/* tcp.c  -- stream interface to TCP					*/

/*
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Library Public License as published
    by the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    See file '../Copyright' for full details.
*/

#include "config.h"

object
make_stream(object host, int fd, enum smmode smm)
{
   object stream;
   char *mode;			/* file open mode */
   FILE *fp;			/* file pointer */

   switch(smm) {
    case smm_input:
      mode = "r";
      break;
    case smm_output:
      mode = "w";
      break;
    default:
      FEerror("make_stream: wrong mode", 0);
   }
   fp = fdopen(fd,mode);

   stream = alloc_object(t_stream);
   stream->sm.sm_mode = (short)smm;
   stream->sm.sm_fp = fp;
   fp->_BASE = BASEFF; 
   stream->sm.sm_object0 = Sstring_char;
   stream->sm.sm_object1 = host; /* not really used */
   stream->sm.sm_int0 = stream->sm.sm_int1 = 0;
   setbuf(fp, alloc_contblock(BUFSIZ)); 
   return(stream);
}

/* 
   Lopen_client_stream --

   To test this function, try:
   (setq s (si:open-client-stream "host" 13))
   (read-line s)
   "Wed Jun 22 19:44:36 METDST 1994"
*/
Lopen_client_stream(int narg, object host, object port)
{
   int fd;			/* file descriptor */
   object streamIn, streamOut;

   check_arg(2);
   if (type_of(host) != t_string)
     FEwrong_type_argument(Sstring, host);

   if (!FIXNUMP(port))
     FEwrong_type_argument(TSpositive_number, port);

   if (host->st.st_fillp > BUFSIZ - 1)
     too_long_file_name(host);

#ifdef THREADS
   start_critical_section();
#endif THREADS
   fd = connect_to_server(host->st.st_self, fix(port)); 
#ifdef THREADS
   end_critical_section();
#endif THREADS

   if (fd == 0) {
     VALUES(0) = Cnil;
     RETURN(1);}

   streamIn = make_stream(host, fd, smm_input);
   streamOut = make_stream(host, fd, smm_output);

   VALUES(0) = make_two_way_stream(streamIn, streamOut);
   RETURN(1);
}

object
Lopen_server_stream(int narg, object port)
{  int fd;			/* file descriptor */
   object streamIn, streamOut;

   check_arg(1);
   if (!FIXNUMP(port))
     FEwrong_type_argument(TSpositive_number, port);

#ifdef MTCL
   start_critical_section();
#endif MTCL
   fd = create_server_port(fix(port));
#ifdef MTCL
   end_critical_section();
#endif MTCL

   if (fd == 0)
     VALUES(0) = Cnil;
   else {
     streamIn = make_stream(Cnil, fd, smm_input);
     streamOut = make_stream(Cnil, fd, smm_output);
     VALUES(0) = make_two_way_stream(streamIn, streamOut);
   }
   RETURN(1);
}

init_tcp()
{
  make_si_function("OPEN-CLIENT-STREAM", Lopen_client_stream);
  make_si_function("OPEN-SERVER-STREAM", Lopen_server_stream);
}
