/*
    print.d -- Print.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/******************************* EXPORTS ******************************/

object Kupcase;
object Kdowncase;
object Kcapitalize;

object Kstream;
object Kescape;
object Kpretty;
object Kcircle;
object Kbase;
object Kradix;
object Kcase;
object Kgensym;
object Klevel;
object Klength;
object Karray;

object Vprint_escape;
object Vprint_pretty;
object Vprint_circle;
object Vprint_base;
object Vprint_radix;
object Vprint_case;
object Vprint_gensym;
object Vprint_level;
object Vprint_length;
object Vprint_array;

object siVprint_package;
object siVprint_structure;

#ifndef MTCL
bool PRINTescape;
bool PRINTpretty;
bool PRINTcircle;
int PRINTbase;
bool PRINTradix;
object PRINTcase;
bool PRINTgensym;
int PRINTlevel;
int PRINTlength;
bool PRINTarray;
int (*write_ch_fun)();		/* virtual output (for pretty-print) */
int (*output_ch_fun)();		/* physical output */
#endif MTCL

/******************************* ------- ******************************/

#define	LINE_LENGTH	72

#define	to_be_escaped(c) \
	(standard_readtable->rt.rt_self[(c)&0377].rte_chattrib \
	 != cat_constituent || \
	 isLower((c)&0377) || (c) == ':')


bool PRINTpackage;
bool PRINTstructure;

#ifdef CLOS
object Sstream_write_char,
  Sstream_write_string,
  Sstream_fresh_line,
  Sstream_clear_output,
  Sstream_force_output;
#endif CLOS

#define	write_ch	(*write_ch_fun)
#define	output_ch	(*output_ch_fun)

object siSpretty_print_format;
object siSsharp_exclamation;

#define	MARK		0400
#define	UNMARK		0401
#define	SET_INDENT	0402
#define	INDENT		0403
#define	INDENT1		0404
#define	INDENT2		0405

#define	mod(x)		((x)%Q_SIZE)

#ifdef MTCL

#define queue             clwp->lwp_queue
#define indent_stack      clwp->lwp_indent_stack
#define qh         clwp->lwp_qh
#define qt         clwp->lwp_qt
#define qc         clwp->lwp_qc
#define isp        clwp->lwp_isp
#define iisp       clwp->lwp_iisp

#define CIRCLEjmp clwp->lwp_CIRCLEjmp
#define CIRCLEbase clwp->lwp_CIRCLEbase
#define CIRCLEtop clwp->lwp_CIRCLEtop
#define CIRCLElimit clwp->lwp_CIRCLElimit

#else
static short queue[Q_SIZE];
static short indent_stack[IS_SIZE];

static int qh;
static int qt;
static int qc;
static int isp;
static int iisp;

jmp_buf CIRCLEjmp;
object *CIRCLEbase;
object *CIRCLEtop;
object *CIRCLElimit;
object PRINTstream;

#endif MTCL

#ifdef CLOS
interactive_writec_stream(int c, object stream)
{
	return(funcall(3, Sstream_write_char, stream, code_char(c)));
}

flush_interactive_stream(object stream)
{
	return(funcall(2, Sstream_force_output, stream));
}

#define FLUSH_STREAM(strm) \
  if (type_of(strm) == t_stream) flush_stream(strm); \
  else flush_interactive_stream(strm)
#define FILE_COLUMN(strm) \
  ((type_of(strm) == t_instance) ? -1 : file_column(strm))
#else
#define FLUSH_STREAM(strm)	flush_stream(strm)
#define FILE_COLUMN(strm) 	file_column(strm)
#endif CLOS

writec_queue(int c)
{
	if (qc >= Q_SIZE)
		flush_queue(FALSE);
	if (qc >= Q_SIZE)
		FEerror("Can't pretty-print.", 0);
	queue[qt] = c;
	qt = mod(qt+1);
	qc++;
}

flush_queue(bool force)
{
	int c, i, j, k, l, i0;

BEGIN:
	while (qc > 0) {
		c = queue[qh];
		if (c == MARK)
			goto DO_MARK;
		else if (c == UNMARK)
			isp -= 2;
		else if (c == SET_INDENT)
			indent_stack[isp] = FILE_COLUMN(PRINTstream);
		else if (c == INDENT) {
			goto DO_INDENT;
		} else if (c == INDENT1) {
			i = FILE_COLUMN(PRINTstream)-indent_stack[isp];
			if (i < 8 && indent_stack[isp] < LINE_LENGTH/2) {
				output_ch(' ');
				indent_stack[isp]
				= FILE_COLUMN(PRINTstream);
			} else {
				if (indent_stack[isp] < LINE_LENGTH/2) {
					indent_stack[isp]
					= indent_stack[isp-1] + 4;
				}
				goto DO_INDENT;
			}
		} else if (c == INDENT2) {
			indent_stack[isp] = indent_stack[isp-1] + 2;
			goto PUT_INDENT;
		} else if (c < 0400)
			output_ch(c);
		qh = mod(qh+1);
		--qc;
	}
	return;

DO_MARK:
	k = LINE_LENGTH - 1 - FILE_COLUMN(PRINTstream);
	for (i = 1, j = 0, l = 1;  l > 0 && i < qc && j < k;  i++) {
		c = queue[mod(qh + i)];
		if (c == MARK)
			l++;
		else if (c == UNMARK)
			--l;
		else if (c == INDENT || c == INDENT1 || c == INDENT2)
			j++;
		else if (c < 0400)
			j++;
	}
	if (l == 0)
		goto FLUSH;
	if (i == qc && !force)
		return;
	qh = mod(qh+1);
	--qc;
	if (++isp >= IS_SIZE-1)
		FEerror("Can't pretty-print.", 0);
	indent_stack[isp++] = FILE_COLUMN(PRINTstream);
	indent_stack[isp] = indent_stack[isp-1];
	goto BEGIN;

DO_INDENT:
	if (iisp > isp)
		goto PUT_INDENT;
	k = LINE_LENGTH - 1 - FILE_COLUMN(PRINTstream);
	for (i0 = 0, i = 1, j = 0, l = 1;  i < qc && j < k;  i++) {
		c = queue[mod(qh + i)];
		if (c == MARK)
			l++;
		else if (c == UNMARK) {
			if (--l == 0)
				goto FLUSH;
		} else if (c == SET_INDENT) {
			if (l == 1)
				break;
		} else if (c == INDENT) {
			if (l == 1)
				i0 = i;
			j++;
		} else if (c == INDENT1) {
			if (l == 1)
				break;
			j++;
		} else if (c == INDENT2) {
			if (l == 1) {
				i0 = i;
				break;
			}
			j++;
		} else if (c < 0400)
			j++;
	}
	if (i == qc && !force)
		return;
	if (i0 == 0)
		goto PUT_INDENT;
	i = i0;
	goto FLUSH;

PUT_INDENT:
	qh = mod(qh+1);
	--qc;
	output_ch('\n');
	for (i = indent_stack[isp];  i > 0;  --i)
		output_ch(' ');
	iisp = isp;
	goto BEGIN;

FLUSH:
	for (j = 0;  j < i;  j++) {
		c = queue[qh];
		if (c == INDENT || c == INDENT1 || c == INDENT2)
			output_ch(' ');
		else if (c < 0400)
			output_ch(c);
		qh = mod(qh+1);
		--qc;
	}
	goto BEGIN;
}

writec_PRINTstream(int c)
{
	if (c == INDENT || c == INDENT1)
		writec_stream(' ', PRINTstream);
	else if (c < 0400)
		writec_stream(c, PRINTstream);
}

#ifdef CLOS
interactive_writec_PRINTstream(int c)
{
	if (c == INDENT || c == INDENT1)
		interactive_writec_stream(' ', PRINTstream);
	else if (c < 0400)
		interactive_writec_stream(c, PRINTstream);
}
#endif CLOS

write_str(char *s)
{
	while (*s != '\0')
		write_ch(*s++);
}

write_decimal(int i)
{
	if (i == 0) {
		write_ch('0');
		return;
	}
	write_decimal1(i);
}

write_decimal1(int i)
{
	if (i == 0)
		return;
	write_decimal1(i/10);
	write_ch(i%10 + '0');
}

write_addr(object x)
{
	int i, j, k;

	i = (int)x;
	for (j = 28;  j >= 0;  j -= 4) {
		k = (i>>j) & 0xf;
		if (k < 10)
			write_ch('0' + k);
		else
			write_ch('a' + k - 10);
	}
}

write_base()
{
	if (PRINTbase == 2)
		write_str("#b");
	else if (PRINTbase == 8)
		write_str("#o");
	else if (PRINTbase == 16)
		write_str("#x");
	else if (PRINTbase >= 10) {
		write_ch('#');
		write_ch(PRINTbase/10+'0');
		write_ch(PRINTbase%10+'0');
		write_ch('r');
	} else {
		write_ch('#');
		write_ch(PRINTbase+'0');
		write_ch('r');
	}
}

/* The floating point precision is required to make the
   most-positive-long-float printed expression readable.
   If this is too small, then the rounded off fraction, may be too big
   to read */

#ifndef FPRC 
#define FPRC 16
#endif

void edit_double(int n, double d, int *sp, char *s, int *ep)
{
	char *p, buff[FPRC + 9];
	int i;

#ifdef IEEEFLOAT
	if ((*((int *)&d +HIND) & 0x7ff00000) == 0x7ff00000)
		FEerror("Can't print a non-number.", 0);
	else
		sprintf(buff, "%*.*e",FPRC+8,FPRC, d);
	if (buff[FPRC+3] != 'e') {
		sprintf(buff, "%*.*e",FPRC+7,FPRC,d);
		*ep = (buff[FPRC+5]-'0')*10 + (buff[FPRC+6]-'0');
	} else
		*ep = (buff[FPRC+5]-'0')*100 +
		  (buff[FPRC+6]-'0')*10 + (buff[FPRC+7]-'0');
	*sp = 1;
	if (buff[0] == '-')
		*sp *= -1;
#else
	sprintf(buff, "%*.*e",FPRC+7,FPRC, d);
	/*  "-D.MMMMMMMMMMMMMMMe+EE"  */
	/*   0123456789012345678901   */
	*sp = 1;
	if (buff[0] == '-')
		*sp *= -1;
	*ep = (buff[FPRC+5]-'0')*10 + (buff[FPRC+6]-'0');
#endif IEEEFLOAT

	if (buff[FPRC+4] == '-')
		*ep *= -1;
	buff[2] = buff[1];
	p = buff + 2;
	if (n < FPRC+1) {
		if (p[n] >= '5') {
			for (i = n - 1;  i >= 0;  --i)
				if (p[i] == '9')
					p[i] = '0';
				else {
					p[i]++;
					break;
				}
			if (i < 0) {
				*--p = '1';
				(*ep)++;
			}
		}
		for (i = 0;  i < n;  i++)
			s[i] = p[i];
	} else {
		for (i = 0;  i < FPRC+1;  i++)
			s[i] = p[i];
		for (;  i < n;  i++)
			s[i] = '0';
	}
	s[n] = '\0';
}


write_double(double d, int e, bool shortp)
{
	int sign;
	char buff[FPRC+5];
	int exp;
	int i;
	int n = FPRC;		/* was FPRC+1 */

	if (shortp)
		n = 7;
	edit_double(n, d, &sign, buff, &exp);
	if (sign==2) {
		write_str("#<");
		write_str(buff);
		write_ch('>');
		return;
	      }
	if (sign < 0)
		write_ch('-');
	if (-3 <= exp && exp < 7) {
		if (exp < 0) {
			write_ch('0');
			write_ch('.');
			exp = (-exp) - 1;
			for (i = 0;  i < exp;  i++)
				write_ch('0');
			for (;  n > 0;  --n)
				if (buff[n-1] != '0')
					break;
			if (exp == 0 && n == 0)
				n = 1;
			for (i = 0;  i < n;  i++)
				write_ch(buff[i]);
		} else {
			exp++;
			for (i = 0;  i < exp;  i++)
				if (i < n)
					write_ch(buff[i]);
				else
					write_ch('0');
			write_ch('.');
			if (i < n)
				write_ch(buff[i]);
			else
				write_ch('0');
			i++;
			for (;  n > i;  --n)
				if (buff[n-1] != '0')
					break;
			for (;  i < n;  i++)
				write_ch(buff[i]);
		}
		exp = 0;
	} else {
		write_ch(buff[0]);
		write_ch('.');
		write_ch(buff[1]);
		for (;  n > 2;  --n)
			if (buff[n-1] != '0')
				break;
		for (i = 2;  i < n;  i++)
			write_ch(buff[i]);
	}
	if (exp == 0 && e == 0)
		return;
	if (e == 0)
		e = 'E';
	write_ch(e);
	if (exp < 0) {
		write_ch('-');
		exp *= -1;
	}
	write_decimal(exp);
}


#ifndef CLOS
call_structure_print_function(object x, int level)
{
	int i, nr;
	bool eflag;
	bds_ptr old_bds_top;

	int (*wf)() = write_ch_fun;

	bool e = PRINTescape;
	bool r = PRINTradix;
	int b = PRINTbase;
	bool c = PRINTcircle;
	bool p = PRINTpretty;
	int lv = PRINTlevel;
	int ln = PRINTlength;
	bool g = PRINTgensym;
	bool a = PRINTarray;
	object ps = PRINTstream;
	object pc = PRINTcase;

	short ois[IS_SIZE];

	int oqh;
	int oqt;
	int oqc;
	int oisp;
	int oiisp;

	while (interrupt_flag) {
		interrupt_flag = FALSE;
#ifdef unix
		alarm(0);
#endif unix
		terminal_interrupt(TRUE);
	}

	if (PRINTpretty)
		flush_queue(TRUE);

	oqh = qh;
	oqt = qt;
	oqc = qc;
	oisp = isp;
	oiisp = iisp;

	for (i = 0;  i <= isp;  i++)
		ois[i] = indent_stack[i];

	old_bds_top = bds_top;
	bds_bind(Vprint_escape, PRINTescape?Ct:Cnil);
	bds_bind(Vprint_radix, PRINTradix?Ct:Cnil);
	bds_bind(Vprint_base, MAKE_FIXNUM(PRINTbase));
	bds_bind(Vprint_circle, PRINTcircle?Ct:Cnil);
	bds_bind(Vprint_pretty, PRINTpretty?Ct:Cnil);
	bds_bind(Vprint_level, PRINTlevel<0?Cnil:MAKE_FIXNUM(PRINTlevel));
	bds_bind(Vprint_length, PRINTlength<0?Cnil:MAKE_FIXNUM(PRINTlength));
	bds_bind(Vprint_gensym, PRINTgensym?Ct:Cnil);
	bds_bind(Vprint_array, PRINTarray?Ct:Cnil);
	bds_bind(Vprint_case, PRINTcase);
	
	if ((nr = frs_push(FRS_PROTECT, Cnil)) != 0) 
		eflag = TRUE;
	else {
		funcall(4, getf(x->str.str_name->s.s_plist,
		       siSstructure_print_function, Cnil),
			  x, PRINTstream, MAKE_FIXNUM(level));
		eflag = FALSE;
	}

	frs_pop();
	bds_unwind(old_bds_top);

	for (i = 0;  i <= oisp;  i++)
		indent_stack[i] = ois[i];

	iisp = oiisp;
	isp = oisp;
	qc = oqc;
	qt = oqt;
	qh = oqh;

	PRINTcase = pc;
	PRINTstream = ps;
	PRINTarray = a;
	PRINTgensym = g;
	PRINTlength = ln;
	PRINTlevel = lv;
	PRINTpretty = p;
	PRINTcircle = c;
	PRINTbase = b;
	PRINTradix = r;
	PRINTescape = e;

	write_ch_fun = wf;

	if (eflag) unwind(nlj_fr, nlj_tag, nr);
}

#else
call_print_object(object x, int level)
{
	int i, nr;
	bool eflag;
	bds_ptr old_bds_top;

	int (*wf)() = write_ch_fun;

	bool e = PRINTescape;
	bool r = PRINTradix;
	int b = PRINTbase;
	bool c = PRINTcircle;
	bool p = PRINTpretty;
	int lv = PRINTlevel;
	int ln = PRINTlength;
	bool g = PRINTgensym;
	bool a = PRINTarray;
	object ps = PRINTstream;
	object pc = PRINTcase;

	short ois[IS_SIZE];

	int oqh;
	int oqt;
	int oqc;
	int oisp;
	int oiisp;

	while (interrupt_flag) {
		interrupt_flag = FALSE;
#ifdef unix
		alarm(0);
#endif
		terminal_interrupt(TRUE);
	}

	if (PRINTpretty)
		flush_queue(TRUE);

	oqh = qh;
	oqt = qt;
	oqc = qc;
	oisp = isp;
	oiisp = iisp;

	for (i = 0;  i <= isp;  i++)
		ois[i] = indent_stack[i];

	old_bds_top = bds_top;
	bds_bind(Vprint_escape, PRINTescape?Ct:Cnil);
	bds_bind(Vprint_radix, PRINTradix?Ct:Cnil);
	bds_bind(Vprint_base, MAKE_FIXNUM(PRINTbase));
	bds_bind(Vprint_circle, PRINTcircle?Ct:Cnil);
	bds_bind(Vprint_pretty, PRINTpretty?Ct:Cnil);
	bds_bind(Vprint_level, PRINTlevel<0?Cnil:MAKE_FIXNUM(PRINTlevel));
	bds_bind(Vprint_length, PRINTlength<0?Cnil:MAKE_FIXNUM(PRINTlength));
	bds_bind(Vprint_gensym, PRINTgensym?Ct:Cnil);
	bds_bind(Vprint_array, PRINTarray?Ct:Cnil);
	bds_bind(Vprint_case, PRINTcase);

	
	if ((nr = frs_push(FRS_PROTECT, Cnil)) != 0)
		eflag = TRUE;
	else {
		funcall(3, Sprint_object, x, PRINTstream);
		eflag = FALSE;
	}

	frs_pop();
	bds_unwind(old_bds_top);

	for (i = 0;  i <= oisp;  i++)
		indent_stack[i] = ois[i];

	iisp = oiisp;
	isp = oisp;
	qc = oqc;
	qt = oqt;
	qh = oqh;

	PRINTcase = pc;
	PRINTstream = ps;
	PRINTarray = a;
	PRINTgensym = g;
	PRINTlength = ln;
	PRINTlevel = lv;
	PRINTpretty = p;
	PRINTcircle = c;
	PRINTbase = b;
	PRINTradix = r;
	PRINTescape = e;

	write_ch_fun = wf;

	if (eflag) unwind(nlj_fr, nlj_tag, nr);
}
#endif CLOS

write_fixnum(int i)
{ object digits[16];
  int j;
  for ( j = 0;  j < 16 && i != 0;  i /= PRINTbase)
    digits[j++] = code_char(digit_weight(i%PRINTbase, PRINTbase));
  if (j == 16) write_fixnum(i);
  while (j-- > 0)
    write_ch(char_code(digits[j]));
}

write_bignum(object b)
{ object digits[16];
  int j;
  for ( j = 0;  j < 16 && !big_zerop(b); )
    digits[j++] = code_char(digit_weight(div_int_big(PRINTbase, b),
					PRINTbase));
  if (j == 16) write_bignum(b);
  while (j-- > 0)
    write_ch(char_code(digits[j]));
}

void write_object(object x, int level)
{
	object r, y;
	int i, j, k;
	object *vp;

	cs_check(x);

	if (x == OBJNULL) {
		write_str("#<OBJNULL>");
		return;
	}

	switch (type_of(x)) {

	case FREE:
		write_str("#<FREE OBJECT ");
		write_addr(x);
		write_ch('>');
		return;

	case t_fixnum:
	{
		if (PRINTradix && PRINTbase != 10)
			write_base();
		i = fix(x);
		if (i == 0) {
			write_ch('0');
			if (PRINTradix && PRINTbase == 10)
				write_ch('.');
			break;
		}
		if (i < 0) {
			write_ch('-');
			i = -i;
		}
		write_fixnum(i);
		if (PRINTradix && PRINTbase == 10)
			write_ch('.');
		break;
	}

	case t_bignum:
	{
		struct bignum *b;

		if (PRINTradix && PRINTbase != 10)
			write_base();
		i = big_sign((struct bignum *)x);
		if (i == 0) {
			write_ch('0');
			if (PRINTradix && PRINTbase == 10)
				write_ch('.');
			break;
		}
		if (i < 0) {
			write_ch('-');
			b = big_minus((struct bignum *)x);
		} else
			b = copy_big((struct bignum *)x);
		write_bignum((object)b);
		if (PRINTradix && PRINTbase == 10)
			write_ch('.');
		break;
	}

	case t_ratio:
		if (PRINTradix) {
			write_base();
			PRINTradix = FALSE;
			write_object(x->rat.rat_num, level);
			write_ch('/');
			write_object(x->rat.rat_den, level);
			PRINTradix = TRUE;
		} else {
			write_object(x->rat.rat_num, level);
			write_ch('/');
			write_object(x->rat.rat_den, level);
		}
		break;

	case t_shortfloat:
		r = symbol_value(Vread_default_float_format);
		if (r == Ssingle_float || r == Sshort_float)
			write_double((double)sf(x), 0, TRUE);
		else
			write_double((double)sf(x), 'f', TRUE);
		break;

	case t_longfloat:
		r = symbol_value(Vread_default_float_format);
		if (r == Slong_float || r == Sdouble_float)
			write_double(lf(x), 0, FALSE);
		else
			write_double(lf(x), 'd', FALSE);
		break;

	case t_complex:
		write_str("#C(");
		write_object(x->cmp.cmp_real, level);
		write_ch(' ');
		write_object(x->cmp.cmp_imag, level);
		write_ch(')');
		break;

	case t_character:
		if (!PRINTescape) {
			write_ch(char_code(x));
			break;
		}
		write_str("#\\");
		if (char_bits(x) != 0) {
			if (char_bits(x) & CONTROL_BIT)
				write_str("C-");
			if (char_bits(x) & META_BIT)
				write_str("M-");
			if (char_bits(x) & SUPER_BIT)
				write_str("Super-");
			if (char_bits(x) & HYPER_BIT)
				write_str("Hyper-");
			}
			
		switch (char_code(x)) {
		case '\r':
			write_str("Return");
			break;

		case ' ':
			write_str("Space");
			break;

		case '\177':
			write_str("Rubout");
			break;

		case '\f':
			write_str("Page");
			break;

		case '\t':
			write_str("Tab");
			break;

		case '\b':
			write_str("Backspace");
			break;

		case '\n':
			write_str("Newline");
			break;

		default:
			if (char_code(x) & 0200) {
				write_ch('\\');
				i = char_code(x);
				write_ch(((i>>6)&7) + '0');
				write_ch(((i>>3)&7) + '0');
				write_ch(((i>>0)&7) + '0');
			} else if (char_code(x) < 040) {
				write_ch('^');
				write_ch(char_code(x) + 0100);
			} else
				write_ch(char_code(x));
			break;
		}
		break;

	case t_symbol:
		if (!PRINTescape) {
			for (i = 0;  i < x->s.s_fillp;  i++) {
				j = x->s.s_self[i];
				if (isUpper(j) &&
				    (PRINTcase == Kdowncase ||
				     PRINTcase == Kcapitalize && i!=0))
					j += 'a' - 'A';
				write_ch(j);
			}
			break;
		}
		if (Null(x->s.s_hpack)) {
		    if (PRINTcircle) {
			for (vp = CIRCLEbase;  vp < CIRCLEtop;  vp += 2)
			    if (x == *vp) {
				write_ch('#');
				write_decimal((vp-CIRCLEbase)/2);
				if (vp[1] != Cnil) {
				    write_ch('#');
				    return;
				} else {
				    write_ch('=');
				    vp[1] = Ct;
				}
			    }
		    }
		    if (PRINTgensym)
			write_str("#:");
		} else if (x->s.s_hpack == keyword_package)
			write_ch(':');
		else if (PRINTpackage
			 || find_symbol(x->st.st_self, x->s.s_fillp, current_package())!=x
                         || intern_flag == 0) {
			k = 0;
			for (i = 0;
			     i < x->s.s_hpack->p.p_name->st.st_fillp;
			     i++) {
				j = x->s.s_hpack->p.p_name
				    ->st.st_self[i];
				if (to_be_escaped(j))
					k = 1;
			}
			if (k)
				write_ch('|');
			for (i = 0;
			     i < x->s.s_hpack->p.p_name->st.st_fillp;
			     i++) {
				j = x->s.s_hpack->p.p_name
				    ->st.st_self[i];
 				if (j == '|' || j == '\\')
					write_ch('\\');
				if (k == 0 && isUpper(j) &&
				    (PRINTcase == Kdowncase ||
				     PRINTcase == Kcapitalize && i!=0))
					j += 'a' - 'A';
				write_ch(j);
			}
			if (k)
				write_ch('|');
			if (find_symbol(x->st.st_self, x->s.s_fillp, x->s.s_hpack) != x)
				error("can't print symbol");
			if (PRINTpackage || intern_flag == INTERNAL)
				write_str("::");
			else if (intern_flag == EXTERNAL)
				write_ch(':');
			else
			FEerror("Pathological symbol --- cannot print.", 0);
		}
		k = 0;
		if (potential_number_p(x, PRINTbase))
			k = 1;
		for (i = 0;  i < x->s.s_fillp;  i++) {
			j = x->s.s_self[i];
			if (to_be_escaped(j))
				k = 1;
		}
		for (i = 0;  i < x->s.s_fillp;  i++)
			if (x->s.s_self[i] != '.')
				goto NOT_DOT;
		k = 1;

	NOT_DOT:			
		if (k)
			write_ch('|');
		for (i = 0;  i < x->s.s_fillp;  i++) {
			j = x->s.s_self[i];
 			if (j == '|' || j == '\\')
				write_ch('\\');
			if (k == 0 && isUpper(j) &&
			    (PRINTcase == Kdowncase ||
			     PRINTcase == Kcapitalize && i != 0))
				j += 'a' - 'A';
			write_ch(j);
		}
		if (k)
			write_ch('|');
		break;

	case t_array:
	{
		int subscripts[ARANKLIM];
		int n, m;

		if (!PRINTarray) {
			write_str("#<array ");
			write_addr(x);
			write_ch('>');
			break;
		}
		if (PRINTcircle) {
			for (vp = CIRCLEbase;  vp < CIRCLEtop;  vp += 2)
			    if (x == *vp) {
				write_ch('#');
				write_decimal((vp-CIRCLEbase)/2);
				if (vp[1] != Cnil) {
				    write_ch('#');
				    return;
				} else {
				    write_ch('=');
				    vp[1] = Ct;
				    break;
				}
			    }
		}
		if (PRINTlevel >= 0 && level >= PRINTlevel) {
			write_ch('#');
			break;
		}
		n = x->a.a_rank;
		write_ch('#');
		write_decimal(n);
		write_ch('A');
		if (PRINTlevel >= 0 && level+n >= PRINTlevel)
			n = PRINTlevel - level;
		for (i = 0;  i < n;  i++)
			subscripts[i] = 0;
		m = 0;
		j = 0;
		for (;;) {
			for (i = j;  i < n;  i++) {
				if (subscripts[i] == 0) {
					write_ch(MARK);
					write_ch('(');
					write_ch(SET_INDENT);
					if (x->a.a_dims[i] == 0) {
						write_ch(')');
						write_ch(UNMARK);
						j = i-1;
						k = 0;
						goto INC;
					}
				}
				if (subscripts[i] > 0)
					write_ch(INDENT);
				if (PRINTlength >= 0 &&
				    subscripts[i] >= PRINTlength) {
					write_str("...)");
					write_ch(UNMARK);
					k=x->a.a_dims[i]-subscripts[i];
					subscripts[i] = 0;
					for (j = i+1;  j < n;  j++)
						k *= x->a.a_dims[j];
					j = i-1;
					goto INC;
				}
			}
			if (n == x->a.a_rank)
				write_object(aref(x, m), level+n);
			else
				write_ch('#');
			j = n-1;
			k = 1;

		INC:
			while (j >= 0) {
				if (++subscripts[j] < x->a.a_dims[j])
					break;
				subscripts[j] = 0;
				write_ch(')');
				write_ch(UNMARK);
				--j;
			}
			if (j < 0)
				break;
			m += k;
		}
		break;
	}

	case t_vector:
		if (!PRINTarray) {
			write_str("#<vector ");
			write_decimal(x->v.v_dim);
			write_ch(' ');
			write_addr(x);
			write_ch('>');
			break;
		}
		if (PRINTcircle) {
			for (vp = CIRCLEbase;  vp < CIRCLEtop;  vp += 2)
			    if (x == *vp) {
				write_ch('#');
				write_decimal((vp-CIRCLEbase)/2);
				if (vp[1] != Cnil) {
				    write_ch('#');
				    return;
				} else {
				    write_ch('=');
				    vp[1] = Ct;
				    break;
				}
			    }
		}
		if (PRINTlevel >= 0 && level >= PRINTlevel) {
			write_ch('#');
			break;
		}
		write_ch('#');
		write_ch(MARK);
		write_ch('(');
		write_ch(SET_INDENT);
		if (x->v.v_fillp > 0) {
			if (PRINTlength == 0) {
				write_str("...)");
				write_ch(UNMARK);
				break;
			}
			write_object(aref(x, 0), level+1);
			for (i = 1;  i < x->v.v_fillp;  i++) {
				write_ch(INDENT);
				if (PRINTlength>=0 && i>=PRINTlength){
					write_str("...");
					break;
				}
				write_object(aref(x, i), level+1);
			}
		}
		write_ch(')');
		write_ch(UNMARK);
		break;

	case t_string:
		if (!PRINTescape) {
			for (i = 0;  i < x->st.st_fillp;  i++)
				write_ch(x->st.st_self[i]);
			break;
		}
		write_ch('"');
		for (i = 0;  i < x->st.st_fillp;  i++) {
			if (x->st.st_self[i] == '"' ||
			    x->st.st_self[i] == '\\')
				write_ch('\\');
			write_ch(x->st.st_self[i]);
		}
		write_ch('"');
		break;

	case t_bitvector:
		if (!PRINTarray) {
			write_str("#<bit-vector ");
			write_addr(x);
			write_ch('>');
			break;
		}
		write_str("#*");
		for (i = 0;  i < x->bv.bv_fillp;  i++)
			if (x->bv.bv_self[i/8] & (0200 >> i%8))
				write_ch('1');
			else
				write_ch('0');
		break;

	case t_cons:
		if (CAR(x) == siSsharp_comma) {
			write_str("#.");
			write_object(CDR(x), level);
			break;
		}
		if (CAR(x) == siSsharp_exclamation) {
			write_str("#!");
			write_object(CDR(x), level);
			break;
		}
		if (PRINTcircle) {
			for (vp = CIRCLEbase;  vp < CIRCLEtop;  vp += 2)
			    if (x == *vp) {
			        write_ch('#');
				write_decimal((vp-CIRCLEbase)/2);
				if (vp[1] != Cnil) {
				    write_ch('#');
				    return;
				} else {
				    write_ch('=');
				    vp[1] = Ct;
				    break;
				}
			    }
		}
		if (CAR(x) == Squote &&
		    type_of(CDR(x)) == t_cons &&
		    Null(CDDR(x))) {
			write_ch('\'');
			write_object(CADR(x), level);
			break;
		}
		if (CAR(x) == Sfunction &&
		    type_of(CDR(x)) == t_cons &&
		    Null(CDDR(x))) {
			write_ch('#');
			write_ch('\'');
			write_object(CADR(x), level);
			break;
		}
		if (PRINTlevel >= 0 && level >= PRINTlevel) {
			write_ch('#');
			break;
		}
		write_ch(MARK);
		write_ch('(');
		write_ch(SET_INDENT);
		if (PRINTpretty && CAR(x) != OBJNULL &&
		    type_of(CAR(x)) == t_symbol &&
		    (r = getf(CAR(x)->s.s_plist,
		              siSpretty_print_format, Cnil)) != Cnil)
			goto PRETTY_PRINT_FORMAT;
		for (i = 0;  ;  i++) {
			if (PRINTlength >= 0 && i >= PRINTlength) {
				write_str("...");
				break;
			}
			y = CAR(x);
			x = CDR(x);
			write_object(y, level+1);
			if (type_of(x) != t_cons) {
				if (x != Cnil) {
					write_ch(INDENT);
					write_str(". ");
					write_object(x, level);
				}
				break;
			}
			if (PRINTcircle) {
			  for (vp = CIRCLEbase; vp < CIRCLEtop; vp += 2)
			    if (x == *vp) {
				if (vp[1] != Cnil) {
				    write_str(" . #");
				    write_decimal((vp-CIRCLEbase)/2);
				    write_ch('#');
				    goto RIGHT_PAREN;
				} else {
				    write_ch(INDENT);
				    write_str(". ");
				    write_object(x, level);
				    goto RIGHT_PAREN;
				}
			    }
			}
			if (i == 0 && y != OBJNULL && type_of(y) == t_symbol)
				write_ch(INDENT1);
			else
				write_ch(INDENT);
		}

	RIGHT_PAREN:
		write_ch(')');
		write_ch(UNMARK);
		break;

	PRETTY_PRINT_FORMAT:
		j = fixint(r);
		for (i = 0;  ;  i++) {
			if (PRINTlength >= 0 && i >= PRINTlength) {
				write_str("...");
				break;
			}
			y = CAR(x);
			x = CDR(x);
			if (i <= j && Null(y))
				write_str("()");
			else
				write_object(y, level+1);
			if (type_of(x) != t_cons) {
				if (x != Cnil) {
					write_ch(INDENT);
					write_str(". ");
					write_object(x, level);
				}
				break;
			}
			if (i >= j)
				write_ch(INDENT2);
			else if (i == 0)
				write_ch(INDENT1);
			else
				write_ch(INDENT);
		}
		goto RIGHT_PAREN;

	case t_package:
		write_str("#<");
		write_object(x->p.p_name, level);
 		write_str(" package>");
		break;

	case t_hashtable:
		write_str("#<hash-table ");
		write_addr(x);
		write_ch('>');
		break;

	case t_stream:
		switch ((enum smmode)x->sm.sm_mode) {
		case smm_input:
			write_str("#<input stream ");
			write_object(x->sm.sm_object1, level);
			break;

		case smm_output:
			write_str("#<output stream ");
			write_object(x->sm.sm_object1, level);
			break;

		case smm_io:
			write_str("#<io stream ");
			write_object(x->sm.sm_object1, level);
			break;

		case smm_probe:
			write_str("#<probe stream ");
			write_object(x->sm.sm_object1, level);
			break;

		case smm_synonym:
			write_str("#<synonym stream to ");
			write_object(x->sm.sm_object0, level);
			break;

		case smm_broadcast:
			write_str("#<broadcast stream ");
			write_addr(x);
			break;

		case smm_concatenated:
			write_str("#<concatenated stream ");
			write_addr(x);
			break;

		case smm_two_way:
			write_str("#<two-way stream ");
			write_addr(x);
			break;

		case smm_echo:
			write_str("#<echo stream ");
			write_addr(x);
			break;

		case smm_string_input:
			write_str("#<string-input stream from \"");
			y = x->sm.sm_object0;
			j = y->st.st_fillp;
			for (i = 0;  i < j && i < 16;  i++)
				write_ch(y->st.st_self[i]);
			if (j > 16)
				write_str("...");
			write_ch('"');
			break;

		case smm_string_output:
			write_str("#<string-output stream ");
			write_addr(x);
			break;

		default:
			error("illegal stream mode");
		}
		write_ch('>');
		break;

	case t_random:
		write_str("#$");
		write_object(MAKE_FIXNUM(x->rnd.rnd_value), level);
		break;

#ifndef CLOS
	case t_structure:
		if (PRINTcircle) {
			for (vp = CIRCLEbase;  vp < CIRCLEtop;  vp += 2)
			    if (x == *vp) {
				write_ch('#');
				write_decimal((vp-CIRCLEbase)/2);
				if (vp[1] != Cnil) {
				    write_ch('#');
				    return;
				} else {
				    write_ch('=');
				    vp[1] = Ct;
				    break;
				}
			    }
		}
		if (PRINTlevel >= 0 && level >= PRINTlevel) {
			write_ch('#');
			break;
		}
		if (type_of(x->str.str_name) != t_symbol)
			FEwrong_type_argument(Ssymbol, x->str.str_name);
		if (PRINTstructure ||
		    Null(getf(x->str.str_name->s.s_plist,
			      siSstructure_print_function, Cnil))) {
			write_str("#S");
/* structure_to_list conses slot names and values into a list to be printed.
 * print shouldn't allocate memory - Beppe
 */
			x = structure_to_list(x);
			write_object(x, level);
		} else
			call_structure_print_function(x, level);
		break;
#endif CLOS

	case t_readtable:
		write_str("#<readtable ");
		write_addr(x);
		write_ch('>');
		break;

	case t_pathname:
		if (PRINTescape) {
			write_ch('#');
			write_object(namestring(x), level);
		} else {
			write_str("#<pathname ");
			write_addr(x);
			write_ch('>');
		}
		break;

	case t_cfun:
		write_str("#<compiled-function ");
		if (x->cf.cf_name != Cnil)
			write_object(x->cf.cf_name, level);
		else
			write_addr(x);
		write_ch('>');
		break;

	case t_cclosure:
		write_str("#<compiled-closure ");
		write_addr(x);
		write_ch('>');
		break;
/*
	case t_spice:
		write_str("#<\100"); /* at-sign is the escape for dpp *//*
		for (i = 28;  i >= 0;  i -= 4) {
			j = ((int)x >> i) & 0xf;
			if (j < 10)
				write_ch('0' + j);
			else
				write_ch('A' + (j - 10));
		}
		write_ch('>');
		break;
*/
#ifdef MTCL
      	case t_cont:
		write_str("#<cont ");
		write_object(x->cn.cn_thread, level);
		write_ch('>');
		break;

	case t_thread:
		write_str("#<thread ");
		write_object(x->th.th_fun, level);
		write_ch(' ');
		write_addr(x);
		write_ch('>');
		break;
#endif MTCL
#ifdef CLOS
	case t_instance:
		if (type_of(x->in.in_class) != t_instance)
			FEwrong_type_argument(Sinstance, x->in.in_class);
		call_print_object(x, level);
		break;

	case t_gfun:
		write_str("#<dispatch-function ");
		if (x->gf.gf_name != Cnil)
			write_object(x->gf.gf_name, level);
		else
			write_addr(x);
		write_ch('>');
		break;
#endif CLOS

#ifdef LOCATIVE
	case t_locative:
		if (UNBOUNDP(x)) {
		  /* The next location should contain the
		     logical variable name */
		  if (type_of(*(object *)(((unsigned int)(x) >> 2)
					  + sizeof(object))) == t_symbol)
		    write_object(*(object *)(((unsigned int)(x) >> 2)
					     + sizeof(object)), level);
		  else {
		    write_str("#<locative ");
		    write_addr(x);
		    write_ch('>');
		  }
		}
		else
		  write_object(DEREF(x), level);
		break;
#endif LOCATIVE
	
	default:
		error("illegal type --- cannot print");
	}
}

#define PRINTcircleSIZE	4000

/* To print circular structures, we traverse the structure by adding
   a pair <element, flag> to the array CIRCLEbase for each element visited.
   flag is initially NIL and becomes T if the element is visited again.
   After the visit we squeeze out all the non circular elements.
   The flags is used during printing to distinguish between the first visit
   to the element.
 */

/* Allocates space for travel_push: if not enough, get back with
  longjmp and increase it */

#ifdef DOWN_STACK

#ifdef i386
#define SIZEincrement PRINTcircleSIZE
#else
#define SIZEincrement size
#endif i386

#define setupPRINTcircle(x) \
	if (PRINTcircle) { volatile int size = PRINTcircleSIZE; \
	  if (_setjmp(CIRCLEjmp) != 0) \
	    size += PRINTcircleSIZE; \
	  CIRCLEbase = alloca(SIZEincrement * sizeof(object)); \
	  CIRCLElimit = &CIRCLEbase[size]; \
	  setupPRINTcircle1(x); }
#else
#define setupPRINTcircle(x) \
	if (PRINTcircle) { volatile int size = PRINTcircleSIZE; \
	  if (_setjmp(CIRCLEjmp) != 0) { \
	    size += PRINTcircleSIZE; \
	    alloca(PRINTcircleSIZE * sizeof(object)); \
	  } else \
	     CIRCLEbase = alloca(PRINTcircleSIZE * sizeof(object)); \
	  CIRCLElimit = &CIRCLEbase[size]; \
	  setupPRINTcircle1(x); }
#endif DOWN_STACK



void setupPRINTcircle1(object x)
{   object *vp, *vq;

    CIRCLEtop = CIRCLEbase;
    travel_push_object(x);
    /* compact shared elements towards CIRCLEbase */
    for (vp = vq = CIRCLEbase;  vp < CIRCLEtop;  vp += 2)
      if (vp[1] != Cnil) {
	vq[0] = vp[0]; vq[1] = Cnil; vq += 2;
      }
    CIRCLEtop = vq;
}

travel_push_object(object x)
{
	enum type t;
	int i;
	object *vp;

	cs_check(x);

BEGIN:
	if (x == OBJNULL) return;
	t = type_of(x);
	if (t != t_array && t != t_vector && t != t_cons &&
#ifdef CLOS
	    t != t_instance &&
#else
	    t != t_structure &&
#endif CLOS
	    !(t == t_symbol && Null(x->s.s_hpack)))
		return;
	for (vp = CIRCLEbase;  vp < CIRCLEtop;  vp += 2)
		if (x == *vp) {
		  /* if (vp[1] == Cnil) */ vp[1] = Ct;
			return;
		}
	if (CIRCLEtop >= CIRCLElimit)
	  _longjmp(CIRCLEjmp, 1); /* go back to allocate more space */
	CIRCLEtop[0] = x;
	CIRCLEtop[1] = Cnil;
	CIRCLEtop += 2;

	switch (t) {
	case t_array:
	  if ((enum aelttype)x->a.a_elttype == aet_object)
	    for (i = 0;  i < x->a.a_dim;  i++)
	      travel_push_object(x->a.a_self[i]);
	  break;

	case t_vector:
	  if ((enum aelttype)x->v.v_elttype == aet_object)
	    for (i = 0;  i < x->v.v_fillp;  i++)
	      travel_push_object(x->v.v_self[i]);
	  break;

	case t_cons:
	  travel_push_object(CAR(x));
	  x = CDR(x);
	  goto BEGIN;

#ifdef CLOS
	case t_instance:
	  for (i = 0;  i < x->in.in_length;  i++)
	    travel_push_object(x->in.in_slots[i]);
	  break;
#else
	case t_structure:
	  for (i = 0;  i < x->str.str_length;  i++)
	    travel_push_object(x->str.str_self[i]);
#endif CLOS
	}
}

void setupPRINT(object x, object strm)
{
	object y;

	PRINTstream = strm;
RETRY:	if (type_of(PRINTstream) == t_stream) {
	  if (PRINTstream->sm.sm_mode == (short)smm_synonym) {
 		PRINTstream = symbol_value(PRINTstream->sm.sm_object0);
		goto RETRY;
	      }
	  else
	  output_ch_fun = writec_PRINTstream;
	} else
#ifdef CLOS
	  if (type_of(PRINTstream) == t_instance)
	    output_ch_fun = interactive_writec_PRINTstream;
	  else
#endif CLOS
	    { Vstandard_output->s.s_dbind = symbol_value(Vterminal_io);
	      FEwrong_type_argument(Sstream, PRINTstream);
	    }
	PRINTescape = symbol_value(Vprint_escape) != Cnil;
	PRINTpretty = symbol_value(Vprint_pretty) != Cnil;
	PRINTcircle = symbol_value(Vprint_circle) != Cnil;
	y = symbol_value(Vprint_base);
	if (!FIXNUMP(y) || fix(y) < 2 || fix(y) > 36) {
		Vprint_base->s.s_dbind = MAKE_FIXNUM(10);
		FEerror("~S is an illegal PRINT-BASE.", 1, y);
	} else
		PRINTbase = fix(y);
	PRINTradix = symbol_value(Vprint_radix) != Cnil;
	PRINTcase = symbol_value(Vprint_case);
	if (PRINTcase != Kupcase && PRINTcase != Kdowncase &&
	    PRINTcase != Kcapitalize) {
		Vprint_case->s.s_dbind = Kdowncase;
		FEerror("~S is an illegal PRINT-CASE.", 1, PRINTcase);
	}
	PRINTgensym = symbol_value(Vprint_gensym) != Cnil;
	y = symbol_value(Vprint_level);
	if (Null(y))
		PRINTlevel = -1;
	else if (!FIXNUMP(y) || fix(y) < 0) {
		Vprint_level->s.s_dbind = Cnil;
		FEerror("~S is an illegal PRINT-LEVEL.", 1, y);
	} else
		PRINTlevel = fix(y);
	y = symbol_value(Vprint_length);
	if (Null(y))
		PRINTlength = -1;
	else if (!FIXNUMP(y) || fix(y) < 0) {
		Vprint_length->s.s_dbind = Cnil;
		FEerror("~S is an illegal PRINT-LENGTH.", 1, y);
	} else
		PRINTlength = fix(y);
	PRINTarray = symbol_value(Vprint_array) != Cnil;
/*	setupPRINTcircle(x); */
	if (PRINTpretty) {
		qh = qt = qc = 0;
		isp = iisp = 0;
		indent_stack[0] = 0;
		write_ch_fun = writec_queue;
	} else
		write_ch_fun = output_ch_fun;
	PRINTpackage = symbol_value(siVprint_package) != Cnil;
	PRINTstructure = symbol_value(siVprint_structure) != Cnil;
}

void cleanupPRINT()
{
	if (PRINTpretty)
		flush_queue(TRUE);
}

bool
potential_number_p(object strng, int base)
{
	int i, l, c; bool dc;
	char *s;

	l = strng->st.st_fillp;
	if (l == 0)
		return(FALSE);
	s = strng->st.st_self;
	dc = FALSE;
	c = s[0];
	if (digitp(c, base) >= 0)
		dc = TRUE;
	else if (c != '+' && c != '-' && c != '^' && c != '_')
		return(FALSE);
	if (s[l-1] == '+' || s[l-1] == '-')
		return(FALSE);
	for (i = 1;  i < l;  i++) {
		c = s[i];
		if (digitp(c, base) >= 0) {
			dc = TRUE;
			continue;
		}
		if (c != '+' && c != '-' && c != '/' && c != '.' &&
		    c != '^' && c != '_' &&
		    c != 'e' && c != 'E' &&
		    c != 's' && c != 'S' && c != 'l' && c != 'L')
			return(FALSE);
	}
	return(dc);
}

@(defun write (x
	       &key ((:stream strm) Cnil)
		    (escape `symbol_value(Vprint_escape)`)
		    (radix `symbol_value(Vprint_radix)`)
		    (base `symbol_value(Vprint_base)`)
		    (circle `symbol_value(Vprint_circle)`)
		    (pretty `symbol_value(Vprint_pretty)`)
		    (level `symbol_value(Vprint_level)`)
		    (length `symbol_value(Vprint_length)`)
		    ((:case cas) `symbol_value(Vprint_case)`)
		    (gensym `symbol_value(Vprint_gensym)`)
		    (array `symbol_value(Vprint_array)`))
@
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
RETRY:	if (type_of(strm) == t_stream) {
	  if (strm->sm.sm_mode == (short)smm_synonym) {
 		strm = symbol_value(strm->sm.sm_object0);
		goto RETRY;
	      }
	  else
	    output_ch_fun = writec_PRINTstream;
	} else
#ifdef CLOS
          if (type_of(strm) == t_instance)
	    output_ch_fun = interactive_writec_PRINTstream;
          else
#endif CLOS
            FEerror("~S is not a stream.", 1, strm);
	PRINTstream = strm;
	PRINTescape = escape != Cnil;
	PRINTpretty = pretty != Cnil;
	PRINTcircle = circle != Cnil;
	if (!FIXNUMP(base) || fix((base))<2 || fix((base))>36)
		FEerror("~S is an illegal PRINT-BASE.", 1, base);
	else
		PRINTbase = fix((base));
	PRINTradix = radix != Cnil;
	PRINTcase = cas;
	if (PRINTcase != Kupcase && PRINTcase != Kdowncase &&
	    PRINTcase != Kcapitalize)
		FEerror("~S is an illegal PRINT-CASE.", 1, cas);
	PRINTgensym = gensym != Cnil;
	if (Null(level))
		PRINTlevel = -1;
	else if (!FIXNUMP(level) || fix((level)) < 0)
		FEerror("~S is an illegal PRINT-LEVEL.", 1, level);
	else
		PRINTlevel = fix((level));
	if (Null(length))
		PRINTlength = -1;
	else if (!FIXNUMP(length) || fix((length)) < 0)
		FEerror("~S is an illegal PRINT-LENGTH.", 1, length);
	else
		PRINTlength = fix((length));
	PRINTarray = array != Cnil;
	if (PRINTpretty) {
		qh = qt = qc = 0;
		isp = iisp = 0;
		indent_stack[0] = 0;
		write_ch_fun = writec_queue;
	} else
		write_ch_fun = output_ch_fun;
	PRINTpackage = symbol_value(siVprint_package) != Cnil;
	PRINTstructure = symbol_value(siVprint_structure) != Cnil;
  	setupPRINTcircle(x);
	write_object(x, 0);
	cleanupPRINT();
	FLUSH_STREAM(PRINTstream);
	@(return x)
@)

@(defun prin1 (obj &optional strm)
@
	prin1(obj, strm);
	@(return obj)
@)

@(defun print (obj &optional strm)
@
	print(obj, strm);
	@(return obj)
@)

@(defun pprint (obj &optional strm)
@
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
RETRY:	if (type_of(strm) == t_stream) {
	  if (strm->sm.sm_mode == (short)smm_synonym) {
 		strm = symbol_value(strm->sm.sm_object0);
		goto RETRY;
	      }
	  else
	    output_ch_fun = writec_PRINTstream;
	} else
#ifdef CLOS
          if (type_of(strm) == t_instance)
	    output_ch_fun = interactive_writec_PRINTstream;
          else
#endif CLOS
            FEerror("~S is not a stream.", 1, strm);
	setupPRINT(obj, strm);
	PRINTescape = TRUE;
	PRINTpretty = TRUE;
	qh = qt = qc = 0;
	isp = iisp = 0;
	indent_stack[0] = 0;
	write_ch_fun = writec_queue;
	output_ch('\n');
  	setupPRINTcircle(obj);
	write_object(obj, 0);
	cleanupPRINT();
	FLUSH_STREAM(PRINTstream);
	@(return)
@)

@(defun princ (obj &optional strm)
@
	princ(obj, strm);
	@(return obj)
@)

@(defun write_char (c &optional strm)
@
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
	check_type_character(&c);
RETRY:	if (type_of(strm) == t_stream) {
	  if (strm->sm.sm_mode == (short)smm_synonym) {
 		strm = symbol_value(strm->sm.sm_object0);
		goto RETRY;
	      }
	  else {
	    writec_stream(char_code(c), strm);
/*
	    FLUSH_STREAM(strm);
*/
	    @(return `c`)
	  }
	} else
#ifdef CLOS
	if (type_of(strm) == t_instance) {
	  interactive_writec_stream(char_code(c), strm);
	  @(return `c`)
	  }
        else
#endif
          FEerror("~S is not a stream.", 1, strm);
@)

@(defun write_string (strng &o strm &k start end)
	int s, e, i;
@
	get_string_start_end(strng, start, end, &s, &e);
	check_type_string(&strng);
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);

RETRY:	if (type_of(strm) == t_stream) {
	  if (strm->sm.sm_mode == (short)smm_synonym) {
 		strm = symbol_value(strm->sm.sm_object0);
		goto RETRY;
	      }
	  else {
	    for (i = s;  i < e;  i++)
	      writec_stream(strng->st.st_self[i], strm);
	    flush_stream(strm);
	  }
	} else
#ifdef CLOS
	if (type_of(strm) == t_instance)
	  funcall(4, Sstream_write_string, strm, strng,
		  MAKE_FIXNUM(s), MAKE_FIXNUM(e));
	else
#endif
          FEerror("~S is not a stream.", 1, strm);
	@(return strng)
@)

@(defun write_line (strng &o strm &k start end)
	int s, e, i;
@
	get_string_start_end(strng, start, end, &s, &e);
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
	check_type_string(&strng);

RETRY:	if (type_of(strm) == t_stream) {
	  if (strm->sm.sm_mode == (short)smm_synonym) {
 		strm = symbol_value(strm->sm.sm_object0);
		goto RETRY;
	      }
	  else {
	    for (i = s;  i < e;  i++)
	      writec_stream(strng->st.st_self[i], strm);
	    writec_stream('\n', strm);
	    flush_stream(strm);
	  }
	} else
#ifdef CLOS
	if (type_of(strm) == t_instance) {
	  for (i = s;  i < e;  i++)
	     interactive_writec_stream(strng->st.st_self[i], strm);
	  interactive_writec_stream('\n', strm);
	  flush_interactive_stream(strm);
	} else
#endif CLOS
	    FEerror("~S is not a stream.", 1, strm);
	@(return strng)
@)

@(defun terpri (&optional strm)
@
	terpri(strm);
	@(return Cnil)
@)

@(defun fresh_line (&optional strm)
@
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
RETRY:	if (type_of(strm) == t_stream) {
	  if (strm->sm.sm_mode == (short)smm_synonym) {
 		strm = symbol_value(strm->sm.sm_object0);
		goto RETRY;
	      }
	  else {
	    if (FILE_COLUMN(strm) == 0)
	      @(return Cnil)
		writec_stream('\n', strm);
	    flush_stream(strm);
	    @(return Ct)
	    }
	} else
#ifdef CLOS
	if (type_of(strm) == t_instance)
  	    RETURN(funcall(2, Sstream_fresh_line,strm));
	else
#endif
	 FEerror("~S is not a stream.", 1, strm);
@)

@(defun finish_output (&o strm)
@
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
RETRY:	if (type_of(strm) == t_stream) {
	  if (strm->sm.sm_mode == (short)smm_synonym) {
 		strm = symbol_value(strm->sm.sm_object0);
		goto RETRY;
	      }
	  else
	    flush_stream(strm);
	} else
#ifdef CLOS
	if (type_of(strm) == t_instance)
	  flush_interactive_stream(strm);
	else
#endif CLOS
	   FEerror("~S is not a stream.", 1, strm);
	@(return Cnil)
@)

@(defun force_output (&o strm)
@
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
RETRY:	if (type_of(strm) == t_stream) {
  	   if (strm->sm.sm_mode == (short)smm_synonym) {
	     strm = symbol_value(strm->sm.sm_object0);
	     goto RETRY;
	   }
	   else
	     flush_stream(strm);
	 } else
#ifdef CLOS
	if (type_of(strm) == t_instance)
	  flush_interactive_stream(strm);
	else
#endif CLOS
	  FEerror("~S is not a stream.", 1, strm);
	@(return Cnil)
@)

@(defun clear_output (&o strm)
@
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
RETRY:	if (type_of(strm) == t_stream) {
	  if (strm->sm.sm_mode == (short)smm_synonym) {
 		strm = symbol_value(strm->sm.sm_object0);
		goto RETRY;
	      }
	  else
	   clear_output_stream(strm);
	} else
#ifdef CLOS
	if (type_of(strm) == t_instance)
	  funcall(2, Sstream_clear_output, strm);
	else
#endif
	  FEerror("~S is not a stream.", 1, strm);
	@(return Cnil)
@)

@(defun write_byte (integer binary_output_stream)
@
	if (!FIXNUMP(integer))
		FEerror("~S is not a byte.", 1, integer);
	check_type_stream(&binary_output_stream);
	writec_stream(fix(integer), binary_output_stream);
	@(return integer)
@)

@(defun write_bytes (stream string start end)
        int is, ie, c = -1; FILE *fp;
	int written, sofarwritten, towrite;
@
	check_type_stream(&stream);
        is = fix(start), ie = fix(end);
        sofarwritten = is, towrite = ie-is;
        fp = stream->sm.sm_fp;
	if (fp == NULL) fp = stream->sm.sm_object1->sm.sm_fp;
/*
        c = fwrite(string->ust.ust_self + is, sizeof(unsigned char),
		   ie - is,
		   fp);
        @(return `MAKE_FIXNUM(c)`)
 */
	while (towrite > 0) {
	  written = write(fileno(fp),
			  string->ust.ust_self+sofarwritten, towrite);
	  if (written != -1) {
	    towrite -= written;
	    sofarwritten += written;
	  }
	  else @(return `MAKE_FIXNUM (-1)`)
	  };
  @(return `MAKE_FIXNUM(sofarwritten - is)`)
@)

init_print()
{
	Kupcase = make_keyword("UPCASE");
	Kdowncase = make_keyword("DOWNCASE");
	Kcapitalize = make_keyword("CAPITALIZE");

	Kstream = make_keyword("STREAM");
	Kescape = make_keyword("ESCAPE");
	Kpretty = make_keyword("PRETTY");
	Kcircle = make_keyword("CIRCLE");
	Kbase = make_keyword("BASE");
	Kradix = make_keyword("RADIX");
	Kcase = make_keyword("CASE");
	Kgensym = make_keyword("GENSYM");
	Klevel = make_keyword("LEVEL");
	Klength = make_keyword("LENGTH");
	Karray = make_keyword("ARRAY");

	Vprint_escape = make_special("*PRINT-ESCAPE*", Ct);
	Vprint_pretty = make_special("*PRINT-PRETTY*", Ct);
	Vprint_circle = make_special("*PRINT-CIRCLE*", Cnil);
	Vprint_base = make_special("*PRINT-BASE*", MAKE_FIXNUM(10));
	Vprint_radix = make_special("*PRINT-RADIX*", Cnil);
	Vprint_case = make_special("*PRINT-CASE*", Kupcase);
	Vprint_gensym = make_special("*PRINT-GENSYM*", Ct);
	Vprint_level = make_special("*PRINT-LEVEL*", Cnil);
	Vprint_length = make_special("*PRINT-LENGTH*", Cnil);
	Vprint_array = make_special("*PRINT-ARRAY*", Cnil);

	siVprint_package = make_si_special("*PRINT-PACKAGE*", Cnil);
	siVprint_structure = make_si_special("*PRINT-STRUCTURE*", Cnil);

	siSpretty_print_format
	= make_si_ordinary("PRETTY-PRINT-FORMAT");
	enter_mark_origin(&siSpretty_print_format);
	siSsharp_exclamation = make_si_ordinary("#!");
	enter_mark_origin(&siSsharp_exclamation);

	PRINTstream = Cnil;
	enter_mark_origin(&PRINTstream);
	PRINTescape = TRUE;
	PRINTpretty = FALSE;
	PRINTcircle = FALSE;
	PRINTbase = 10;
	PRINTradix = FALSE;
	PRINTcase = Kupcase;
	enter_mark_origin(&PRINTcase);
	PRINTgensym = TRUE;
	PRINTlevel = -1;
	PRINTlength = -1;
	PRINTarray = FALSE;

	write_ch_fun = writec_PRINTstream;
	output_ch_fun = writec_PRINTstream;
}

object
princ(object obj, object strm)
{
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
	if (obj == OBJNULL)
		goto SIMPLE_CASE;
	switch (type_of(obj)) {
	case t_symbol:
		PRINTcase = symbol_value(Vprint_case);
		PRINTpackage = symbol_value(siVprint_package) != Cnil;

	SIMPLE_CASE:
	case t_string:
	case t_character:
		PRINTstream = strm;
		PRINTescape = FALSE;
RETRY:		if (type_of(PRINTstream) == t_stream) {
		  if (PRINTstream->sm.sm_mode == (short)smm_synonym) {
			PRINTstream = symbol_value(PRINTstream->sm.sm_object0);
			goto RETRY;
		      }
		  else
		    write_ch_fun = writec_PRINTstream;
		} else
#ifdef CLOS
		  if (type_of(PRINTstream) == t_instance)
		    write_ch_fun = interactive_writec_PRINTstream;
		  else
#endif CLOS
		    FEerror("~S is not a stream.", 1, strm);
		write_object(obj, 0);
		break;

	default:
		setupPRINT(obj, strm);
		PRINTescape = FALSE;
		write_object(obj, 0);
		cleanupPRINT();
	}
	return(obj);
}

object
prin1(object obj, object strm)
{
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
	if (obj == OBJNULL)
		goto SIMPLE_CASE;
	switch (type_of(obj)) {
	SIMPLE_CASE:
	case t_string:
	case t_character:
		PRINTstream = strm;
		PRINTescape = TRUE;
RETRY:		if (type_of(PRINTstream) == t_stream) {
		  if (PRINTstream->sm.sm_mode == (short)smm_synonym) {
			PRINTstream = symbol_value(PRINTstream->sm.sm_object0);
			goto RETRY;
		      }
		  else
		    write_ch_fun = writec_PRINTstream;
		} else
#ifdef CLOS
		  if (type_of(PRINTstream) == t_instance)
		    write_ch_fun = interactive_writec_PRINTstream;
		  else
#endif CLOS
		    FEerror("~S is not a stream.", 1, strm);
		write_object(obj, 0);
		break;

	default:
		setupPRINT(obj, strm);
		PRINTescape = TRUE;
		setupPRINTcircle(obj);
		write_object(obj, 0);
		cleanupPRINT();
	}
	FLUSH_STREAM(PRINTstream);
	return(obj);
}

object
print(object obj, object strm)
{
	terpri(strm);
	return prin1(obj, strm);
}

object
terpri(object strm)
{
	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
RETRY:	if (type_of(strm) == t_stream) {
          if (strm->sm.sm_mode == (short)smm_synonym) {
	    strm = symbol_value(strm->sm.sm_object0);
	    goto RETRY;
	  }
	  else
	    write_ch_fun = writec_stream;
	} else
#ifdef CLOS
	  if (type_of(strm) == t_instance)
	    write_ch_fun = interactive_writec_stream;
	  else
#endif CLOS
	    FEerror("~S is not a stream.", 1, strm);
	write_ch('\n', strm);
	FLUSH_STREAM(strm);
	return(Cnil);
}

write_string(object strng, object strm)
{
	int i;

	if (Null(strm))
		strm = symbol_value(Vstandard_output);
	else if (strm == Ct)
		strm = symbol_value(Vterminal_io);
	check_type_string(&strng);
RETRY:	if (type_of(strm) == t_stream) {
          if (strm->sm.sm_mode == (short)smm_synonym) {
	    strm = symbol_value(strm->sm.sm_object0);
	    goto RETRY;
	  }
	  else {
	    for (i = 0;  i < strng->st.st_fillp;  i++)
	      writec_stream(strng->st.st_self[i], strm);
	    flush_stream(strm);
	  }
	} else
#ifdef CLOS
	if (type_of(strm) == t_instance) {
	  for (i = 0;  i < strng->st.st_fillp;  i++)
		interactive_writec_stream(strng->st.st_self[i], strm);
	  flush_interactive_stream(strm);
	} else
#endif CLOS
	  FEerror("~S is not a stream.", 1, strm);
}

/*
	THE ULTRA-SPECIAL-DINNER-SERVICE OPTIMIZATION
*/
princ_str(char *s, object sym)
{
/*	sym = symbol_value(sym);		Beppe */
	if (Null(sym))
		sym = symbol_value(Vstandard_output);
	else if (sym == Ct)
		sym = symbol_value(Vterminal_io);
RETRY:	if (type_of(sym) == t_stream) {
          if (sym->sm.sm_mode == (short)smm_synonym) {
	    sym = symbol_value(sym->sm.sm_object0);
	    goto RETRY;
	  }
	  else
	    writestr_stream(s, sym);
	} else
#ifdef CLOS
	if (type_of(sym) == t_instance)
	  while (*s != '\0')
		interactive_writec_stream(*s++, sym);
	else
#endif CLOS
	  FEerror("~S is not a stream.", 1, sym);
}

princ_char(int c, object sym)
{
/*	sym = symbol_value(sym); 		Beppe */
	if (Null(sym))
		sym = symbol_value(Vstandard_output);
	else if (sym == Ct)
		sym = symbol_value(Vterminal_io);
RETRY:	if (type_of(sym) == t_stream) {
          if (sym->sm.sm_mode == (short)smm_synonym) {
	    sym = symbol_value(sym->sm.sm_object0);
	    goto RETRY;
	  }
	  else {
	    writec_stream(c, sym);
	    if (c == '\n')
	      flush_stream(sym);
	  }
	} else
#ifdef CLOS
	if (type_of(sym) == t_instance) {
	  interactive_writec_stream(c, sym);
	  if (c == '\n')
		flush_interactive_stream(sym);
	} else
#endif CLOS
	  FEerror("~S is not a stream.", 1, sym);
}

init_print_function()
{
	make_function("WRITE", Lwrite);
	make_function("PRIN1", Lprin1);
	make_function("PRINT", Lprint);
	make_function("PPRINT", Lpprint);
	make_function("PRINC", Lprinc);

	make_function("WRITE-CHAR", Lwrite_char);
	make_function("WRITE-STRING", Lwrite_string);
	make_function("WRITE-LINE", Lwrite_line);
	make_function("TERPRI", Lterpri);
	make_function("FRESH-LINE", Lfresh_line);
	make_function("FINISH-OUTPUT", Lfinish_output);
	make_function("FORCE-OUTPUT", Lforce_output);
	make_function("CLEAR-OUTPUT", Lclear_output);

	make_function("WRITE-BYTE", Lwrite_byte);
	make_si_function("WRITE-BYTES", Lwrite_bytes);
#ifdef CLOS
	Sstream_write_char = make_ordinary("STREAM-WRITE-CHAR");
	Sstream_write_string = make_ordinary("STREAM-WRITE-STRING");
	Sstream_fresh_line = make_ordinary("STREAM-FRESH-LINE");
	Sstream_clear_output = make_ordinary("STREAM-CLEAR-OUTPUT");
	Sstream_force_output = make_ordinary("STREAM-FORCE-OUTPUT");
#endif
}
