#include <c_decl.h>
#include "sys.h"
#include "lisp.h"

CL_INIT KFmake_sequence[] =
{
{ CL_FIXNUM, 40 }, /* 0 */
{ RT_CHAR_PTR, (long)"~S is an invalid sequence typespecifier." },
{ CL_FIXNUM, 63 }, /* 2 */
{ RT_CHAR_PTR, (long)"The size ~S is inconsistent with the specified size ~S in type." },
};

void Fmake_sequence(CL_FORM *base, int nargs)
{
	BOOL supl_flags[1];
	static CL_FORM * keylist[] =
	{
		SYMBOL(Slisp, 124), /* INITIAL-ELEMENT */
	};
	keysort(STACK(base, 2), nargs - 2, 1, keylist, supl_flags, FALSE);
	if(NOT(supl_flags[0]))
	{
		LOAD_NIL(STACK(base, 2));
		LOAD_NIL(STACK(base, 3));
	}
	else
	{
		LOAD_T(STACK(base, 3));
	}
	COPY(STACK(base, 0), STACK(base, 4));
	normalize_type(STACK(base, 4));
	LOAD_NIL(STACK(base, 5));
	if(CL_ATOMP(STACK(base, 4)))
	{
		if(GET_SYMBOL(STACK(base, 4)) == SYMBOL(Slisp, 28) && CL_SYMBOLP(STACK(base, 4))) /* LIST */
		{
			if(CL_TRUEP(STACK(base, 3)))
			{
				COPY(STACK(base, 1), STACK(base, 0));
				LOAD_SYMBOL(SYMBOL(Slisp, 124), STACK(base, 1)); /* INITIAL-ELEMENT */
				Fmake_list(STACK(base, 0), 3);
			}
			else
			{
				COPY(STACK(base, 1), STACK(base, 0));
				Fmake_list(STACK(base, 0), 1);
			}
			goto RETURN168;
		}
		else
		{
			goto M146_1;
		}
	}
	else
	{
		COPY(GET_CAR(STACK(base, 4)), STACK(base, 6));
		if(GET_SYMBOL(STACK(base, 6)) == SYMBOL(Slisp, 553) && CL_SYMBOLP(STACK(base, 6))) /* SIMPLE-ARRAY */
		{
			LOAD_T(STACK(base, 7));
		}
		else
		{
			LOAD_NIL(STACK(base, 7));
		}
		if(CL_TRUEP(STACK(base, 7)))
		{
			bool_result = TRUE;
		}
		else
		{
			bool_result = GET_SYMBOL(STACK(base, 6)) == SYMBOL(Slisp, 13) && CL_SYMBOLP(STACK(base, 6)); /* ARRAY */
		}
		if(bool_result)
		{
			COPY(STACK(base, 4), STACK(base, 7));
			COPY(GET_CAR(STACK(base, 4)) + 1, STACK(base, 8));
			if(CL_TRUEP(STACK(base, 8)))
			{
				if(CL_CONSP(STACK(base, 8)))
				{
					COPY(GET_CAR(STACK(base, 8)), STACK(base, 7));
				}
				else
				{
					LOAD_SMSTR((CL_FORM *)&KClisp[62], STACK(base, 7)); /* ~a is not a list */
					Ferror(STACK(base, 7), 2);
				}
			}
			else
			{
				LOAD_NIL(STACK(base, 7));
			}
			COPY(STACK(base, 4), STACK(base, 8));
			COPY(GET_CAR(STACK(base, 4)) + 1, STACK(base, 9));
			if(CL_TRUEP(STACK(base, 9)))
			{
				if(CL_CONSP(STACK(base, 9)))
				{
					COPY(GET_CAR(STACK(base, 9)) + 1, STACK(base, 9));
				}
				else
				{
					LOAD_SMSTR((CL_FORM *)&KClisp[60], STACK(base, 10)); /* ~a is not a list */
					COPY(STACK(base, 9), STACK(base, 11));
					Ferror(STACK(base, 10), 2);
				}
			}
			else
			{
				LOAD_NIL(STACK(base, 9));
			}
			if(CL_TRUEP(STACK(base, 9)))
			{
				if(CL_CONSP(STACK(base, 9)))
				{
					COPY(GET_CAR(STACK(base, 9)), STACK(base, 8));
				}
				else
				{
					LOAD_SMSTR((CL_FORM *)&KClisp[62], STACK(base, 8)); /* ~a is not a list */
					Ferror(STACK(base, 8), 2);
				}
			}
			else
			{
				LOAD_NIL(STACK(base, 8));
			}
			COPY(STACK(base, 8), STACK(base, 9));
			if(CL_TRUEP(STACK(base, 8)))
			{
				if(CL_CONSP(STACK(base, 8)))
				{
					bool_result = CL_TRUEP(GET_CAR(STACK(base, 8)) + 1);
				}
				else
				{
					LOAD_SMSTR((CL_FORM *)&KClisp[60], STACK(base, 10)); /* ~a is not a list */
					COPY(STACK(base, 8), STACK(base, 11));
					Ferror(STACK(base, 10), 2);
				}
			}
			else
			{
				bool_result = CL_TRUEP(STACK(base, 8));
			}
			if(bool_result)
			{
				goto M146_1;
			}
			COPY(STACK(base, 8), STACK(base, 9));
			COPY(STACK(base, 9), STACK(base, 10));
			if(CL_TRUEP(STACK(base, 10)))
			{
				if(CL_CONSP(STACK(base, 10)))
				{
					COPY(GET_CAR(STACK(base, 10)), STACK(base, 5));
				}
				else
				{
					LOAD_SMSTR((CL_FORM *)&KClisp[62], STACK(base, 11)); /* ~a is not a list */
					COPY(STACK(base, 10), STACK(base, 12));
					Ferror(STACK(base, 11), 2);
				}
			}
			else
			{
				LOAD_NIL(STACK(base, 5));
			}
			if(GET_SYMBOL(STACK(base, 5)) == SYMBOL(Slisp, 48) && CL_SYMBOLP(STACK(base, 5))) /* * */
			{
				bool_result = FALSE;
			}
			else
			{
				COPY(STACK(base, 1), STACK(base, 9));
				COPY(STACK(base, 5), STACK(base, 10));
				Fnumneql(STACK(base, 9), 2);
				bool_result = CL_TRUEP(STACK(base, 9));
			}
			if(bool_result)
			{
				goto M146_2;
			}
			if(GET_SYMBOL(STACK(base, 7)) == SYMBOL(Slisp, 18) && CL_SYMBOLP(STACK(base, 7))) /* CHARACTER */
			{
				if(CL_TRUEP(STACK(base, 3)))
				{
					COPY(STACK(base, 1), STACK(base, 0));
					LOAD_SYMBOL(SYMBOL(Slisp, 124), STACK(base, 1)); /* INITIAL-ELEMENT */
					Fmake_string(STACK(base, 0), 3);
				}
				else
				{
					COPY(STACK(base, 1), STACK(base, 0));
					Fmake_string(STACK(base, 0), 1);
				}
			}
			else
			{
				LOAD_GLOBFUN(&CFmake_array, STACK(base, 9));
				COPY(STACK(base, 1), STACK(base, 10));
				if(CL_TRUEP(STACK(base, 3)))
				{
					LOAD_SYMBOL(SYMBOL(Slisp, 124), STACK(base, 11)); /* INITIAL-ELEMENT */
					COPY(STACK(base, 2), STACK(base, 12));
					Flist(STACK(base, 11), 2);
				}
				else
				{
					LOAD_NIL(STACK(base, 11));
				}
				if(GET_SYMBOL(STACK(base, 7)) == SYMBOL(Slisp, 48) && CL_SYMBOLP(STACK(base, 7))) /* * */
				{
					LOAD_NIL(STACK(base, 12));
				}
				else
				{
					LOAD_SYMBOL(SYMBOL(Slisp, 94), STACK(base, 12)); /* ELEMENT-TYPE */
					COPY(STACK(base, 7), STACK(base, 13));
					Flist(STACK(base, 12), 2);
				}
				Fappend(STACK(base, 11), 2);
				Fapply(STACK(base, 9), 3);
				COPY(STACK(base, 9), STACK(base, 0));
			}
			goto RETURN168;
		}
		else
		{
			goto M146_1;
		}
	}
	M146_1:;
	LOAD_SMSTR((CL_FORM *)&KFmake_sequence[0], STACK(base, 6)); /* ~S is an invalid sequence typespecifier. */
	COPY(STACK(base, 0), STACK(base, 7));
	Ferror(STACK(base, 6), 2);
	M146_2:;
	LOAD_SMSTR((CL_FORM *)&KFmake_sequence[2], STACK(base, 6)); /* The size ~S is inconsistent with the specified size ~S in type. */
	COPY(STACK(base, 1), STACK(base, 7));
	COPY(STACK(base, 5), STACK(base, 8));
	Ferror(STACK(base, 6), 3);
	LOAD_NIL(STACK(base, 0));
	RETURN168:;
}
