#include <c_decl.h>
#include "sys.h"
#include "lisp.h"

void Fsort(CL_FORM *base, int nargs)
{
	BOOL supl_flags[1];
	static CL_FORM * keylist[] =
	{
		SYMBOL(Slisp, 139), /* KEY */
	};
	keysort(STACK(base, 2), nargs - 2, 1, keylist, supl_flags, FALSE);
	if(NOT(supl_flags[0]))
	{
		LOAD_GLOBFUN(&CFidentity, STACK(base, 2));
	}
	if(CL_CONSP(STACK(base, 0)) || CL_NILP(STACK(base, 0)))
	{
		list_merge_sort(STACK(base, 0));
	}
	else
	{
		COPY(STACK(base, 0), STACK(base, 3));
		LOAD_FIXNUM(0, STACK(base, 4));
		if(CL_CONSP(STACK(base, 0)) || CL_NILP(STACK(base, 0)))
		{
			COPY(STACK(base, 0), STACK(base, 5));
			raw_list_length(STACK(base, 5));
		}
		else
		{
			if(TYPE_OF(STACK(base, 0)) >= T_VEC_LO && TYPE_OF(STACK(base, 0)) <= T_VEC_HI)
			{
				LOAD_FIXNUM(AR_SIZE(GET_FORM(STACK(base, 0))), STACK(base, 5));
			}
			else
			{
				LOAD_SMSTR((CL_FORM *)&KClisp[32], STACK(base, 5)); /* ~a is not a sequence */
				COPY(STACK(base, 0), STACK(base, 6));
				Ferror(STACK(base, 5), 2);
			}
		}
		COPY(STACK(base, 1), STACK(base, 6));
		COPY(STACK(base, 2), STACK(base, 7));
		quick_sort(STACK(base, 3));
		COPY(STACK(base, 3), STACK(base, 0));
	}
}
