;;;-----------------------------------------------------------------------------
;;; Copyright (C) 1993 Christian-Albrechts-Universitaet zu Kiel, Germany
;;;----------------------------------------------------------------------------
;;; Projekt  : APPLY - A Practicable And Portable Lisp Implementation
;;;            ------------------------------------------------------
;;; Inhalt   : Laufzeitfunktionen des FFI
;;;
;;; $Revision: 1.6 $
;;; $Log: foreign.lisp,v $
;;; Revision 1.6  1993/06/16  15:20:38  hk
;;;  Copyright Notiz eingefuegt.
;;;
;;; Revision 1.5  1993/05/23  17:56:08  pm
;;; Alle in Lisp geschriebenen Konstruktor- und Konvertierungs-
;;; Funktionen fuer die primitiven C-Typen implementiert
;;;
;;; Revision 1.4  1993/05/21  13:59:37  pm
;;; c-int in int umbenannt
;;;
;;; Revision 1.3  1993/05/06  14:38:36  pm
;;; erste Versuche fuer int's
;;;
;;; Revision 1.2  1993/04/28  09:10:27  pm
;;; initial revision
;;;
;;------------------------------------------------------------------------------

(in-package "LISP")

(export
 '(ffi::c-char ffi::c-unsigned-char ffi::c-short ffi::c-int
   ffi::c-long ffi::c-unsigned-short ffi::c-unsigned-int
   ffi::c-unsigned-long ffi::c-float ffi::c-double ffi::c-long-double
   ffi::lisp-character ffi::lisp-integer ffi::lisp-float)
 "FFI")

;;------------------------------------------------------------------------------

(defun ffi:c-char (value)
  (if (typep value 'character)
      (rt::make-c-char value)
      (error-in 'c-char 
                "The computed value ~S is not of type character." value)))

(defun ffi:c-unsigned-char (value)
  (if (typep value 'character)
      (rt::make-c-unsigned-char value)
      (error-in 'c-unsigned-char 
                "The computed value ~S is not of type character." value)))

(defun ffi:c-short (value)
  (if (typep value 'fixnum)
      (rt::make-c-short value)
      (error-in 'c-short 
                "The computed value ~S is not of type fixnum." value)))

(defun ffi:c-int (value)
  (if (typep value 'fixnum)
      (rt::make-c-int value)
      (error-in 'c-int
                "The computed value ~S is not of type fixnum." value)))

(defun ffi:c-long (value)
  (if (typep value 'fixnum)
      (rt::make-c-long value)
      (error-in 'c-long 
                "The computed value ~S is not of type fixnum." value)))

(defun ffi:c-unsigned-short (value)
  (if (typep value 'fixnum)
      (rt::make-c-unsigned-short value)
      (error-in 'c-unsigned-short 
                "The computed value ~S is not of type fixnum." value)))

(defun ffi:c-unsigned-int (value)
  (if (typep value 'fixnum)
      (rt::make-c-unsigned-int value)
      (error-in 'c-unsigned-int
                "The computed value ~S is not of type fixnum." value)))

(defun ffi:c-unsigned-long (value)
  (if (typep value 'fixnum)
      (rt::make-c-unsigned-long value)
      (error-in 'c-unsigned-long 
                "The computed value ~S is not of type .fixnum" value)))

(defun ffi:c-float (value)
  (if (typep value 'float)
      (rt::make-c-float value)
      (error-in 'c-float 
                "The computed value ~S is not of type float." value)))

(defun ffi:c-double (value)
  (if (typep value 'float)
      (rt::make-c-double value)
      (error-in 'c-double 
                "The computed value ~S is not of type float." value)))

(defun ffi:c-long-double (value)
  (if (typep value 'float)
      (rt::make-c-long-double value)
      (error-in 'c-long-double
                "The computed value ~S is not of type float." value)))

;;------------------------------------------------------------------------------
(defun ffi:lisp-character (c-value)
  (if (or (rt::c-char-p c-value)
          (rt::c-unsigned-char-p c-value))
      (rt::make-lisp-character c-value)
      (error-in 
       'lisp-character
       "The computed value ~S is not of type c-<char>."
       c-value)))

(defun ffi:lisp-integer (c-value)
  (if (or (rt::c-short-p c-value)
          (rt::c-int-p c-value)
          (rt::c-long-p c-value)
          (rt::c-unsigned-short-p c-value)
          (rt::c-unsigned-int-p c-value)
          (rt::c-unsigned-long-p c-value))
      (rt::make-lisp-integer c-value)
      (error-in
       'lisp-integer
       "The computed value ~S is not of type c-<integer>."
       c-value)))

(defun ffi:lisp-float (c-value)
  (if (or (rt::c-float-p c-value)
          (rt::c-double-p c-value)
          (rt::c-long-double-p c-value))
      (rt::make-lisp-float c-value)
      (error-in
       'lisp-float
       "The computed value ~S is not of type c-<float>."
       c-value)))
