;;;-----------------------------------------------------------------------------
;;; Projekt  : APPLY - A Practicable And Portable Lisp Implementation
;;;            ------------------------------------------------------
;;; Funktion : Auf die Seiteneffektanalyse beruhende Optimierungen.
;;;
;;; $Revision: 1.4 $
;;; $Log: seomain.lisp,v $
;;; Revision 1.4  1993/07/15  15:55:36  jh
;;; Schreibfehler beseitigt.
;;;
;;; Revision 1.3  1993/07/09  11:30:49  jh
;;; Fehler behoben.
;;;
;;; Revision 1.2  1993/07/08  11:16:39  jh
;;; Spezialbehandlung fuer einen Fall von progn-form, der aus dolist entsteht,
;;; eingebaut.
;;;
;;; Revision 1.1  1993/07/08  10:42:06  jh
;;; Initial revision
;;;
;;;-----------------------------------------------------------------------------

(in-package "CLICC")
(require "titypes")

;;------------------------------------------------------------------------------
;; *result-used* gibt an, ob das Ergebnis des Zwsichensprachausdrucks benoetigt
;; wird.
;;------------------------------------------------------------------------------

(defvar *result-used*)

;;------------------------------------------------------------------------------
;; An var-refs, named-const etc. kann nichts optimiert werden.
;;------------------------------------------------------------------------------

(defmethod seo-1form ((a-form form))
  a-form)

(defmethod seo-1form :around ((a-form form))
           (if *result-used*
               (if (has-no-side-effect a-form)
                   (let ((type (?type a-form)))
                     (cond
                       ((type-eq null-t type) empty-list)
                       ((type-eq t-symbol-t type)
                        (get-symbol-bind 'clicc-lisp::T))
                       (T (call-next-method))))
                   (call-next-method))
               (if (has-no-side-effect a-form)
                   empty-list
                   (call-next-method))))
                        
;;------------------------------------------------------------------------------

(defmethod seo-1form ((a-progn-form progn-form))
  (let ((form-queue (empty-queue))
        (forms (?form-list a-progn-form)))
    (dolist (a-form (butlast forms))
      (unless (has-no-side-effect a-form)
        (add-q a-form form-queue)))
    (let ((a-form (first (last forms))))
      (unless (and (not *result-used*) (has-no-side-effect a-form))
        (add-q a-form form-queue)))
    (let* ((new-forms (queue2list form-queue))
           (form-n-1 (first (last (butlast new-forms))))
           (form-n (last-q form-queue)))
      (when (and form-n-1               ; Dieser Fall entsteht aus 'dolist'.
                 (null-form-p form-n)
                 (type-eq null-t (?type form-n-1)))
        (setq new-forms (butlast new-forms)))
      (setf (?form-list a-progn-form) new-forms)))
  a-progn-form)

;;------------------------------------------------------------------------------

(provide "seomain")


