;;;-----------------------------------------------------------------------------
;;; Copyright (C) 1993 Christian-Albrechts-Universitaet zu Kiel, Germany
;;;-----------------------------------------------------------------------------
;;; Projekt  : APPLY - A Practicable And Portable Lisp Implementation
;;;            ------------------------------------------------------
;;; Funktion : Codegenerierung
;;;            Erzeugen von Inline-Code fuer ausgewaehlte Systempraedikate
;;;
;;; $Revision: 1.20 $
;;; $Log: cginline.lisp,v $
;;; Revision 1.20  1993/07/22  13:00:54  hk
;;; In cg-%car und cg-%cdr GET_FORM durch GET_CAR ersetzt.
;;;
;;; Revision 1.19  1993/06/17  08:00:09  hk
;;; Copright Notiz eingefuegt
;;;
;;; Revision 1.18  1993/04/06  17:28:30  hk
;;; ?codegen -> ?c-inline.
;;;
;;; Revision 1.17  1993/04/06  17:09:29  hk
;;; shift-right, shift-left -> %shift-right, %shift-left.
;;;
;;; Revision 1.16  1993/02/16  15:50:26  hk
;;; Revision Keyword eingefuegt, Symbole im zu uebersetzenden Programm
;;; werden im clicc-lisp Package angesprochen.
;;;
;;; Revision 1.15  1993/01/13  15:06:31  ft
;;; Erweiterung um Funktionen fuer ash.
;;;
;;; Revision 1.14  1993/01/07  10:00:20  hk
;;; Fehler mit special-sys-fun behoben.
;;;
;;; Revision 1.13  1993/01/07  08:31:04  hk
;;; Fehler in macrolet von cg-special-funs behoben.
;;;
;;; Revision 1.12  1993/01/06  13:03:40  hk
;;; Funktionen {p1,p2,p3,cg}-special-funs vereinheitlicht.
;;;
;;; Revision 1.11  1993/01/06  11:18:53  ft
;;; Erweiterung um logische Operationen auf Zahlen.
;;;
;;; Revision 1.10  1992/12/03  14:53:26  hk
;;; typecase -> etypecase
;;;
;;; Revision 1.9  1992/11/26  16:46:17  hk
;;; Neu cg-%vector-length.
;;;
;;; Revision 1.8  1992/11/26  16:00:13  hk
;;; cg-init von cgmain.lisp -> hier, get-arg geaendert, etc.
;;;
;;; Revision 1.7  1992/11/25  17:51:27  hk
;;; Inline Compilation von %car, %cdr, %rplaca, %rplacd, %cons und
;;; einige Umbenennungen: check-integer-low -> fixnum-low-p ...
;;;
;;; Revision 1.6  1992/10/08  14:04:23  hk
;;; cg-eq: Optimierung nach p2, null-form beachtet, cg-get-arg korrigiert.
;;;
;;; Revision 1.5  1992/09/25  17:24:44  kl
;;; C-eq und C-eql auf die neue Repraesentation der einfachen Literale
;;; umgestellt.
;;;
;;; Revision 1.4  1992/09/21  11:18:52  hk
;;; Die eigentliche C-Codegenerierung uebersichtlicher gestaltet
;;;
;;; Revision 1.3  1992/07/30  10:27:07  hk
;;; .
;;;
;;; Revision 1.2  1992/06/04  07:11:20  hk
;;; Nach Umstellung auf die Lisp nahe Zwischensprache, Syntax-Fehler
;;; sind schon beseitigt
;;;
;;; Revision 1.1  1992/03/24  16:54:56  hk
;;; Initial revision
;;;-----------------------------------------------------------------------------

(in-package "CLICC")     

;;------------------------------------------------------------------------------
;; Bekanntgeben der Funktionen, die inline kompiliert werden.
;;------------------------------------------------------------------------------
(p0-special-funs
 (?c-inline "CG")
 clicc-lisp::eq
 clicc-lisp::eql
 clicc-lisp::not
 clicc-lisp::integerp
 rt::fixnum-low-p
 rt::fixnum-high-p
 clicc-lisp::consp
 clicc-lisp::characterp
 clicc-lisp::simple-string-p
 clicc-lisp::floatp
 clicc-lisp::atom
 clicc-lisp::symbolp
 clicc-lisp::listp
 clicc-lisp::stringp
 clicc-lisp::numberp
 clicc-lisp::functionp
 clicc-lisp::vectorp
 clicc-lisp::simple-vector-p
 clicc-lisp::arrayp
 rt::simple-array-p
 clicc-lisp::values
 clicc-lisp::cons
 rt::%car
 rt::%cdr
 rt::%rplaca
 rt::%rplacd
 rt::%vector-length
 rt::%logior
 rt::%logxor
 rt::%logand
 rt::%lognot
 rt::%shift-right
 rt::%shift-left)

;;------------------------------------------------------------------------------
;; Hilfsfunktion, die Code f"ur den Zugriff auf das Resultat eines Ausdrucks
;; generiert. Bei Variablenzugriffen wird ein Kopieren des Werts vermieden.
;;------------------------------------------------------------------------------
(defun CC-get-arg (form)
  (CC-dest (get-arg-loc form)))

;;------------------------------------------------------------------------------
(defmethod get-arg-loc ((form var-ref))
  (etypecase (?var form)
    (static (?var form))
    (dynamic (?var form))))

(defmethod get-arg-loc ((form t))
  (let ((*result-spec* (stacktop-result-location)))
    (cg-form form)
    (incf *stack-top*)
    *result-spec*))

;;------------------------------------------------------------------------------
;; Hilfsfunktion, die bei Bedarf Boolesche C-Werte in die LISP-Werte
;; T / NIL umwandelt.
;;------------------------------------------------------------------------------
(defun pred-result (pred)
  (case *result-spec*
    ((NIL))
    (C-bool (setq *C-bool* pred))
    (T (C-if pred)
       (C-blockstart)
       (C-t (CC-dest *result-spec*))
       (C-blockend)
       (C-else)
       (C-blockstart)
       (C-nil (CC-dest *result-spec*))
       (C-blockend))))

;;------------------------------------------------------------------------------
;; Hilfsfunktion, die das Resultat einer inline kompilierten Funktion an die
;; in *result-spec* angegebene Position kopiert.
;;------------------------------------------------------------------------------
(defun C-result (source)
  (case *result-spec*
    
    ;; Resultat wird nicht benoetigt
    ;;------------------------------
    ((NIL))
    
    ;; Boolesches Resultat gewuenscht
    ;;-------------------------------
    (C-BOOL (setq *C-bool* (CC-make-bool source)))

    ;; Normales Resultat erzeugen
    ;;---------------------------
    (T (C-copy source (CC-dest *result-spec*)))))

;;------------------------------------------------------------------------------
;; EQ, inline
;; ACHTUNG: es wird davon ausgegangen, dass Zeiger die groesste Komponente
;; in CL_FORM sind.
;; Optimiert, wenn einer der Parameter konstant ist.
;;------------------------------------------------------------------------------
(defun cg-eq (form1 form2)
  (pred-result
   (let ((*stack-top* *stack-top*)
         (const-arg 0))

     ;; pruefen, welche der Argumente konstant sind
     ;;--------------------------------------------
     (if (or (simple-literal-p form1) (sym-p form1))
         (incf const-arg 1)
         (setq form1 (CC-get-arg form1)))
     (if (or (simple-literal-p form2) (sym-p form2))
         (incf const-arg 2)
         (setq form2 (CC-get-arg form2)))

     (case const-arg

       ;; eines der Argumente ist konstant
       ;;---------------------------------
       ((1 2) (when (= const-arg 2)
                (rotatef form1 form2))
        (typecase form1
          (null-form (getCode "CL_NILP(~A)" form2))
          (int
           (getCode "GET_FIXNUM(~A) == ~A && CL_FIXNUMP(~A)"
                    form2 (?value form1) form2))
          (character-form
           (getCode "GET_CHAR(~A) == ~A && CL_CHARP(~A)"
                    form2 (CC-character (?value form1)) form2))
          (sym (getCode "GET_SYMBOL(~A) == ~A && CL_SYMBOLP(~A)"
                        form2 (CC-symbol form1) form2))
          (T "FALSE")))
       
              
       (t (getCode "GET_FORM(~A) == GET_FORM(~A) && ~
                        TYPE_OF(~A) == TYPE_OF(~A)" 
                   form1 form2 form1 form2))))))

;;------------------------------------------------------------------------------
;; EQL, inline
;; Optimierung:
;; Wenn eines der Argument vom Typ FLOAT ist, dann direkt vergleichen.
;;------------------------------------------------------------------------------
(defun cg-eql (form1 form2)
  (pred-result
   (let ((*stack-top* *stack-top*) 
         (floatconst 0))
     
     ;; Pruefen, ob FLOAT Konstanten vorliegen
     ;;---------------------------------------
     (if (float-form-p form1)
         (incf floatconst 1)
         (setq form1 (CC-get-arg form1)))
     (if (float-form-p form2)
         (incf floatconst 2)
         (setq form2 (CC-get-arg form2)))

     (case floatconst

       ;; 'Normales' EQL
       ;;---------------
       (0 (getCode 
           "TYPE_OF(~A) == TYPE_OF(~A) && (GET_FORM(~A) == GET_FORM(~A) || ~
                CL_FLOATP(~A) && GET_FLOAT(~A) == GET_FLOAT(~A))"
           form1 form2 form1 form2 form1 form1 form2))
     
       ;; beide Argumente sind vom Typ FLOAT
       ;;-----------------------------------
       (3 (CC-bool (= (?value form1) (?value form2))))
     
       ;; eines der Argumente ist vom Typ FLOAT
       ;;--------------------------------------
       (T (when (= floatconst 2)
            (rotatef form1 form2))
          (getCode "CL_FLOATP(~A) && GET_FLOAT(~A) == ~A"
                   form2 form2 (?value form1)))))))

;;------------------------------------------------------------------------------
(defun cg-not (form)
  (pred-result
   (let ((*result-spec* (when *result-spec* 'C-bool)))
     (cg-form form)
     (CC-MacroCall "NOT" *C-bool*))))

;;------------------------------------------------------------------------------
(defun cg-integerp (x-loc)
  (pred-result (getCode "CL_FIXNUMP(~A)" (CC-get-arg x-loc))))

;;------------------------------------------------------------------------------
(defun cg-fixnum-low-p (val low)
  (setq val (CC-get-arg val))
  (setq low (CC-get-arg low))
  (pred-result
   (getCode "GET_FIXNUM(~A) >= GET_FIXNUM(~A) && CL_FIXNUMP(~A)" val low val)))

;;------------------------------------------------------------------------------
(defun cg-fixnum-high-p (val high)
  (setq val (CC-get-arg val))
  (setq high(CC-get-arg high))
  (pred-result
   (getCode "GET_FIXNUM(~A) <= GET_FIXNUM(~A) && CL_FIXNUMP(~A)" val high val)))


;;------------------------------------------------------------------------------
(defun cg-consp (x-loc)
  (pred-result
   (getCode "CL_CONSP(~A)" (CC-get-arg x-loc))))

;;------------------------------------------------------------------------------
(defun cg-characterp (x-loc)
  (pred-result
   (getCode "CL_CHARP(~A)" (CC-get-arg x-loc))))

;;------------------------------------------------------------------------------
(defun cg-simple-string-p (x-loc) 
  (pred-result
   (getCode "CL_SMSTRP(~A)" (CC-get-arg x-loc))))

;;------------------------------------------------------------------------------
(defun cg-floatp (x-loc)
  (pred-result
   (getCode "CL_FLOATP(~A)" (CC-get-arg x-loc))))

;;------------------------------------------------------------------------------
(defun cg-atom (x-loc)
  (pred-result
   (getCode "CL_ATOMP(~A)" (CC-get-arg x-loc))))

;;------------------------------------------------------------------------------
(defun cg-symbolp (x-loc)
  (setq x-loc (CC-get-arg x-loc))
  (pred-result
   (getCode "CL_SYMBOLP(~A) || CL_NILP(~A)"
            x-loc x-loc x-loc)))

;;------------------------------------------------------------------------------
(defun cg-listp (x-loc)
  (setq x-loc (CC-get-arg x-loc))
  (pred-result
   (getCode "CL_CONSP(~A) || CL_NILP(~A)" x-loc x-loc)))

;;------------------------------------------------------------------------------
(defun cg-stringp (x-loc)
  (setq x-loc (CC-get-arg x-loc))
  (pred-result
   (getCode "CL_SMSTRP(~A) || CL_STRINGP(~A)" x-loc x-loc)))

;;------------------------------------------------------------------------------
(defun cg-numberp (x-loc)
  (setq x-loc (CC-get-arg x-loc))
  (pred-result
   (getCode "CL_FIXNUMP(~A) || CL_FLOATP(~A)" x-loc x-loc)))

;;------------------------------------------------------------------------------
(defun cg-functionp (x-loc)
  (setq x-loc (CC-get-arg x-loc))
  (pred-result
   (getCode "CL_CLOSUREP(~A) || CL_DOWNFUNP(~A) || CL_GLOBFUNP(~A)"
            x-loc x-loc x-loc)))

;;------------------------------------------------------------------------------
(defun cg-vectorp (x-loc)
  (setq x-loc (CC-get-arg x-loc))
  (pred-result
   (getCode "TYPE_OF(~A) >= T_VEC_LO && TYPE_OF(~A) <= T_VEC_HI" x-loc x-loc)))

;;------------------------------------------------------------------------------
(defun cg-simple-vector-p (x-loc)
  (pred-result
   (getCode "CL_SMVEC_T_P(~A)" (CC-get-arg x-loc))))

;;------------------------------------------------------------------------------
(defun cg-arrayp (x-loc)
  (setq x-loc (CC-get-arg x-loc))
  (pred-result
   (getCode "TYPE_OF(~A) >= T_ARR_LO && TYPE_OF(~A) <= T_ARR_HI" x-loc x-loc)))

;;------------------------------------------------------------------------------
(defun cg-simple-array-p (x-loc)
  (setq x-loc (CC-get-arg x-loc))
  (pred-result
   (getCode "TYPE_OF(~A) >= T_SMAR_LO && TYPE_OF(~A) <= T_SMAR_HI"
            x-loc x-loc)))

;;------------------------------------------------------------------------------
(defun cg-%car (cell)
  (setq cell (CC-get-arg cell))
  (C-result (CC-MacroCall "GET_CAR" cell)))

;;------------------------------------------------------------------------------
(defun cg-%cdr (cell)
  (setq cell (CC-get-arg cell))
  (C-result (CC-op+ (CC-MacroCall "GET_CAR" cell) 1)))

;;------------------------------------------------------------------------------
(defun cg-cons (x y)
  (setq x (CC-get-arg x))
  (setq y (CC-get-arg y))
  (case *result-spec*
    ((NIL))
    (C-BOOL (setq *C-bool* C-TRUE))
    (T (let ((var "lptr"))
         (C-Blockstart)
         (C-PtrDecl "CL_FORM" var)
         (C-assign var (CC-Call "form_alloc" (CC-StackTop) 2))
         (C-copy x var)
         (C-copy y (CC-op+ var 1))
         (C-MacroCall "LOAD_CONS" var (CC-dest *result-spec*))
         (C-Blockend)))))

;;------------------------------------------------------------------------------
(defun cg-%rplaca (x y)
  (setq x (get-arg-loc x))
  (setq y (get-arg-loc y))
  (C-copy (CC-dest y) (CC-MacroCall "GET_FORM" (CC-dest x)))
  (to-result-loc x))

;;------------------------------------------------------------------------------
(defun cg-%rplacd (x y)
  (setq x (get-arg-loc x))
  (setq y (get-arg-loc y))
  (C-copy (CC-dest y) (CC-op+ (CC-MacroCall "GET_FORM" (CC-dest x)) 1))
  (to-result-loc x))

;;------------------------------------------------------------------------------
(defun cg-%vector-length (x)
  (setq x (CC-get-arg x))
  (C-MacroCall "LOAD_FIXNUM"
               (CC-MacroCall "AR_SIZE" (CC-MacroCall "GET_FORM" x))
               (CC-dest *result-spec*)))

;;------------------------------------------------------------------------------
(defun cg-%logior (x y)
  (setq x (CC-get-arg x))
  (setq y (CC-get-arg y))
  (C-MacroCall "LOAD_FIXNUM"
               (CC-opIor
                (CC-MacroCall "GET_FIXNUM" x)
                (CC-MacroCall "GET_FIXNUM" y))
               (CC-dest *result-spec*)))

;;------------------------------------------------------------------------------
(defun cg-%logxor (x y)
  (setq x (CC-get-arg x))
  (setq y (CC-get-arg y))
  (C-MacroCall "LOAD_FIXNUM"
               (CC-op^
                (CC-MacroCall "GET_FIXNUM" x)
                (CC-MacroCall "GET_FIXNUM" y))
               (CC-dest *result-spec*)))

;;------------------------------------------------------------------------------
(defun cg-%logand (x y)
  (setq x (CC-get-arg x))
  (setq y (CC-get-arg y))
  (C-MacroCall "LOAD_FIXNUM"
               (CC-op&
                (CC-MacroCall "GET_FIXNUM" x)
                (CC-MacroCall "GET_FIXNUM" y))
               (CC-dest *result-spec*)))

;;------------------------------------------------------------------------------
(defun cg-%lognot (x)
  (setq x (CC-get-arg x))
  (C-MacroCall "LOAD_FIXNUM"
               (CC-op~
                (CC-MacroCall "GET_FIXNUM" x))
               (CC-dest *result-spec*)))

;;------------------------------------------------------------------------------
(defun cg-%shift-right (i c)
  (setq i (CC-get-arg i))
  (setq c (CC-get-arg c))
  (C-MacroCall "LOAD_FIXNUM"
               (CC-op>>
                (CC-MacroCall "GET_FIXNUM" i)
                (CC-MacroCall "GET_FIXNUM" c))
               (CC-dest *result-spec*)))

;;------------------------------------------------------------------------------
(defun cg-%shift-left (i c)
  (setq i (CC-get-arg i))
  (setq c (CC-get-arg c))
  (C-MacroCall "LOAD_FIXNUM"
               (CC-op<<
                (CC-MacroCall "GET_FIXNUM" i)
                (CC-MacroCall "GET_FIXNUM" c))
               (CC-dest *result-spec*)))

;;------------------------------------------------------------------------------
(provide "cginline")
