/* Common Definition for YY-server
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: yydefs.h,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.1 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include "conf.h"

typedef int	bool;
typedef u_char	byte;

/* #define private		static */

#define TRUE		1
#define FALSE		0

#define EOS		'\0'
#define EOL		'\n'
#define SINGLEQUOTE	'\''
#define DOUBLEQUOTE	'\"'
#define BACKSLASH	'\\'
#define ERR		(-1)

extern int YyErrNo;
extern int SysErrNo;

extern char *getenv();
extern char *malloc();

#define xalloc	malloc
#define xfree	free

#define strSAME(s1,s2)		(strcmp((s1),(s2))==0)
#define strnSAME(s1,s2,n)	(strncmp((s1),(s2),(n))==0)
#define MAX(a1,a2)		((a1)>(a2)?(a1):(a2))
#define MIN(a1,a2)		((a1)<(a2)?(a1):(a2))
#define XOR(a1,a2)		((a1)^(a2))

#include <errno.h>
#include <sys/time.h>
#include <sysexits.h>
#include "yydefault.h"

#define KEYINPUTBUFLEN		80

#define YYPI2		23040	/* 64*360 */
#define YYPI3_2		17280	/* 64*270 */
#define YYPI		11520	/* 64*180 */
#define YYPI_2		5760	/* 64*90 */

extern char *Version;

extern void cleanup();
extern void warning();
extern char *mamALLOC();
extern char *mamCALLOC();
#define memFREE(s)			free((char *)(s))
extern char *strDUP();

#ifdef DEBUG
#define DebugSetFunc(type,func)		debug_setfunc(type,func)
#define DebugEndFunc(type,func)		debug_endfunc(func)
#define DebugON(l)			debug_on(l)
#define DebugPrint0(l,f)		debug_print(l,f)
#define DebugPrint1(l,f,a1)		debug_print(l,f,a1)
#define DebugPrint2(l,f,a1,a2)		debug_print(l,f,a1,a2)
#define DebugPrint3(l,f,a1,a2,a3)	debug_print(l,f,a1,a2,a3)
#define DebugPrint4(l,f,a1,a2,a3,a4)	debug_print(l,f,a1,a2,a3,a4)
#define DebugPrint5(l,f,a1,a2,a3,a4,a5)	debug_print(l,f,a1,a2,a3,a4,a5)
#define DebugPrint6(l,f,a1,a2,a3,a4,a5,a6)	\
    debug_print(l,f,a1,a2,a3,a4,a5,a6)
#define DebugPrint7(l,f,a1,a2,a3,a4,a5,a6,a7)	\
    debug_print(l,f,a1,a2,a3,a4,a5,a6,a7)
#define DebugPrint8(l,f,a1,a2,a3,a4,a5,a6,a7,a8)	\
    debug_print(l,f,a1,a2,a3,a4,a5,a6,a7,a8)
#define DebugPrint9(l,f,a1,a2,a3,a4,a5,a6,a7,a8,a9)	\
    debug_print(l,f,a1,a2,a3,a4,a5,a6,a7,a8,a9)
#else /*!DEBUG*/
#define DebugSetFunc(type,func)
#define DebugEndFunc(type,func)
#define DebugON(l)			0
#define DebugPrint0(lvl,fmt)
#define DebugPrint1(lvl,fmt,a1)
#define DebugPrint2(lvl,fmt,a1,a2)
#define DebugPrint3(lvl,fmt,a1,a2,a3)
#define DebugPrint4(l,f,a1,a2,a3,a4)
#define DebugPrint5(l,f,a1,a2,a3,a4,a5)
#define DebugPrint6(l,f,a1,a2,a3,a4,a5,a6)
#define DebugPrint7(l,f,a1,a2,a3,a4,a5,a6,a7)
#define DebugPrint8(l,f,a1,a2,a3,a4,a5,a6,a7,a8)
#define DebugPrint9(l,f,a1,a2,a3,a4,a5,a6,a7,a8,a9)
#endif /*!DEBUG*/

/* $@F|K\8l(J EUC $@=hM}$N$?$a$NDj5A(J
 */
#define EUC_TOP		0200
#define EUC_SS2		0xfe
#define EUC_SS3		0xfd
/*
 * extern int JEUCByteTable[];
 * extern int JEUCDLenTable[];
 * extern int JEUCWidthTable[];
 */
#define JEUC_CodeSet(ptr)	(*(ptr)&EUC_TOP? (*(ptr)==EUC_SS2? 2: \
						  *(ptr)==EUC_SS3? 3: 1): 0)
/* $@J8;z%3!<%I$N%P%$%H?t$rF@$k(J */
#define JEUC_Bytes(ptr)		(*(ptr)&EUC_TOP? (*(ptr)==EUC_SS2? 2: \
						  *(ptr)==EUC_SS3? 3: 2): 1)
/* $@J8;z%3!<%I$N%3!<%IK\BN$N%P%$%H?t$rF@$k(J */
#define JEUC_DLen(ptr)		(*(ptr)&EUC_TOP? (*(ptr)==EUC_SS2? 1: 2): 1)
/* $@J8;z%3!<%I$NI8=`E*$JI}$rF@$k(J */
#define JEUC_Width(ptr)		(*(ptr)&EUC_TOP? (*(ptr)==EUC_SS2? 1: 2): 1)

extern int JEUC_StrLen(/*int nchar, u_char *str*/);	/*$@%P%$%H?t$rF@$k(J*/
extern int JEUC_StrNChar(/*int leng, u_char *str*/);	/*$@J8;z?t$rF@$k(J*/

/* Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
