/* Functions for Handling Windows on X11R4
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: xwindow.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $
 */

#ifndef lint
static char *RcsId =
    "$Id: xwindow.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.4 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.1 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/27 08:10:20 $
 ****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"
#include "sched.h"
#include <X11/keysym.h>

static void key_press();
static void parse_event();
static void parse_mouse_motion_event();
static void report_mouse_event();
static void parse_button_press_event();
static void parse_button_release_event();

static void x_mouse_stay_timer();

/*
 * X Window System ˤ륨顼ѥåȤȤä
 * ƤӽФϥɥ
 *
 *  YY-client Τ⤷ʤ
 */
static int x_err_handler(disp, er)
    Display *disp;
    XErrorEvent *er;
{
    char message[128];
    extern char *get_x11_request_name();
    XGetErrorText(disp, er->error_code, message, sizeof(message));
    warning("Error on X-Protocol (%s)\n", message);
    warning(" Error Code: %d\n", er->error_code);
    warning(" Request Code: %d (%s)\n", er->request_code,
	    get_x11_request_name(er->request_code));
    warning(" Minor Code: %d\n", er->minor_code);
}

static int x_io_err_handler(disp)
    Display *disp;
{
    cleanup(EX_OK, "X Connection has been closed...\n");
}

set_error_handler()
{
    XSetErrorHandler(x_err_handler);
    XSetIOErrorHandler(x_io_err_handler);
}

/* void sync_x_server(xp)
 *
 * X server ФƤޤäƤХѥåȤǤФ
 */
void sync_x_server(xp)
    x_private *xp;
{
    XFlush(xp->xDisp);
}

sync_x_server_sp(xp)
    x_private *xp;
{
    XSync(xp->xDisp,1);
}


/**********************************************************************
  ***
  ***  Enter/Leave ٥Ȥν
  ***
  **********************************************************************/

/*
 */
static void parse_mouse_enter_event(ch, tr, ep)
    yy_comm_channel *ch;
    register territory_entry *tr;
    XEvent *ep;
{
    x_private *xp = XPRIVATE(ch);
    XEvent save;
    int mask;

    DebugSetFunc("xwindow-event", "parse_mouse_enter_event");
    /* äǤɤ餫ξѲƤΤ
     * ޤǤ STAY ƻϰ̣ʤʤ
     */
    if (tr->teEventMask & YYMASK_STAY)
	yysched_delque(ch, tr->teID, YYSCHED_TYPE_MOUSE_STAY, (-1));

    mask = (ep->type==EnterNotify? YYMASK_ENTER: YYMASK_LEAVE);
    if (tr->teEventMask & mask) {
	DebugPrint2(5, "%sNotify in TR#%d\n",
		    (ep->type==EnterNotify? "Enter": "Leave"), tr->teID);
	report_mouse_event(ch, tr->teID, mask,
			   ep->xcrossing.x, ep->xcrossing.y);
#ifdef STAYDEBUG
	printf("%sNotify in TR#%d\n",
	       (ep->type==EnterNotify? "Enter": "Leave"), tr->teID);
#endif
    }

    if (tr->teEventMask & YYMASK_STAY) {
	if (ep->type == EnterNotify) {
	    /* äΤǤ STAY δƻϤ
	     */
	    memcpy(&xp->xLastPointer, ep, sizeof(XEvent));
	} else {
	    /* Υ줿Τ */
	    xp->xLastPointer.type = LeaveNotify;
	}
    }
    DebugEndFunc("xwindow-event", "parse_mouse_enter_event");
    /*NoReturnValue*/
}





/**********************************************************************
 *****
 *****  X Window ǤΥ٥ȼ
 *****
 **********************************************************************/

/* void get_events_on_x_server(ch, wait_network)
 *
 * X server ȤäƤ륤٥Ȥ
 * ΤΰĤϤ
 * ȤäƤʤϲ(֥å⤷ʤ)
 *  Τޤ޴ؿλ
 * ޤʣΥ٥ȤȤäƤǤäƤ⡤
 *  ٤˽ΤϰĤǤ
 */
get_events_on_x_server(ch, wait_network)
    yy_comm_channel *ch;
    bool wait_network;
{
    x_private *xp = XPRIVATE(ch);
    XEvent event;
    int i;
    DebugSetFunc("xwindow-event", "get_events_on_x_server");
#ifdef KOSAKA921021
    /* 1992.10.21 ȯɽΤΤäĤ patch */
    if (XEventsQueued(xp->xDisp, QueuedAfterReading) == 0)
	XNoOp(xp->xDisp);
#endif /*KOSAKA921021*/
    while ((i = XEventsQueued(xp->xDisp, QueuedAfterReading))) {
	DebugPrint1(1, "XQUEUE has %d events\n", i);
	XNextEvent(xp->xDisp, &event);
	DebugPrint1(1, "Catch Event from X Server %d\n", event.type);
	parse_event(ch, xp, &event);
    }
    DebugEndFunc("xwindow-event", "get_events_on_x_server");
    /*NoReturnValue*/
}


/* void parse_event(ch, xp, ev)
 *
 * X Window System  X server ȯ٥Ȥβ
 */
static void parse_event(ch, xp, ev)
    yy_comm_channel *ch;
    x_private *xp;
    XEvent *ev;
{
    register territory_entry *tr;
    DebugSetFunc("xwindow-event", "parse_event");
    switch (ev->type) {
    default:
	DebugPrint1(5, "Unknown Event Type %d\n", ev->type);
	break;
    case KeyPress: { /* 줿 */
	DebugPrint0(5, "KeyPress Event\n");
	tr = search_territory_from_win(ev->xexpose.window);
	if (NULLTERRITORY(tr) || !NULLTERRITORY(tr->teParent))
	    break; /* This Territory is not ROOT */
	DebugPrint1(6, "  *** KeyPress Event on TR#%d\n", tr->teID);
	key_press(ch, xp, ev);
	break;
    }
    case KeyRelease: /* Υ줿 */
	DebugPrint0(5, "KeyRelease Event\n");
	break;
    case ButtonPress: { /* ޥܥ󤬲줿 */
	DebugPrint0(5, "ButtonPress Event\n");
	/*
	 * β줿٥ȤФƤȤΥ٥Ȥɬפ«
	 *  ʤ褦ˤ (źˤ)
	 * դˡˤä ButtonPress бʤ ButtonRelease 
	 *  褦ʤȤ⤢
	 */
	XUngrabPointer(xp->xDisp, ev->xbutton.time);
	if (!ch->ccXEventEnable)
	    break; /* ٥ȼդ֤ˤʤ */
	tr = search_territory_from_win(ev->xbutton.window);
	if (NULLTERRITORY(tr) ||
	    !(tr->teEventMask & (YYMASK_BUTTON_PRESS|YYMASK_DOUBLE_CLICK)))
	    break; /* ʤ */
	DebugPrint1(6, "  *** ButtonPress Event on TR#%d\n", tr->teID);
	parse_button_press_event(ch, tr, ev);
	break;
    }
    case ButtonRelease: { /* ޥܥΥ줿 */
	DebugPrint0(5, "ButtonRelease Event\n");
	tr = search_territory_from_win(ev->xbutton.window);
	if (NULLTERRITORY(tr) ||
	    !(tr->teEventMask & (YYMASK_BUTTON_RELEASE|YYMASK_DOUBLE_CLICK)))
	    break; /* Uuum.. What's this? */
	DebugPrint1(6, "  *** ButtonRelease Event on TR#%d\n", tr->teID);
	parse_button_release_event(ch, tr, ev);
	break;
    }
    case MotionNotify: {
	DebugPrint0(5, "MotionNotify Event\n");
	tr = search_territory_from_win(ev->xmotion.window);
	if (!NULLTERRITORY(tr)) {
	    DebugPrint1(6, "  *** Event on Territory#%d\n", tr->teID);
	    parse_mouse_motion_event(ch, tr, ev);
	}
	break;
    }
    case EnterNotify:
    case LeaveNotify: {
	int mask;
	mask = (ev->type == EnterNotify? YYMASK_ENTER: YYMASK_LEAVE);
	DebugPrint1(5, "%sNotify Event\n",
		    (ev->type == EnterNotify? "Enter": "Leave"));
	tr = search_territory_from_win(ev->xcrossing.window);
	if (!NULLTERRITORY(tr)) {
	    DebugPrint1(6, "  *** Event on TR#%d\n", tr->teID);
	    parse_mouse_enter_event(ch, tr, ev);
	}
	break;
    }
    case FocusIn:
	DebugPrint0(5, "FocusIn Event\n");
	break;
    case FocusOut:
	DebugPrint0(5, "FocusOut Event\n");
	break;
    case KeymapNotify:
	DebugPrint0(5, "KeymapNotify Event\n");
	break;
    case Expose: {
	DebugPrint1(5, "Expose Event (Count:%d)\n", ev->xexpose.count);
	/* if (ev->xexpose.count > 0)
	 * break; /* We may have more Expose event */
	tr = search_territory_from_win(ev->xexpose.window);
	if(tr != (TERRITORY *)NULL && IsVisibleTerritory(tr)) {
	    static void do_expose();
	    do_expose(XPRIVATE(ch), tr, ev);
	    ch->ccXNeedFlush = TRUE;
	}
	break;
    }
    case GraphicsExpose:
	DebugPrint0(5, "GraphicsExpose Event\n");
	break;
    case NoExpose:
	DebugPrint0(5, "NoExpose Event\n");
	break;
    case VisibilityNotify:
	DebugPrint0(5, "VisibilityNotify Event\n");
	break;
    case CreateNotify:
	DebugPrint0(5, "CreateNotify Event\n");
	break;
    case DestroyNotify:
	DebugPrint0(5, "DestroyNotify Event\n");
	break;
    case UnmapNotify:
	DebugPrint0(5, "UnmapNotify Event\n");
	break;
    case MapNotify:
	DebugPrint0(5, "MapNotify Event\n");
	break;
    case MapRequest:
	DebugPrint0(5, "MapRequest Event\n");
	break;
    case ReparentNotify:
	DebugPrint0(5, "ReparentNotify Event\n");
	break;
    case ConfigureNotify:
	DebugPrint0(5, "ConfigureNotify Event\n");
	break;
    case ConfigureRequest:
	DebugPrint0(5, "ConfigureRequest Event\n");
	break;
    case GravityNotify:
	DebugPrint0(5, "GravityNotify Event\n");
	break;
    case ResizeRequest:
	DebugPrint0(5, "ResizeRequest Event\n");
	break;
    case CirculateNotify:
	DebugPrint0(5, "CirculateNotify Event\n");
	break;
    case CirculateRequest:
	DebugPrint0(5, "CirculateRequest Event\n");
	break;
    case PropertyNotify:
	DebugPrint0(5, "PropertyNotify Event\n");
	break;
    case SelectionClear:
	DebugPrint0(5, "SelectionClear Event\n");
	break;
    case SelectionRequest:
	DebugPrint0(5, "SelectionRequest Event\n");
	break;
    case SelectionNotify:
	DebugPrint0(5, "SelectionNotify Event\n");
	break;
    case ColormapNotify:
	DebugPrint0(5, "ColormapNotify Event\n");
	break;
    case ClientMessage:
	DebugPrint0(5, "ClientMessage Event\n");
	break;
    case MappingNotify:
	DebugPrint0(5, "MappingNotify Event\n");
	break;
    }
    DebugEndFunc("xwindow-event", "parse_event");
}


/* do_expose(xp, tr, ev)
 *
 * ɥ Expose 줿Τ
 * ƥȥȤκɽԤʤ
 */
static void do_expose(xp, tr, ev)
    register x_private *xp;
    register TERRITORY *tr;
    register XEvent *ev;
{
    register TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);

    DebugSetFunc("xwindow-event", "do_expose");
    if (IsDrawableTerritory(tr)) {
	DebugPrint5(5, " TR#%d - Copy from Pixmap (%d,%d)[%d,%d]\n",
		    tr->teID, ev->xexpose.x, ev->xexpose.y,
		    ev->xexpose.width, ev->xexpose.height);
	XSetFunction(xp->xDisp, tx->txGC, GXcopy);
	if (tx->txPixmap == (Pixmap)NULL)
	    printf(" TR#%d has illegal Pixmap!!\n", tr->teID);
	if (tx->txWindow == (Window)NULL)
	    printf(" TR#%d has illegal Window!!\n", tr->teID);
	XCopyArea(xp->xDisp, tx->txPixmap, tx->txWindow,
		  tx->txGC, ev->xexpose.x, ev->xexpose.y,
		  ev->xexpose.width, ev->xexpose.height,
		  ev->xexpose.x, ev->xexpose.y);
#ifndef IPA_PATCH T.kosaka
	/* For SPLITE */
	redraw_splite_territory(tr);
#endif 
    } else if (tr->teTRType != TR_FENCE && tx->txWindow != (Window)NULL) {
	DebugPrint5(5, " Clear TR#%d - (%d,%d)[%d,%d]\n",
		    tr->teID, ev->xexpose.x, ev->xexpose.y,
		    ev->xexpose.width, ev->xexpose.height);
	XSetFunction(xp->xDisp, tx->txGC, GXclear);
	XClearArea(xp->xDisp, tx->txWindow,
		   ev->xexpose.x, ev->xexpose.y,
		   ev->xexpose.width, ev->xexpose.height,
		   False);
    }
    DebugEndFunc("xwindow-event", "do_expose");
    return;
}

/**********************************************************************
 ***
 ***  ޥܥ佤ξ֤ǧ
 ***
 **********************************************************************/

/* parse_button_state(em, press_or_release, st)
 *
 * X Window System ˤޥܥȽξ֤Ϥ
 *
 * press_or_release  YYMASK_BUTTON_PRESS  YYMASK_BUTTON_RELEASE
 *  ޤϤह mask ǤФбޥܥξ֤
 *  ͤ˴ޤ
 */
int parse_button_state(em, press_or_release, st)
    int em;	/* YYonX ˤEvent Mask */
    int press_or_release; /* ޥܥ Press/Release  */
    int st;	/* Status */
{
    int mask = 0;
    DebugSetFunc("xwindow-event", "parse_button_state");
    /* ޥܥ Press/Release ֤μ */
    press_or_release &= em; /* ǰΤ */
    if (st & Button3Mask) mask |= (press_or_release & YYMASK_RIGHT_BUTTON);
    if (st & Button2Mask) mask |= (press_or_release & YYMASK_MIDDLE_BUTTON);
    if (st & Button1Mask) mask |= (press_or_release & YYMASK_LEFT_BUTTON);

    /* ξ֤μ */
    if (st & Mod1Mask)		mask |= (em & YYMASK_META);
    if (st & ControlMask)	mask |= (em & YYMASK_CTRL);
    if (st & ShiftMask)		mask |= (em & YYMASK_SHIFT);
    DebugEndFunc("xwindow-event", "parse_button_state");
    return mask;
}

/**********************************************************************
 ***
 ***  X Window ˤޥܥ󥤥٥Ȥμ갷
 ***
 **********************************************************************/

#define CROSSINGSTATE(tr,tm,ev,em)	(((tr)->teEventMask & (tm)) && \
					 ((ev)->xcrossing.state & (em)))

/*
 *
 * ܥ󤬲줿ν
 */
#define MAX_X_BUTTON			3
struct x_yy_button_mask {
    int x_button;
    int yy_mask, yy_double;
} ;
static struct x_yy_button_mask x_yy_press_mask[MAX_X_BUTTON] = {
    { Button1, YYMASK_LEFT_PRESS, YYMASK_LEFT_DOUBLE },
    { Button2, YYMASK_MIDDLE_PRESS, YYMASK_MIDDLE_DOUBLE },
    { Button3, YYMASK_RIGHT_PRESS, YYMASK_RIGHT_DOUBLE },
};
static struct x_yy_button_mask x_yy_release_mask[MAX_X_BUTTON] = {
    { Button1, YYMASK_LEFT_RELEASE, YYMASK_LEFT_DOUBLE },
    { Button2, YYMASK_MIDDLE_RELEASE, YYMASK_MIDDLE_DOUBLE },
    { Button3, YYMASK_RIGHT_RELEASE, YYMASK_RIGHT_DOUBLE },
};

/*
 *
 * YYonX ˤ륤٥ȥޥ yy_emask Ǥä
 * Press 뤤 Release Τäޥܥܥ button 
 * Ƥ鳺륤٥ȥޥξ֤
 *
 * CHECK_PRESS_MASK(yy_emask,button)  Press Ф
 * CHECK_RELEASE_MASK(yy_emask,button)  Release Ф
 * åԤʤΥޥǤ
 */
#define CHECK_PRESS_MASK(e,b)	check_button_mask((e),(b),x_yy_press_mask)
#define CHECK_RELEASE_MASK(e,b)	check_button_mask((e),(b),x_yy_release_mask)

static int check_button_mask(yy_emask, button, tbl)
    register int yy_emask;
    register int button;
    register struct x_yy_button_mask *tbl;
{
    register int mask = 0;
    register int size;
    for (size = MAX_X_BUTTON; size > 0; tbl++, size--)
	if (button == tbl->x_button)
	    mask |= ((yy_emask&tbl->yy_mask)|(yy_emask&tbl->yy_double));
    return mask;
}

/* bool on_same_point(ch, tr, ev)
 *
 * ޥܥ󥤥٥ ev  tr ˵ϿƤܥ󥤥٥Ȥ
 *  ƱܥǤɸ礭ƤʤȤ TRUE
 *  Ǥʤ FALSE ֤
 */
static bool on_same_point(ch, tr, ev)
    yy_comm_channel *ch;
    register territory_entry *tr;	/* оݤȤʤäƤƥȥ */
    XEvent *ev;
{
    register int loop;
    register XEvent *ep;

    DebugSetFunc("xwindow-event", "on_same_point");
    ep = tr->teEventRecord;
    for (loop = tr->teEventNum; loop > 0 ; ep++, loop--) {
	register int xd = ep->xbutton.x - ev->xbutton.x;
	register int yd = ep->xbutton.y - ev->xbutton.y;
	if (ep->xbutton.button != ev->xbutton.button) break;
	if (xd*xd > ch->ccXDClickRegion || yd*yd > ch->ccXDClickRegion) break;
    }
    DebugEndFunc("xwindow-event", "on_same_point");
    return (loop==0);
}

/* static bool in_dclick_interval(ch, tr, ev)
 *
 * ޥܥ󥤥٥ ev  tr κǽ˵ϿƤܥ󥤥٥ȤФ
 *  ֥륯åȹ֤ͤۤƤʤ TRUE
 *  Ǥʤ FALSE ֤
 */
static bool in_dclick_interval(ch, tr, ev)
    yy_comm_channel *ch;
    register territory_entry *tr;	/* оݤȤʤäƤƥȥ */
    XEvent *ev;
{
    register bool ret = TRUE;
    DebugSetFunc("xwindow-event", "in_dclick_interval");
    if (tr->teEventNum > 0) {
	register Time t1 = tr->teEventRecord[0].xbutton.time;
	register Time t2 = ev->xbutton.time;
	if (t1 <= t2) {
	    ret = ((t2-t1) <= ch->ccXDClickInterval);
	} else {
	    /* t1  t2 δ֤˥󥿤ꥻåȤƤ.. */
	    ret = (((~t1)+t2+1) <= ch->ccXDClickInterval);
	}
    }
    DebugEndFunc("xwindow-event", "in_dclick_interval");
    return ret;
}

/*
 *
 * ϿƤޥܥ Press/Release 
 * YY-client  max ĤΤ
 */
static void report_recorded_events(ch, tr, max)
    yy_comm_channel *ch;
    register territory_entry *tr;	/* оݤȤʤäƤƥȥ */
    register int max;
{
    register int loop;
    register int emask = tr->teEventMask;
    register XEvent *ep, *ep2;

    DebugSetFunc("xwindow-event", "report_recorded_events");
    if (max > tr->teEventNum) max = tr->teEventNum;
    /* max Ĥ Press/Release 𤹤 */
    ep = tr->teEventRecord;
    for (loop = 0; loop < max ; ep++, loop++) {
	register int m;
	if ((loop % 2) == 0) {
	    m = CHECK_PRESS_MASK(emask, ep->xbutton.button);
	    m &= YYMASK_BUTTON_PRESS;
#ifdef DCLICKDEBUG
	    printf("Recorded Button Press on TR#%d\n", tr->teID);
#endif /*DCLICKDEBUG*/
	} else {
	    m = CHECK_RELEASE_MASK(emask, ep->xbutton.button);
	    m &= YYMASK_BUTTON_RELEASE;
#ifdef DCLICKDEBUG
	    printf("Recorded Button Release on TR#%d\n", tr->teID);
#endif /*DCLICKDEBUG*/
	}
	if (m == 0) continue; /* ɬפʤϿǤ */
	DebugPrint2(3, "Button#%d, State 0%o\n",
		    ep->xbutton.button, ep->xbutton.state);
	m |= parse_button_state(tr->teEventMask, 0, ep->xbutton.state);
	report_mouse_event(ch, tr->teID, m, ep->xbutton.x, ep->xbutton.y);
    }

    /* Ĥä٥ȤξǼľ */
    ep2 = tr->teEventRecord;
    for (loop = max; loop < tr->teEventNum; loop++, ep++, ep2++)
	memcpy(ep2, ep, sizeof(XEvent));
    tr->teEventNum -= max;
    DebugEndFunc("xwindow-event", "report_recorded_events");
    /*NoReturnValue*/
}

/*
 *
 * ֥륯åоݤȤʤäƤ Press/Release ξФ
 * ֥륯åΤλ֤᤮Ƥޤä˸ƤӽФ
 */
static void x_mouse_event_timer(ch, myself, id, type, flag, tp, delay)
    int (*myself)();		/* ʬ */
    int id;			/* оݥƥȥ ID */
    int type;			/* ؿΥ */
    int flag;			/* ­ */
    struct timeval *tp;		/* 赯ưϤλ */
    long delay;			/* εư֤٤ */
{
    /* ֤ΤǵϿ 1 Ĥ 2 Ĥ
     */
    register TERRITORY *tr;
    DebugSetFunc("xwindow-event", "x_mouse_event_timer");
    tr = search_territory(id);
    if (!NULLTERRITORY(tr)) {
	register int max = (tr->teEventNum > 1? 2: 1);
	report_recorded_events(ch, tr, max);
	/* ʬȤϥ塼ϤϤƤΤ
	 * ĤäΤ򥭥塼鳰 */
	if (max > 1) yysched_delque(ch, id, YYSCHED_TYPE_MOUSE_CLICK, 1);
    } else {
	/* ٤ƤΥ޴ؿ򰮤Ĥ֤Ƥޤ */
	yysched_delque(ch, id, YYSCHED_TYPE_MOUSE_CLICK, (-1));
	tr->teEventNum = 0;
    } 
    DebugEndFunc("xwindow-event", "x_mouse_event_timer");
    /*NoReturnValue*/
}


/*
 * ޥܥ󤬲줿˸ƤӽФ
 */
static void parse_button_press_event(ch, tr, ev)
    yy_comm_channel *ch;
    register territory_entry *tr;	/* оݤȤʤäƤƥȥ */
    XEvent *ev;
{
    int mask = 0;
    DebugSetFunc("xwindow-event", "parse_button_press_event");
    DebugPrint2(3, "Button: 0%o - EventMask: 0%o\n",
		ev->xbutton.button, tr->teEventMask);
    /* Υƥȥ Press ξɬפ뤫ɤȽǤ
     */
    mask = CHECK_PRESS_MASK(tr->teEventMask, ev->xbutton.button);
    if (mask != 0) {
	/* Υ٥ȤϤΥƥȥоݤȤƲϤ
	 * ˥٥ȤϿƤ硤
	 *  1) 줬2ۤ¸ߤ
	 *     뤤ϵϿ¸ߤ
	 *  2) ֥륯åоݤˤʤäƤʤ
	 *  3) ֥륯åֳ֤᤮Ƥ
	 *  4) ֥륯åɸ礭ۤʤ
	 * Τ줫ξ郎ΩˤϲεϿ𤷤Ƥޤ
	 * Υ٥ȤܤΥ٥ȤȤ
	 */
	if (tr->teEventNum > 2 || tr->teEventNum == 1 ||
	    !(mask & YYMASK_DOUBLE_CLICK) ||
	    !on_same_point(ch, tr, ev) || !in_dclick_interval(ch, tr, ev)) {
	    /* ٤ƤεϿƤ륤٥Ȥ𤷤
	     * 塼ϿƤʤ餳
	     */
	    report_recorded_events(ch, tr, tr->teEventNum);
	    yysched_delque(ch, tr->teID, YYSCHED_TYPE_MOUSE_CLICK, (-1));
	    /* νä ev ǽ Press ٥ȤȤ
	     *  */
	}

	if (mask & YYMASK_DOUBLE_CLICK) {
	    /* ֥륯åоݤʤΤǤϿ
	     * ޤꤹ
	     */
	    memcpy(&tr->teEventRecord[tr->teEventNum], ev, sizeof(XEvent));
	    tr->teEventNum++;
	    yysched_addque(ch, x_mouse_event_timer,
			   tr->teID, YYSCHED_TYPE_MOUSE_CLICK, 0,
			   (struct timeval *)NULL, ch->ccXDClickInterval);
#ifdef DCLICKDEBUG
	    printf("%s Button Press for Double Clink on TR#%d\n",
		   (tr->teEventNum > 1? "2nd": "1st"), tr->teID);
#endif /*DCLICKDEBUG*/
	} else if (mask & YYMASK_BUTTON_PRESS) {
	    /* ܥ Press  */
	    mask &= YYMASK_BUTTON_PRESS;
	    DebugPrint2(3, "Button#%d, State 0%o\n",
			ev->xbutton.button, ev->xbutton.state);
	    mask |= parse_button_state(tr->teEventMask, 0, ev->xbutton.state);
	    report_mouse_event(ch, tr->teID, mask,
			       ev->xbutton.x, ev->xbutton.y);
#ifdef DCLICKDEBUG
	    printf("Normal Button Press on TR#%d\n", tr->teID);
#endif /*DCLICKDEBUG*/
	}
	/* ǤΥƥȥΥܥ󥤥٥ȽϽλ */
    } else {
	/* ƤΥƥȥ˥٥ȥޥåȤƤʤ
	 * ǽԤʤ (źˤ뽤) */
	if (!NULLTERRITORY(tr->teParent)) {
	    ev->xbutton.x += tr->teX; /* ʤȤ... */
	    ev->xbutton.y += tr->teY;
	    parse_button_press_event(ch, tr->teParent, ev);
	}
    }
    DebugEndFunc("xwindow-event", "parse_button_press_event");
    /*NoReturnValue*/
}



static void parse_button_release_event(ch, tr, ev)
    yy_comm_channel *ch;
    register territory_entry *tr;
    XEvent *ev;
{
    int mask = 0;

    DebugSetFunc("xwindow-event", "parse_button_release_event");
    DebugPrint2(3, "Button: 0%o - EventMask: 0%o\n",
		ev->xbutton.button, tr->teEventMask);

    mask = CHECK_RELEASE_MASK(tr->teEventMask, ev->xbutton.button);
    if (mask != 0) {
	/* Υ٥ȤϤΥƥȥоݤȤƲϤ
	 * ˥٥ȤϿƤ硤
	 *  1) 줬3ۤ¸ߤ
	 *     뤤ϵϿ¸ߤ
	 *  2) ֥륯åоݤˤʤäƤʤ
	 *  3) ֥륯åֳ֤᤮Ƥ
	 *  4) ֥륯åɸ礭ۤʤ
	 * Τ줫ξ郎Ωˤ
	 * ߤεϿۤʤĤνԤʤ
	 * ⤦ټʬȤƤӽФ
	 */
	if (tr->teEventNum > 0 &&
	    (tr->teEventNum > 3 || tr->teEventNum == 2 ||
	     !(mask & YYMASK_DOUBLE_CLICK) ||
	     !on_same_point(ch, tr, ev) || !in_dclick_interval(ch, tr, ev))) {
	    /* ϿƤ륤٥Ȥ𤷤
	     * 塼ϿƤʤ
	     */
	  int max = 2;
	    DebugPrint2(5, "Delete %d Queue on Scheduler on TR#%d\n",
			max, tr->teID);
	    report_recorded_events(ch, tr, max);
	    yysched_delque(ch, tr->teID, YYSCHED_TYPE_MOUSE_CLICK, max);
	    parse_button_release_event(ch, tr, ev);
	    /* äƤ餳νϽ */
	} else if (tr->teEventNum > 0 && (mask & YYMASK_DOUBLE_CLICK)) {
	    /* ֥륯åо */
	    if (tr->teEventNum == 3) {
		/* ֥륯åλΤǤ */
		mask &= YYMASK_DOUBLE_CLICK;
		DebugPrint2(3, "Double Click - Button#%d, State 0%o\n",
			    ev->xbutton.button, ev->xbutton.state);
		mask |= parse_button_state(tr->teEventMask, 0,
					   ev->xbutton.state);
		report_mouse_event(ch, tr->teID, mask,
				   ev->xbutton.x, ev->xbutton.y);
		yysched_delque(ch, tr->teID, YYSCHED_TYPE_MOUSE_CLICK, (-1));
		tr->teEventNum = 0;
#ifdef DCLICKDEBUG
		printf("Double Click on TR#%d\n", tr->teID);
#endif /*DCLICKDEBUG*/
	    } else {
		/* ܤ Release ȤƵϿ */
		DebugPrint1(5, "1st Release on Double Click on TR#%d\n",
			    tr->teID);
		memcpy(&tr->teEventRecord[tr->teEventNum], ev, sizeof(XEvent));
		tr->teEventNum++;
		yysched_addque(ch, x_mouse_event_timer,
			       tr->teID, YYSCHED_TYPE_MOUSE_CLICK, 0,
			       (struct timeval *)NULL, ch->ccXDClickInterval);
#ifdef DCLICKDEBUG
		printf("1st Button Release for Double Click on TR#%d\n",
		       tr->teID);
#endif /*DCLICKDEBUG*/
	    }
	} else if (mask & YYMASK_BUTTON_RELEASE) {
	    /* ܥ Release  */
	    mask &= YYMASK_BUTTON_RELEASE;
	    DebugPrint2(3, "Release Button#%d, State 0%o\n",
			ev->xbutton.button, ev->xbutton.state);
	    mask |= parse_button_state(tr->teEventMask, 0, ev->xbutton.state);
	    report_mouse_event(ch, tr->teID, mask,
			       ev->xbutton.x, ev->xbutton.y);
#ifdef DCLICKDEBUG
	    printf("Normal Button Release on TR#%d\n", tr->teID);
#endif /*DCLICKDEBUG*/
	}
	/* ǤΥƥȥΥܥ󥤥٥ȽϽλ */
    } else {
	/* ƤΥƥȥ˥٥ȥޥåȤƤʤ
	 * ǽԤʤ (źˤ뽤) */
	if (!NULLTERRITORY(tr->teParent)) {
	    ev->xbutton.x += tr->teX; /* ʤȤ... */
	    ev->xbutton.y += tr->teY;
	    parse_button_release_event(ch, tr->teParent, ev);
	}
    }
    DebugEndFunc("xwindow-event", "parse_button_release_event");
    /*NoReturnValue*/
}

/**********************************************************************
 ***
 ***  X Window ˤޥư٥Ȥμ갷
 ***
 **********************************************************************/

/* ֤ΤǸ֤߰ޤѹƤʤ𤹤
 */
static void x_mouse_stay_timer(ch, myself, id, type, flag, tp, delay)
    yy_comm_channel *ch;
    int (*myself)();		/* ʬ */
    int id;			/* оݥƥȥ ID */
    int type;			/* ؿΥ */
    int flag;			/* ­ */
    struct timeval *tp;		/* 赯ưϤλ */
    long delay;			/* εư֤٤ */
{
    x_private *xp = XPRIVATE(ch);
    register TERRITORY *tr;

    DebugSetFunc("xwindow-event", "x_mouse_stay_timer");
    /* ϿƤΤƱΥƥȥꡤ(X Window)ɥ
     *  ʤнϹԤʤʤ
     * ޤΥƥȥ STAY ФؼƤʤ
     *  Ԥʤʤ
     */
    tr = search_territory(id);
    if (NULLTERRITORY(tr) ||
	xp->xLastPointer.type != MotionNotify ||
	xp->xLastPointer.xmotion.window != tr->teXEnt.txWindow) {
	/* ƥȥ꤬Ǥ¸ߤƤʤΤǡط
	 * ĤƤƤ̣ʤ */
	/* ϿƤ륤٥Ȥ¸ߤʤΤ
	 * ޤƤޤ */
	yysched_delque(ch, id, YYSCHED_TYPE_MOUSE_STAY, (-1));
    } else {
	/* ǽŪʰ֤ª */
	XEvent *ep = &xp->xLastPointer;
	Window r, c;
	int r_x, r_y, w_x, w_y;
	unsigned int m;
	Bool same_screen, do_report;

#ifdef METHOD1
	if (XQueryPointer(ep->xmotion.display, ep->xmotion.window,
			  &r, &c, &r_x, &r_y, &w_x, &w_y, &m)) {
	    register int xd = w_x - ep->xmotion.x;
	    register int yd = w_y - ep->xmotion.y;
	    if (xd*xd <= ch->ccXDClickRegion &&
		yd*yd <= ch->ccXDClickRegion &&
		m == ep->xmotion.state) {
		/* 𤹤٤֤Ǥ */
		register int mask = YYMASK_STAY;
		mask |= parse_button_state(tr->teEventMask,
					   YYMASK_BUTTON_PRESS, m);
		report_mouse_event(ch, tr->teID, mask, w_x, w_y);
#ifdef STAYDEBUG
		printf("PointerStay in TR#%d at %ld.%ld (delay:%d)\n",
		       tr->teID, tp->tv_sec, tp->tv_usec, delay);
#endif /*STAYDEBUG*/
		yysched_delque(ch, id, YYSCHED_TYPE_MOUSE_STAY, (-1));
		xp->xLastPointer.type = LASTEvent;
	    } else {
		/* ߤξ֤Ͽơ򿷤 STAY оݤȤ
		 * ϿƤ */
		ep->xmotion.x = w_x;
		ep->xmotion.y = w_y;
		ep->xmotion.state = m;
		yysched_delque(ch, id, YYSCHED_TYPE_MOUSE_STAY, (-1));
		yysched_addque(ch, myself, id, YYSCHED_TYPE_MOUSE_STAY,
			       YYSCHED_FLAG_SKIP, (struct timeval *)NULL,
			       ch->ccXStayInterval);
	    }
	} else {
	    /* QueryPointer Ǥʤ..
	     *  ٤ƤΥ޴ؿ򰮤Ĥ֤Ƥޤ */
	    yysched_delque(ch, id, YYSCHED_TYPE_MOUSE_STAY, (-1));
	}
#else /*!METHOD1*/
	/* 𤹤٤֤Ǥ */
	register int mask = YYMASK_STAY;
	mask |= parse_button_state(tr->teEventMask,
				   YYMASK_BUTTON_PRESS, ep->xmotion.state);
	report_mouse_event(ch, tr->teID, mask, ep->xmotion.x, ep->xmotion.y);
#ifdef STAYDEBUG
	printf("PointerStay in TR#%d at %ld.%ld (delay:%d)\n",
	       tr->teID, tp->tv_sec, tp->tv_usec, delay);
#endif /*STAYDEBUG*/
	yysched_delque(ch, id, YYSCHED_TYPE_MOUSE_STAY, (-1));
	xp->xLastPointer.type = LASTEvent; /* Υȥ̵ˤ */
#endif /*!METHOD1*/
    }
    DebugEndFunc("xwindow-event", "x_mouse_stay_timer");
    /*NoReturnValue*/
}


/*
 * ޥ MotionEvent ΰää뤿
 *  
 * ƳΥե饰򥻥åȤƤޤ
 */
static void x_mouse_motion_timer(ch, myself, id, type, flag, tp, delay)
    yy_comm_channel *ch;
    int (*myself)();		/* ʬ */
    int id;			/* оݥƥȥ ID */
    int type;			/* ؿΥ */
    int flag;			/* ­ */
    struct timeval *tp;		/* 赯ưϤλ */
    long delay;			/* εư֤٤ */
{
    /* ֤ΤǵϿ 1 Ĥ 2 Ĥ
     */
    register TERRITORY *tr;
    DebugSetFunc("xwindow-event", "x_mouse_motion_timer");
#ifdef KEISUKEDEBUG
    printf("Pirorororor...\n");
#endif
    ch->ccXMotionEnable = TRUE;
    yysched_delque(ch, (-1), YYSCHED_TYPE_MOUSE_MOTION, (-1));
    DebugSetFunc("xwindow-event", "x_mouse_motion_timer");
    /*NoReturnValue*/
}


/*
 * 뤳ȤȤƤϡ
 *  STAY ƤˤϡʬΩĤ٤Ƥ STAY Ԥ
 *   ƥ޴ؿꤹ
 *  mask  Motion 𤬵̳ŤƤ
 *   ߾֤Ǥʤ¤ꤳ𤹤
 *   ߾֤ξϡȤǻȤΤǤȤäƤ
 *    (¸Ƥ֤ Leave ɤ)
 */
static void parse_mouse_motion_event(ch, tr, ev)
    yy_comm_channel *ch;
    register territory_entry *tr;
    XEvent *ev;
{
    x_private *xp = XPRIVATE(ch);
    DebugSetFunc("xwindow-event", "parse_mouse_motion_event");

    /* ߤΥ٥ȾϿƤ
     */
    memcpy(&xp->xLastPointer, ev, sizeof(XEvent));
    ev = &xp->xLastPointer;

#ifdef FUTURE
    /* ٥ȤɤФԤʤʤ Motion Τξ
     *  ߤ뤳ȤϤꤨʤΤǤΤޤΤ
     */
    if (tr->teEventMask & YYMASK_ALL_MOTION) {
	mask = YYMASK_ALL_MOTION;
	mask |= parse_button_state(tr->teEventMask, YYMASK_BUTTON_PRESS,
				   ev->xmotion.state);
	DebugPrint1(3, "Button State 0%o\n", ev->xmotion.state);
	report_mouse_event(ch, tr->teID, mask,
			   ev->xmotion.x, ev->xmotion.y);
    } else
#endif /*FUTURE*/
	{
	    /* ٥ȤɤФԤʤ */
	    XEvent save;
	    while (XEventsQueued(ev->xmotion.display, QueuedAfterReading) > 0) {
		XPeekEvent(ev->xmotion.display, &save);
		if (save.type != MotionNotify) break;
		if (save.xmotion.window != ev->xmotion.window) break;
		XNextEvent(ev->xmotion.display, &xp->xLastPointer);
	    }
	}
    if (ev->xmotion.is_hint == NotifyHint) {
	Window r, c;
	int r_x, r_y, w_x, w_y;
	unsigned int m;
#ifdef STAYDEBUG
	printf("HINT HINT HINT\n");
#endif /*STAYDEBUG*/
	if (XQueryPointer(ev->xmotion.display, ev->xmotion.window,
			  &r, &c, &r_x, &r_y, &w_x, &w_y, &m)) {
	    ev->xmotion.x = w_x; ev->xmotion.y = w_y;
	    ev->xmotion.x_root = r_x; ev->xmotion.y_root = r_y;
	    ev->xmotion.state = m;
	}
    }

    if (tr->teEventMask & YYMASK_STAY) {
	/* ưƤΤǸǤ STAY Ԥ̵ˤʤ
	 * ʬɸ STAY ԤųݤƤ
	 */
#ifdef STAYDEBUG
	struct timeval curtime;
#endif /*STAYDEBUG*/
	yysched_delque(ch, tr->teID, YYSCHED_TYPE_MOUSE_STAY, (-1));
	yysched_addque(ch, x_mouse_stay_timer,
		       tr->teID, YYSCHED_TYPE_MOUSE_STAY, YYSCHED_FLAG_SKIP,
		       (struct timeval *)NULL, ch->ccXStayInterval);
#ifdef STAYDEBUG
	gettimeofday(&curtime,(struct timezone *)NULL);
	printf("PointerStay is set in TR#%d at %ld.%ld\n",
	       tr->teID, curtime.tv_sec, curtime.tv_usec);
#endif /*STAYDEBUG*/
    }

    if ((tr->teEventMask & YYMASK_MOVE) && ch->ccXMotionEnable) {
	/* (ְ)Motion 𤹤
	 * 𤷤 YY-client Ƴޤ
	 *  ߤ褦ˤ
	 */
	register int mask = YYMASK_MOVE;
	mask |= parse_button_state(tr->teEventMask, YYMASK_BUTTON_PRESS,
				   ev->xmotion.state);
	DebugPrint1(3, "Button State 0%o\n", ev->xmotion.state);
#ifdef STAYDEBUG
	printf("Motion --> YY-client (TR#%d)\n", tr->teID);
#endif
	report_mouse_event(ch, tr->teID, mask, ev->xmotion.x, ev->xmotion.y);
	/*  MotionEvent 𤷤
	 * YY-client ޤʤ */
	ch->ccXMotionEnable = FALSE;
	yysched_addque(ch, x_mouse_motion_timer,
		       tr->teID, YYSCHED_TYPE_MOUSE_MOTION, 0,
		       (struct timeval *)NULL, 1000);
    }
#ifdef STAYDEBUG
    else {
	printf("Motion, DO NOT Send to YY-client (TR#%d)\n", tr->teID);
    }
#endif
    DebugEndFunc("xwindow-event", "parse_mouse_motion_event");
    /*NoReturnValue*/
}




/***************************************************************************
 ***** Event 73
 *****
 *****  Send Mouse Event on Territory
 *****
 ***************************************************************************/
static void report_mouse_event(ch, id, mask, x, y)
    yy_comm_channel *ch;
    int id;	/* Territory ID */
    int mask;	/* Event Mask */
    int x, y;	/* Localtion of Mouce Cursor */
{
    yy_packet *event;
    DebugSetFunc("xwindow-event", "report_mouse_event");
    event = ALLOC_EVENTPACKET(YYCOMMAND_MOUSE_EVENT);
    DebugPrint4(5, "Event on TR#%d (%d,%d) - mask:0%o\n", id, x, y, mask);
    append_packet_entry_integer(event, id);
    append_packet_entry_integer(event, mask);
    append_packet_entry_integer(event, x);
    append_packet_entry_integer(event, y);
    put_packet_on_sendq(QUE(ch), event);
    /* Motion Υ٥ȤϢ³ʤ褦ˤʤäƤ뤬
     *  Ҥ˺ƳΥޥɤʤޤޤˤʤäƤޤȤ
     *  Τ̤μΥ٥ȤȯʳǤƳ
     *  Ȥˤ
     * (LUV92 ǥΤΤȤꤢб)
     */
    ch->ccXMotionEnable = TRUE; /* Motion λ return  FALSE ˤ */
    yysched_delque(ch, (-1), YYSCHED_TYPE_MOUSE_MOTION, (-1));
    DebugEndFunc("xwindow-event", "report_mouse_event");
}

static void report_key_event(ch, id, leng, str)
    yy_comm_channel *ch;
    int id;
    int leng;
    char *str;
{
    yy_packet *event;
    DebugSetFunc("xwindow-event", "report_key_event");
    DebugPrint1(5, "   to Territory#%d\n", id);
    event = ALLOC_EVENTPACKET(YYCOMMAND_KEY_EVENT);
    append_packet_entry_integer(event, id);
    append_packet_entry_string_with_length(event, leng, str);
    put_packet_on_sendq(QUE(ch), event);
    DebugEndFunc("xwindow-event", "report_key_event");
}

typedef struct _x_event_control {
    KeySym ecLastKeySym;
    Time ecLastKeyTime;
    int ecMaxLengString;
    char *ecKeyString;
    char *ecCurKeyString;
    int ecLengKeyString;
} x_event_control;

/* key_press(ch, xp, ev)
 *
 * 줿Υβ
 */
static void key_press(ch, xp, ev)
    yy_comm_channel *ch;
    x_private *xp;
    XEvent *ev;
{
    KeySym key;
    char string[10];
    int leng;
    territory_entry *tr = selected_territory();

    DebugSetFunc("xwindow", "key_press");
    if (NULLTERRITORY(tr)) {
	DebugPrint0(1, "No selected territory...\n"); goto send_reply;
    }

    /* ξ֤̣Ʋ줿ʸȤ
     */
    leng = XLookupString(ev, string, sizeof(string), &key, NULL);
    string[leng] = EOS;	/* ϥǥХåΤˤƤ */
    DebugPrint2(10, "Key Pressed\nLength=%d (%s)\n", leng, string);
    if (tr->teTRType == TR_PAGE) {
	/* ڡ⡼ɥƥȥʤΤǼϽԤʤǽ
	 */
	keyin_on_input_territory(ch, tr, leng, string);
    } else {
	/* KeySym 򸫤üʥƤˤ
	 * ʤνԤʤ
	 */
#define LRCHECK(ksym)		((key)==(ksym)?'L':'R')
	switch (key) {
	case XK_Delete:
	    DebugPrint0(10,"Delete Key Pressed\n");
	    report_key_event(ch, tr->teID, leng, string);
	    break;
	case XK_Return:
	case XK_Linefeed:
	    DebugPrint0(10,"Return Key Pressed\n");
	    report_key_event(ch, tr->teID, leng, string);
	    break;
	case XK_Shift_L: case XK_Shift_R:
	    DebugPrint1(10,"Shift(%c) Key Presses\n",LRCHECK(XK_Shift_L));
	    break;
	case XK_Control_L: case XK_Control_R:
	    DebugPrint1(10,"Control(%c) Key Presses\n",LRCHECK(XK_Control_L));
	    break;
	case XK_Meta_L: case XK_Meta_R:
	    DebugPrint1(10,"Meta(%c) Key Presses\n",LRCHECK(XK_Meta_L));
	    break;
	case XK_Alt_L: case XK_Alt_R:
	    DebugPrint1(10,"Alt(%c) Key Presses\n",LRCHECK(XK_Alt_L));
	    break;
	case XK_Super_L: case XK_Super_R:
	    DebugPrint1(10,"Super(%c) Key Presses\n",LRCHECK(XK_Super_L));
	    break;
	case XK_Hyper_L: case XK_Hyper_R:
	    DebugPrint1(10,"Hyper(%c) Key Presses\n",LRCHECK(XK_Hyper_L));
	    break;
	default:
	    if (!IsCursorKey(key) && !IsFunctionKey(key)) {
		DebugPrint0(10, "Normal Key Pressed\n");
		report_key_event(ch, tr->teID, leng, string);
	    }
	    break;
	}
    }
 send_reply:
    DebugEndFunc("xwindow", "key_press");
    /*NoReturnValue*/
}


/**********************************************************************
 *****
 *****  顼μ갷
 *****
 **********************************************************************/

/* x_color get_x_color(xp, name)
 *
 * name Ȥ̾ĿΥԥͤ
 * ¸ߤʤйΥԥ֤ͤ
 */
x_color get_x_color(xp, name)
    x_private *xp;
    char *name;
{
    XColor c0, c1;
    DebugSetFunc("xwindow-color", "get_x_color");
    DebugPrint1(2, "Color Name : '%s'\n", name);
    if (XAllocNamedColor(xp->xDisp, xp->xColor, name, &c1, &c0) == 0) {
	c1.pixel = BlackPixel(xp->xDisp, xp->xScreen);
    }
    DebugPrint1(2, "Color Code : %lu\n", c1.pixel);
    DebugEndFunc("xwindow-color", "get_x_color");
    return c1.pixel;
}

/***************************************************************************
 ***** Command 45
 *****
 *****  Query Color
 *****
 ***************************************************************************/
yy_packet *yycom_query_color(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    XColor color;
    yy_packet *repl;

    /* RGB ͤ ԥͤ */
    DebugSetFunc("xwindow-color", "yycom_query_color");
    color.red = (u_short)(read_packet_entry_integer(pkt) & 0xffff);
    color.green = (u_short)(read_packet_entry_integer(pkt) & 0xffff);
    color.blue = (u_short)(read_packet_entry_integer(pkt) & 0xffff);
    color.pixel = 0;
    DebugPrint3(1, "Allocate color for (R:%d,G:%d,B:%d)\n",
		color.red, color.green, color.blue);

    if (XAllocColor(xp->xDisp, xp->xColor, &color) == (Status)0) {
	DebugPrint0(1, "Can't allocate color\n");
	color.pixel = BlackPixel(xp->xDisp, xp->xScreen);
    }
    DebugPrint1(5, "Pixel value is %lu\n", color.pixel);
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl, color.pixel);
    DebugEndFunc("xwindow-color", "yycom_query_color");
    return repl;
}

/***************************************************************************
 ***** Command 46
 *****
 *****  Get Color Value with Name
 *****
 *****  ̾ԥͤ RGB ͤ
 *****
 ***************************************************************************/
yy_packet *yycom_get_color_numrgb(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    XColor c0, c1;
    yy_packet *repl;
    int leng; char name[64];

    DebugSetFunc("xwindow", "yycom_get_color_numrgb");
    if ((leng = read_packet_entry_integer(pkt)) > 0) {
	read_packet_entry_string(pkt, MIN(leng,sizeof(name)), name);
	DebugPrint1(1, "Color Name : '%s'\n", name);
	if (XAllocNamedColor(xp->xDisp, xp->xColor, name, &c1, &c0) == 0) {
	    c1.pixel = BlackPixel(xp->xDisp, xp->xScreen);
	}
	DebugPrint1(1, "Pixel Value : %lu\n", c1.pixel);
    } else {
	DebugPrint0(1, "Can't Get Color Name\n");
	c1.pixel = BlackPixel(xp->xDisp, xp->xScreen);
    }
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl, c1.pixel);
    append_packet_entry_integer(repl, c1.red);
    append_packet_entry_integer(repl, c1.green);
    append_packet_entry_integer(repl, c1.blue);
    DebugEndFunc("xwindow", "yycom_get_color_numrgb");
    return repl;
}

/***************************************************************************
 ***** Command 51
 *****
 *****  Change RGC Value for Color
 *****
 *****  ̾ԥͤ RGB ͤ
 *****
 ***************************************************************************/
yy_packet *yycom_change_color_rgb(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    yy_packet *repl = (yy_packet *)NULL;
    DebugSetFunc("xwindow", "yycom_change_color_rgb");
    DebugEndFunc("xwindow", "yycom_change_color_rgb");
    return repl;
}

yy_packet *yycom_free_color(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    yy_packet *repl = (yy_packet *)NULL;
    DebugSetFunc("xwindow", "yycom_free_color");
    DebugEndFunc("xwindow", "yycom_free_color");
    return repl;
}

yy_packet *yycom_get_color_value(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    yy_packet *repl = (yy_packet *)NULL;
    DebugSetFunc("xwindow", "yycom_get_color_value");
    DebugEndFunc("xwindow", "yycom_get_color_value");
    return repl;
}




yy_packet *yycom_debug_list_color(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    int len;
    char name[256];
    x_color color;
    yy_packet *repl;
    DebugSetFunc("xwindow", "yycom_debug_list_color");
    len = read_packet_entry_integer(pkt);
    DebugPrint1(5, "Length = %d\n", len);
    read_packet_entry_string(pkt, len, name);
    DebugPrint1(5, "Name = %d\n", len);
    color = get_x_color(xp, name);
    DebugPrint2(1, "Color Code for '%s' is %lu\n", name, color);
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_color(repl, color);
    DebugEndFunc("xwindow", "yycom_debug_list_color");
    return (yy_packet *)NULL;
}

yy_packet *yycom_debug_do_input(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    int id;
    int leng;
    char buf[256];
    yy_packet *event;
    DebugSetFunc("xwindow", "yycom_debug_do_input");
    id = read_packet_entry_integer(pkt);
    leng = read_packet_entry_integer(pkt);
    DebugPrint2(1, "Echo Back String (Length = %d) on TR#%d\n", leng, id);
    read_packet_entry_string(pkt, leng, buf);
    event = ALLOC_EVENTPACKET(YYCOMMAND_KEY_EVENT);
    append_packet_entry_integer(event, id);
    append_packet_entry_string_with_length(event, leng, buf);
    put_packet_on_sendq(QUE(ch), event);
    DebugEndFunc("xwindow", "yycom_debug_do_input");
    return (yy_packet *)NULL;
}

/*
 */

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
