/*
 */

#ifndef lint
static char *RcsId =
    "$Id: page_ctrl.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $" ;
#endif

/****************************************************************************
%%%COPYRIGHT%%%
****************************************************************************/

/****************************************************************************
#
# $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
#			$Date: 1992/10/08 04:59:44 $
# Log:
#  Version 1.0 is written by Keisuke 'Keiko' Tanaka
#		recieved_line		(keisuke@csrl.aoyama.ac.jp)
# 
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"

#ifdef PROTODEBUG
#include <malloc.h>
#define memALLOC(size)		malloc(size)
#define memCALLOC(nelem,size)	calloc(nelem,size)
#define memFREE(ptr)		free(ptr)

#undef DebugSetFunc
#undef DebugEndFunc
#undef DebugPrint0
#undef DebugPrint1
#undef DebugPrint2
#undef DebugPrint3
#undef DebugPrint4
#undef DebugPrint5
#undef DebugPrint6
#undef DebugPrint7
#undef DebugPrint8
#undef DebugPrint9
#define DebugLevel()		10
#define DebugSetFunc(label,func)	\
    fprintf(stderr,"*****Start(%s:%s)\n",label,func)
#define DebugEndFunc(label,func)	\
    fprintf(stderr,"*****End(%s:%s)\n",label,func)
#define DebugPrint0(level,fmt)			fprintf(stderr,fmt)
#define DebugPrint1(level,fmt,a1)		fprintf(stderr,fmt,a1)
#define DebugPrint2(level,fmt,a1,a2)		fprintf(stderr,fmt,a1,a2)
#define DebugPrint3(level,fmt,a1,a2,a3)		fprintf(stderr,fmt,a1,a2,a3)
#define DebugPrint4(level,fmt,a1,a2,a3,a4)	fprintf(stderr,fmt,a1,a2,a3,a4)
#define DebugPrint5(level,fmt,a1,a2,a3,a4,a5)	\
    fprintf(stderr,fmt,a1,a2,a3,a4,a5)
#define DebugPrint6(level,fmt,a1,a2,a3,a4,a5,a6)	\
    fprintf(stderr,fmt,a1,a2,a3,a4,a5,a6)
#define DebugPrint7(level,fmt,a1,a2,a3,a4,a5,a6,a7)	\
    fprintf(stderr,fmt,a1,a2,a3,a4,a5,a6,a7)
#define DebugPrint8(level,fmt,a1,a2,a3,a4,a5,a6,a7,a8)	\
    fprintf(stderr,fmt,a1,a2,a3,a4,a5,a6,a7,a8)
#define DebugPrint9(level,fmt,a1,a2,a3,a4,a5,a6,a7,a8,a9)	\
    fprintf(stderr,fmt,a1,a2,a3,a4,a5,a6,a7,a8,a9)
#endif /*PROTODEBUG*/

static void insert_control_block_queue_entry();
static void remove_control_block_queue_entry();
static void insert_line_buffer_queue_entry();
static void remove_line_buffer_queue_entry();
static PAGELINE *alloc_page_line_buffer();
static void destroy_pageline_control_block();
static void free_page_line_buffer();
static void insert_line_buffer();
static void concat_line_buffer();
static void divide_line_buffer();
static void delete_line_buffer();
static PAGELINE *allocate_line_buffer_for_string();
static void reduce_line_buffer_link();
static void up_char_cursor_on_page();
static void down_char_cursor_on_page();
static void backward_char_cursor_on_page();
static void forward_char_cursor_on_page();




/*
 * Page Mode Territory
 */

/* ɸȼºɸδط:
 *
 *  Page Mode Territory 񤭥⡼ɤξ硤ɸ (C,R) 
 * ºɸ (X,Y) δ֤ˤ X=C, V=R δط
 *
 *  Page Mode Territory Ľ񤭥⡼ɤξ硤
 * ⤦äʣˤʤ
 */


/**********************************************************************
 * insert_control_block_queue_entry(plane, ctrl)
 * remove_control_block_queue_entry(ctrl)
 *
 * ֥åΥ󥯾Τδؿ
 * insert_control_block_queue_entry()  plane Ƭ֥åȤ
 *   ctrl Ͽ
 * remove_control_block_queue_entry()  ctrl Ƭ֥åȤƤ
 *   Ͽ
 */
#define ISNULLCTRLBLOCK(p)	((p)==(struct pageline_control_block *)NULL)
static void insert_control_block_queue_entry(plane, ctrl)
    register PAGEPLANE *plane;
    register struct pageline_control_block *ctrl;
{
    register struct pageline_control_block *oldtop = plane->lineCtrlBlock;
    ctrl->backCtrlBlock = (struct pageline_control_block *)NULL;
    if (!ISNULLCTRLBLOCK(ctrl->forwCtrlBlock = oldtop))
	oldtop->backCtrlBlock = ctrl;
    ctrl->plane = plane;
    plane->lineCtrlBlock = ctrl;
}

static void remove_control_block_queue_entry(ctrl)
    register struct pageline_control_block *ctrl;
{
    if (!ISNULLCTRLBLOCK(ctrl->backCtrlBlock))
	ctrl->backCtrlBlock->forwCtrlBlock = ctrl->forwCtrlBlock;
    else
	ctrl->plane->lineCtrlBlock = ctrl->forwCtrlBlock;
    if (!ISNULLCTRLBLOCK(ctrl->forwCtrlBlock))
	ctrl->forwCtrlBlock->backCtrlBlock = ctrl->backCtrlBlock;
}

/**********************************************************************
 * insert_line_buffer_queue_entry(pline, prev, top)
 * remove_line_buffer_queue_entry(pline, top)
 *
 * PageLineBuffer Υ󥯾뤿δؿ
 * insert_line_buffer_queue_entry()  *top ƬȤ륭塼Ф
 *   prev ΤȤ pline ɲä
 *   prev  *top Υ塼¸ߤ뤫ɤγǧϹԤʤäƤʤ
 * remove_line_buffer_queue_entry() 
 *   *top Ϥޤ륭塼椫 pline 
 *
 * BUG:
 *  insert_line_buffer_queue_entry() ˤ prev 
 *  remove_line_buffer_queue_entry() ˤ pline 
 *  *top Υ塼¸ߤ뤫ɤγǧϹԤʤäƤʤ
 */
static void insert_line_buffer_queue_entry(pline, prev, top)
    register PAGELINE *pline, *prev, **top;
{
    if (prev != (PAGELINE *)NULL) {
	if ((pline->forw = prev->forw) != (PAGELINE *)NULL)
	    prev->forw->back = pline;
	prev->forw = pline;
	pline->back = prev;
    } else {
	if ((pline->forw = *top) != (PAGELINE *)NULL)
	    (*top)->back = pline;
	pline->back = (PAGELINE *)NULL;
	*top = pline;
    }
}
static void remove_line_buffer_queue_entry(pline, top)
    register PAGELINE *pline, **top;
{
    if (pline->back != (PAGELINE *)NULL) pline->back->forw = pline->forw;
    else				 *top = pline->forw;
    if (pline->forw != (PAGELINE *)NULL) pline->forw->back = pline->back;
}


/**********************************************************************
 *
 */

/* plane ° LineBuffer 
 */
static PAGELINE *alloc_page_line_buffer(plane)
    PAGEPLANE *plane;
{
    PAGELINE *pline;
    struct pageline_control_block *ctrl;
    int loop;
    DebugSetFunc("page","alloc_page_line_buffer");

    /*
     * ̤ΰ֥åõ
     */
    ctrl = plane->lineCtrlBlock;
    while (ctrl != (struct pageline_control_block *)NULL &&
	   ctrl->free == (PAGELINE *)NULL)
	ctrl = ctrl->forwCtrlBlock;

    if (ctrl == (struct pageline_control_block *)NULL) {
	/*
	 * ̤Ѥΰ褬¸ߤʤΤǿ֥åդ
	 * Υ֥å PagePlane Ƭ֥åȤϿ
	 */
	DebugPrint0(3," Allocate new Control Block!!\n");
	ctrl = (struct pageline_control_block *)
	    memALLOC(sizeof(struct pageline_control_block));
	insert_control_block_queue_entry(plane, ctrl);

	/*
	 * Ƥ֥å˰̤ΥХåեݤ
	 * free 󥯤³롥
	 */
#define BUFNUMinCTRLBLK		80	/* ֥åλĥХåե */
	ctrl->top = ctrl->free =
	    (PAGELINE *)memCALLOC(BUFNUMinCTRLBLK, sizeof(PAGELINE));
	for (loop = BUFNUMinCTRLBLK, pline = ctrl->top;
	     loop > 0 ; loop--, pline++) {
	    pline->forw = (pline+1); pline->back = (pline-1);
	    pline->ctrlBlock = ctrl;
	}
	/* ƬȺǸˤ̤ʽɬ */
	ctrl->free->back = (pline-1)->forw = (PAGELINE *)NULL;
	ctrl->active = (PAGELINE *)NULL;
    }

    /*
     * FreeList Ƭ PageLineBuffer  ActiveList Ƭ˲ä
     * ΰƤؤΥݥ󥿤֤
     */
    pline = ctrl->free;
    remove_line_buffer_queue_entry(pline, &ctrl->free);
    insert_line_buffer_queue_entry(pline, (PAGELINE *)NULL, &ctrl->active);
    /* ΰν */
    pline->fontID = pline->nchar = pline->leng = 0;
    pline->dirty = TRUE;
    DebugEndFunc("page","alloc_page_line_buffer");
    return pline;
}

/*
 */
static void destroy_pageline_control_block(ctrl)
    struct pageline_control_block *ctrl;
{
    remove_control_block_queue_entry(ctrl);
    memFREE((char *)ctrl->top);
    memFREE((char *)ctrl);
    /*NoReturnValue*/
}

/* pline ΰγ
 * ֥åǤ ActiveList  FreeList ؤΰưˤäƹԤʤ
 * ΰưˤä ActiveList ˤʤäˤ
 * ֥åޤ memFREE Ԥʤ
 */
static void free_page_line_buffer(pline)
    PAGELINE *pline;
{
    struct pageline_control_block *ctrl;
    DebugSetFunc("page","free_page_line_buffer");
    ctrl = pline->ctrlBlock;
    /* Active 󤫤ڤΥ Free Ͽ */
    remove_line_buffer_queue_entry(pline, &ctrl->active);
    insert_line_buffer_queue_entry(pline, (PAGELINE *)NULL, &ctrl->free);
    DebugPrint2(5," Active:0x%x, Free:0x%x\n",ctrl->active,ctrl->free);
    /* Active ʤΤʤʤäΤǤФΰ */
    if (ctrl->active == (PAGELINE *)NULL) {
	DebugPrint0(5," No Active LineBuffer - Destroy\n");
	(void)destroy_pageline_control_block(ctrl);
    }
    DebugEndFunc("page","free_page_line_buffer");
    /*NoReturnValue*/
}




/**********************************************************************
 * PageLineBuffer 򰷤δؿ
 */


/* insert_line_buffer(pline, prev)
 *
 * pline Ϥޤ LineBuffer  prev ΤȤ
 *
 * BUG:
 *  prev  NULL ǤäƤϤʤʤ
 *   (prev->nextBuf  NULL ǤäƤ⹽ʤ)
 */
static void insert_line_buffer(pline, prev)
    PAGELINE *pline, *prev;
{
    PAGELINE *last;
    for (last = pline; last->nextBuf != (PAGELINE *)NULL; last = last->nextBuf)
	;
    if ((last->nextBuf = prev->nextBuf) != (PAGELINE *)NULL)
	prev->nextBuf->prevBuf = last;
    pline->prevBuf = prev;
    prev->nextBuf = pline;
    /*NoReturnValue*/
}

/* crack_line_buffer(pline, ptr)
 *
 * pline ʸ ptr ʬ䤹
 *
 * BUG:
 *  ptr  pline ¸ߤʤˤ̵ˤʤ
 */
void crack_line_buffer(plane, pline, ptr)
    PAGEPLANE *plane;
    PAGELINE *pline;
    u_char *ptr;
{
    register int pos = ptr - pline->buffer;
    register PAGELINE *next;
    next = allocate_line_buffer_for_string(plane, pline->fontID,
					   pline->leng-pos, ptr);
    pline->leng = pos;
    pline->nchar = JEUC_StrNChar(pos, pline->buffer);
    pline->dirty = TRUE;
    insert_line_buffer(next, pline);
    /*NoReturnValue*/
}

/* concat_line_buffer(plane)
 *
 * ߤʸ֤餢ȤΤιԤʸõ
 * ιԤ³
 */
static void concat_line_buffer(plane)
    PAGEPLANE *plane;
{
    PAGELINE *top = plane->curLineTop;
    PAGELINE *cur = plane->curLineBuf;
    PAGELINE *next = top->nextLine;

    /* ߤʸ֤餢Ȥʸξõ */
    crack_line_buffer(plane, cur, plane->curPtr);
    while (cur->nextBuf != (PAGELINE *)NULL)
	delete_line_buffer(cur->nextBuf);
    if ((next = top->nextLine) != (PAGELINE *)NULL) {
	/* next  LineBuffer ȴФ */
	if ((top->nextLine = next->nextLine) != (PAGELINE *)NULL)
	    next->nextLine->prevLine = top;
	/* next  LineBuffer  cur ΤȤ */
	insert_line_buffer(next, cur);
    }
    reduce_line_buffer_link(plane->curLineBuf);
    /*NoReturnValue*/
}

/* divide_line_buffer(plane)
 *
 * ߤʸ֤ǹԤʬ䤷ʹߤʸä
 * Ԥ򿷤ˤĤ
 * ʸϸΰ֤ˤȤɤޤ
 */
static void divide_line_buffer(plane)
    PAGEPLANE *plane;
{
    PAGELINE *top = plane->curLineTop;
    PAGELINE *cur = plane->curLineBuf;
    PAGELINE *next;

    /* ߤʸ֤餢Ȥʸ */
    crack_line_buffer(plane, cur, plane->curPtr);
    next = cur->nextBuf;
    next->prevLine = top;
    if ((next->nextLine = top->nextLine) != (PAGELINE *)NULL)
	next->nextLine->prevLine = next;
    top->nextLine = next;
    reduce_line_buffer_link(next);
    /*NoReturnValue*/
}


/* delete_line_buffer(pline)
 *
 * pline  LineBuffer 󤫤 Free 
 *
 * BUG:
 *  pline  LineBuffer ƬǤäƤϤʤʤ
 */
static void delete_line_buffer(pline)
    PAGELINE *pline;
{
    if (pline->nextBuf != (PAGELINE *)NULL)
	pline->nextBuf->prevBuf = pline->prevBuf;
    pline->prevBuf->nextBuf = pline->nextBuf;
    free_page_line_buffer(pline);
    /*NoReturnValue*/
}

/* allocate_line_buffer_for_string(plane, font, leng, str)
 *
 * եֹ font ʸ str (Ĺ leng Х) 
 * ǼǤ LineBuffer ƤƬɥ쥹֤
 */
static PAGELINE *allocate_line_buffer_for_string(plane, font, leng, str)
    PAGEPLANE *plane;
    int font;		/* եֹ */
    int leng;		/* ʸĹ (Хȿ) */
    u_char *str;	/* ʸƬɥ쥹 */
{
    PAGELINE *top, *cur;
    DebugSetFunc("page","allocate_line_buffer_for_string");
    DebugPrint2(3, "Font:%d, Length:%d\n", font, leng);
    top = cur = (PAGELINE *)NULL;
    while (leng > 0) {
	/*  LineBuffer Ƥ֤ʸ򤽤֤ */
	PAGELINE *new = alloc_page_line_buffer(plane);
	new->dirty = TRUE;	/* ѹ */
	new->fontID = font;
	/* LineBuffer ι */
	if (cur == (PAGELINE *)NULL) {
	    /* Ƭ */
	    new->nextBuf = new->prevBuf = (PAGELINE *)NULL;
	    top = cur = new;
	} else {
	    /* Ƹ */
	    cur->nextBuf = new;
	    new->prevBuf = cur; new->nextBuf = (PAGELINE *)NULL;
	    cur = new;
	}
	/* ֤ʸ򤪤JEUC ʸȤƸ
	 * ʸΥǡƱ LineBuffer ˤޤ褦ˤ */
	memcpy(cur->buffer, str, MIN(leng,sizeof(cur->buffer)));
	cur->nchar = JEUC_StrNChar(MIN(leng,sizeof(cur->buffer)), cur->buffer);
	cur->leng = JEUC_StrLen(cur->nchar, cur->buffer);
	leng -= cur->leng;
	str += cur->leng;
    }
    DebugEndFunc("page","allocate_line_buffer_for_string");
    return top;
}

/* reduce_line_buffer_link(pline)
 *
 * pline Ϥޤ LineBuffer ǤФ
 * ʲξΤ줫˸ LineBuffer ä
 * 1)  LineBuffer ˤʸޤޤƤʤ
 *    ->  LineBuffer Ƥ򥳥ԡ塤 LineBuffer ä
 * 2)  LineBuffer ˤʸޤޤƤʤ
 *    ->  LineBuffer ä
 * 3)  LineBuffer ʸ򤹤٤Ƥ LineBuffer ɲäǤ
 *    ->  LineBuffer ʸ򥳥ԡ塤
 *        LineBuffer ä
 *
 * BUG:
 *  pline  LineBuffer ʸ뤬¸ߤ
 *  LineBuffer õʸ֤ȤʤäƤޤ
 *  Τ褦ʸƤӽФϹԤʤäƤϤʤʤ
 */
static void reduce_line_buffer_link(pline)
    register PAGELINE *pline;
{
    register PAGELINE *next;
    /*  LineBuffer ʤʤޤ³ */
    while ((next = pline->nextBuf) != (PAGELINE *)NULL) {
	if (pline->leng == 0 || next->leng == 0 ||
	    (pline->fontID == next->fontID &&
	     pline->leng + next->leng <= sizeof(pline->buffer) &&
	     (pline->baseX == next->baseX || pline->baseY == next->baseY))) {
	    memcpy(pline->buffer+pline->leng, next->buffer, next->leng);
	    pline->fontID = next->fontID;
	    pline->leng += next->leng;
	    pline->nchar += next->nchar;
	    if (!pline->dirty && next->dirty) pline->dirty = TRUE;
	    delete_line_buffer(next);
	} else
	    pline = next;
    }
}

/* total_nchar_in_line_buffer(pline)
 *
 * pline Ϥޤ LineBuffer ˴ޤޤʸ֤
 */
int total_nchar_in_line_buffer(pline)
    register PAGELINE *pline;
{
    register int nchar = 0;
    for ( ; pline != (PAGELINE *)NULL; pline = pline->nextBuf)
	nchar += pline->nchar;
    return nchar;
}

/**********************************************************************
 ****
 ****
 ****
 **********************************************************************/

/* insert_string_on_page(plane, font, leng, str)
 *
 * ʸ뤬¸ߤ֤ leng ХȤĹʸ str 
 * 
 */
void insert_string_on_page(plane, font, leng, str)
    PAGEPLANE *plane;	/* о PagePlane */
    int font;		/* font ֹ */
    int leng;		/* str ͭĹ (Хȿ) */
    u_char *str;	/* ʸ */
{
    u_char *ss, *se;
    PAGELINE *cur = plane->curLineBuf;	/*ʸΤLineBuffer*/
    int nchar, row;

    DebugSetFunc("page", "insert_string_on_page");
    *(str+leng) = 0;
    DebugPrint2(3, " Length of String: %d <%s>\n", leng, str);

    /*  cur ϤΤȤʸ٤ LineBuffer Ǥ */

    /* ߤʸ֤ LineBuffer Ǥ
     *  LineBuffer ʬ䤹 */
    if ((plane->curPtr - cur->buffer) < cur->leng)
	crack_line_buffer(plane, cur, plane->curPtr);

    se = str;
    nchar = row = 0;
    while (leng > 0) {
	/* se Ϥޤ򤷤ƤʤʸƬ򼨤Ƥ
	 * 򿷤Ƭ ss Ȥ */
	ss = se;

	/* ʸڤФƤޤ LineBuffer ꡤ
	 * cur ľ롤 cur  LineBuffer 
	 * Ǹ LineBuffer Ȥ
	 * nchar ˤ LineBuffer ʸäƤ
	 * ̤ʽ '\n'  '\r'  '\i' ˤĤƹԤʤ
	 */
	while (leng > 0) {
	    if (JEUC_CodeSet(se)!=0 || !iscntrl(*se)) {
		/* ̾ʸǤΤǤΤޤ se ʤ */
		register int bytes = JEUC_Bytes(se);
		nchar++;
		se += bytes;
		leng -= bytes;
	    } else {
		/* ASCII ʸǤ */
		if (se != ss) break; /* ss  se-1 ޤǤϤ
				      * θ˺ٽԤʤ */
		if (*se == '\n' || *se == '\r') {
		    /* ιԤʸʤ */
		    PAGELINE *top;	/* cur ιԤƬ */
		    PAGELINE *next;	/* ԤƬˤʤ LineBuffer */
		    DebugPrint0(5, "Create New Line on PageTerritory\n");
		    for (top = cur; top->prevBuf != (PAGELINE *)NULL; )
			top = top->prevBuf;
		    if ((next = cur->nextBuf) != (PAGELINE *)NULL) {
			cur->nextBuf = next->prevBuf = (PAGELINE *)NULL;
		    } else {
			next = alloc_page_line_buffer(plane);
			next->dirty = TRUE;	/* ѹ */
			next->nextBuf = next->prevBuf = (PAGELINE *)NULL;
		    }
		    /* top  top μιԤδ֤˹ƬȤ next  */
		    if ((next->nextLine = top->nextLine) != (PAGELINE *)NULL)
			next->nextLine->prevLine = next;
		    top->nextLine = next;
		    next->prevLine = top;
		    /* cur ΤäԤ Reduce Ƥ */
		    reduce_line_buffer_link((row > 0? top: plane->curLineBuf));
		    /* */
		    cur = next;
		    nchar = -plane->curCol;
		    row++;
		}
		se++; ss++;
		leng--;
	    }
	}
	/* ss  se ޤǤʸޤ LineBuffer 
	 * cur ΤȤΤ cur 򤽤 LineBuffer κǸˤ
	 */
	if (se != ss) {
	    PAGELINE *new, *last;
	    new = allocate_line_buffer_for_string(plane,font,(se-ss),ss);
	    for (last = new; last->nextBuf != (PAGELINE *)NULL; )
		last = last->nextBuf;
	    insert_line_buffer(new, cur);
	    cur = last;
	}
    }
    reduce_line_buffer_link(plane->curLineBuf);
    /* ΰư
     */
    move_char_cursor_on_page(plane, nchar, row);
    DebugEndFunc("page", "insert_string_on_page");
    /*NoReturnValue*/
}

/*
 *
 * ߤʸ֤ nchar ʸõ
 * ãϹȤƾäˤä
 * Ԥη礬
 *
 * BUG:
 *  nchar  0 ʲξưݾڤǤʤ
 */
void delete_string_on_page(plane, nchar)
    PAGEPLANE *plane;
    int nchar;
{
    register PAGELINE *cur = plane->curLineBuf; /* ܤ LineBuffer */
    register u_char *ptr = plane->curPtr;	/*  */

    for ( ; ; ptr = (cur = cur->nextBuf)->buffer) {
	register int rest_leng = cur->leng - (ptr - cur->buffer);
	register int rest_nchar = JEUC_StrNChar(rest_leng, ptr);
	if (nchar <= rest_nchar) {
	    /* ptr  nchar ʸä */
	    register int l = JEUC_StrLen(nchar, ptr);
	    if (rest_leng-l > 0) memcpy(ptr, ptr+l, rest_leng-l);
	    cur->leng -= l;
	    cur->nchar -= nchar;
	    if (nchar > 0) cur->dirty = TRUE;
	    break;
	}
	/*  LineBuffer  ptr ʸΥǡä
	 *  LineBuffer ϶ˤʤ뤬ΤޤޤˤƤ
	 * reduce ʳǲä
	 */
	cur->leng -= rest_leng;
	cur->nchar -= rest_nchar;
	cur->dirty = TRUE;
	nchar -= rest_nchar;

	if (cur->nextBuf == (PAGELINE *)NULL) {
	    /* Ԥ cur Ϣ뤹롥ιԤʤФ */
	    register PAGELINE *top;	/* cur ιƬ */
	    register PAGELINE *next;	/* top μιƬ */
	    for (top = cur; top->prevBuf != (PAGELINE *)NULL; )
		top = top->prevBuf;
	    if ((next = top->nextLine) == (PAGELINE *)NULL)
		break; /* ιԤʤ */
	    /* top μιԤ cur μ LineBuffer ˤ */
	    cur->nextBuf = next;
	    next->prevBuf = cur;
	    next->dirty = TRUE;
	    /* top μιԤԤȤƼ */
	    if ((top->nextLine = next->nextLine) != (PAGELINE *)NULL)
		next->nextLine->prevLine = top;
	}
    }
    reduce_line_buffer_link(plane->curLineBuf);
    /*NoReturnValue*/
}

/* overwrite_string_on_page(plane, font, leng, str)
 *
 * ߤʸ֤եֹ font Ȥä
 * Ĺ leng ʸ str  OVERWRITE 
 */
void overwrite_string_on_page(plane, font, leng, str)
    PAGEPLANE *plane;
    int font;
    int leng;
    u_char *str;
{
    (void)delete_string_on_page(plane, JEUC_StrNChar(leng, str));
    (void)insert_string_on_page(plane, font, leng, str);
    /*NoReturnValue*/
}

/* get_string_on_page(plane, nchar, ptr)
 *
 * ߤʸ֤ nchar ʸ ptr ΰ
 * ʣ̤
 * nchar οǤйޤǤ
 * ºݤ줿ʸΥХȿ֤
 *
 * BUG:
 *  ptr ΰʸǼ˽ʬ礭ĤȤȤ
 */
int get_string_on_page(plane, nchar, ptr)
    PAGEPLANE *plane;
    int nchar;
    u_char *ptr;
{
    PAGELINE *cur = plane->curLineBuf;
    register u_char *p;
    register int leng = 0;

    for (p = plane->curPtr; /*롼ǥåƤ*/ ; p = cur->buffer) {
	register int leng_inbuf = cur->leng - (p - cur->buffer);
	register int nchar_inbuf = JEUC_StrNChar(leng_inbuf, p);
	if (leng_inbuf > 0) {
	    if (nchar_inbuf <= nchar) {
		/* ̵Τ򥳥ԡ */
		memcpy(ptr, p, leng_inbuf);
		leng += leng_inbuf; ptr += leng_inbuf;
		nchar -= nchar_inbuf;
		if (nchar <= 0) break; /*⤦ʾͤ뤳ȤϤʤ*/
	    } else {
		/* ٤Ĺ򥳥ԡƽλ */
		register int leng_copy = JEUC_StrLen(nchar, p);
		memcpy(ptr, p, leng_copy);
		leng += leng_copy; ptr += leng_copy;
		break; /*⤦뤳ȤϤʤ*/
	    }
	}
	if (cur->nextBuf != (PAGELINE *)NULL) {
	    cur = cur->nextBuf; /*  LineBuffer оݤˤ */
	} else {
	    /* ιԤˤʤƤϤʤʤ */
	    register PAGELINE *top;
	    /* ʸդä */
	    *ptr++ = EOL; leng++;
	    if (--nchar <= 0) break;
	    for (top = cur; top->prevBuf != (PAGELINE *)NULL; )
		top = top->prevBuf;
	    if ((cur = top->nextLine) == (PAGELINE *)NULL)
		break; /*⤦Ԥʤ*/
	}
    }
    *ptr = EOS; /*̵Ѥκ򤱤뤿 EOS äƤ*/
    return leng;
}











/**********************************************************************
 * ʸưΤδؿ
 */

/* ʸ(Ū) -rrow Կʤ
 * ʸϤιԤιƬ˰֤뤳Ȥˤʤ
 * ƬԤ˰֤ˤϤ줫̤뤳ȤϤʤ
 *
 * BUG:
 *  rrow οǤʤаưϤʤ
 * ʸϹƬ˰֤뤳Ȥˤʤ
 */
static void up_char_cursor_on_page(plane, rrow)
    PAGEPLANE *plane;
    register int rrow;
{
    register PAGELINE *cur = plane->curLineTop;
    for ( ; rrow < 0 && cur->prevLine != (PAGELINE *)NULL ; rrow++) {
		cur = cur->prevLine;
		plane->curRow--;
    }
    plane->curLineTop = plane->curLineBuf = cur;
    plane->curPtr = cur->buffer;
    plane->curCol = 0;
    /*NoReturnValue*/
}

/* ʸ(Ū) rrow Կʤ
 * ʸϤιԤιƬ˰֤뤳Ȥˤʤ
 * LineBuffer ¸ߤʤԤˤʤˤϤ˶ LineBuffer ݤ
 *
 * BUG:
 *  rrow οǤʤаưϤʤ
 * ʸϹƬ˰֤뤳Ȥˤʤ
 */
static void down_char_cursor_on_page(plane, rrow)
    PAGEPLANE *plane;
    register int rrow;
{
    register PAGELINE *cur = plane->curLineTop;
    for ( ; rrow > 0 ; rrow--) {
	if (cur->nextLine == (PAGELINE *)NULL) {
	    register PAGELINE *next;
	    next = alloc_page_line_buffer(plane);
	    cur->nextLine = next;
	    next->prevLine = cur;
	    next->nextLine = (PAGELINE *)NULL;
	    next->nextBuf = next->prevBuf = (PAGELINE *)NULL;
	}
	cur = cur->nextLine;
	plane->curRow++;
    }
    plane->curLineTop = plane->curLineBuf = cur;
    plane->curPtr = cur->buffer;
    plane->curCol = 0;
    /*NoReturnValue*/
}

/* Ʊʸ(Ū) -rcol ʸʤ
 * ʸ뤬ƬãˤϤǻߤޤ
 *
 * BUG:
 *  rcol οǤʤв⤷ʤ
 */
static void backward_char_cursor_on_page(plane, rcol)
    PAGEPLANE *plane;
    register int rcol;
{
    register PAGELINE *cur = plane->curLineBuf;
    register u_char *ptr = plane->curPtr;
    while (rcol < 0) {
	/* nchar  LineBuffer cur  ptr ˤʸ */
	int nchar = JEUC_StrNChar(ptr - cur->buffer, cur->buffer);
	if (rcol + nchar > 0) {
	    /* Ū֤Ϥ LineBuffer Ǥ */
	    ptr = cur->buffer + JEUC_StrLen(rcol+nchar, cur->buffer);
	    plane->curCol += rcol;
	    rcol = 0;
	} else if (cur->prevBuf != (PAGELINE *)NULL) {
	    /* Ū֤Ϥ LineBuffer  LineBuffer 
	     *  */
	    cur = cur->prevBuf;
	    ptr = &cur->buffer[cur->leng]; /* Ǹʸθ */
	    plane->curCol -= nchar; /* nchar ʸ򤵤ΤܤäȤˤʤ */
	    rcol += nchar;
	} else {
	    /* Ū֤Ϥ LineBuffer  LineBuffer 
	     * 뤬ƬãƤޤ */
	    ptr = cur->buffer;		/* Ƭ */
	    plane->curCol = rcol = 0;
	}
    }
    plane->curLineBuf = cur;
    plane->curPtr = ptr;
    /*NoReturnValue*/
}

/* Ʊʸ(Ū) rcol ʸʤ
 * ʸ֤ʸ뤳Ȥݾڤʤ
 * ʸޤǤΰʸ֤Ƥʤ
 * ǥեʸ
 *
 * BUG:
 *  rcol οǤʤв⤷ʤ
 */
static void forward_char_cursor_on_page(plane, rcol)
    PAGEPLANE *plane;
    register int rcol;
{
    register PAGELINE *cur = plane->curLineBuf;
    register u_char *ptr = plane->curPtr;
    while (rcol > 0) {
	/* nchar  LineBuffer cur  ptr ˤʸ */
	int nchar = cur->nchar - JEUC_StrNChar(ptr - cur->buffer, cur->buffer);
	if (rcol <= nchar) {
	    /* Ū֤Ϥ LineBuffer Ǥ */
	    ptr += JEUC_StrLen(rcol, ptr);
	    plane->curCol += rcol;
	    rcol = 0;
	} else if (cur->nextBuf != (PAGELINE *)NULL) {
	    /* Ū֤Ϥ LineBuffer  LineBuffer 
	     *  */
	    cur = cur->nextBuf;
	    ptr = cur->buffer;	/* LineBuffer Ƭ */
	    plane->curCol += nchar; /* nchar ʸʤ */
	    rcol -= nchar;
	} else {
	    /* Ū֤Ϥ LineBuffer  LineBuffer 
	     * 뤬⤦ LineBuffer ¸ߤʤ
	     * plane->defChar Ƥ LineBuffer  */
	    register int leng;
	    register PAGELINE *new;
	    leng = JEUC_StrLen(MIN((rcol-nchar),plane->defCharNChar),
			       plane->defCharStr);
	    new = allocate_line_buffer_for_string(plane, plane->defCharFont,
						  leng, plane->defCharStr);
	    insert_line_buffer(new, cur);
	    if (new->fontID == cur->fontID) reduce_line_buffer_link(cur);
	    if (cur->nextBuf) {
		cur = cur->nextBuf;
		ptr = cur->buffer;	/* LineBuffer Ƭ */
		rcol -= nchar;	/* nchar ʸʤ */
		plane->curCol += nchar;
	    }
	}
    }
    plane->curLineBuf = cur;
    plane->curPtr = ptr;
    /*NoReturnValue*/
}

/* move_char_cursor_on_page(plane, rcol, rrow)
 *
 * plane Ǥʸ֤򸽺ߤΰ֤
 * (rcol,rrow) ư
 */
move_char_cursor_on_page(plane, rcol, rrow)
    PAGEPLANE *plane;
    int rcol, rrow;
{
    PAGELINE *cur;

    /* 岼ؤΰư */
    if (rrow < 0) {
	rcol += plane->curCol;
	up_char_cursor_on_page(plane, rrow);
    } else if (rrow > 0) {
	rcol += plane->curCol;
	down_char_cursor_on_page(plane, rrow);
    }
    /* ؤΰư */
    if (rcol < 0)
	backward_char_cursor_on_page(plane, rcol);
    else if (rcol > 0)
	forward_char_cursor_on_page(plane, rcol);
    /*NoReturnValue*/
}

/* locate_char_cursor_on_page(plane, col, row)
 *
 * plane Ǥʸ֤򤽤Υڡ
 * ɸ (col,row) ˰ư
 */
void locate_char_cursor_on_page(plane, col, row)
    PAGEPLANE *plane;
    int col, row;
{
    move_char_cursor_on_page(plane, col-plane->curCol, row-plane->curRow);
    /*NoReturnValue*/
}


/**********************************************************************
 *
 */

/* init_page_plane(plane, font, leng, str)
 *
 * PagePlane plane 
 * ǥեȤʸեֹ font 
 * Хȿ leng ʸ str Ȥ
 */
void init_page_plane(plane, font, leng, str)
    PAGEPLANE *plane;
    int font;
    int leng;
    u_char *str;
{
    register PAGELINE *cur;
    plane->curCol = plane->curRow = 0;
    plane->lineCtrlBlock = (struct pageline_control_block *)NULL;
    plane->defCharFont = font;
    plane->defCharNChar=JEUC_StrNChar(MIN(leng,sizeof(plane->defCharStr)),str);
    plane->defCharLeng=JEUC_StrLen(plane->defCharNChar,str);
    memcpy(plane->defCharStr, str, plane->defCharLeng);
    cur =plane->curLineTop =plane->curLineBuf =alloc_page_line_buffer(plane);
    plane->curPtr = cur->buffer;
    cur->nextLine = cur->prevLine = (PAGELINE *)NULL;
    cur->nextBuf = cur->prevBuf = (PAGELINE *)NULL;
    /*NoReturnValue*/
}

/* destroy_page_plane(plane)
 *
 * PagePlane plane ΰ
 */
void destroy_page_plane(plane, font, leng, str)
    PAGEPLANE *plane;
{
    register PAGELINE *cur;
    while (plane->lineCtrlBlock != (struct pageline_control_block *)NULL)
	destroy_pageline_control_block(plane->lineCtrlBlock);
    /*NoReturnValue*/
}

void dump_page_plane(plane)
    PAGEPLANE *plane;
{
    int row = 0;
    PAGELINE *ltop = plane->curLineTop;
    DebugSetFunc("page", "dump_page_plane");
    while (ltop->prevLine != (PAGELINE *)NULL)
	ltop = ltop->prevLine;
    for ( ; ltop != (PAGELINE *)NULL ; ltop = ltop->nextLine, row++) {
	register PAGELINE *cur;
	fprintf(stderr, "<%d>", row);
	for (cur = ltop; cur != (PAGELINE *)NULL; cur = cur->nextBuf) {
	    fprintf(stderr, "(%d,%d)[%d]<",
		    cur->baseX, cur->baseY, cur->fontID);
	    if (cur->leng > 0) {
		char buf[1024];
		memcpy(buf, cur->buffer, cur->leng);
		buf[cur->leng] = EOS;
		fputs(buf, stderr);
	    }
	    fputs(">", stderr);
	}
	fputs("<EOL>\n", stderr);
    }
    DebugEndFunc("page", "dump_page_plane");
}






#ifdef PROTODEBUG
main()
{
    char readbuf[1024];
    PAGEPLANE planebuf;
    int overwrite = FALSE;
    (void)init_page_plane(&planebuf, 1, 4, "ABBA");
    while (fgets(readbuf, sizeof(readbuf), stdin) != (char *)NULL) {
	register char *s = readbuf;
	while (*s != EOS && *s != EOL) {
	    if (*s != '$' || *(s+1) == EOS || *(s+1) == EOL) {
		if (overwrite)
		    overwrite_string_on_page(&planebuf, 1, 1, s);
		else
		    insert_string_on_page(&planebuf, 1, 1, s);
		s++;
	    } else {
		int arg = 0;
		s++;
		for (arg = 0; *s >= '0' && *s <= '9'; s++) {
		    arg *= 10; arg += *s - '0';
		}
		if (*s == EOS || *s == EOL)
		    break;
		switch (*s) {
		case 'u':
		    move_char_cursor_on_page(&planebuf, 0, (arg>0?-arg:-1));
		    break;
		case 'd':
		    move_char_cursor_on_page(&planebuf, 0, (arg>0?arg:1));
		    break;
		case 'f':
		    move_char_cursor_on_page(&planebuf, (arg>0?arg:1), 0);
		    break;
		case 'b':
		    move_char_cursor_on_page(&planebuf, (arg>0?-arg:-1), 0);
		    break;
		case 'D':
		    delete_string_on_page(&planebuf, (arg>0?arg:1));
		    break;
		case 'H':
		    move_char_cursor_on_page(&planebuf, -1, 0);
		    delete_string_on_page(&planebuf, 1);
		    break;
		case 'O':
		    overwrite = TRUE;
		    break;
		case 'I':
		    overwrite = FALSE;
		    break;
		case 'P': dump_page_plane(&planebuf); break;
		default:
		    break;
		}
		s++;
	    }
	}
    }
}

#endif /*PROTODEBUG*/

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
