/* $Id: page.h,v 3.0 1992/10/08 04:59:44 keisuke Exp $ */

/****************************************************************************
%%%COPYRIGHT%%%
****************************************************************************/

/****************************************************************************
#
# $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
#			$Date: 1992/10/08 04:59:44 $
# Log:
#  Version 1.0 is written by Keisuke 'Keiko' Tanaka
#				(keisuke@csrl.aoyama.ac.jp)
# 
****************************************************************************/

/* ɸȼºɸδط:
 *
 *  Page Mode Territory 񤭥⡼ɤξ硤ɸ (C,R) 
 * ºɸ (X,Y) δ֤ˤ X=C, V=R δط
 *
 *  Page Mode Territory Ľ񤭥⡼ɤξ硤
 * ⤦äʣˤʤ
 */

struct _char_position {
    int log_x, log_y;	/* Logical Position */
    int phs_x, phs_y;	/* Physical Position */
} ;
typedef struct _char_position	CPOS;

typedef struct {
    int x, y, w, h;
} STRINGBOX;

/**********************************************************************
 * Page Mode Territory Խ֤˴ؤ
 */

/* PageLineBuffer ΰΤι¤ */
struct pageline_control_block {
    struct _page_line_buffer *top;
    struct _page_line_buffer *active;
    struct _page_line_buffer *free;
    struct pageline_control_block *forwCtrlBlock, *backCtrlBlock;
    struct _page_plane *plane;
} ;

/* Ԥιꤹ빽¤
 */
struct _page_line_buffer {
    /* ιԤƬξˤΤͭʾ */
    struct _page_line_buffer *nextLine, *prevLine;
    int redraw;
    /* ƥȥͭʾ */
    int dirty;
    int baseX, baseY;		/* Ūʺɸ򼨤١ɸ򼨤 */
    int endX, endY;		/* Ūʺɸ򼨤١ɸ򼨤 */
    int fontID;			/* եȼ̤򼨤 */
    int nchar, leng;		/* buffer ʸȥǡĹ򼨤 */
    u_char buffer[10];		/* ǡγǼ */
    struct _page_line_buffer *nextBuf, *prevBuf;
    /* Τι */
    struct _page_line_buffer *forw, *back; /* Active/Free Ǥط */
    struct pageline_control_block *ctrlBlock;	/*֥å*/
} ;

/* ڡʿ̤ꤹ빽¤
 */
struct _page_plane {
    /* ʸ˴ؤ */
    int curCol, curRow;			  /* ߤΥ */
    struct _page_line_buffer *curLineTop; /* ΤԤƬ */
    struct _page_line_buffer *curLineBuf; /* Τ LineBuffer */
    u_char *curPtr;			  /* ΰ */
    /* ʸ˴ؤ */
    int defCharFont;		/* եֹ */
    int defCharLeng;		/* ʸĹ(Хȿ) */
    int defCharNChar;		/* ʸʸ */
    u_char defCharStr[4];	/* ʸ */
    /* ڡ° LineBuffer ֥å */
    struct pageline_control_block *lineCtrlBlock;
} ;

typedef struct _page_line_buffer	PAGELINE;
typedef struct _page_plane		PAGEPLANE;

/* ԽΤδؿȥ
 */
typedef struct _input_edit_func_table {
    int leng;
    u_char *chars;
    void (*func)();
    struct _input_edit_func_table *back, *forw;
} YYEDITFUNC;

typedef struct _input_edit_func_list {
    char *label;
    void (*func)();
} YYEDITFUNCLIST;

extern YYEDITFUNC *add_input_edit_func_entry();


/* ڡ⡼ɥƥȥ湽¤
 */
struct _territory_page_control {
    int pcOperationMode;	/* MODE */
    /* (˰¸)ؿȥ */
    /* ɽ˴ط */
    int pcXOffset, pcYOffset;
    int pcHeadOffset, pcTailOffset;
    int pcLineSkip;
    PAGEPLANE pcPagePlane;		/* ʸʿ */
    /* ϽΤΥȥ */
    int inputMode;
    TERRITORY *pcInputTerritory;	/* Ͻѥƥȥ */
    YYEDITFUNC *pcUserEditFuncTab;	/* (桼)ԽѴؿɽ */
    /* Υڡ⡼ɥƥȥ꤬ϽѤξͭʹ */
    int startCol;		/* ϽϤޤä (Ԥ0) */
    PAGEPLANE pcInputPlane;
#ifdef KINPUT
    PAGEPLANE pcKanaInputPlane;
    int pcKInputCurBun;
    PAGEPLANE pcKInputPlane;
#endif /*KINPUT*/
} ;
typedef struct _territory_page_control		TERRITORY_PAGE;

#define GETPAGECOL(pg)		((pg)->pcPagePlane.curCol)
#define GETPAGEROW(pg)		((pg)->pcPagePlane.curRow)
#define GETPAGEFID(pg)		((pg)->pcPagePlane.defCharFont)



extern STRINGBOX *get_string_box();

extern TERRITORY *create_input_territory();


#define PAGEOP_INPUTMODE	03
#define		YYIN_ASCII	0
#define		YYIN_KANA	1
#define		YYIN_KANJI	2
#define		YYIN_STATUS	3
#define PAGEOP_NEEDCURSOR	010
#define PAGEOP_PUTCURSOR	020
#define PAGEOP_ABORT		040
#define PAGEOP_NEEDRESIZEINFO	0100

#define PG_MODE		0303
#define PG_HMODE	0100
#define PG_VMODE	0200
#define PG_LTMODE	0001
#define PG_LBMODE	0002
#define PG_HLT		0101
#define PG_HLB		0102
#define PG_VLT		0201
#define PG_VLB		0202

#define DRAW_TEXT_DIR_H		0
#define DRAW_TEXT_DIR_V		1
#define PAGE_DIR(pg)		(((pg)->pcPageMode & PG_HMODE)? 0: 1)

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
