/* Support Character Input on Page Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: input.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $
 */

#ifndef lint
static char *RcsId =
    "$Id: input.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/06/07 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.3 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.1 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/27 08:10:20 $
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"
#ifdef WNNKINPUT
#include <wnn/rk_spclval.h>
#endif /*WNNKINPUT*/


/**********************************************************************
 *****
 **********************************************************************/

YYEDITFUNC *add_input_edit_func_entry(top, leng, chars, func)
    YYEDITFUNC *top;
    int leng;
    u_char *chars;
    void (*func)();
{
    YYEDITFUNC *new;
    new = (YYEDITFUNC *)memALLOC(sizeof(YYEDITFUNC));
    new->leng = leng;
    new->chars = (u_char *)memALLOC(leng);
    memcpy(new->chars, chars, leng);
    new->func = func;
    new->back = (YYEDITFUNC *)NULL;
    if ((new->forw = top) != (YYEDITFUNC *)NULL)
	top->back = new;
    return new;
}

YYEDITFUNC *delete_input_edit_func_entry(top, ent)
    register YYEDITFUNC *top, *ent;
{
    memFREE(ent->chars);
    if (ent->forw != (YYEDITFUNC *)NULL)
	ent->forw->back = ent->back;
    if (ent->back != (YYEDITFUNC *)NULL)
	ent->back->forw = ent->forw;
    else
	top = ent->forw;
    memFREE(ent);
    return top;
}

void destroy_input_edit_func_table(top)
    register YYEDITFUNC *top;
{
    while (top != (YYEDITFUNC *)NULL) {
	register YYEDITFUNC *ent = top->forw;
	memFREE(top->chars);
	memFREE(top);
	top = ent;
    }
    /*NoReturnValue*/
}

/**********************************************************************
 ***** ƥԽؿơ֥κ
 **********************************************************************/

static void input_ascii_character(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    TERRITORY *input_tr = pg->pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    DebugSetFunc("input", "input_ascii_character");
    *(ptr+leng) = EOS;
    DebugPrint2(5, "Input on TR#%d <%s>\n", input_tr->teID, ptr);
    if (leng > 0) {
	insert_string_on_page(&input_pg->pcPagePlane, GETPAGEFID(input_pg),
			      leng, ptr);
	insert_string_on_page(&input_pg->pcInputPlane, GETPAGEFID(input_pg),
			      leng, ptr);
	redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    }
    /**/
    DebugEndFunc("input", "input_ascii_character");
    /*NoReturnValue*/
}

#ifdef KINPUT
/* pcPagePlane ˤɽԤΤΤޤޤΥ᡼Ϥ
 * pcKanaInputPlane ˤϥե󥹤ΤĤʤʸϤ
 */
static void input_kana_character(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    TERRITORY *input_tr = pg->pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;

    DebugSetFunc("input", "input_kana_character");
    while (leng > 0) {
	register int bytes = JEUC_Bytes(ptr);
	if (JEUC_CodeSet(ptr)!=0 || !iscntrl(*ptr)) {
	    register int fid = GETPAGEFID(input_pg);
	    register int nc;
	    nc = total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);
	    DebugPrint1(9, "%d chars in KanaInputPlane\n", nc);
	    if (nc == 0)
		insert_string_on_page(&input_pg->pcPagePlane, fid, 1, "|");
	    insert_string_on_page(&input_pg->pcPagePlane, fid, bytes, ptr);
	    if (nc == 0) {
		insert_string_on_page(&input_pg->pcPagePlane, fid, 1, "|");
		move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
	    }
	    insert_string_on_page(&input_pg->pcKanaInputPlane,
				  fid, bytes, ptr);
	}
	leng -= bytes;
	ptr += bytes;
    }
    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    DebugEndFunc("input", "input_kana_character");
    /*NoReturnValue*/
}

/* ⡼ɤǤ̾ʸ
 * ->
 * ֤ˤƤϤȤư
 */
static void input_char_in_kanji_mode(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    TERRITORY *input_tr = pg->pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;

    DebugSetFunc("input", "input_char_in_kanji_mode");
    if (leng > 0) {
	kanji_kakutei(ch, tr);
	unget_keyin_on_input_territory(YYIN_KANA, leng, ptr);
    }
    DebugEndFunc("input", "input_char_in_kanji_mode");
    /*NoReturnValue*/
}
#endif KINPUT



static YYEDITFUNC *YYSystemInputEditFuncTab[YYIN_STATUS] =
    { (YYEDITFUNC *)NULL, (YYEDITFUNC *)NULL, (YYEDITFUNC *)NULL};

static YYEDITFUNCLIST YYSystemDefaultEditFuncTab[YYIN_STATUS] = {
{ "", input_ascii_character },	/* ASCII ϻΥǥե */
#ifdef KINPUT
{ "", input_kana_character },
{ "", input_char_in_kanji_mode }
#else
{ "", NULL },
{ "", NULL }
#endif
} ;



struct _yy_input_edit_func_prefix {
    char *prefix;
    int type;
} ;

static struct _yy_input_edit_func_prefix
    YYInputEditFuncPrefixTab[] = {
{ "", YYIN_ASCII },
#ifdef KINPUT
{ "kana", YYIN_KANA },
{ "kanji", YYIN_KANJI },
#endif /*KINPUT*/
{ (char *)NULL, (-1) }
} ;

static int get_edit_func_type(label)
    char *label;
{
    register struct _yy_input_edit_func_prefix *p;
    char work[32];
    register char *s;
    strncpy(work, label, sizeof(work));
    work[sizeof(work)-1] = EOS;
    if ((s = strchr(work, ':')) != NULL)
	*s = EOS;
    else
	work[0] = EOS;
    for (p = YYInputEditFuncPrefixTab; p->prefix != (char *)NULL; p++)
	if (strSAME(p->prefix, work))
	    break;
    return p->type;
}

extern YYEDITFUNCLIST YYInputEditFuncList[];
#ifdef KINPUT
extern YYEDITFUNCLIST YYKanaInputEditFuncList[];
extern YYEDITFUNCLIST YYKanjiInputEditFuncList[];
#endif /*KINPUT*/

static YYEDITFUNCLIST *FuncListTable[YYIN_STATUS] = {
#ifdef KINPUT
    YYInputEditFuncList, YYKanaInputEditFuncList, YYKanjiInputEditFuncList
#else /*!KINPUT*/
    YYInputEditFuncList, NULL, NULL
#endif /*!KINPUT*/
    } ;

void *get_edit_func_entry(list, label)
    YYEDITFUNCLIST *list;
    char *label;
{
    if (list == (YYEDITFUNCLIST *)NULL)
	return NULL;
    for ( ; list->label != (char *)NULL; list++)
	if (strSAME(list->label,label))
	    return list->func;
    return NULL;
}

static int get_edit_character(ptr)
    u_char *ptr;
{
    register char c1, c2, c3, c4, c5;
    c1 = *ptr++; c2 = *ptr++;
    c3 = *ptr++; c4 = *ptr++; c5 = *ptr++;

    if (JEUC_CodeSet(ptr) != 0 || !isprint(c1) || c1 == '#' || c1 == '%')
	return (-1);
    if (c1 == '^') {
	/* ɽ ^[a-zA-Z] Τ */
	if (isalpha(c2) && isspace(c3))
	    return(c2 & 037); /* ASCII code ꤷƤ */
	return (-1);
    }
    if (c1 == BACKSLASH) {
	/* ɽ \[0-9][0-9][0-9]  \[ASCII] Τ */
	if (isdigit(c2) && isdigit(c3) && isdigit(c4) && isspace(c5))
	    return(((c2-'0')<<6) + ((c3-'0')<<3) + (c4-'0'));
	else if (isprint(c2) && isspace(c3))
	    return c2;
	return (-1);
    }
    if (isspace(c2))
	return c1;
    return (-1);
}

void init_edit_func_table(file)
    char *file;
{
    int i;
    FILE *fp;
    char buf[BUFSIZ];

    DebugSetFunc("input", "init_edit_func_table");
    /* ꤵƤϤΰ
     */
    for (i = YYIN_STATUS; i > 0; ) {
	i--;
	if (YYSystemInputEditFuncTab[i] != (YYEDITFUNC *)NULL) {
	    destroy_input_edit_func_table(YYSystemInputEditFuncTab[i]);
	    YYSystemInputEditFuncTab[i] = (YYEDITFUNC *)NULL;
	}
    }

    if ((fp = fopen(file, "r")) == NULL) {
	char fpath[512];
	sprintf(fpath, "%s/%s", YYLIBDIR, file);
	fp = fopen(fpath, "r");
    }

    if (fp != NULL) {
	/* ԤȤɤԽؿơ֥
	 * ƹԤ
	 *   ƤӽФΥ    ؿ٥
	 * Ȥ¤ˤʤäƤ
	 * ؿ٥ˤ kana:  kanji: ʤɤֻ줬ĤȤ
	 */
	while (fgets(buf, sizeof(buf), fp) != (char *)NULL) {
	    int c;
	    char *s, *label, *tail;
	    int type;
	    void (*func)();
	    if ((c = get_edit_character(buf)) < 0)
		continue; /* ʤ/ȤǤ */
	    buf[0] = c; /* ɤ buf[0] ¸ */

	    /* s ؿ٥Ƭ򼨤
	     * label ϴؿ̾ΤƬtail ϴؿ٥κǸ򼨤
	     */
	    s = &buf[1];
	    if (!isspace(*s))
		while (*s != EOS && !isspace(*s)) s++; /*ʸ򥹥å*/
	    while (*s != EOS && isspace(*s)) s++; /*ڤ򥹥å*/
	    if (*s == EOS) continue; /* ԴʹԤǤ */
	    tail = s;
	    while (*tail != EOS && !isspace(*tail)) tail++;
	    *tail = EOS;
#ifdef KINPUT
	    if ((label = strchr(s, ':')) != (char *)NULL) {
		/* kana:function-label ʤֻդ */
		if ((type = get_edit_func_type(s)) < 0) continue;
		label++;
	    } else {
		type = YYIN_ASCII;
		label = s;
	    }
#else /*!KINPUT*/
	    type = YYIN_ASCII;
	    label = s;
#endif /*!KINPUT*/
	    DebugPrint3(5, " Edit Function '%s'(type:%d) for KeyCode '0%o'\n",
			label, type, buf[0]);
	    func = get_edit_func_entry(FuncListTable[type], label);
	    if (func != NULL)
		YYSystemInputEditFuncTab[type] =
		    add_input_edit_func_entry(YYSystemInputEditFuncTab[type],
					      1, buf, func);
	}
	fclose(fp);
    }

    DebugEndFunc("input", "init_edit_func_table");
    /*NoReturnValue*/
}


/**********************************************************************
 * Խؿ
 **********************************************************************/

static void *get_input_edit_function_entry(tab, leng, ptr)
    YYEDITFUNC *tab;
    int leng;
    u_char *ptr;
{
    for ( ; tab != NULL; tab = tab->forw) {
	register int l = tab->leng;
	register u_char *s = tab->chars;
	for (l = tab->leng, s = tab->chars; l > 0; l--, s++)
	    if (*s == *ptr) return tab->func;
    }
    return NULL;
}

/* get_input_edit_function(mode, tab, leng, ptr)
 *
 * ڡ⡼ɤϤ줿ʸĹ leng (Хȿ)ʸ ptr Ф
 * Խؿ
 * tab ƬȤ桼ؿơ֥Ǹ
 * mode ˱ƥؿơ֥򸡺
 */
void *get_input_edit_function(mode, tab, leng, ptr)
    int mode;
    YYEDITFUNC *tab;
    int leng;
    u_char *ptr;
{
    register void (*func)();
    if (leng != 1 || JEUC_CodeSet(ptr)!=0)
	return NULL;
    if ((func = get_input_edit_function_entry(tab, leng, ptr)) == NULL)
	func = get_input_edit_function_entry(YYSystemInputEditFuncTab[mode],
					     leng, ptr);
    return func;
}

/*
 * KeyInput
 */

static void put_initial_string_on_page(ch, tr, pg, input_tr, input_pg,
				       col, lin)
    yy_comm_channel *ch;
    TERRITORY *tr, *input_tr;
    TERRITORY_PAGE *pg, *input_pg;
    int col, lin;
{
}

/* create_input_territory(ch, tr, col, row, mode)
 *
 * PageModeTerritory tr ѤΥڡ⡼ɥƥȥ
 * 
 * ƥȥϸΥƥȥ tr  <col,row> ΰ֤
 * Ͻ򳫻Ϥ
 */
TERRITORY *create_input_territory(ch, tr, col, row, mode)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int col, row;
    int mode;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    TERRITORY *input_tr = (TERRITORY *)NULL;
    TERRITORY_PAGE *input_pg;
    STRINGBOX *sb;
    int err_code;

    DebugSetFunc("page", "create_input_territory");
    DebugPrint3(3, "Create Input Territory on <%d,%d> of Page#%d \n",
		col, row, tr->teID);
    locate_char_cursor_on_page(&pg->pcPagePlane, col, row);
    redraw_page_plane(ch, tr, &pg->pcPagePlane);
    sb = get_string_box(ch, &pg->pcPagePlane, col, row, col+1, row);
    DebugPrint4(3, "Territory size: x: %d y: %d w * h: %d * %d \n",
				 sb->x,sb->y, tr->teWidth, sb->h);
#ifdef DEBUG
    printf("Create Territory size: x: %d y: %d w * h: %d * %d \n",
				 sb->x,sb->y, tr->teWidth, sb->h);
#endif /*DEBUG*/
#ifndef VERSION104
    input_tr = create_territory(ch, 49999, sb->x, sb->y, tr->teWidth, sb->h,
				tr->teID, TRUE, TRUE, TR_PAGE, &err_code);
#else /*VERSION104*/
    input_tr = create_territory(ch, sb->x, sb->y, tr->teWidth, sb->h,
				tr->teID, TRUE, TRUE, TR_PAGE, &err_code);
#endif /*VERSION104*/
    if (input_tr == (TERRITORY *)NULL)
	goto send_reply;
    /* GC  */
    XCopyGC(xp->xDisp, XEntry(tr)->txGC,
	    (GCForeground|GCBackground), XEntry(input_tr)->txGC);
    XSetFunction(xp->xDisp, XEntry(input_tr)->txGC, GXcopy);
    /* Page Ф° */
    input_pg = &input_tr->teModeEnt.tPageControl;
    init_page_plane(&input_pg->pcPagePlane, GETPAGEFID(pg), 4, "    ");
    locate_char_cursor_on_page(&input_pg->pcPagePlane, 0, 0);
    input_pg->pcHeadOffset = pg->pcHeadOffset;
    input_pg->pcTailOffset = pg->pcTailOffset;
    input_pg->pcLineSkip = pg->pcLineSkip;
    input_pg->pcOperationMode = (YYIN_ASCII|PAGEOP_NEEDCURSOR);
    input_pg->pcInputTerritory = (TERRITORY *)NULL;
    input_pg->inputMode = YYIN_ASCII;
    input_pg->startCol = col;
    init_page_plane(&input_pg->pcInputPlane, GETPAGEFID(pg), 4, "    ");
    locate_char_cursor_on_page(&input_pg->pcInputPlane, 0, 0);
#ifdef KINPUT
    init_page_plane(&input_pg->pcKanaInputPlane, GETPAGEFID(pg), 4, "    ");
    locate_char_cursor_on_page(&input_pg->pcKanaInputPlane, 0, 0);
    init_page_plane(&input_pg->pcKInputPlane, GETPAGEFID(pg), 4, "    ");
    locate_char_cursor_on_page(&input_pg->pcKInputPlane, 0, 0);
#endif /*KINPUT*/
    pg->pcOperationMode &= ~PAGEOP_ABORT;
    if (col > 0) {
	/* tr  <0,row>  <col,row> ޤǤʸǥեʸȤ
	 * ɽ */
	register int read_col = col;
	PAGEPLANE *plane = &pg->pcPagePlane;
	u_char buf[16];
	DebugPrint1(9, " read_col = %d\n", read_col);
	move_char_cursor_on_page(plane, -col, 0);
	while (read_col > 0) {
	    register int nchar = MIN(read_col, (sizeof(buf)>>1));
	    register int leng;
	    leng = get_string_on_page(plane, nchar, buf);
	    nchar = JEUC_StrNChar(leng, buf);
	    insert_string_on_page(&input_pg->pcPagePlane, GETPAGEFID(pg),
				  leng, buf);
	    move_char_cursor_on_page(plane, nchar, 0);
	    read_col -= nchar;
	    DebugPrint1(9, " nchar = %d\n", nchar);
	}
    } else {
	input_pg->pcPagePlane.curLineTop->dirty = TRUE;
    }
    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    if (input_pg->pcOperationMode & PAGEOP_NEEDCURSOR) {
	(void)put_char_cursor_on_page(ch, input_tr);
	input_pg->pcOperationMode |= (PAGEOP_PUTCURSOR);
    }
    sync_x_server(xp);
 send_reply:
    DebugEndFunc("page", "create_input_territory");
    return input_tr;
}

static int total_nchar_in_input_page(ipg)
    TERRITORY_PAGE *ipg;
{
    register int nc;
    register PAGELINE *top = ipg->pcInputPlane.curLineTop;
    /* Page ƬޤǤΤܤ */
    while (top->prevLine != (PAGELINE *)NULL) top = top->prevLine;
    for (nc = 0; /* λϥ롼*/ ; nc++/*ʸʬä*/) {
	nc += total_nchar_in_line_buffer(top);
	if ((top = top->nextLine) == (PAGELINE *)NULL)
	    break;
    }
    return nc;
}




/* abort_input_procedure(ch, tr)
 *
 * Ͻ
 * ѥƥȥ¸ߤʸ tr ˤĤ
 * ѥƥȥ˲
 */
void abort_input_procedure(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    TERRITORY *input_tr = pg->pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    u_char buf[512];
    int nchar;
    int size;

    DebugSetFunc("input", "abort_input_procedure");
    locate_char_cursor_on_page(&input_pg->pcInputPlane, 0, 0);
    nchar = total_nchar_in_input_page(input_pg);
    if (nchar > 0) {
	size = get_string_on_page(&input_pg->pcInputPlane, nchar, buf);
	insert_string_on_page(&pg->pcPagePlane, GETPAGEFID(pg), size, buf);
	redraw_page_plane(ch, tr, &pg->pcPagePlane);
    }
    pg->pcOperationMode = PAGEOP_ABORT;
    DebugEndFunc("input", "abort_input_procedure");
    /*NoReturnValue*/
}

/* send_input_status(ch, tr)
 *
 */
void send_input_status(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY_PAGE *pg = &tr->teModeEnt.tPageControl;
    TERRITORY *input_tr = pg->pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    yy_packet *event;
    u_char buf[512];
    int nchar;
    int size;
    int col, row;

    DebugSetFunc("page", "send_input_status");
    /* ѥѥåȤ */
    event = ALLOC_EVENTPACKET(YYCOMMAND_KEY_EVENT);
    append_packet_entry_integer(event, tr->teID);
    col = input_pg->pcInputPlane.curCol;
    row = input_pg->pcInputPlane.curRow;
    locate_char_cursor_on_page(&input_pg->pcInputPlane, 0, 0);
    nchar = total_nchar_in_input_page(input_pg);
    DebugPrint1(5, "Send %d chars to client\n", nchar);
    DebugPrint1(9, " Event Pagcket %x\n", event);
    if (nchar > 0) {
	size = get_string_on_page(&input_pg->pcInputPlane, nchar, buf);
	buf[size] = EOS;
	DebugPrint2(5, "String <%d>'%s'\n", size, buf);
	DebugPrint1(9, " Event Pagcket %x\n", event);
	append_packet_entry_string_with_length(event, size, buf);
	DebugPrint1(9, " Event Pagcket %x\n", event);
    } else {
	append_packet_entry_integer(event, size);
	append_packet_entry_integer(event, size); /*DUMMY*/
    }
    put_packet_on_sendq(QUE(ch), event);
    locate_char_cursor_on_page(&input_pg->pcInputPlane, col, row);
    DebugEndFunc("page", "send_input_status");
    /*NoReturnValue*/
}



void input_terminate_keyin(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    void (*func)();
    func = YYSystemDefaultEditFuncTab[YYIN_ASCII].func;
    if (func != NULL) (*func)(ch, tr, leng, ptr);
    send_input_status(ch, tr);
    abort_input_procedure(ch, tr);
}

void input_send_keyin_status(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    void (*func)();
    func = YYSystemDefaultEditFuncTab[YYIN_ASCII].func;
    if (func != NULL) (*func)(ch, tr, leng, ptr);
    send_input_status(ch, tr);
}



#ifdef KINPUT
extern void push_kana_keyinput();
extern int romkan_getc();
#endif /*KINPUT*/

static struct {
    int mode;
    int leng;
    u_char buf[4];
} KeyinUngetBuf;

unget_keyin_on_input_territory(mode, leng, ptr)
    int mode;
    int leng;
    u_char *ptr;
{
    KeyinUngetBuf.mode = mode;
    KeyinUngetBuf.leng = leng;
    memcpy(KeyinUngetBuf.buf, ptr, leng);
    /*NoReturnValue*/
}

static struct {
    void (*push_func)();
    int (*read_keyin)();
} YYSystemKeyinFuncTab[YYIN_STATUS] = {
{ NULL, NULL },
#ifdef KINPUT
{ push_kana_keyinput, romkan_getc },
#else /*!KINPUT*/
{ NULL, NULL },
#endif /*!KINPUT*/
{ NULL, NULL }
} ;


/* Ϥä˸ƤӽФ
 *
 * Ϥ줿ȸߤϾ֤˱ԽѤδؿƤӽФ
 */
void keyin_on_input_territory(ch, tr, leng, str)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *str;
{
    /* Ϥ줿ʸ򸫤ưʲ input_ function 椫Ĥ
       ӸƤӽФ
       */
    TERRITORY_PAGE *pg;
    TERRITORY *input_tr;
    TERRITORY_PAGE *input_pg;
    int mode;
    void (*func)();
    YYEDITFUNC *usertab;
    u_char *ptr;

    DebugSetFunc("input", "keyin_on_input_territory");
    pg = &tr->teModeEnt.tPageControl;
   /* Ͼ֤ˤʤäƤʤ goto send_reply */
    if ((input_tr = pg->pcInputTerritory) == (TERRITORY *)NULL)
	goto send_reply;
    input_pg = &input_tr->teModeEnt.tPageControl;
    /* ɽƤХõ */
    if (input_pg->pcOperationMode & PAGEOP_PUTCURSOR) {
	(void)put_char_cursor_on_page(ch, input_tr);
	input_pg->pcOperationMode &= (~PAGEOP_PUTCURSOR);
    }
    /* ⡼ɤ
     * get_input_edit_function() ƤӽФ
     * ؿ줿ʤ餳ƤӽФ
     * ʤäϥ⡼ɤ˱ǥեȴؿƤӽФ
     */
    mode = (input_pg->pcOperationMode & PAGEOP_INPUTMODE);
    usertab = (mode == YYIN_ASCII? pg->pcUserEditFuncTab: (YYEDITFUNC *)NULL);

    ptr = str;
 retry:
    KeyinUngetBuf.leng = 0;
    /*  push ؿФԤʤ */
#ifdef KINPUT
    if (YYSystemKeyinFuncTab[mode].push_func != NULL) {
	extern letter *curdis;
	extern int kana_keyin_depth;
	(*YYSystemKeyinFuncTab[mode].push_func)(leng, ptr);
	while (kana_keyin_depth > 0 || *curdis != EOLTTR) {
	    register u_int i; u_char work[4];
	    register int len;
	    i = (*YYSystemKeyinFuncTab[mode].read_keyin)();
	    DebugPrint1(9, " Keyin - code 0x%x\n", i);
	    if (i == EOLTTR || i == CHMSIG || i == NISEBP ||
		i == LTREOF || i == REDRAW || i == NISEDL)
		break;
	    len = 1;
	    if ((work[0] = ((i>>8) & 0377)) != 0) len++;
	    work[len-1] = (i & 0377);
	    func = get_input_edit_function(mode, usertab, len, work);
	    if (func == NULL) func = YYSystemDefaultEditFuncTab[mode].func;
	    if (func != NULL)
		(*func)(ch, tr, len, work);
	}
    } else {
	func = get_input_edit_function(mode, usertab, leng, ptr);
	if (func == NULL) func = YYSystemDefaultEditFuncTab[mode].func;
	if (func != NULL) (*func)(ch, tr, leng, ptr);
    }
#else /*!KINPUT*/
    func = get_input_edit_function(mode, usertab, leng, ptr);
    if (func == NULL) func = YYSystemDefaultEditFuncTab[mode].func;
    if (func != NULL) (*func)(ch, tr, leng, ptr);
#endif /*!KINPUT*/
    if (KeyinUngetBuf.leng > 0) {
	mode = (KeyinUngetBuf.mode & PAGEOP_INPUTMODE);
	usertab = (mode == YYIN_ASCII?
		   pg->pcUserEditFuncTab: (YYEDITFUNC *)NULL);
	leng = KeyinUngetBuf.leng;
	ptr = KeyinUngetBuf.buf;
	goto retry;
    }

    /* ɽɬפǤХɽ */
    if (input_pg->pcOperationMode & PAGEOP_NEEDCURSOR) {
	(void)put_char_cursor_on_page(ch, input_tr);
	input_pg->pcOperationMode |= (PAGEOP_PUTCURSOR);
    }
    if (pg->pcOperationMode & PAGEOP_ABORT) {
	/* ΰ˲ */
	destroy_page_plane(&input_pg->pcPagePlane);
	destroy_page_plane(&input_pg->pcInputPlane);
#ifdef KINPUT
	destroy_page_plane(&input_pg->pcKanaInputPlane);
#endif /*KINPUT*/
	destroy_territory(ch, input_tr, TRUE);
	pg->pcInputTerritory = (TERRITORY *)NULL;
    }

    sync_x_server(XPRIVATE(ch));
 send_reply:
    DebugEndFunc("input", "keyin_on_input_territory");
    /*NoReturnValue*/
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
