/* Function to load (animation) data files
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: image.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId=
    "$Id: image.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <rasterfile.h>
#include <sys/types.h>
#include <sys/mman.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"

#define IMAGE_TYPE		07
#define IMAGE_BW		01
#define IMAGE_GRAY		02
#define IMAGE_COLOR		04

/* YY եޥåȤĥեΥإå */
struct yyimagehead {
    int ihMagic;		/* Magic No. */
    int ihType;			/* BW/GRAY/COLOR */
    int ihWidth;		/* ǡ(ԥñ) */
    int ihHeight;		/* ǡι⤵(ԥñ) */
} ;
typedef struct {
    int imfFD;			/* read оݤȤʤեǥץ */
    int imfSize;		/* եХȿ */
    union {
	int magic;
	struct yyimagehead yy_head;	/* YYեޥåȥإå */
	struct rasterfile ras_head;	/* Sun饹եإå */
    } imfHead;
    caddr_t imfImage;		/* ᡼եǡ */
    caddr_t imfMap;		/* 顼ޥåפƬ */
    caddr_t imfPtr;		/* */
} IMAGEFILE;
/* YY format Τ */
#define imfYYMagic	imfHead.yy_head.ihMagic
#define imfYYType	imfHead.yy_head.ihType
#define imfYYWidth	imfHead.yy_head.ihWidth
#define imfYYHeight	imfHead.yy_head.ihHeight
/* Rasterfile Τ */
#define imfRasMagic	imfHead.ras_head.ras_magic
#define imfRasWidth	imfHead.ras_head.ras_width
#define imfRasHeight	imfHead.ras_head.ras_height
#define imfRasDepth	imfHead.ras_head.ras_depth
#define imfRasLength	imfHead.ras_head.ras_length
#define imfRasType	imfHead.ras_head.ras_type
#define imfRasMapType	imfHead.ras_head.ras_maptype
#define imfRasMapLength	imfHead.ras_head.ras_maplength


/* void close_image_file(imf)
 *
 * ᡼ե imf 򥯥
 */
static void close_image_file(imf)
    IMAGEFILE *imf;
{
    DebugSetFunc("animation", "close_image_file");
    if (imf != (IMAGEFILE *)NULL) {
	if (imf->imfImage != (caddr_t)0 &&
	    imf->imfImage != (caddr_t)(-1))
	    munmap(imf->imfImage, imf->imfSize);
	if (imf->imfFD >= 0) close(imf->imfFD);
	memFREE((caddr_t)imf);
    }
    DebugEndFunc("animation", "close_image_file");
}

/* ӥåȥޥåץ᡼ե open 
 * mmap Ȥäƥ֤ĥդ
 */
static IMAGEFILE *open_image_file(fpath)
    char *fpath;
{
    IMAGEFILE *imf;
    struct stat sbuf;
    int magic;

    DebugSetFunc("animation", "open_image_file");
    imf = (IMAGEFILE *)memALLOC(sizeof(IMAGEFILE));
    if ((imf->imfFD = open(fpath, O_RDONLY)) < 0 ||
	fstat(imf->imfFD, &sbuf) < 0) {
	close_image_file(imf);
	DebugEndFunc("animation", "open_image_file");
	return (IMAGEFILE *)NULL;
    }
    imf->imfSize = sbuf.st_size;
    DebugPrint2(5, "File '%s' - size %d bytes\n", fpath, imf->imfSize);
    imf->imfImage = mmap((caddr_t)0, sbuf.st_size, PROT_READ,
			 MAP_PRIVATE, imf->imfFD, (off_t)0);
    if (imf->imfImage == (caddr_t)(-1)) {
	close_image_file(imf);
	DebugEndFunc("animation", "open_image_file");
	return (IMAGEFILE *)NULL;
    }
    /* ե륿פ */
    bcopy(imf->imfImage, (char *)&magic, 4);
    /*fprintf(stderr, "MAGIC #%d\n", magic);*/
    if (magic == YYPROTO_MAGIC) {
	DebugPrint1(5, "Image File has YY-Format (Header Size: %d)\n",
		    sizeof(imf->imfHead.yy_head));
	bcopy(imf->imfImage, (char *)&imf->imfHead.yy_head,
	      sizeof(imf->imfHead.yy_head));
	imf->imfMap = (caddr_t)NULL;
	imf->imfPtr = imf->imfImage + sizeof(imf->imfHead.yy_head);
	DebugPrint1(6, "MAGIC # = %d\n", imf->imfYYMagic);
	DebugPrint1(6, "TYPE = %d\n", imf->imfYYType);
	DebugPrint1(6, "WIDTH = %d\n", imf->imfYYWidth);
	DebugPrint1(6, "HEIGHT = %d\n", imf->imfYYHeight);
    } else if (magic == RAS_MAGIC) {
	struct rasterfile head_ras;
	DebugPrint0(5, "Image File has Sun Rasterfile Format\n");
	bcopy(imf->imfImage, (char *)&imf->imfHead.ras_head,
	      sizeof(imf->imfHead.ras_head));
	imf->imfMap = imf->imfImage + sizeof(imf->imfHead.ras_head);
	imf->imfPtr = imf->imfMap + imf->imfRasMapLength;
	DebugPrint1(6, "MAGIC # = %d\n", imf->imfRasMagic);
	DebugPrint1(6, "WIDTH # = %d\n", imf->imfRasWidth);
	DebugPrint1(6, "HEIGHT # = %d\n", imf->imfRasHeight);
	DebugPrint1(6, "DEPTH # = %d\n", imf->imfRasDepth);
	DebugPrint1(6, "LENGTH # = %d\n", imf->imfRasLength);
	DebugPrint1(6, "TYPE # = %d\n", imf->imfRasType);
	DebugPrint1(6, "MAPTYPE # = %d\n", imf->imfRasMapType);
	DebugPrint1(6, "MAPLENGTH # = %d\n", imf->imfRasMapLength);
    } else {
	DebugPrint0(5, "Unknown Image File Format\n");
	close_image_file(imf);
	imf = (IMAGEFILE *)NULL;
    }
    DebugEndFunc("animation", "open_image_file");
    return imf;
}


#include <sys/time.h>

static void read_image1(ch, im, width, height, image)
    yy_comm_channel *ch;
    IMAGEFILE *im;
    int width, height;
    XImage *image;
{
    x_private *xp = XPRIVATE(ch);
    register int x, y;
    struct timeval start, stop;
    int time;
    XColor color;
    register char *p;
    int loop;

    DebugSetFunc("animation", "read_image1");
    DebugPrint0(5, "TYPE#1\n");
    gettimeofday(&start, NULL);
    p = im->imfPtr + 2;
    for (y = 0; y < im->imfYYHeight; y++)
	for (x = 0; x < im->imfYYWidth; x++) {
	    bcopy(p, &color.red, 2); p += 4;
	    bcopy(p, &color.green, 2); p += 4;
	    bcopy(p, &color.blue, 2); p += 4;
	    XAllocColor(xp->xDisp, xp->xColor, &color);
	    XPutPixel(image, x, y, color.pixel);
	}
    gettimeofday(&stop, NULL);
    DebugPrint4(5, "START: %ld.%ld, STOP: %ld.%ld\n",
		start.tv_sec, start.tv_usec, stop.tv_sec, stop.tv_usec);
    time = (stop.tv_sec - start.tv_sec) * 1000;
    time += ((stop.tv_usec - start.tv_usec)/1000);
    DebugPrint1(5, " TIME: %d\n", time);
    DebugEndFunc("animation", "read_image1");
}

#define RGBDIFF(c1,c2)	(((c1).red^(c2).red)+((c1).green^(c2).green)+((c1).blue^(c2).blue))

static void read_image2(ch, im, width, height, image)
    yy_comm_channel *ch;
    IMAGEFILE *im;
    int width, height;
    XImage *image;
{
    x_private *xp = XPRIVATE(ch);
    register int x, y;
    XColor color;
    register char *p1, *p2;
    int loop;
    int *pixel1, *px1;
    XColor c1, c2;

    int hit = 0;
    struct timeval start, stop;
    int time;

    DebugSetFunc("animation", "read_image2");
    DebugPrint0(5, "TYPE#2\n");
    gettimeofday(&start, NULL);

    pixel1 = (int *)calloc(im->imfYYWidth, sizeof(int));
    p1 = im->imfPtr + 2;
    for (y = 0; y < im->imfYYHeight; y++) {
	px1 = pixel1;
	/* 1ΥɥåȤξ c1  */
        bcopy(p1, &c1.red, 2); bcopy(p1+4, &c1.green, 2);
	bcopy(p1+8, &c1.blue, 2); p1 += 12;
	color.red = c1.red; color.green = c1.green; color.blue = c1.blue;
	XAllocColor(xp->xDisp, xp->xColor, &color);
	XPutPixel(image, 0, 0, (*px1++ = color.pixel));
	for (x = 1; x < im->imfYYWidth; x++) {
	    /* ٤Υɥå */
	    register int diff;
	    bcopy(p1, &c2.red, 2);bcopy(p1+4, &c2.green, 2);
	    bcopy(p1+8, &c2.blue, 2); p1 += 12;
	    if (RGBDIFF(c1,c2) < 100) {
		hit++;
		XPutPixel(image, x, y, (*px1 = *(px1-1)));
		px1++;
	    } else {
		color.red = c2.red; color.green = c2.green;
		color.blue = c2.blue;
		XAllocColor(xp->xDisp, xp->xColor, &color);
		XPutPixel(image, x, y, (*px1++ = color.pixel));
	    }
	    c1.red = c2.red; c1.green = c2.green; c1.blue = c2.blue;
	}
    }
    gettimeofday(&stop, NULL);
    DebugPrint4(5, "START: %ld.%ld, STOP: %ld.%ld\n",
		start.tv_sec, start.tv_usec, stop.tv_sec, stop.tv_usec);
    time = (stop.tv_sec - start.tv_sec) * 1000;
    time += ((stop.tv_usec - start.tv_usec)/1000);
    DebugPrint2(5, " TIME: %d\n HIT: %d", time, hit);
    DebugEndFunc("animation", "read_image2");
}

#define RGBPDIFF(c1,c2)	(((c1)->red^(c2)->red)+((c1)->green^(c2)->green)+((c1)->blue^(c2)->blue))

static void read_image3(ch, im, width, height, image)
    yy_comm_channel *ch;
    IMAGEFILE *im;
    int width, height;
    XImage *image;
{
    x_private *xp = XPRIVATE(ch);
    int x, y;
    XColor *ctab1, *ctab2;
    XColor color, *c1, *cp1, *c2;
    char *ptr;
    /* ʲϽפΤѿ */
    int hit = 0;
    int time;
    struct timeval start, stop;

    DebugSetFunc("animation", "read_image3");
    DebugPrint0(5, "TYPE#3\n");
    gettimeofday(&start, NULL);

    /* ǽΥǡƬ2ХȰưȤ
     *  (ǡ4ХȤƬ2ХȤ X Ǥϰ̣ʤ)
     */
    ptr = im->imfPtr + 2;
    /* 顼ǡΰ¸ */
    ctab1 = (XColor *)calloc(im->imfYYWidth, sizeof(XColor));
    ctab2 = (XColor *)calloc(im->imfYYWidth, sizeof(XColor));

    /* 1ξ ctab1 
     */
    c1 = cp1 = ctab1;
    /* ֺΥɥåȤξ */
    bcopy(ptr, &c1->red, 2); bcopy(ptr+4, &c1->green, 2);
    bcopy(ptr+8, &c1->blue, 2); ptr += 12;
    color.red = c1->red; color.green = c1->green; color.blue = c1->blue;
    XAllocColor(xp->xDisp, xp->xColor, &color);
    XPutPixel(image, 0, 0, (c1->pixel = color.pixel));
    for (c1++, x = 1; x < im->imfYYWidth; x++, c1++, cp1++) {
	/* ٤ΥɥåȤξ */
	bcopy(ptr, &c1->red, 2); bcopy(ptr+4, &c1->green, 2);
	bcopy(ptr+8, &c1->blue, 2); ptr += 12;
	if (RGBPDIFF(c1,cp1) < 100) {
	    XPutPixel(image, x, 0, (c1->pixel = cp1->pixel));
	    hit++;
	} else {
	    color.red = c1->red; color.green = c1->green;
	    color.blue = c1->blue;
	    XAllocColor(xp->xDisp, xp->xColor, &color);
	    XPutPixel(image, x, 0, (c1->pixel = color.pixel));
	}
    }

    /* 2ʹߤγˤĤĴ
     */
    for (y = 1; y < im->imfYYHeight; y++) {
	register XColor *temp;
	temp = ctab1; ctab1 = ctab2; ctab2 = temp;
	c1 = cp1 = ctab1; c2 = ctab2;
	/* ֺΥɥåȤξ */
	bcopy(ptr, &c1->red, 2); bcopy(ptr+4, &c1->green, 2);
	bcopy(ptr+8, &c1->blue, 2); ptr += 12;
	if (RGBPDIFF(c1,c2) < 100) {
	    XPutPixel(image, 0, y, (c1->pixel = c2->pixel));
	    hit++;
	} else {
	    color.red = c1->red; color.green = c1->green;
	    color.blue = c1->blue;
	    XAllocColor(xp->xDisp, xp->xColor, &color);
	    XPutPixel(image, 0, y, (c1->pixel = color.pixel));
	}
	for (c1++, c2++, x = 1; x < im->imfYYWidth; x++,c1++,cp1++,c2++) {
	    /* ٤ΥɥåȤξ */
	    bcopy(ptr, &c1->red, 2); bcopy(ptr+4, &c1->green, 2);
	    bcopy(ptr+8, &c1->blue, 2); ptr += 12;
	    if (RGBPDIFF(c1,cp1) < 100) {
		XPutPixel(image, x, y, (c1->pixel = cp1->pixel));
		hit++;
	    } else if (RGBPDIFF(c1,c2) < 100) {
		XPutPixel(image, x, y, (c1->pixel = c2->pixel));
		hit++;
	    } else {
		color.red = c1->red; color.green = c1->green;
		color.blue = c1->blue;
		XAllocColor(xp->xDisp, xp->xColor, &color);
		XPutPixel(image, x, y, (c1->pixel = color.pixel));
	    }
	}
    }
    gettimeofday(&stop, NULL);
    DebugPrint4(5, "START: %ld.%ld, STOP: %ld.%ld\n",
		start.tv_sec, start.tv_usec, stop.tv_sec, stop.tv_usec);
    time = (stop.tv_sec - start.tv_sec) * 1000;
    time += ((stop.tv_usec - start.tv_usec)/1000);
    DebugPrint2(5, " TIME: %d\n HIT: %d\n", time, hit);
    free(ctab1);
    free(ctab2);
    DebugEndFunc("animation", "read_image3");
}

static void read_raster_image(ch, im, width, height, image)
    yy_comm_channel *ch;
    IMAGEFILE *im;
    int width, height;
    XImage *image;
{
    x_private *xp = XPRIVATE(ch);
    XColor *ctable;
    /* ʲǽ¬Τѿ */
    int time;
    struct timeval start, stop;

    DebugSetFunc("animation", "read_raster_image");
    DebugPrint0(5, "TYPE Sun RasterFile\n");
    gettimeofday(&start, NULL);

    /* ǥݡȤƤΤϡRT_STANDAD  RMT_EQUAL_RGB Ǥ
     * ΤΤ */
    if (im->imfRasType != RT_STANDARD || im->imfRasMapType != RMT_EQUAL_RGB ||
	im->imfRasMapLength == 0) {
	DebugPrint2(5, "Rasterfile(Type:%d,MapType:%d) is not supported\n",
		    im->imfRasType, im->imfRasMapType);
	DebugEndFunc("animation", "read_raster_image");
	return;
    }
    /* 顼ޥåפκ */
    if (im->imfRasMapLength > 0) {
	int size = im->imfRasMapLength/3;
	register u_char *red, *green, *blue;
	register XColor *col;
	register int loop;
	col = ctable = (XColor *)calloc(size, sizeof(XColor));
	red = (u_char *)im->imfMap;
	green = (u_char *)im->imfMap + size;
	blue = (u_char *)im->imfMap + (size<<1);
	for (loop = size; loop > 0; loop--, col++, red++, green++, blue++) {
	    col->red = ((u_int)*red << 8);
	    col->green = ((u_int)*green << 8);
	    col->blue = ((u_int)*blue << 8);
	    XAllocColor(xp->xDisp, xp->xColor, col);
	    DebugPrint4(9, " %02x:%02x:%02x => %3d\n",
			col->red, col->green, col->blue, col->pixel);
	}
    }

    /* ᡼ */
    if (im->imfRasMapLength > 0) {
	register u_char *ptr = (u_char *)im->imfPtr;
	register int x, y;
	for (y = 0; y < im->imfRasHeight; y++) {
	    for (x = 0; x < im->imfRasWidth; x++) {
		XPutPixel(image, x, y, (ctable+((int)*ptr))->pixel);
		ptr++;
	    }
	}
    }
    free((char *)ctable);
    gettimeofday(&stop, NULL);
    DebugPrint4(5, "START: %ld.%ld, STOP: %ld.%ld\n",
		start.tv_sec, start.tv_usec, stop.tv_sec, stop.tv_usec);
    time = (stop.tv_sec - start.tv_sec) * 1000;
    time += ((stop.tv_usec - start.tv_usec)/1000);
    DebugPrint1(5, " TIME: %d\n", time);
    DebugEndFunc("animation", "read_raster_image");
}


read_image_file(ch, fpath, width, height, image)
    yy_comm_channel *ch;
    char *fpath;
    int width, height;
    XImage *image;
{
    x_private *xp = XPRIVATE(ch);
    IMAGEFILE *im;
    int type = 3;

    DebugSetFunc("animation", "read_image_file");
    if ((im = open_image_file(fpath)) == (IMAGEFILE *)NULL) {
	DebugPrint1(5, "Can't open %s\n", fpath);
	DebugEndFunc("animation", "read_image_file");
	return;
    }
    if (im->imfHead.magic == YYPROTO_MAGIC) {
	if (type == 1)
	    read_image1(ch, im, width, height, image);
	else if (type == 2)
	    read_image2(ch, im, width, height, image);
	else
	    read_image3(ch, im, width, height, image);
    } else if (im->imfHead.magic == RAS_MAGIC) {
	read_raster_image(ch, im, width, height, image);
    }
    close_image_file(im);
    DebugEndFunc("animation", "read_image_file");
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
