/* Support Character Input on Page Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: edit_kanji.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId =
    "$Id: edit_kanji.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/06/07 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"

#ifdef WNNKINPUT
#include <wnn/rk_spclval.h>
#include <wnn/jllib.h>

static struct wnn_buf *KConvBuf =
    (struct wnn_buf *)NULL;

/* void wnn_message(str)
 *
 * Υ顼åɽؿ
 */
static void wnn_message(str)
    char *str;
{
    fputs(str, stderr);
    putc(EOL, stderr);
}

init_kanakan_proc()
{
    init_kanakanji_conv(KANAFILE, 010, "YY", JSERVER, WNNRCFILE);
}

/* int init_kanakanji_conv()
 *
 * ޻ѴʴѴĶν
 */
int init_kanakanji_conv(kanafile, delchar, envname, jserver, wnnrcfile)
    char *kanafile;	/* ޻Ѵե */
    int delchar;	/* ޻ϻΰʸõ */
    char *envname;	/* Wnn Ķ̾ */
    char *jserver;	/* Jserver ۥ̾ */
    char *wnnrcfile;	/* ʴѴơ֥ */
{
    extern int pop_kana_keyinput();
    /*
     * romkan_init Ǥʤ romkan_init2 Ȥ
     * ϤФɬ֤ͤ褦ꤹ(?)
     */
    /* romkan_init(KANAFILE, 0x8, 1, pop_kana_keyinput, 0);*/
    romkan_init2(KANAFILE, 0x8, 1, pop_kana_keyinput, 0, 1, 0, 0);
	
    KConvBuf = jl_open("YYonX", JSERVER, WNNRCFILE,
		       wnn_message, wnn_message, 30);

    if (jl_isconnect(KConvBuf) == 0) {
		wnn_message("Can't Communicate with Wnn Jserver");
		jl_close(KConvBuf);
		KConvBuf = (struct wnn_buf *)NULL;
		return -1;
    }
    return 0;
}


/**********************************************************************
 ***
 ***/

/* int wstous(wl, ws, us)
 *
 * Wnn ΤѴ
 * Ĺ wl  wchar_t 2Х ws  u_char ľ
 * u_char Ĺ֤
 * u_char ʸ EOS ʤ
 */
static int wstous(wl, ws, us)
    int wl;			/* 2ХĹ */
    register wchar_t *ws;	/* Ѵо2Х */
    register u_char *us;	/* ѴʸǼΰ */
{
    register int ul = 0;	/* ѴĹ */
    for ( ul = 0; wl > 0 ; wl--, ws++) {
	if (*us = (*ws>>8)&0377) { us++, ul++; }
	*us++ = ((*ws)&0377); ul++;
    }
    return ul;
}

/* int ustows(ul, us, ws)
 *
 * Wnn ΤѴ
 * Ĺ ul  u_char  wchar_t 2Х ws ľ
 * wchar_t Ĺ֤
 * wchar_t ʸϽλɤʤ
 *
 * BUGS:
 *  ʸɤ2Хȥ ( wchar_t) ɽǤʤ
 *  ϡʸ̵뤹
 */
static int ustows(ul, us, ws)
    register int ul;		/* ʸĹ */
    register u_char *us;	/* Ѵоʸ */
    register wchar_t *ws;	/* Ѵ2ХǼΰ */
{
    register int wl = 0;	/* Ѵ2ХĹ */
    while ( ul > 0 ) {
	register int b = JEUC_Bytes(us);/* ʸɤΥХȿ */
	if (b <= sizeof(wchar_t)) {
	    *ws = 0; ul -= b;
	    while (b-- > 0) { *ws = ((*ws << 8)|*us), us++; }
	    ws++, wl++;
	} else {
	    /* wchar_t ǤϤʸɽǤʤΤ̵뤷㤤ޤ */
	    us += b, ul -= b;
	}
    }
    return wl;
}

/**********************************************************************
 ***
 ***/

/* ߤΥΤ֤ bun_no  bun_no2 ޤǤ
 * Ƥɽ
 *  bun_no Ƭ˰֤뤳Ȥˤ
 */
static void put_bunsetsu_on_page(wbuf, bun_no, bun_no2, space, ipg)
    struct wnn_buf *wbuf;
    int bun_no, bun_no2;
    bool space;
    TERRITORY_PAGE *ipg;
{
    int b;
    int nc = 0;
    DebugSetFunc("kanji", "put_bunsetsu_on_page");
    for (b = bun_no; b < bun_no2; b++) {
	wchar_t work1[128];
	u_char work2[256];
	register int wc_len, uc_len;
	if (space && nc > 0) {
	    insert_string_on_page(&ipg->pcPagePlane,
				  GETPAGEFID(ipg), 1, " ");
	    nc++;
	}
	wc_len = jl_get_kanji(wbuf, b, b+1, work1);
	uc_len = wstous(wc_len, work1, work2);
	insert_string_on_page(&ipg->pcPagePlane,
			      GETPAGEFID(ipg), uc_len, work2);
	nc += wc_len;
	if (!space)
	    insert_string_on_page(&ipg->pcInputPlane,
				  GETPAGEFID(ipg), uc_len, work2);
    }
    ipg->pcKInputCurBun = bun_no;
    move_char_cursor_on_page(&ipg->pcPagePlane, -nc, 0);
    DebugEndFunc("kanji", "put_bunsetsu_on_page");
    /*NoReturnValue*/
}    

/* bun_no  bun_no2 ޤǤƤõ
 * ϤȤ bun_no Ƭ˰֤뤳Ȥˤ
 */
static void delete_bunsetsu_on_page(wbuf, bun_no, bun_no2, space, ipg)
    struct wnn_buf *wbuf;
    int bun_no, bun_no2;
    bool space;
    TERRITORY_PAGE *ipg;
{
    register int cur_bun = ipg->pcKInputCurBun;
    register int nc;

    DebugSetFunc("kanji", "delete_bunsetsu_on_page");
    /* ֤ */
    if (cur_bun < bun_no) { /* ʤޤ */
	nc = jl_kanji_len(wbuf, cur_bun, bun_no) + (space?(bun_no-cur_bun):0);
	move_char_cursor_on_page(&ipg->pcPagePlane, nc, 0);
    } else if (cur_bun > bun_no) { /* ᤹ */
	nc = jl_kanji_len(wbuf, bun_no, cur_bun) + (space?(cur_bun-bun_no):0);
	move_char_cursor_on_page(&ipg->pcPagePlane, -nc, 0);
    }
    /* bun_no  bun_no2 ޤǤδĹ */
    nc = jl_kanji_len(wbuf, bun_no, bun_no2) + (space?(bun_no2-bun_no-1):0);
    delete_string_on_page(&ipg->pcPagePlane, nc);
    DebugEndFunc("kanji", "delete_bunsetsu_on_page");
    /*NoReturnValue*/
}    

/* ɽθγ
 * Ͼ֤᤹
 */
void kanji_kakutei(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;

    DebugSetFunc("kanji", "kanji_kakutei");
    /* Ѵʸξõ */
    delete_bunsetsu_on_page(KConvBuf, 0, jl_bun_suu(KConvBuf), TRUE, input_pg);
    move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
    delete_string_on_page(&input_pg->pcPagePlane, 2); /*ե󥹤ξõ*/
    /* ߤθǤγ */
    jl_update_hindo(KConvBuf, 0, jl_bun_suu(KConvBuf));
    put_bunsetsu_on_page(KConvBuf, 0, jl_bun_suu(KConvBuf), FALSE, input_pg);
    move_char_cursor_on_page(&input_pg->pcPagePlane,
			     jl_kanji_len(KConvBuf, 0, -1), 0);
    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    /* ⡼ɤ򤫤ϥ⡼ɤˤ */
    input_pg->pcOperationMode &= ~PAGEOP_INPUTMODE;
    input_pg->pcOperationMode |= YYIN_KANA;
    DebugEndFunc("kanji", "kanji_kakutei");
    /*NoReturnValue*/
}

/* ɽθΤΤΤꤷ
 * ʹߤΤΤ̵Ѵˤ
 * Ͼ֤᤹
 */
void kanji_muhenkan(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;
    u_char yomi[256]; int uc_len;
    wchar_t wyomi[128]; int wc_len;

    DebugSetFunc("kanji", "kanji_muhenkan");
    /* Ѵʸξõ */
    delete_bunsetsu_on_page(KConvBuf, 0, jl_bun_suu(KConvBuf), TRUE, input_pg);
    move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
    delete_string_on_page(&input_pg->pcPagePlane, 2); /*ե󥹤ξõ*/
    /* ߤθǤγ */
    if (cur_bun > 0) {
	jl_update_hindo(KConvBuf, 0, cur_bun);
	put_bunsetsu_on_page(KConvBuf, 0, cur_bun, FALSE, input_pg);
	move_char_cursor_on_page(&input_pg->pcPagePlane,
				 jl_kanji_len(KConvBuf, 0, cur_bun), 0);
    }
    /* ɤߤơեդ PagePlane ɽ
     * ƱƤ KanaInputPlane ꤹ
     */
    wc_len = jl_get_yomi(KConvBuf, cur_bun, -1, wyomi);
    uc_len = wstous(wc_len, wyomi, yomi);
    insert_string_on_page(&input_pg->pcPagePlane,
			  GETPAGEFID(input_pg), 1, "|");
    insert_string_on_page(&input_pg->pcPagePlane,
			  GETPAGEFID(input_pg), uc_len, yomi);
    insert_string_on_page(&input_pg->pcPagePlane,
			  GETPAGEFID(input_pg), 1, "|");
    move_char_cursor_on_page(&input_pg->pcPagePlane, -(wc_len+1), 0);
    insert_string_on_page(&input_pg->pcKanaInputPlane,
			  GETPAGEFID(input_pg), uc_len, yomi);
    move_char_cursor_on_page(&input_pg->pcKanaInputPlane, -wc_len, 0);
    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    /* ⡼ɤ򤫤ϥ⡼ɤˤ */
    input_pg->pcOperationMode &= ~PAGEOP_INPUTMODE;
    input_pg->pcOperationMode |= YYIN_KANA;
    DebugEndFunc("kanji", "kanji_muhenkan");
    /*NoReturnValue*/
}

void kanji_forward_bunsetsu(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;

    DebugSetFunc("kanji", "kanji_forward_bunsetsu");
    if (cur_bun+1 < jl_bun_suu(KConvBuf)) {
	register int col = jl_kanji_len(KConvBuf, cur_bun, cur_bun+1);
	move_char_cursor_on_page(&input_pg->pcPagePlane, col+1, 0);
	input_pg->pcKInputCurBun++;
    }
    DebugEndFunc("kanji", "kanji_forward_bunsetsu");
    /*NoReturnValue*/
}

void kanji_backward_bunsetsu(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;

    DebugSetFunc("kanji", "kanji_backward_bunsetsu");
    if (cur_bun > 0) {
	register int col = jl_kanji_len(KConvBuf, cur_bun-1, cur_bun);
	move_char_cursor_on_page(&input_pg->pcPagePlane, -(col+1), 0);
	input_pg->pcKInputCurBun--;
    }
    DebugEndFunc("kanji", "kanji_backward_bunsetsu");
    /*NoReturnValue*/
}

void kanji_beginning_of_line(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;

    DebugSetFunc("kanji", "kanji_beginning_of_line");
    if (cur_bun > 0) {
	register int col = jl_kanji_len(KConvBuf, 0, cur_bun);
	move_char_cursor_on_page(&input_pg->pcPagePlane, -(col+cur_bun), 0);
	input_pg->pcKInputCurBun = 0;
    }
    DebugEndFunc("kanji", "kanji_beginning_of_line");
    /*NoReturnValue*/
}

void kanji_end_of_line(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;
    int max = jl_bun_suu(KConvBuf);

    DebugSetFunc("kanji", "kanji_end_of_line");
    if (cur_bun+1 < max) {
	register int col = jl_kanji_len(KConvBuf, cur_bun, max-1);
	move_char_cursor_on_page(&input_pg->pcPagePlane,
				 col+(max-cur_bun-1), 0);
	input_pg->pcKInputCurBun = (max-1);
    }
    DebugEndFunc("kanji", "kanji_end_of_line");
    /*NoReturnValue*/
}

static void kanji_next_kouho(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;
    int max = jl_bun_suu(KConvBuf);

    DebugSetFunc("kanji", "kanji_next_kouho");
    /* ߤʸᤫʹߤ򤹤٤ƾõƤ */
    delete_bunsetsu_on_page(KConvBuf, cur_bun, max, TRUE, input_pg);
    /* ߤʸƤ */
    jl_zenkouho(KConvBuf, cur_bun, WNN_USE_MAE, WNN_NO_UNIQ);
    jl_next(KConvBuf);
    put_bunsetsu_on_page(KConvBuf, cur_bun, max, TRUE, input_pg);
    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    DebugEndFunc("kanji", "kanji_next_kouho");
    /*NoReturnValue*/
}

static void kanji_previous_kouho(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;
    int max = jl_bun_suu(KConvBuf);

    DebugSetFunc("kanji", "kanji_previous_kouho");
    /* ߤʸᤫʹߤ򤹤٤ƾõƤ */
    delete_bunsetsu_on_page(KConvBuf, cur_bun, max, TRUE, input_pg);
    /* ߤʸƤ */
    jl_zenkouho(KConvBuf, cur_bun, WNN_USE_MAE, WNN_NO_UNIQ);
    jl_previous(KConvBuf);
    put_bunsetsu_on_page(KConvBuf, cur_bun, max, TRUE, input_pg);
    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    DebugEndFunc("kanji", "kanji_previous_kouho");
    /*NoReturnValue*/
}

static void kanji_expand_bunsetsu(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;
    int max = jl_bun_suu(KConvBuf);
    register int len = jl_yomi_len(KConvBuf, cur_bun, cur_bun+1);

    DebugSetFunc("kanji", "kanji_expand_bunsetsu");
    if (cur_bun+1 < max) {
	/* ߤʸᤫʹߤ򤹤٤ƾõƤ */
	delete_bunsetsu_on_page(KConvBuf, cur_bun, max, TRUE, input_pg);
	DebugPrint3(9, " Bunsetsu:%d Length %d -> %d\n",
		    cur_bun, len, (len+1));
	jl_nobi_conv(KConvBuf, cur_bun, (len+1), -1, WNN_USE_MAE, WNN_SHO);
	put_bunsetsu_on_page(KConvBuf, cur_bun, jl_bun_suu(KConvBuf),
			     TRUE, input_pg);
	redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    }
    DebugEndFunc("kanji", "kanji_expand_kouho");
    /*NoReturnValue*/
}

static void kanji_shrink_bunsetsu(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    int cur_bun = input_pg->pcKInputCurBun;
    int max = jl_bun_suu(KConvBuf);
    register int len = jl_yomi_len(KConvBuf, cur_bun, cur_bun+1);

    DebugSetFunc("kanji", "kanji_shrink_kouho");
    if (len > 1) {
	/* ߤʸᤫʹߤ򤹤٤ƾõƤ */
	delete_bunsetsu_on_page(KConvBuf, cur_bun, max, TRUE, input_pg);
	jl_nobi_conv(KConvBuf, cur_bun, (len-1), -1, WNN_USE_ZENGO, WNN_DAI);
	put_bunsetsu_on_page(KConvBuf, cur_bun, jl_bun_suu(KConvBuf),
			     TRUE, input_pg);
	redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    }
    DebugEndFunc("kanji", "kanji_shrink_bunsetsu");
    /*NoReturnValue*/
}





    

void kanji_henkan(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = input_pg->pcKanaInputPlane.curCol;
    register int nc =
	total_nchar_in_line_buffer(input_pg->pcKanaInputPlane.curLineTop);
    u_char yomi[512];
    wchar_t yomi_buf[256]; int yomi_len;
    int len, bun_len;

    DebugSetFunc("kanji", "kanji_henkan");
    if (nc == 0) {
	/*ϤʤƤʤ --> Ϥ̵뤹*/
	unget_keyin_on_input_territory(YYIN_ASCII, leng, ptr);
	DebugEndFunc("kanji", "kanji_henkan");
	return /*NoReturnValue*/;
    }
    /* ɽΰξõ(ե󥹤ϻĤ) */
    move_char_cursor_on_page(&input_pg->pcPagePlane, -col, 0);
    delete_string_on_page(&input_pg->pcPagePlane, nc);
    /* ɤߤξѴԤʤ */
    move_char_cursor_on_page(&input_pg->pcKanaInputPlane, -col, 0);
    len = get_string_on_page(&input_pg->pcKanaInputPlane,
			     MIN(nc,(sizeof(yomi)>>1)), yomi);
    yomi_len = ustows(len, yomi, yomi_buf);
    yomi_buf[yomi_len] = (wchar_t)0;
    bun_len = jl_ren_conv(KConvBuf, yomi_buf, 0, -1, WNN_USE_MAE);

    /* ɽԤʤ */
    put_bunsetsu_on_page(KConvBuf, 0, bun_len, TRUE, input_pg);

    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    /* pcKanaInputPlane κ */
    destroy_page_plane(&input_pg->pcKanaInputPlane);
    init_page_plane(&input_pg->pcKanaInputPlane, GETPAGEFID(input_pg),
		    4, "    ");
    locate_char_cursor_on_page(&input_pg->pcKanaInputPlane, 0, 0);

    /* ⡼ɤ⡼ɤˤ */
    input_pg->pcOperationMode &= ~PAGEOP_INPUTMODE;
    input_pg->pcOperationMode |= YYIN_KANJI;

    DebugEndFunc("kanji", "kanji_henkan");
    /*NoReturnValue*/
}


YYEDITFUNCLIST YYKanjiInputEditFuncList[] = {
{ "kanji-kakutei", kanji_kakutei },
{ "kanji-muhenkan", kanji_muhenkan },
{ "forward-bunsetsu", kanji_forward_bunsetsu },
{ "backward-bunsetsu", kanji_backward_bunsetsu },
{ "beginning-of-line", kanji_beginning_of_line },
{ "end-of-line", kanji_end_of_line },
{ "next-kouho", kanji_next_kouho },
{ "previous-kouho", kanji_previous_kouho },
{ "expand-bunsetsu", kanji_expand_bunsetsu },
{ "shrink-bunsetsu", kanji_shrink_bunsetsu },
{ NULL, NULL}
} ;

#endif /*WNNKINPUT*/
/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */

