/* InitialSet for YY-server
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: com_init.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId =
    "$Id: com_init.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"

/*
 * Initialize
 */

struct yy_client_info {
    int ycVersion;
    int ycRelease;
    int ycSyncCounter;
    int ycMouseStayTime;
    char *ycXServer;
} ;
struct yy_server_info {
    int ysVersion;
    int ysRelease;
    int ysSyncCounter;
    int ysMouseStayTime;
} ;
struct yy_client_info YYClientInfo;
struct yy_server_info YYServerInfo;

yy_packet *yycom_init(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    int id, leng, err;
    yy_packet *repl;
    x_private *xp;
    static char xserver_name[64];
    static char window_name[64];
    static char icon_name[64];

    DebugSetFunc("init", "yycom_init");

    if (ch->ccXFd >= 0) {
	/* We already have the connection with the X server.. */
	/* Ignore this packet */
	DebugEndFunc("init", "yycom_init");
	return create_error_packet(pkt, YYERROR_NOTYYPACKET);
    }
    if ((id = read_packet_entry_integer(pkt)) != YYPROTO_MAGIC) {
	/* This is not YY Packet */
	DebugEndFunc("init", "yycom_init");
	return create_error_packet(pkt, YYERROR_NOTYYPACKET);
    }
    YYClientInfo.ycVersion = read_packet_entry_integer(pkt);
    YYClientInfo.ycRelease = read_packet_entry_integer(pkt);
    /* check version and release */
    YYClientInfo.ycSyncCounter = read_packet_entry_integer(pkt);
    YYClientInfo.ycMouseStayTime = read_packet_entry_integer(pkt);
    if ((err = check_client_info(&YYClientInfo, &YYServerInfo)) > 0) {
	DebugEndFunc("init", "yycom_init");
	return create_error_packet(pkt, err);
    }
    /* Sync Counter */
    ch->ccYYSyncPacketNum = YYServerInfo.ysSyncCounter;
    /* X Server Name */
    leng = read_packet_entry_integer(pkt);
    read_packet_entry_string(pkt, leng, xserver_name);
    YYClientInfo.ycXServer = xserver_name;
    if ((err = make_connection_with_x_server(ch, xserver_name)) > 0) {
	repl = ALLOC_ERRPACKET(pkt);
	append_packet_entry_integer(pkt, err);
	DebugEndFunc("init", "yycom_init");
	return repl;
    }
    DebugPrint1(5, "Connect X Server on '%s'\n", xserver_name);
    xp = XPRIVATE(ch);
    if ((leng = read_packet_entry_integer(pkt)) > 0) {
	read_packet_entry_string(pkt, leng, window_name);
	xp->xWindowName = window_name;
    } else
	xp->xWindowName = YYWINDOWNAME;
    if ((leng = read_packet_entry_integer(pkt)) > 0) {
	read_packet_entry_string(pkt, leng, icon_name);
	xp->xIconName = icon_name;
    } else
	xp->xIconName = YYICONNAME;
    ch->ccXStayInterval = YYClientInfo.ycMouseStayTime;
    xp->xEventNum = 0;
    xp->xLastPointer.type = LASTEvent;
    DebugPrint2(5, "Window Name:'%s', Icon Name:'%s'\n",
		xp->xWindowName, xp->xIconName);

    /* create reply packet */
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl, YYPROTO_MAGIC);
    append_packet_entry_integer(repl, YYServerInfo.ysVersion);
    append_packet_entry_integer(repl, YYServerInfo.ysRelease);
    append_packet_entry_integer(repl, YYServerInfo.ysSyncCounter);
    append_packet_entry_integer(repl, YYServerInfo.ysMouseStayTime);
    append_packet_entry_integer(repl,
				DisplayWidth(xp->xDisp, xp->xScreen));
    append_packet_entry_integer(repl,
				DisplayHeight(xp->xDisp, xp->xScreen));
    append_packet_entry_string(repl, YYSERVER_LABEL);

    /* We finish initialization without any trouble */
    ch->ccXFd = ConnectionNumber(xp->xDisp);
    /* Fix Command Search Table for Another Commands */
    fix_command_search_table();
    DebugPrint0(5, "Finish Initialize Procedures withour any error\n");
    DebugEndFunc("init", "yycom_init");
    return repl;

}

int check_client_info(ci, si)
	struct yy_client_info *ci;
	struct yy_server_info *si;
{
	/* This is a prototype version.. */
	si->ysVersion = ci->ycVersion;
	si->ysRelease = ci->ycRelease;
	si->ysSyncCounter = ci->ycSyncCounter;
	si->ysMouseStayTime = ci->ycMouseStayTime;
	return 0;
}

static x_private XPrivateArea;
bool YYSynchronizeMode;

int make_connection_with_x_server(ch, xserver)
    yy_comm_channel *ch;
    char *xserver;	/* X server (Display) */
{
    x_private *xp = &XPrivateArea;
    
    ch->ccXPrivate = (char *)xp;
    DebugSetFunc("xwindow", "make_connection_with_x_server");
    DebugPrint1(1, "Open Display on '%s'\n", xserver);
    if ((xp->xDisp = XOpenDisplay(xserver)) == NULL) {
	DebugPrint1(1, "Can't open display '%s'\n", XDisplayName(xserver));
	return YYERROR_NODISP;
    }
    XSetCloseDownMode(xp->xDisp, DestroyAll);
    if (YYSynchronizeMode) {
	DebugPrint0(1, "X-server Syncronize!!!\n");
	XSynchronize(xp->xDisp, 1);
    }
    DebugPrint1(1, "Display on '%s' has been opend\n",
		XDisplayName(xserver));
    xp->xScreen = DefaultScreen(xp->xDisp);
    xp->xColor = DefaultColormap(xp->xDisp, xp->xScreen);
    DebugEndFunc("xwindow", "make_connection_with_x_server");
    return 0;
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
