;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;; $@#Y#Y(J  $@#o#n(J  $@#X(J $@$K$*$1$k(J $@#Y#Y(J $@%W%m%H%3%k(J 
;;;
;;; filename: yyprtcl-kosaka.lisp
;;;
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; Written By Yukio Ohta 1990.02.06
;;;      under supervision of Masayuki Ida
;;;
;;; change log
;;; Version 0.5 07-Feb-90
;;; Version 1.0 05-Mar-90
;;;
;;; Version 1.0   Updated by t.kosaka 1990-3-13
;;; Version 1.1   Updated by t.kosaka 1990-6-6
;;; Version 1.1   Updated by t.kosaka 1990-8-18
;;; Version 1.2   Update by T.kosaka 1990-10-3
;;;               Change I use unsigned-byte for C function inteface
;;;		  Added Symbolics code contribution of E.Shiota
;;; Version 1.21  Add close f;unction for Network
;;; Version 1.21  Modefy by T.kosaka 1990-11-30 
;;; Version 1.3   Update by T.kosaka 1991-1-9 
;;; Version 1.3   Change  porotocol number at yy-protocol-40 to 60
;;; Version 1.3   Change functionalty for return value and image-data handling 
;;;               at yy-protocol-60
;;; Version 1.3   Added functionalty for vector at make-command-packet 
;;; Version 1.3   Added yy-protocol-61 for put-image 

(in-package :yy)

#+CMU
(declaim (inline csetupserver)
         (inline cwriteinternal)
         (inline cread1internal)
         (inline cread2)
		 (inline caccess)
		 (inline cstore)
		 (inline cstore2)
		 (inline cstoremul)
		 (inline unixselection)
		 (inline alamsetup))

;;; $@<u?.H/9T2s?t(J

(DEFPARAMETER *MAX-RECEIPT-TIME* 0)
(DEFPARAMETER *RECEIPT-TIME* 0)

;;; $@%Q%1%C%H<oJL(J
(defvar *ALONE-PACKET-TYPE* 0)
(defvar *START-PACKET-TYPE* 1)
(defvar *CONT-PACKET-TYPE* 2)
(defvar *END-PACKET-TYPE* 3)

;;; $@%a%C%;!<%8%G!<%?NN0h(J
(defparameter *max-message-size* 0)
(defparameter *max-receive-size* 0)

(defun real-integer (data)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (not (zerop (logand #x80000000 data)))
      (- 0 (+ (logxor #xFFFFFFFF data) 1))
    data))

;;;$@%3%^%s%I%P%C%U%"!<(J
(defvar *send* nil)

;;; $@%3%^%s%ILa$jCM%P%C%U%!!<(J $@%X%C%@!<It(J $@#8%P%$%H$O$J$$(J
(defvar *send-receive* nil)

;;;$@DLCN%P%C%U%!!<(J  $@%X%C%@!<It(J $@#8%P%$%H$O$J$$(J
(defvar *receive* nil)

;;; $@%X%C%@!<%G!<%?%P%C%U%!!<(J
(defvar *header* (make-packet 2))
(defvar *header2* (make-packet 2))

;;; packet-send
;;; $@%Q%1%C%H$NAw?.$r9T$&(J
;;; $@$3$N$H$-%3%^%s%IH/9T2s?t$,(J*max-receipt-time*$@0J>e$G$"$l$P<+F0E*$K<u?.$r$^$D(J
;;; $@C"$7!"(Jsync-p$@$,(Jnil $@$N>l9g$O$=$N8B$j$G$O$J$$(J
(defun packet-send (&optional (sync-p t))
  (declare (special *ALONE-PACKET-TYPE* *START-PACKET-TYPE* 
		    *CONT-PACKET-TYPE* *END-PACKET-TYPE* *send*
		    *header*)
		   #-CMU
		   (inline lognad car >= = incf)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((len (logand #x00FFFFFF (c_access (car *send*) 0)))
	 (type (c_access (car *send*) 1)))

    (if (= type *ALONE-PACKET-TYPE*)
	;;; 1 $@8D$N%Q%1%C%H(J
      (progn
       (c_write_internal (car *send*) len)
       (when sync-p
	   (incf *receipt-time*)
	   (when (>= *receipt-time* *MAX-RECEIPT-TIME*)
		 (c_read1_internal *header* 2)
		 (setf *receipt-time* 0))))
	   
      ;;; $@J#?t$N%Q%1%C%H(J
      (progn 
	(dolist (item *send*)
		(setf type (c_access item 1)
		      len (logand #x00FFFFFF (c_access item 0)))

		(c_write_internal item len)
		
		(if (= type *END-PACKET-TYPE*)
		    (return)))

	(when sync-p
           (incf *receipt-time*)
	   (when (>= *receipt-time* *MAX-RECEIPT-TIME*)

		 (setf  *receipt-time* 0)
		 (c_read1_internal *header* 2)))))
  (values)))

;;; packet-send-receive
;;; $@%Q%1%C%HAw?.8e!"<u?.$rBT$D(J
(defun packet-send-receive  ()
  (declare (special *END-PACKET-TYPE* *ALONE-PACKET-TYPE* *header* 
		    *max-receive-size* *send-receive* *send*)
		   #-CMU
		   (inline = logand incf)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((type 0) (no 0) (len 0))

    (setf *receipt-time* 0)
    (packet-send nil)

    ;;; $@%X%C%@!<$rFI$_$H$k(J
    (c_read1_internal *header* 2)
    (setf len (logand #x00FFFFFF (c_access *header* 0)))

    ;;; $@:G=i$N%Q%1%C%H$rFI$_$H$k(J
    (c_read1_internal (car *send-receive*) (- len 2))

    (loop
      (if (or (= (logand (setf type (c_access *header* 1))  3)
			   *END-PACKET-TYPE*)
	       (= (logand type 3) *ALONE-PACKET-TYPE*))
	 (return))

     (incf no)

     ;;; $@<!$N%j%9%H$,$"$k$+D4$Y$k(J
     (if (null (nth no *send-receive*))
	 (setf *send-receive* 
	       (nconc *send-receive* (list (make-packet *max-receive-size* )))))

     ;;; $@%X%C%@!<$rFI$_$H$k(J
     (c_read1_internal *header* 2)
     ;;; $@%Q%1%C%H?t$r5a$a$k(J
     (setf  len (logand #x00FFFFFF (c_access *header* 0)))
     ;;; $@%Q%1%C%H$NFI$_$H$j(J
    (c_read1_internal (nth no *send-receive*) (- len 2))
	 )

    *send-receive*))


;;; packet-send-single
;;; $@#18D$N%Q%1%C%H$NAw?.$r9T$&(J
;;; $@$3$N$H$-%3%^%s%IH/9T2s?t$,(J*max-receipt-time*$@0J>e$G$"$l$P<+F0E*$K<u?.$r$^$D(J
;;; $@C"$7!"(Jsync-p$@$,(Jnil $@$N>l9g$O$=$N8B$j$G$O$J$$(J
(defun packet-send-single (packet &optional (sync-p t))
  (declare (special *ALONE-PACKET-TYPE* *header*)
		   #-CMU
		   (inline logand >= incf)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((len (logand #x00FFFFF (c_access packet 0))))

    (setf (c_access packet 1) *ALONE-PACKET-TYPE*)
    (c_write_internal packet len)
    (when sync-p
      (incf *receipt-time*)
      (when (>= *receipt-time* *MAX-RECEIPT-TIME*)
	(c_read1_internal *header* 2)
	(setf *receipt-time* 0))
      )))

;;; packet-send-receive-single
;;; $@#18D$N%Q%1%C%HAw?.8e!"J#?t$N<u?.$rBT$D(J
(defun packet-send-receive-single  (packet)
  (declare (special *END-PACKET-TYPE*  *header* 
		    *max-receive-size* *send-receive* )
		   #-CMU
		   (inline logand incf =)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((type 0) (no 0) (len 0))


    (setf *receipt-time* 0)
    (packet-send-single packet nil)

    ;;; $@%X%C%@!<$rFI$_$H$k(J
    (c_read1_internal *header* 2)

    ;;; $@%Q%1%C%H?t$r5a$a$k(J
    (setf len (logand #x00FFFFFF (c_access *header* 0)))

    ;;; $@:G=i$N%Q%1%C%H$rFI$_$H$k(J
    (c_read1_internal (car *send-receive*) (- len 2))

    (loop
      (if (or (= (logand (setf type (c_access *header* 1))  3)
			   *END-PACKET-TYPE*)
	       (= (logand type 3) *ALONE-PACKET-TYPE*))
	 (return))

     (incf no)

     ;;; $@<!$N%j%9%H$,$"$k$+D4$Y$k(J
     (if (null (nth no *send-receive*))
	 (setf *send-receive* 
	       (nconc *send-receive* (list (make-packet *max-receive-size* )))))

     ;;; $@%X%C%@!<$rFI$_$H$k(J
     (c_read1_internal *header* 2)
     ;;; $@%Q%1%C%H?t$r5a$a$k(J
     (setf len (logand #x00FFFFFF (c_access *header* 0)))
     ;;; $@%Q%1%C%H$NFI$_$H$j(J
    (c_read1_internal (nth no *send-receive*) (- len 2))
	 )

    *send-receive*))



;;; $@La$jCM%Q%1%C%H5Z$SDLCN%Q%1%C%H$N;XDjHV9f$+$i$N%G!<%?$r<h$j=P$9(J
;;; packet -> *receive* $@$b$7$/$O(J *send-receive*
(defun get-packet-data (packet no &optional (string nil))
  (declare (special *max-message-size* *max-receive-size*)
		   #-CMU
		   (inline / floor = decf 1+ -)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (let ((pno (floor (/ no (- *max-message-size* 2))))
	(data 0) (shino (mod no (- *max-message-size* 2))))

    (if  string
		(let ((j -1) 
			  (new-string (make-string string)))

		  (dotimes 
		   (sno string)
		   (when (= j -1)
				 (when (>= shino *max-receive-size*)
					   (setf pno   (1+ pno)
							 shino 0))
			       
				 (setf data (c_access (nth pno packet) shino)
					   j 3
					   shino (1+ shino)))

		   (setf (char new-string sno) (code-char (get-one-byte data j)))
		   (decf j))
		  new-string)
      (c_access (nth pno packet) shino))))


;;; $@;XDj$5$l$?%P%$%H$r<h$j=P$9(J
;;; #x00000000  <- fixnum
;;;    3 2 1 0  <- no
(defun get-one-byte (num no)
  (declare (integer num no)
		   (optimize (speed 3) (compilation-speed 0) (safety 0)))
  (ldb (byte 8 (* no 8)) num))

#|
(defun get-one-byte (fixnum no)
  (declare 
   #-CMU
   (inline ash * logand)
   (fixnum fixnum no)
   (optimize (speed 0) (safety 3)))
  (logand #x000000FF (ash fixnum (* no -8))))
|#

;;; $@%Q%1%C%H$r:n$j!"(J*send*$@$K@_Dj$9$k!#(J
;;; arg $@$O!"(J:string "data" :integer 1$@$N7A<0$G@_Dj$9$k(J
;;;
;;; added Symbolics code 31.Oct.90
(defun make-command-packet (commad &rest arg)
  (declare (special *send* *max-message-size*
		    *ALONE-PACKET-TYPE* *START-PACKET-TYPE*
                    *CONT-PACKET-TYPE* *END-PACKET-TYPE*)
		   #-CMU
		   (inline incf > / >= ceiling - decf * min nth)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((counter 0) (packet-count 2) (pno 0) 
	(length 0) (start 0) (c-length 0) (real-byte 0)
	(status *ALONE-PACKET-TYPE*))

    (setf (c_access (car *send*) 1) *ALONE-PACKET-TYPE*)

    (loop 
	     ;;; $@%Q%1%C%HCf$N%G!<%?!<$N?t$rD4$Y$k(J
	     (when (>= packet-count *max-message-size*)
		 (incf pno)
		 (if (null (nth pno *send*))
		     (setf *send* (nconc *send* (list  (make-packet)))))
		 (setf packet-count 2
		       (c_access (nth (- pno 1) *send*) 0) 
		       (encode-com-pac commad *max-message-size*)
		       (c_access (nth (- pno 1) *send*) 1)
		       (set-packet-type-cont status)
		       status *CONT-PACKET-TYPE*))
		       
	     (case (nth counter arg)
	           (:vector ;;; $@%Y%/%?!<(J
				(incf counter)
				(setf real-byte (length (nth counter arg))
					  (c_access (nth pno *send*) packet-count)
					  real-byte
					  start 0)
				(incf packet-count)

				(if (> real-byte 0)
					(loop
					 (setf length 
						   (min  (* (- *max-message-size* packet-count) 4)
								 real-byte))
					 
					 (if (zerop real-byte)
						 (return))

					 (incf start (c_store_vector (nth pno *send*) 
												 packet-count 
												 (nth counter arg)
												 start
												 length))

					 (incf packet-count (ceiling (/ length 4)))
					 (decf real-byte length)

					 ;; $@%Q%1%C%H?t$N%A%'%C%/(J
					 (when (>= packet-count *max-message-size*)
						   (incf pno)
						   (if (null (nth pno *send*))
							   (setf *send* 
									 (nconc *send* (list  (make-packet)))))
						   
						   (setf packet-count 2
								 (c_access (nth (- pno 1) *send*) 0)
								 (encode-com-pac commad *max-message-size*)
								 (c_access (nth (- pno 1) *send*) 1)
								 (set-packet-type-cont status)
								 status *CONT-PACKET-TYPE*))
					 )
				  (incf packet-count))
				)

			   (:string ;;; $@J8;zNs(J
				(incf counter)
				
				(setf 
				 real-byte (real-length (nth counter arg))
				 (c_access (nth pno *send*) packet-count)
				 real-byte
				 c-length real-byte
				 start 0)

				(incf packet-count)

				(if (> real-byte 0)
					(loop
					 (setf length 
						   (min  (* (- *max-message-size* packet-count) 4)
								 c-length))
		      
					 (if (zerop c-length)
						 (return))
					 #+(or LUCID (and EXCL (not ICS)) CMU Symbolics);31.Oct.90 
					 (incf start (c_store_string (nth pno *send*) 
												packet-count 
												(nth counter arg)
												start
												length))

					 #+(and EXCL ICS)
					 (incf start (c_store_string_ics (nth pno *send*) 
													 packet-count
													 (nth counter arg)
													 start
													 length))

			   (incf packet-count (ceiling (/ length 4)))
			   (decf c-length length)

		           ;;; $@%Q%1%C%H?t$N%A%'%C%/(J
			   (when (>= packet-count *max-message-size*)
			     (incf pno)
			     (if (null (nth pno *send*))
				 (setf *send* 
				   (nconc *send* (list  (make-packet)))))
			    
			     (setf packet-count 2
				   (c_access (nth (- pno 1) *send*) 0)
				   (encode-com-pac commad *max-message-size*)
				   (c_access (nth (- pno 1) *send*) 1)
				   (set-packet-type-cont status)
				   status *CONT-PACKET-TYPE*))
			   )
		       (incf packet-count))
				)

		   (:integer ;;; $@?t;z(J
			   (incf counter)
		           (c_store2 (nth pno *send*) packet-count 
				     (nth counter arg))
			   (incf packet-count))

		   (:end ;;; $@%Q%1%C%H$N=*$j(J
			(when (nth (+ pno 1) *send*)
			    (nbutlast *send*))
			(return))
		   (t
		    (error "Commad no ~a Args ~a Counter ~a" commad 
			   (nth counter arg)
			   counter)))
	     (incf counter))
    ;;; $@%3%^%s%I$H%Q%1%C%HD9$r@_Dj(J
    (setf (c_access (nth pno *send*) 0) (encode-com-pac commad packet-count)
	  (c_access (nth pno *send*) 1)
	  (set-packet-type status))
    ))

(defun set-packet-type-cont (status)
  (declare (special *ALONE-PACKET-TYPE* *CONT-PACKET-TYPE* *START-PACKET-TYPE*))
  (cond
   ((eq status *ALONE-PACKET-TYPE*)
    *START-PACKET-TYPE*)
   ((eq status *CONT-PACKET-TYPE*)
    *CONT-PACKET-TYPE*)))

(defun set-packet-type (status)
  (declare (special *ALONE-PACKET-TYPE* *CONT-PACKET-TYPE* *END-PACKET-TYPE*))
  (cond 
   ((eq status *ALONE-PACKET-TYPE*)
    *ALONE-PACKET-TYPE*)
   ((eq status *CONT-PACKET-TYPE*)
	*END-PACKET-TYPE*)))

(defun dump-all-packet ()
  (let ((count 0))
    (dolist (item *send*)
	    (multiple-value-bind (com no)
		 (decode-com-pac (c_access item 0))

		     
		 (format t "~%~a com-no ~a no ~a type ~a ~%"count com no 
			 (c_access item 1))
		 (dotimes (i (- no 2))
		   (format t "(~a)  ~x " (+ i 2) (c_access item (+ i 2)))
		   (if (zerop (mod (+ i 2) 5))
			      (terpri)))
		 (if (or (= (c_access item 1) *ALONE-PACKET-TYPE*)
			 (= (c_access item 1) *END-PACKET-TYPE*))
		     (return))
		 (incf count))
	    )
    ))



;;; encode-com-pac
;;; $@%3%^%s%IHV9f$H%Q%1%C%HD9$r(Jencode$@$9$k(J
;;; (encode-com-pac com-num &optional (pac-lng)) -> fixnum
;;; args. com-num = $@%3%^%s%IHV9f(J
;;;	  pac-lng = $@%Q%1%C%HD9(J
;;; val.  fxnum = 4$@%P%$%HD9$N@0?t(J
;;; notice:
;;; $@$3$3$O8e$G=q$-49$($^$9(J(fmr$@MQ(J)
;;;
;;; Ex.)
;;; (encode-com-pac 1 6)
;;; -> 16777222 (#x01000006)
(defun encode-com-pac (com-num &optional (pac-lng 0))
  #+:gclisp
       (+ (* com-num #.(expt 2 24)) pac-lng)
  #-:gclisp
(declare  (optimize (speed 0) (safety 3)))
  (let ((tmp com-num))
    (setf tmp (ash tmp 24))
    (logior tmp pac-lng)))

;;; decode-com-pac
;;; $@%3%^%s%IHV9f$H%Q%1%C%HD9$KJ,2r$9$k(J
;;; (decode-com-pac fixnum) -> command packet-length
;;; (decode-com-pac #x12345678)
(defun decode-com-pac (fixnum)
;; symbolics cannot understand #u by shiota 
;  #+:gclisp
;  (values (floor (logand fixnum #x#uf000) #.(expt 2 24))
;	  (logand fixnum #x00ffffff))
;  #-:gclisp
  (declare (optimize (speed 0) (compilation-speed 3) (safety 3)))
  (values (ldb (byte 8 24) fixnum) (ldb (byte 24 0) fixnum))
;  (values (ash (logand fixnum #xff000000) -24) (logand fixnum #x00ffffff))
  )



;;; string-to-fixnum
;;; $@J8;zNs$r(Jfixnum$@$KJQ49$7!"$=$N(Jfixnum$@$N%j%9%H$rJV$9!#(J
;;; char$@$NJ8;z%3!<%I$r(J4 $@%P%$%HKh$K6h@Z$j(Jfixnum$@$H$9$k!#(J
;;; (string-to-fixnum string) -> list-of-fixnum
;;; args. string = $@J8;zNs(J
;;; val.  list-of-fixnum = fixnum$@$N%j%9%H(J
;;;
;;; Ex.)
;;; (string-to-fixnum "abcd")
;;; -> (1633837924) 
;;; (string-to-fixnum "abcdeghijk")
;;; -> (1633837924 1701275753 1785397248))
(defun string-to-fixnum (string)
  (declare 
   #-CMU
   (inline floor / + /= - mod logior =)
   (optimize (speed 0) (safety 3)))
  (let* ((total (length string))
	 (data (* (floor (/ (+ total 3) 4)) 4))
	 (endlist nil) (fixnum 0))

    (dotimes (i total)
       (when (and (/= i 0) (= 0 (mod i 4)))
	     (push fixnum endlist)
	     (setf fixnum 0))

       (setf fixnum (logior (ash fixnum 8) (char-code (char string i)))))

    (dotimes (i (- data total))
	     (setf fixnum (logior (ash fixnum 8) 0)))

    (if (or (/= data total) (= (mod total 4) 0))
	(push fixnum endlist))

    (nreverse endlist)))

;;; fixnum-to-bytes
;;; 4$@%P%$%HD9$N@0?t$r(J1$@%P%$%H$:$D$KJ,2r$9$k(J
;;; (fixnum-to-bytes fixnum) -> byte1 byte2 byte3 byte4
;;;(fixnum-to-bytes #xffffffff)
(defun fixnum-to-bytes (fixnum)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (values (get-one-byte fixnum 3)
	  (get-one-byte fixnum 2)
	  (get-one-byte fixnum 1)
	  (get-one-byte fixnum 0)))

;;; set-string-to-packet
;;; $@J8;zNs$r%Q%1%C%H$KEPO?$9$k(J
;;; Args   packet      -> $@%Q%1%C%H(J
;;;        loaction-no -> $@3+;O0LCV(J
;;;        string      -> $@J8;zNs(J
;;; return$@CM(J  $@$J$7(J
(defun set-string-to-string (packet location-no string)
#+(or LUCID CMU (and EXCL (not ICS)) Symbolics);31.Oct.90
   (c_store_string packet location-no string 0 (length string))
#+(and EXCL ICS)
   (c_store_string_ics packet location-no string 0 (length string))
   )

;;; byte-paket-length (bate)
;;; $@%P%$%H?t$+$i%Q%1%C%H?t$r5a$a$k(J
;;; $@$b$7!"#0$J$i$P#1$rJV$9(J
(defun byte-packet-length (byte)
  (let ((c-l (ceiling byte 4)))
    (if (zerop c-l)
	1
      c-l)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                 ;;
;;                Entry of YY on X Protocol.                       ;;
;;                                                                 ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; #000 yy-protocol-0
;;; $@%5!<%P!<$H$N@\B3(J
;;; (yy-protocol-0 id vno rno responceno ntime sname return-struct)
;;; -> return-struct
;;; args. id = $@#Y#Y%W%m%H%3%k$N%Q%1%C%H$G$"$k$3$H$r<($9?t;z(J
;;;	  vno = $@%W%m%H%3%k%P!<%8%g%sHV9f(J
;;;	  rno = $@%j%j!<%9HV9f(J
;;;	  responceno = $@<u?.!?H/9T2s?t(J
;;;	  ntime = $@%^%&%9BZ:_;~4V(J  $@%_%jIC(J
;;;	  sname = $@@\B3$9$Y$-%5!<%P!<L>(J
;;;	  return-struct = $@9=B$BN(J yy-server-connection
;;; val.  return-struct = $@9=B$BN(J yy-server-connection
;(dedcommand yy-protocol-0 (id vno rno responceno ntime sname retstr)
(defun yy-protocol-0 (id vno rno responceno ntime sname retstr)
  (let ((receive nil) )
    (make-command-packet 0 :integer id
		       :integer vno :integer rno :integer responceno
		       :integer ntime :string sname :end)
    ;;; $@Aw?.(J
    (setf receive (packet-send-receive))
    
    (if (= id (get-packet-data receive 0))
	(progn 
	
    ;;; return-struct$@$KCM$r@_Dj(J
	  (setf (yy-server-connection-yy-version retstr)
	    (get-packet-data receive 1)
	    (yy-server-connection-yy-release-no retstr)
	    (get-packet-data receive 2)
	    (yy-server-connection-yy-responce-no retstr)
	    (get-packet-data receive 3)
	    (yy-server-connection-yy-ntime retstr)
	    (get-packet-data receive 4)
	    (yy-server-connection-yy-width retstr)
	    (get-packet-data receive 5)
	    (yy-server-connection-yy-height retstr)
	    (get-packet-data receive 6)
	    (yy-server-connection-yy-label retstr)
	    (get-packet-data receive 8 (get-packet-data receive 7)))

	  (SETF *MAX-RECEIPT-TIME* 
		(YY-SERVER-CONNECTION-YY-RESPONCE-NO RETSTR))
	  retstr)
      nil)
  ))

;;; #001 yy-protocol-1
;;; $@%F%j%H%j$r:n@.$9$k(J
;;; (yy-protocol-1 x y width height parent visible &optional (drawable 1)) -> no
;;; args. x = $@?F%F%j%H%j$N:8>e$+$i$N:BI8(J X
;;;	  y = $@?F%F%j%H%j$N:8>e$+$i$N:BI8(J Y
;;;	  width = $@%F%j%H%j$NI}(J
;;;	  height = $@%F%j%H%j$N9b$5(J
;;;	  parent = $@?F$K$J$k%F%j%H%j(J
;;;	  visible = $@I=<(%U%i%0(J 1->$@I=<((J  0->$@HsI=<((J
;;; val.  no = 0$@$J$i$P<:GT!"$=$&$G$J$1$l$P%F%j%H%jHV9f(J
(defcommand yy-protocol-1 (x y width height parent visible 
				&optional (drawable 1))
  (let ((receive nil)
	(packet (car *send*)))

    (if (> 0 width) 
	(setf x (+ x width)
	      width (abs width)))

    (if (> 0 height)
	(setf y (+ y height)
	     height (abs height)))

    (setf 
     (c_access packet 0) (encode-com-pac 1 9))

    (c_store2 packet 2 x)
    (c_store2 packet 3 y)
    (c_store2 packet 4 width)
    (c_store2 packet 5 height)
    (c_store2 packet 6 parent)
    (c_store2 packet 7 visible)
    (c_store2 packet 8 drawable)
#|
    (make-command-packet 1
		       :integer x :integer y :integer width
		       :integer height :integer parent :integer visible 
		       :integer drawable :end)
|#
     ;;; $@Aw?.(J
    (setf receive (packet-send-receive-single packet))
    (real-integer (get-packet-data receive 0))))

;;; #002 yy-protocol-2
;;; $@%F%j%H%j$NI=<(!?HsI=<((J
;;; (yy-protocol-2 no visible-p) -> 
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  visible = $@I=<(%U%i%0(J 1->$@I=<((J 0->$@HsI=<((J
(defcommand yy-protocol-2 (no visible)
  (let ((packet (car *send*)))
    
    (setf
     (c_access packet 0) (encode-com-pac 2 4))
    (c_store2 packet 2 no)
    (c_store2 packet 3 visible)

#|
  (make-command-packet 2
		       :integer no :integer visible :end)
|#
  ;;; $@Aw?.(J
  (packet-send-single packet)))

;;; #003 yy-protocol-3
;;; $@%F%j%H%j$N0\F0(J
;;; (yy-protocol-3 no x y) ->
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;       x  = $@?F%F%j%H%j$N:8>e$+$i$N:BI8(J X
;;;	  y  = $@?F%F%j%H%j$N:8>e$+$i$N:BI8(J Y
(defcommand yy-protocol-3 (no x y)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 3 5))

    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
     
#|
  (make-command-packet 3
		       :integer no :integer x :integer y :end)
|#
  (packet-send-single packet)))

;;; #004 yy-protocol-4
;;; $@%F%j%H%j$N0LCVBg$-$5$NJQ99(J 
;;; (yy-protocol-4 no x y width height new-x new-y) ->
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;       x  = $@?F%F%j%H%j$N:8>e$+$i$N:BI8(J X
;;;	  y  = $@?F%F%j%H%j$N:8>e$+$i$N:BI8(J Y
;;;	  width = $@%F%j%H%j$NI}(J
;;;	  height = $@%F%j%H%j$N9b$5(J
;;;       new-x =  $@?7$7$$%F%j%H%j$NIA2h86E@(J
;;;       new-y =  $@?7$7$$%F%j%H%j$NIA2h86E@(J
;;;    $@85$N%F%j%H%j$K3(IA$+$l$F$$$?3($,!"?7$7$$IA2h86E@$K%3%T!<$5$l$k!#(J
(defcommand yy-protocol-4 (no x y width height &optional (new-x 0) (new-y 0))
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 4 9))
    (c_store2 packet 2 no)
    (c_store2 packet 3 x)
    (c_store2 packet 4 y)
    (c_store2 packet 5 width)
    (c_store2 packet 6 height)
    (c_store2 packet 7 new-x)
    (c_store2 packet 8 new-y)

#|
  (make-command-packet 4
		       :integer no :integer x :integer y :integer width
		       :integer height 
		       :integer new-x :integer new-y :end)
|#
  (packet-send-single packet)))

;;; #005 yy-protocol-5
;;; $@%F%j%H%j$NGK2u(J
;;; (yy-protocol-5 no) -> no
;;; args. no = $@%F%j%H%j$NHV9f(J
;;; val.  no = 0$@$J$i$P<:GT!"$=$&$G$J$1$l$PAw$C$?%F%j%H%jHV9f(J
(defcommand yy-protocol-5 (no)
  (let ((packet (car *send*))
	(receive nil))

    (setf
     (c_access packet 0) (encode-com-pac 5 3))

    (c_store2 packet 2 no)


;    (make-command-packet 5 :integer no :end)

    (setf receive (packet-send-receive-single packet))
    (get-packet-data receive 0)))
  

;;; #006 yy-protocol-6
;;; $@%F%j%H%j$N?FJQ99(J
;;; (yy-protocol-6 no pno x y) ->
;;; args. no  = $@%F%j%H%j$NHV9f(J
;;;	  pno = $@?F%F%j%H%j$NHV9f(J
;;;	  x   = $@?7$7$$?FFb$G$N0LCV(J X
;;;	  y   = $@?7$7$$?FFb$G$N0LCV(J Y
(defcommand yy-protocol-6 (no pno x y)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 6 6))
    (c_store2 packet 2 no)
    (c_store2 packet 3 pno)
    (c_store2 packet 4 x)
    (c_store2 packet 5 y)


;  (make-command-packet 6 :integer no :integer pno :integer x :integer y :end)

  (packet-send-single packet )))

;;; #007 yy-protocol-7
;;; $@%F%j%H%j$N@$BeJQ99!J0lHV>e$X!K(J
;;; (yy-protocol-7 no) ->
;;; args. no = $@%F%j%H%j$NHV9f(J
(defcommand yy-protocol-7 (no)
    (let ((packet (car *send*)))
      
      (setf
       (c_access packet 0) (encode-com-pac 7 3))
      (c_store2 packet 2 no)

;  (make-command-packet 7 :integer no :end)

  (packet-send-single packet )))

;;; #008 yy-protocol-8
;;; $@%F%j%H%j$N@$BeJQ99!J0lHV2<$X!K(J
;;; (yy-protocol-7 no) ->
;;; args. no = $@%F%j%H%j$NHV9f(J
(defcommand yy-protocol-8 (no)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 8 3))
    (c_store2 packet 2 no)

;  (make-command-packet 8 :integer no :end)
  (packet-send-single packet )))


;;; #009 yy-protocol-9
;;; reserved

;;; #010 yy-protocol-10
;;; $@J8;z%U%)%s%H$N%m!<%I(J
;;; (yy-protocol-10 name text-font) -> text-font
;;; args. name = $@%U%)%s%HL>(J
;;;	  text-font = class text-font
;;; val.  text-font = class text-font
(defcommand yy-protocol-10 (name text-font)
  (let ((receive nil)
		(font-char-data (slot-value text-font 'ascii-font))
		(temp-val 10))

    (make-command-packet 10 :string name :end)

    (setf receive (packet-send-receive))

    ;;; text-font $@$X$N=q$-9~$_(J
    (setf (slot-value text-font 'font-name) name
	  (slot-value text-font 'internal-font-no) (get-packet-data receive 0)
	  (slot-value text-font 'kanji-width)  (get-packet-data receive 1)
	  (slot-value text-font 'kanji-height) (get-packet-data receive 2)
	  (slot-value text-font 'kanji-base-line) (get-packet-data receive 3)
	  temp-val (slot-value text-font 'kanji-width))

	(setf temp-val (round (/ temp-val 2)))

      (dotimes (i 256)
	(multiple-value-bind (cc cw ch cb) (fixnum-to-bytes
					    (get-packet-data receive (+ i 4)))
        ;; $@I,$:(J256$@8D$J$1$l$P$J$i$J$$(J
	(if (numberp cc)
	    (let ((font-char (elt font-char-data i)))
	      (setf (slot-value font-char 'character-width) 
				(if (zerop cw)
					temp-val
				  cw)
				(slot-value font-char 'character-height) 
				(if (zerop ch)
					temp-val
				  ch)
		    (slot-value font-char 'character-base-line) 
			(if (zerop cb)
				temp-val
			  cb))
	      )
	  )))
      text-font
      ))


;;; #011 yy-protocol-11
;;; reserved

;;; #012 yy-protocol-12
;;; reserved

;;; #013 yy-protocol-13
;;; reserved

;;; #014 yy-protocol-14
;;; reserved

;;; #015 yy-protocol-15
;;; reserved

;;; #016 yy-protocol-16
;;; reserved

;;; #017 yy-protocol-17
;;; reserved

;;; #018 yy-protocol-18
;;; reserved

;;; #019 yy-protocol-19
;;; reserved


;;; #020 yy-protocol-20
;;; $@E@$NIA2h(J
;;; (yy-protocol-20 no x y op color) ->
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x  = $@%F%j%H%j$N:8>e$+$i$N:BI8(J X
;;;	  y  = $@%F%j%H%j$N:8>e$+$i$N:BI8(J Y
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
(defcommand yy-protocol-20 (no x y op color)
  (if (/= color -1)
	  (let ((packet (car *send*)))
		(setf
		 (c_access packet 0) (encode-com-pac 20 7))
		(c_store_mul packet 2 no x y op color 0 0 0 0 0)
		(packet-send-single packet))))


;;; #021 yy-protocol-21
;;; $@@~$NIA2h(J
;;; (yy-protocol-21 no x1 y1 x2 y2 width op edge color dashing)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x1 = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J X
;;;	  y1 = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J Y
;;;       x2 = $@%F%j%H%j$N:8>e$+$i$N=*E@:BI8(J X
;;;	  y2 = $@%F%j%H%j$N:8>e$+$i$N=*E@:BI8(J Y
;;;		$@0J>e$NCM$O@~$NCf?4(J
;;;	  width = $@@~$NI}(J $@Cf?4$+$i$G$O$J$$(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  edge = $@@~$NC<E@$N7A(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  dashing = $@%@%C%7%s%0$h$&$N(Jchar$@$NG[Ns$,F~$C$F$$$k!#(J
;;;		    $@%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(JX_window$@$NCM$K=>$&(J
(defcommand yy-protocol-21 (no x1 y1 x2 y2 width op edge color dashing)
  (if (/= color -1)
	  (let* ((r-length (real-length dashing))
			 (p-length (byte-packet-length r-length)))
		(if (< (+ p-length 12) *max-message-size*)
			(let ((packet (car *send*)))

			  (setf
			   (c_access packet 0) (encode-com-pac 21 (+ p-length 12)))
			  (c_store_mul packet 2 no x1 y1 x2 y2 width op 
						   edge color r-length)
			  (set-string-to-string packet 12 dashing)

			  (packet-send-single packet))
		  (progn 
			(make-command-packet 
			 21 :integer no :integer x1 :integer Y1 
			 :integer x2 :integer y2
			 :integer width :integer op :integer edge :integer color
			 :string dashing :end)
			(packet-send))))))


;;; #022 yy-protocol-22
;;; $@1_$NIA2h(J
;;; (yy-protocol-22 no x y radius width op color dashing) ->
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J X
;;;	  y = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J Y
;;;	  radius = $@1_$NH>7B(J
;;;	  width = $@@~$NB@$5(J $@H>7B$NFbB&$KB@$/$J$k(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  dashing = $@%@%C%7%s%0$h$&$N(Jchar$@$NG[Ns$,F~$C$F$$$k!#(J
;;;		    $@%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(JX_window$@$NCM$K=>$&(J
(defcommand yy-protocol-22 (no x y radius width op color dashing)
  (if (/= color -1) 
	  (let* ((r-length (real-length dashing))
			 (p-length (byte-packet-length r-length)))
		(if (< (+ p-length 10) *max-message-size*)
			(let ((packet (car *send*)))

			  (setf
			   (c_access packet 0) (encode-com-pac 22 (+ p-length 10)))

			  (c_store_mul packet 2 no x y radius width op color r-length 0 0)
			  (set-string-to-string packet 10 dashing)
	    
			  (packet-send-single packet))
		  (progn
			(make-command-packet 
			 22 :integer no :integer x :integer y :integer radius
			 :integer width :integer op :integer color
			 :string dashing :end)
			(packet-send))))))


;;; #023 yy-protocol-23
;;; $@@^$l@~$NIA2h(J
;;; (yy-protocol-23 no xys-list width op edge connect color
;;;                 dashing) -> ?
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  xys-list = $@0J2<$NDL$j(J
;;;	    x1 = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J X
;;;	    y1 = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J Y
;;;	    x2 = $@%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(J X
;;;	    y2 = $@%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(J Y
;;;	    xm = $@%F%j%H%j$N:8>e$+$i$N=*E@:BI8(J X
;;;	    ym = $@%F%j%H%j$N:8>e$+$i$N=*E@:BI8(J Y
;;;		$@0J>e$NCM$O@~$NCf?4(J
;;;	  width = $@@~$NB@$5(J $@Cf?4$+$i$G$O$J$$(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  edge = $@@~$NC<E@$N7A(J X_window $@$NCM$K=>$&(J
;;;	  connect = $@@\B3E@$N7A(J X_window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  dashing = $@%@%C%7%s%0$h$&$N(Jchar$@$NG[Ns$,F~$C$F$$$k!#(J
;;;		    $@%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(JX_window$@$NCM$K=>$&(J
;;; val.  ?
(defcommand yy-protocol-23 (no xys-list width op edge connect color dashing)
  (if (/= color -1) 
	  (let ((args nil) (points (round (length xys-list) 2)))
		(setf args
			  `(23 :integer ,no
				   :integer ,points
				   ,.(mapcan #'(lambda (p) (list :integer p))
							 xys-list)
				   :integer ,width :integer ,op :integer ,edge
				   :integer ,connect :integer ,color
				   :string ,dashing :end))
		(apply 'make-command-packet args)
		(packet-send))))

;;; #024 yy-protocol-24
;;; $@B?3Q7A$NIA2h(J
;;; (yy-protocol-24 no xys-list width op connect color dashing)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  xys-list = $@0J2<$NDL$j(J
;;;	    x1 = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J X
;;;	    y1 = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J Y
;;;	    x2 = $@%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(J X
;;;	    y2 = $@%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(J Y
;;;	    xm = $@%F%j%H%j$N:8>e$+$i$N=*E@:BI8(J X
;;;	    ym = $@%F%j%H%j$N:8>e$+$i$N=*E@:BI8(J Y
;;;		$@0J>e$NCM$O@~$NCf?4(J
;;;	  width = $@@~$NB@$5(J $@Cf?4$+$i$G$O$J$$(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  connect = $@@\B3E@$N7A(J X_window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  dashing = $@%@%C%7%s%0$h$&$N(Jchar$@$NG[Ns$,F~$C$F$$$k!#(J
;;;		    $@%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(JX_window$@$NCM$K=>$&(J
;;; val.  ?
(defcommand yy-protocol-24 (no xys-list width op connect color dashing)
  (if (/= color -1)
	  (let ((args nil) (points (round (length xys-list) 2)))
		(setf args
			  `(24 :integer ,no :integer ,points
				   ,.(mapcan #'(lambda (p) (list :integer p))
							 xys-list)
				   :integer ,width :integer ,op
				   :integer ,connect :integer ,color
				   :string ,dashing :end))
		(apply 'make-command-packet args)
		(packet-send))))

;;; #025 yy-protocol-25
;;; $@1_8L$NIA2h(J
;;; (yy-protocol-25 no x y radius theta1 theta2 width op color dashing) -> ?
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J X
;;;	  y = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J Y
;;;	  radius = $@H>7B(J
;;;	  theta1 = $@1_8L3+;OE@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(J
;;;		   1/64$@EYC10L(J
;;;	  theta2 = $@1_8L3+=*E@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(J
;;;		   1/64$@EYC10L(J
;;;	  width = $@@~$NB@$5(J $@!JH>7B$+$i1[$($J$$!K(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  dashing = $@%@%C%7%s%0$h$&$N(Jchar$@$NG[Ns$,F~$C$F$$$k!#(J
;;;		    $@%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(JX_window$@$NCM$K=>$&(J
;;; val.  ?
(defcommand yy-protocol-25 (no x y radius theta1 theta2 width op color dashing)
  (if (/= color -1)
	  (let* ((r-length (real-length dashing))
			 (p-length (byte-packet-length r-length)))
		(if (< (+ p-length 12) *max-message-size*)
			(let ((packet (car *send*)))

			  (setf
			   (c_access packet 0) (encode-com-pac 25 (+ p-length 12)))
			  
			  (c_store_mul packet 2 no x y radius theta1 theta2 width op color
						   r-length)
			  (packet-send-single packet))
		  (progn 
			(make-command-packet 
			 25 :integer no :integer x :integer y :integer radius
			 :integer theta1 :integer theta2 :integer width 
			 :integer op :integer color :string dashing :end)
			(packet-send))))))


;;; #026 yy-protocol-26
;;; $@;M3Q7A$NIA2h(J
;;; (yy-protocol-26 no x y width height linewidt op color dashing) -> ?
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J X
;;;	  y = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J Y
;;;	  width = $@;M3Q7A$NI}(J
;;;	  height = $@;M3Q7A$N9b$5(J
;;;	  linewidt = $@@~$NI}(J $@;XDj$7$?(Jwidth$@!"(Jheight$@$h$jFbB&(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  dashing = $@%@%C%7%s%0$h$&$N(Jchar$@$NG[Ns$,F~$C$F$$$k!#(J
;;;		    $@%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(JX_window$@$NCM$K=>$&(J
;;; val.  ?
(defcommand yy-protocol-26 (no x y width height linewidt op color dashing)
  (if (/= color -1)
	  (let* ((r-length (real-length dashing))
			 (p-length (byte-packet-length r-length)))
		(if (< (+ p-length 11) *max-message-size*)
			(let ((packet (car *send*)))
			  (setf
			   (c_access packet 0) (encode-com-pac 26 (+ p-length 11)))
			  (c_store_mul packet 2 no x y width height linewidt op color 
						   r-length 0)
			  (set-string-to-string packet 11 dashing)
			  (packet-send-single packet))
		  (progn
			(make-command-packet 
			 26 :integer no :integer x :integer y :integer width
			 :integer height :integer linewidt :integer op
			 :integer color :string dashing :end)
			(packet-send))))))
		      

;;; #027 yy-protocol-27
;;; $@EI$jDY$7B?3Q7A$NIA2h(J
;;; (yy-protocol-27 no xys-list op connect color fill pattarn)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  xys-list = $@0J2<$NDL$j(J
;;;	    x1 = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J X
;;;	    y1 = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J Y
;;;	    x2 = $@%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(J X
;;;	    y2 = $@%F%j%H%j$N:8>e$+$i$NBh#2E@L\$N:BI8(J Y
;;;	    xm = $@%F%j%H%j$N:8>e$+$i$N=*E@:BI8(J X
;;;	    ym = $@%F%j%H%j$N:8>e$+$i$N=*E@:BI8(J Y
;;;		$@0J>e$NCM$O@~$NCf?4(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  connect = $@@\B3E@$N7A(J X_window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  fill = $@EI$jDY$7%k!<%k(J X_window$@$K=>$&(J
;;;	  pattern = $@EI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(J $@$b$7#0$J$i$P(J
;;;		   $@;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(J
(defcommand yy-protocol-27 (no xys-list op connect color fill pattern)
  (if (/= color -1) 
	  (let ((args nil) (points (round (length xys-list) 2)))
		(setf args
			  `(27 :integer ,no :integer ,points
				   ,.(mapcan #'(lambda (p) (list :integer p))
							 xys-list)
				   :integer ,op :integer ,connect :integer ,color
				   :integer ,fill :integer ,pattern :end))
		(apply 'make-command-packet args)
		(packet-send))))


;;; #028 yy-protocol-28
;;; $@EI$jDY$7;M3Q7A$NIA2h(J
;;; (yy-protocol-28 no x y width height op color pattern) -> ?
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J X
;;;	  y = $@%F%j%H%j$N:8>e$+$i$N;OE@:BI8(J Y
;;;	  width = $@;M3Q7A$NI}(J
;;;	  height = $@;M3Q7A$N9b$5(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  pattern = $@EI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(J $@$b$7#0$J$i$P(J
;;;		   $@;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(J
(defcommand yy-protocol-28 (no x y width height op color pattern)
  (if (/= color -1)
	  (let ((packet (car *send*)))
		(setf
		 (c_access packet 0) (encode-com-pac 28 10))
		(c_store_mul packet 2 no x y width height op color pattern 0 0)
		(packet-send-single packet))))

;;; #029 yy-protocol-29
;;; $@EI$jDY$71_$NIA2h(J
;;; (yy-protocol-29 no x y radius op color pattern)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J X
;;;	  y = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J Y
;;;	  radius = $@1_$NH>7B(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  pattern = $@EI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(J $@$b$7#0$J$i$P(J
;;;		   $@;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(J
(defcommand yy-protocol-29 (no x y radius op color pattern)
  (if (/= color -1)
	  (let ((packet (car *send*)))
		(setf
		 (c_access packet 0) (encode-com-pac 29 10))
		(c_store_mul packet 2 no x y radius op color pattern 0 0 0)
		(packet-send-single packet))))


;;; #030 yy-protocol-30
;;; $@EI$jDY$7@p7A$NIA2h(J
;;; (yy-protocol-30 no x y radius theta1 theta2 op color pattern a-mode) -> ?
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J X
;;;	  y = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J Y
;;;	  radius = $@H>7B(J
;;;	  theta1 = $@1_8L3+;OE@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(J
;;;		   1/64$@EYC10L(J
;;;	  theta2 = $@1_8L3+=*E@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(J
;;;		   1/64$@EYC10L(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  pattern = $@EI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(J $@$b$7#0$J$i$P(J
;;;		   $@;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(J
;;;       a-mode = $@@p7?%b!<%I(J  
;;; val.  ?
(defcommand yy-protocol-30 (no x y radius theta1 theta2 op color 
							   pattern a-mode)
  (if (/= color -1)
	  (let ((packet (car *send*)))
		(setf
		 (c_access packet 0) (encode-com-pac 30 12))
		(c_store_mul packet 2 no x y radius theta1 theta2 op 
					 color pattern a-mode)
    (packet-send-single packet))))


;;; #031 yy-protocol-31
;;; $@J8;zNs$NIA2h(J
;;; (yy-protocol-31 no x y op color fno string)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x  = $@%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(J X
;;;	  y  = $@%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(J Y
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  fno = font $@$NHV9f(J
;;;	  string = $@J8;zNs(J
(defcommand yy-protocol-31 (no x y op color fno string)
  (if (/= color -1)
	  (let* ((r-length (real-length string))
			 (p-length (byte-packet-length r-length)))
		(if (< (+ p-length 9) *max-message-size*)
			(let ((packet (car *send*)))
			  (setf
			   (c_access packet 0) (encode-com-pac 31 (+ p-length 9)))
			  (c_store_mul packet 2 no x y op color fno r-length 0 0 0)
			  (set-string-to-string packet 9 string)
			  (packet-send-single packet))
		  (progn 
			(make-command-packet 
			 31 :integer no :integer x :integer y :integer op
			 :integer color :integer fno :string string :end)
			(packet-send))))))

;;; #032 yy-protocol-32
;;; $@GX7J$NIA2h(J
;;; (yy-protocol-32 no color)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  color = $@?'$N;XDj(J
(defcommand yy-protocol-32 (no color)
  (if (/= color -1)
	  (let ((packet (car *send*)))
		(setf
		 (c_access packet 0) (encode-com-pac 32 4))
		(c_store2 packet 2 no)
		(c_store2 packet 3 color)
		(packet-send-single packet))))

;;; #033 yy-protocol-33
;;; $@GX7J%Q%?!<%s!J%S%C%H%^%C%W!K$NIA2h(J
;;; (yy-protocol-33 no pno)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  pno = $@%Q%?!<%s$,F~$C$F$$$k%F%j%H%j(J
(defcommand yy-protocol-33 (no pno)
  (let ((packet (car *send*)))
    (setf
     (c_access packet 0) (encode-com-pac 33 4))
    (c_store2 packet 2 no)
    (c_store2 packet 3 pno)
    (packet-send-single packet)))
#|
;  (territory-check no)
  (make-command-packet 33 :integer no :integer pno :end)
  (packet-send))
|#

;;; #034 yy-protocol-34
;;; $@%S%C%H%^%C%W$N:n@.(J
;;; (yy-protocol-34 no width height format pat)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  width = $@%Q%?!<%s$NI}(J
;;;	  height = $@%Q%?!<%s$N9b$5(J
;;;	  format = 1 --> Common Window $@%U%)!<%^%C%H(J
;;;		   2 --> X-window $@%U%)!<%^%C%H(J
;;;	  pat = $@%Q%?!<%s$,F~$C$F$$$kJ8;zNs(J
(defcommand yy-protocol-34 (no width height format pat)
  (make-command-packet 34 :integer no :integer width :integer height
		       :integer format :vector pat :end)
  (packet-send))

;;; #035 yy-protocol-35
;;; bitblt
;;; (yy-protocol-35 sno sx sy dno dx dy width height op)
;;; args. sno = $@%=!<%9%F%j%H%j$NHV9f(J
;;;	  sx = $@%=!<%9%F%j%H%j$N3+;O0LCV(J X
;;;	  sy = $@%=!<%9%F%j%H%j$N3+;O0LCV(J Y
;;;	  dno = $@%G%9%F%#%M!<%7%g%s%F%j%H%j$NHV9f(J
;;;	  dx = $@%G%9%F%#%M!<%7%g%s%F%j%H%jFb$KIA2h$5$l$k0LCV(J X
;;;	  dx = $@%G%9%F%#%M!<%7%g%s%F%j%H%jFb$KIA2h$5$l$k0LCV(J Y
;;;	  width = $@%G%9%F%#%M!<%7%g%s%F%j%H%jFb$KIA2h$5$l$kBg$-$5(J width
;;;	  height = $@%G%9%F%#%M!<%7%g%s%F%j%H%jFb$KIA2h$5$l$kBg$-$5(J height
;;;	  op = bitblt$@$9$k%*%Z%l!<%7%g%s(J
(defcommand yy-protocol-35 (sno sx sy dno dx dy width height op)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 35 11))
    (c_store2 packet 2 sno)
    (c_store2 packet 3 sx)
    (c_store2 packet 4 sy)
    (c_store2 packet 5 dno)
    (c_store2 packet 6 dx)
    (c_store2 packet 7 dy)
    (c_store2 packet 8 width)
    (c_store2 packet 9 height)
    (c_store2 packet 10 op)

    (packet-send-single packet)))
#|
  (make-command-packet 35 :integer sno :integer sx :integer sy :integer dno
		       :integer dx :integer dy :integer width :integer height
		       :integer op :end)
  (packet-send))
|#

;;; #036 yy-protocol-36
;;; $@%F%j%H%j$KIA2h$5$l$F$$$k3(>pJs$N%;!<%V#n8D(J
;;; (yy-protocol-36 return-string &rest territory-nos) -> return-string
;;;	  territory-nos = $@%F%j%H%jHV9f$N%j%9%H(J
;;; val.  return        = territory-nos$@$KIA2h$5$l$F$$$k3(%G!<%?$NJ8;zNs(J
#-CMU
(defcommand yy-protocol-36 (return-string &rest nos-list)
  (let ((args nil) (receive nil))
    (dolist (item nos-list)
            (push :integer args)
            (push item args))
    (push :end args)
    (setf args (nreverse args))
    (push 36 args)
    (apply 'make-command-packet args)
   
    (setf receive (packet-send-receive)
		  return-string
		  (get-packet-data receive 1 (get-packet-data receive 0)))
    ))

;;; #037 yy-protocol-37
;;; $@%F%j%H%j$KIA2h$5$l$F$$$k3(>pJs$N%m!<%I#n8D(J
;;; (yy-protocol-37 data-string &rest nos-list) -> flg
;;; args. data-string = $@3(%G!<%?J8;zNs(J
;;;	  nos-list = $@%F%j%H%jHV9f$N%j%9%H(J
;;; val.  flg = 0:ok  1:no good
(defcommand yy-protocol-37 (data-string &rest nos-list)
  (let ((args nil)(receive nil))
    (dolist (item nos-list)
	    (push :integer args)
            (push item args))
    (setf args (nreverse args))
    (push 37 args)
    (setf args (nconc args (list :string data-string)))

    (setf receive (packet-send-receive))

    (get-packet-data receive 0)))


;;; #038 yy-protocol-38
;;; $@%F%j%H%j$KIA2h$5$l$F$$$k3(>pJs$N3HBg!?=L>.(J
;;; (yy-protocol-38 sno dno x-ratio y-ratio)
;;; args. sno = $@3HBg!?=L>.$5$l$k%F%j%H%jHV9f(J
;;;       dno = $@3HBg!?=L>.$5$l$k%F%j%H%j$,==J,$KF~$k%F%j%H%j(J
;;;	  x-raito = X $@J}8~$N3HBg!?=L>.G\N((J 1/100 $@C10L(J
;;;	  y-raito = Y $@J}8~$N3HBg!?=L>.G\N((J 1/100 $@C10L(J
(defcommand yy-protocol-38 (sno dno x-ratio y-ratio)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 38 6))
    (c_store2 packet 2 sno)
    (c_store2 packet 3 dno)
    (c_store2 packet 4 x-ratio)
    (c_store2 packet 5 y-ratio)

    (packet-send-single packet)))

#|
  (make-command-packet 38 :integer sno :integer dno :integer x-raito
		       :integer y-raito :end)
  (packet-send))
|#

;;; #039 yy-protocol-39
;;; $@%F%j%H%j$KIA2h$5$l$F$$$k3(>pJs$N2sE>(J
;;; (yy-protocol-39 sno dno degree)
;;; args. sno = $@2sE>$5$l$k%F%j%H%jHV9f(J
;;;       dno = $@2sE>$5$l$k%F%j%H%j$,==J,$KF~$k%F%j%H%j(J
;;;	  degree = $@2sE>3Q(J 1/64$@EYC10L(J
(defcommand yy-protocol-39 (sno dno degree)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 39 5))
    (c_store2 packet 2 sno)
    (c_store2 packet 3 dno)
    (c_store2 packet 4 degree)
    (packet-send-single packet)))

#|
  (make-command-packet 39 :integer sno :integer dno :integer degree :end)
  (packet-send))
|#

;;; #040 $@$O(J60$@$KJQ99!#=>$C$F(J#040$@$OL$;HMQ(J

;;; #041 yy-protocol-41
;;; $@BJ1_8L$NIA2h(J
;;; (yy-protocol-41 no x y width height theta1 theta2 lwidth op color dashing)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J X
;;;	  y = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J Y
;;;	  width = $@BJ1_$NI}(J
;;;	  height = $@BJ1_$N9b$5(J
;;;	  theta1 = $@1_8L3+;OE@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(J
;;;		   1/64$@EYC10L(J
;;;	  theta2 = $@1_8L3+=*E@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(J
;;;		   1/64$@EYC10L(J
;;;	  lwidth = $@@~$NB@$5(J $@!JH>7B$+$i1[$($J$$!K(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  dashing = $@%@%C%7%s%0$h$&$N(Jchar$@$NG[Ns$,F~$C$F$$$k!#(J
;;;		    $@%U%)%s%H$N%m!<%I$HF1MM$G!"CM$O(JX_window$@$NCM$K=>$&(J
(defcommand yy-protocol-41 (no x y width height theta1 theta2 lwidth op 
							   color dashing)
  (if (/= color -1)
	  (let* ((r-length (real-length dashing))
			 (p-length (byte-packet-length r-length)))
		(if (< (+ p-length 13) *max-message-size*)
			(let ((packet (car *send*)))
			  (setf
			   (c_access packet 0) (encode-com-pac 41 (+ p-length 13)))
			  (c_store2 packet 2 no)
			  (c_store2 packet 3 x)
			  (c_store2 packet 4 y)
			  (c_store2 packet 5 width)
			  (c_store2 packet 6 height)
			  (c_store2 packet 7 theta1)
			  (c_store2 packet 8 theta2)
			  (c_store2 packet 9 lwidth)
			  (c_store2 packet 10 op)
			  (c_store2 packet 11 color)
			  (c_store2 packet 12 r-length)
			  (set-string-to-string packet 13 dashing)
            (packet-send-single packet))
		  (progn
			(make-command-packet 
			 41 :integer no :integer x :integer y :integer width
			 :integer height 
			 :integer theta1 :integer theta2 :integer lwidth
			 :integer op :integer color :string dashing :end)
			
	(packet-send))))))
       

;;; #042 yy-protocol-42
;;; $@EI$jDY$7BJ1_8L$NIA2h(J
;;; (yy-protocol-42 no x y width height theta1 theta2 op color pattern arc_mode)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J X
;;;	  y = $@%F%j%H%j$N:8>e$+$i$NCf?4:BI8(J Y
;;;	  width = $@BJ1_$NI}(J
;;;	  height = $@BJ1_$N9b$5(J
;;;	  theta1 = $@1_8L3+;OE@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(J
;;;		   1/64$@EYC10L(J
;;;	  theta2 = $@1_8L3+=*E@$N#X<4$+$i$N3QEY!J%G%#%0%j!<!K(J
;;;		   1/64$@EYC10L(J
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  pattern = $@EI$jDY$7%Q%?!<%s$N%F%j%H%jHV9f(J  $@$b$7(J0 $@$J$i$P(J
;;;		   $@;XDj$5$l$??'$GEI$jDY$7$,9T$o$l$k(J
;;;	  arc_mode = arc_mode$@$O(J X$@%&%#%s%I%&$K=>$&(J
;;;		     arc_mode --> ArcPieSlice $@@p7?(J
;;;		     arc_mode --> ArcChord    $@5]7?(J
(defcommand yy-protocol-42 (no x y width height theta1 theta2 op 
							   color pattern arc_mode)
  (if (/= color -1)
	  (let ((packet (car *send*)))
		(setf
		 (c_access packet 0) (encode-com-pac 42 13))
		(c_store2 packet 2 no)
		(c_store2 packet 3 x)
		(c_store2 packet 4 y)
		(c_store2 packet 5 width)
		(c_store2 packet 6 height)
		(c_store2 packet 7 theta1)
		(c_store2 packet 8 theta2)
		(c_store2 packet 9 op)
		(c_store2 packet 10 color)
		(c_store2 packet 11 pattern)
		(c_store2 packet 12 arc_mode)

		(packet-send-single packet))))


;;; #043 yy-protocol-43
;;; $@=D=q$-J8;zNs$NIA2h(J
;;; (yy-protocol-43 no x y op color fno string)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x  = $@%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(J X
;;;	  y  = $@%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(J Y
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  fno = font $@$NHV9f(J
;;;	  string = $@J8;zNs(J
(defcommand yy-protocol-43 (no x y op color fno string)
  (if (/= color -1)
	  (let* ((r-length (real-length string))
			 (p-length (byte-packet-length r-length)))
		(if (< (+ p-length 9) *max-message-size*)
			(let ((packet (car *send*)))
			  (setf
			   (c_access packet 0) (encode-com-pac 43 (+ p-length 9)))
			  (c_store2 packet 2 no)
			  (c_store2 packet 3 x)
			  (c_store2 packet 4 y)
			  (c_store2 packet 5 op)
			  (c_store2 packet 6 color)
			  (c_store2 packet 7 fno)
			  (c_store2 packet 8 r-length)
			  (set-string-to-string packet 9 string)
			  
            (packet-send-single packet))
		  (progn
	
			(make-command-packet 
			 43 :integer no :integer x :integer y :integer op
			 :integer color :integer fno :string string :end)
			(packet-send))))))

;;; #044 yy-protocol-44
;;; $@2sE>9TNs$rH<$C$?J8;zNs$NIA2h(J
;;; (yy-protocol-44 no x y op color fno x-time y-time theta string)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;	  x  = $@%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(J X
;;;	  y  = $@%F%j%H%j$N:8>e$+$i$N%Y!<%9%i%$%s:BI8(J Y
;;;	  op = $@%i%9%?!<%*%Z%l!<%7%g%s(J X-window $@$NCM$K=>$&(J
;;;	  color = $@?'$N;XDj(J
;;;	  fno = font $@$NHV9f(J
;;;	  x-time = $@2sE>9TNs$K$*$1$k#XJ}8~$NG\?t(J
;;;	  y-time = $@2sE>9TNs$K$*$1$k#YJ}8~$NG\?t(J
;;;	  theta = $@2sE>9TNs$K$*$1$k2sE>3QEY(J ($@%G%#%0%j!<(J)
;;;	  string = $@J8;zNs(J
(defcommand yy-protocol-44 (no x y op color fno x-time y-time theta string)
  (if (/= color -1)
	  (let* ((r-length (real-length string))
			 (p-length (byte-packet-length r-length)))
		(if (< (+ p-length 12) *max-message-size*)
			(let ((packet (car *send*)))
			  (setf
			   (c_access packet 0) (encode-com-pac 44 (+ p-length 12)))
			  (c_store2 packet 2 no)
			  (c_store2 packet 3 x)
			  (c_store2 packet 4 y)
			  (c_store2 packet 5 op)
			  (c_store2 packet 6 color)
			  (c_store2 packet 7 fno)
			  (c_store2 packet 8 x-time)
			  (c_store2 packet 9 y-time)
			  (c_store2 packet 10 theta)
			  (c_store2 packet 11 r-length)
			  (set-string-to-string packet 12 string)
			  (packet-send-single packet))
		  (progn 
			(make-command-packet 
			 44 :integer no :integer x :integer y :integer op
		     :integer color :integer fno :integer x-time :integer y-time
		     :integer theta :string string :end)

			(packet-send))))))

;;; #045 yy-protocol-45
;;; $@%+%i!<HV9f$r5a$a$k(J
;;; (yy-protocol-45 r g b) -> no
;;; args. r
;;;	  g
;;;	  b
;;; vals. no
(defcommand yy-protocol-45 (r g b)
  (let ((receive nil)
	(packet (car *send*)))
    (setf
     (c_access packet 0) (encode-com-pac 45 5))
    (c_store2 packet 2 r)
    (c_store2 packet 3 g)
    (c_store2 packet 4 b)

;    (make-command-packet 45 :integer r :integer g :integer b :end)

    (setf receive (packet-send-receive-single packet))

    (real-integer (get-packet-data receive 0))))
  

;;; #046 yy-protocol-46
;;; $@%+%i!<L>$+$i%+%i!<HV9f$r5a$a$k(J
;;; (yy-protocol-46 name) -> no
;;; vals .no
(defcommand yy-protocol-46 (name)
  (let ((receive nil))
    (make-command-packet 46 :string name :end)

    (setf receive (packet-send-receive))

   (list (get-packet-data receive 0)
	 (get-packet-data receive 1)
	 (get-packet-data receive 2)
	 (get-packet-data receive 3))))


;;; #047 yy-protocol-47
;;; reserved

;;; #048 yy-protocol-48
;;; reserved

;;; #049 yy-protocol-49
;;; reserved

;;; #050 yy-protocol-50

;;;#050 yy-protocol-51
;;; $@%+%i!<$N(JRGB$@CM$rJQ99$9$k!#(J
;;; yy-protocol-51 color-no red green blue
;;; args.  color-no  $@%+%i!<HV9f(J
;;;        red       $@@V$N?'CM(J
;;;        green     $@NP$N?'CM(J
;;;        blue      $@@D$N?'CM(J
(defcommand yy-protocol-51 (color-no red green blue)
   (make-command-packet 51 :integer color-no
		 :integer red :integer green :integer blue :end)
   (packet-send))


;;; #052 yy-protocol-52
;;; $@%+%i!<$N2rJ|(J
;;; (yy-protocol-52 color-no-list
;;; args.  clolor-nos  $@%+%i!<HV9f(J
(defcommand yy-protocol-52 (color-no-list)
  (let* ((args (list 52 :integer (length color-no-list)))
	 (last (cddr args)))

    (dotimes (item color-no-list)
      (setf (cdr last) (list :integer item)
	    last (cddr last)))

    (apply #'make-command-packet args)
    (packet-send)))

;;; #053 yy-protocol-53
;;; $@E@$N%+%i!<HV9f$r5a$a$k(J
;;; yy-protocol-53 tno x y
;;; args.  tno    $@%F%j%H%j!<HV9f(J
;;;        x      $@0LCV(Jx
;;;        y      $@0LCV(Jy
(defcommand yy-protocol-53 (tno x y)
  (let ((receive nil))
    (make-command-packet 53 :integer tno :integer x :integer y :end)

    (setf receive (packet-send-receive))

    (get-packet-data receive 0)))


;;; #059 yy-protocol-59
;;; reserved

;;; #060 yy-protocol-60
;;; $@IA2h%$%a!<%8$N<h$j=P$7(J
;;; (yy-protocol-60 no width height format)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;       x     = $@%F%j%H%jFb$N3+;O0LCV(J 
;;;       y     = $@%F%j%H%jFb$N3+;O0LCV(J
;;;	  width = $@%Q%?!<%s$NI}(J
;;;	  height = $@%Q%?!<%s$N9b$5(J
;;;	  format = 1 --> Common Window $@%U%)!<%^%C%H(J
;;;		   2 --> X-window $@%U%)!<%^%C%H(J
;;; return value : (format width height $@%Q%?!<%s$,F~$C$F$$$k%Y%/%?!<(J)
(defcommand yy-protocol-60 (no x y width height format)
  (let ((receive nil))

    (make-command-packet 60 :integer no :integer x :integer y 
			 :integer width :integer height :integer format :end)

    (setf receive (packet-send-receive))
    
    (let* ((j 0) 
	   (pno (floor (/ 5 *max-receive-size*)))
	   (data 0)
	   (shino (mod 5 *max-receive-size*))
	   (end (get-packet-data receive 4))
	   (new-array (make-array end :element-type '(unsigned-byte 8))))

      (do ((sno 0 (incf sno)))
	  ((= sno (/ end 4)))

	(when (>= shino *max-receive-size*)
	  (setf pno   (1+ pno)
		shino 0))
	  
	(setf data (c_access (nth pno receive) shino)
	      shino (1+ shino))

	(multiple-value-bind (a1 a2 a3 a4)
	    (fixnum-to-bytes data)
	  (setf (elt new-array j) a1
		(elt new-array (incf j)) a2
		(elt new-array (incf j)) a3
		(elt new-array (incf j)) a4)
	  )
	(incf j))

      (list format (get-packet-data receive 1)  (get-packet-data receive 2)
	    new-array))))

;;; #061 yy-protocol-61
;;; $@IA2h%$%a!<%8$NIA2h(J
;;; (yy-protocol-61 no x y width height format image-vector)
;;; args. no = $@%F%j%H%j$NHV9f(J
;;;       x     = $@%F%j%H%jFb$N3+;O0LCV(J 
;;;       y     = $@%F%j%H%jFb$N3+;O0LCV(J
;;;	  width = $@%Q%?!<%s$NI}(J
;;;	  height = $@%Q%?!<%s$N9b$5(J
;;;	  format = 1 --> Common Window $@%U%)!<%^%C%H(J
;;;		   2 --> X-window $@%U%)!<%^%C%H(J
;;;       image-vector = $@%$%a!<%8%G!<%?(J
(defcommand yy-protocol-61 (no x y width height format image-data)

   (make-command-packet 61 :integer no :integer x :integer y 
			 :integer width :integer height :integer format 
			 :vector image-data :end)

   (packet-send))

;;; #070 yy-protocol-70
;;; $@J8;zNs%$%Y%s%H$NF~NO(J
;;;

;;; #071 yy-protocol-71
;;; $@%F%j%H%j$NF~NO%;%l%/%7%g%s(J
;;; (yy-protocol-71 no)
;;; args. no = $@%F%j%H%jHV9f(J
(defcommand yy-protocol-71 (no)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 71 3))
    (c_store2 packet 2 no)
    (packet-send-single packet)))
#|
  (make-command-packet 71 :integer no :end)
  (packet-send))
|#

;;; #072 yy-protocol-72
;;; $@%F%j%H%j$NF~NO%^%9%/$N@_Dj(J
;;; (yy-protocol-72 no mask)
;;; args. no = $@%F%j%H%jHV9f(J
;;;	  mask = $@F~NO%^%9%/(J
(defcommand yy-protocol-72 (no mask)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 72 4))
    (c_store2 packet 2 no)
    (c_store2 packet 3 mask)
    (packet-send-single packet)))
  
#|
  (make-command-packet 72 :integer no :integer mask :end)
  (packet-send))
|#

;;; #073 yy-protocol-73
;;; $@%F%j%H%j$NF~NO%$%Y%s%H(J
;;;

;;; #074 yy-protocol-74
;;; $@%F%j%H%j$NF~NO%$%Y%s%HMW5a(J
;;; (yy-protocol-74 state)
;;; args. state = 1 --> $@%$%Y%s%HMW5a(J
;;;		  2 --> $@%$%Y%s%HF~NO5qH](J
(defcommand yy-protocol-74 (state)
  (let ((packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 74 3))
    (c_store2 packet 2 state)
    (packet-send-single packet)))
#|
  (make-command-packet 74 :integer state :end)
  (packet-send))
|#

;;; #076 yy-protocol-76
;;; $@%^%&%9$N%b!<%7%g%s%$%Y%s%HMW5a(J
;;; (yy-protocol-76)
(defcommand yy-protocol-76 ()
  (let ((packet (car *send*)))
    (setf
     (c_access packet 0) (encode-com-pac 76 2))
    (packet-send-single packet)))

;;; #080 yy-protocol-80
;;; $@%Z!<%8%b!<%I%F%j%H%j!<$NB0@-@_Dj(J
;;; (yy-protocol-80 t-no f-no skip d-mode c-mode x y) -> 0-> good 1->fail
;;; args. t-no   = $@%F%j%H%j!<HV9f(J
;;;	  f-no   = $@%U%)%s%HHV9f(J
;;;	  skip   = $@%Y!<%9%i%$%s%9%-%C%W(J
;;;	  d-mode = $@J8;zNs$NJ}8~!!#0!'2#=q$-!!#1!'=D=q$-(J
;;;	  c-mode = $@:BI87O!!!!!!!!#0!':8>e6y!!#1!':82<6y(J
;;;	  x      = $@%+%i%`0LCV(J
;;;       y      = $@9T0LCV(J
(defcommand yy-protocol-80  (t-no f-no skip d-mode c-mode x y)
  (let ((receive nil))
    (make-command-packet 80 :integer t-no :integer f-no :integer skip
     			    :integer d-mode :integer c-mode
			    :integer x :integer y :end)

    (setf receive (packet-send-receive))

    (if (zerop (get-packet-data receive 0))
    	(error "Can not set a page mode attibute"))
    ))

    
;;; #081 yy-protocol-81
;;; $@%Z!<%8%b!<%I%F%j%H%j!<$NB0@-@_Dj(J
;;; (yy-protocol-81 t-no tile tcolumn m-mode line column c-mode)
;;; args. t-no    = $@%F%j%H%j!<HV9f(J
;;;	  tline   = $@0\F0$9$k%F%j%H%j!<$N0\F00LCV!J9T!K(J
;;;	  tcolumn = $@0\F0$9$k%F%j%H%j!<$N0\F00LCV!J%+%i%`!K(J
;;;	  m-mode  = $@0\F0%b!<%I!!#0!'0\F0$;$:(J $@#1!'@dBP:BI8(J $@#2!'AjBP:BI8(J
;;;	  line    = $@%+!<%=%k$N9T0LCV(J
;;;	  column  = $@%+!<%=%k$N%+%i%`0LCV(J
;;;       c-mode  = $@%+!<%=%k$N0\F0%b!<%I!!#0!'0\F0$;$:(J $@#1!'@dBP:BI8(J $@#2!'AjBP:BI8(J
(defcommand yy-protocol-81 (t-no tline tcolumn m-mode line column c-mode)
  (make-command-packet 81 :integer t-no :integer tcolumn :integer tline 
			  :integer m-mode :integer column :integer line 
			  :integer c-mode :end)
  (packet-send))

      
;;; #082 yy-protocol-82
;;; $@%Z!<%8%b!<%I%F%j%H%j!<$NF~NO3+;O(J
;;; (yy-protocol-82 t-no x y type s-terminate-s terminate-s interrupt-s)
;;; args. t-no    = $@%F%j%H%j!<HV9f(J
;;;	  x       = $@3+;O9T(J
;;;	  y       = $@3+;O%+%i%`(J
;;;	  type    = $@%(%3!<%?%$%W!!#1!'%(%3!<!!#2!'%(%3!<$;$:!"%+!<%=%kI=<((J
;;;                               $@#3!'%(%3!<$;$:!"%+!<%=%kI=<(L5$7(J
;;;	  s-terminate-s = $@ESCf7k2LAw?.%-!<$NJ8;zNs(J
;;;	  terminate-s   = $@:G=*7k2LAw?.%-!<$NJ8;zNs(J
;;;       interrupt-s   = $@F~NOCfCG%-!<$NJ8;zNs(J
(defcommand yy-protocol-82 (t-no x y type s-terminate-s terminate-s interrupt-s)
  (make-command-packet 82 :integer t-no :integer x :integer y
			  :integer type :string s-terminate-s
			  :string terminate-s :string interrupt-s :end)
  (packet-send))

;;; #083 yy-protocol-83
;;; $@F~NO=hM}$NCf;_(J
;;; (yy-protocol-83 t-no )
;;; args. t-no    = $@%F%j%H%j!<HV9f(J
(defcommand yy-protocol-83 (t-no)
  (make-command-packet 83 :integer t-no :end)
  (packet-send))

;;; Update 11/14 By T.kosaka
;;; Return value is a list for left, bottom, width, height ,colum and line

;;; #084 yy-protocol-84
;;; $@%Z!<%8%b!<%I%F%j%H%j!<$KBP$9$kJ8;zNs$NIA2h(J
;;; (yy-protocol-84 t-no op color font string) -> 
;;;              (list $@IA2h%j!<%8%g%s(J $@%+%i%`$H9T$N0LCV(J)
;;; args. t-no   = $@%F%j%H%j!<HV9f(J
;;;	  op     = $@I=<(%*%Z%l!<%7%g%s(J
;;;	  color  = $@I=<(%+%i!<HV9f(J
;;;       font   = $@%U%)%s%HHV9f(J
;;;	  string = $@J8;zNs(J
(defcommand yy-protocol-84 (t-no op color font string)
  (if (/= color -1)
	  (let ((receive nil))
		(make-command-packet 84 :integer t-no :integer op :integer color
							 :integer font
							 :string string :end)

		(setf receive (packet-send-receive))

		(list (get-packet-data receive 0)
			  (get-packet-data receive 1)
			  (get-packet-data receive 2)
			  (get-packet-data receive 3)
			  (get-packet-data receive 4)
			  (get-packet-data receive 5)))))
  
;;; #085 yy-protocol-85
;;; $@9T$H%+%i%`$N0LCV$h$j%j!<%8%g%s$r5a$a$k(J
;;; (yy-protocol-85 t-no column line) -> $@%j!<%8%g%s(J
;;; args. t-no   = $@%F%j%H%j!<HV9f(J
;;;	  colum  = $@%+%i%`(J
;;;	  line   = $@9T(J
(defcommand yy-protocol-85 (t-no column line)
  (let ((receive nil)
	(packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 85 5))
    (c_store2 packet 2 t-no)
    (c_store2 packet 3 column)
    (c_store2 packet 4 line)

;    (make-command-packet 85 :integer t-no :integer column :integer line  :end)

    (setf receive (packet-send-receive-single packet))

    (list (get-packet-data receive 0)
	  (get-packet-data receive 1)
	  (get-packet-data receive 2)
	  (get-packet-data receive 3))))


;;; #085 yy-protocol-87
;;; $@8=:_$N9T$H%+%i%`$N0LCV$r5a$a$k(J
;;; (yy-protocol-87 t-no)
;;; args. t-no   = $@%F%j%H%j!<HV9f(J
(defcommand yy-protocol-87 (t-no)
  (let ((receive nil)
	(packet (car *send*)))

    (setf
     (c_access packet 0) (encode-com-pac 87 3))
    (c_store2 packet 2 t-no)

;    (make-command-packet 87 :integer t-no :end)

    (setf receive (packet-send-receive-single packet))

    (list (get-packet-data receive 0)
	  (get-packet-data receive 1))))



;;; #089 yy-protocol-89
;;; reserved


;;; #090 yy-protocol-90
;;; $@%^%&%9%+!<%=%k$N@8@.(J
;;; (yy-protocol-90 width height parent x-hot y-hot bitmap) -> no
;;; args. width = $@%F%j%H%j$NI}(J
;;;	  height = $@%F%j%H%j$N9b$5(J
;;;	  parent = $@?F$K$J$k%F%j%H%j(J
;;;	  x-hot = $@%[%C%H%9%]%C%H$N0LCV(J X
;;;	  y-hot = $@%[%C%H%9%]%C%H$N0LCV(J y
;;;	  bitmap = $@%S%C%H%^%C%W$,IA2h$5$l$F$$$k%F%j%H%j$NHV9f(J
;;;		   0 $@$G$"$k$J$i$P!"2?$bIA2h$5$l$F$$$J$$%S%C%H%^%C%W$K$J$k!#(J
;;; val.  no = 0 $@$J$i$P<:GT!"$=$&$G$J$1$l$P%F%j%H%jHV9f(J
(defcommand yy-protocol-90 (width height parent x-hot y-hot bitmap)
  (let ((receive nil))
    (make-command-packet 90 :integer width :integer height :integer parent
			 :integer x-hot :integer y-hot :integer bitmap :end)

    (setf receive (packet-send-receive))

    (get-packet-data receive 0)))

;;; #091 yy-protocol-91
;;; $@%^%&%9%+!<%=%k%[%C%H%9%]%C%H$N0LCVJQ99(J
;;; (yy-protocol-91 no x-hot y-hot)
;;; args. no = $@%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(J
;;;	  x-hot = $@%[%C%H%9%]%C%H$N0LCV(J X
;;;	  y-hot = $@%[%C%H%9%]%C%H$N0LCV(J y
(defcommand yy-protocol-91 (no x-hot y-hot)
  (make-command-packet 91 :integer no :integer x-hot :integer y-hot :end)
  (packet-send))

;;; #092 yy-protocol-92
;;; $@%^%&%9%+!<%=%k$N%S%C%H%^%C%W$NJQ99(J
;;; (yy-protocol-92 no bitmap)
;;; args. no = $@%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(J
;;;	  bitmap = $@%S%C%H%^%C%W$,IA2h$5$l$F$$$k%F%j%H%j$NHV9f(J
;;;		   0 $@$G$"$k$J$i$P!"2?$bIA2h$5$l$F$$$J$$%S%C%H%^%C%W$K$J$k!#(J
(defcommand yy-protocol-92 (no bitmap)
  (make-command-packet 92 :integer no :integer bitmap :end)
  (packet-send))

;;; #093 yy-protocol-93
;;; $@%^%&%9%+!<%=%k$N0LCVJQ99(J
;;; (yy-protocol-93 no pno x y)
;;; args. no = $@%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(J
;;;	  pno = $@0LCV$r;XDj$9$k%F%j%H%j$NHV9f(J
;;;	  x = $@@_Dj0LCV(J X
;;;	  y = $@@_Dj0LCV(J Y
(defcommand yy-protocol-93 (no pno x y)
  (make-command-packet 93 :integer no :integer pno :integer x :integer y :end)
  (packet-send))

;;; #094 yy-protocol-94
;;; $@%^%&%9%+!<%=%k>C5n(J
;;; (yy-protocol-94 no) -> no
;;; args. no = $@%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(J
;;; val.  no = 0 $@$J$i$P<:GT!"$=$&$G$J$1$l$P%F%j%H%jHV9f(J
(defcommand yy-protocol-94 (no)
  (let ((receive nil))
    (make-command-packet 94 :integer no :end)
    (setf receive (packet-send-receive))
    (get-packet-data receive 0)))

;;; #095 yy-protocol-95
;;; $@%^%&%9%+!<%=%k$N>uBV3MF@(J
;;; (yy-protocol-95 no interrupt-event) -> interrupt-event
;;; args. no = $@%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(J
;;;	  interrupt-event = $@%^%&%9!"3d$j9~$_%-!<%$%Y%s%H(J
;;; val.  interrupt-event = $@%^%&%9!"3d$j9~$_%-!<$N>uBV(J
(defcommand yy-protocol-95 (no interrupt-event)
  (let ((receive nil))
    (make-command-packet 95 :integer no :end)
    (setf receive (packet-send-receive)
	  (slot-value interrupt-event 'territory-no) 
	  (get-packet-data receive 0)
	  (slot-value interrupt-event 'event-mask)
	  (get-packet-data receive 1)
	  (position-x (slot-value interrupt-event 'event-position))
	  (get-packet-data receive 2)
	  (position-y (slot-value interrupt-event 'event-position))
	  (get-packet-data receive 3))
    interrupt-event)
  )

;;; #096 yy-protocol-96
;;; $@8=>u$N%^%&%9%+!<%=%k$NJQ99(J
;;; (yy-protocol-96 no)
;;; args. no = $@%^%&%9%+!<%=%k$N%F%j%H%j$NHV9f(J
(defcommand yy-protocol-96 (no)
  (make-command-packet 96 :integer no :end)
  (packet-send))

;;; #097 yy-protocol-97
;;;	    :
;;; #254 yy-protocol-254
;;; reserved


;;; #255 yy-protocol-255
;;; $@#Y#Y(J  $@#o#n(J  $@#X$N=*N;(J
;;; (yy-protocol-255 no)
;;; args. no = $@%k!<%H%F%j%H%j$NHV9f(J
(defcommand yy-protocol-255 (no)
  (make-command-packet 255 :integer no :end)
  (packet-send))

;;; $@%$%Y%s%H%G!<%?$N%j%9%H(J
;;; $@%$%Y%s%H$N%G!<%?C10L$N%j%9%H(J
(defvar *event-data-list* nil)

;;; access-4-byte
;;; $@%Q%1%C%H$N0lC10L$G$"$k(J4$@%P%$%H$r<h$j=P$9!#(J
(defun access-4-byte (data no)
  (declare 
   #-CMU
   (inline ash aref * + logior)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((n (* no 4)))
    (logior 
	 (ash (aref data (+ 0 n)) 24)
	 (ash (aref data (+ 1 n)) 16)
	 (ash (aref data (+ 2 n))  8)
	 (ash (aref data (+ 3 n))  0)
	 )))


;;; packet-data-copy
;;; $@%G!<%?%3%T!<(J
#-CMU
(defun packet-data-copy (data form-p to-p length)
  (declare (inline aref +)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dotimes (no length)
		   (setf (aref data (+ to-p no))
				 (aref data (+ form-p no))))
  length)

#+CMU
(defun packet-data-copy (data form-p to-p length)
  (declare (inline aref +)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dotimes (no length)
		   (setf (deref data (+ to-p no))
				 (deref data (+ form-p no))))
  length)

  
;;; $@%$%Y%s%H%Q%1%C%H$N%j%9%H(J
(defvar *event-packet-struct* 
  (make-event-packet :data *receive* :current 0
					 :item '((100 0 0))
					 :number 0))

;;; read-from-socket-stream
;;; $@%=%1%C%H%9%H%j!<%`$+$i%$%Y%s%H%G!<%?$r(J
;;; $@<h$j9~$`!#(J
#+(or LUCID EXCL)
(defun read-from-socket-stream (byte)
  (declare (special *event-packet-struct* *receive* *max-receive-size*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((max-bytes (* *max-receive-size* 4))
	 (real-byte (c_read2 *receive* (- max-bytes byte) byte))
	 (command 0)
	 (length 0)
	 (total-length 0)
	 (packet-item nil)
	 (next-packet 0))
    (loop
	 ;;; $@%Q%1%C%HHV9f$H%Q%1%C%HD9$rF@$k(J
      (setf command (aref *receive* next-packet)
	    length
	    (logior 
	      (ash (aref *receive* (+ 1 next-packet)) 16)
	      (ash (aref *receive* (+ 2 next-packet)) 8)
	      (aref *receive* (+ 3 next-packet))
	      ))
      (push (list command length 
		  (aref *receive* (+ 7 next-packet))) packet-item)
      (incf total-length length)

	  ;; 1$@%Q%1%C%H$KB-$j$J$$$+D4$Y$k(J
      (if (and (< real-byte (* total-length 4))
	       (> *max-receive-size* real-byte))
		 ;;; *max-receive-size*$@$^$GFI$_9~$`(J
	  (incf real-byte
		(c_read2 *receive* (- max-bytes total-length) 
			 (* total-length 4))))
	  ;; $@=*N;H=CG(J
      (if (<= real-byte (* total-length 4))
	  (return))
	 
      (incf next-packet (* length 4))
      )
	;; $@%$%Y%s%H%Q%1%C%H9=B$BN$KCM$r%;%C%H$9$k(J
    (setf (event-packet-item *event-packet-struct*)
		  (reverse packet-item)
		  (event-packet-max-byte *event-packet-struct*)
		  real-byte
		  (event-packet-number *event-packet-struct*)
		  (length packet-item)
		  (event-packet-current *event-packet-struct*) 0)
    *event-packet-struct*))

#+CMU
(defun read-from-socket-stream (byte)
  (declare (special *event-packet-struct* *receive* *max-receive-size*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((max-bytes (* *max-receive-size* 4))
	 (real-byte (c_read2 *receive* (- max-bytes byte) byte))
	 (command 0)
	 (length 0)
	 (total-length 0)
	 (packet-item nil)
	 (next-packet 0))
    (loop
	 ;;; $@%Q%1%C%HHV9f$H%Q%1%C%HD9$rF@$k(J
      (setf command (deref *receive* next-packet)
			length
			(logior 
			 (ash (deref *receive* (+ 1 next-packet)) 16)
			 (ash (deref *receive* (+ 2 next-packet)) 8)
			 (deref *receive* (+ 3 next-packet))
	      ))
      (push (list command length 
		  (deref *receive* (+ 7 next-packet))) packet-item)
      (incf total-length length)

	  ;; 1$@%Q%1%C%H$KB-$j$J$$$+D4$Y$k(J
      (if (and (< real-byte (* total-length 4))
	       (> *max-receive-size* real-byte))
		 ;;; *max-receive-size*$@$^$GFI$_9~$`(J
	  (incf real-byte
		(c_read2 *receive* (- max-bytes total-length) 
				 (* total-length 4))))
	  ;; $@=*N;H=CG(J
      (if (<= real-byte (* total-length 4))
		  (return))
	 
      (incf next-packet (* length 4))
      )
	;; $@%$%Y%s%H%Q%1%C%H9=B$BN$KCM$r%;%C%H$9$k(J
    (setf (event-packet-item *event-packet-struct*)
		  (reverse packet-item)
		  (event-packet-max-byte *event-packet-struct*)
		  real-byte
		  (event-packet-number *event-packet-struct*)
		  (length packet-item)
		  (event-packet-current *event-packet-struct*) 0)
    *event-packet-struct*))

;;;;;;;(real-byte (c_read2 *receive* (- max-bytes byte) byte))
#+symbolics
(defun read-from-socket-stream (byte)
  (declare (special *event-packet-struct* *receive* *max-receive-size*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (unless (zerop byte)
    (error "read-from-socket-stream arg must be zero, But now arg is ~a" byte))
  (c_read2 *receive* 2 0)
  (let* ((command (aref *receive* 0))
	 (length (logior 
		   (ash (aref *receive* 1) 16)
		   (ash (aref *receive* 2) 8)
		   (aref *receive* 3)
		   )))
    (c_read2 *receive* (- length 2) 8)
	 ;;; $@%Q%1%C%HHV9f$H%Q%1%C%HD9$rF@$k(J
	;;; $@%$%Y%s%H%Q%1%C%H9=B$BN$KCM$r%;%C%H$9$k(J
    (setf (event-packet-item *event-packet-struct*)
	  (list (list command length (aref *receive* 7)))
	  (event-packet-max-byte *event-packet-struct*)
	  (* length 4)
	  (event-packet-number *event-packet-struct*) 1
	  (event-packet-current *event-packet-struct*) 0)
    *event-packet-struct*))

;;; integer-from-packet
;;; $@%Q%1%C%HCf$N(Jfield-no$@%U%#!<%k%IL\$K$"$k@0?t$r<h$j=P$9(J
;;; $@%Q%1%C%H$r0lEYFI$`$H$=$NFbMF$O!"J]>Z$5$l$J$$(J
(defun integer-from-packet (field-no event-packet)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((total-byte 0)
		(packet-number (event-packet-current event-packet))
		(packet-item (event-packet-item event-packet))
		(max-byte (event-packet-max-byte event-packet)))
	
    ;;; $@3:Ev$9$k%U%#!<%k%I$N%P%$%H?t$r5a$a$k(J
	(dotimes (no (- packet-number 1))
			 (incf total-byte (second (nth no packet-item))))

	(setf total-byte (* total-byte 4))

	(incf total-byte (* field-no 4))

    ;;; $@%G!<%?$,B-$i$J$$$+D4$Y$k(J
	;;; *receive*$@$K$O!"F~$j@Z$i$J$+$C$?(J
	;;; $@?7$7$/(J*receive*$@$K%Q%1%C%H$rF~$lD>$9(J
	(when (> (+ total-byte 4) max-byte)
		  ;;; $@%Q%1%C%H$N%3%T!<(J
		  (packet-data-copy (event-packet-data event-packet) 
							(decf total-byte (* field-no 4))
							0 (- max-byte total-byte))
		  (read-from-socket-stream (- max-byte total-byte))
		  (setf total-byte (* field-no 4)
				(event-packet-current event-packet) 0))

	(c_access (event-packet-data event-packet)
			  (floor (/ total-byte 4))))
   )

;;; string-from-packet
;;; $@%Q%1%C%HCf$N(Jfield-no$@%U%#!<%k%IL\$K$"$kJ8;zNs$r<h$j=P$9(J
#-CMU
(defun string-from-packet (field-no string-length event-packet)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *END-PACKET-TYPE* *ALONE-PACKET-TYPE*
					*max-receive-size*))
  (let* ((total-byte 0)
		 (packet-number (event-packet-current event-packet))
		 (packet-item (event-packet-item event-packet))
		 (max-byte (event-packet-max-byte event-packet))
		 (ret-string (make-string string-length))
		 (packet-max-byte (* *max-receive-size* 4))
		 (strign-4-len (floor (/ string-length 4))))
	
    ;;; $@3:Ev$9$k%U%#!<%k%I$N%P%$%H?t$r5a$a$k(J
	(dotimes (no (- packet-number 1))
			 (incf total-byte (second (nth no packet-item))))

	(setf total-byte (* total-byte 4))
	(incf total-byte (* field-no 4))

    ;;; $@%G!<%?$,B-$i$J$$$+D4$Y$k(J
	;;; *receive*$@$K$O!"F~$j@Z$i$J$+$C$?(J
	;;; $@?7$7$/(J*receive*$@$K%Q%1%C%H$rF~$lD>$9(J
	(when (> (+ total-byte strign-4-len) max-byte)
		  ;;; $@%Q%1%C%H$N%3%T!<(J
		  (packet-data-copy (event-packet-data event-packet) 
							(decf total-byte (* field-no 4))
							0 (- max-byte total-byte))
		  (read-from-socket-stream (- max-byte total-byte))
		  (setf total-byte (* field-no 4)
				(event-packet-current event-packet) 0))

	(dotimes 
	 (no string-length)
	 ;; $@%Q%1%C%H$,#1$D0J>e$N$H$-(J
	 (when (> total-byte packet-max-byte)
		   (read-from-socket-stream 0)
		   (setf total-byte 8
				 (event-packet-current event-packet) 0))
	 
	 (setf (char ret-string no)
		   (code-char 
			(aref (event-packet-data event-packet)
				  total-byte)))
	 (incf total-byte 1))
	ret-string))

#+CMU
(defun string-from-packet (field-no string-length event-packet)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *END-PACKET-TYPE* *ALONE-PACKET-TYPE*
					*max-receive-size*))
  (let* ((total-byte 0)
		 (packet-number (event-packet-current event-packet))
		 (packet-item (event-packet-item event-packet))
		 (max-byte (event-packet-max-byte event-packet))
		 (ret-string (make-string string-length))
		 (packet-max-byte (* *max-receive-size* 4))
		 (strign-4-len (floor (/ string-length 4))))
	
    ;;; $@3:Ev$9$k%U%#!<%k%I$N%P%$%H?t$r5a$a$k(J
	(dotimes (no (- packet-number 1))
			 (incf total-byte (second (nth no packet-item))))

	(setf total-byte (* total-byte 4))
	(incf total-byte (* field-no 4))

    ;;; $@%G!<%?$,B-$i$J$$$+D4$Y$k(J
	;;; *receive*$@$K$O!"F~$j@Z$i$J$+$C$?(J
	;;; $@?7$7$/(J*receive*$@$K%Q%1%C%H$rF~$lD>$9(J
	(when (> (+ total-byte strign-4-len) max-byte)
		  ;;; $@%Q%1%C%H$N%3%T!<(J
		  (packet-data-copy (event-packet-data event-packet) 
							(decf total-byte (* field-no 4))
							0 (- max-byte total-byte))
		  (read-from-socket-stream (- max-byte total-byte))
		  (setf total-byte (* field-no 4)
				(event-packet-current event-packet) 0))

	(dotimes 
	 (no string-length)
	 ;; $@%Q%1%C%H$,#1$D0J>e$N$H$-(J
	 (when (> total-byte packet-max-byte)
		   (read-from-socket-stream 0)
		   (setf total-byte 8
				 (event-packet-current event-packet) 0))
	 
	 (setf (char ret-string no)
		   (code-char 
			(deref (event-packet-data event-packet)
				   total-byte)))
	 (incf total-byte 1))
	ret-string))
			 

;;; packet-receive
;;; $@DLCNMQ(Jread
#+symbolics
(defun packet-receive ()
  (declare (special *END-PACKET-TYPE* *ALONE-PACKET-TYPE* *header* *receive*
		    *max-receive-size*)
	   (inline car = logand incf)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))

   (let ((type 0) (no 0) (len 0) (command 0)
	 (ret 1))

     (unless (zerop ret)
       ;;; $@%X%C%@!<$rFI$_$H$k(J
       (c_read2 *header2* 2)

        ;;; $@%Q%1%C%H?t$r5a$a$k(J
       (multiple-value-setq 
		(command len) 
		(decode-com-pac (c_access *header2* 0)))

       (when (or (= command 70)
		 (= command 73)
		 (= command 55)
		 (= command 86))
         ;;; $@%Q%1%C%H$NFI$_$H$j(J
	 (c_read2 (car *receive*) (- len 2))

	 (loop
	   (if (or (= (logand (setf type (c_access *header2* 1))  3)
		      *END-PACKET-TYPE*)
		   (= (logand type 3) *ALONE-PACKET-TYPE*))
	       (return))
      
	   (incf no)
	
           ;;; $@<!$N%j%9%H$,$"$k$+D4$Y$k(J
	   (if (null (nth no *receive*))
	       (nconc *receive* (list (make-packet *max-receive-size*))))
	   
            ;;; $@%X%C%@!<$rFI$_$H$k(J
	   (c_read2 *header2* 2)
	   
             ;;; $@%Q%1%C%H?t$r5a$a$k(J
	   (setf len (logand #x00FFFFFF (c_access *header2* 0)))
     
             ;;; $@%Q%1%C%H$NFI$_$H$j(J
	   (c_read2 (nth no *receive*) (- len 2))
	   )
	 )
       )
	 command)
   )

