;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%&%#%s%I%&%9%H%j!<%`4XO"(J
;;; yy-stream.lisp
;;;
;;;  Copyright (C) 1989,1990 Aoyama Gakuin University CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $@%&%#%s%I%&%9%H%j!<%`5Z$S%S%C%H%^%C%W%9%H%j!<%`$NDj5A(J
;;; 2/27 1990 $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-2-17

;;; Change log
;;; Update get-new-position-add  6/24 T.kosaka
;;; Add icon class for window stream 7/4 T.kosaka
;;; Change for event handlng T.kosaka

(in-package :yy)

#+CMU
(declaim 
 (inline unixselection)
 (inline alamsetup))

;;; $@%&%#%s%I%&%9%H%j!<%`$NI=<(!?HsI=<((J
(defmethod (setf window-visible) (value (window window-stream))
  (setf (draw-piece-visible window) value))

;;; $@%&%#%s%I%&%9%H%j!<%`$NI=<(>uBV$N;2>H(J
(defmethod window-visible ((window window-stream))
  (draw-piece-visible window))


;;; $@%&%#%s%I%&%9%H%j!<%`$N@8@.(Jafter $@%a%=%C%I(J
;;; $@%&%#%s%I%&$N9=@.MWAG%$%s%9%?%s%9$,$"$l$P=i4|2=$9$k!#(J
(defmethod initialize-instance :after ((ob window-stream) &rest args
				       &key &allow-other-keys)
  #-CMU
  (declare (special *root-territory-no* *default-font*)
		   (function REDISPLAY-WINDOW (t) t)
		   (function set-window-component-size (T) T)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((border (make-instance 'window-border :parent-window ob))
	 (frame (if (find-list :window-frame args)
				(apply #'make-instance 
					   (append (list (find-list :window-frame args) 
									 :parent-window ob)
							   (find-list :frame-keyword args)))
			  (make-instance 'window-frame :parent-window ob)))
	 (region (window-region ob))
	 (parent (parent-window ob))
         (ptno (if parent (world-territory-no parent) *ROOT-TERRITORY-NO*))
	 (start-x (if parent (world-x-start parent) 0))
	 (start-y (if parent (world-y-start parent) 0))
	 (bottom (with-translate-coordinate-stream (region-bottom region)
						   (parent-window ob)))
	 (font (if (find-list :font args)
		   (find-list :font args)
		 *default-font*))
	 (old-b-window nil))

    ;;; $@2<C<$N@_Dj(J
    (unless (= bottom (region-bottom region))
	(setf bottom (- bottom (region-height region))))
	 	 
    ;;; $@%\!<%@!<$H%U%l!<%`$N@_Dj(J
    (setf (window-frame ob) frame ; (border-method ob) border
	  (territory ob)
	  (with-object-make-territory border
	     :parent ptno :visible nil :x (+ (region-left region) start-x)
	   	 :y (+ bottom start-y) :width (region-width region) 
		 :height (region-height region))
	  (frame-territory-no frame)
	  (with-object-make-territory frame
		 :width 10 :height 10
		 :fence T :parent (territory ob)))
#|
    ;;; $@%U%l!<%`$KBP$7$F%^%9%/$r@_Dj(J
    (yy-protocol-72 (frame-territory-no frame)
		    #b0001111111111111)
|#
    
    ;;; $@:BI8JQ49MQ%9%m%C%H$KCM$r@_Dj(J
    (setf (slot-value ob 'translate-coordinate)
      (if (eq (find-list :translate-coordinate args) :left-bottom)
	  (make-instance 'translate-coordinate-left-bottom)
	(make-instance 'translate-coordinate-left-top)))
	      
    ;;; $@%U%)%s%H$N@_Dj(J
    (setf (stream-font ob) font)

     ;;; $@3F9=@.MWAG(J
    (apply #'make-title-bar ob args)
    (apply #'make-horizontal-scroll-bar ob args)
    (apply #'make-vertical-scroll-bar ob args)
    (apply #'make-coordinate-area ob args)
    (apply #'make-default-icon ob args)
	 
    ;;; $@3F9=@.MWAG$NBg$-$5$N:F7W;;(J
    (set-window-component-size ob)

#|    
    ;;; $@%\!<%@$N%a%=%C%I$rDj5A(J
    (set-window-border-method ob 'window-pop-up
			      :event-mask *mouse-right-1*)
|#

    ;;; $@%G%U%)%k%H$N%\!<%@I}@_Dj(J
    (setf (slot-value ob 'real-border-belt) (border-belt ob))

    ;;; $@%G%U%)%k%H$N%o!<%k%I$NBg$-$5$r@_Dj(J
    (setf (world-height ob) (region-height frame)
		  (world-width ob) (region-width frame)
		  (world-height (window-vertical-scroll-bar ob))
		  (region-height frame)
		  (world-width (window-horizontal-scroll-bar ob))
		  (region-width frame)
		  (region-width ob) (region-width frame)
		  (region-height ob) (region-height frame))

	(if (window-horizontal-scroll-bar ob)
		(setf  (slot-value (window-horizontal-scroll-bar ob) 'frame-width)
			   (region-width frame)))
	
	(if (window-vertical-scroll-bar ob)
		(setf (slot-value (window-vertical-scroll-bar ob) 'frame-height)
	  		  (region-height frame)))

    ;;; $@?F;R7;Do4X78$N@_Dj(J
    (when parent
	(setf old-b-window (car (last (children-windows parent))))

	(if (children-windows parent)
	    (push ob (cdr (last (children-windows parent))))
	  (push ob (children-windows parent)))

	(if old-b-window
	    (setf (young-brother-window old-b-window)
		  ob)
	  )

	(setf (old-brother-window ob) old-b-window))

    ;;; $@%&%#%s%I%&$NI=<((J
    (redisplay-window ob)

    (setf (window-visible ob) (find-list :visible args))

        ;;; $@%+!<%=%k%]%8%7%g%s$N=i4|@_Dj(J
    (setf (stream-cursor-y-position ob)
	  (font-kanji-base-line (stream-font ob)))
))
    
;;; $@%?%$%H%k%P!<$N@8@.(J
(defun make-title-bar (window &rest args &key &allow-other-keys)
  #-CMU
  (declare (special *DEFAULT-FONT* *black-color* *mouse-right-1*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (find-list :title-bar args)
    (let* ((string  (find-list :title-bar-string args))
	   (font (find-list :title-bar-font args))
	   (color (find-list :title-bar-color args))
	   (ins (apply #'make-instance (find-list :title-bar args)
		 :parent-window window :object-parent window
		 :draw-piece-visible  (find-list :title-bar-visible args)
		 :right 10 :top 10
		 :title-bar-font (if font font *DEFAULT-FONT*)
		 :title-bar-string (if string string "")
		 :title-bar-color (if color color *black-color*)
		 args)))

	 	 ;;; $@%$%Y%s%H%a%=%C%I$N@_Dj(J		      
      (with-event-object (ins)
	 (setf (right-button-down-1-method ins) 'window-pop-up
	       (get 'window-pop-up 'single-process) t
	       (left-button-down-1-method ins) 'expose-my-self
	       (get 'expose-my-sel 'single-process) t
	       (middle-button-down-1-method ins) 'bury-my-self
	       (get 'bury-my-sel 'single-process) t
	       (mouse-cursor-in-method ins) 'message-my-self
	       (get 'message-my-self 'single-process) t
	       (slot-value ins 'event-mask) 
	       (logior *mouse-right-1* *mouse-middle-1*  *mouse-left-1*
		       *mouse-in*)))

      (setf (slot-value window 'title-bar) ins))
    ))


;;; $@%?%$%H%k%P!<$N:8%\%?%s$G!"(Jexpose $@$9$k(J
(defun expose-my-self (ob state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-slots
   (parent-window) ob
   (expose parent-window)))

;;; $@%?%$%H%k%P!<$NCf%\%?%s$G!"(Jbury $@$9$k(J
(defun bury-my-self (ob state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-slots
   (parent-window) ob
   (bury parent-window)))

		
;;; $@2#%9%/%m!<%k%P!<(J
(defun make-horizontal-scroll-bar (window &rest args &key &allow-other-keys)
  #-CMU
  (declare (special *black-color* *mouse-move* *mouse-button-down-1*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (find-list :horizontal-scroll-bar args)
	(let* ((color (find-list :scroll-bar-color args))
	       (ins (apply #'make-instance 
			   (find-list :horizontal-scroll-bar args)
			  :parent-window window  :object-parent window
			  :right 10 :top 10
			  :draw-piece-visible
			  (find-list :horizontal-scroll-visible args)
			  :scroll-bar-color (if color	color *black-color*)
			  args)))
	  (with-event-object (ins)			     	
	      (setf (slot-value window 'horizontal-scroll-bar) ins
		    (left-button-down-1-method ins)
		    'horizontal-scroll-left-internal
		    (middle-button-down-1-method ins)
		    'horizontal-scroll-middle-internal
		    (right-button-down-1-method ins)
		    'horizontal-scroll-right-internal
		    (move-mouse-cursor-method ins)
		    'horizontal-scroll-move-internal
		    (slot-value ins 'event-mask)
		    (logior *mouse-button-down-1* *mouse-move*)))
	  )))
				

;;; $@=D%9%/%m!<%k%P!<(J
(defun make-vertical-scroll-bar (window &rest args &key &allow-other-keys)
  #-CMU
  (declare (special *black-color* *mouse-move* *mouse-button-down-1*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (find-list :vertical-scroll-bar args)
	(let* ((color (find-list :scroll-bar-color args))
	       (coordinate (find-list :translate-coordinate args))
	       (ins (apply #'make-instance (find-list :vertical-scroll-bar args)
			  :parent-window window :object-parent window
			  :draw-piece-visible
			  (find-list :vertical-scroll-visible args)
			  :right 10 :top 10
			  :coordinate (if coordinate  coordinate :left-top)
			  :scroll-bar-color (if color color *black-color*)
			  args)))
	  (with-event-object (ins)			     	
	      (setf (slot-value window 'vertical-scroll-bar) ins
		    (left-button-down-1-method ins) 
		    'vertical-scroll-left-internal
		    (middle-button-down-1-method ins)
		    'vertical-scroll-middle-internal
		    (right-button-down-1-method ins) 
		    'vertical-scroll-right-internal
		    (move-mouse-cursor-method ins) 
		    'vertical-scroll-move-internal
		    (slot-value ins 'event-mask)
		    (logior *mouse-button-down-1* *mouse-move*)))
	  )))

;;; $@:BI87OI=<(%(%j%"(J
(defun make-coordinate-area (window &rest args &key &allow-other-keys)
  #-CMU
  (declare (special *black-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (find-list :COORDINATE-AREA args)
    (let* ((color (find-list :coordinate-area-color args))
	   (coordinate (find-list :translate-coordinate args)))
      (setf (slot-value window 'coordinate-area)
	(apply #'make-instance (find-list :COORDINATE-AREA args)
	       :parent-window window :object-parent window
	       :draw-piece-visible
	       (find-list :coordinate-area-visible args)
	       :right 10 :top 10
	       :coordinate (if coordinate coordinate :left-top)
	       :coordinate-area-color
	       (if color color	*black-color*)
	       args))
      )))

;;; $@%"%$%3%s$N@8@.(J
(defun make-default-icon (window &rest args &key &allow-other-keys)
  #-CMU
  (declare (special *DEFAULT-FONT* *black-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (find-list :window-icon args)
      (let* ((region (window-region window))
			 (ins (make-instance (find-list :window-icon args)
								 :parent-window window :object-parent window
								 :right 10 :top 10
								 :draw-piece-visible  nil
								 :p-left (region-left region)
								 :p-bottom (region-bottom region)
								 :p-width (region-width region)
								 :p-height (region-height region))))
	 	   ;;; $@%$%Y%s%H%a%=%C%I$N@_Dj(J		      
		(with-event-object
		 (ins)
		 (setf (right-button-down-1-method ins) 'icon-pop-up
			   (slot-value window 'window-icon) ins))
		ins)
    (let* ((region (window-region window))
		   (ins (make-instance 'icon
							   :parent-window window :object-parent window
							   :draw-piece-visible  nil
							   :right 10 :top 10
							   :p-left (region-left region)
							   :p-bottom (region-bottom region)
							   :p-width (region-width region)
							   :p-height (region-height region))))
      (with-event-object 
	   (ins)
	   (setf (right-button-down-1-method ins) 'icon-pop-up
			 (slot-value window 'window-icon) ins))
      ins)))


;;; $@%Z!<%8%b!<%I$N%&%#%s%I%&$N=i4|2=(J
(defmethod initialize-instance :after ((ob page-window-stream) &rest args
				       &key &allow-other-keys)
  #-CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((output-direction (find-list :output-direction args))
	 (coordinate (find-list :translate-coordinate args))
	 (font (find-list :text-font args))
	 (line-feed (find-list :line-feed args))
	 (frame (window-frame ob))
	 (width (region-width frame))
	 (height (region-height frame))
	 (tno (with-object-make-territory ob
		  :parent (frame-territory-no frame)
		  :width width
		  :height height
		  :window-mode nil)))

	 (yy-protocol-80 tno
			 (font-no font)
			 line-feed
			 (if (eq output-direction :horizontal)  0  1)
			 (if (eq coordinate :left-top) 0 1)
			 0 0)

	 (setf (world-territory-no ob) tno)))


;;; $@%Z!<%8%&%#%s%I%&%9%H%j!<%`$NI=<(%a%=%C%I(J
(defmethod print-object ((window page-window-stream) stream)
  (format stream "\#<Window Stream Page :Size ~a>" 
	  (window-region window)))


;;; $@%S%e!<%]!<%H%&%#%s%I%&$N=i4|2=(J
(defmethod initialize-instance :after ((ob viewport-window-stream) &rest args
				       &key &allow-other-keys)
#-(or :PCL CMU)
  (declare (ignore args)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (let* ((frame (window-frame ob))
	 (width (region-width frame))
	 (height (region-height frame))
	 (tno (with-object-make-territory ob
			:parent (frame-territory-no frame)
			:width width
			:height height)))
    
    (setf (world-territory-no ob) tno)))


;;; $@%S%e!<%]!<%H%&%#%s%I%&%9%H%j!<%`$NI=<(%a%=%C%I(J
(defmethod print-object ((window viewport-window-stream) stream)
  (format stream "\#<Window Stream Viewport :Size ~a>" 
	  (window-region window)))

;;; $@%U%l!<%`%5%$%:$r7W;;(J
;;; calcu-window-frame window
;;; ARG.
;;;         window   =  $@%&%#%s%I%&%9%H%j!<%`(J
;;; RET.
;;;         (vaslues width height)
(defmethod calcu-window-frame ((window window-stream))
  #-CMU
  (declare (special *SCROLL-BAR-BELT*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((width (region-width (window-region window)))
	 (height (region-height (window-region window)))
	 (belt (real-border-belt window))
	 (f-l belt)
	 (f-b belt)
	 (f-r (- width belt))
	 (f-t (- height belt)))

    (if (window-title-bar window)
	(when (draw-piece-visible (window-title-bar window))
	  ;;; $@%?%$%H%k%P!<$,$"$k(J
	  (let ((region (window-title-bar window)))
	    (setf f-b (font-kanji-height
		       (slot-value region 'title-font))))
	  ))

    (if (window-coordinate-area window)
	(when (draw-piece-visible (window-coordinate-area window))
	  ;;; $@:BI87OI=<(%(%j%"$,$"$k(J
	  (setf  f-t (- height belt *SCROLL-BAR-BELT*)
		 f-l (+ belt *SCROLL-BAR-BELT*))
	  ))
    (if (window-horizontal-scroll-bar window)
	(when (draw-piece-visible (window-horizontal-scroll-bar window))
	  ;;; $@2#%9%/%m!<%k%P!<$,$"$k(J
	  (setf f-t (- height belt *SCROLL-BAR-BELT*))))

    (if (window-vertical-scroll-bar window)
	;;; $@=D%9%/%m!<%k%P!<$,$"$k(J
	(when (draw-piece-visible (window-vertical-scroll-bar window))
	  (setf f-l (+ belt *SCROLL-BAR-BELT*))))

    (values (- f-r f-l) (- f-t  f-b))
  ))

;;; parent-stream
;;;
(defmethod parent-stream ((window window-stream))
    window)

;;; parent-stream
(defmethod parent-stream ((object drawable-piece))
  (parent-stream (object-parent object)))

;;; $@%&%#%s%I%&$N%^%&%9%+!<%=%k$NJQ99(J
(defmethod (setf window-mouse-cursor) :around (mouse (window window-stream))
  #-CMU
  (declare (function mouse-cursorp (T) T)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (mouse-cursorp mouse)
      (call-next-method)
    (error "The argument ~a is not a mouse cursor" mouse)))


;;; $@%o!<%k%I$N>l9g(J
(defmethod xy-from-object ((window window-stream) x y)
  (values (- x (world-x-start window))
	   (translate-coordinate-y (slot-value window 'translate-coordinate)
		(- y (world-y-start window)) (world-height window))))


;;; $@B>$N%*%V%8%'%/%H$N>l9g(J
(defmethod xy-from-object ((ob T) x y)
   (values x y))

;;; $@F~NO%;%l%/%7%g%s%F!<%V%k(J
(defvar *selection-table* nil)
(defvar *force-selection-table* nil)
(defvar *cursor-display-table* (make-array 64. :fill-pointer 0 :adjustable t))

;;; $@F~NO%;%l%/%7%g%s%a%=%C%I(J
(defmethod select-window ((window window-stream))
  (if (null *force-selection-table*)
      (progn (select-window-exec window)
	     (setf *selection-table* window))
    )
  window)

(defmethod select-window ((window NULL))
)

;;; $@6/@)F~NO%;%l%/%7%g%s%a%=%C%I(J
(defmethod force-select  ((window window-stream))
  (setf *force-selection-table* window)
  (setf *selection-table* window)
  (select-window-exec window)
  window)

;;; select-page 
(defmethod select-window-exec ((stream window-stream))
	 (yy-protocol-71 (world-territory-no stream)))

;;; $@JT=8J8;zNs$NI=<(%*%Z%l!<%7%g%s$N7hDj(J
(defmethod get-text-edit-operation ((back-color color) (text-color color))
  #-CMU
  (declare (special *BLACK-COLOR* *WHITE-COLOR*)
	 (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (and (or (eq back-color *BLACK-COLOR*)
	       (eq back-color *WHITE-COLOR*))
	   (or (eq text-color *BLACK-COLOR*)
	       (eq text-color *WHITE-COLOR*)))
      (if (zerop (color-no *BLACK-COLOR*))
	  *GEQIV*
	*GXOR*)
    *GXOR*))
  

;;; $@%&%#%s%I%&$N%\!<%@!<$N%\%?%s%a%=%C%I$r@_Dj(J
;;; set-window-border-method 
;;;          window $@%&%#%s%I%&%9%H%j!<%`$N%$%s%9%?%s%9(J
;;;          method $@5/F0$9$k%a%=%C%IL>(J
;;;          &key (event-mask  *mouse-left-1*) $@%^%&%9%9%F!<%H$N%Q%i%a!<%?(J
(defmethod set-window-border-method ((window window-stream)
					method 
					&key (event-mask *mouse-left-1*))
  #-CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((event-method (window-border window))
	 (s-name (event-method-slot-name event-method event-mask)))

    (if s-name
	(progn 
           ;;; $@%9%m%C%H$K%a%=%C%I$r@_Dj(J
	  (setf (slot-value event-method s-name)  method
		(event-mask event-method) 
		(if method 
		    (logior event-mask (event-mask event-method))
		  (logand (event-mask event-method))))
		  
	  ;;; $@%^%9%/$N@_Dj(J
	  (yy-protocol-72 (territory window)
			  (event-mask event-method))
	  method)
    (error "The event-mask ~a is not a avilable." event-mask))
    ))


;;; $@%&%#%s%I%&$N%\%?%s%a%=%C%I$r@_Dj(J
;;; set-window-method 
;;;          window $@%&%#%s%I%&%9%H%j!<%`$N%$%s%9%?%s%9(J
;;;          method $@5/F0$9$k%a%=%C%IL>(J
;;;          &key (event-mask  *mouse-left-1*) $@%^%&%9%9%F!<%H$N%Q%i%a!<%?(J
(defmethod set-window-method ((window window-stream)
					method 
					&key (event-mask *mouse-left-1*))
  #-CMU
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((event-method window)
		 (s-name (event-method-slot-name event-method event-mask)))

    (if s-name
	(progn 
           ;;; $@%9%m%C%H$K%a%=%C%I$r@_Dj(J
	  (setf (slot-value event-method s-name) method
		(event-mask event-method) 
		(if method 
		    (logior event-mask (event-mask event-method))
		  (logand event-mask (event-mask event-method))))
    
          ;;; $@%^%9%/$N@_Dj(J
	  (yy-protocol-72 (world-territory-no window)
		    (event-mask event-method))
	  method)
      (error "The event-mask ~a is not a avilable." event-mask)))
  )

;;; $@%^%&%9%+!<%=%k$N>uBV3MF@(J
(defun mouse-status (&optional (mouse-state *SYSTEM-MOUSE-STATE*))
  #-CMU
  (declare (special *SYSTEM-MOUSE-CURSOR* *SYSTEM-INTERRUPT-EVENT*
		    *ROOT-WINDOW*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
#|
  (let ((m-t-no (if *SYSTEM-MOUSE-CURSOR*
                    (slot-value *SYSTEM-MOUSE-CURSOR* 'mouse-territory-no)
                  0)))
|#

    (yy-protocol-95 0 ;m-t-no 
					*SYSTEM-INTERRUPT-EVENT*)

     ;;; $@%^%&%9>uBV$N%*%V%8%'%/%H$r5a$a$k(J
    (let ((object (get-lisp-object (territory-no *SYSTEM-INTERRUPT-EVENT*)))
	  (x 0) (y 0))
#+:YY2.0
      (multiple-value-setq (x y)
	  (xy-from-object object
		       (position-x (event-position *SYSTEM-INTERRUPT-EVENT*))
			(position-y (event-position *SYSTEM-INTERRUPT-EVENT*))
			  ))
#-:YY2.0
      (multiple-value-setq (x y) ;;; SERVER BUG 
	   (values  (position-x (event-position *SYSTEM-INTERRUPT-EVENT*))
		    (position-y (event-position *SYSTEM-INTERRUPT-EVENT*))))
#-:YY2.0
      (setf object *ROOT-WINDOW*)

      ;;; mouse-state $@$NFbMF$rJQ99$9$k(J
      (setf (mouse-state-x-position mouse-state) x
	    (mouse-state-y-position mouse-state) y
	    (mouse-state-button-state mouse-state)
	    (event-mask *SYSTEM-INTERRUPT-EVENT*)
	    (mouse-state-object mouse-state)
	    object))
  mouse-state)

;;; $@%$%Y%s%H$N%0%m!<%P%kCM(J
(defvar *keybord-event1* (make-instance 'yy-keybord-event))
(defvar *interrupt-event1* (make-instance 'yy-interrupt-event))
(defvar *resize-event1* (make-instance 'yy-resize-event))

;;; $@%^%&%9%a%=%C%I$N<B9T4X?t(J
(defun execution-mause-method (event)
  #-CMU
  (declare (inline not zerop null eq make-mouse-state)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (let* ((instance (get-lisp-object (car event)))
		 (method-mixin instance)
		 (method (get-available-method method-mixin (second event)))
		 (move-method-flg (logand *mouse-move* (second event))))
	
    (when (and method-mixin method)
      ;;; $@%a%=%C%I$N5/F0(J
      (if (or (eq method 'vertical-scroll-left-internal)
	      (eq method 'vertical-scroll-middle-internal)
	      (eq method 'vertical-scroll-right-internal)
	      (eq method 'vertical-scroll-move-internal)
	      (eq method 'horizontal-scroll-left-internal)
	      (eq method 'horizontal-scroll-middle-internal)
	      (eq method 'horizontal-scroll-right-internal)
	      (eq method 'horizontal-scroll-move-internal))

		  (funcall method (parent-window instance)
				   (third event) (fourth event)
				   (second event))
		  #|
		  #+CMU
		  (progn
			(set-without-interrupts-flg)
			 (funcall method (parent-window instance)
					 (third event) (fourth event)
					 (second event))
			 (pop-without-interrupts-flg)
			 )
		  |#
        ;;; $@EPO?$5$l$?%a%=%C%I$r5a$a$k(J
	(let ((m-state (make-mouse-state 
			:mask (second event)
			:any-object instance)))
		      
	  (multiple-value-bind (x y)
	      (xy-from-object instance 
			      (third event)
			      (fourth event))
	    (setf (mouse-state-x-position m-state) x
			  (mouse-state-y-position m-state) y))
	  #-CMU
	  (if (zerop move-method-flg)
	      (if (null (get method 'single-process))
			  (run-process method instance m-state)
			(funcall method instance m-state))
        (progn 
	       ;;; move $@$N%$%Y%s%H$OF14|%b!<%I$G2TF/$9$k(J
	      (funcall method instance m-state)
		  (yy-protocol-76)
	      )
	    )
	  #+CMU
	  (cond
	   ((zerop move-method-flg)
		(let ((mask (UNIX:UNIX-SIGSETMASK 0)))
		  (pop-without-interrupts-flg)
		  (unwind-protect
			  (funcall method instance m-state)
			(progn
			  (set-without-interrupts-flg)
			  (UNIX:UNIX-SIGSETMASK mask)))))
	   (t
	       ;;; move $@$N%$%Y%s%H$OF14|%b!<%I$G2TF/$9$k(J
		(unwind-protect
		   (funcall method instance m-state)
		  (yy-protocol-76))
		))
	   ))
	  )))

;;; $@F~NO%A%'%C%/(J
(defun input-ok (stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (> (length (slot-value stream 'input-string)) 0)
      T
    nil))

;;; $@%-!<%\!<%I%$%Y%s%H(J
(defun yy-event-method2 (event)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;;; $@%-!<%\!<%IF~NO(J
  (let ((instance (get-lisp-object (car event))))
	(with-slots (input-string) instance
				(setf input-string (nconc 
									input-string
									(coerce (second event) 'list))))

	(let ((proc (car (read-event-proc instance))))
	  #+CMU
	  (push t *with-inhibit*)
	  (when proc
			(if (apply (car proc) (cdr proc))
				(setf (end-of-read instance) T)))
	  #+CMU
	  (pop *with-inhibit*)
	  )))
  

;;; $@J8;zNs$r(Jinput-stream $@$KA^F~(J
(defmethod set-string-to-stream ((stream fundamental-character-input-stream)
				 (string string))
  (with-slots (input-string) stream
     (setf input-string (nconc input-string 
			       (coerce string 'list)))))


;;; $@%F%j%H%j!<$N%j%5%$%:(J
(defun yy-event-method3 (event)
  #-CMU
  (declare (function set-world-region-internal (T T) T)
	   (ignore mask))
  (let ((instance (get-lisp-object (car event))))
    ;;; $@%o!<%k%I$N%j%5%$%:(J
    (set-world-region-internal (make-region :left (second event)
					    :bottom (third event)
					    :width (fourth event)
					    :height (fifth event)) instance))
  nil)

;;;
;;; $@%5!<%P$+$i%Q%1%C%H$,Mh$?$i%Q%1%C%H$rAHN)$F$k(J
;;; $@DLCN(J
#-CMU
(defun yy-tuuchi (default-event)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (special *event-packet* *event-packet-struct*
		    *event-loop-process* *event-method-stream*))
  (let ((call-function nil)
	(event-packet default-event)
	(error-flg nil)
	(curren-p (current-process))
	(arg-list nil))
	;;;$@L58B$N%k!<%W(J
	(loop 
	 ;; $@<+J,$,=*N;$7$F$bNI$$$+D4$Y$k(J
	 (if (and *event-loop-process* 
		  (not (eq *event-loop-process*
			   curren-p)))
	     (return))

	 ;;$@%Q%1%C%H$rFI$`(J
	 (when (null event-packet)
	       #+ EXCL 
	       (when (> (unix_selection 5) 0)
		     (setf event-packet (read-from-socket-stream 0))
		     (unless event-packet
			     (setf event-packet *event-packet-struct*))
		     )

	       #+(OR :LUCID :SYMBOLICS)
	       (setf event-packet (read-from-socket-stream 0))
	       )

	   ;;; $@%$%Y%s%H%Q%1%C%H$NJ]B8(J
	   (setf *event-packet* event-packet)

	   ;; event-packet $@$,$"$k$+H=CG$9$k(J 
	   (when event-packet
		 (case 
		  (car (nth (event-packet-current event-packet)
			    (event-packet-item event-packet)))
		  ;; $@J8;zNs$NF~NO(J
		  (70
		   ;; $@J8;zNsA`:n4X?t$N8F$S$@$7(J
		   (setf call-function #'yy-event-method2
			 arg-list 
			 ;; $@%F%j%H%j!<HV9f(J
			 (list (integer-from-packet 2 event-packet)
			       ;; $@J8;zNs(J
			       (string-from-packet 
				4 (integer-from-packet 3 event-packet)
				event-packet))
			 ))
		  ;; $@%^%&%9!"3d$j9~$_%-!<%$%Y%s%H(J
		  (73
		   (setf  
		    call-function #'execution-mause-method
		    arg-list
		    (list 
		     (integer-from-packet 2 event-packet) ; $@%F%j%H%jHV9f(J
		     (integer-from-packet 3 event-packet) ;;; $@%^%9%/(J
		     (real-integer (integer-from-packet 4 event-packet))
		     (real-integer (integer-from-packet 5 event-packet))))
		   )
		  ;; $@%"%K%a!<%7%g%s$NDLCN(J
		  (55
		   (setf call-function #'yy-event-method4
			 arg-list 
			 (list (integer-from-packet 2 event-packet)
				   (integer-from-packet 3 event-packet)
			       (integer-from-packet 4 event-packet)))
		   
		   )
		  ;; $@%F%j%H%j!<$NBg$-$5JQ99%$%Y%s%H(J  
		  (86
		   (setf 
		    call-function #'yy-event-method3
		    arg-list
		    (list (integer-from-packet 2 event-packet)
			  (real-integer (integer-from-packet 3 event-packet))
			  (real-integer (integer-from-packet 4 event-packet))
			  (real-integer (integer-from-packet 5 event-packet))
			  (real-integer (integer-from-packet 6 event-packet))
			  ))
		   )
		  (t 
		   (yy-protocol-76)
		   (setf event-packet nil))
		  )
		 ;; $@4X?t$N8F$S$@$7(J
		 (when call-function
		   (incf (event-packet-current event-packet))
		   (unwind-protect
		       (progn
			 (setf error-flg T)
			 #-Symbolics
			 (funcall call-function arg-list)
			 #+Symbolics
			 (scl:condition-case (e)
			      (funcall call-function arg-list)
			    (sys:bad-connection-state  (error e))
			    ((sys:abort error)
			     ;;(zl:dbg)
			     ))
			 (setf error-flg nil))
		     (when error-flg
		       #+Symbolics
		       (incf (event-packet-current event-packet))
			 (yy-tuuchi event-packet)))
		   (setf call-function nil)
		       
		   (if (= (event-packet-current event-packet)
			  (event-packet-number event-packet))
		       (setf event-packet nil))
		       
		   )
		 )
	   )
	))

;;;
;;; $@%5!<%P$+$i%Q%1%C%H$,Mh$?$i%Q%1%C%H$rAHN)$F$k(J
;;; $@DLCN(J
;;; CMU$@MQ$NDLCN=hM}4X?t(J
#+CMU
(defun yy-tuuchi (signal code scp)
  (declare (ignore signal code scp)
		   (special *alam-mask* *with-inhibit*))
  (let ((call-function nil)
		(event-packet nil)
		(arg-list nil))
	;;; $@%^%9%/$N@_Dj(J
	(UNIX:UNIX-SIGBLOCK *alam-mask*)
	(when 
	 (> (unix_selection 0) 0)
	 (setf event-packet (read-from-socket-stream 0))
	 (set-without-interrupts-flg)
	 (case 
	  (car (event-packet-item event-packet))
	  ;; $@J8;zNs$NF~NO(J
	  (70
	   ;; $@J8;zNsA`:n4X?t$N8F$S$@$7(J
	   (setf call-function #'yy-event-method2
			 arg-list 
			 ;; $@%F%j%H%j!<HV9f(J
			 (list (integer-from-packet 2 event-packet)
				   ;; $@J8;zNs(J
				   (string-from-packet 
					4 (integer-from-packet 3 event-packet)
					event-packet))
			 ))
	  ;; $@%^%&%9!"3d$j9~$_%-!<%$%Y%s%H(J
	  (73
	   (setf  call-function #'execution-mause-method
			  arg-list
			  (list 
			   (integer-from-packet 2 event-packet) ; $@%F%j%H%jHV9f(J
			   (integer-from-packet 3 event-packet) 	;;; $@%^%9%/(J
			   (real-integer (integer-from-packet 4 event-packet))
			   (real-integer (integer-from-packet 5 event-packet))))
	   )
	  ;; $@%"%K%a!<%7%g%s$NDLCN(J
	  (55
	   (setf call-function #'yy-event-method4
			 arg-list 
			 (list (integer-from-packet 2 event-packet)
				   (integer-from-packet 3 event-packet)
				   (integer-from-packet 4 event-packet)))
	   )
		;; $@%F%j%H%j!<$NBg$-$5JQ99%$%Y%s%H(J
	  (86
	   (setf call-function #'yy-event-method3
			 arg-list
			 (list (integer-from-packet 2 event-packet)
				   (real-integer (integer-from-packet 3 event-packet))
				   (real-integer (integer-from-packet 4 event-packet))
				   (real-integer (integer-from-packet 5 event-packet))
				   (real-integer (integer-from-packet 6 event-packet))
					 ))
	   )
	  (t
	   ))
	 )
	(when (and (eq call-function #'execution-mause-method)
			   (zerop (logand (second arg-list) *mouse-move*)))
		  (alam_setup 1))
	;; $@4X?t$N8F$S$@$7(J
	 (if call-function
		 (unwind-protect
			 (funcall call-function arg-list)
		   (progn
			 (alam_setup 1)
			 (pop-without-interrupts-flg)
			 (UNIX:UNIX-SIGSETMASK 0)))
	  (progn
		(alam_setup 1)
		(pop-without-interrupts-flg)
		(UNIX:UNIX-SIGSETMASK 0))
	)
  ))

	  

;;; start-event-loop
;;; $@%$%Y%s%H%k!<%W%W%m%;%9$r5/F0$9$k(J
;;; $@%$%Y%s%H%k!<%W$r5/F0$9$k$H$-$K$O!"I,$:$3$N4X?t$rMxMQ$9$k(J
#-CMU
(defun start-event-loop ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *event-loop-process*))
  (setf *event-loop-process*
		(run-process 'yy-tuuchi nil)))

#+CMU
(defun start-event-loop ()
  (setf *with-inhibit* nil)
  (UNIX:UNIX-SIGSETMASK 0)
  (enable-interrupt 14 #'yy-tuuchi)
  (alam_setup 1))

;;; END




