;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; yy-clolor.lisp
;;; 
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;             All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/1/11 by t.kosaka

;;; $@%+%i!<4pK\%/%i%9$NDj5A5Z$S4XO"%a%=%C%I(J


(in-package :yy)

(defvar *top-color-table* nil)
(defvar *near-val* 15)

;;; $@%+%i!<8!:w$N$?$a$N9=B$BN(J
(defstruct color-table
  color                ;;; $@%+%i!<%$%s%9%?%s%9(J
  key                  ;;; $@80(J
  big
  small)

;;; color $@%$%s%9%?%s%9I=<(%a%=%C%I(J
(defmethod print-object ((color color) stream)
;;;$@?'$N%$%s%9%?%s%9$rI=<((J
  (format stream "\#<Color RGB [~a ~a ~a]>"
          (red color) (green color) (blue color)))

;;; color $@@8@.4X?t(J
;;; make-x-color &key (red 0) (green 0) (blue 0)
;;; ARG.  red   =  RGB$@$G$N@V(J 0 $@!A(J 256
;;;       blue  =  RGB$@$G$N@D(J 0 $@!A(J 256
;;;       green =  RGB$@$G$NNP(J 0 $@!A(J 256
;;; X$@$N%+%i!<(JRGB$@$NCM$HF1$8(J
;;; RET.
;;;       color instance or NIL
(defun make-x-color (&key (red 0) (green 0) (blue 0))
  (let ((new-red (if (= red 0)
					 0
				   (- (ash red 8) 1)))
		(new-green (if (= green 0)
					   0
					 (- (ash green 8) 1)))
		(new-blue (if (= blue 0)
					  0
					(- (ash blue 8) 1))))
				   
  (make-color :red new-red :green new-green :blue new-blue)))


;;; color $@@8@.4X?t(J
;;; make-color &key (red 0) (green 0) (blue 0)
;;; ARG.  red   =  RGB$@$G$N@V(J 
;;;       blue  =  RGB$@$G$N@D(J 
;;;       green =  RGB$@$G$NNP(J 
;;; RET.
;;;       color instance or NIL
(defun make-color (&key (red 0) (green 0) (blue 0))
;;; $@%G%U%)%k%H$N%+%i!<$O!"(Jred 0 green 0 blue 0$@$G!"9u$K$J$k(J
  (declare (special *all-colors*)
		   #-CMU
		   (inline < car push)
		   )
  (let ((no (yy-protocol-45 red green blue)))
    (if (< no 0)
	nil
	(let ((color nil))
	  (if (setf color (code-color no))
		  color
		(progn
		  (setf color (make-instance  'color :red-no red :color-no no
						:green-no green :blue-no blue))
		  (set-tree-color color)
		  (push color *all-colors*)
		  color)
		)))))

;;; $@%+%i!<$N%-!<%o!<%I$+$i%+%i!<HV9f$r5a$a$k(J
;;; $@;XDj$7$??'%-!<%o!<%I$,$J$$$H(J0$@$rJV$9(J
(defmethod color-no ((ob symbol))
  (if (keywordp ob)
	  (let ((no (get ob 'color-value)))
		(if no
			no
		  0))
	0))

(defmethod (setf color-no) (new-v (ob symbol))
  (if (keywordp ob)
	  (setf (get ob 'color-value) new-v))
	new-v)
  

;;; $@%+%i!<$NLZ9=B$$r:n$k(J
(defun set-tree-color (color)
  (declare (special *top-color-tabel*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((top *top-color-tabel*)
	(no (logxor (red color) (green color) (blue color))))
    (if top
	(loop
	  (unless top
	    (return))
	  (cond 
	   ((>= no (color-table-key top))
	    (if (null (color-table-big top))
		(return (setf (color-table-big top)
			  (make-color-table :color color
					    :key no)))
	      (setf top (color-table-big top))))
	   ((< no (color-table-key top))
	    (if (null (color-table-small top))
		(return (setf (color-table-small top)
			  (make-color-table :color color
                                            :key no)))
	    (setf top (color-table-small top))))
	  ))
      (setf *top-color-tabel*
	(make-color-table :color color :key no))))
  )

;;;$@%+%i!<LZ9=B$$+$i$N2rJ|(J
(defun delete-tree-color (color)
  (declare (special *top-color-tabel*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((top *top-color-tabel*)
	(no (logxor (red color) (green color) (blue color))))
    (loop
      (unless top
          (return nil))
      (cond
       ((> no (color-table-key top))
	(if (null (color-table-big top))
	    (return nil)
	  (setf top (color-table-big top))))

       ((<  no (color-table-key top))
        (if (null (color-table-small top))
	    (return nil)
	  (setf top (color-table-small top))))
       (t
	(if (null (color-table-color top))
	    (setf top (color-table-big top))
	  (if (eq color (color-table-color top))
	      (return (setf (color-table-color top) nil))
	    (setf top (color-table-big top)))
	  ))
       ))))

;;; RGB$@$K$h$k%+%i!<LZ9=B$$+$i$N8!:w(J
(defun find-from-rgb (red green blue)
  (declare (special *top-color-tabel*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((top *top-color-tabel*)
	(no (logxor red green blue)))
    (loop 
      (unless top
          (return nil))
      (cond
       ((> no (color-table-key top))
	(if (null (color-table-big top))
	    (return nil)
	  (setf top (color-table-big top))))

       ((<  no (color-table-key top))
        (if (null (color-table-small top))
	    (return nil)
	  (setf top (color-table-small top))))
       (t
	(if (null (color-table-color top))
	    (setf top (color-table-big top))
	  (if (and (= (red (color-table-color top)) red)
		   (= (green (color-table-color top)) green)
		   (= (blue(color-table-color top)) blue))
	      (return (color-table-color top))
	    (setf top (color-table-big top)))
	  ))
       ))))

;;; RGB$@$K$h$k%+%i!<LZ9=B$$+$i$N8!:w(J
(defun near-from-rgb (red green blue)
  (declare (special *top-color-tabel*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((top *top-color-tabel*)
	(no (logxor red green blue)))
    (loop 
      (unless top
          (return nil))
      (cond
       ((> no (color-table-key top))
	(if (null (color-table-big top))
	    (return nil)
	  (setf top (color-table-big top))))

       ((<  no (color-table-key top))
        (if (null (color-table-small top))
	    (return nil)
	  (setf top (color-table-small top))))
       (t
	(if (null (color-table-color top))
	    (setf top (color-table-big top))
	  (if (and (> (+ (red (color-table-color top)) *near-val*) red)
		   (< red (- (red (color-table-color top)) *near-val*))
		   (> (+ (green (color-table-color top)) *near-val*) green)
		   (< green (- (green (color-table-color top)) *near-val*))
		   (> (+ (blue(color-table-color top)) *near-val*) blue)
		   (< blue (- (blue(color-table-color top)) *near-val*)))
	      (return (color-table-color top))
	    (setf top (color-table-big top)))
	  ))
       ))))

;;; $@%+%i!<$NLd$$9g$o$;(J
;;; find-color  &key (red 0) (green 0) (blue0)
;;; ARG.  red   =  RGB$@$G$N@V(J
;;;       blue  =  RGB$@$G$N@D(J
;;;       green =  RGB$@$G$NNP(J
;;; RET.
;;;       color instance or NIL
(defun find-color (&key (red 0) (green 0) (blue 0))
  (declare (special *all-colors*)
		   #-CMU
		   (inline = )
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (find-from-rgb red green blue))


;;; $@L>A0$G%+%i!<$r:n$k(J
;;; make-color-of-name color-name
;;; ARGS. color-name  = $@%+%i!<$NL>A0(J
;;; RET.
;;;      color instance or NIL
(defun make-color-of-name (color-name)
  (declare (special *all-colors*)
		   #-CMU
		   (inline < car)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((list (yy-protocol-46 color-name)))
    (if (< (car list) 0)
        nil
      (let ((color (make-instance 'color 
		     :color-no (car list)
		     :red-no (second list)
		     :green-no (third list) 
		     :blue-no (nth 4 list))))
	(set-tree-color color)
	(push color *all-colors*)
	color))))

;;; $@%+%i!<%;%k$r2rJ|$9$k(J
;;; remove-colors &rest colors
;;;  ARG.  colors   =  $@%+%i!<%$%s%9%?%s%9(J
;;;  RET.  
;;;        NIL
(defun remove-colors (&rest colors)
  (declare (special *all-colors*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dolist (item colors)
    (delete item *all-colors*)
    (delete-tree-color item))

  (yy-protocol-52 (mapcar #'color-no colors)))

;;; $@%+%i!<$N#R#G#B$NCM$rJQ99$9$k(J
;;; replace-color color &key (red (red color))
;;;			     (blue (blue color))
;;;			     (green (green color))
;;; ARG.
;;;     color $@%+%i!<%$%s%9%?%s%9(J
;;;     red   RGB$@$N@V$NCM(J
;;;     blue  RGB$@$N@D$NCM(J
;;;     green RGB$@$NNP$NCM(J
(defmethod replace-color ((color color) &key (red (red color))
					     (blue (blue color))
					     (green (green color)))
  (delete-tree-color color)
  
  (setf (red color) red
	(blue color) blue
	(green color) green)
  (set-tree-color color)
  ;;; Call YY protocol
  (yy-protocol-51 (color-no color) red green blue)
  color)

;;; $@%+%i!<%*%V%8%'%/%H$N%+%i!<HV9f$rJV$9(J
;;; color-code color-object
;;; ARG.
;;;      color-object  $@%+%i!<%$%s%9%?%s%9(J
;;; RET.
;;;;     $@%+%i!<HV9f(J
(defmethod color-code ((color color))
   (color-no color))

;;; $@%+%i!<HV9f$+$i%+%i!<%$%s%9%?%s%9$rJV$9(J
;;; code-color color-code
;;; ARG.  color-code  $@%+%i!<HV9f(J
;;; RET.
;;;       $@%+%i!<%$%s%9%?%s%9(Jor NIL
(defun code-color (color-no)
  (declare (special *all-colors*)
		   #-CMU
		   (inline =))
  (dolist (color *all-colors*)
      (when (= (color-no color) color-no)
	(return color)))
	)


;;; $@:GE,$J%*%Z%l!<%7%g%s$r5a$a$k(J
(defun avialble-operation (color)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *BLACK-COLOR*))
  (if (and (eq *BLACK-COLOR* color)
		   (/= 1 (color-no color)))
	  *GEQIV*
	*GXOR*))




