;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%&%#%s%I%&%9%H%j!<%`$NItIJ4XO"(J
;;; window-parts-class.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 91/11/28 by t.kosaka (kosaka@csrl.aoyama.ac.jp)

(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&$NItIJ%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-parts () 
  ((parent-window :initarg :parent-window
                  :accessor parent-window)))

;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%?%$%H%k%P!<%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass title-bar (event-drawable-piece window-parts)
  ((title-font :initarg :title-bar-font
	       :initform *DEFAULT-FONT*)

   (title-bar-string :initarg :title-bar-string
		     :initform "" )

   (title-bar-color :initarg :title-bar-color
		    :initform *BLACK-COLOR*)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%o!<%k%I$N4pK\%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass world-primitive (region graphic-stream)
  ((world-territory-no :initarg :world-territory-no 
		       :accessor world-territory-no :initform 0)
   ;;; $@%F%j%H%j!<$N$R$@$j$9$_$2$s$F$s$+$i(J
   (world-x-start :initarg :world-x-start
		  :initform 0 :accessor world-x-start) 
    ;;; $@%F%j%H%j!<$N$R$@$j$&$($2$s$F$s$+$i(J
   (world-y-start :initarg :world-y-start
		   :initform 0 :accessor world-y-start) 
   (world-color :initarg :world-back-color :initform *WHITE-COLOR*
		:type color :accessor world-back-color)

   (drawing-region :initarg :drawing-region :initform nil
		   :type region :accessor drawing-region)

   ;;; $@?F$+$i;R$I$b$K0U$?$k$^$GA4$F=q$-D>$7(J
   (present-redraw-all :initform nil :accessor present-redraw-all)

   (accetpt-active-list :initform nil :accessor accetpt-active-list)

   (present-list :initarg :present-list :initform nil
		 :type list :accessor present-list) ;$@%W%l%<%s%F!<%7%g%s$N%j%9%H(J

   (presentation-instance :initform nil    ;$@IA2h=hM}$N;~MxMQ$9$k(J
			  :accessor presentation-instance) 

   (present-selection :initform nil
					  :accessor present-selection) ;$@A*BrCf$N%W%l%<%s%F!<%7%g%s(J

   (present-selection-ok :initform nil   ;$@7hDj$7$?%W%l%<%s%F!<%7%g%s(J
						 :accessor present-selection-ok)
										;$@85$N?F%j!<%8%g%s(Jleft bottom
   (old-root-left-bottom :initform (list 0 0))

   (present-move-step :initform (list 0 0) ;$@%W%l%<%s%F!<%7%g%s$N0\F0%9%F%C%W(J
					  :accessor present-move-step) 

   (presentation-class-list :initform nil  ;$@%"%/%;%W%H$7$?;~$N%?%$%W(J
							:accessor presentation-class-list)

   ;;; $@O@M}86E@$+$i$N%:%l(J x$@J}8~(J
   (world-x-offset :initarg :x-offset :initform 0)

   ;;; $@O@M}86E@$+$i$N%:%l(J y$@J}8~(J
   (world-y-offset :initarg :y-offset :initform 0)

   ;;; $@%j%5%$%:MQ$N%o!<%/%j!<%8%g%s(J
   (resize-work :initform (make-region) :accessor resize-work)
   ))

;;;;;;;;;;;;;;;;;;;;;
;;; $@%Z!<%8%b!<%I(J ;;;;
;;;;;;;;;;;;;;;;;;;;;
(defclass page-mode ()
  (   ;;; $@%+%i%`(J
   (column :initarg :column :initform 0
	   :accessor page-column )
   ;;; $@9T(J
   (line :initarg :line :initform 0
	 :accessor page-line)))

;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%S%e%]!<%H%b!<%I(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;
(defclass viewport-mode () ())

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&%I%m!<%"%V%k%o!<%k%I(J ;;;
;;; $@%S%e!<%]!<%H%b!<%I(J             ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass drawable-viewport-world 
  (viewport-mode world-primitive)
  ;;; $@%"%K%a!<%7%g%s$N>uBV(J
  ())

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&%I%m!<%"%V%k%o!<%k%I(J ;;;
;;; $@%Z!<%8%b!<%I(J                   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass drawable-page-world (page-mode world-primitive)
  ())

#|
   LTRB $@$N$P$"$$(J
    + 	+-----------------------------+ START-X START-Y
    |	|			      |   
    +	|  * $@$2$s$F$s(J                 |
	|			      |
	|			      |
	|			      |
    +	|  * $@$2$s$F$s(J		      |
    |	|			      |
    +	+-----------------------------+
  LBWH $@$N$P$"$$(J

	$@$2$s$F$s$O!"$3$F$$!#(J 
	$@%o!<%k%I%j!<%8%g%s$O!"$2$s$F$s$+$i!"$N$+$/$@$$!?$7$e$/$7$g$&(J
	$@$r$9$k!#$7$?$,$C$F!"%^%$%J%9$[$&$3$&$X$N$+$/$@$$$b$"$j$&$k!#(J
|#


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&%U%l!<%`%/%i%9(J  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-frame (region window-parts)
  ((frame-territory-no :initform 0 :accessor frame-territory-no
			  :initarg :frame-territory-no
			  :reader territory)

   (frame-visible :initform T :accessor frame-visible
		     :initarg :frame-visible)

   (child-object-list :initarg :child-object-list
		      :initform nil :accessor child-object-list)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%9%/%m!<%k%P!<%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass scroll-bar (event-drawable-piece window-parts)
  ((scroll-bar-color :initform *black-color*
		     :initarg :scroll-bar-color
		     :accessor scroll-bar-color)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@=DJ}8~$N%9%/%m!<%k%P!<%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass vertical-scroll-bar (scroll-bar)
  ((vdisplay-start :initarg :vdisplay-start :initform 0
   			    :accessor vdisplay-start)

   (sdisplay-height :initarg :sdisplay-height :initform nil
   		    :accessor sdisplay-height)

   (world-height :initarg :world-height 
		 :reader world-height
		 :initform 0)

   (frame-height :initarg frame-heigth
		 :reader frame-height 
		 :initform 0)

   (coordinate :initarg :coordinate
	      :initform :left-top
	      :accessor coordinate)

   ;;; $@O@M}86E@$+$i$N%:%l(J y$@J}8~(J
   (world-y-offset :initarg :y-offset :initform 0)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@2#J}8~$N%9%/%m!<%k%P!<%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass horizontal-scroll-bar (scroll-bar)
  ((hdisplay-start :initarg :hdisplay-start :initform 0
		   :accessor hdisplay-start)

   (sdisplay-width :initarg :sdisplay-width :initform nil
   		   :accessor sdisplay-width)

   (world-width :initarg :world-with
		:reader world-width
		:initform 0)

   (frame-width :initarg frame-width
		 :reader frame-width)
   
   ;;; $@O@M}86E@$+$i$N%:%l(J x $@J}8~(J
   (world-x-offset :initarg :world-x-offset :initform 0
		)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@:BI87OI=<(%(%j%"%/%i%9(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass coordinate-area (piece-region window-parts)
  ((coordinate :accessor coordinate :initform :left-top
	       :initarg :coordinate)
   (coordinate-area-color :initform *black-color*
			 :accessor coordinate-area-color
      	 :initarg :coordinate-area-color)))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%&%#%s%I%&$N%\!<%@!<%/%i%9(J  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass window-border (event-method-mixin window-parts)
  ())

;;; End of window-parts-class.lisp


