;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; ɥΥ᥽åɴϢ
;;; window-method.lisp
;;; This file is EUC CODE
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University and CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; ɥΥޥ˥ԥ쥤
;;; 6/20 1990 ź
;;; Version 1.0   Coded by t.kosaka 1990-6-20

(in-package :yy)

    
;;; ֥ȤΤ֤롼ȥɥȥ꡼फΰ֤ѹ
;;; ֤XY ɥȥ꡼
(defmethod translate-root-xy ((window window-stream) x y)
  (declare (inline +)
	   (special *root-window*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((frame-region (frame-region window))
	 (window-region (window-region window)))

    (with-region-slots 
     ((fl left) (fb bottom)) frame-region
      (with-region-slots
       ((wl left) (wb bottom)) window-region
       (if (eq *root-window* window)
	   (values (+ x (slot-value window 'world-x-offset) fl wl)
		    (+ (with-translate-coordinate-stream y window) fb wb))
	  (translate-root-xy (parent-window window)
	    (+ x (slot-value window 'world-x-offset) fl wl)
	    (+ (with-translate-coordinate-stream y window) fb wb))
	  ))))
  )

;;; ֥ȤΤ֤롼ȥɥȥ꡼फΰ֤ѹ
;;; ֤XY ꡼
(defmethod translate-root-xy ((object drawable-piece) x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((ol left) (ob bottom)) object
   (if (window-streamp (object-parent object))
       (with-region-slots
	((pl left) (pb bottom)) (window-region (object-parent object))
	(translate-root-xy (parent-window (object-parent object))
			    (+ x ol pl)
			    (+ y ob pb)))
     (translate-root-xy (object-parent object)
			(+ x ol) (+ y ob)))))

;;; ֥ȤΤ֤롼ȥɥȥ꡼फΰ֤ѹ
;;; ֤XY ܡ
(defmethod translate-root-xy ((object window-border) x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (parent-window object)))
    (with-region-slots
     (left bottom) (window-region parent)
     (translate-root-xy (parent-window parent)
			(+ x left)
			(+ y bottom)))))

;;; ֥ȤΤ֤롼ȥɥȥ꡼फΰ֤ѹ
;;; ֤XY ե졼
(defmethod translate-root-xy ((object window-frame) x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (parent-window object)))
    (with-region-slots
     ((ol left) (ob bottom)) object
     (with-region-slots
      ((pl left) (pb bottom)) (window-region parent)
       (translate-root-xy (parent-window parent)
			  (+ x pl ol)
			  (+ y pb ob))))))
	

;;; 롼ȥɥΰ֤ꤵ줿ɥΰ֤ˤ
(defmethod root-fram-window-position-xy ((window window-stream)
				      (x integer) (y integer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (multiple-value-bind (xx yy) (translate-root-xy window 0 
			          (- (with-translate-coordinate-stream 0 window)))
     (let ((new-x (- x xx))
	   (new-y (- y yy)))

       ;;; ɸѴΰ֤֤
       (values new-x (with-translate-coordinate-stream new-y window))))
     )

;;; Ϳ줿ɥͿ줿֤
;;; ꤵ줿ɥΰ֤֤ X Y 
(defmethod translate-window-xy-to-xy ((s-window window-stream)
				      (x integer) (y integer)
				      (d-window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (multiple-value-bind (xx yy) (translate-root-xy s-window x y)
    (root-fram-window-position-xy d-window xx yy)))

;;; whichw
;;; ޥ֤Υɥ֤
;;; ARGS.
;;;             none
;;; RET.
;;;             ɥȥ꡼
(defun whichw ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((mouse-state (mouse-status)))
	(window-from-root-xy *root-window* 
			 (mouse-state-x-position mouse-state)
			 (mouse-state-y-position mouse-state))))


;;; whicw-with-button
;;; ޥ줿ȤΥɥ֤
;;; ARGS.
;;;            none
;;; RET.
;;;            ɥȥ꡼
(defun whichw-with-button ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((mouse-state nil))
    ;;; ޥޤԤ
    (with-mouse-grabbed *GET-POSITION-MOUSE-CURSOR*
       (loop
	 (setf mouse-state (mouse-status))
	  (unless (zerop (logand (mouse-state-button-state mouse-state)
                                  *mouse-button-down-1*))
	    (return))
	 ))
    (window-from-root-xy *root-window* 
			 (mouse-state-x-position mouse-state)
			 (mouse-state-y-position mouse-state))))

;    (parent-stream (mouse-state-object mouse-state))))


;;; 롼ȥɥΰ֤Ǥ륦ɥʤλҶΥɥ
;;; פ륦ɥ֤
(defun window-from-root-xy (window x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((region (make-region))
	(ret window)
	(p-x (if (eq window *root-window*)
		 0
	       (region-left (window-region window))))
	(p-y (if (eq window *root-window*)
		 0
	       (region-bottom (window-region window)))))

;    (format t "~%print :~a" window)
    (dolist (win (children-windows window))
      (when (draw-piece-visible win)
	(set-region region (window-region win))
	(multiple-value-bind (xx yy)
	    (values (+ (region-left (window-frame window)) p-x
		       (world-x-offset window))
		    (+ (region-bottom (window-frame window)) p-y
		       (world-y-offset window)))
	  (shift-region-position region xx yy))
	(if (region-contains-position-xy-p region x y)
	    (return (setf ret (window-from-root-xy win x y))))))

    ret))
      
    

;;; ޥ줿֤֤ XY
(defun get-position-xy (&optional (window *root-window*))
  (declare (special *GET-POSITION-MOUSE-CURSOR*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (window-streamp window)
      (let ((mouse-state nil))
		      
        ;;; ʤˤܥ󤬲ޤԤ
	(with-mouse-grabbed *GET-POSITION-MOUSE-CURSOR*
	   (loop 
	    (setf mouse-state (mouse-status))
	  
	    (if (not (zerop (logand (mouse-state-button-state mouse-state)
				  *mouse-button-down-1*)))
                ;;; 줿
		(return))
	     ))
	(multiple-value-bind (xx yy)
	    (translate-root-xy (mouse-state-object mouse-state)
			       (mouse-state-x-position mouse-state)
			       (mouse-state-y-position mouse-state))
	  (if (eq *root-window* window)
	      (values xx yy)
	    (root-fram-window-position-xy window xx yy))
	  ))
    (error "The argument ~a is not a window stream" window)))


;;; get-position
;;; ޥ줿֤֤ ݥ
(defun get-position (&optional (window *root-window*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (multiple-value-bind (x y) (get-position-xy window)
    (make-position :x x :y y))
  )


(defvar *no-clip-territory1* nil)
(defvar *no-clip-territory2* nil)
(defvar *no-clip-territory3* nil)
(defvar *no-clip-territory4* nil)

#|
                        *no-clip-territory1*
                     +-----------------------+
*no-clip-territory2* |                       |*no-clip-territory4*
                     |                       |
                     +-----------------------+
                       *no-clip-territory3*
|#

;;; draw-region-region-no-clip
;;; ǡƤΥɥΥåפ򤷤ʤ
;;; Ϳ꡼ϡ롼ȥɥˤɸǤ롣
(defun draw-region-region-no-clip (stream region)
  (declare (inline +)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (WITH-INHIBIT-SCHEDULING
   (with-region-slots (left bottom width height) region

        ;;; ưڤӥѹ
     (yy-protocol-4 *no-clip-territory1* left bottom width 1)
     (yy-protocol-4 *no-clip-territory2* left bottom 1 height)
     (yy-protocol-4 *no-clip-territory3* left (+ bottom height) width 1)
     (yy-protocol-4 *no-clip-territory4* (+ left width) bottom 1 height))
   ))
      

;;; setup-draw-region-region-no-clip
;;; ǡƤΥɥΥåפ򤷤ʤ
;;; Ϳ꡼ϡ롼ȥɥˤɸǤ롣
;;; mode -> T ɽ mode -> nil ɽ
(defun setup-draw-region-region-no-clip (stream color mode)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (WITH-INHIBIT-SCHEDULING
     (if mode
	 ;;; 
	 (if (null *no-clip-territory1*)
	     (progn  
	       (setf 
		   *no-clip-territory1* (make-territory :x 0 :y 0 :width 1 
			          :height 1
				  :window-mode T
				  :parent (world-territory-no *root-window*))
	       *no-clip-territory2* (make-territory :x 0 :y 0 :width 1 
			          :height 1
				  :window-mode T
				  :parent (world-territory-no *root-window*))
	       *no-clip-territory3* (make-territory :x 0
				  :y 0
				  :width 1
			          :height 1
				  :window-mode T
				  :parent (world-territory-no *root-window*))
	       *no-clip-territory4* (make-territory 
				  :x 0
				  :y 0 :width 1
			          :height 1 
				  :window-mode T
				  :parent (world-territory-no *root-window*)))
	
	       ;;; ƥȥ꡼οˤ
	       (yy-protocol-32 *no-clip-territory1* (color-no color))
	       (yy-protocol-32 *no-clip-territory2* (color-no color))
	       (yy-protocol-32 *no-clip-territory3* (color-no color))
	       (yy-protocol-32 *no-clip-territory4* (color-no color))
	       )
           ;;; ־ˤ⡼
	   (progn 
	     (yy-protocol-7 *no-clip-territory1*)
	     (yy-protocol-7 *no-clip-territory2*)
	     (yy-protocol-7 *no-clip-territory3*)
	     (yy-protocol-7 *no-clip-territory4*)

	     (yy-protocol-2 *no-clip-territory1* 1)
	     (yy-protocol-2 *no-clip-territory2* 1)
	     (yy-protocol-2 *no-clip-territory3* 1)
	     (yy-protocol-2 *no-clip-territory4* 1)
	     ))
       ;;; ɽ
       (progn
	 (yy-protocol-2 *no-clip-territory1* 0)
	 (yy-protocol-2 *no-clip-territory2* 0)
	 (yy-protocol-2 *no-clip-territory3* 0)
	 (yy-protocol-2 *no-clip-territory4* 0))
       )))

;;; ¥
;;; ٥ȥޥʸ
(defun mask-to-message (mask)
  (cond 
   ((/= (logand mask *mouse-left-1*) 0)
    "ܥ")
   ((/= (logand mask *mouse-middle-1*) 0)
	"ܥ")
   ((/= (logand mask *mouse-right-1*) 0)
	"ܥ")))

;;; Ϳ줿ޥξ֤Ӥơ
;;; ۤʤäƤT֤
(defun waite-mouse-state (mouse-state)
    (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
			 (special *current-mouse-state*))
	(if (and *current-mouse-state* mouse-state)
		(if (or (/= (mouse-state-button-state mouse-state)
					(mouse-state-button-state *current-mouse-state*))
				(/= (mouse-state-y-position mouse-state)
					(mouse-state-y-position *current-mouse-state*))
				(/= (mouse-state-x-position mouse-state)
					(mouse-state-x-position *current-mouse-state*))
				(not (eq (mouse-state-object mouse-state)
						 (mouse-state-object *current-mouse-state*))))
			T
		  nil)
	  (progn
		(setf *current-mouse-state* (mouse-status))
		T)))

;;; get-box-region 
;;; ΰ
;;; get-box-region (init-region region &key end-condition *mouse-right-1*)
;;;                           (change-condition *mouse-left-1*)
;;;                           (move-mode :corner)
;;;                           (window *root-window*))
;;; ARGS.
;;; init-region ꡼ 롼ȥɥˤ꡼
;;; &key
;;; end-condition λΥޥܥ
;;; change-condition move-mode:cornerΤȤѤѹ׵᤹
;;;                  end-condition줿äȤᤤѤФ
;;; move-mode   :corner ѤǡưݥͿС
;;;             ΥݥޥβƯ֤Ȥƶư
;;;             ݥϡ꡼κȤ
;;; window      ޤäɸꤵ줿ɥκɸˤ
(defun get-box-region (init-region
					   &key (end-condition *mouse-right-1*)
					   (change-condition *mouse-left-1*)
					   (move-mode :corner)
					   (window *root-window*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *current-mouse-state*))

  (draw-prompt
   (format nil "~aǷ ~aǥե꡼(~a~a)"
		   (mask-to-message end-condition)
		   (mask-to-message change-condition)
		   (mask-to-message end-condition)
		   move-mode))

  (if (window-streamp window)
      (let* ((mouse-s (mouse-status))
			 (sub-status t)
			 (status nil)
			 (shift-x 0)
			 (shift-y 0)
			 (root-x 0)
			 (root-y 0))
		(multiple-value-setq (root-x root-y) 
	  (translate-root-xy (mouse-state-object mouse-s)
			     (mouse-state-x-position mouse-s)
			     (mouse-state-y-position mouse-s)))
         ;;;Ȥɽ
		(setup-draw-region-region-no-clip *root-window* 
					  (graphic-color window) T)
		(draw-region-region-no-clip *root-window* init-region)

        ;;; 򷫤֤
		(WITH-INHIBIT-SCHEDULING
		 (loop
		  ;; ۤʤmouse-stateޤԤ
		  (setf mouse-s (mouse-status))

		  (multiple-value-setq 
		   (root-x root-y)
		   (translate-root-xy (mouse-state-object mouse-s)
							  (mouse-state-x-position mouse-s)
							  (mouse-state-y-position mouse-s)))

		  ;; ܥξ֤򸫤
		  (cond 
		   ((not (zerop (logand (mouse-state-button-state mouse-s)
								end-condition)))
			(if (null status)
				;; λ
				(return)
			  ;; ʡη
			  (progn
				(draw-prompt (format nil "~aꤵޤ" move-mode))
				(multiple-value-bind 
				 (x y) 
				 (near-corner-xy init-region root-x root-y)
				 (setf shift-x (- (region-left init-region) x)
					   shift-y (- (region-bottom init-region) y)
					   sub-status nil)))))
	       
		   ((not (zerop (logand (mouse-state-button-state mouse-s)
								change-condition)))
			(draw-prompt 
			 (format nil "ޥե꡼ˤʤޤ~a~aꤷƲ"
					 (mask-to-message end-condition)
					 move-mode))

			;; cornerΥå
			(unless (position-p move-mode)
					(setf status T)))
		   (t
			(if (null sub-status)
				(setf sub-status T
					  status nil))
			(unless status
					;; ֤ᡢȤ
					(draw-region-region-no-clip 
					 *root-window*
					 (set-region-position-xy init-region
											 (+ shift-x root-x)
											 (+ shift-y root-y)))))
		   )))
		(setup-draw-region-region-no-clip *root-window* 
										  (graphic-color window) nil)
        ;; 롼ȥɥΥå
	(if (eq *root-window* window)
	       init-region
	  (multiple-value-bind (x y)
	      (root-fram-window-position-xy window 
					    (region-left init-region)
					    (region-bottom init-region))
	    (set-region-position-xy  init-region x y))))
    (error "The arument ~a is not a window stream" window)))


;;; Ϳ줿ʡȡݥǥ꡼ѹ
(defmethod change-region-size ((region region)
			       (pos position)
			       (corner-pos position))
  (declare (inline =)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((pos-x (position-x pos))
	(pos-y (position-y pos))
	(r-posx (position-x corner-pos))
	(r-posy (position-y corner-pos)))
    (with-region-slots 
     (left bottom right top) region

     (if (= left r-posx)
	 (setf left pos-x))
    
    (if (= right r-posx)
	(setf right pos-x))

    (if (= bottom r-posy)
	(setf bottom pos-y))

    (if (= top  r-posy)
	(setf top pos-y)))
  region
  ))

;;; Ϳ줿ʡȡݥǥ꡼ѹ
(defmethod change-region-size-xy ((region region)
								  x y cx cy)
  (declare (inline =)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left bottom right top) region
   (if (= left cx)
       (setf left x))
    
   (if (= right cx)
       (setf right x))

   (if (= bottom cy)
       (setf bottom y))

   (if (= top cy)
       (setf top y))
   region)
  )

(defvar *NEAR-REGION* 30)

;;; get-region 
;;; &key
;;; init-region ꡼ 롼ȥɥˤ꡼
;;; max-region ꡼
;;; min-region Ǿ꡼
;;; end-condition λΥޥܥ
;;; move-mode ϡ:corner  :line Ǥ
;;;               :cornerΤȤϡѤǥ顼СХɤҤ롣
;;;               :line ΤȤϡΰĤǥ顼СХɤҤ
;;; change-condition move-mode:cornerΤȤѤѹ׵᤹
;;;                  end-condition줿äȤᤤѤФ
;;;                  move-mode:lineΤȤѹ׵᤹롣
;;;                  end-condition줿äȤᤤФ
;;; window      ޤäɸꤵ줿ɥκɸˤ
(defun get-region ( &key 
			(init-region nil)
			(max-region nil)
			(min-region nil)
			(end-condition *mouse-right-1*)
			(move-mode :corner)
			(change-condition *mouse-left-1*)
			(window *root-window*))
  (declare (inline + < > - <= min max abs)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;;; Υå
  (unless (window-streamp window)
	  (error "The argument ~a is not a window stream" window))

  (if max-region
      (unless (region-p max-region)
	      (error "The argument ~a is not a region" max-region)))

  (if min-region
      (unless (region-p min-region)
	      (error "The argument ~a is not a region" min-region)))

  (draw-prompt
   (format nil "~aǷ ~aǥե꡼(~a~a)"
		   (mask-to-message end-condition)
		   (mask-to-message change-condition)
		   (mask-to-message end-condition)
		   move-mode))

  (let* ((mouse-s (mouse-status))
	 (status nil)
	 (sub-status T)
	 (root-x 0) (root-y 0)
	 
	 (max-height (if max-region
			 (region-height max-region)
		       most-positive-fixnum))
	 (max-width (if max-region
			(region-width max-region)
		      most-positive-fixnum))
	 (min-width (if min-region
			(region-width min-region)
		      0))
	 (min-height (if min-region
			 (region-height min-region)
		       0))
	 (x1 0) (x2 0) (y1 0) (y2 0)
	 (origin 1))

    (multiple-value-setq (root-x root-y) 
      (translate-root-xy (mouse-state-object mouse-s)
			 (mouse-state-x-position mouse-s)
			 (mouse-state-y-position mouse-s)))

    (unless init-region
      ;;; 
      (multiple-value-bind (x y) (get-position-xy window)
	(setf init-region (make-region :left x
				       :bottom y
				       :width 2
				       :height 2))))
    (setf x1 (region-left init-region)
	  x2 (region-right init-region)
	  y1 (region-bottom init-region)
	  y2 (region-top init-region))

    ;;; ޥΥ
    (yy-protocol-74 2)

    ;;; Ϥդǡޥΰưߤ
    ; (move-mouse-cursor ...)

    ;;; Ȥ
    (setup-draw-region-region-no-clip *root-window* (graphic-color window) T)
    (draw-region-region-no-clip *root-window* init-region)
	(WITH-INHIBIT-SCHEDULING
    ;;; 򷫤֤
    (loop
      (setf mouse-s (mouse-status))

      (multiple-value-setq (root-x root-y) 
	(translate-root-xy (mouse-state-object mouse-s)
			   (mouse-state-x-position mouse-s)
			   (mouse-state-y-position mouse-s)))

     ;;; ܥξ֤򸫤
     (cond 
      ;;; λȽ
      ((not (zerop (logand (mouse-state-button-state mouse-s)
			   end-condition)))
       (if (null status)
           ;;; λ
	   	   (return)
	 ;;; ʡη
	 (let ((x root-x)
	       (y root-y))
	   (draw-prompt (format nil "~aꤵޤ" move-mode))
	   (case move-mode
	     (:corner
	      (cond 
	       ((and (< x (+ x1 *NEAR-REGION*)) (> x (- x1 *NEAR-REGION*)))
		(cond
		 ((and (< y (+ y1 *NEAR-REGION*)) (> y (- y1 *NEAR-REGION*)))
		  (setf origin 4
			sub-status nil))
		 ((and (< y (+ y2 *NEAR-REGION*)) (> y (- y2 *NEAR-REGION*)))
		  (setf origin 2
			sub-status nil))))
	       ((and (< x (+ x2 *NEAR-REGION*)) (> x (- x2 *NEAR-REGION*)))
		(cond
		 ((and (< y (+ y1 *NEAR-REGION*)) (> y (- y1 *NEAR-REGION*)))
		  (setf origin 3
			sub-status nil))
		 ((and (< y (+ y2 *NEAR-REGION*)) (> y (- y2 *NEAR-REGION*)))
		  (setf origin 1
			sub-status nil))))))
	      
	     (:line
	      (cond 
	       ((and (> (max x1 x2) x) (> x (min x1 x2)))
		(cond
		 ((and (< y (+ y1 *NEAR-REGION*)) (> y (- y1 *NEAR-REGION*)))
		  (setf origin 3
			sub-status nil))
		 ((and (< y (+ y2 *NEAR-REGION*)) (> y (- y2 *NEAR-REGION*)))
		  (setf origin 1
			sub-status nil))
		 ))
	       ((and (> (max y1 y2) y) (> y (min y1 y2)))
		(cond
		 ((and (< x (+ x1 *NEAR-REGION*)) (> x (- x1 *NEAR-REGION*)))
		  (setf origin 2
			sub-status nil))
		 ((and (< x (+ x2 *NEAR-REGION*)) (> x (- x2 *NEAR-REGION*)))
		  (setf origin 4
			sub-status nil))
		 ))
	       ))
	     ))))

      ;;; ư֤ѹ
      ((not (zerop (logand (mouse-state-button-state mouse-s) 
			   change-condition)))
	   (draw-prompt 
		(format nil "ޥե꡼ˤʤޤ~a~aꤷƲ"
				(mask-to-message end-condition)
				move-mode))
       (setf status T))

      ;;; Ȥ
      (t  (if (null sub-status)  (setf sub-status T status nil))

       (unless status
	  (when (and (<= min-width (abs (- x1 x2)))
		     (<= (abs (- x1 x2)) max-width)
		     (<= min-height (abs (- y1 y2)))
		     (<= (abs (- y1 y2)) max-height))

	    ;;; ORIGINˤ
	    (case move-mode
	      (:corner
	       (case origin
		 (1 (setf x2  root-x
			  y2  root-y))
		 (2 (setf x1 root-x
			  y2 root-y))
		 (3 (setf x2 root-x
			  y1 root-y))
		 (4 (setf x1 root-x
			  y1 root-y))))
	      (:line
	       (case origin
		 (1 (setf y2 root-y))
		 (2 (setf x1 root-x))
		 (3 (setf y1 root-y))
		 (4 (setf x2 root-x)))))
	  )

	  (with-region-slots
	   (left bottom right top) init-region
	   
	   (setf left (min x1 x2)
		 right (max x1 x2)
		 top (max y1 y2)
		bottom (min y1 y2)))

	    ;;; ֤ᡢȤ
	  (draw-region-region-no-clip *root-window* init-region)
	  )))
    )

    (setup-draw-region-region-no-clip *root-window* (graphic-color window) nil)
    (yy-protocol-74 1)
    ;;; 롼ȥɥΥå
    (if (eq *root-window* window)
	init-region
      (multiple-value-bind (x y)
	  (with-region-slots 
	   (left bottom) init-region
	   (root-fram-window-position-xy window 
					 left bottom))
	(set-region-position-xy  init-region x y)))
    )))
    
	

;;; ɥΥ
;;; scroll window-stream new-origin-x new-origin-y 
;;; origin-x,origin-yϡɥˡ줿ե졼फɤ
;;; ֤ѹ롣ꤹȡ֤ΰ֤ˤʤ롣
(defmethod scroll ((window window-stream) (x-offset integer) (y-offset integer))
    (change-world-xy-offset window x-offset y-offset)
)

;;; ɥleft᥽å
;;; window-left window-stream
;;; ARG.
;;;             window-stream   =  ɥȥ꡼
;;; RET.
;;;             left
(defmethod window-left ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (region-left (window-region window)))

;;; ɥleftѹ᥽å
;;; (setf window-left) new-v window-stream
;;; ARG.
;;;           new-v           =  left
;;;           window-stream   =  ɥȥ꡼
;;; RET.
;;;           left
(defmethod (setf window-left) (new-v (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (move-xy-internal window new-v (region-bottom (window-region window)))
  new-v)

;;; ɥbottom᥽å
;;; window-bottom window-stream
;;; ARG.
;;;             window-stream   =  ɥȥ꡼
;;; RET.
;;;             bottom
(defmethod window-bottom ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (region-bottom (window-region window)))

;;; ɥbottomѹ᥽å
;;; (setf window-bottom) new-v window-stream
;;; ARG.
;;;           new-v           =  bottom
;;;           window-stream   =  ɥȥ꡼
;;; RET.
;;;           bottom
(defmethod (setf window-bottom) (new-v (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (move-xy-internal window (region-left (window-region window))
		    new-v)
  new-v)

;;; ɥright᥽å
;;; window-right window-stream
;;; ARG.
;;;             window-stream   =  ɥȥ꡼
;;; RET.
;;;             right
(defmethod window-right ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (region-right (window-region window)))

;;; ɥrightѹ᥽å
;;; (setf window-right) new-v window-stream
;;; ARG.
;;;           new-v           =  right
;;;           window-stream   =  ɥȥ꡼
;;; RET.
;;;           right
(defmethod (setf window-right) (new-v (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots (right) (window-region window)
	      (setf right new-v))
  (setf (window-region window) (window-region window))
  new-v)
	
;;; ɥtop᥽å
;;; window-top window-stream
;;; ARG.
;;;             window-stream   =  ɥȥ꡼
;;; RET.
;;;           top 
(defmethod window-top ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (region-top (window-region window)))

;;; ɥtopѹ᥽å
;;; (setf window-top) new-v window-stream
;;; ARG.
;;;           new-v           =  top
;;;           window-stream   =  ɥȥ꡼
;;; RET.
;;;           right
(defmethod (setf window-top) (new-v (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots (top) (window-region window)
	      (setf top new-v))
  (setf (window-region window) (window-region window))
  new-v)


;;; ɥ᥽å
;;; window-width window-stream
;;; ARG.
;;;             window-stream   =  ɥȥ꡼
;;; RET.
;;;           
(defmethod window-width ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (region-width (window-region window)))

;;; ɥѹ᥽å
;;; (setf window-width) new-v window-stream
;;; ARG.
;;;           new-v           =  
;;;           window-stream   =  ɥȥ꡼
;;; RET.
;;;           
(defmethod (setf window-width) (new-v (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots (left right) (window-region window)
	      (setf right (+ left new-v)))
  (setf (window-region window) (window-region window))
  new-v)


;;; ɥι⤵᥽å
;;; window-height window-stream
;;; ARG.
;;;             window-stream   =  ɥȥ꡼
;;; RET.
;;;           ⤵
(defmethod window-height ((window window-stream))
  (region-height (window-region window)))

;;; ɥι⤵ѹ᥽å
;;; (setf window-height) new-v window-stream
;;; ARG.
;;;           new-v           =  ⤵
;;;           window-stream   =  ɥȥ꡼
;;; RET.
;;;           ⤵
(defmethod (setf window-height) (new-v (window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots (bottom top) (window-region window)
	      (setf top (+ bottom new-v)))
  (setf (window-region window) (window-region window))
  new-v)


;;; ɥΰư
;;; move window-stream new-position
;;; new-position ϡƤΥɥʤκɸǤ
(defmethod move ((window window-stream) (new-position position))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (move-xy-internal window (position-x new-position)
		    (position-y new-position)))

;;; ɥΰư
;;; move-xy window-stream new-x new-y
;;; new-x,new-y ϡƥɥǤκɸ
(defmethod move-xy ((window window-stream) (new-x integer) (new-y integer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (move-xy-internal window new-x new-y))

;;; ɥΰưΥ󥿡ʥؿ
(defun move-xy-internal (window new-x new-y)
  (set-region-position-xy (window-region window) new-x new-y)
      (if (parent-window window)
	  (yy-protocol-3 (territory window)
                    (- (region-left (window-region window))
                       (world-x-start (parent-window window)))
                     (- (with-translate-coordinate-stream
                         (region-bottom (window-region window))
                         (parent-window window))
                        (world-y-start (parent-window window))))
      ))


;;; ɥ礭ѹ
;;; reshape window-stream new-region
(defmethod reshape ((window window-stream) (new-region region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (window-region window) new-region))


;;; ɥΥݡ ɥ־ˤ
;;; expose window-stream
(defmethod expose ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((p-window (parent-window window))
	 (child (children-windows p-window))
	 (old-b (old-brother-window window))
	 (young-w (young-brother-window window)))

    (yy-protocol-7 (territory window))
    
    ;;; ɥ³طκ
    (if old-b
	(setf (young-brother-window old-b) young-w))

    (if young-w 
	(setf (old-brother-window young-w) old-b))

    (setf (old-brother-window window) (car child)
	  (young-brother-window window) nil)

    (when (car child)
	(setf (young-brother-window (car child)) window)
	(delete window child)
	(pushnew window child))
    window))

;;; ɥΥХ꡼ ɥֲˤ
;;; bury window-stream
(defmethod bury ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((p-window (parent-window window))
	 (child (children-windows p-window))
	 (old-b (old-brother-window window))
	 (young-w (young-brother-window window)))

    (yy-protocol-8 (territory window))
    
    ;;; ɥ³طκ
    (if old-b
	(setf (young-brother-window old-b) young-w))

    (if young-w 
	(setf (old-brother-window young-w) old-b))

    (setf (old-brother-window window) nil
	  (young-brother-window window) (car (last child)))

    (when (car child)
	(setf (old-brother-window (car (last child))) window)
	(delete window child)
	(nconc child (list window)))

    window))


;;; ɥ򥷥󥯤 ɥ򥢥ˤ롣
;;; shrink window-stream &optional exp
;;; ARG.
;;;           window-stream   =   ɥȥ꡼
;;;           exp             =   ӥåȥޥå or ʸ or ᥽å
(defmethod shrink ((window window-stream) &optional (exp nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (unless exp
	  (setf exp (title-bar-string window)))

  (if (stringp exp)
      (if (= (length exp) 0)
	  (setf exp (multiple-value-bind (b p j n g y)
                           (get-decoded-time)
                         (declare (ignore b))
                         (format nil "~a(Year) ~a/~a ~a:~a" y g n j p)))))

  (let ((icon (window-icon window)))

    ;;; ƹǤɽ
    (temp-invisible-parts window)
    
    (resize-window-and-invisible window
				 (draw-icon icon  exp))
			       
    (setf  (window-status window) :icon)

    ;;; ɽ
    (setf (draw-piece-visible icon) T)))

(defun resize-window-and-invisible (window region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((icon (window-icon window))
		 (wregion (window-region window))
		 (parent (parent-window window))
		 (start-x (if parent (world-x-start parent) 0))
		 (start-y (if parent (world-y-start parent) 0)))

    ;;; ɥ礭ѹ
    (with-slots 
     (p-left p-bottom p-width p-height) icon
     (with-region-slots 
      (left bottom width height) wregion
      
      (setf p-left left
	    p-bottom bottom
	    p-width width
	    p-height height)))

;    (set-region wregion region)
    (setf (region-width wregion) 
      (+ (* 2 (real-border-belt window)) (region-width region))
      (region-height wregion)
      (+ (* 2 (real-border-belt window)) (region-height region)))

    (with-region-slots
     (left bottom width height) wregion
     (yy-protocol-4 (territory window) (+ left start-x)
                   (+ (with-translate-coordinate-stream bottom parent)
                      start-y)
		   width height))
    (redisplay-border window)
    nil))
	  
;;; 褹δؿ
;;; draw-icon icon exp
;;; ARG.
;;;           icon   =   
;;;           exp    =   ʸorӥåȥޥåorѼΥ᥽å
;;;                      ѼΥ᥽åɤϡ(apply ***** icon)ǸƤФ
;;;                      ʸӥåȥޥåפξϥ礭ꤵ뤬
;;;                      ѼξϡѼԤɬפ롣
(defgeneric  draw-icon (icon exp)
  (:method ((icon icon) (exp string))
	   (let ((font (stream-font (parent-window icon))))
	     (with-real-object (icon)
	       (setf 
		   (region-bottom icon) 1
		   (region-left icon) 1
		   (region-width icon) (+ (font-string-length font exp) 2)
		   (region-height icon) (font-kanji-height font)))

	     (draw-piece-string icon 2 (font-kanji-base-line font) exp))
	   icon)
  (:method ((icon icon) (exp bitmap))
	   (with-real-object (icon)
              (setf (region-width icon) (bitmap-width exp)
		    (region-bottom icon) (bitmap-height exp)))
	   
	   (draw-piece-copy exp 0 0 icon 0 0 (region-width icon)
			    (region-bottom icon))
	   icon)
  (:method ((icon icon) exp)
#-PCL 
   (declare (ignore exp))
	   (apply #'exp icon)
	   icon))
  
;;; ɥιǤŪɽ롣
(defun temp-invisible-parts (window)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (window-title-bar window)
      (yy-protocol-2 (territory (window-title-bar window)) 0))
  (if (window-horizontal-scroll-bar window)
      (yy-protocol-2 (territory (window-horizontal-scroll-bar window)) 0))
  (if (window-vertical-scroll-bar window)
      (yy-protocol-2 (territory (window-vertical-scroll-bar window)) 0))
  (if (window-coordinate-area window)
      (yy-protocol-2 (territory (window-coordinate-area window)) 0))
  (yy-protocol-2 (territory (window-frame window)) 0))


;;; ɥιǤΰŪɽߤ
(defun temp-visible-parts (window)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((title    (window-title-bar window))
	(h-scroll (window-horizontal-scroll-bar window))
	(v-scroll (window-vertical-scroll-bar window))
	(co       (window-coordinate-area window))
	(frame    (window-frame window)))
    (if (draw-piece-visible title)
	(yy-protocol-2 (territory title) 1))
    (if (draw-piece-visible h-scroll)
	(yy-protocol-2 (territory h-scroll) 1))
    (if (draw-piece-visible v-scroll)
	(yy-protocol-2 (territory v-scroll) 1))
    (if (draw-piece-visible co)
	(yy-protocol-2 (territory co) 1))
    (if (frame-visible frame)
	(yy-protocol-2 (territory frame) 1))
    ))
      
  
;;; 򥨥ѥɤ
;;; exapnd window-stream 
(defmethod expand ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (eq :icon (window-status window))
     (let* ((icon (window-icon window))
	    (region (window-region window)))
       
       (with-slots 
	(p-left p-bottom p-width p-height) icon
	(with-region-slots 
	 (left bottom width height)  region
		   
	 (setf left p-left
	       bottom p-bottom
	       width p-width
	       height p-height)))

       ;;; ɽ
       (setf (draw-piece-visible icon) NIL
	     (window-status window) :window)

       ;;; Τľ
       (setf (window-region window) region)

       ;;; Ǥɽ
       (temp-visible-parts window)
       )
;     (redisplay-window window)
  ))
      

;;; ɥ򥢥ƥ֤ˤ
;;; acitivate window
;;; ARG.
;;;           window  =  ɥȥ꡼
(defmethod activate ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (window-visible window) T))


;;; ɥ󥢥ƥ֤ˤ
;;; deactivate window
;;; ARG.
;;;            window = ɥȥ꡼
(defmethod deactivate ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (window-visible window) nil))


;;; ɥΥꥢ
;;; clear-window-stream window-stream
;;; ARGS.
;;;           window-stream  = оݤˤʤ륰եåȥ꡼
;;; ꥢ᥽å
(defmethod clear-window-stream ((stream viewport-window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (stream-cursor-y-position  stream)
    (font-kanji-base-line (stream-font stream))
    (position-x  (slot-value stream 'cursor-position))
    0)
  (claer-graphic-stream stream (stream-default-color-pattern stream))
  (setf (world-x-offset stream) 0)
  (setf (world-y-offset stream) 0)
stream)

(defmethod clear-window-stream ((stream page-window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-81 (world-territory-no stream)
				  0 0 1 0 0 1)
	(claer-graphic-stream stream (stream-default-color-pattern stream))
	(setf (world-x-offset stream) 0)
	(setf (world-y-offset stream) 0)
	(set-y-position-for-page-maode stream 0 0)
	stream)


;;; եåȥ꡼Υꥢ  顼ξ
(defmethod claer-graphic-stream ((stream window-stream) (color color))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-32 (world-territory-no stream)
		  (color-no color)))


;;; եåȥ꡼Υꥢ  ᡼ξ
(defmethod claer-graphic-stream ((stream window-stream) (image image))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((tno (make-territory 
	       :width (image-width image)
	       :height (image-height image)
	       :visible nil))
	 (format1 (if (eq (image-format image) :yy)
                      2
                    1))
	 (format (case (image-type image)
		   (:color
		    (logior #x8000 format1))
		   (:gray
		    (logior #x4000 format1))
		   (t
		    (logior #x2000 format1)))))

    (yy-protocol-61 tno 0 0 (image-width image) (image-height image)
                        format (image-data image))

    (yy-protocol-33 (world-territory-no stream) tno)
    
    (yy-protocol-5 tno)))

;;; եåȥ꡼Υꥢ  ӥåȥޥåפξ
(defmethod claer-graphic-stream ((stream window-stream) (bitmap bitmap))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-33 (world-territory-no stream)
		    (bitmap-territory-no bitmap)))

;;; ٥Ȥΰ ɥ
;;; disnable-event window mask
;;; ARG.
;;;          window = ɥȥ꡼
;;;          mask   = ٥ȤΥޥ
(defmethod disnable-event ((window window-stream) mask)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((event-method window)
	 (old-mask (event-mask event-method))
	 (new-mask (logand (lognot mask) old-mask)))
    (yy-protocol-72 (world-territory-no window) new-mask)))


;;; ٥Ȥβ ɥ
;;; enable-event  window
;;; ARG.
;;;               window = ɥȥ꡼
(defmethod enable-event ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-72 (world-territory-no window) 
		  (event-mask window)))


;;; ɥξõ
;;; ɥʤλɥˤ
;;; ƥ֥꡼ץ쥼ơ
;;; õ
;;; flush-window window-stream
;;; ARG. 
;;;          window-stream = ɥȥ꡼
(defmethod flush-window ((window window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;;; Ƥ鼫ʬ
  (if (parent-window window)
      (setf (children-windows (parent-window window))
	(delete window (children-windows (parent-window window)))))

  ;;; طκ
  (let ((young (young-brother-window window))
	(old   (old-brother-window window)))
  (if young
    (if (old-brother-window young)
      (setf (old-brother-window young) old)))
  (if old
      (if (young-brother-window old) 
	  (setf (young-brother-window old) young)))

  ;;; ʬȤʤ
  (delete-window-parts window nil)

  ;;; ʬλҤɤ
  (dolist (item (children-windows window))
    (delete-window-parts item nil))

  (setf (children-windows window) nil)

  ;;; ƥȥ꡼˲
  (yy-protocol-5 (territory window))

  (setf (territory window) nil)))
  

;;; ʤκ
(defun delete-window-parts (window &optional (territory T))
  (declare (function flush-active-region (T T) T)
	   (function flush-presentation (T T) T)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  ;;; ʤξõ
  (dolist (item (child-object-list window))
    (flush-draw-piece item territory))

  ;;; ƥ֥꡼ξõ
  (dolist (item (active-region-list window))
    (flush-active-region item territory))

  ;;; ץ쥼ơξõ
  (dolist (item (present-list window))
    (flush-presentation item territory))

  ;;; ɤμ곰
  (delete-lisp-object (world-territory-no window))
  (setf (world-territory-no window) nil)

  ;;; ե졼μ곰
  (delete-lisp-object (frame-territory-no 
		       (window-frame window)))

  (setf (frame-territory-no (window-frame window)) nil)

  ;;; ܡμ곰
  (delete-lisp-object (territory window))
  )
  
;;; End of file.

