;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; ӥǥ˥᡼μ¸
;;; This file is EUC code.
;;; vtr-window.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/11/19 by t.kosaka
;;;
;;;  ʲΥ᥽åɤؿ饹ϡɥΩ夬äƤ

(in-package :yy)

;;; draw-region-xy  Хб
(defun bug-draw-region-xy (window x y width height)
  (draw-region-xy window x y width height))

;  (draw-polygon-xy window x y (+ x width) y (+ x width) (+ y height)
	;			   x (+ y height)))

;(defvar *vide-tape-height* 40)
(defvar *vide-tape-height* 20)

;;; ʸͿ줿礭֤˽Ϥ
(defun center-draw-string (window text x y width height)
  (let* ((font (stream-font window))
		 (font-height (font-kanji-height font))
		 (font-base-line (font-kanji-base-line font))
		 (ww (font-string-length font text))
		 (width-p (round (/ (- width ww) 2)))
		 (base-p (+ (round (/ (- height font-height) 2)) font-base-line)))
	(draw-string-xy window text (+ x width-p)
					(+ y base-p))))

;;; ӥǥơפɽȰ֤
(defmethod show-video-tape ((tape vtr-tape) x y width)
  (with-slots 
   (pos-x pos-y my-window tape-name original-x original-y) tape
   (setf pos-x x pos-y y
		 original-x x original-y y)
   (with-slots
	(tape-title-color tape-color) my-window
	(with-output-as-presentation
	 (tape my-window)
	 (with-graphic-state
	  (color line-width ) my-window
	  (setf color tape-color
			line-width 3)
	  (bug-draw-region-xy my-window x y width *vide-tape-height*)
	  (setf color tape-title-color)
	  (center-draw-string my-window tape-name x y width *vide-tape-height*))
	 ))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; ӥǥΥåѹ  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Ф֥Ȥ
;;; X Yϡ濴
(defun display-toridasi (window ob-color text-color x y ratio
								&optional (d-w 20) (d-h 10))
  (let ((width (round (* d-w ratio)))
		(height (round (* d-h ratio))))
	(with-graphic-state
	 (color filled-type) window
	 (setf color ob-color filled-type *FillSolid*)
	 (draw-ellipse-xy window x y width height)
;	 (setf color text-color)
	; (center-draw-string window "Ф"  
		;				 (- x width) (- y height) (* width 2)
			;			 (* height 2))
	 )))

;;; initialize-instance  after method
;;; Ф֥Ȥν
(defmethod initialize-instance :after ((ob eject) &rest args
									   &key &allow-other-keys)
  (declare (ignore args))
  (with-slots (my-window pos-x pos-y default-w default-h) ob
   (with-slots (eject-color tape-color vtr-monitor) my-window
	(with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
  	  (let ((new-x (+ xx pos-x default-w))
			(new-y (+ yy pos-y default-h)))
	  (with-output-as-presentation
	   (ob my-window)
	   (display-toridasi my-window eject-color tape-color 
						 new-x new-y 1.0)
	))))))

;;; ѹ modeϡ:normal --> ̾
;;;                    :other  --> 
;;; Ф֥Ȥκɽ
(defmethod redisplay-vtr-switch ((ob eject) p-instance mode)
  (with-slots (my-window pos-x pos-y default-w default-h) ob
   (with-slots (eject-color tape-color vtr-monitor) my-window
	(with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
	 (let ((new-x (+ xx pos-x))
		   (new-y (+ yy pos-y)))
	   (cond 
		((eq mode :normal)
		 (with-shape-presentation-alone (ob my-window 'eject p-instance)
		  (display-toridasi my-window eject-color tape-color
							(+ new-x default-w) (+ new-y default-h) 1.0)))
		(t
		 (with-shape-presentation-alone (ob my-window 'eject p-instance)
		  (display-toridasi my-window eject-color tape-color
							(+ new-x default-w) (+ new-y default-h) 0.8)))
		)
	   )))))


;;; ᤷ֥Ȥ
;;; X Yϡ濴
(defun display-makimodosi (window ob-color text-color x y ratio
								  &optional (d-w 25) (d-h 10))
  (let ((width (round (* d-w ratio)))
		(height (round (* d-h ratio))))
	(with-graphic-state (color filled-type) window
	 (setf color ob-color
		   filled-type *FillSolid*)
	 (draw-polygon-xy window (- x width) y x (- y height) x (+ y height))
	 (draw-polygon-xy window x y (+ x width) (- y height)
					  (+ x width) (+ y height))
	 (setf color text-color)
;	 (center-draw-string window  "ᤷ" 
;						 (- x width) (- y 20) (* width 2) 20)
	 )))

;;; initialize-instance  after method
;;; ᤷ֥Ȥν
(defmethod initialize-instance :after ((ob rew) &rest args
									   &key &allow-other-keys)
  (declare (ignore args))
  (with-slots (my-window pos-x pos-y default-w default-h) ob
   (with-slots(speed-color tape-color vtr-monitor) my-window
	  (with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
	   (let ((new-x (+ xx pos-x default-w))
			 (new-y (+ yy pos-y default-h)))
	  (with-output-as-presentation (ob my-window)
	   (display-makimodosi my-window speed-color tape-color new-x new-y 1.0)
	   ))))))

;;; ѹ modeϡ:normal --> ̾
;;;                    :other  --> 
;;; ᤷ֥Ȥκɽ
(defmethod redisplay-vtr-switch ((ob rew) p-instance mode)
  (with-slots
   (my-window pos-x pos-y default-w default-h) ob
   (with-slots (speed-color tape-color vtr-monitor) my-window
	(with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
	 (let ((new-x (+ xx pos-x default-w))
		   (new-y (+ yy pos-y default-h)))
	  (cond 
	   ((eq mode :normal)
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-makimodosi my-window speed-color 
							 tape-color new-x new-y 1.0)
		))
	   (t
		(with-shape-presentation-alone
		 (ob my-window 'rew p-instance)
		 (display-makimodosi my-window speed-color 
							 tape-color new-x new-y 0.8)
		 )))
	  )))))

;;; ֥Ȥ
;;; X Yϡ濴
(defun display-saisei (window ob-color text-color x y ratio
							  &optional (d-w 50) (d-h 10))
  (let ((width d-w)
		(height d-h))
	(with-graphic-state (color filled-type) window
	 (setf color ob-color
		   filled-type *FillSolid*)
	 (draw-polygon-xy window (- x width) (- y height)
					  (+ x width) y  (- x width) (+ y height))
	 (setf color text-color)

	 (when (/= ratio 1.0)
		   (draw-polygon-xy window (- x 5) (- y 5)
							(- x 5) (+ y 5) (+ x 5) y))
;	 (center-draw-string window  "" 
	;					 (- x d-w) (- y 20) (* d-w 2) 20)
	 )))

;;; initialize-instance  after method
;;; ֥Ȥν
(defmethod initialize-instance :after ((ob play) &rest args
									   &key &allow-other-keys)
  (declare (ignore args))
  (with-slots (my-window pos-x pos-y default-w default-h) ob
   (with-slots(play-color tape-color vtr-monitor) my-window
	  (with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
	   (let ((new-x (+ xx pos-x default-w))
			 (new-y (+ yy pos-y default-h)))
	  (with-output-as-presentation (ob my-window)
	   (display-saisei my-window play-color tape-color new-x new-y 1.0)
	   ))))))

;;; ѹ modeϡ:normal --> ̾
;;;                    :other  --> 
;;; ֥Ȥκɽ
(defmethod redisplay-vtr-switch ((ob play) p-instance mode)
  (with-slots
   (my-window pos-x pos-y default-w default-h) ob
   (with-slots (play-color tape-color vtr-monitor) my-window
	(with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
	 (let ((new-x (+ xx pos-x default-w))
		   (new-y (+ yy pos-y default-h)))
	  (cond 
	   ((eq mode :normal)
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-saisei my-window play-color 
							 tape-color new-x new-y 1.0)
		))
	   (t
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-saisei my-window play-color 
							 tape-color new-x new-y 0.8)
		 )))
	  )))))

;;; ꥪ֥Ȥ
;;; X Yϡ濴
(defun display-hayaokuri (window ob-color text-color x y ratio
								 &optional (d-w 25) (d-h 10))
  (let ((width (round (* d-w ratio)))
		(height (round (* d-h ratio))))
	(with-graphic-state (color filled-type) window
	 (setf color ob-color
		   filled-type *FillSolid*)
	 (draw-polygon-xy window (- x width) (- y height) x y 
					  (- x width) (+ y height))
	 (draw-polygon-xy window x (- y height) (+ x width) y
					  x (+ y height))
	 (setf color text-color)
;	 (center-draw-string window  "" 
	;					 (- x d-w) (- y 20) (* d-w 2) 20)
	 )))

;;; initialize-instance  after method
;;; ꥪ֥Ȥν
(defmethod initialize-instance :after ((ob ff) &rest args
									   &key &allow-other-keys)
  (declare (ignore args))
  (with-slots (my-window pos-x pos-y default-w default-h) ob
   (with-slots(speed-color tape-color vtr-monitor) my-window
	  (with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
	   (let ((new-x (+ xx pos-x default-w))
			 (new-y (+ yy pos-y default-h)))
	  (with-output-as-presentation (ob my-window)
	   (display-hayaokuri my-window speed-color tape-color new-x new-y 1.0)
	   ))))))

;;; ѹ modeϡ:normal --> ̾
;;;                    :other  --> 
;;; ꥪ֥Ȥκɽ
(defmethod redisplay-vtr-switch ((ob ff) p-instance mode)
  (with-slots
   (my-window pos-x pos-y default-w default-h) ob
   (with-slots
	(speed-color tape-color vtr-monitor) my-window
	(with-slots
	 ((xx pos-x) (yy pos-y)) vtr-monitor
	 (let ((new-x (+ xx pos-x default-w))
		   (new-y (+ yy pos-y default-h)))
	  (cond 
	   ((eq mode :normal)
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-hayaokuri my-window speed-color 
							tape-color new-x new-y 1.0)))
	   (t
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-hayaokuri my-window speed-color 
							tape-color new-x new-y 0.8))))
	  )))))

;;; ߥ֥Ȥ
;;; X Yϡ濴
(defun display-ichiji (window ob-color text-color x y ratio
							  &optional (d-w 25) (d-h 10))
  (let ((back-color (slot-value window 'tape-color))
		(ww (round (/ d-w 2)))
		(hh (+ (round (/ d-h 2)) 3)))

	(with-graphic-state (color line-width filled-type) window
     (setf color back-color   line-width 2)
;	 (bug-draw-region-xy window (- x d-w) (- y d-h)
;					 (* d-w 2) (* d-h 2))
	 (setf filled-type *FillSolid*)
;	 (draw-region-xy window (+ (- x d-w) 2) (+ (- y d-h) 2)
;						 (- (* d-w 2) 4) (- (* d-h 2) 4))
	 (setf color (if (= ratio 1.0) ob-color text-color))
	 (draw-region-xy window (- x ww 1) (- y hh) 12 (* hh 2))
	 (draw-region-xy window (- (+ x ww) 6) (- y hh) 12 (* hh 2))
	 (setf color text-color)
;	 (center-draw-string window  "" 
	;					 (- x d-w) (- y 20) (* d-w 2) 20)
	 )))

;;; initialize-instance  after method
;;; ߥ֥Ȥν
(defmethod initialize-instance :after ((ob pose) &rest args
									   &key &allow-other-keys)
  (declare (ignore args))
  (with-slots (my-window pos-x pos-y default-w default-h) ob
   (with-slots(speed-color tape-color vtr-monitor) my-window
	  (with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
	   (let ((new-x (+ xx pos-x default-w))
			 (new-y (+ yy pos-y default-h)))
	  (with-output-as-presentation (ob my-window)
	   (display-ichiji my-window speed-color tape-color new-x new-y 1.0)
	   ))))))

;;; ѹ modeϡ:normal --> ̾
;;;                    :other  --> 
;;; ߥ֥Ȥκɽ
(defmethod redisplay-vtr-switch ((ob pose) p-instance mode)
  (with-slots
   (my-window pos-x pos-y default-w default-h) ob
   (with-slots
	(speed-color tape-color vtr-monitor) my-window
	(with-slots
	 ((xx pos-x) (yy pos-y)) vtr-monitor
	 (let ((new-x (+ xx pos-x default-w))
		   (new-y (+ yy pos-y default-h)))
	  (cond 
	   ((eq mode :normal)
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-ichiji my-window speed-color 
						 tape-color new-x new-y 1.0)))
	   (t
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-ichiji my-window speed-color 
						 tape-color new-x new-y 0.8))))
	  )))))

;;; ߥ֥Ȥ
;;; X Yϡ濴
(defun display-teishi (window ob-color text-color x y ratio
							  &optional (d-w 70) (d-h 10))
  (declare (ignore ratio))
  (let ((back-color (slot-value window 'tape-color))
		(ww (- (round (/ d-w 2)) 2))
		(hh (+ (round (/ d-h 2)) 4)))
	(with-graphic-state (color line-width filled-type) window
     (setf color back-color
           line-width 2)
;	 (bug-draw-region-xy window (- x d-w) (- y d-h)
;					 (* d-w 2) (* d-h 2))
	 (setf filled-type *FillSolid*)

;	 (draw-region-xy window (- x d-w) (- y d-h)
;					 (* d-w 2) (* d-h 2))
	 (setf color ob-color)
	 (draw-region-xy window (- x ww) (- y hh) (* ww 2) (* hh 2))
;	 (setf color text-color)
;	 (center-draw-string window  "" 
	;					 (- x d-w) (- y 20) (* d-w 2) 20)
	 )))

;;; initialize-instance  after method
;;; ߥ֥Ȥν
(defmethod initialize-instance :after ((ob stop) &rest args
									   &key &allow-other-keys)
  (declare (ignore args))
  (with-slots (my-window pos-x pos-y default-w default-h) ob
   (with-slots(speed-color tape-color vtr-monitor) my-window
	  (with-slots ((xx pos-x) (yy pos-y)) vtr-monitor
	   (let ((new-x (+ xx pos-x default-w))
			 (new-y (+ yy pos-y default-h)))
	  (with-output-as-presentation (ob my-window)
	   (display-teishi my-window speed-color tape-color new-x new-y 1.0)
	   ))))))

;;; ѹ modeϡ:normal --> ̾
;;;                    :other  --> 
;;; ߥ֥Ȥκɽ
(defmethod redisplay-vtr-switch ((ob stop) p-instance mode)
  (with-slots
   (my-window pos-x pos-y default-w default-h) ob
   (with-slots
	(speed-color tape-color vtr-monitor) my-window
	(with-slots
	 ((xx pos-x) (yy pos-y)) vtr-monitor
	 (let ((new-x (+ xx pos-x default-w))
		   (new-y (+ yy pos-y default-h)))
	  (cond 
	   ((eq mode :normal)
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-teishi my-window speed-color 
						 tape-color new-x new-y 1.0)))
	   (t
		(with-shape-presentation-alone (ob my-window 'rew p-instance)
		 (display-teishi my-window speed-color 
						 tape-color new-x new-y 0.8))))
	  )))))

;;; ˥ after ᥽å
(defmethod initialize-instance :after ((ob vtr-monitor) &rest args)
  (declare (ignore args))
  (with-slots 
   (my-window pos-x pos-y switch-list insert-region) ob

   (setf insert-region
		 (make-region :left (+ pos-x 75) :bottom (+ pos-y 175 )
					  :width 145 :height 30))
   (with-slots	(vtr-monitor monitor-color tape-color) my-window
	(setf vtr-monitor ob)
	(with-graphic-state (color line-width) my-window
	 (setf color monitor-color
		   line-width 5)
	 (with-output-as-presentation (ob my-window)
	  (draw-region-xy my-window pos-x pos-y  225 265)
	  (setf color tape-color
			line-width 2)
	  (draw-region-xy my-window 
					  (+ pos-x 75) (+ pos-y 175)
					  145 30))))
   ;;; Ƽ凉å
   (push (make-instance 'eject :my-window my-window
						:pos-x 5 :pos-y 180) switch-list)
   (push (make-instance 'rew :my-window my-window
						:pos-x 5 :pos-y 210) switch-list)
   (push (make-instance 'play :my-window my-window
						:pos-x 70 :pos-y 210) switch-list)
   (push (make-instance 'ff :my-window my-window
						:pos-x 170 :pos-y 210) switch-list)
   (push (make-instance 'pose :my-window my-window
						:pos-x 5 :pos-y 235) switch-list)
   (push (make-instance 'stop :my-window my-window
						:pos-x 60 :pos-y 235) switch-list)
   ))

;;; ӥǥơץåɽ
;;; tapesϡơפΥꥹȤǤ롣
(defun make-tape-rack (window x y tape-width tapes)
  (let ((obj (make-instance 'vtr-ruck
							:my-window window
							:left x :bottom y
							:tape-list (copy-seq tapes)))
		(height 0)
		(yy y)
		(new-width (+ tape-width 8)))

	;;; ơפΰ֤ɽ
	(dolist (item tapes)
			(show-video-tape item (+ x 5) (+ yy 5) tape-width)
			(incf height (+ *vide-tape-height* 7))
			(incf yy (+ *vide-tape-height* 7)))
		
	;;; ơץåɽ
	(with-slots (ruck-color) window
	 (with-output-as-presentation (obj window)
	  (with-graphic-state  (color line-width) window
	   (setf color ruck-color
			 line-width 5)
	   (bug-draw-region-xy window x y new-width height)
	   (setf yy (+ y *vide-tape-height* 9))
	   (dolist (item (cdr tapes))
			   (draw-line-xy window x yy (+ x new-width) yy)
			   (incf yy (+ *vide-tape-height* 9))))))

	(with-region-slots (right top) obj
				(setf right (* x new-width)
					 top (+ y height)))
	obj))

;;; ơֹ
(defvar *tape-number* 0)

;;; VTR ơפ
(defun make-vtr-tape (window file-name title-name
							 frame-no frame-width frame-height)
  (let* ((vtr (make-window-instance
				  'viewport-window-stream
				  :parent-window window
				  :window-region (make-region :width frame-width
											  :height frame-height)
				  :border-visible nil
				  :border-belt 0
				  :vertical-scroll-bar nil
				  :parent-window window
				  :horizontal-scroll-bar nil
				  :coordinate-area nil
				  :title-bar nil
				  :visible nil))
		 (frame (define-animation-frame vtr
				  1 1 frame-width frame-height frame-no))
		 (file-path (concatenate 'string
								 user::*YY-IMAGE-directory*
								 file-name))
		 (obj (make-instance 'vtr-tape
							 :tape-name title-name
							 :tape-no *tape-number*
							 :my-window window
							 :animation-window vtr
							 :animation-frame frame)))
	(incf *tape-number*)
	(dotimes (i frame-no)
			 (put-frame frame i (format nil "~a~a.ras" file-path i)))
	
	obj))


;;; VTRɥ
(defun init-vtr ()
  (let* ((region (get-box-region (make-region :left 0 :bottom 0
											  :width 500
											  :height 400)))
		 (window (make-window-instance 
				  'vtr-window
				  :window-region region
				  :title-bar 'vtr-switch-title-bar
				  :title-bar-string "VTRץꥱ"))
		 (pos (get-box-region (make-region :left 0 :bottom 0
										   :width 225
										   :height 265) :window window))
		 (monitor (make-instance 'vtr-monitor
								:pos-x (region-left pos)
								:pos-y (region-bottom pos)
								:my-window window))
		 (tape-list nil))
	;;; ޥ᥽åɤ
	(set-window-method window 'tape-move :event-mask *mouse-move*)
	(set-window-method window 'button-down-with-tape 
					   :event-mask *mouse-button-down-1*)

	(setf (get 'button-down-with-tape 'signle-process) T
		  (get 'tape-move 'signle-process) T)

	;;; ٥ȥޥ
	(disnable-event window (event-mask window))

	;;; ơפΥ
	(push (make-vtr-tape window "tanaka-" " " 3 214 161)
		  tape-list)
	(push (make-vtr-tape window "kosaka-" "ź " 8 214 161)
		  tape-list)
	(push (make-vtr-tape window "ootha-" " ͺ" 5 214 161)
		  tape-list)
	(push (make-vtr-tape window "aoyama-" "ץȥ" 18 214 161)
		  tape-list)

	(with-slots 
	 (vtr-monitor tape-ruck) window
	 (setf vtr-monitor monitor 
		   tape-ruck (make-tape-rack window 10 10 130 tape-list)))
	;;; VTR ץꥱΥȥåץ٥롼
	window))

;;; ȥСΥޥ								
(defmethod redisplay-title-bar :after ((title vtr-switch-title-bar))
  (declare (special *mouse-button-down-1* *default-font* *image-yy*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (null (switch1 title))
    (let ((ob1 (make-instance 'switch
    		     :object-parent title
		     :draw-piece-visible T
    		     :switch-stream (object-parent title)
    			 :bottom 1 :left (- (region-width title) 65)
			 :width 30 :height (- (region-height title) 2)))
	  (ob2 (make-instance 'switch
		 :object-parent title
		 :draw-piece-visible T
		 :switch-stream (object-parent title)
		 :bottom 1 :left (- (region-width title) 33)
		 :width 30 :height (- (region-height title) 2))))

      (with-event-object (ob1)
		 (setf (button1-method ob1) 'start-vtr
			   (get 'start-animation 'single-process) T
	    	   (slot-value ob1 'event-mask) *mouse-button-down-1*))

      (with-event-object (ob2)
		 (setf (button1-method ob2) 'stop-vtr
		       (get 'animation-stop 'single-process) t
	    	   (slot-value ob2 'event-mask) *mouse-button-down-1*))

      (setf (switch1 title) ob1
	    (switch2 title) ob2)
      
      (with-slots 
       ((color title-bar-color)) title
       (draw-animation-title ob1 "¹" color)
       (draw-animation-title ob2 "" color)))

    (let ((ob1 (switch1 title))
	  (ob2 (switch2 title)))
      (with-region-slots
       (width) title
       (with-real-object 
	(ob1)
	(set-region-position-xy ob1 (- width 65) 1))
       (with-real-object
        (ob2)
        (set-region-position-xy ob2 (- width 35) 1)))
      )
    ))
       
;;;ץꥱμ¹
(defmethod start-vtr ((ob switch) state)
  (declare (ignore state))
  (draw-prompt "VTRץꥱμ¹ԡơפ򤷤Ƥ")
  (let ((window (switch-stream ob)))
	(with-slots
	 (accept-counter) window
	 (if accept-counter
		 (terminate-accept window))
	 (setf accept-counter T))
	(vtr-top-level window)))

;;; ץꥱ
(defmethod stop-vtr ((ob switch) state)
  (declare (ignore state))
  (draw-prompt "VTRץꥱ")
  (let ((window (switch-stream ob)))
	(disnable-event window (event-mask window))
	(with-slots
	 (accept-counter) window
	 (if accept-counter
		 (terminate-accept window))
	 (setf accept-counter nil))))
		 


