;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%S%G%*7?%"%K%a!<%7%g%s$N<B83(J
;;; This file is EUC code.
;;; vtr-class.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/11/19 by t.kosaka
;;;

;;;  $@0J2<$N%a%=%C%I$d4X?t!"%/%i%9$O!"%&%#%s%I%&$,N)$A>e$,$C$F$+$i%m!<%I(J

(in-package :yy)

;;; $@0\F0$N$?$a$N%/%i%9(J
(defclass pos-data ()
  ((pos-x :initform 0 :initarg :pos-x)
   (pos-y :initform 0 :initarg :pos-y)))

;;; VTR$@$N%F!<%W$N%/%i%9(J
(defclass vtr-tape (pos-data)
  ((tape-name :initform "" :initarg :tape-name)
   (tape-no :initform 0 :initarg :tape-no)
   (original-x :initform 0)
   (original-y :initform 0)
   (my-window :initform nil :initarg :my-window)
   (animation-window :initform nil :initarg :animation-window)
   (animation-frame :initform nil :initarg :animation-frame)))

;;; VTR$@$N%i%C%/$N%/%i%9(J
;;; tape-list$@$K3JG<$5$l$k%F!<%W$O!"%F!<%WHV9f$N=gHV$K$J$k!#(J
;;; tape-list$@$+$i%F!<%W$r<h$j=P$9$H$=$NCM$,(JNIL$@$K$J$k!#(J
(defclass vtr-ruck (region)
  ((tape-list :initform nil :initarg :tape-list)
   (current-out-tape :initform nil :initarg :currrent-out-tape)
   (my-window :initform nil :initarg :my-window)))


;;; VTR$@$N%9%$%C%AN`(J
(defclass vtr-switch (pos-data)
  ((my-window :initform nil :initarg :my-window)
   ;;; ON -> T , OFF -> NIL
   (on-off :initform nil :accessor on-off)))

(defclass eject (vtr-switch)
  ((default-w :initarg :defalut-w :initform 20)
   (default-h :initarg :defalut-h :initform 10)))

(defclass rew (vtr-switch)
  ((default-w :initarg :defalut-w :initform 25)
   (default-h :initarg :defalut-h :initform 10)))

(defclass play (vtr-switch)
  ((default-w :initarg :defalut-w :initform 50)
   (default-h :initarg :defalut-h :initform 10)))

(defclass ff (vtr-switch)
  ((default-w :initarg :defalut-w :initform 25)
   (default-h :initarg :defalut-h :initform 10)))

(defclass pose (vtr-switch)
  ((default-w :initarg :defalut-w :initform 25)
   (default-h :initarg :defalut-h :initform 10)))

(defclass stop (vtr-switch)
  ((default-w :initarg :defalut-w :initform 70)
   (default-h :initarg :defalut-h :initform 10)))

;;; VTR$@@lMQ%b%K%?(J
(defclass vtr-monitor ()
  ((my-window :initform nil :initarg :my-window)
   (insert-region :initform nil :initarg :inset-region)
   (pos-x :initarg :pos-x :initform 0)
   (pos-y :initarg :pos-y :initform 0)
   (screen-x :initform 5 :initarg :screen-x)
   (screen-y :initform 5 :initarg :screen-y)
   (switch-list :initform nil :initarg :switch-list)
   ))

;;; VTR $@%"%K%a!<%7%g%s$rI=<($9$k%&%#%s%I%&(J
(defclass vtr-window (viewport-window-stream)
  ((current-tape :initform nil :initarg :current-tape)
   (vtr-monitor :initform nil :accessor vtr-monitor)
   (current-swtich :initform nil :accessor current-switch)
   (accept-condition :initform 'vtr-tape :accessor accept-condition)
   ;;; select-tape$@$O!"(J(ob present)
   (select-tape :initform nil :accessor select-tape)
   (tape-ruck :initform nil :initarg :tape-ruck)
   (accept-stop :initform nil :accessor accept-stop)
   (accept-counter :initform 0 :accessor accept-counter)
   (ruck-color :initform :brown)
   (tape-title-color :initform :red)
   (tape-color :initform :black)
   (monitor-color :initform  :purple)
   (play-color :initform   :blue)
   (speed-color :initform  :green)
   (eject-color :initform  :yellow)
   (other-color :initform :white)))

(defclass vtr-switch-title-bar (title-bar)
  ((switch1 :initform nil :accessor switch1)
   (switch2 :initform nil :accessor switch2)))

;;; End of file
   





