;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%F%j%H%j!<$K0MB8$9$kItJ,$rDj5A(J
;;; territory.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; 7/27 1990 $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-7-27

(in-package :yy )

#|
;;; $@%F%j%H%*%jHV9f$H(JLISP$@%*%V%8%'%/%H$r4IM}$9$k9=B$BN(J
(defstruct territory-object 
           territory-no      ;;; $@%F%j%H%j!<HV9f(J
           lisp-object       ;;; LISP$@%*%V%8%'%/%H(J
	   bigger            ;;; $@Bg$-$$$b$N$,F~$k(J
	   smaller           ;;; $@>.$5$$$b$N$,F~$k(J
	   )
|#
;;; $@%F%j%H%*%jHV9f$H(JLISP$@%*%V%8%'%/%H$r4IM}$9$k9=B$BN(J
;;; (territory-no lisp-object bigger smaller)
;;; $@$N%j%9%H$K$9$k!#(J

;;; $@9=B$BN$N5?;w4X?t(J
(defun make-territory-object (&key (territory-no 0)
								   (lisp-object nil)
								   (bigger nil)
								   (smaller nil))
  (list territory-no lisp-object bigger smaller))

;;; $@%"%/%;%94X?t$N5?;w(J
(defmacro territory-object-territory-no (object)
  `(car ,object))

(defmacro territory-object-lisp-object (object)
  `(second ,object))

(defmacro territory-object-bigger (object)
  `(third ,object))

(defmacro territory-object-smaller (object)
  `(fourth ,object))

;;; $@%F%j%H%*%jHV9f$H(JLISP$@%*%V%8%'%/%H$r4XO"IU$1$k!#(J
(defun set-territory-object (no object)
  (declare (special *territory-lisp-object*)
	   (inline > < )
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
    (if *territory-lisp-object*
      (let ((next *territory-lisp-object*))
		(loop  
		 (cond 
		  ;; next$@$,(J NIL$@$N$H$-(J
		  ((null next)
		   (return nil))

		  ;; no$@$O(Jnext$@$NHV9f$h$jBg$-$$(J
		  ((> no (territory-object-territory-no next))
		   ;; $@?7$7$/@8@.$+(J
		   (if (null (territory-object-bigger next))
			   (return (setf (territory-object-bigger next) 
							 (make-territory-object :territory-no no
													:lisp-object object)))
			 ;; $@4{$K$"$k(J
			 (setf next (territory-object-bigger next))))

		  ;; no$@$O(Jnext$@$NHV9f$h$j>.$5$$(J
		  ((< no (territory-object-territory-no next))
		   ;; $@?7$7$/@8@.$+(J
		   (if (null (territory-object-smaller next))
			   (return (setf (territory-object-smaller next)
							 (make-territory-object :territory-no no
													:lisp-object object)))
			 ;; $@4{$K$"$k(J
			 (setf next (territory-object-smaller next))))

		  ;; $@B?J,F1$8HV9f(J
		  (t 
		   (if (null (territory-object-lisp-object next))
			   (return
				(setf (territory-object-lisp-object next) object))
		
			 (return nil)))
		  )))
	  (setf *territory-lisp-object*  
			(make-territory-object :territory-no no
								   :lisp-object object)))
	)
    

;;; $@$"$kHV9f$+$i(Jlisp-object$@$r5a$a$k!#$J$$;~$O(JNIL
(defun get-lisp-object (no)
  (declare (special *territory-lisp-object*)
	   (inline > <)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((next *territory-lisp-object*))
    (loop
     (cond
      ;;; next$@$,(JNIL$@$N$H$-(J
      ((null next)
       (return nil))

      ;;; no$@$O(Jnext$@$NHV9f$h$jBg$-$$(J
      ((> no (territory-object-territory-no next))
	;;; bigge$@%*%V%8%'%/%H$,$"$k$+(J
	(if (null (territory-object-bigger next))
	    (return nil)
	    ;;; $@4{$K$"$k(J
	    (setf next (territory-object-bigger next))))

      ;;; no$@$O(Jnext$@$NHV9f$h$j>.$5$$(J
      ((< no (territory-object-territory-no next))
	;;; smaller$@%*%V%8%'%/%H$,$"$k$+(J
	(if (null (territory-object-smaller next))
	     (return nil)
	   ;;; $@4{$K$"$k(J
	   (setf next (territory-object-smaller next))))

	;;; $@B?J,F1$8HV9f(J
	(t 
	  (if (null (territory-object-lisp-object next))
	      (return nil)
	    (return (territory-object-lisp-object next))))
	))))
	    
;;; $@$"$kHV9f$+$i(Jlisp-object$@$r%G%j!<%H$9$k!#$J$$;~$O(JNIL
(defun delete-lisp-object (no)
  (declare (special *territory-lisp-object*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((next *territory-lisp-object*))
    (loop
     (cond
      ;; next$@$,(JNIL$@$N$H$-(J
      ((null next)
       (return nil))

      ;;; no$@$O(Jnext$@$NHV9f$h$jBg$-$$(J
      ((> no (territory-object-territory-no next))
	;;; bigge$@%*%V%8%'%/%H$,$"$k$+(J
	(if (null (territory-object-bigger next))
	    (return nil)
	    ;;; $@4{$K$"$k(J
	    (setf next (territory-object-bigger next))))

      ;;; no$@$O(Jnext$@$NHV9f$h$j>.$5$$(J
      ((< no (territory-object-territory-no next))
	;;; smaller$@%*%V%8%'%/%H$,$"$k$+(J
	(if (null (territory-object-smaller next))
	     (return nil)
	   ;;; $@4{$K$"$k(J
	   (setf next (territory-object-smaller next))))

	;;; $@B?J,F1$8HV9f(J
	(t 
	  (if (null (territory-object-lisp-object next))
	      (return nil)
	    (progn
	     (setf (territory-object-lisp-object next) nil)
	     (return T))))
	))))

;(defvar *territory-attributte* nil)

;;; $@%F%j%H%j$N@8@.(J
(defun make-territory (&key (x 0) (y 0) (width 0) (height 0)
			    (parent -1) (visible t) (drawable t)
			    (fence nil) (window-mode nil)
			    (transparent nil))
  (declare (special *ROOT-TERRITORY-NO* *current-territory-no*)
	   (inline /=)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
    (if (and (/= *ROOT-TERRITORY-NO* -1) (= parent -1))
      (setf parent *ROOT-TERRITORY-NO*))

    (if (null parent)
	(setq parent *ROOT-TERRITORY-NO*))

    (if (null visible)
      (setf visible 0)
      (setf visible 1))
    
    (let ((mode 0))
      
      (if (null drawable)
	  (if fence
	      (setf mode #x0001)
	    (setf mode #x0000))
	(if (null window-mode)
	    (setf mode #x0100)    ;;; $@%Z!<%8(J
	  (if transparent
	      (setf mode #x0103)           ;;; $@F)L@%F%j%H%j!<(J
	    (setf mode #x0101)))) 	  ;;; $@%S%e!<%]!<%H%b!<%I(J
      ;;; $@%W%m%H%3%k@8@.$HAw=P(J
	  (yy-protocol-1 x y  width height parent visible 
					 *current-territory-no* mode)
	  (prog1 *current-territory-no*
		(incf *current-territory-no*))))


#|

;;; debug for territory attriburte
     (if (= parent 0)
	 (setf *territory-attribute* nil))


           (let ((val nil))
	     (if (zerop (setf val 
			(yy-protocol-1 x y  width height parent visible mode)))
		 (error "Can not make a TERRITORY!!!")
	       (progn 
		 ;;; Debug
		 (setf *territory-attribute* 
		       (acons val mode *territory-attribute*))
	       val)))
      ))
|#


;;; End of file





