;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10 -*-
;;;                 Copyright (C) 1989,1990,1991 
;;;            Aoyama Gakuin University. All rights reserved.
;;; Authors:
;;;   version 1.4 91/07/19 by y.ohta (yohta@csrl.aoyama.ac.jp)
;;; ***                                                               ***
;;; ***        DIRECTIONS FOR INSTALLING YY AT YOUR SITE              ***
;;; ***                                                               ***
;;;
;;; To get YY working at your site you should:
;;; 
;;;  - Get all the YY source files from AGU.  The complete list of source
;;;    file names can be found in the defsystem for YY which appears towards
;;;    the end of this file.
;;; 
;;;  - Edit the variable *yy-directory* below to specify the directory at
;;;    your site where the YY sources and binaries will be.  This variable
;;;    can be found by searching from this point for the string "***" in
;;;    this file.
;;; 
;;;  - Use the function (compile-yy) to compile YY for your site.
;;; 
;;;  - Once YY has been compiled it can be loaded with (load-yy).

;;; ***                SITE SPECIFIC YY DIRECTORY                         ***
;;;
;;; *yy-directory* is a variable which specifies the directory yy is stored
;;; in at your site.  If the value of the variable is a single pathname, the
;;; sources and binaries should be stored in that directory.  If the value of
;;; that directory is a cons, the CAR should be the source directory and the
;;; CDR should be the binary directory.
;;;
;;; ***                                                                   ***

(in-package :user)

(load "config.lisp")
(load (compile-file "defpackage.lisp"))
(load (compile-file "yydefsys.lisp"))
(load (compile-file "yy-system-definition.lisp"))


;;; Set location of YY source files and binary files.
(defvar *YY-directory*
  (car (acons (format nil "~a/client/" *YY*) 
			  (format nil "~a/client/BIN/" *YY*)
			  nil)))

#+CMU  ;;; $@B>8@8l4X?t$N@_Dj$r%3%s%Q%$%k$9$k(J
(compile-file (format nil "~adefine-foreign.lisp"
					  (car *YY-directory*))
			  :output-file
			  (format nil "~adefine-foreign.sparcf" (cdr *YY-directory*)))

;;; Set location of IMAGE files
(defvar *YY-IMAGE-directory* (format nil "~a/image/" *YY*))

;;; Set location of CG application system
(defvar *CG-FILES* (format nil "~a/CG/" *YY*))
(defvar *CG-BIN* (format nil "~a/CG/BIN/" *YY*))

#+CMU
(setf ext:*bytes-consed-between-gcs* 1800000)

(compile-yy)

(load-yy)

(defun init-yy ()
  (let* ((len 
		  #+EXCL
		  (sys::command-line-argument-count)
		  #+CMU
		  (length ext::*command-line-strings*)
		  #+LUCID
		  10)
		 #+EXCL
		(yy-server (if (> len 2)
					   (sys::command-line-argument 1)
					 nil))
		#+CMU
		(yy-server (if (> len 4)
					   (fifth ext::*command-line-strings*)
					 nil))
		#+LUCID
		(yy-server (command-line-argument 3))
		#+EXCL
		(x-server  (if yy-server
					   (sys::command-line-argument 2)
					 nil))
		#+CMU
		(x-server (if yy-server
					  (sixth ext::*command-line-strings*)
					nil))
		#+LUCID
		(x-server (command-line-argument 4))
		)

	#+CMU         ;;;$@B>8@8l4X?t$rFI$`(J
	(extensions:load-foreign 
	 (format nil "~a/prtclif.o" (cdr *YY-directory*)))

	#+CMU         ;;; $@$=$N@_Dj%U%!%$%k$rFI$`(J
	(load (format nil "~a/define-foreign" (cdr *YY-directory*)))

	(format t "YY Server ~a X Server ~a ~%" yy-server x-server)

	(if (or (string= yy-server "--") 
			(null yy-server))
		(yy::initialize-yy) 		;; LOCAL
	  (yy::initialize-yy :server-name yy-server ;; Network
						 :x-server-name x-server
						 :network t))
	#+EXCL
	(tpl::top-level-read-eval-print-loop)
	#+CMU
	(COMMON-LISP::%TOP-LEVEL)
	))


;;;; Disk save lisp image
(format t "~%Saving YY image.~%")

#+EXCL
(excl::dumplisp :restart-actions 
				(append *restart-actions*
						'((:eval . (init-yy))))
			   :name (format nil "~a/bin/yy-system" *YY*))

#+CMU
(ext::save-lisp (format nil "~a/bin/yy.core" *YY*)
				:process-command-line t
				:init-function #'init-yy
				)

#+LUCID
(disksave (format nil "~a/bin/yy-system" *YY*)
		  :restart-function #'init-yy)

#+CMU   ;;; $@<B9T$N(J shell $@%9%/%j%W%H$rDj5A$9$k(J
(let ((fname (format nil "~a/bin/yy-system" *YY*)))
  (with-open-file 
   (stream fname
		   :direction :output
		   :if-exists :overwrite
		   :if-does-not-exist :create)
   (format stream "~a -core ~a/bin/yy.core $1 $2 $3" 
		   (car ext::*command-line-strings*)
		   *YY*))
  (ext::run-program "chmod"
					(list "+x" fname)))

#+EXCL
(exit)

#+(OR CMU LUCID)
(quit)
