;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; prtclif-ohta.lisp
;;; Foreign function interface and Process controlers.
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; Written By Yukio Ohta 1990.03.01
;;;      under supervision of Masayuki Ida
;;;
;;; change log
;;; 3/30 '90 T.kosaka DEFFOREGIN change ..
;;; 5/10 '90 T.kosaka Kill-process added ..
;;; 10/31'90 Contribution of E.Shiota
;;; 	     Run-process,
;;; $@%j%9%W=hM}7O$K0MB8$7$?%W%m%;%9$K4X78$7$F$$$k(J
;;; $@4X?t$d%^%/%m$r0l3g4IM}$9$k(J

(in-package :yy)

;;; yy-start-process 
;;; $@@8@.$7$?%W%m%;%9$N8e;OKv$r$9$k(J
;;; ARGS function  ; $@4X?tL>(J
;;;      args      ; fuction$@$N0z?t(J
(defun yy-start-process (function &rest args)
  (unwind-protect
      (progn
	(pushnew (current-process) *yy-process-table*)
	(apply (symbol-function function) args))
    (pop *yy-process-table*)))


