;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%W%j%_%F%#%V$N4XO"(J
;;; primitive.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka
;;;   version 1.3 91/05/15 by T.kosaka

;;
;; YY$@%&%#%s%I%&%7%9%F%`$N4pK\%/%i%9$rDj5A$9$k!#(J
;;               1990.1.17  $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-1-17
;;; Chnage LOG 
;;; Add near corner method 6/27 '90 $@M?$($i$l$?%]%8%7%g%s$K:G$b6a$$(J
;;;                                 $@%j!<%8%g%s$N3Q$N%]%8%7%g%s$rJV$9(J
;;; $@%j!<%8%g%s$NDj5A$rJQ99$9$k(J
;;; $@%9%m%C%H$H$7$F!"(Jleft,right,bottom,top$@$r;}$D(J
;;; $@%j!<%8%g%s$N%9%m%C%H$r%j%9%H$K$9$k!#(J

(in-package :yy)

;;; Position $@%$%s%9%?%s%9$N%W%j%s%H%a%=%C%I(J
(defmethod print-object ((position position) stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (format stream "\#<Position (~a,~a)>" 
	  (position-x position) (position-y position))
)

;;; Position $@@8@.4X?t(J
(defun make-position (&key (x 0) (y 0))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (and (integerp x) (integerp y))
      (make-instance 'position :position-x x :position-y y)
    (error "The argument :x ~a :y: ~a are not a number" x y)))


;;; Position-p $@%*%V%8%'%/%H$,(Jposition$@$G$"$k$+(J?
(defun position-p (pos)
  (typep pos 'position))

;;; Region $@%/%i%9(J
;;; bottom$@$O!"(J0$@$K6a$$$H$3$m$G$"$k!#(J

#|

 0,0
  +------------------------- x
  | (left,bottom)
  |     +--------------+
  |     |              |
  |     +--------------+
  |              (right,top)              
  y

  y
  |             (right,top)
  |     +-------------+
  |     |             |
  |     +-------------+
  |(left,bottom)
  +------------------------ x
 0,0



(defclass region 
  ()
  ((left-bottom  :type position :initarg :lb :reader left-bottom)
   (right-top  :type position :initarg :rt :reader right-top))
)

|#


;;; item$@$K0lCW$9$k<!$NMWAG$+$i$N%j%9%H$rJV$9(J
(defun find-list (item list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
        (do ((x list (cdr x)))
            ((null x) nil)
	  (if (eq (car x) item)
	      (return (second x))))
	)

;;; $@%j!<%8%g%sMQ$N(Jitem$@$K0lCW$9$kCM$rJV$9(J
;;; $@$J$1$l$P#0(J
(defun find-list-region (item list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (do ((x list (cdr x)))
            ((null x) 0)
          (if (eq (car x) item)
              (return (second x))))
        )

;;; $@%j!<%8%g%s$N@8@.%a%=%C%I(J
(defmethod initialize-instance :after ((ob region) &rest rest 
				       &key &allow-other-keys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ll (find-list-region :left rest))
		(rr (find-list-region :right rest))
		(bb (find-list-region :bottom rest))
		(tt (find-list-region :top rest))
		(ww (find-list-region :width rest))
		(hh (find-list-region :height rest))
		(list (make-list 4)))
    
    (if (/= ww 0)
	(setf rr (+ ll ww)))
	
    (if (/= hh 0)
	(setf tt (+ bb hh)))

    (setf (car list) ll
	  (second list) bb
	  (third list) rr
	  (fourth list) tt
	  (region-internal ob) list)
    ))
  
;;; Region $@%$%s%9%?%s%9$N%W%j%s%H%a%=%C%I(J
(defmethod print-object ((region region) stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left bottom right top) region
   (format stream "\#<Region Left:~a Bottom:~a Right:~a Top:~a>" 
	   left bottom right top)))

;;; Region $@4XO"%a%=%C%I(J

;;; Region $@@8@.4X?t(J
(defun make-region (&key (left 0) (right 0) (bottom 0) (top 0) width height)
  (declare 
   #-CMU
   (inline +)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if width
      (setf right (+ left width)))
  (if height
      (setf top (+ bottom height)))
  (if (and (integerp left) (integerp bottom) (integerp right) (integerp top))
      (make-instance 'region 
		     :left left :right right :bottom bottom :top top)
    (error "The argument is not a number. Should set a number"))
  )

;;; $@%j!<%8%g%s#1$K%j!<%8%g%s#2$NBg$-$5$r@_Dj$9$k(J
(defun set-region (region1 region2)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots ((l1 left) (r1 right) (t1 top) (b1 bottom)) region1
     (with-region-slots ((l2 left) (r2 right) (t2 top) (b2 bottom)) region2
	 (setf l1 l2 r1 r2 t1 t2 b1 b2)))
  region1)

;;; Region$@$N%3%T!<%a%=%C%I(J
(defmethod region-copy ((region region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left bottom right top) region
   (make-region :left left
		:top top
		:bottom  bottom
		:right right)))

;;; $@%j!<%8%g%s$N(Jleft
(defmethod region-left ((ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (car (region-internal ob)))

;;; $@%j!<%8%g%s$N(Jleft$@$N(Jsetf$@%a%=%C%I(J
(defmethod (setf region-left) (val (ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (car (region-internal ob)) val))

;;; $@%j!<%8%g%s$N(Jbottom
(defmethod region-bottom ((ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (second (region-internal ob)))

;;; $@%j!<%8%g%s$N(Jbottom$@$N(Jsetf$@%a%=%C%I(J
(defmethod (setf region-bottom) (val (ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (second (region-internal ob)) val))

;;; $@%j!<%8%g%s$N(Jright
(defmethod region-right ((ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (third (region-internal ob)))

;;; $@%j!<%8%g%s$N(Jright$@$N(Jsetf$@%a%=%C%I(J
(defmethod (setf region-right) (val (ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (third (region-internal ob)) val))

;;; $@%j!<%8%g%s$N(Jtop
(defmethod region-top ((ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (fourth (region-internal ob)))

;;; $@%j!<%8%g%s$N(Jtop$@$N(Jsetf$@%a%=%C%I(J
(defmethod (setf region-top) (val (ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (fourth (region-internal ob)) val))

;;; $@%j!<%8%g%s$NI}(J
(defmethod region-width ((ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((list (region-internal ob)))
    (- (third list) (car list))))

;;;; $@%j!<%8%g%s$NI}$N(Jsetf$@%a%=%C%I(J
(defmethod (setf region-width) (val (ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((list (region-internal ob)))
    (setf (third list) (+ (car list) val))))

;;; $@%j!<%8%g%s$N9b$5(J
(defmethod region-height ((ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((list (region-internal ob)))
    (- (fourth list) (second list))))

;;; $@%j!<%8%g%s$N9b$5$N(Jsetf$@%a%=%C%I(J
(defmethod (setf region-height) (val (ob region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((list (region-internal ob)))
    (setf (fourth list) (+ (second list) val))))

;;; region-p $@%*%V%8%'%/%H$,(Jregion$@$G$"$k$+(J?
(defun region-p (region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (typep region 'region))

;;; region-center $@%a%=%C%I(J region $@$N??Cf$r5a$a$k!#(J
(defmethod region-center ((region region) &key (return :multiple))
  (declare 
    #-CMU
    (inline + / round)
    (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
    (left bottom width height) region
    (let ((center-x (+ (round (/ (the integer width) 2)) (the integer left)))
	  (center-y (+ (round (/ (the integer height) 2)) 
		       (the integer bottom))))
      (case return
	(:multiple (values center-x center-y))
	(:position (make-position :x center-x :y center-y))
	(t (list center-x center-y)))
      )))

;;; region-contains-position-p $@%j!<%8%g%s$K%]%8%7%g%s$,F~$C$F$$$P$l(JT,
;;; $@$=$&$G$J$1$l$P!"(JNIL
(defmethod region-contains-position-p ((region region) (position position))
  (declare 
   #-CMU
   (inline >= <= )
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots (left top right bottom) region
    (if (and (>= top (position-y position))
	     (>= right (position-x position))
	     (<= bottom (position-y position))
	     (<= left (position-x position)))
	t
        NIL)))

;;; region-contains-position-xy-p $@%j!<%8%g%s$K(JX$@$H(JY$@$,F~$C$F$$$P$l(JT,
;;; $@$=$&$G$J$1$l$P!"(JNIL
(defmethod region-contains-position-xy-p ((region region) (X integer) (Y integer))
  (declare 
   #-CMU
   (inline >= <=)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots (left top right bottom) region
    (if (and (>= top Y)
	     (>= right X)
	     (<= bottom Y)
	     (<= left X))
	t
        NIL)))

;;; region-overlap-p-in (region-s region-d)
(defun region-overlap-p-in (region-s region-d)
  #-CMU
  (declare 
   #-CMU
   (inline >= - min max)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((l1 left) (b1 bottom) (r1 right) (t1 top)) region-s
   (with-region-slots 
	((l2 left) (b2 bottom) (r2 right) (t2 top)) region-d
	(if (and (>= (- (min r1 r2) (max l1 l2)) 0)
			 (>= (- (min t1 t2) (max b1 b2)) 0))
		T
	  nil))))

;;; region-overlap-p $@%j!<%8%g%s(J1$@$H%j!<%8%g%s(J2$@$,0lIt$G$b=E$J$C$F$$$l$P(JT
;;; $@$=$&$G$J$1$l$P(JNIL
(defmethod region-overlap-p ((region1 region) (region2 region))
    (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
	(if (region-overlap-p-in region1 region2)
		T
	  (if (region-overlap-p-in region2 region1)
		  T
		NIL)
	  ))

;;;region-contains-region- $@%j!<%8%g%s(J1$@$K%j!<%8%g%s(J2$@$,F~$C$F$$$l$P(JT
;;;$@$=$&$G$J$1$l$P(JNIL
#-CMU
(defmethod region-contains-region-p ((region1 region) (region2 region))
  (declare 
   #-CMU
   (inline >= <=)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((left1 left) (top1 top) (right1 right) (bottom1 bottom)) region1
   (with-region-slots 
    ((left2 left) (top2 top) (right2 right) (bottom2 bottom)) region2
    (if (and (<= left1 left2)
			 (>= top1 top2)
			 (>= right1 right2)
			 (<= bottom1 bottom2))
		T
      NIL))))
#+CMU
(defun region-contains-region-p (region1 region2)
  (with-region-slots 
   ((left1 left) (top1 top) (right1 right) (bottom1 bottom)) region1
   (with-region-slots 
    ((left2 left) (top2 top) (right2 right) (bottom2 bottom)) region2
    (if (and (<= left1 left2)
			 (>= top1 top2)
			 (>= right1 right2)
			 (<= bottom1 bottom2))
		T
      NIL))))

;;; region-intersection $@%j!<%8%g%s$N8r$o$j$r5a$a$k!#(J
(defmethod region-intersection ((region1 region) (region2 region)
			       &key (return :mutiple) )
  (declare 
   #-CMU
   (inline max min)
   (optimize (compilation-speed 0) (speed 3) (safety 0))
   #-CMU
   (function (region-contains-region-p (t t) t))
   )
  (let ((left 0) (top 0) (right 0) (bottom 0) (re nil))
    (with-region-slots
     ((left1 left) (top1 top) (right1 right) (bottom1 bottom)) region1
     (with-region-slots
      ((left2  left) (top2 top) (right2 right) (bottom2 bottom)) region2
      (setf left (max left1 left2)
	    top  (min top1 top2)
	    right (min right1 right2)
	    bottom (max bottom1 bottom2))

      ;;; $@?7$7$$%j!<%8%g%s$N@_Dj(J
      (setf re (make-region :left left :right right :top top :bottom bottom))
      
      ;;; $@?7%j!<%8%g%s$N%A%'%C%/(J
      (if (not (and (region-contains-region-p region1 re)
		    (region-contains-region-p region2 re)))
	  nil
	(case return
	      (:mutiple (values left top right bottom))
	      (:region  re)
	      (t (list left top right bottom)))
	)))))


;;; $@%j!<%8%g%s$N%]%8%7%g%s$r5a$a$k(J $@%j!<%8%g%s$N%]%8%7%g%s$O(Jleft bottom$@$G$"$k!#(J
(defmethod region-position ((region region) &key (return :multiple))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left bottom) region
   (case return 
	 (:multiple (values left bottom))
	 (:position (make-position :x left
				   :y bottom))
	 (t (list left bottom)))))

;;; $@%j!<%8%g%s$N%]%8%7%g%s$N(Jsetf 
(defmethod (setf region-position) ((new-position position)
				   (region region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left bottom width height) region
   (let ((ww width)
	 (hh height))

     (setf left (position-x new-position)
	   bottom (position-y new-position)
	   width ww
	   height hh)
    region)))
    

;;;$@%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(JX Y$@$K@_Dj$9$k!#(J
(defmethod set-region-position-xy ((region region) (x number) (y number))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left bottom right top) region
   (incf right (- x left))
   (incf top (- y bottom))
   (setf left x bottom y))
  region)

;;;$@%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(Jposition$@$K@_Dj$9$k!#(J
(defmethod set-region-position ((region region) (new-position position))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots
   (left bottom right top) region
   (let ((x (position-x new-position))
	 (y (position-y new-position)))
     (incf right (- x left))
     (incf top (- y bottom))
     (setf left x bottom y))
   region))

;;;$@%j!<%8%g%s$N%]%8%7%g%s$rM?$($i$l$?(Jdelta-x delta-y$@$K$:$i$9!#(J
(defmethod shift-region-position ((region region) delta-x delta-y)
  (declare 
   #-CMU
   (inline +)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots (left bottom right top) region
	(incf left delta-x)
	(incf right delta-x)
	(incf bottom delta-y)
	(incf top delta-y))
  region)

;;; $@Fs$D$N%j!<%8%g%s$K$*$1$k!"3F!9$N:9$r5a$a$k!#(J
;;; ( (- left1 left2) (- top1 top2) (- right1 right2) (- bottom1 bottom2))
;;; $@$NCM$,5a$^$k!#(J***1 $@$O!":G=i$N%j!<%8%g%s(J ***2 $@$O!"<!$N%j!<%8%g%s(J
(defmethod region-difference ((region1 region) (region2 region))
  (declare 
   #-CMU
   (inline -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((left1 left) (top1 top) (right1 right) (bottom1 bottom)) region1
   (with-region-slots 
    ((left2 left) (top2 top) (right2 right) (bottom2 bottom)) region2
    (values (- left1 left2) (- top1 top2) 
	    (- right1 right2) (- bottom1 bottom2)))))


;;; $@Fs$D$N%j!<%8%g%s$rHf$Y$k!#F1$8$J$i$P(J T $@$=$&$G$J$1$l$P(JNIL
(defmethod region-equal ((region1 region) (region2 region))
  (declare 
   #-CMU
   (inline =)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
    (with-region-slots
     ((left1 left) (top1 top) (right1 right) (bottom1 bottom)) region1
     (with-region-slots
      ((left2 left) (top2 top) (right2 right) (bottom2 bottom)) region2
      (if (and (= left1 left2)
	       (= top1 top2)
	       (= right1 right2)
	       (= bottom1 bottom2))
	  T
	NIL))))

;;; $@Fs$D$N%j!<%8%g%s$N$*$*$-$5$rHf$Y$k!#F1$8$J$i$P(J T $@$=$&$G$J$1$l$P(JNIL
(defmethod region-same-area ((region1 region) (region2 region))
  (declare    
   #-CMU
   (inline =)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((w1 width) (h1 height)) region1
   (with-region-slots
    ((w2 width) (h2 height)) region2
    (if (and (= w1 w2)
	     (= h1 h2))
	T
      NIL))))

;;; $@Fs$D$N%j!<%8%g%sLL@Q$NHf3S!#%j!<%8%g%s(J1$@$O!"%j!<%8%g%s(J2$@$h$j>.$5$1$l$P(J
;;; T$@!#$=$l0J30$J$i$P(JNIL
(defmethod region-smaller-p ((region1 region) (region2 region))
  (declare 
   #-CMU
   (inline abs * <)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((w1 width) (h1 height)) region1
   (with-region-slots
    ((w2 width) (h2 height)) region2
   (let ((menseki1 (abs (* w1 h1)))
	 (menseki2 (abs (* w2 h2))))
     (if (< menseki1 menseki2)
	 T
       NIL)))))

;;; $@Fs$D$N%j!<%8%g%sLL@Q$NHf3S!#%j!<%8%g%s(J1$@$O!"%j!<%8%g%s(J2$@$h$jBg$-$1$l$P(J
;;; T$@!#$=$l0J30$J$i$P(JNIL
(defmethod region-larger-p ((region1 region) (region2 region))
  (declare 
   #-CMU
   (inline abs * >)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((w1 width) (h1 height)) region1
   (with-region-slots
    ((w2 width) (h2 height)) region2
   (let ((menseki1 (abs (* w1 h1)))
	 (menseki2 (abs (* w2 h2))))
     (if (> menseki1 menseki2)
	 T
       NIL)))))

;;; $@Fs$D$N%j!<%8%g%s$r4^$`%j!<%8%g%s$r5a$a$k!#(J
(defmethod region-union ((region1 region) (region2 region))
  (declare 
   #-CMU
   (inline min max)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots
   ((l1 left) (b1 bottom) (r1 right) (t1 top)) region1
   (with-region-slots
    ((l2 left) (b2 bottom) (r2 right) (t2 top)) region2
    (make-region :left (min l1 l2)
		 :top (max t1 t2)
		 :right (max r1 r2)
		 :bottom (min b1 b2))
    )))

;;; $@Fs$D$N%j!<%8%g%s$r4^$`%j!<%8%g%s$r5a$a$k!#(J
;;; region1 $@$,GK2u$5$l$k(J
(defmethod region-union-no-copy ((region1 region) (region2 region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((l1 left) (b1 bottom) (r1 right) (t1 top)) region1
   (with-region-slots 
    ((l2 left) (b2 bottom) (r2 right) (t2 top)) region2
    (setf l1 (min l1 l2) b1 (min b1 b2) t1 (max t1 t2) r1 (max r1 r2))
    region1)))
  

;;; $@IA2h%j!<%8%g%s$KIA2h%(%j%"$r@_Dj%a%=%C%I(J
(defmethod  set-drawing-region ((drawing-region region) (set-region region))
  (declare 
   #-CMU
   (inline max min)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots
   ((l1 left) (b1 bottom) (r1 right) (t1 top)) drawing-region
   (with-region-slots
    ((l2 left) (b2 bottom) (r2 right) (t2 top)) set-region
    (setf l1 (min l1 l2)
	  r1 (max r1 r2)
	  t1 (max t1 t2)
	  b1 (min b1 b2)))
     ))

;;; $@IA2h%j!<%8%g%s$,@_Dj$5$l$F$$$J$$;~$O!#2?$b$7$J$$(J
(defmethod  set-drawing-region ((drawing-region NULL) (set-region region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (values drawing-region set-region)
  )

;;; $@M?$($i$l$?%j!<%8%g%s$N%3%T!<$r:n$k(J
(defmethod copy-region ((region region))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left right bottom top) region
   (make-region :left left :right right
		:top top :bottom bottom)))


;;; $@Fs$D$N%j!<%8%g%s(J(region1,region2)$@$r4^$_!"(J
;;; region1$@$+$i$O$_=P$7$F$$$kJ}$K0lDjNL$r2C$($k(J
;;; x$@J}8~$O!"(Jexpand-width ,y$@J}8~$K$O(Jexpand-height 
;;; $@$b$7$O$_=P$7$F$$$J$1$l$P!"Bg$-$$J}$N%j!<%8%g%s$rJV$9(J
(defmethod region-union-expand ((region1 region) (region2 region)
				(region3 region)
				(expand-width integer)
				(expand-height integer))
  (declare 
   #-CMU
   (inline /= decf incf)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((left1 left) (right1 right) (top1 top) (bottom1 bottom)) region1
   (with-region-slots
    ((left2 left) (right2 right) (top2 top) (bottom2 bottom)) region2

    (let ((left (min left1 left2))
	  (top (max top1 top2))
	  (right (max right1 right2))
	  (bottom (min bottom1 bottom2))
	  (ins (region-internal region3)))

	 (when (/= left1  left)
   	        ;;; REGION2$@$,:8$K$O$_=P$7$F$$$k(J
	       (decf left expand-width))

	 (when (/= top1 top)
	        ;;; region2$@$,>e$K$O$_=P$7$F$$$k(J
	       (incf top expand-height))

	 (when (/= right1 right)
   	        ;;; region2$@$,1&$K$O$_=P$7$F$$$k(J
	       (incf right expand-width))

	 (when (/= bottom1 bottom)
	       ;;; region2 $@$,2<$K$O$_=P$7$F$$$k(J
	       (decf bottom expand-height))

	  (setf (car ins) left
		(third ins) right
		(fourth ins) top
		(second ins) bottom)
	 )
    region3)))


;;; $@M?$($i$l$?%]%8%7%g%s$K:G$b6a$$%j!<%8%g%s$N3Q$N%]%8%7%g%s$rJV$9(J
(defmethod near-corner ((region region) (pos position))
  (declare 
   #-CMU
   (inline <= abs -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (left right bottom top) region
   (let ((p-x
	  (if (<= (abs (- left
			 (position-x pos)))
		 (abs (- right
			 (position-x pos))))
	      left
	    right))
	(p-y 
	 (if (<= (abs (- bottom
			 (position-y pos)))
		 (abs (- top
			 (position-y pos))))
	     bottom
	   top)))
     (make-position :x p-x :y p-y))))

;;; $@M?$($i$l$?%]%8%7%g%s$K:G$b6a$$%j!<%8%g%s$N3Q$N%]%8%7%g%s$rJV$9(J
(defmethod near-corner-xy ((region region) x y)
  (declare 
   #-CMU
   (inline <= abs -)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots
   (left right bottom top) region
   (let ((p-x
	 (if (<= (abs (- left
			 x))
		 (abs (- right
			 x)))
	     left
	   right))
	(p-y 
	 (if (<= (abs (- bottom
			 Y))
		 (abs (- top
			 y)))
	     bottom
	   top)))
     (values p-x p-y))))


;;; $@%j!<%8%g%s$KCM$r@_Dj$9$k(J
(defmethod set-region-values ((region region) &key (left 0) (bottom 0)
							  (right 0) (top 0))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   ((l left) (r right) (t top) (b bottom)) region
   (setf l left r right t top b bottom))
  region)
  
;;;; End of primitive.lisp 



