;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%&%#%s%I%&%9%H%j!<%`$NItIJ$N4pK\%/%i%9$H%a%=%C%I(J
;;; parts-primitive.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/02/21 by t.kosaka

;;; Change Log   

(in-package :yy)

;;; $@%-!<%o!<%I$N%j%9%H:o=|(J
(defun make-xy-arg (arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (do ((item arg (cdr item)))
      ((null item) arg)
    (when (keywordp (car item))
	(setf (cdr item) nil)
	(return (nbutlast arg)))
    ))



;;; piece-region $@$r>C5n$9$k(J
;;; flush-draw-piece piece-region &optional (territory T)
;;; ARG.
;;;         piece-region =  $@IA2h%(%j%"(J
;;;         territory    =  $@$b$7(JT$@$J$i$P!"%F%j%H%j!<$N>C5n(J
(defmethod flush-draw-piece ((piece piece-region) &optional (territory T))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dolist (item (child-object-list piece))
    (flush-draw-piece item NIL))
  
  ;;; $@4XO"IU$1$r2r=|(J
  (delete-lisp-object (territory piece))

  ;;; $@?F$N$+$i<+J,$r<h$j=|$/(J
  (if (object-parent piece)
      (setf (child-object-list (object-parent piece))
	(delete piece (child-object-list (object-parent piece)))))
  
  (if territory
      (yy-protocol-5 (territory piece)))

  (setf (territory piece) nil)
  nil)


;;; $@%$%s%9%?%s%9@8@.$N(Jafter$@%a%=%C%I(J
;;; $@%F%j%H%j!<$H4XO"$:$1(J
(defmethod initialize-instance :after ((ob piece-region)
				       &rest arg &key &allow-other-keys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (unless (find-list :object-parent arg)
     ;;; $@%(%i!<$rH/@8(J
     (error ":Object-Parent argument is NULL.
             You should Make instance with :OBJECT-PARENT argument"))
  (let ((parent (find-list :object-parent arg)))
    
    (unless (territory ob)
      (push ob (child-object-list parent))
      (let ((x (find-list :left arg))
	    (y (find-list :bottom arg))
	    (r (find-list :right arg))
	    (tt (find-list :top arg))
	    (w (find-list :width arg))
	    (h (find-list :height arg)))
	(unless x (setf x 0))
	(unless y (setf y 0))
	(unless w (setf w  (if r (- r x) 1)))
	(unless h (setf h  (if tt (- tt y) 1)))

	(setf (territory ob)
	  (with-object-make-territory 
	   ob :x x :y y :width w :height h
	   :visible (find-list :draw-piece-visible arg)
	   :parent (territory parent)))
	))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; drawable piece$@$NIA2h%a%=%C%I(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; draw-piece-point 
;;; drawable piece $@$KE@$rBG$D(J
;;; draw-piece-point drawable-piece x y &key (color black-color*) (op *GCOPY*)
;;; ARG.
;;;        drawable-piece = $@IA2h%(%j%"(J
;;;        x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;        color          = $@?'%$%s%9%?%s%9(J
;;;        op             = $@%*%Z%l!<%7%g%s(J
(defmethod draw-piece-point ((object drawable-piece)
			     (x integer) (y integer)
			     &key (color *black-color*) (op *GCOPY*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-20 (territory object) x y op (color-no color)))

;;; draw-piece-line 
;;; drawable piece $@$K@~$r=q$/(J
;;; draw-piece-line drawable-piece x1 y1 x2 y2 &key (color *black-color*)
;;;            (width 1) (op *GCOPY*) (edge  *SQUEAR-LINE-EDGE*)
;;;            (dash "")
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x1 y1 x2 y2    = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       width          = $@@~$NI}(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       edge           = $@%i%$%s$NC<$N7?(J
;;;       dash           = $@E@@~$N>uBV(J
(defmethod draw-piece-line ((object drawable-piece)
			    (x1 integer) (y1 integer)
			    (x2 integer) (y2 integer)
			    &key (width 1) (op *GCOPY*) 
			    (color *black-color*)
			    (edge  *SQUEAR-LINE-EDGE*)
			    (dash ""))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-21 (territory object)
		  x1 y1 x2 y2 width op edge (color-no color)
		  dash))


;;; draw-piece-circle
;;; drawable piece $@$K1_$r=q$/(J
;;; draw-piece-circle drawable-piece x y radius &key
;;;            (color *black-color*) (width 1) (op *GCOPY*) (dash "")
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       radius         = $@H>7B(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       width          = $@@~$NI}(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       dash           = $@E@@~$N>uBV(J
(defmethod draw-piece-circle ((object drawable-piece)
			    (x integer) (y integer)
			    (radius integer)
			    &key (color *black-color*) (width 1) (op *GCOPY*) 
			    (dash ""))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-22 (territory object)
		  x y radius width op (color-no color)
		  dash))

;;; draw-piece-polyline
;;; drawable piece $@$K@^$l@~$r=q$/(J
;;; draw-piece-polyline drawable-piece xy-list &key
;;;            (width 1) (op *GCOPY*) (edge *SQUEAR-LINE-EDGE*)
;;;            (connect *SHARP-JOINT*) (color *black-color*) (dash "")
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       xy-list        = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       edge           = $@@~$NC<$N7A(J
;;;       connect        = $@@\B3E@$N7A(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       width          = $@@~$NI}(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       dash           = $@E@@~$N>uBV(J
(defmethod draw-piece-polyline ((object drawable-piece)
			     &rest xy-list
			    &key (width 1) (op *GCOPY*) 
			    (dash "") (color *black-color*)
			    (edge *SQUEAR-LINE-EDGE*)
			    (connect *SHARP-JOINT*) &allow-other-keys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-23 (territory object)
		  (make-xy-arg xy-list) width op edge connect (color-no color)
		  dash))

;;; draw-piece-polygon
;;; drawable piece $@$KB?3Q7A$r=q$/(J
;;; draw-piece-polygon drawable-piece xy-list &key
;;;            (op *GCOPY*) (width 1)
;;;            (connect *SHARP-JOINT*) (color *black-color*) (dash "")
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       xy-list        = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       connect        = $@@\B3E@$N7A(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       width          = $@@~$NI}(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       dash           = $@E@@~$N>uBV(J
(defmethod draw-piece-polygon ((object drawable-piece)
			     &rest xy-list
			    &key (width 1) (op *GCOPY*) 
			    (dash "") (color *black-color*)
			    (connect *SHARP-JOINT*) &allow-other-keys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-24 (territory object)
		  (make-xy-arg xy-list) width op connect (color-no color)
		  dash))

;;; draw-piece-arc
;;; drawable piece $@$K1_8L$r=q$/(J $@3QEY$N;XDj$O!">o$KH?;~7W2s$j(J
;;;       $@3QEY$N;XDj$O!"%G%#%0%j!<$G!"Bh#4>]8=$rBh0l>]8=$N$4$H$/07$&(J
;;; draw-piece-arc drawable-piece x y radius  theta1 theta2 &key
;;;            (width 1) (op *GCOPY*) (dash "") (color *black-color*)
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       radius         = $@H>7B(J
;;;       theta1         = $@3+;O3QEY(J $@%G%#%0%j!<(J
;;;       theta2         = $@=*N;3QEY(J $@%G%#%0%j!<(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       width          = $@@~$NI}(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       dash           = $@E@@~$N>uBV(J
(defmethod draw-piece-arc ((object drawable-piece)
			    (x integer) (y integer)
			    (radius integer)
			    theta1 theta2
			    &key (width 1) (op *GCOPY*) 
			    (color *black-color*)
			    (dash ""))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-25 (territory object)
		  x y radius 
		  (ceiling (* theta1 64))
		  (ceiling (* theta2 64))
		  width op (color-no color)
		  dash))

;;; draw-piece-rectangle
;;; drawable piece $@$K6k7A$r=q$/(J
;;; draw-piece-rectangle drawable-piece x y width height &key
;;;            (line-width 1) (op *GCOPY*) (color *black-color*) (dash "")
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       width height   = $@I}$H9b$5(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       line-width     = $@@~$NI}(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       dash           = $@E@@~$N>uBV(J
(defmethod draw-piece-rectangle ((object drawable-piece)
			     (x integer) (y integer) (width integer)
			     (height integer)
			    &key (line-width 1) (op *GCOPY*) 
			    (dash "") (color *black-color*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-26 (territory object)
		  x y width height line-width op (color-no color)
		  dash))
		  

;;; draw-piece-filled-polygon
;;; drawable piece $@$KB?3Q7A$NEI$j$D$V$7$rIA$/(J
;;; $@;XDj$5$l$??'$GEI$j$D$V$5$l$k(J
;;; draw-piece-filled-polygon drawable-piece xy-list &key
;;;            (op *GCOPY*) 
;;;            (connect *SHARP-JOINT*) (color *black-color*)
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       xy-list        = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       connect        = $@@\B3E@$N7A(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
(defmethod draw-piece-filled-polygon ((object drawable-piece)
			     &rest xy-list
			    &key (op *GCOPY*) 
			    (color *black-color*)
			    (connect *SHARP-JOINT*) &allow-other-keys)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-27 (territory object)
		  (make-xy-arg xy-list) op connect (color-no color)
		  *FillSolid* 0))

;;; draw-piece-filled-rectangle
;;; drawable piece $@$K6k7A$NEI$j$D$V$7$rIA$/(J
;;; $@;XDj$5$l$??'$GEI$j$D$V$5$l$k(J
;;; draw-piece-filled-rectangle drawable-piece x y width height &key
;;;            (op *GCOPY*) 
;;;            (connect *SHARP-JOINT*) (color *black-color*)
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       width height   = $@I}$H9b$5(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
(defmethod draw-piece-filled-rectangle ((object drawable-piece)
			    x y width height
			    &key (op *GCOPY*) 
			    (color *black-color*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-28 (territory object)
		  x y width height op (color-no color)
		  0))

;;; draw-piece-filled-circle
;;; drawable piece $@$KEI$j$D$V$5$l$?1_$r=q$/(J
;;; draw-piece-filled-circle drawable-piece x y radius &key 
;;;            (color *black-color*)
;;;            (op *GCOPY*) 
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       radius         = $@H>7B(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
(defmethod draw-piece-filled-circle ((object drawable-piece)
				     (x integer) (y integer)
				     (radius integer)
				     (color color)
				     &key (op *GCOPY*) )
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-29 (territory object)
		  x y radius op (color-no color) 0)
  )

;;; draw-piece-filled-arc
;;; drawable piece $@$KEI$j$D$V$5$l$?1_8LKt$O@p7?$r=q$/(J $@3QEY$N;XDj$O!">o$K;~7W2s$j(J
;;;       $@3QEY$N;XDj$O!"%G%#%0%j!<$G!"Bh#4>]8=$rBh0l>]8=$N$4$H$/07$&(J
;;; draw-piece-filled-arc drawable-piece x y radius theta1 theta2 &key
;;;             (op *GCOPY*) (color *black-color*) (arc-mode *ARCPIESLICE*)
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       radius         = $@H>7B(J
;;;       theta1         = $@3+;O3QEY(J $@%G%#%0%j!<(J
;;;       theta2         = $@=*N;3QEY(J $@%G%#%0%j!<(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       arc-mode       = $@1_8L$N%?%$%W(J($@@p7?$+5]7?(J)
(defmethod draw-piece-filled-arc ((object drawable-piece)
			    (x integer) (y integer)
			    (radius integer)
			    theta1 theta2
			    &key (op *GCOPY*) 
			    (color *black-color*)
			    (arc-mode *ARCPIESLICE*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-30 (territory object)
		  x y radius 
		  (ceiling (* theta1 64))
		  (ceiling (* theta2 64))
		  op (color-no color) 0
		  arc-mode))

;;; draw-piece-string
;;; drawable piece$@$KJ8;zNs$rIA$/(J
;;; draw-piece-string drawable-piece x y string 
;;;             (op *GCOPY*) (color *black-color*) (font *default-font*)
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       string         = $@J8;zNs(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       font           = $@%U%)%s%H(J
(defmethod draw-piece-string ((object drawable-piece)
			    (x integer) (y integer)
			    string
			    &key (op *GCOPY*) 
			    (color *black-color*)
			    (font *default-font*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-31 (territory object)
		  x y op (color-no color) (font-no font)
		  string))

;;; draw-piece-copy
;;; drawable piece$@$K(Jbitmap$@$+(Jdrawable piece$@$rD%$jIU$1$k(J
;;; draw-piece-copy source-drawable-piece sx sy 
;;;                 distenation-drawable-piece dx dy width height &optional
;;;                 (op *GCOPY*)
;;; ARG.
;;;       source                     = $@%=!<%9IA2h%(%j%"$b$7$/$O%S%C%H%^%C%W(J
;;;       sx sy                      = $@%=!<%9IA2h%(%j%"$J$$$N0LCV(J
;;;       distenation-drawable-piece = $@%G%#%9%F%#%M!<%7%g%sIA2h%(%j%"(J
;;;       dx dy                      = $@%G%#%9%F%#%M!<%7%g%sIA2h%(%j%"$N0LCV(J
;;;       width height               = $@I}$H9b$5(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
(defgeneric draw-piece-copy (s-object sx sy d-object dx dy
			     width height &optional op)
  (:method ((s-object drawable-piece)
	    (sx integer) (sy integer)
	    (d-object drawable-piece)
	    (dx integer) (dy integer) 
	    (width integer) (height integer)
	    &optional (op *GCOPY*))
	   (yy-protocol-35 (territory s-object)
			   sx sy 
			   (territory d-object)
			   dx dy width height op))
  (:method ((s-object bitmap)
	    (sx integer) (sy integer)
            (d-object drawable-piece)
            (dx integer) (dy integer)
            (width integer) (height integer)
            &optional (op *GCOPY*))
	   (yy-protocol-35 (bitmap-territory-no s-object)
			   sx sy
                           (territory d-object)
                           dx dy width height op))
  )

;;; draw-piece-color
;;; drawable piece$@$r;XDj$5$l$??'$GEI$j$D$V$9(J
;;; draw-piece-color drawable-piece color
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       color          = $@?'%$%s%9%?%s%9(J
(defmethod draw-piece-color ((object drawable-piece)
			     (color color))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-32 (territory object) (color-no color)))

		  
;;; draw-piece-put-image
;;; drawable piece$@$K%$%a!<%8$r$*$/(J
;;; draw-piece-put-image drawable-piece x y image
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$N0LCV(J
;;;       image          = $@%$%a!<%8(J
(defmethod draw-piece-put-image ((object drawable-piece)
				 (x integer) (y integer)
				 (image image))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((format1 (if (eq (image-format image) :yy)
                      2
                    1))
         (format (case (image-type image)
                   (:color
                    (logior #x8000 format1))
                   (:gray
                    (logior #x4000 format1))
                   (t
                    (logior #x2000 format1)))))

    (yy-protocol-61 (territory object) x y
		  (image-width image) (image-height image)
		  format (image-data image))))


;;; draw-piece-vertical-string
;;; drawable piece$@$K=D=q$-J8;zNs$rIA$/(J
;;; draw-piece-vertical-string drawable-piece x y string 
;;;             (op *GCOPY*) (color *black-color*) (font *default-font*)
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       string         = $@J8;zNs(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       font           = $@%U%)%s%H(J
(defmethod draw-piece-vertical-string ((object drawable-piece)
			    (x integer) (y integer)
			    string
			    &key (op *GCOPY*) 
			    (color *black-color*)
			    (font *default-font*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-43 (territory object)
		  x y op (color-no color) (font-no font)
		  string))

;;; draw-piece-ellipse
;;; drawable piece $@$KBJ1_$rIA$/(J
;;;       $@3QEY$N;XDj$O!"%G%#%0%j!<$G!">o$KH?;~7W$^$o$j(J
;;; draw-piece-ellipse drawable-piece x-radius y-radius &key
;;;             (op *GCOPY*) (color *black-color*) (width 1)
;;;             (dash "") (theta1 0) (theta 360)
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       x-radius       = X$@<4>e$NH>7B(J
;;;       y-radius       = Y$@<4>e$NH>7B(J
;;;       theta1         = $@3+;O3QEY(J $@%G%#%0%j!<(J
;;;       theta2         = $@=*N;3QEY(J $@%G%#%0%j!<(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       dash           = $@E@@~$N%Q%?!<%s(J
(defmethod draw-piece-ellipse ((object drawable-piece)
			       (x integer) (y integer)
			       (x-radius integer)
			       (y-radius integer)
			       &key  (theta1 0) (theta2 360)
			       (width 1)
			       (op *GCOPY*) 
			       (color *black-color*)
			       (dash ""))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-41 (territory object)
		  x y (* 2 x-radius) (* 2 y-radius)
		  (ceiling (* theta1 64))
		  (ceiling (* theta2 64))
		  width  op (color-no color) dash))


;;; draw-piece-filled-ellipse
;;; drawable piece $@$KEI$j$D$V$7BJ1_$rIA$/(J
;;;       $@3QEY$N;XDj$O!"%G%#%0%j!<$G!"Bh#4>]8=$rBh0l>]8=$N$4$H$/07$&(J
;;; draw-piece-filled-ellipse drawable-piece x y x-radius y-radius &key
;;;             (op *GCOPY*) (color *black-color*) 
;;;             (theta1 0) (theta 360) (arc-mode *ARCPIESLICE*)
;;; ARG.
;;;       drawable-piece = $@IA2h%(%j%"(J
;;;       x y            = $@IA2h%(%j%"$J$$$N0LCV(J
;;;       x-radius       = X$@<4>e$NH>7B(J
;;;       y-radius       = Y$@<4>e$NH>7B(J
;;;       theta1         = $@3+;O3QEY(J $@%G%#%0%j!<(J
;;;       theta2         = $@=*N;3QEY(J $@%G%#%0%j!<(J
;;;       color          = $@?'%$%s%9%?%s%9(J
;;;       op             = $@%*%Z%l!<%7%g%s(J
;;;       arc-mode       = $@1_8L$N%?%$%W(J($@@p7?$+5]7?(J)
(defmethod draw-piece-filled-ellipse ((object drawable-piece)
				      (x integer) (y integer)
				      (x-radius integer)
				      (y-radius integer)
				      &key  (theta1 0) (theta2 360)
				      (arc-mode *ARCPIESLICE*)
				      (op *GCOPY*) 
				      (color *black-color*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-protocol-42 (territory object)
		  x y (* 2 x-radius) (* 2 y-radius)
		  (ceiling (* theta1 64))
		  (ceiling (* theta2 64))
		  op (color-no color) 0 arc-mode))

;;; (setf draw-piece-visible)
;;; drawable piece $@$NI=<(>uBV$rJQ99$9$k(J
;;; (setf draw-piece-visible) val ob
;;; ARG.
;;;            val    =  T or NIL T:$@I=<((J NIL:$@HsI=<((J
;;;            ob     = $@IA2h%(%j%"(J
(defmethod (setf draw-piece-visible) :after (val (ob drawable-piece))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if val
      (yy-protocol-2 (territory ob) 1)
    (yy-protocol-2 (territory ob) 0)))



(defun get-avialble-mask (list)
  #-CMU
 (declare (special *mouse-move* *mouse-in* *mouse-out* *mouse-wait*
                    *mouse-button-down-1* *mouse-right-1*
                    *mouse-middle-1* *mouse-left-1* *mouse-button-up*
                    *mouse-right-up* *mouse-middle-up* *mouse-left-up*
                    *mouse-button-down-2* *mouse-right-2* *mouse-middle-2*
                    *mouse-left-2*)
	  (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((mask 0))
    (do ((item-list list (cdr item-list)))
	((null item-list))
      (case (car item-list)
	(:button-1
	 (if (second item-list)
	     (setf mask (logior mask *mouse-button-down-1*))))
	(:left-button-down-1
	 (if (second item-list)
	     (setf mask (logior mask *mouse-left-1*))))
	(:middle-button-down-1
	 (if (second item-list)
	     (setf mask (logior mask *mouse-middle-1*))))
	(:right-button-down-1
	 (if (second item-list)
	     (setf mask (logior mask *mouse-right-1*))))
	(:button-up
	 (if (second item-list)
	     (setf mask (logior mask *mouse-button-up*))))
	(:left-button-up
	 (if (second item-list)
	     (setf mask (logior mask *mouse-left-up*))))
	(:middle-button-up
	 (if (second item-list)
	     (setf mask (logior mask *mouse-middle-up*))))
	(:right-button-up
	 (if (second item-list)
	     (setf mask (logior mask *mouse-right-up*))))
	(:button-2
	 (if (second item-list)
	     (setf mask (logior mask  *mouse-button-down-2*))))
	(:left-button-down-2
	 (if (second item-list)
	     (setf mask (logior mask *mouse-left-2*))))
	(:middle-button-down-2
	 (if (second item-list)
	     (setf mask (logior mask *mouse-middle-2*))))
	(:right-button-down-2
	 (if (second item-list)
	     (setf mask (logior mask *mouse-right-2*))))
	(:move-mouse-cursor
	 (if (second item-list)
	     (setf mask (logior mask *mouse-move*))))
	(:mouse-cursor-in
	 (if (second item-list)
	     (setf mask (logior mask *mouse-in*))))
	(:mouse-cursor-out
	 (if (second item-list)
	     (setf mask (logior mask *mouse-out*))))
	(:mouse-cursor-wait
	 (if (second item-list)
	     (setf mask (logior mask *mouse-wait*))))
	))
    mask))

;;; $@%^%&%9%a%=%C%I$N=i4|2=(J
(defmethod initialize-instance :after ((ob event-drawable-piece)
				       &rest arg)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((mask (get-avialble-mask arg)))
    ;;; $@%$%Y%s%H%^%9%/$N@_Dj(J
    (unless (find-list :object-parent arg)
     ;;; $@%(%i!<$rH/@8(J
     (error ":Object-Parent argument is NULL.
             You should Make instance with :OBJECT-PARENT argument"))
  
    (let ((parent (find-list :object-parent arg)))
      (unless (territory ob)
	(push ob (child-object-list parent))
	(let ((x (find-list :left arg))
	      (y (find-list :bottom arg))
	      (r (find-list :right arg))
	      (tt (find-list :top arg))
	      (w (find-list :width arg))
	      (h (find-list :height arg)))
	  (unless x (setf x 0))
	  (unless y (setf y 0))
	  (unless w (setf w  (if r (- r x) 1)))
	  (unless h (setf h  (if tt (- tt y) 1)))

	  (setf (territory ob)
	    (with-object-make-territory 
	     ob :x x :y y :width w :height h
	     :visible (find-list :draw-piece-visible arg)
	     :parent (territory parent))))
	
	(setf (slot-value ob 'event-mask) mask)
	(yy-protocol-72 (territory ob) mask)))))


