;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; Mouse cusor $@4XO"(J
;;; mouse-cursor.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $@%^%&%9%+!<%=%k%/%i%9(J
;;; 6/22 1990 $@8E:d(J
;;; Version 1.0   Cored by t.kosaka 1990-6-22

(in-package :yy)

;;; $@%^%&%9%+!<%=%k$NI=<(%a%=%C%I(J
(defmethod print-object ((mouse mouse-cursor) stream)
  (format stream "\#<Mouse Cursor hotspot ~a,~a>" (x-hotspot mouse)
	  (y-hotspot mouse)))

;;; $@%^%&%9%+!<%=%k$+!)(J
(defun mouse-cursorp (object)
  (typep object 'mouse-cursor))


;;; $@%^%&%9%+!<%=%k%/%i%9$r:n$k(J
;;; $@%S%C%H%^%C%W$O!"%^%&%9%+!<%=%k$r:n$k;~$@$1!"$=$N3(>pJs$,;HMQ$5$l$k(J
;;; $@=>$C$F!"$=$N%S%C%H%^%C%W$r%^%&%9%+!<%=%k:n@.8e!"JQ99$7$F$b(J
;;; $@%^%&%9%+!<%=%k$N7A>u$O!"JQ2=$7$J$$!#(J
(defun make-mouse-cursor (width height bitmap &key (x-hotspot 0) 
				(y-hotspot 0))
  (declare (special *ROOT-TERRITORY-NO*))
  (let ((instance (make-instance 'mouse-cursor
				 :mouse-width width 
				 :mouse-height height
				 :mouse-cursor-bitmap bitmap
				 :x-hotspot x-hotspot
				 :y-hotspot y-hotspot))
		(tno 0)
		(no 0))

	(cond 
	 ((or (window-streamp bitmap)
		  (bitmap-streamp bitmap))
	  (setf tno (world-territory-no bitmap)))
	 ((bitmapp bitmap)
	  (setf tno (bitmap-territory-no bitmap)))
	 (t
	  (error "The argument ~a is not a bitmap-stream or window-stream" bitmap)
	  ))
	 (setf no (yy-protocol-90 width height *ROOT-TERRITORY-NO*
							   x-hotspot y-hotspot
							   tno))
	 (if (zerop no)
		 (error "Can not make mause cursor"))
	 (progn
	   ;; $@HV9f$H$N4XO"IU$1(J
	   (set-territory-object no instance)
	   (setf (mouse-territory-no instance) no))
	 instance))

;;; X-hotspot$@$NJQ99(J
(defmethod (setf x-hotspot) :around (new-value (mouse mouse-cursor))
  (if (integerp new-value)
      (progn
	(yy-protocol-91 (mouse-territory-no mouse)
		      new-value
		      (y-hotspot mouse))
	(call-next-method))
    (error "The argument ~a is not a integer" new-value)))

;;; Y-hotspot$@$NJQ99(J
(defmethod (setf y-hotspot) :around (new-value (mouse mouse-cursor))
  (if (integerp new-value)
      (progn
	(yy-protocol-91 (mouse-territory-no mouse)
		      (x-hotspot mouse)
		      new-value)
	(call-next-method))
    (error "The argument ~a is not a integer" new-value)))

;;; $@%^%&%9%+!<%=%k$N%S%C%H%^%C%W$NJQ99(J
(defmethod (setf mouse-cursor-bitmap) :around (new-b (mouse mouse-cursor))
  (if (or (window-streamp new-b)
	  (bitmap-streamp new-b))
      (progn 
	(yy-protocol-92 (mouse-territory-no mouse)
			(world-territory-no new-b))
	(call-next-method))
    (error "THe argument ~a is not a bitmap-stream or window-stream" new-b)))
	
;;; $@%^%&%9%+!<%=%k$N>C5n(J
(defmethod flush-mouse-cursor ((mouse mouse-cursor))
  (let ((return (yy-protocol-5 (mouse-territory-no mouse))))
    (if (zerop return)
        (error "Sorry ,can not remove ~a" mouse)
      (progn
      (delete-lisp-object (world-territory-no mouse))
      nil))))

;;; $@%^%&%9%+!<%=%k$NJQ99(J
(defmethod change-mouse-cursor ((mouse mouse-cursor))
  (declare (special *SYSTEM-MOUSE-CURSOR*))
  
  (setf *SYSTEM-MOUSE-CURSOR* mouse)
  (yy-protocol-96 (mouse-territory-no mouse))
  mouse)

;;; $@%^%&%9%+!<%=%k$NJQ99(J NULL$@$N>l9g(J
(defmethod change-mouse-cursor ((mouse NULL))
  mouse)

  

;;; get-position $@MQ%^%&%9%+!<%=%k(J
(defun make-get-position-mouse-cursor ()
  (let ((bitmap (make-bitmap-stream :width 16 :height 6)))
    (yy-protocol-22 (world-territory-no bitmap)
		    8 8 8 1 *GCOPY* (color-no (graphic-color bitmap)) "")

    (yy-protocol-21 (world-territory-no bitmap)
                   0 8 16 8 1 *GCOPY* *SQUEAR-LINE-EDGE*
                   (color-no (graphic-color bitmap)) "")
    (yy-protocol-21 (world-territory-no bitmap)
                    8 0 8 16 1 *GCOPY* *SQUEAR-LINE-EDGE*
                   (color-no (graphic-color bitmap)) "")
    
    (make-mouse-cursor 16 16 bitmap :x-hotspot 8 :y-hotspot 8)))


;;; End of file



