;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; macro-func.lisp
;;; $@%^%/%mDj5A$KI,MW$J4X?t(J
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 92/10/26 by t.kosaka
;;; $@%^%/%mDj5A$KI,MW$J4X?t72(J

(in-package :yy)

;;;$@%j!<%8%g%s$NJ,2r(J
;;; args => (left bottom right top width height) od ((l left) (r right))
(defun replace-atom (atom args ob)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dolist
   (one-item args)
   (if (listp one-item)
       (case (second one-item)
	     (left
	      (if (eq atom (car one-item))
	       (return (list 'car ob))))
	    (bottom
	     (if (eq atom (car one-item))
		 (return (list 'second ob))))
	    (right
	     (if (eq atom (car one-item))
		 (return (list 'third ob))))
	    (top
	     (if (eq atom (car one-item))
		 (return (list 'fourth ob))))
	    (width
	     (if (eq atom (car one-item))
		 (return (list 're-width-acc ob))))
	    (height
	     (if (eq atom (car one-item))
		 (return (list 're-height-acc ob))))
	    )
    (case one-item
	  (left
	   (if (eq atom one-item)
	       (return (list 'car ob))))
	  (bottom
	   (if (eq atom one-item)
	       (return (list 'second ob))))
	  (right
	   (if (eq atom one-item)
	       (return (list 'third ob))))
	  (top
	   (if (eq atom one-item)
	       (return (list 'fourth ob))))
	  (width
	   (if (eq atom one-item)
	       (return (list 're-width-acc ob))))
	  (height
	   (if (eq atom one-item)
	       (return (list 're-height-acc ob))))
	 ))))

#+CMU
(defun can-without-interrputs ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *with-inhibit*))
  (if *with-inhibit*
	  nil
	T))

;;;    SET-WITHOUT-INTERRUPTS-FLG
#+CMU
(defun set-without-interrupts-flg ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *with-inhibit*))
  (setf *with-inhibit* T))

#+CMU
(defun pop-without-interrupts-flg ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *with-inhibit*))
  (setf *with-inhibit* nil))

#+CMU
(defun before-interrupt-stop ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (not *with-inhibit*)
	  (progn
		(set-without-interrupts-flg)
		(ext::gc-off)
		(UNIX:UNIX-SIGBLOCK *alam-mask*))
	nil))

#+CMU
(defun after-interrupt-stop (mask)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when mask
		(pop-without-interrupts-flg)
		(UNIX:UNIX-SIGSETMASK mask)
		(ext::gc-on)))

(defun until-atom (atom ob args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (listp atom)
      (mapcar #'(lambda (x) (until-atom x ob args)) atom)
    (let ((ret (replace-atom atom args ob)))
      (if ret
	  ret
	atom))))


;;; $@%j!<%8%g%s$NI}$r%"%/%;%9(J
(defun re-width-acc (ob)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (- (third ob) (car ob)))

;;; $@%j!<%8%g%s$NI}$rJQ99(J
(defun set-re-width (ob new-v)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (third ob) (+ (car ob) new-v)))

(defsetf re-width-acc set-re-width)

;;; $@%j!<%8%g%s$N9b$5$r%"%/%;%9(J
(defun re-height-acc (ob)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (- (fourth ob) (second ob)))

;;; $@%j!<%8%g%s$N9b$5$rJQ99(J
(defun set-re-height (ob new-v)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (fourth ob) (+ (second ob) new-v)))


(defun packet-sending ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if *packet-sending*
	  nil
	T))


;;; $@%0%i%U%#%C%/%9(Jstate$@$NJ,2r(J
(defun replace-atom-state (atom args ob)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (dolist
   (one-item args)
   (if (listp one-item)
       (case (second one-item)
			 ((operation graphic-operation)
			  (if (eq atom (car one-item))
				  (return (list 'car ob))))
			 ((color graphic-color)
			  (if (eq atom (car one-item))
				  (return (list 'second ob))))
			 (line-width 
			  (if (eq atom (car one-item))
				  (return (list 'third ob))))
			 (line-edge
			  (if (eq atom (car one-item))
				  (return (list 'fourth ob))))
			 ((joint-type line-joint-type)
			  (if (eq atom (car one-item))
				  (return (list 'fifth ob))))
			 (line-dashing
			  (if (eq atom (car one-item))
				  (return (list 'sixth ob))))
			 (arc-mode
			  (if (eq atom (car one-item))
				  (return (list 'seventh ob))))
			 (filled-type
			  (if (eq atom (car one-item))
				  (return (list 'eighth ob))))
			 ((default-color-pattern stream-default-color-pattern)
			  (if (eq atom (car one-item))
				  (return (list 'ninth ob))))
			 (filled-rule
			  (if (eq atom (car one-item))
				  (return (list 'tenth ob))))
			 (filled-pattern
			  (if (eq atom (car one-item))
				  (return (list 'nth 10 ob))))
			 (stream-clockwize
			  (if (eq atom (car one-item))
				  (return (list 'nth 11 ob))))
			 )
	 (case one-item
		   ((operation graphic-operation)
			(if (eq atom one-item)
				(return (list 'car ob))))
		   ((color graphic-color)
			(if (eq atom one-item)
				(return (list 'second ob))))
		   (line-width
			(if (eq atom one-item)
				(return (list 'third ob))))
		   (line-edge
			(if (eq atom one-item)
				(return (list 'fourth ob))))
		   ((joint-type line-joint-type)
			(if (eq atom one-item)
				(return (list 'fifth ob))))
		   (line-dashing
			(if (eq atom one-item)
				(return (list 'sixth ob))))
		   (arc-mode
			(if (eq atom one-item)
				(return (list 'seventh ob))))
		   (filled-type
			(if (eq atom one-item)
				(return (list 'eighth ob))))
		   ((default-color-pattern stream-default-color-pattern)
		   (if (eq atom one-item)
			   (return (list 'ninth ob))))
		  (filled-rule
		   (if (eq atom one-item)
			   (return (list 'tenth ob))))
		  (filled-pattern
		   (if (eq atom one-item)
			   (return (list 'nth 10 ob))))
		  (stream-clockwize
		   (if (eq atom one-item)
			   (return (list 'nth 11 ob))))
		  ))))

(defun until-atom-state (atom ob args)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (listp atom)
      (mapcar #'(lambda (x) (until-atom-state x ob args)) atom)
    (let ((ret (replace-atom-state atom args ob)))
      (if ret
		  ret
		atom))))

#+CMU
(defun expand-defgeneric-for-yy (function-specifier lambda-list options)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((methods nil)
	(others nil))
    (dolist (option options)
      (case (car option)
	(:method (push `(defmethod ,function-specifier ,@(cdr option)) methods))
	(otherwise (push option others))))
    `(eval-when (eval load compile)
       (pcl:defgeneric ,function-specifier ,lambda-list ,@others)
       ,@methods)))
)


