;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; եΥƥȥɥ
;;; This file is EUC code.
;;; graphic-test.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/02/26 by t.kosaka
;;;

;;;  ʲΥ᥽åɤؿ饹ϡɥΩ夬äƤ

(in-package :yy)


;;; 饤ͤȤ
(defmethod get-slider-value ((ob slider))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((val (value-slot ob)))
    (with-slots (value offset) val
		(funcall offset value))))

;;; 饤κɽ
(defun redisplay-slider (ob)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (redisplay-slider-title (title-slot ob))
  (redisplay-slider-piece (piece-slot ob) 
			 (slot-value  (value-slot ob) 'value)))


;;; ȥ뤬ѹ줿Ȥκɽ᥽å
(defmethod (setf title) :after (string (ob slider-title))
#-:PCL
  (declare (ignore string))
  (redisplay-slider-title ob))

;;; ɽ
(defun redisplay-slider-title (ob)
  (declare (special *default-font*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-color ob (back-color (color-value ob)))
  (draw-piece-string ob 0 (font-kanji-base-line *default-font*)
		     (title ob) :color (color (color-value ob))))

;;; ͤѹɽ᥽å
(defmethod (setf value) :after (val (ob slider-value))
  (declare (special *default-font*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-color ob (back-color (color-value ob)))
  (let* ((string (write-to-string (round (funcall (offset ob) val))))
         (len (font-string-length *default-font* string)))
    (draw-piece-string ob (- (region-width ob) len)
		     (font-kanji-base-line *default-font*)
		     string
		     :color (color (color-value ob)))
    (funcall (form ob) (car (a-list ob)) (round (funcall (offset ob) val)))
    ))


;;; 饤ΰưκɽ
(defun redisplay-slider-piece (ob x)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (old-x ob)
      (draw-piece-line ob (old-x ob) 1 (old-x ob) (- (region-height ob) 2)
		       :width 4 :color (color (color-value ob)))
    (progn (setf (old-x ob) 0) 
	   (draw-piece-color ob (color (color-value ob)))))

  (setf (old-x ob) (current-x ob)
	(current-x ob) x)
  (draw-piece-line ob x 1 x (- (region-height ob) 2) :width 4
		   :color (back-color (color-value ob)))

  (setf (value (value-slot (object-parent ob))) x)
  )

;;; ޥˤưؿ
(defun move-slider (ob state)
  (declare (special *mouse-button-down-1*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (not (zerop (logand (mouse-state-button-state state)
			  *mouse-button-down-1*)))
      ;;; ƤȤͤѹ	
      (redisplay-slider-piece ob (mouse-state-x-position state))))

(defun button-slider (ob state)
  (declare (ignore ob state)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (values))

;;; 饤ؿ
;;; ꤵ뿧饤Τͤ򼨤ˤʤ롣
;;; formؿ᥽åɤΰϡa-list
;;; valueȤʤ롣
;;; valueϡ饤ͤǤ롣
;;; make-slider parent title value-string-width slider-width
;;;             lambda-form a-list
;;;             &key (back-color *white-color*) (color *black-color*)
;;;                  (offset #'+) (left 0) (bottom 0) (width 100)
;;;                  (initval 0)
;;; ARG.
;;;        parent              = ꡼ʥɥȥ꡼ʤС
;;;                              ɥȤդä
;;;        title               = ȥʸ
;;;                              ȥ뤬ɽǤΤ
;;;                              饤ΤΣĹ
;;;        value-string-width  = ͤɽ뤿
;;;        lambda-form         = ͤѹ줿
;;;                              ƤФؿ᥽å
;;;        a-list              = ؿƤФ
;;;                              Υꥹ
;;;        back-color          = Хå饦ɤο
;;;        color               = 饤ʸο
;;;        offset              = եå
;;;        left                = ü
;;;        bottom              = ü
;;;        width               = 
;;;        initval             = 
(defun make-slider (parent string value-string-width lambda-form
			   a-list
			   &key (back-color *white-color*)
			   (color *black-color*) (offset #'+)
			   (left 0) (bottom 0) (width 150)
			   (initval 0))
  (declare (special *default-font* *mouse-move*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((color-value (make-instance 'color-value
				    :color color
				    :back-color back-color))

	 (len1 (round (/ width 5)))
	 (slider (make-instance 'slider
		   :draw-piece-visible T
		   :left left :bottom bottom
		  :object-parent parent
		  :draw-piece-visible T
		  :width width
		  :height (font-kanji-height *default-font*)
		  :color-value color-value)))

    (setf (title-slot slider) 
	  (make-instance 'slider-title
	    :draw-piece-visible T
	    :title string
	    :color-value color-value
	    :object-parent slider
	    :width len1
	    :height (font-kanji-height *default-font*))
	  (value-slot slider)
	  (make-instance 'slider-value
	    :draw-piece-visible T
	    :left (+ len1 1)
	    :width value-string-width
	    :height (font-kanji-height *default-font*)
	    :offset offset
	    :value initval
	    :color-value color-value
	    :a-list a-list
	    :form lambda-form
	    :object-parent slider)
	  (piece-slot slider)
	  (make-instance 'slider-piece
	    :draw-piece-visible T
	    :left (+ len1 value-string-width 2)
	    :width (- width len1 value-string-width 2)
	    :height (font-kanji-height *default-font*)
	    :color-value color-value
	    :object-parent slider))

    ;;; ޥΥ٥ȥ᥽åɤ
    (let ((ob (piece-slot slider)))
      (with-event-object 
       (ob)
       (setf (move-mouse-cursor-method ob)
	     'move-slider
	     (get 'move-slider 'single-process) t
	     (button1-method ob) 'button-slider
	     (get 'button-slider 'single-process) t
	     (slot-value ob 'event-mask)
	     (logior *mouse-move* *mouse-button-down-1*) )))
    (redisplay-slider slider)
    slider))

;;; ޥȥåѥͥ
(defun make-matrix-panel (stream left bottom width)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ins (make-instance 'matrix-panel
	       :draw-piece-visible T
	       :width width
	       :left left
	       :height 84
	       :bottom bottom
	       :object-parent stream)))
    (setf (theta-slider ins)
	  (make-slider ins "" 30 'set-matrix-theta
		       (list (stream-transform-by-matrix stream))
		       :offset #'(lambda (x) (- (* x 5) 180))
		       :left 2 :bottom 24
		       :initval 36)
	  (x-time-slider ins)
	  (make-slider ins "X" 22 'set-matrix-x-time
		       (list (stream-transform-by-matrix stream))
		       :left 2 :bottom 44 :initval 5 
		       :offset #'(lambda (x) (* x 0.2)))
	  (y-time-slider ins)
	  (make-slider ins "Y" 22 'set-matrix-y-time
		       (list (stream-transform-by-matrix stream))
		       :left 2 :bottom 64 :initval 5 
		       :offset #'(lambda(x) (* x 0.2))))

    (draw-piece-rectangle ins 0 0 (region-width ins)
			  (region-height ins) :line-width 2)

    (draw-piece-string ins 2 20 "ޥȥꥯѥͥ")
    ins))


(defun set-matrix-theta (matrix new-v)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (matrix-theta matrix) new-v))

(defun set-matrix-x-time (matrix new-v)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (matrix-x-time matrix) new-v))

(defun set-matrix-y-time (matrix new-v)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (matrix-y-time matrix) new-v))

;;; 170ɥåȾե졼ˤ
(defmethod compute-window-parts ((frame switch-frame) region other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  ;;; ǥեȤ׻
  (default-compute-frame frame region other-regions)

  (setf (region-right frame) (- (region-right frame) 190)
		(region-left frame) (+ (region-left frame) 100))
  frame)



;;; current-draw-switch Υ᥽å
(defmethod (setf current-draw-switch) (ob (window switch-window))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (slot-value window 'current-draw-switch) ob
		(temp-x window) nil
		))

(defvar *dash-list* (list "" "I" (make-string 1 :initial-element (code-char 128))
			  (make-string 1 :initial-element (code-char 170))
			  (make-string 1 :initial-element (code-char 146))))

(defvar *mono-yy-bitmap* nil)
(defvar *color-yy-bitmap* nil)
(defvar *color-image-yy* nil)

(defvar *temp-image* nil)

;;; ƥѤΥɥȥ꡼
(defun make-test-window ()
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *DEMO-WINDOW2*))

  ;;; ӥåȥޥåפɤ߹
  (unless *mono-yy-bitmap*
	  (setf *mono-yy-bitmap* (make-bitmap 16 12 :image *image-yy*)))

  ;;; 顼ӥåȥޥåפɤ߹    
  (unless *color-yy-bitmap*
	  (unless *color-image-yy* 
		  (setq *color-image-yy* (make-image 16 12 :color 
						     *white-color*)))
	  ;;; ӥåȥޥåפν֤ѹ
	  (dotimes (y 12)
		   (dotimes (x 16)
			    (if (eq *white-color* 
				    (image-color-xy *image-yy* x y))
				(setf (image-color-xy *color-image-yy* x y)
				      *red-color*))))
	  (setf *color-yy-bitmap*
		(make-bitmap 16 12 :image *color-image-yy*)))

  ;; ɥ
  (setq *demo-window2*
		(make-window-instance 
		 'switch-window :window-region
		 (make-region :left 150 :bottom 50 :width 700
					  :height 450)
		 :title-bar 'switch-title-bar
		 :vertical-scroll-bar 'switch-vertical-scroll-bar
		 :horizontal-scroll-bar 'switch-horizontal-scroll-bar
		 :window-frame 'switch-frame
		 :transform-matrix (make-transform-matrix)
		 :drawing-region (make-region)
		 :title-bar-string "Demo Window 2"))

  ;;; ɥտ魯ޥ٥ȥ᥽åɤ
  (set-window-method *demo-window2* 'mouse-button-method 
		      :EVENT-MASK *mouse-button-down-1*)
    (setf (get 'mouse-button-method 'single-process) t)

    (set-window-method *demo-window2* 'move-function
		       :EVENT-MASK *mouse-move*)

    (setf (get 'move-function 'single-process) t
		  (stream-font *demo-window2*)
		  (load-font :font-name "a24"))  ;; եȤ
    )

	  
;;; ɽ᥽å
(defmethod redisplay-window  ((window switch-window))
  (declare (special *red* *blue* *green* *yellow*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((width (region-width (window-region window)))
		 (start (- width 190)))

	(default-redisplay-window window)

    (if (null (switch-with-title window))
		(with-slots 
		 ((switch switch-with-title)) window

		 (push (make-switch-with-title "ʸ" 'tate-yoko-switch 
									   (+ start 2) 25 :horizontal
									   '(:horizontal :vertical) window) switch)

		 (push (make-switch-with-title "" 'line-width-switch 
									   (+ 64 start) 25 1
									   '(1 2 4 6 8) window) switch)

		 (push (make-switch-with-title "ü" 'line-edge-switch
									   (+ 128 start) 25 *SQUEAR-LINE-EDGE*
									   (list *SQUEAR-LINE-EDGE*
											 *SQUEAR-LINE-EDGE-WITHOUT-END*
											 *ROUND-LINE-EDGE*)
									   window) switch)

		 (push (make-switch-with-title "³" 'line-joint-switch
									   (+ 2 start) 95 *SHARP-JOINT*
									   (list *SHARP-JOINT* *ROUND-JOINT*)
									   window) switch)
	 
		 (push (make-switch-with-title "η" 'line-dashing-switch
									   (+ 64 start) 95 "" 
									   *dash-list*
									   window) switch)

		 (push (make-switch-with-title 
				"迧" 'color-change-switch
				(+ 128 start) 95 *black-color*
				(list *black-color* *red-color*  *blue-color*
					  *green-color* *yellow-color* *orange-color*)
				window) switch)

		 (push (make-switch-with-title "ɤ٤" 'fill-switch
									   (+ 2 start) 165 *Fillednon*
									   (list *Fillednon* *FillSolid*
											 *FillTiled* *FillOpaqueStippled*)
									   window) switch)
		 (push (make-switch-with-title "߸̷" 'arc-mode-switch
									   (+ 64 start) 165
									   *ARCPIESLICE*
									   (list *ARCPIESLICE* *ARCCHORD*)
									   window) switch)))

    (if (null (draw-switch-list window))
		(with-slots
		 ((switch draw-switch-list)) window
		 (push (make-draw-switch 16 20 window 'line-draw-switch) switch)
		 (push (make-draw-switch 58 20 window 'circle-draw-switch) switch)
		 (push (make-draw-switch 16 61 window 'ellipse-draw-switch) switch)
		 (push (make-draw-switch 58 61 window 'polyline-draw-switch) switch)
		 (push (make-draw-switch 16 102 window 'region-draw-switch) switch)
		 (push (make-draw-switch 58 102 window 'polygon-draw-switch) switch)
		 (push (make-draw-switch 16 143 window 'arc-draw-switch) switch)
		 (push 
		  (make-draw-switch 58 143 window 'arc-ellipse-draw-switch) switch)
		 (push (make-draw-switch 16 184 window 'string-draw-switch) switch)
		 (push 
		  (make-draw-switch 58 184 window 'selction-object-switch) switch)
		 (push (make-draw-switch 16 225 window 'relation-object-switch) switch)
		 (push (make-draw-switch 58 225 window 'delete-object-switch) switch)
		 ))

    (if (null (matrix-panel window))
	(setf (matrix-panel window)
	    (make-matrix-panel window (- width 190) 235 170))

      (let ((ob (matrix-panel window)))
	(with-real-object
        (ob)
        (region-left ob) (- width 190))))
    ))
		

;;; δؿ 
(defgeneric redisplay-switch (ob))

;;; ɽ
(defmethod redisplay-switch-with-title ((ob switch-with-title))
  (declare (special *black-color* *white-color* *default-font*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-color ob *black-color*)
  (let* ((width (region-width ob))
	 (len (font-string-length *default-font* (title-string ob)))
	 (start (round (/ (- width len) 2))))

    (draw-piece-string ob start (font-kanji-base-line *default-font*)
		       (title-string ob) :color *white-color*)
    (let ((ins (switch-body ob)))
      (redisplay-switch ins))))


;;; ȥСդΥå
(defun make-switch-with-title (title class-name left bottom init-switch-vlaue
				     select-value-list stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((ins (make-instance 'switch-with-title
			    :draw-piece-visible T
			    :object-parent stream
			    :left left :bottom bottom
			    :width 60 :height 60
			    :title-string title))
	 (ob (make-instance class-name
			 :left 1 :bottom 15 :width 58
			 :draw-piece-visible T
			 :height 44
			 :object-parent ins
			 :switch-stream stream
			 :switch-value init-switch-vlaue
			 :select-value-list select-value-list)))

       (with-event-object 
	(ob)
	(setf (button1-method ob) 'select-button
	      (get 'select-button 'single-process) t
	      (slot-value ob 'event-mask) *mouse-button-down-1*
	      (switch-body ins) ob))
       (redisplay-switch-with-title ins)

    ins))

;;; ܥ᥽å
(defun select-button (ob state)
  (declare (ignore state)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((max (length (select-value-list ob))))
    (with-slots (current-count) ob
		(incf current-count)
		(if (>= current-count max)
		    (setf current-count 0))))
  (redisplay-switch ob))


;;; ɽ
(defmethod redisplay-switch ((ob tate-yoko-switch))
  (declare (special *white-color* *default-font* *black-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (switch-stream switch-value select-value-list current-count) ob
   (display-tate-yoko-switch ob switch-value *white-color*)
   (setf switch-value (nth current-count select-value-list))
   (display-tate-yoko-switch ob switch-value *black-color*)

   (setf (stream-output-direction switch-stream) switch-value)))
   
(defun display-tate-yoko-switch (ob value color)
  (declare (special *default-font*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((height (round (/ (region-height ob) 2))))
    (case value
	  (:horizontal
	   (draw-piece-string ob 5 height
			      "" :color color))
	(:vertical 
	 (draw-piece-vertical-string ob 16 12
			    "Ľ" :color color)))))

;;; ɽ
(defmethod redisplay-switch ((ob line-width-switch))
  (declare (special *white-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((hh (round (/ (region-height ob) 2))))
    (with-slots
     (switch-stream switch-value select-value-list current-count) ob
     (draw-piece-line ob 1 hh (- (region-width ob) 2) hh :width switch-value 
		      :color *white-color*)
     (setf switch-value (nth current-count select-value-list))
     (draw-piece-line ob 1 hh (- (region-width ob) 2) hh :width switch-value)
     (setf (line-width switch-stream) switch-value))))

;;; ɽ
(defmethod redisplay-switch ((ob line-edge-switch))
  (declare (special *white-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((hh (round (/ (region-height ob) 2))))
    (with-slots
     (switch-stream switch-value select-value-list current-count) ob
     (draw-piece-line ob 20 hh (region-width ob) hh :width 10
		      :edge switch-value
		      :color *white-color*)
     (setf switch-value (nth current-count select-value-list))
     (draw-piece-line ob 20 hh (region-width ob) hh :width 10
		      :edge switch-value)
     (setf (line-edge switch-stream) switch-value))))

(defmethod redisplay-switch ((ob line-joint-switch))
  (declare (special *white-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((hh (region-height ob)))
    (with-slots
     (switch-stream switch-value select-value-list current-count) ob
     (draw-piece-polyline ob 2 hh 24 15 56 hh :width 10
			  :connect switch-value
			  :color *white-color*)
     (setf switch-value (nth current-count select-value-list))
     (draw-piece-polyline ob 2 hh 24 15 56 hh :width 10
			  :connect switch-value)
     (setf (line-joint-type switch-stream) switch-value))))


(defmethod redisplay-switch ((ob line-dashing-switch))
  (declare (special *white-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((hh (round (/ (region-height ob) 2))))
    (with-slots
     (switch-stream switch-value select-value-list current-count) ob
     (draw-piece-line ob 1 hh (- (region-width ob) 2) hh :width 10
		      :dash switch-value
		      :color *white-color*)
     (setf switch-value (nth current-count select-value-list))
     (draw-piece-line ob 1 hh (- (region-width ob) 2) hh :width 10
		      :dash switch-value)
     (setf (line-dashing switch-stream) switch-value))))

(defmethod redisplay-switch ((ob color-change-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (switch-stream switch-value select-value-list current-count) ob
   (setf switch-value (nth current-count select-value-list))
   (draw-piece-color ob switch-value)
   (setf (graphic-color switch-stream) switch-value)))

(defmethod redisplay-switch ((ob fill-switch))
  (declare (special *white-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (switch-stream switch-value select-value-list current-count) ob
   (setf switch-value (nth current-count select-value-list))
   (let ((ret (redisplay-fill ob switch-value)))
     (setf (filled-type switch-stream) switch-value
	   (filled-pattern switch-stream) ret))
   ))

(defun redisplay-fill (ob value)
  (declare (special *white-color* *color-image-yy* *color-yy-bitmap*
		    *image-yy* *mon-yy-bitmap*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-color ob *white-color*)

  (cond 
    ((eq *Fillednon* value)
      (draw-piece-string ob 15 20 "")
      nil)

     ((eq *FillSolid* value)
      (draw-piece-string ob 20 20 "")
      nil)
     
     ((eq *FillTiled* value)
      (draw-piece-put-image ob 20 10 *color-image-yy*)
      (bitmap-territory-no *color-yy-bitmap*))

     ((eq *FillOpaqueStippled* value)
      (draw-piece-put-image ob 20 10 *image-yy*)
      (bitmap-territory-no *mono-yy-bitmap*))
     ))


(defmethod redisplay-switch ((ob arc-mode-switch))
  (declare (special *white-color* *black-color*)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (switch-stream switch-value select-value-list current-count) ob
   (rediplsy-arc-mode ob switch-value *white-color*)
   (setf switch-value (nth current-count select-value-list))
   (rediplsy-arc-mode ob switch-value *black-color*)
   ))

(defun rediplsy-arc-mode (ob value color)
  (declare 	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (cond
   ((eq value *ARCPIESLICE*)
    (draw-piece-string ob 15 20 "" :color color))
   (t
    (draw-piece-string ob 15 20 "ݷ" :color color))
   ))



;;; 襳ޥɤΥå
(defun make-draw-switch (left bottom stream class-name)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((ob (make-instance class-name
			    :left left :bottom bottom :width 40
			    :draw-piece-visible T
			    :height 40
			    :object-parent stream
			    :switch-stream stream)))

    (with-event-object 
     (ob)
     (setf (button1-method ob) 'select-draw-switch
	   (get 'select-draw-switch 'single-process) t
	   (slot-value ob 'event-mask) *mouse-button-down-1*))
    (redisplay-draw-switch ob)
    ob))


(defmethod redisplay-draw-switch ((ob draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-rectangle ob 0 0 (region-width ob) 
			 (region-height ob)))

;;; ȿž 
(defun area-hanten (ob)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if ob 
	  (draw-piece-filled-rectangle ob 1 1 
								   (- (region-width ob) 2)
								   (- (region-height ob) 2)
								   :op (avialble-operation *black-color*))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     襳ޥɽؿ   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; ɥǥޥưȤ˵ưޥ᥽å
;;; λΥСХɽԤʤ
(defun move-function (window state)
  (declare 	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (rubber-band-method window)
	  (funcall (rubber-band-method window) window 
			   (mouse-state-x-position state)
			   (mouse-state-y-position state)))
  )

;;; ɥǥܥ򲡲줿Ȥ˵ưޥ᥽å
;;; ɸη
(defun mouse-button-method (window state)
  (declare 	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
   (let ((x (mouse-state-x-position state))
		 (y (mouse-state-y-position state)))
	 (when (button-down-method window)
		   (push x (points-list window))
		   (push y (points-list window))
		   (apply (button-down-method window) (list window state))))
  )


;;; СХɤ䥤٥ȥ᥽åɤ
(defmethod initialize-handler ((window switch-window))
  (with-slots 
   (button-down-method points-list rubber-band-method 
    temp-x old-temp-x) window
	(setf points-list nil
		  rubber-band-method nil
		  temp-x nil old-temp-x nil)))


(defmethod redisplay-draw-switch :after ((ob line-draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-line ob 4 20 36 20 :width 3))

;;; ΥСХ
(defun line-rubber-band (stream new-x new-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (temp-x stream)
	(with-non-graphic-matrix 
	  stream
	  (with-graphic-state 
	   ((op graphic-operation ) color line-dashing) stream
	    (setf op (avialble-operation color)
			  line-dashing "")
	    (with-slots 
	     (temp-x temp-y old-temp-x old-temp-y) stream
		 (if old-temp-x ;;; ŤΤоä
			 (draw-line-xy stream old-temp-x old-temp-y temp-x temp-y))
		 (draw-line-xy stream temp-x temp-y new-x new-y)
	     (setf old-temp-x new-x old-temp-y new-y)
	     )
	 ))))

;;; ֤ΤȤΥɥؤβ
(defun line-button-down (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore state))
  (with-slots 
   (points-list rubber-band-method 
    temp-x temp-y old-temp-x 
	 ) window
	(cond
	 ((= (length points-list) 4)
 	  ;;; СХɤä
	  (setf old-temp-x nil)
	  (line-rubber-band window (second points-list) (car points-list))
	  ;;; μ¹
	  (draw-prompt "褷ޤ")
	  (with-output-as-presentation
	   ((make-instance 'line-object) window)
	   (apply #'draw-line-xy window (reverse points-list)))
	  (initialize-handler window))
	 ((= (length points-list) 2)
	   (setf temp-x (second points-list)
			 temp-y (car points-list)
			 rubber-band-method #'line-rubber-band)
	   (draw-prompt "ϰ֤򥻥åȤޤ⤦Ʋ"))
	  )))
	

;;; 襳ޥɤ		
(defmethod select-draw-switch ((ob line-draw-switch) state)
  (declare 
#-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
    (setf (button-down-method stream) #'line-button-down
		  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))
    
;;; åκɽ
(defmethod redisplay-draw-switch :after ((ob circle-draw-switch))
  (draw-piece-circle ob 20 20 15 :width 3))

;;; ߤΥСХ
(defun circle-rubber-band (stream new-x new-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when 
   (temp-x stream)
   (with-non-graphic-matrix 
	stream
	(with-graphic-state
	 ((op graphic-operation) color line-dashing) stream
	  (setf op (avialble-operation color) line-dashing "")
	  (with-slots 
	   (temp-x temp-y old-temp-x move-oldest-x move-oldest-y) stream
	   ;;; ΥСХɤä
	   (if old-temp-x
		   (draw-circle-xy stream temp-x  temp-y old-temp-x))

	   (setf move-oldest-x new-x
			 move-oldest-y new-y)

	   (let ((hankei (round 
					  (sqrt (+ (* (- new-x temp-x)
								  (- new-x temp-x))
							   (* (- new-y temp-y)
								  (- new-y temp-y)))))))
		 (draw-circle-xy stream temp-x  temp-y hankei)
		 (setf old-temp-x hankei)))
	  ))))

;;; ֤ΤȤΥɥؤβ
(defun circle-button-down (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   #-PCL
		   (ignore state)
		   )
  (with-slots 
   (points-list rubber-band-method  
	move-oldest-x move-oldest-y
    temp-x temp-y old-temp-x) window
	(cond
	 ((= (length points-list) 4)
 	  ;;; СХɤä
	  (setf old-temp-x nil)
	  (circle-rubber-band window move-oldest-x move-oldest-y)
	  ;;; μ¹
	  (draw-prompt "ߤ褷ޤ")
	  (with-output-as-presentation
	   ((make-instance 'circle-object) window)
	   (apply #'draw-circle-xy window (list temp-x temp-y old-temp-x)))
	  (initialize-handler window))

	 ((= (length points-list) 2)
	   (setf temp-x (second points-list)
			 temp-y (car points-list)
			 rubber-band-method #'circle-rubber-band)
	   (draw-prompt "ϰ֤򥻥åȤޤȾ¤Ʋ"))
	  )))

;;; 襳ޥɤ
(defmethod select-draw-switch ((ob circle-draw-switch) state)
  (declare 
#-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
    (setf  (button-down-method stream) #'circle-button-down
		   (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))
			      
;;;ɽ
(defmethod redisplay-draw-switch :after ((ob ellipse-draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-ellipse ob 20 20 15 10 :width 3))

;;; ʱߤΥСХ
(defun ellipse-rubber-band (stream new-x new-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (temp-x stream)
	(with-non-graphic-matrix 
	  stream
	  (with-graphic-state
	   ((op graphic-operation) color) stream
	    (setf op (avialble-operation color))
	    (with-slots 
	     (temp-x temp-y old-temp-x old-temp-y move-oldest-x move-oldest-y) 
		 stream

		 (setf move-oldest-x new-x 
			   move-oldest-y new-y)

		 (if old-temp-x ;;; ŤΤä
			 (draw-ellipse-xy stream temp-x temp-y old-temp-x old-temp-y))
	     (let ((x-radius (abs (- new-x temp-x)))
			   (y-radius (abs (- new-y temp-y))))
	       (draw-ellipse-xy stream temp-x temp-y x-radius y-radius)
	       (setf old-temp-x x-radius old-temp-y y-radius)
	   ))))))

;;; ʱ֤ΤȤΥɥؤβ
(defun ellipse-button-down (window state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
	
  (with-slots 
   (points-list rubber-band-method 
	move-oldest-x move-oldest-y
     temp-x temp-y old-temp-x old-temp-y) window
	(cond
	 ((= (length points-list) 4)
 	  ;;; СХɤä
	  (setf old-temp-x nil)
	  (ellipse-rubber-band window move-oldest-x move-oldest-y)
	  ;;; μ¹
	  (draw-prompt "ʱߤ褷ޤ")

	  (with-output-as-presentation
	   ((make-instance 'ellipse-object) window)
	   (apply #'draw-ellipse-xy window 
			  (list temp-x temp-y old-temp-x old-temp-y)))
	  
	  (initialize-handler window))
	((= (length points-list) 2)
	   (setf temp-x (second points-list)
			 temp-y (car points-list)
			 rubber-band-method #'ellipse-rubber-band)
	   (draw-prompt "ϰ֤򥻥åȤޤ"))
	  )))

;;; ʱߥޥɤ
(defmethod select-draw-switch ((ob ellipse-draw-switch) state)
  (declare 
#-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
    (setf (button-down-method stream) #'ellipse-button-down
	 (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))
			      
;;; ɽ
(defmethod redisplay-draw-switch :after ((ob polyline-draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-polyline ob 2 38 20 4 38 38 :width 3))

;;; ޤä
(defun polyline-clear (stream &optional x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore x y))
  (with-non-graphic-matrix 
    stream
    (with-graphic-state
     ((op graphic-operation ) color ) stream
      (setf op (avialble-operation color))
      (apply #'draw-polyline-xy stream (reverse (points-list stream))))))

;;; ޤ֤ΤȤΥɥؤβ
(defun polyline-button-down (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list rubber-band-method
     temp-x temp-y old-temp-x old-temp-y) window
	(cond
	 ((and (eq *mouse-right-1* (mouse-state-button-state state))
		   (> (length points-list) 2))
 	  ;;; СХɤä
	  (polyline-clear window)
	  ;;; μ¹
	  (draw-prompt "ޤ褷ޤ")
	  
	  (with-output-as-presentation
	   ((make-instance 'polyline-object) window)
		(apply #'draw-polyline-xy window 
			   (reverse points-list)))
	  (initialize-handler window))
	 ((= (length points-list) 2)
	   (setf temp-x (second points-list)
			 temp-y (car points-list)
			 rubber-band-method #'line-rubber-band)
	   (draw-prompt 
		"ϰ֤򥻥åȤޤλ֤ޥαǻꤷƲ"))
	 (t
	  (setf temp-x (second points-list)
			temp-y (car points-list))
	  (draw-prompt "λ֤ޥαǻꤷƲ"))
	  )))

;;; ޤޥɤ
(defmethod select-draw-switch ((ob polyline-draw-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
    (setf (button-down-method stream) #'polyline-button-down
		  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ɽ
(defmethod redisplay-draw-switch :after ((ob region-draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-rectangle ob 7 10 26 22 :line-width 3))

;;; ΥСХ
(defun region-rubber-band (stream new-x new-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (temp-x stream)
	(with-graphic-state
	 ((op graphic-operation ) color line-dashing) stream
	  (with-non-graphic-matrix 
	    stream
		(setf op (avialble-operation color) line-dashing "")
		(with-slots 
		 (temp-x temp-y old-temp-x old-temp-y move-oldest-x move-oldest-y) 
		 stream
		 (setf move-oldest-x new-x
			   move-oldest-y new-y)
		 (if old-temp-x ;;; ΥСХɤä
			 (draw-polygon-xy stream temp-x temp-y old-temp-x temp-y
							  old-temp-x old-temp-y temp-x old-temp-y))
		 (draw-polygon-xy stream temp-x temp-y new-x temp-y
						  new-x new-y temp-x new-y)
		 (setf old-temp-x new-x old-temp-y new-y)
		 )))))

;;; ֤ΤȤΥɥؤβ
(defun region-button-down (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore state))
  (with-slots 
   (points-list rubber-band-method
	move-oldest-x move-oldest-y
     temp-x temp-y old-temp-x old-temp-y) window
	(cond
	 ((= (length points-list) 4)
 	  ;;; СХɤä
	  (setf old-temp-x nil
			(second points-list) move-oldest-x
			(car points-list) move-oldest-y)
	  (region-rubber-band window (second points-list) (car points-list))
	  ;;; μ¹
	  (draw-prompt "褷ޤ")
	  (let ((x1 temp-x)
			(y1 temp-y)
			(x2 old-temp-x)
			(y2 old-temp-y))
		(with-output-as-presentation
		 ((make-instance 'region-object) window)
		 (apply #'draw-region-xy window 
				(list (min x1 x2) (min y1 y2) 
					  (abs (- x1 x2)) (abs (- y1 y2)))))
	  (initialize-handler window)))
	 ((= (length points-list) 2)
	   (setf temp-x (second points-list)
			 temp-y (car points-list)
			 rubber-band-method #'region-rubber-band)
	   (draw-prompt "ϰ֤򥻥åȤޤ"))
	  )))

;;; ޥɤ
(defmethod select-draw-switch ((ob region-draw-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
    (setf (button-down-method stream) #'region-button-down
		  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ɽ
(defmethod redisplay-draw-switch :after ((ob polygon-draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-polygon ob 4 33 10 4 20 20 30 4 33 33 :width 3))

;;; ¿ѷΥꥢ
(defun polygon-clear (stream &optional x y)
  (declare 
   #-PCL
   (ignore x y)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
	
  (with-non-graphic-matrix 
    stream
    (with-graphic-state
     ((op graphic-operation)
	  (fill filled-type) color) stream
      (setf op (avialble-operation color)
			fill *Fillednon*)
      (apply #'draw-polygon-xy stream (reverse (points-list stream))))))


;;; ¿ѷ֤ΤȤΥɥؤβ
(defun polygon-button-down (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list rubber-band-method
     temp-x temp-y old-temp-x old-temp-y) window
	(cond
	 ((and (eq *mouse-right-1* (mouse-state-button-state state))
		   (> (length points-list) 2))
 	  ;;; СХɤä
	  (polygon-clear window)
	  ;;; μ¹
	  (draw-prompt "¿ѷ褷ޤ")

	  (with-output-as-presentation
	   ((make-instance 'polygon-object) window)
	   (apply #'draw-polygon-xy window 
			  (reverse points-list)))
	  (initialize-handler window))

	 ((= (length points-list) 2)
	   (setf temp-x (second points-list)
			 temp-y (car points-list)
			 rubber-band-method #'line-rubber-band)
	   (draw-prompt 
		"ϰ֤򥻥åȤޤλ֤ޥαǻꤷƲ"))
	 (t
	  (setf temp-x (second points-list)
			temp-y (car points-list))
	  (draw-prompt "λ֤ޥαǻꤷƲ"))
	  )))

;;; ¿ѷޥɤ
(defmethod select-draw-switch ((ob polygon-draw-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
    (setf (button-down-method stream) #'polygon-button-down
		  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ɽ
(defmethod redisplay-draw-switch :after ((ob arc-draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-arc ob 20 20 10 -10 60 :width 3))

;;; ߸̤ΥСХ
(defun arc-rubber-band (stream new-x new-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (arc-hankei stream)
		(with-graphic-state
		 ((op graphic-operation ) color line-dashing) stream
		  (with-non-graphic-matrix 
		   stream
		   (setf op (avialble-operation color) line-dashing "")
		   (with-slots 
			(temp-x temp-y arc-hankei start-angle end-angle
					move-oldest-x move-oldest-y)
			stream

			(setf move-oldest-x new-x 
				  move-oldest-y new-y)

			(if end-angle  ;;; ΥСХɤä
				(draw-circle-xy stream temp-x temp-y arc-hankei
								:start-angle start-angle
								:end-angle end-angle))
			(setf end-angle
				  (angle-from-axsis stream (- new-x temp-x)
									(- new-y temp-y)))
			(draw-circle-xy stream temp-x temp-y arc-hankei
							:start-angle start-angle
							:end-angle end-angle))
		   ))))

;;; ߸֤ΤȤΥɥؤβ
(defun arc-button-down (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore state))
  (with-slots 
   (points-list rubber-band-method move-oldest-x move-oldest-y
    temp-x temp-y start-angle end-angle arc-hankei 
	old-temp-x old-temp-y) window
	(cond
	 ((= (length points-list) 6)
 	  ;;; СХɤä
	  (setf end-angle nil)
	  (arc-rubber-band window move-oldest-x move-oldest-y)

	  ;;; μ¹
	  (draw-prompt "߸̤褷ޤ")
	  (with-output-as-presentation
	   ((make-instance 'arc-object) window)
	   (apply #'draw-circle-xy window 
			  (list temp-x temp-y (round arc-hankei )
				   :start-angle start-angle
				   :end-angle end-angle)))
	  (setf start-angle nil end-angle nil arc-hankei nil)
	  (initialize-handler window))

	 ((= (length points-list) 2)
	   (setf temp-x (second points-list)
			 temp-y (car points-list)
			 rubber-band-method #'line-rubber-band)
	   (draw-prompt 
		"ϰ֤򥻥åȤޤȾ¤ȳϳ٤ꤷƲ"))
	 (t
	  (let* ((new-x (second points-list))
			 (new-y (car points-list)))
		(setf old-temp-x nil)
		;;; ΥСХɤä
		(line-rubber-band window new-x new-y)
		(setf arc-hankei
			  (round (sqrt (+ (* (- new-x temp-x)
								 (- new-x temp-x))
							  (* (- new-y temp-y)
								 (- new-y temp-y)))))
			  start-angle (angle-from-axsis window
						   (- new-x temp-x)
						   (- new-y temp-y))
			  rubber-band-method #'arc-rubber-band)
		(draw-prompt 
		 "Ⱦ¤ȳϳ٤򥻥åȤޤλ٤Ʋ"))
	  )
	  )))

;;; εΥǳٷ׻򤹤
;;; εΥ x y
;;; ȿײ
(defun angle-from-axsis (window x y)
    (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

	(if (eq (class-name (class-of (stream-translate-coordinate window)))
			'translate-coordinate-left-top)
		(setf y (* y -1)))

	(if (zerop y) ;;; ð
		(if (> x 0)
			0.0
			pi)
	  (if (zerop x) ;;; ð
		  (if (> y 0)
			  (/ pi 2)
			(+ pi (/ pi 2)))
		(cond 
		 ((and (> x 0) (> y 0)) ;;; 켡ݸ
		  (atan (/ y x)))
		 ((and (< x 0) (> y 0)) ;;; 󼡾ݸ
		  (+ pi (atan (/ y x))))
		 ((and (< x 0) (< y 0)) ;;; 軰ݸ
		  (+ (atan (/ y x)) pi))
		 (t
		  (+ (atan (/ y x)) (* 2 pi)))
		 ))))

;;; ߸̥ޥɤ
(defmethod select-draw-switch ((ob arc-draw-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
    (setf (button-down-method stream) #'arc-button-down
		  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ɽ
(defmethod redisplay-draw-switch :after ((ob arc-ellipse-draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-ellipse ob 20 20 10 5 :theta1 10 :theta2 170 :width 3))


;;; ʱ߸̤ΥСХ
(defun ellipse-arc-rubber-band (stream new-x new-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when (ellipse-x-hankei stream)
		(with-graphic-state
		 ((op graphic-operation ) color line-dashing) stream
		  (with-non-graphic-matrix 
		   stream
		   (setf op (avialble-operation color) line-dashing "")
		   (with-slots 
			(temp-x temp-y ellipse-x ellipse-y move-oldest-x move-oldest-y
					ellipse-x-hankei ellipse-y-hankei start-angle end-angle)
			stream

			(setf move-oldest-x new-x
				  move-oldest-y new-y)

			(if end-angle  ;;; ΥСХɤä
				(draw-ellipse-xy stream ellipse-x ellipse-y
								 ellipse-x-hankei ellipse-y-hankei
								:start-angle start-angle
								:end-angle end-angle))
			(setf end-angle
				  (angle-from-axsis stream (- new-x temp-x)
									(- new-y temp-y)))
			(draw-ellipse-xy stream ellipse-x ellipse-y
								 ellipse-x-hankei ellipse-y-hankei
								 :start-angle start-angle
								 :end-angle end-angle))
		   ))))

;;; ʱ߸֤ΤȤΥɥؤβ
(defun ellipse-arc-button-down (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore state))
  (with-slots 
   (points-list rubber-band-method move-oldest-x move-oldest-y
    temp-x temp-y start-angle end-angle ellipse-x ellipse-y
	old-temp-x old-temp-y ellipse-x-hankei ellipse-y-hankei
	) window
	(cond
	 ((= (length points-list) 4)
	  ;;; ΥСХɤä
	  (setf old-temp-x nil
			(second points-list) move-oldest-x
			(car points-list) move-oldest-y)

	  (region-rubber-band window (second points-list) (car points-list))

	  (let* ((x (min (fourth points-list)
					 (second points-list)))
			 (y (min (car points-list)
					 (third points-list)))
			 (width (round (/ (- (max (fourth points-list)
									  (second points-list))
								 x) 2)))
			 (height (round (/ (- (max (car points-list)
									   (third points-list))
								  y) 2))))
	  (setf temp-x (+ x width)
			temp-y (+ y height)
			old-temp-x nil
			ellipse-x  temp-x 
			ellipse-y temp-y
			ellipse-x-hankei width
			ellipse-y-hankei height
			rubber-band-method #'line-rubber-band)
	  (draw-prompt 
		"Ĺû򥻥åȤޤϳ٤Ʋ")))

	 ((= (length points-list) 8)
 	  ;;; СХɤä
	  (setf end-angle nil)
	  (ellipse-arc-rubber-band window (second points-list)
							(car points-list))
	  ;;; μ¹
	  (draw-prompt "ʱ߸̤褷ޤ")

	  (with-output-as-presentation
	   ((make-instance 'ellipse-arc-object) window)
	   (apply #'draw-ellipse-xy window 
			 (list ellipse-x ellipse-y ellipse-x-hankei ellipse-y-hankei
				   :start-angle start-angle
				   :end-angle end-angle)))
	  (setf start-angle nil end-angle nil ellipse-x-hankei nil)
	  (initialize-handler window))
	 ((= (length points-list) 2)
	   (setf temp-x (second points-list)
			 temp-y (car points-list)
			 rubber-band-method #'region-rubber-band)
	   (draw-prompt 
		"ϰ֤򥻥åȤޤĹûꤷƲ"))
	 (t
	  (let* ((new-x (second points-list))
			 (new-y (car points-list)))
		(setf old-temp-x nil)
		;;; ΥСХɤä
		(line-rubber-band window new-x new-y)
		(setf start-angle (angle-from-axsis window
											(- new-x temp-x)
											(- new-y temp-y))
			  rubber-band-method #'ellipse-arc-rubber-band)
		(draw-prompt 
		 "Ⱦ¤ȳϳ٤򥻥åȤޤλ٤Ʋ"))
	  )
	  )))

;;; ʱ߸̥ޥɤ
(defmethod select-draw-switch ((ob arc-ellipse-draw-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
	(terminate-accept stream)
    (setf 
	 (button-down-method stream) #'ellipse-arc-button-down
	 (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))

;;; ɽ
(defmethod redisplay-draw-switch :after ((ob string-draw-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-string ob 10 18 "ABC"))

(defun draw-string-exe (stream x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (setf (stream-cursor-x-position stream) x
		(stream-cursor-y-position stream) y)
  (let ((select *selection-table*))
	(select-window stream)
	(with-output-as-presentation
	 ((make-instance 'string-object) stream)
	 (read-line stream))
     (select-window select)))


;;; ʸ֤ΤȤΥɥؤβ
(defun string-button-down (window state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((matrix (stream-transform-by-matrix window))
		(new-x (mouse-state-x-position state)) 
		(new-y (mouse-state-y-position state)))

	(setf (matrix-theta matrix)
		  (* (matrix-theta matrix) -1))
	
	(multiple-value-setq
	 (new-x new-y)
	 (transform-by-matrix-xy new-x new-y matrix))

	(setf (matrix-theta matrix)
		  (* (matrix-theta matrix) -1))
	(draw-string-exe window new-x new-y)
  (setf (points-list window) nil)
;  (draw-prompt "Υޥɤϡ߻ѤǤޤ")
  (area-hanten (current-draw-switch window))
  (initialize-handler window)
  (setf (current-draw-switch window) nil)
  ))

	
;;; ʸ󥳥ޥɤ
(defmethod select-draw-switch ((ob string-draw-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
    (area-hanten (current-draw-switch stream))
    (setf (button-down-method stream) #'string-button-down
	  (current-draw-switch stream) ob)
    (area-hanten (current-draw-switch stream))))


;;; 򥳥ޥɤ
(defmethod select-draw-switch ((ob selction-object-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
	(terminate-accept stream)
	(area-hanten (current-draw-switch stream))
	(setf (current-draw-switch stream) ob
		  (button-down-method stream) nil)
    (area-hanten (current-draw-switch stream))
	(draw-prompt "޷ޥΰưǤޤܥβǰư")	
	(accept 'draw-object stream)
    (area-hanten (current-draw-switch stream))
	(initialize-handler stream)
	(setf (current-draw-switch stream) nil)))

;;; ɽ
(defmethod redisplay-draw-switch :after ((ob selction-object-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-string ob 3 18 ""))

;;; طդޥɤ
(defmethod select-draw-switch ((ob relation-object-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
	(setf (current-draw-switch stream) ob
		  (button-down-method stream) nil)
    (area-hanten (current-draw-switch stream))

	(draw-prompt "޷ɤطդޤط˥ޥư򡣺ܥǳǧ")
	(multiple-value-bind
	 (real-ob check)
	 (accept 'draw-object stream)

	 (if (eq check :terminate)
		 (draw-prompt "޷ɤδطλޤ")
	   (progn
		 (draw-prompt "ط˥ޥ˰ư򡣺ܥǳǧ")
		 (multiple-value-bind 
		  (temp-ob check2)
		  (accept 'draw-object stream)

		  (if (eq check2 :terminate)
				(draw-prompt "޷ɤδطλޤ")
			(push temp-ob
				  (relationship real-ob))
			)))
	   )
	 )
	(area-hanten (current-draw-switch stream))
	(initialize-handler stream)
	(setf (current-draw-switch stream) nil)
	)
  )


;;; ɽ
(defmethod redisplay-draw-switch :after ((ob relation-object-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-string ob 1 10 "ط")
  (draw-piece-string ob 1 25 "դ") )


;;; õޥɤ
(defmethod select-draw-switch ((ob delete-object-switch) state)
  (declare 
   #-PCL
   (ignore state)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (switch-stream ob)))
	(terminate-accept stream)
	(terminate-accept stream)
    (area-hanten (current-draw-switch stream))
	(setf (current-draw-switch stream) ob
		  (button-down-method stream) nil)
    (area-hanten (current-draw-switch stream))

	(draw-prompt "оݿ޷ޥΰư򤷺ܥǼ¹Ԥޤ")
	(multiple-value-bind
	 (real-ob check present)
	 (accept 'draw-object stream)

	 (if (eq check :terminate)
		 (draw-prompt "λޤ")
	   (progn
		 (delete-presentation-object real-ob stream 'draw-object present)
		 (area-hanten (current-draw-switch stream))
		 (setf (current-draw-switch stream) nil)
		 )
	   )
	 (initialize-handler stream)
	 (setf (current-draw-switch stream) nil)
  )))


;;; ɽ
(defmethod redisplay-draw-switch :after ((ob delete-object-switch))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (draw-piece-string ob 1 18 "õ"))


;;; ط륪֥Ȥΰư
(defmethod moved-presented-object ((ob draw-object) (stream window-stream)
								   step-x step-y)
  (dolist (item (relationship ob))
		  (move-presented-object-alone item stream 'draw-object step-x step-y))
  )


;;; End of list


