;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; extended-graphics.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.2 90/12/xx by Y.Ohta
;;;

;;; $@3HD%%0%i%U%#%C%/(J
;;; change log
;;;

(in-package :yy)

;;; A color graphics extension for yyonx ver1.2

;;; $@%+%i!<%F!<%V%k$r;}$C$F$$$J$$$H(JRGB$@$,F1$8$G$b(Jmake-color$@$7$?CM$,Kh2s(J
;;; $@0c$&%*%V%8%'%/%H$K$J$k!#=>$C$F(Jeql$@$NCM$,(Jt$@$K$J$i$J$$!#(J
;;; $@$b$7!"(Jreplace-color$@$r:n$C$?$H$9$k$H%+%i!<%*%V%8%'%/%H$N(JRGB$@CM$H<B:]$N(J
;;; $@?'$,0[$J$k>l9g$,=P$F$/$k!#(J
;;; => replace-color$@$r:n$C$F$+$iJQ99$9$k(J

;;; $@F)L@?'$O$I$&$d$C$F@8@.$7$h$&$+$J!#(J
;;; $@%5!<%P!<$KEO$7$A$c$^$:$$$+$J!#(J
;;; => $@%/%i%$%"%s%H$GH=Dj$9$k(J

   ;;
;;;;;; expantended protocol
   ;;

;;; for debug
#|
(eval-when (eval compile load)
  (pushnew :debug *features*))
|#

(defun dump-packet (&optional (size))
  (dolist (packet *send*)
    (multiple-value-bind (command length)
	(decode-com-pac (c_access packet 0))
      (lisp:format t "~%ComNo ~d Len ~d <~a>" command length (case (c_access packet 1)
							       ((0) "Alone")
							       ((1) "Start")
							       ((2) "Continue")
							       ((3) "End")
							       (otherwise "Unkown")))
      (dotimes (i (if (numberp size)
		      (min (- (floor (length packet) 4) 2) size (- length 2))
		    (min (- (floor (length packet) 4) 2) (- length 2))))
			   (lisp:format t "~%~d: ~d" (+ i 2) 
							(c_access packet (+ i 2))))
      (when (zerop (c_access packet 1))
	(return nil)))))

;;; #054 yy-protocol-54
;;; $@%"%K%a!<%7%g%s%U%l!<%`$NDj5A(J
;;; (yy-protocol-54 tno width height)
;;; args. tno = $@%F%j%H%j$NHV9f(J
;;;	  width = $@%"%K%a!<%7%g%s%U%l!<%`$NI}(J
;;;	  height = $@%"%K%a!<%7%g%s%U%l!<%`$N9b$5(J
(defcommand yy-protocol-54 (tno width height)
  (make-command-packet 54 :integer tno :integer width :integer height
		          :end)
  #+debug
  (dump-packet)
  (packet-send))

;;; #055 yy-protocol-55
;;; $@%"%K%a!<%7%g%s$N<B9T(J
;;; (yy-protocol-55 tno x y fno speed dir times sync)
;;; => last-frame-number
;;; args. tno = $@%F%j%H%j$NHV9f(J
;;;	  x = x$@:BI8(J
;;;	  y = y$@:BI8(J
;;;	  fno = $@%"%K%a!<%7%g%s3+;O%U%l!<%`HV9f(J
;;;	  speed = $@%"%K%a!<%7%g%s%9%T!<%I(J (10msec)
;;;	  dir = $@J}8~(J 0:=forward 1:=backward
;;;	  times = $@%"%K%a!<%7%g%s$N2s?t(J 0:=endless
;;;	  sync = $@F14|$r$H$k%"%K%a!<%7%g%s$NKg?t(J
(defcommand yy-protocol-55 (tno x y fno speed dir times sync)
  (make-command-packet 55 :integer tno :integer x :integer y :integer fno
		       :integer speed
		       :integer dir :integer times :integer sync :end)
  #+debug
  (dump-packet)
  (packet-send))

;;; #056 yy-protocol-56
;;; $@%"%K%a!<%7%g%s$NDd;_(J
;;; (yy-protocol-56 tno) -> last-frame-number
;;; args. tno = $@%F%j%H%j$NHV9f(J
(defcommand yy-protocol-56 (tno)
  (make-command-packet 56 :integer tno :end)
  #+debug
  (dump-packet)
  (packet-send))

;;; #057 yy-protocol-57
;;; $@%"%K%a!<%7%g%s%U%l!<%`$NGK2u(J
;;; (yy-protocol-57 tno)
;;; args. tno = $@%F%j%H%j$NHV9f(J
(defcommand yy-protocol-57 (tno)
  (make-command-packet 57 :integer tno :end)
  #+debug
  (dump-packet)
  (packet-send))

;;; #058 yy-protocol-58 
;;; $@%"%K%a!<%7%g%s%G!<%?$N%m!<%I(Jn$@8D(J
;;; (yy-protocol-58 tno format source &rest images)
;;; args. tno = $@%F%j%H%j$NHV9f(J
;;;	  format = format of image 1:=color
;;;				   2:=gray
;;;				   3:=mono
;;;	  source = 0:=image 1:=from territory
;;;	  images* source==0
;;;			fno = frame number
;;;			image = image (bytes)
;;;		  source==1
;;;			fno = frame number
;;;			tno = source territory number
;;;			x
;;;			y
(defcommand yy-protocol-58-only (tno format source fno &rest image)
  (cond
   ;; image object
   ((zerop source)
    (make-command-packet 58
			 :integer tno :integer 1 :integer format
			 :integer fno :integer source :vector (first image) :end))
   ;; image on territory
   ((= source 1)
    (make-command-packet 58
			 :integer tno :integer 1 :integer format
			 :integer fno :integer source
			 :integer (first image) :integer (second image)
			 :integer (third image) :end))
   ;;; $@%P%C%/%I%"%U%!%$%k(J
   ((= source 2)
	 (make-command-packet 
	  58 :integer tno :integer 1 :integer format
		 :integer fno :integer 2 :string (car image) :end))
   (t (error "yy-protocol-58-only: unknown type ~a" source)))
  #+debug
  (dump-packet 6)
  (packet-send))


(defcommand yy-protocol-58 (tno format source &rest images)
  (let ((form nil))
    (cond
     ((zerop source)
      (apply #'make-command-packet 58
	     :integer tno :integer (round images 2) :integer format
	     (do* ((x images (cddr x))
		   (fno (first x) (first x))
		   (image (second x) (second x)))
		 ((null x) (nconc form (list :end)))
	       (setf form (nconc form
				 (list :integer fno :integer source :vector image))
		     ))))
     ((= source 1)
      (apply #'make-command-packet 58
	     :integer tno :integer (round images 4) :integer format
	     (do* ((x images (nthcdr 4 x))
		   (fno (first x) (first x))
		   (sno (second x) (second x))
		   (left (third x) (third x))
		   (top (fourth x) (fourth x)))
		 ((null x) (nconc form (list :end)))
	       (setf form (nconc form
				 (list :integer fno :integer source
				       :integer sno :integer left :integer top)))
	       )))
     (t (error "yy-protocol-58: unknown type ~a" source)))
    #+debug
    (dump-packet 10)
    (packet-send)))


;;; $@%"%K%a!<%7%g%s=hM}(J
;;; The simple animation system

;;; primitives
;;; event dispatch


;;; animation method

(eval-when (eval compile)
  (defconstant *animation-pause* 0)
  (defconstant *animation-forward* 1)
  (defconstant *animation-backward* 2)

  (defconstant *yy-format* 2)
  (defconstant *cw-format* 1)
  (defconstant *color-format* #x8000)
  (defconstant *gray-format* #x4000)
  (defconstant *mono-format* #x2000)
  )

(defmethod print-object ((animation-frame animation-frame) stream)
  (format stream "#<Animation-frame ~ax~a>"
	  (width animation-frame) (height animation-frame)))

;;; $@%"%K%a!<%7%g%s%U%l!<%`$NDj5A(J
(defmethod define-animation-frame ((stream viewport-window-stream)
								   (x integer) (y integer)
								   (width integer) (height integer)
								   (max-number integer))
  (with-translate-transform-xy ((new-x new-y) stream x y)
    (with-translate-transform-xy ((x1 y1) stream (+ x width) (+ y height))
     (with-temp-region-args ((draw-anime-region) (work-region1 stream)
			     :left (min new-x x1) :width width
			     :bottom (min new-y y1) :height height)
      (let ((drawing-region (drawing-region stream)))
        ;;; $@%o!<%k%I%j!<%8%g%s$NJQ99(J
	(setf (world-region stream) draw-anime-region)
        ;;; drawing-region$@$K:#$N%j!<%8%g%s$rDI2C(J
	(if (null drawing-region)
	    (setf (drawing-region stream) draw-anime-region)
	  (setf (region-left drawing-region) (min (region-left drawing-region)
						  (region-left draw-anime-region))
		(region-top drawing-region) (max (region-top drawing-region)
						 (region-top draw-anime-region))
		(region-right drawing-region) (max (region-right drawing-region)
						   (region-right draw-anime-region))
		(region-bottom drawing-region) (min (region-bottom drawing-region)
						    (region-bottom draw-anime-region))
		))))))
	(yy-protocol-54 (world-territory-no stream) width height)
	(make-instance 'animation-frame
	  :left x :top y :width width :height height :window stream
	  :max-number max-number)
	)

;;; $@%"%K%a!<%7%g%s$NDd;_(J
(defmethod stop-animation ((frame animation-frame))
  ;;$@$b$7<B9TCf$@$C$?$iDd;_$9$k!"$=$l0J30$O$J$K$b$7$J$$(J
  (when (eql (animation-status frame) :active)
		(yy-protocol-56 (world-territory-no (window frame)))
		(setf (animation-status frame) :sleep)
    ))

;;; 11/19 91 kosaka change 
;;; $@J#?t$N%W%m%;%9$G%"%K%a!<%7%g%s$r2TF/$5$;$k(J
;;; $@<B9T$G$-$k%"%K%a!<%7%g%s$O!"0l%&%#%s%I%&$KIU$-0l8D(J
(defmethod run-animation ((frame NULL)
			  &key (left 0) (top 0)
			  (speed 1) (start-frame-no 0)
			  (direction :forward)
			  (presentation-times :endless)
			  (sync 20))
  (declare (ignore frame left top speed start-frame-no
                   direction presentation-time sync))
)

;;; $@%"%K%a!<%7%g%s$O!"0l$D$N%W%m%;%9$G$7$+2TF/$G$-$J$$!#(J
;;; 11/19 91 kosaka change 
;;; $@J#?t$N%W%m%;%9$G%"%K%a!<%7%g%s$r2TF/$5$;$k(J
;;; $@<B9T$G$-$k%"%K%a!<%7%g%s$O!"0l%&%#%s%I%&$KIU$-0l8D(J
(defmethod run-animation ((frame animation-frame)
			  &key (left (left frame)) (top (top frame))
			  (speed 1) (start-frame-no 0)
			  (direction :forward)
			  (presentation-times :endless)
			  (sync 20))
  (let ((function
		 #'(lambda (f ll tt sp st d pt sy)
			 (multiple-value-bind 
			  (l1 t1)
			  (adjust-xy f ll tt)		;$@$3$NCf$G(Jleft$@$H(Jtop$@$NCM$rJQ99$7$F$$$k(J
			  (let ((tno (world-territory-no (window f)))
					(dir (dir-sym2code d))
					(times (times-sym2code pt)))

				;;; $@<B9TCf$N%"%K%a!<%7%g%s$,$"$l$PDd;_$9$k(J
				(if (exec-animation-frame (window f))
					(stop-animation (exec-animation-frame (window f))))
			   
				(setf (animation-status f) :active
                      ;;; $@2TF/Cf$N%"%K%a!<%7%g%s%U%l!<%`$r3JG<(J
					  (exec-animation-frame (window f))
					  f)
				(yy-protocol-55 tno l1 t1 st sp dir times sy)
				(wait-process 'wait-animation f)
					)
			  ))))
	;;; $@2TF/$5$;$k(J
	(funcall function frame left top speed start-frame-no 
			 direction presentation-times sync))
  )


;;; $@%"%K%a!<%7%g%s$O!"0l$D$N%W%m%;%9$G$7$+2TF/$G$-$J$$!#(J
;;; $@$3$N=hM}$O!"%"%K%a!<%7%g%s$N40N;$^$GBT$?$J$$!#(J
;;; 11/19 91 kosaka change 
;;; $@J#?t$N%W%m%;%9$G%"%K%a!<%7%g%s$r2TF/$5$;$k(J
;;; $@<B9T$G$-$k%"%K%a!<%7%g%s$O!"0l%&%#%s%I%&$KIU$-0l8D(J
(defmethod without-wait-run-animation ((frame animation-frame)
			  &key (left (left frame)) (top (top frame))
			  (speed 1) (start-frame-no 0)
			  (direction :forward)
			  (presentation-times :endless)
			  (sync 20))
  (let ((function
		 #'(lambda (f ll tt sp st d pt sy)
			 (multiple-value-bind 
			  (l1 t1)
			  (adjust-xy f ll tt)		;$@$3$NCf$G(Jleft$@$H(Jtop$@$NCM$rJQ99$7$F$$$k(J
			  (let ((tno (world-territory-no (window f)))
					(dir (dir-sym2code d))
					(times (times-sym2code pt)))

				;;; $@<B9TCf$N%"%K%a!<%7%g%s$,$"$l$PDd;_$9$k(J
				(if (exec-animation-frame (window f))
					(stop-animation (exec-animation-frame (window f))))
			   
				(setf (animation-status f) :active
                      ;;; $@2TF/Cf$N%"%K%a!<%7%g%s%U%l!<%`$r3JG<(J
					  (exec-animation-frame (window f))
					  f)
				(yy-protocol-55 tno l1 t1 st sp dir times sy)
					)
			  ))))
	;;; $@2TF/$5$;$k(J
	(funcall function frame left top speed start-frame-no 
			 direction presentation-times sync))
  )

;;; $@<B9TBT$A4X?t(J
(defun wait-animation (frame)
  (if (eq (animation-status frame) :active)
	  nil
    T))

;;; $@%"%K%a!<%7%g%s$NDLCN(J
(defun yy-event-method4 (event)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((instance (get-lisp-object (car event))))
	(when instance
		  (setf (current-frame-no (exec-animation-frame instance))
				(second event))
		  (case (third event)
				((1 3)
				 (setf 
				  (animation-status (exec-animation-frame instance))
				  :sleep
				  (exec-animation-frame instance) nil))
				(t
				 nil)
				)
		  ))
  )


(defun dir-sym2code (direction)
  (case direction
	((:oneshot) 0)
	((:forward) 1)
	((:backward) 2)
	(otherwise (error "run-animation: Unknown direction ~s."))
	))

(defun times-sym2code (presentation-times)
  (cond
   ((eq presentation-times :endless) 0)
   ((and (integerp presentation-times)
	 (> presentation-times 0))
    presentation-times)
   (t
    (error "run-animation: presentation-times must be integer"))))

(defun adjust-xy (frame left top)
  (let ((width (width frame)) (height (height frame))
	(stream (window frame)) (yy 0) (def-y 0))
    (with-translate-transform-xy 
     ((new-x new-y) stream left top)
     (with-translate-transform-xy 
      ((x1 y1) stream (+ left width)
       (+ top height))
      (with-temp-region-args
       ((anime-region) (work-region1 stream)
	:left (min new-x x1) :width width
	:bottom (min new-y y1) :height height)
       (let ((drawing-region (drawing-region stream)))
	 (setf yy (with-translate-coordinate-stream top stream)
	       def-y (if (= yy top) 0 height))
	 (setf (world-region stream) anime-region)

	 ;;; $@IA2h%j!<%8%g%s$KDI2C(J
	 (set-drawing-region (drawing-region stream) drawing-region)))

      (values (+ new-x (world-x-start stream))
	      (- (+ new-y (world-y-start stream)) def-y))
      ))))



(defmethod display-frame ((frame animation-frame) (frame-no integer)
			  &key (x (left frame)) (y (top frame)))
  (let ((width (width frame)) (height (height frame))
	(stream (window frame)) (yy 0) (def-y 0))
    (with-translate-transform-xy ((new-x new-y) stream x y)
      (with-translate-transform-xy ((x1 y1) stream (+ x width) (+ y height))
	(with-temp-region-args ((anime-region) (work-region1 stream)
				:left (min new-x x1) :width width
				:bottom (min new-y y1) :height height)
	  (let ((drawing-region (drawing-region stream)))
	    (setf yy (with-translate-coordinate-stream y stream)
		  def-y (if (= yy y) 0 height))
	  ;;; $@%o!<%k%I%j!<%8%g%s$NJQ99(J
	    (setf (world-region stream) anime-region)
	    ;;; $@0LCV$NJQ99(J
	    (setf new-x (+ new-x (world-x-start stream))
		  new-y (- (+ new-y (world-y-start stream)) def-y))
	    ;; $@IA2h%W%j%_%F%#%V(J
	    (yy-protocol-55 (world-territory-no stream) new-x new-y frame-no 0 0 0 0)
	    ;; drawing-region$@$K:#$N%j!<%8%g%s$rDI2C(J
	    (if (null drawing-region)
		(setf (drawing-region stream) anime-region)
	      (setf (region-left drawing-region) (min (region-left drawing-region)
						      (region-left anime-region))
		    (region-top drawing-region) (max (region-top drawing-region)
						     (region-top anime-region))
		    (region-right drawing-region) (max (region-right drawing-region)
						       (region-right anime-region))
		    (region-bottom drawing-region) (min (region-bottom drawing-region)
							(region-bottom anime-region))))
	    frame))))))

(defmethod put-frame ((frame animation-frame) (frame-no integer) (image image)
					  &key (image-position (make-position :x 0 :y 0)))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore image-position))
  ;; check max-number
  (let ((image-data (image-data image))
	(format (logior (if (eql (image-format image) :yy) *yy-format* *cw-format*)
					(case (image-type image)
						  ((:color) *color-format*)
						  ((:gray) *gray-format*)
						  (otherwise *mono-format*)))))
    (yy-protocol-58-only (world-territory-no (window frame)) 
						 format 0 frame-no image-data)
    frame))

;;; $@%"%K%a!<%7%g%s$N%P%C%/%I%"(J
(defmethod put-frame ((frame animation-frame) (frame-no integer) 
					  (image string)
					  &key (image-position (make-position :x 0 :y 0)))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore image-position))
  ;; check max-number
  (let ((format 
		 (logior *yy-format*  *color-format*)))
	(draw-prompt (format nil "Animation Loding: ~a" image))
    (yy-protocol-58-only (world-territory-no (window frame)) 
						 format 2 frame-no image)
	(draw-prompt " ")
    frame))

(defmethod put-frame-xy ((frame animation-frame) (frame-no integer) 
						 (image image)
						 &key (image-x 0) (image-y 0))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore image-x image-y))
  ;; check max-number
  ;; $@$3$N%P!<%8%g%s$O(Jimage-x, image-y$@$r8+$F$$$J$$(J
  (let ((image-data (image-data image))
	(format (logior (if (eql (image-format image) :yy) *yy-format* *cw-format*)
			(case (image-type image)
			  ((:color) *color-format*)
			  ((:gray) *gray-format*)
			  (otherwise *mono-format*)))))
    (yy-protocol-58-only (world-territory-no 
						  (window frame)) format 0 frame-no image-data)
    frame))

;;;$@%P%C%/%I%"MQ(J 
(defmethod put-frame-xy ((frame animation-frame) (frame-no integer) 
						 (image string)
						 &key (image-x 0) (image-y 0))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore image-x image-y))
  ;; check max-number
  ;; $@$3$N%P!<%8%g%s$O(Jimage-x, image-y$@$r8+$F$$$J$$(J
  (let ((format 
		 (logior *yy-format* *color-format*)))
	(draw-prompt (format nil "Animation Backdoor Loding: ~a" image))
    (yy-protocol-58-only (world-territory-no 
						  (window frame)) format 2 frame-no image)
	(draw-prompt " ")
    frame))

(defmethod flush-animation-frame ((frame animation-frame))
  (yy-protocol-57 (world-territory-no (window frame)))
  nil
  )