/* Main Part of Application Box for YYonX
 * This file is part of YY-server of YYonX (Version 1.5)
 * $Id: super.c,v 3.0 1992/10/08 04:59:44 keisuke Exp keisuke $
 */

#ifndef lint
static char *RcsId =
    "$Id: super.c,v 3.0 1992/10/08 04:59:44 keisuke Exp keisuke $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include <memory.h>
#include <signal.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/termios.h>
#include <netdb.h>
#include <netinet/in.h>
#include <malloc.h>
#include "conf.h"
#include "abox.h"

/*
 * inetd ˤäƵư뤳ȤȤ
 * -debug ⡼ɤˤä xterm  slave ⡼ɤˤΩ뤬
 *  ....
 * Description File ν񼰤ͤʤä
 *  #...
 *  Define 'YY-client' {
 *  Debug: ON
 *  Information: YY Client
 *  Command: /local/bin/acl %s %d
 *  Send: "....."
 *  Wait: "....."
 *  Send: "....."
 *  Wait: "....."
 *  Send: "....."
 *  Wait: "....."
 *  }
 */


static char *CmdName;
static char *LibDir;
static char ClientAddr[128];
static char ClientHost[128];

static int get_client_name(sock)
    int sock;
{
    struct sockaddr_in src;
    int srclen = sizeof(src);

    if (getpeername(sock, &src, &srclen) == 0) {
	FILE *fp;
	char fpath[256];
	struct hostent *client;
	unsigned long req_addr;
	client = gethostbyaddr(&src.sin_addr, sizeof(src.sin_addr), PF_INET);

	ClientHost[0] = '\0';
	strcpy(ClientAddr, inet_ntoa(src.sin_addr));
	if (client != (struct hostent *)NULL)
	    strcpy(ClientHost, client->h_name);
	syslog(LOG_DEBUG, "Request from %s(%s)", ClientHost, ClientAddr);

	/* src.sin_addr  LibDir/securenetworks Ͽ
	 * 뤫ɤĴ٤ϿƤʤХ顼ˤ
	 *
	 * Default  127.0.0.1  OK ˤ
	 */
	req_addr = src.sin_addr.s_addr;
	if (req_addr == inet_addr("127.0.0.1"))
	    return 0;
	sprintf(fpath, "%s/securenetworks", LibDir);
	if ((fp = fopen(fpath, "r")) != (FILE *)NULL) {
	    char readbuf[1024];
	    while (fgets(readbuf, sizeof(readbuf), fp) != (char *)NULL) {
		register char *s = readbuf;
		register char *mask, *addr;
		/* MASK ڤФ */
		mask = s;
		while (*s != '\0' && !isspace(*s)) s++;
		if (*s == '\0') continue;
		*s++ = '\0';
		while (*s != '\0' && isspace(*s)) s++;
		if (*s == '\0') continue;
		/* ADDRESS ڤФ */
		addr = s;
		while (*s != '\0' && !isspace(*s)) s++;
		if (*s == '\0') continue;
		*s++ = '\0';
		if ((req_addr & inet_addr(mask)) == inet_addr(addr)) {
		    fclose(fp);
		    return 0;
		}
	    }
	    fclose(fp);
	}
	syslog(LOG_ERR, "Request from unauthorized host %s(%s)",
	       ClientHost, ClientAddr);
	return (-1);
    }
    syslog(LOG_ERR, "Request from unknown host");
    return(-1);
}

struct yy_call_request *read_request(sock)
{
    char buf[1024];
    int leng = 0;
    char *s = buf;
    int ent;
    struct yy_call_request *req;

    /* Ԥޤɤߤޤ */
    while (leng < sizeof(buf)) {
	register int rlen;
	rlen = read(sock, s, sizeof(buf)-leng);
	while (rlen > 0) {
	    if (*s == '\n' || *s == '\r') break;
	    s++, leng++;
	}
	if (rlen > 0) break;
    }
    *s = '\0';

    /* ; äʬ */
    req = (struct yy_call_request *)malloc(sizeof(struct yy_call_request));
    if (req == (struct yy_call_request *)NULL)
	return (struct yy_call_request *)NULL;

    if ((s = strdup(buf)) == (char *)NULL) {
	free((char *)req);
	return (struct yy_call_request *)NULL;
    }
    syslog(LOG_DEBUG, "Request Line: %s", s);

    for (ent = 0; ent < YYREQ_ENTNUM; ent++) {
	register char *e = strchr(s, ';');
	req->req_entry[ent] = s;
	if (e == (char *)NULL) {
	    syslog(LOG_WARNING, "Can't understand request: %s", buf);
	    return (struct yy_call_request *)NULL;
	}
	*e++ = '\0';
	s = e;
    }
#define isNullString(s)		((s)==(char *)NULL||*(s)=='\0')
    if (isNullString(req->req_name) || isNullString(req->req_user) ||
	isNullString(req->req_xdisp) || isNullString(req->req_server)) {
	syslog(LOG_WARNING, "Can't understand request: %s", buf);
	return (struct yy_call_request *)NULL;
    }
    return req;
}

#ifndef INETD
static void detach()
{
    int fd, pid;
    (void)umask(0);
    if ((pid = fork()) != 0) {
	sleep(2);
	exit((pid > 0)? 0: 1);
    }
    setpgrp(0,getpid());
    if ((fd = open("/dev/tty", O_RDWR)) >= 0) {
	ioctl(fd, TIOCNOTTY, 0);
	(void)close(fd);
    }
    for (fd = 0; fd < 20; fd++) (void)close(fd);
}

static int setup_server()
{
    struct sockaddr_in addr;
    int sock;

    (void)detach();

    openlog(CmdName, (LOG_PID), LOG_DAEMON);
    syslog(LOG_DEBUG, "Application box server starts");
    if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) return (-1);
    bzero((char *)&addr, sizeof(addr));
    addr.sin_family = PF_INET;
    addr.sin_port = htons(YYCALLPORT);
    if (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0 ||
	listen(sock, 5) < 0) {
	syslog(LOG_ERR, "Can't setup server port");
	(void)close(sock);
	return (-1);
    }
    return sock;
}
#endif /*!INETD*/

void close_session(fd)
{
    close(fd);
}


#include <setjmp.h>
#include <sys/wait.h>

static jmp_buf EnvBeforeFork;

static void child_term1(sig, code)
    int sig, code;
{
    int stat;
    int pid;
    if ((pid = wait(&stat)) < 0)
	syslog(LOG_ERR, "error on wait(2)");
    if (pid > 0)
	syslog(LOG_WARNING, "Process (#%d) is temincated abnormaly %d",
	       pid, stat);
    longjmp(EnvBeforeFork, 1);
}

do_main(desc_dir)
    char *desc_dir;
{
    struct yy_call_request *req;

    /* 뤳
     *
     * - openlog 
     * - ҹܤγǧ
     * - stdin Ф getsockname() Ȥ Address Ƥ
     * - Service Name ФƤεҤ
     * - եޥåȤ
     *     Name;User;Key;X-display;YY-server;Option;
     *   Ȥ롥٤ ASCII Ȥ ';' ǥߥȤ
     * - fork ƻҥץǥޥɤư
     * - ƥץǤʸ򤪤äƼ.. 򤹤
     *   Timeout  Error Code ֤
     *    Code ֤
     */
    openlog(CmdName, (LOG_PID), LOG_DAEMON);
    if (get_client_name(0) < 0) {
	closelog();
	shutdown(0,2); close(0);
	exit(10);
    }

    /* ҥץνλƻ뤹ϥɥ */
    if (setjmp(EnvBeforeFork)) {
	closelog();
	shutdown(0,2); close(0);
	exit(1);
    }
    signal(SIGCHLD, child_term1);

    /* Read Request Line from Client */
    if ((req = read_request(0)) != (struct yy_call_request *)NULL) {
	int port, xtty;
	char fpath[256];
	sprintf(fpath, "%s/%s.desc", desc_dir, req->req_name);
	if (read_description(req, fpath) < 0) {
	    syslog(LOG_ERR, "Error -- Terminate");
	    closelog();
	    shutdown(0,2); close(0);
	    exit(1);
	}

	port = open_session(req);
	xtty = (-1);
	/* ǥХå⡼ɤ xterm ɬפǤ Xterm 򳫻Ϥ
	 */
	if (strstr(req->req_option, "xterm"))
	    xtty = open_xterm(req->req_xdisp);

	if (do_on_session(req, port, xtty) < 0) {
	    syslog(LOG_ERR, "I/O error on PTY");
	    closelog();
	    exit(1);
	}
	(void) close_session(port);
    }
    closelog();
    shutdown(0,2); close(0);
    exit(0);
}

#ifndef INETD
static jmp_buf EnvForMainLoop;

static void terminate_one_yyabox()
{
    int status;
    wait(&status);
    longjmp(EnvForMainLoop, 1);
}
#endif /*!INETD*/

main(argc, argv)
    int argc;
    char *argv[];
{
    char buf[1024];
    int leng = 0;
    char *s = buf;
    char *desc_dir, desc_dir_buf[1024];
    int ent;
#ifndef INETD
    int sock;
#endif /*!INETD*/

    CmdName = *argv++; argc--;
    if (strrchr(CmdName,'/') != (char *)NULL)
	CmdName = strrchr(CmdName,'/') + 1;

    /* -d dir */
    if (argc > 1 && strcmp(argv[0], "-d") == 0) {
	desc_dir = argv[1];
	argc -= 2; argv += 2;
    } else {
#ifdef INST
	sprintf(desc_dir_buf, "%s/DESC", YYLIBDIR);
#else
	strcpy(desc_dir_buf, "./DESC");
#endif
	desc_dir = desc_dir_buf;
    }
#ifdef INST
    LibDir = YYLIBDIR;
#else
    LibDir = ".";
#endif

#ifndef INETD
    if ((sock = setup_server()) < 0) exit(10);
    setjmp(EnvForMainLoop);
    signal(SIGCHLD, terminate_one_yyabox);
    for (;;) {
	int req;
	int pid;
	struct sockaddr_in addr; int addrlen;
	addrlen = sizeof(addr);
	if ((req = accept(sock, addr, &addrlen)) < 0)
	    continue;
	if ((pid = fork()) == 0) {
	    setpgrp(0,getpid());
	    syslog(LOG_DEBUG, "do_main on %s", desc_dir);
	    closelog();
	    dup2(req, 0); close(req); close(1); close(2);
	    do_main(desc_dir);
	    /*NOTREACHED*/
	}
	sleep(1);
	close(req);
    }
#else
    do_main(desc_dir);
#endif /*!INETD*/
    /*NOTREACHED*/
}



/*
 * pty μ
 * '/dev/ptyp0' ֤˻ȤΤõ
 *
 * Return Value:
 *  Open  pty  File Descripter
 *  Open Ǥ pty ¸ߤʤ (-1) ֤
 *
 * Side Effect:
 *  Open ˤϰ name 
 *  '/dev/ptyXX'  Open  pty ̾ꤵ
 */
int get_new_pty(name)
    char *name;
{
    int fd;
    register int c1, c2;
    char *pty_dev_num = "0123456789abcdef";

    strcpy(name, "/dev/ptyp0");
    for (c1 = 'p'; c1 <= 's'; c1++) {
	name[strlen("/dev/pty")] = c1;
	for (c2 = 0; c2 < 16; c2++) {
	    name[strlen("/dev/ptyp")] = pty_dev_num[c2];
	    if ((fd = open(name, O_RDWR)) >= 0) {
		return fd;
	    }
	}
    }
    return -1;
}


/*
 * ʸ str Ф %x νԤʤ
 *  %x  X ̾
 *  %s  YY-server ̾
 * 줾ִ
 *
 * BUG:
 *  ƤӽФȤƱΰѤΤ
 *  θƤӽФƤ˲Ƥޤ
 */
char *expand_string(req, str)
    struct yy_call_request *req;
    char *str;
{
    static char buf[512];
    char *s, *p;
    for (s = str, p = buf; *s != '\0'; s++) {
	if (*s == '%' && *(s+1) != '\0') {
	    s++;
	    if (*s == 'x') {
		strcpy(p, req->req_xdisp);
		p += strlen(req->req_xdisp);
	    } else if (*s == 's') {
		strcpy(p, req->req_server);
		p += strlen(req->req_server);
	    } else {
		*p++ = *s;
	    }
	} else {
	    *p++ = *s;
	}
    }
    *p = '\0';
    return buf;
}

/*
 * ӥ󶡥ޥɤθƤӽФꤹ
 */
char **make_command_line(req)
    struct yy_call_request *req;
{
    struct yy_call_command *cmd;
    static char buf[4096];
    static char *argbuf[64];
    char **ag = argbuf;
    char *s, *p;

    for (cmd = req->req_command; cmd ; cmd = cmd->com_next)
	if (isSameCOM(cmd->com_label, COM_COMMAND)) break;
    if (cmd == (struct yy_call_command *)NULL) {
	syslog(LOG_ERR, "No command line for %s", req->req_name);
	return (char **)NULL;
    }

    argbuf[0] = argbuf[1] = buf;
    ag = &argbuf[2];
    for (s = cmd->com_string, p = buf; *s != '\0'; s++) {
	if (*s == '%' && *(s+1) != '\0' && !isspace(*(s+1))) {
	    s++;
	    if (*s == 'x') {
		strcpy(p, req->req_xdisp);
		p += strlen(req->req_xdisp);
	    } else if (*s == 's') {
		strcpy(p, req->req_server);
		p += strlen(req->req_server);
	    } else {
		*p++ = *s;
	    }
	} else if (isspace(*s)) {
	    *p++ = '\0';
	    *ag++ = p;
	} else {
	    *p++ = *s;
	}
    }
    *p = '\0';
    *ag = (char *)NULL;

    if (strrchr(argbuf[0], '/')) argbuf[1] = strrchr(argbuf[0], '/') + 1;
    return argbuf;
}


/*
 * ӥ󶡥ޥɤƤӽФ
 *
 *
 *
 *
 */
static char *command_environ[] = {
    "TERM=network",
    "HOME=/tmp",
    "PATH=/bin:/usr/bin:/usr/ucb",
    "SHELL=/bin/sh",
    NULL,
};

int open_session(req)
    struct yy_call_request *req;
{
    char **args, **ss;
    char tty_name[64], pty_name[64];
    int pty_fd, tty_fd;
    struct termios term;
    int pid;

    args = make_command_line(req);
    if (args == (char **)NULL)
	return -1;

    fprintf(stdout, "Exec:");
    for (ss = args; *ss ; ss++) fprintf(stdout, " %s", *ss);
    fprintf(stdout, "\n");

    if ((pty_fd = get_new_pty(pty_name)) < 0) {
	syslog(LOG_ERR, "No PTY");
	return -1;
    }
    strcpy(tty_name, pty_name);
    tty_name[strlen("/dev/")] = 't';
    tty_fd = open(tty_name, O_RDWR);
    if (tty_fd < 0) {
	syslog(LOG_ERR, "Can't open %s", tty_name);
	return -1;
    }

    /* tty ѹ
     *  ޥ¦ Non-canonical Mode ˤƤ
     *   MIN=0, TIME=XX ˤ Timeout ä餹Ф⡼
     *   ü쥭饯Ф
     */
    /*ioctl(tty_fd, TIOCSCTTY, on);*/
    if (ioctl(tty_fd, TCGETS, &term) == 0) {
	term.c_lflag &= ~(ICANON);
	term.c_cc[VMIN] = 1;
	term.c_cc[VTIME] = 0;
	ioctl(tty_fd, TCSETS, &term);
    }
    if ((pid = fork()) < 0) {
	syslog(LOG_ERR, "Can't create application process");
	return -1;
    }
    if (pid == 0) {
	extern char **environ;
	dup2(tty_fd, 0);
	dup2(tty_fd, 1);
	dup2(tty_fd, 2);
	close(tty_fd);
	close(pty_fd);
	environ = command_environ;
	execv(args[0], &args[1]);
	syslog(LOG_ERR, "Can't exec %s", args[0]);
	_exit(101);
    }
    close(tty_fd);
    return pty_fd;
}


static jmp_buf EnvForXterm;

static void abort_xterm()
{
    longjmp(EnvForXterm, 1);
}

/*
 *  pty ơ pty  xterm ư
 * tty ¦ RDWR  open ֤
 *
 * tty ¦ 餫 ID äƤޤǤ read ԤĤ
 * δ֤ xterm λϤ٤Ƥ
 * -1 ֤
 */
int open_xterm(xdisp)
    char *xdisp;
{
    int pid;
    char argbuf[10];
    int pty, tty;
    char pty_name[64], tty_name[64];
    char buf[1024]; int buflen, rlen;
    struct termios term;
    static void (*osig_child)();

    if ((pty = get_new_pty(pty_name)) < 0) {
	syslog(LOG_ERR, "No PTY");
	return -1;
    }
    strcpy(tty_name, pty_name);
    tty_name[strlen("/dev/")] = 't';
    if ((tty = open(tty_name, O_RDWR)) < 0) {
	syslog(LOG_ERR, "Can't open tty %s", tty_name);
	close(pty);
	return -1;
    }
    /* tty ѹ
     *  ⤷ʤ⡼
     *   MIN=1, TIME=0
     */
    /*ioctl(tty_fd, TIOCSCTTY, on);*/
    /* tty  NOECHO ˤƤɬפ */
    if (ioctl(tty, TCGETS, &term) == 0) {
	term.c_lflag &= ~(ISIG|ECHO|ICANON|IEXTEN);
	term.c_cc[VMIN] = 1;
	term.c_cc[VTIME] = 0;
	ioctl(tty, TCSETS, &term);
    }

    if (setjmp(EnvForXterm)) {
	signal(SIGCHLD, osig_child);
	close(tty); close(pty);
	return -1;
    }
    osig_child = signal(SIGCHLD, abort_xterm);

    strcpy(argbuf, "-Sxx2");
    argbuf[strlen("-S")] = pty_name[strlen("/dev/pty")];
    argbuf[strlen("-Sx")] = pty_name[strlen("/dev/ptyp")];
    if ((pid = fork()) < 0) {
	syslog(LOG_ERR, "Can't create application process");
	signal(SIGCHLD, osig_child);
	close(tty); close(pty);
	return -1;
    }

    if (pid == 0) {
	dup2(pty, 0);
	dup2(pty, 1);
	dup2(pty, 2);
	close(pty); close(tty);
	execl(XTERMPATH, "xterm", argbuf, "-display", xdisp, (char *)0);
	syslog(LOG_ERR, "Can't exec xterm");
	_exit(10);
    }

    /* tty  id ֤äƤΤԤ
     */
    close(pty);



    buflen = 0;
    while ((rlen = read(tty, &buf[buflen], sizeof(buf)-buflen)) > 0) {
	buflen += rlen;
	if (memchr(buf, '\n', buflen) != (char *)NULL) break;
    }
    if (rlen <= 0) {
	syslog(LOG_ERR, "I/O error on %s", tty_name);
	kill(pid, SIGTERM);
	sleep(1);
	signal(SIGCHLD, osig_child);
	close(tty);
	return -1;
    }
    signal(SIGCHLD, osig_child);
    buf[buflen] = '\0';
    syslog(LOG_DEBUG, "Window ID: %s", buf);
    return tty;
}





int write_on_port(port, str, len)
    int port;
    char *str;
    int len;
{
    return write(port, str, len);
}

int wait_on_port(port, str, len, xterm)
    int port;
    char *str;
    int len;
    int xterm;
{
    char buf[1024];
    int buflen = 0;
    int notmatch = 1;

    while (notmatch) {
	register char *top;
	int rlen = read(port, &buf[buflen], sizeof(buf)-buflen);
	if (rlen <= 0) return rlen;
	buflen += rlen;
	buf[buflen] = '\0'; /*ǥХå*/
	/*syslog(LOG_DEBUG, "String: %s", buf);*/

	/* buf Ƭ buflen ܤޤǤ str[0] Ʊʸ¸ߤ
	 * ֤򸫤Ĥ롥 top Ȥ
	 */
	while (buflen >= len) {
	    top = memchr(buf, str[0], buflen);
	    if (top == (char *)NULL) {
		/* ΤʤΤǡ򤹤Ƥ*/
		if (xterm > 0) write(xterm, buf, buflen);
		buflen = 0; break;
	    }
	    /* buf Ƭ top μޤǤפʥǡǤ */
	    if (buflen - (top-buf) >= len) {
		*(top+buflen) = '\0'; /*ǥХå*/
		syslog(LOG_DEBUG, "Check %s", top);
		if (memcmp(top, str, len) == 0) {
		    notmatch = 0;
		    if (xterm > 0) write(xterm, buf, buflen);
		    buflen = 0;
		    break;
		}
		top++; /* ޥåʤäΤ top פˤʤä */
	    }
	    /* buf Ƭ top ΰޤǤפʥǡǤΤ
	     * ΤƤ */
	    if (top != buf) {
		register char *p, *q;
		register int l;
		if (xterm >= 0) write(xterm, buf, (int)(top-buf));
		buflen -= (top-buf);
		for (p = top, q = buf, l = buflen; l > 0; l--)
		    *q++ = *p++;
	    }
	}
    }
    return 1;
}


int do_on_session(req, port, xterm)
    struct yy_call_request *req;
    int port, xterm;
{
    struct yy_call_command *cmd;
    int send_len, recv_len;
    char send_buf[2048], recv_buf[2048];

    /*sleep(10);*/
    /* Search first Send/Wait Command */
    for (cmd = req->req_command; cmd ; cmd = cmd->com_next) {
	/*syslog(LOG_DEBUG, "Command '%s'", cmd->com_label);*/
	if (isSameCOM(cmd->com_label, COM_SEND)) {
	    char *exp;
	    syslog(LOG_DEBUG, "Send '%s'", cmd->com_string);
	    exp = expand_string(req, cmd->com_string);
	    write(port, exp, strlen(exp));
	}
	if (isSameCOM(cmd->com_label, COM_WAIT)) {
	    /* read on port */
	    syslog(LOG_DEBUG, "Wait '%s'", cmd->com_string);
	    wait_on_port(port, cmd->com_string,
			 strlen(cmd->com_string), xterm);
	}
    }

    /* ưŪΤʤʤäΤǤȤ port  read Τߤ
     * ԤʤȤˤ
     * âxterm ƤФȤΤȤ
     */
    send_len = recv_len = 0;
    for (;;) {
	int width;
	fd_set rfds, wfds;
	width = 0;
	FD_ZERO(&rfds); FD_ZERO(&wfds);
	if (send_len > 0)
	    { FD_SET(port, &wfds); if (port > width) width = port; }
	if (recv_len == 0)
	    { FD_SET(port, &rfds); if (port > width) width = port; }
	if (send_len == 0 && xterm >= 0)
	    { FD_SET(xterm, &rfds); if (xterm > width) width = xterm; }
	if (recv_len > 0 && xterm >= 0)
	    { FD_SET(xterm, &wfds); if (xterm > width) width = xterm; }
	else recv_len = 0;

	if (select(width+1, &rfds, &wfds, NULL, NULL) < 0) {
	    syslog(LOG_ERR, "Error on select");
	    return -1;
	}
	if (FD_ISSET(port, &rfds))
	    if ((recv_len = read(port, recv_buf, sizeof(recv_buf))) < 0) {
		syslog(LOG_ERR, "Error on Port %d (read)", port);
		return recv_len;
	    }
	if (FD_ISSET(port, &wfds)) {
	    register int w;
	    if ((w = write(port, send_buf, send_len)) < 0) {
		syslog(LOG_ERR, "Error on Port %d (write)", port);
		return w;
	    }
	    send_len = 0;
	}
	if (xterm >= 0 && FD_ISSET(xterm, &rfds))
	    if ((send_len = read(xterm, send_buf, sizeof(send_buf))) < 0) {
		syslog(LOG_ERR, "Error on Xterm %d (read)", port);
		return send_len;
	    }
	if (xterm >= 0 && FD_ISSET(xterm, &wfds)) {
	    register int w;
	    if ((w = write(xterm, recv_buf, recv_len)) < 0) {
		syslog(LOG_ERR, "Error on Xterm %d (write)", port);
		return w;
	    }
	    recv_len = 0;
	}
    }
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
