;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-
(in-package :yy-geo)

(defvar *viewer-switches*
	'((0 0 "All"       	define-accept-all-methods    *b-color*)
	  (1 0 "Vertex"		define-accept-vertex-methods *b-color*)
	  (2 0 "Edge"		define-accept-edge-methods   *b-color*)
	  (3 0 "Face"		define-accept-face-methods   *b-color*)
	  (4 0 "Solid"		define-accept-solid-methods  *b-color*)
	  (5 0 "None"		define-accept-none-methods   *b-color*)

	  (0 1 "Clear"  	define-clear-methods)
	  (1 1 "Redisplay"  	define-redisplay-methods)
	  (2 1 "Hidden"		define-draw-hidden-face-methods     *g-color*)
	  (3 1 "Number"		define-draw-sequence-number-methods *m-color*)
	  (4 1 "AXIS"		define-draw-axis-methods 	    *m-color*)


	  (6 0 "View"   	define-change-view-methods)
	  (6 1 "Aim"    	define-change-aim-methods      *y-color*)
	  (6 2 "Factor" 	define-change-factor-methods)
	  (5 1 "Vanishig"    	define-change-vanishig-methods *y-color*)

	  (0 2 "Lift"		define-lift-methods        *m-color*)
	  (1 2 "Collapse"	define-collapse-methods    *m-color*)
	  (2 2 "Extrude"	define-extrude-methods     *r-color*)
	  (3 2 "Cut"		define-cut-methods         *r-color*)
	  (4 2 "Move"		define-move-methods        *r-color*)
	  (5 2 "Accept"		define-accept-methods      *y-color*)
;;	  (5 2 "Delete"		define-delete-methods      *r-color*)
;;        (? ? "Add"		define-add-methods	   *r-color*)	  
	  ))

(defun define-accept-all-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'accept-all-internal)))

(defun define-accept-vertex-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'accept-vertex-internal)))

(defun define-accept-edge-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'accept-edge-internal)))

(defun define-accept-face-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'accept-face-internal)))

(defun define-accept-solid-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'accept-solid-internal)))

(defun define-accept-none-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots ((window yy::object-parent)) switch
    (with-slots (accept-type previous-accept-type-switch) window
      (setf accept-type nil
	    previous-accept-type-switch switch)
      (draw-switch switch :active)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'accept-none-internal)))

(defun define-clear-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'clear-method-internal)))

(defun define-redisplay-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'redisplay-internal)))

(defun define-draw-hidden-face-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots ((window yy::object-parent)) switch
    (with-slots ((viewer superior)) window
      (with-slots (draw-hidden-face) viewer
	(if draw-hidden-face
	    (draw-switch switch :deactive)
	    (draw-switch switch :active)))))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'draw-hidden-face-internal
	  (yy::button2-method switch) 'draw-hidden-face-internal2)))

(defun define-draw-sequence-number-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots ((window yy::object-parent)) switch
    (with-slots ((viewer superior)) window
      (with-slots (draw-sequence-number) viewer
	(if draw-sequence-number
	    (draw-switch switch :active)
	    (draw-switch switch :deactive)))))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'draw-sequence-number-internal)))

(defun define-draw-axis-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots ((window yy::object-parent)) switch
    (with-slots ((viewer superior)) window
      (with-slots (draw-axis) viewer
	(if draw-axis
	    (draw-switch switch :active)
	    (draw-switch switch :deactive)))))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'draw-axis-internal)))

(defun define-change-view-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'change-view-internal
	  (yy::button2-method switch)   'change-view-internal2)))

(defun define-change-aim-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'change-aim-internal
	  (yy::button2-method switch)   'change-aim-internal2 )))

(defun define-change-vanishig-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'change-vanishig-internal
	  (yy::button2-method switch)   'change-vanishig-internal)))

(defun define-change-factor-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'change-factor-internal
	  (yy::button2-method switch)   'change-factor-internal2)))

(defun define-accept-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'accept-internal
	  (yy::button2-method switch)   'accept-internal)))

(defun define-lift-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'lift-internal
	  (yy::button2-method switch)   'lift-internal)))

(defun define-collapse-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'collapse-internal
	  (yy::button2-method switch)   'collapse-internal)))

(defun define-extrude-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch)   'extrude-internal
	  (yy::button2-method switch)   'extrude-internal)))

(defun define-cut-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'cut-method-internal)))

(defun define-move-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::with-event-object (switch)
    (setf (yy::button1-method switch) 'move-method-internal)))


;;;
;;;Define mouse event methods for VIEWER-WINDOW's switches.
;;;

;;;real ...
(defmethod set-accept-type  ((switch switch-with-title) type prompt-string)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots ((window yy::object-parent)) switch
    (with-slots (accept-type previous-accept-type-switch) window
      (unless (eql type accept-type)
	(when previous-accept-type-switch
	  (draw-switch previous-accept-type-switch :deactive))
	(draw-switch switch :active)
	(setf accept-type type
	      previous-accept-type-switch switch)
	(yy::draw-prompt prompt-string)
	))))

(defmethod accept-all-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (set-accept-type switch 'basic-view-object "ALL"))

(defmethod accept-vertex-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (set-accept-type switch 'view-vertex "VERTEX"))

(defmethod accept-edge-internal ((switch switch-with-title) mouse-state)
  (declare (ignore mouse-state))
  (set-accept-type switch 'view-edge "EDGE"))

(defmethod accept-face-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (set-accept-type switch 'view-face "FACE"))

(defmethod accept-solid-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (set-accept-type switch 'view-solid "SOLID"))

(defmethod accept-none-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (set-accept-type switch nil "NONE"))

(defmethod accept-internal ((switch switch-with-title) state)
  (declare (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (accept-type) window
	(if accept-type
	    (progn
	      (yy::draw-prompt (format nil "Accept ~a" accept-type))
	      (let ((view-object (yy::accept accept-type window)))
		(when view-object
		  (with-slots (object) view-object
		    (yy::draw-prompt (format nil "~a" object))))))
	    (yy::draw-prompt "Now Accept Type Null"))))))

(defmethod clear-method-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (yy::terminate-accept window)
      (yy::clear-window-stream window))))

(defmethod redisplay-internal ((switch switch-with-title) mouse-state)
  (with-switch-default-look (switch)
    (let* ((bt (yy::mouse-state-button-state mouse-state))
	   ;; left-1 recompute-position is nil
	   (recompute-position (zerop (logand yy::*mouse-left-1* bt)))
	   ;; control set-visibility is nil
	   (set-visibility (zerop (logand yy::*control* bt))))
      (with-slots ((window yy::OBJECT-PARENT)) switch
	(with-slots ((view SUPERIOR)) window
	  (redisplay-switches window)
	  (redisplay view recompute-position set-visibility))))))

(defmethod draw-hidden-face-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (with-slots ((window yy::object-parent) select-color) switch
    (with-slots ((view superior)) window 
      (with-slots (draw-hidden-face face-color) view
	(setf draw-hidden-face (null draw-hidden-face))
	(cond (draw-hidden-face
	       (setf select-color *g-color*
		     face-color yy::*transparent*)
	       (draw-switch switch :deavtive))
	      (t
	       (setf select-color *g-color*
		     face-color yy::*transparent*)
	       (draw-switch switch :active)))
	(redisplay view nil)
	))))

(defmethod draw-hidden-face-internal2 ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (with-slots ((window yy::object-parent) select-color) switch
    (with-slots ((view superior)) window 
      (with-slots (draw-hidden-face face-color) view
	(setf draw-hidden-face (null draw-hidden-face))
	(cond (draw-hidden-face
	       (setf select-color *g-color*
		     face-color yy::*transparent*)
	       (draw-switch switch :deavtive))
	      (t
	       (setf select-color *r-color*
		     face-color yy::*white-color*)
	       (draw-switch switch :active)))
	(redisplay view nil)
	))))

(defmethod draw-sequence-number-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (with-slots ((window yy::object-parent)) switch
    (with-slots ((view superior)) window 
      (with-slots (draw-sequence-number) view
	(setf draw-sequence-number (null draw-sequence-number))
	(if draw-sequence-number
	    (draw-switch switch :active)
	    (draw-switch switch :deavtive))
	(redisplay view nil)))))

(defmethod draw-axis-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
           (ignore mouse-state))
  (with-slots ((window yy::object-parent)) switch
    (with-slots ((view superior)) window 
      (with-slots (draw-axis) view
	(setf draw-axis (null draw-axis))
	(if draw-axis
	    (draw-switch switch :active)
	    (draw-switch switch :deavtive))
	(draw-axis view)))))

(defmethod change-view-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state))
	  (dx 0.0)
	  (dy 0.0)
	  (dz 0.0)
	  (dd 1.0))
      (cond ((not (zerop (logand yy::*control* bt)))
	     (setf dd (* 10.0 dd)))
	    ((not (zerop (logand yy::*meta*    bt)))
	     (setf dd (* 0.1 dd))))
      (cond ((not (zerop (logand yy::*mouse-left-1* bt)))
	     (setf dx dd))
	    ((not (zerop (logand yy::*mouse-middle-1* bt)))
	     (setf dy dd))
	    ((not (zerop (logand yy::*mouse-right-1* bt)))
	     (setf dz dd)))
      (with-slots ((view SUPERIOR)) (yy::OBJECT-PARENT switch)
	(with-slots (view-point) view
	  (let ((new-x (+ (get-vector-x view-point) dx))
		(new-y (+ (get-vector-y view-point) dy))
		(new-z (+ (get-vector-z view-point) dz)))
	    (when (not (zerop (logand yy::*shift*   bt)))
	      (setf new-x 80.0
		    new-y 100.0
		    new-z 50.0))
	    (yy::draw-prompt
	      (format nil "VIEW x:~d y:~d z:~d" new-x new-y new-z))
	    (change-view-point view (list new-x new-y new-z))))))))

(defmethod change-view-internal2 ((switch switch-with-title) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (selection accept-type (view superior)) window
	(yy::draw-prompt "Chaging View")
	(let ((ans))
	  (yy::draw-prompt "Please Select center viewer")
	  (when (setf ans (yy::accept t window))
	    (when ans
	      (yy::set-window-method window 'change-moving-view
				     :event-mask (logior yy::*shift*
							 yy::*control*
							 yy::*meta*
							 yy::*mouse-move*))
	      (yy::set-window-method window 'moving-finish
				     :event-mask yy::*mouse-left-1*)
	      (setf selection ans)
	      (yy::wait-process 'moving-terminate window)
	      (yy::disnable-event window (logior yy::*control*
						 yy::*meta*
						 yy::*shift*
						 yy::*mouse-move*
						 yy::*mouse-left-1*))
	      (yy::draw-prompt "Moving Finished")
	      (redisplay view nil)
	      )))))))

(defmethod change-moving-view ((window viewer-window) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (previous-x previous-y selection (view superior)) window
    (when selection
      (unless previous-x (setf previous-x (yy::mouse-state-x-position state)))
      (unless previous-y (setf previous-y (yy::mouse-state-y-position state)))
      (if (not (zerop (logand (yy::mouse-state-button-state state)
			      yy::*shift*)))
	  (setf previous-x (yy::mouse-state-x-position state)
		previous-y (yy::mouse-state-y-position state))
	  (unless (and (= previous-x (yy::mouse-state-x-position state))
		       (= previous-y (yy::mouse-state-y-position state)))
	    (let ((r (/ *pi* 180))
		  (step-x (- (yy::mouse-state-x-position state) 
			     previous-x))
		  (step-y (- (yy::mouse-state-y-position state)
			     previous-y)))
	      (when (not (zerop (logand (yy::mouse-state-button-state state)
					yy::*control*)))
		(setf step-x (* 10 step-x)
		      step-y (* 10 step-y)))
	      (when (not (zerop (logand (yy::mouse-state-button-state state)
					yy::*meta*)))
		(setf step-x (* .1 step-x)
		      step-y (* .1 step-y)))
	      (setf previous-x
		    (yy::mouse-state-x-position state)
		    previous-y
		    (yy::mouse-state-y-position state)
		    step-x (* r step-x)
		    step-y (* r step-y))
	      (with-slots (view-point aim-point) view
		(let ((new-view-point (change view-point aim-point step-x step-y)))
		  (yy::draw-prompt (format nil "View Point ~a " new-view-point ))
		  ;; not erase
		  #+ignore
		  (yy::draw-string-xy window
				      (format nil "View Point ~a ~a ~a "
					      new-view-point step-x step-y ) 15 15)
		  (change-view-point view new-view-point t)))))))))

(defmethod change-aim-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state))
	  (dx 0.0)
	  (dy 0.0)
	  (dz 0.0)
	  (dd 1.0))
      (when (not (zerop (logand yy::*control* bt)))
	(setf dd (* 10.0 dd)))
      (when (not (zerop (logand yy::*meta*    bt)))
	(setf dd (* 0.1 dd)))

      (when (not (zerop (logand yy::*mouse-left-1* bt)))
	(setf dx dd))
      (when (not (zerop (logand yy::*mouse-middle-1* bt)))
	(setf dy dd))
      (when (not (zerop (logand yy::*mouse-right-1* bt)))
	(setf dz dd))
      (with-slots ((view SUPERIOR)) (yy::OBJECT-PARENT switch)
	(with-slots (aim-point) view
	  (let ((new-x (+ (get-vector-x aim-point) dx))
		(new-y (+ (get-vector-y aim-point) dy))
		(new-z (+ (get-vector-z aim-point) dz)))
	    (when (not (zerop (logand yy::*shift*   bt)))
	      (setf new-x 0.0
		    new-y 0.0
		    new-z 0.0))
	    (yy::draw-prompt
	      (format nil "AIM x:~d y:~d z:~d" new-x new-y new-z))
	    (change-aim-point view (list new-x new-y new-z))))))))

(defmethod change-aim-internal2 ((switch switch-with-title) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (selection accept-type (view superior)) window
	(yy::draw-prompt "Chaging Aim")
	(let ((ans))
	  (yy::draw-prompt "Please Select center viewer")
	  (when (setf ans (yy::accept t window))
	    (when ans
	      (yy::set-window-method window 'change-moving-aim
				     :event-mask (logior yy::*shift*
							 yy::*control*
							 yy::*meta*
							 yy::*mouse-move*))
	      (yy::set-window-method window 'moving-finish
				     :event-mask yy::*mouse-left-1*)
	      (setf selection ans)
	      (yy::wait-process 'moving-terminate window)
	      (yy::disnable-event window (logior yy::*control*
						 yy::*meta*
						 yy::*shift*
						 yy::*mouse-move*
						 yy::*mouse-left-1*))
	      (yy::draw-prompt "Moving Finished")
	      (redisplay view nil)
	      )))))))

(defmethod change-moving-aim ((window viewer-window) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (previous-x previous-y selection (view superior)) window
    (when selection
      (unless previous-x (setf previous-x (yy::mouse-state-x-position state)))
      (unless previous-y (setf previous-y (yy::mouse-state-y-position state)))
      (if (not (zerop (logand (yy::mouse-state-button-state state)
			      yy::*shift*)))
	  (setf previous-x (yy::mouse-state-x-position state)
		previous-y (yy::mouse-state-y-position state))
	  (unless (and (= previous-x (yy::mouse-state-x-position state))
		       (= previous-y (yy::mouse-state-y-position state)))
	    (let ((r (/ *pi* 180))
		  (step-x (- (yy::mouse-state-x-position state) 
			     previous-x))
		  (step-y (- (yy::mouse-state-y-position state)
			     previous-y)))
	      (when (not (zerop (logand (yy::mouse-state-button-state state)
					yy::*control*)))
		(setf step-x (* 10 step-x)
		      step-y (* 10 step-y)))
	      (when (not (zerop (logand (yy::mouse-state-button-state state)
					yy::*meta*)))
		(setf step-x (* .1 step-x)
		      step-y (* .1 step-y)))
	      (setf previous-x
		    (yy::mouse-state-x-position state)
		    previous-y
		    (yy::mouse-state-y-position state)
		    step-x (* r step-x)
		    step-y (* r step-y))
	      (with-slots (view-point aim-point) view
		(let ((new-aim-point (change aim-point view-point step-x step-y)))
		  (yy::draw-prompt (format nil "Aim Point ~a " new-aim-point ))
		  ;; not erase
		  #+ignore
		  (yy::draw-string-xy window
				      (format nil "Aim Point ~a ~a ~a "
					      new-aim-point step-x step-y ) 15 15)
		  (change-aim-point view new-aim-point t)))))))))

(defmethod change-vanishig-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state))
	  (p 0.0)
	  (q 0.0)
	  (r 0.0)
	  (dd -0.01))
      (when (not (zerop (logand yy::*control* bt)))
	(setf dd (* 10.0 dd)))
      (when (not (zerop (logand yy::*meta*    bt)))
	(setf dd (* 0.1 dd)))
      (when (not (zerop (logand yy::*mouse-left-1* bt)))
	(setf r dd))
      (when (not (zerop (logand yy::*mouse-middle-1* bt)))
	(setf q dd))
      (when (not (zerop (logand yy::*mouse-right-1* bt)))
	(setf p dd))


      (when (not (zerop (logand yy::*mouse-left-2* bt)))
	(setf r (- dd)))
      (when (not (zerop (logand yy::*mouse-middle-2* bt)))
	(setf q (- dd)))
      (when (not (zerop (logand yy::*mouse-right-2* bt)))
	(setf p (- dd)))

      (with-slots ((view SUPERIOR)) (yy::OBJECT-PARENT switch)
	(with-slots (vanishig) view
	  (let ((new-p (+ (get-vector-x vanishig) p))
		(new-q (+ (get-vector-y vanishig) q))
		(new-r (+ (get-vector-z vanishig) r)))
	    (yy::draw-prompt
	      (format nil "Vanishig p:~d q:~d r:~d" new-p new-q new-r))
	    (change-vanishig view (list new-p new-q new-r))))))))


(defmethod change-factor-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state))
	  (factor 1.0))
      (cond ((not (zerop (logand yy::*mouse-left-1* bt)))
	     (setf factor 1.1))
	    ((not (zerop (logand yy::*mouse-middle-1* bt)))
	     (setf factor 1.5))
	    ((not (zerop (logand yy::*mouse-right-1* bt)))
	     (setf factor 2.0)))
      (cond ((not (zerop (logand yy::*control* bt)))
	     (setf factor (* factor 10)))
	    ((not (zerop (logand yy::*meta*    bt)))
	     (setf factor (* factor .1))))
      (with-slots ((view superior)) (yy::object-parent switch)
	(with-slots (view-factor) view
	  (let ((new-factor (* view-factor factor)))
	    (when (not (zerop (logand yy::*shift*   bt)))
	      (setf new-factor 1.0))
	    (yy::draw-prompt (format nil "New Factor ~a" new-factor))
	    (change-view-factor view new-factor)))))))

(defmethod change-factor-internal2 ((switch switch-with-title) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (selection accept-type (view superior)) window
	(yy::draw-prompt "Chaging Factor")
	(let ((ans))
	  (yy::draw-prompt "Please Select center of viewer object")
	  (when (setf ans (yy::accept t window))
	    (when ans
	      (yy::set-window-method window 'change-moving-factor
				     :event-mask (logior yy::*shift*
							 yy::*control*
							 yy::*meta*
							 yy::*mouse-move*))
	      (yy::set-window-method window 'moving-finish
				     :event-mask yy::*mouse-left-1*)
	      (setf selection ans)
	      (yy::wait-process 'moving-terminate window)
	      (yy::disnable-event window (logior yy::*control*
						 yy::*meta*
						 yy::*shift*
						 yy::*mouse-move*
						 yy::*mouse-left-1*))
	      (yy::draw-prompt "Moving Finished")
	      (redisplay view nil nil t)
	      )))))))

(defmethod change-moving-factor ((window viewer-window) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (previous-x previous-y selection (view superior)) window
    (when selection
      (unless previous-y (setf previous-y (yy::mouse-state-y-position state)))
      (if (not (zerop (logand (yy::mouse-state-button-state state)
			      yy::*shift*)))
	  (setf previous-y (yy::mouse-state-y-position state))
	  (unless (= previous-y (yy::mouse-state-y-position state))
	    (let ((step (* .01 (- (yy::mouse-state-y-position state)
				 previous-y))))
	      (when (not (zerop (logand (yy::mouse-state-button-state state)
					yy::*control*)))
		(setf step (* 10 step)))
	      (when (not (zerop (logand (yy::mouse-state-button-state state)
					yy::*meta*)))
		(setf step (* .1 step)))
	      (setf previous-y (yy::mouse-state-y-position state))
	      (with-slots (view-factor) view
		(let ((new-factor (+ view-factor step)))
		  (if (< 5.0 new-factor) (setf new-factor 5.0))
		  (if (< new-factor 0.1) (setf new-factor 0.1))
		  (yy::draw-prompt (format nil "New Factor ~a" new-factor))
		  ;; not erase
		  #+ignore
		  (yy::draw-string-xy window
				      (format nil "New Factor ~a" new-factor) 15 15)
		  (change-view-factor view new-factor t)))))))))


(defmethod lift-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore mouse-state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (selection (view superior)) window
	(yy::draw-prompt "Lift     Please Select face")
	(let ((view-face (yy::accept 'view-face window)))
	  (when view-face
	    (yy::draw-prompt "Please Select edge")
	    (with-slots ((face object) edges) view-face
	      (let ((view-edge (yy::accept (cons 'member edges) window)))
		(when view-edge
		  (with-slots ((edge object)) view-edge
		    (with-slots (normal-vector) face
		      (yy::draw-prompt (format nil "Lift ~a face by ~a" face edge))
		      (yy::set-window-method window 'lift-moving-internal
					     :event-mask (logior yy::*control*
								 yy::*meta*
								 yy::*shift*
								 yy::*mouse-move*))
		      (yy::set-window-method window 'moving-finish
					     :event-mask yy::*mouse-left-1*)
		      (setf selection (cons face (lift-edge face edge normal-vector)))
		      (yy::wait-process 'moving-terminate window)
		      (yy::disnable-event window (logior yy::*control*
							 yy::*meta*
							 yy::*shift*
							 yy::*mouse-move*
							 yy::*mouse-left-1*))
		      (yy::draw-prompt "Lift Finished")
		      (with-slots (polyhedron) face
			(with-slots (view-objects) polyhedron
			  (dolist (view-object view-objects)
			    (redraw-view-solid view-object))))
		      )))))))))))

(defmethod lift-moving-internal ((window viewer-window) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (previous-x previous-y selection (view superior)) window
    (when selection
      (unless previous-x (setf previous-x 1))
      (unless previous-y
	(setf previous-y (yy::mouse-state-y-position state)))
      (if (not (zerop (logand (yy::mouse-state-button-state state)
			      yy::*shift*)))
	  (setf previous-y (yy::mouse-state-y-position state))
	  (unless (= previous-y (yy::mouse-state-y-position state))
	    (let ((face (car selection))
		  (edge (cdr selection)))
	      (with-slots (normal-vector) face
		(let ((step (- (yy::mouse-state-y-position state)
			       previous-y)))
		  (if (not (zerop (logand (yy::mouse-state-button-state state)
					  yy::*control*)))
		      (setf step (* 10 step)))
		  (if (not (zerop (logand (yy::mouse-state-button-state state)
					  yy::*meta*)))
		      (setf step (* .1 step)))
		  (setf previous-y (yy::mouse-state-y-position state))
		  (when (plusp (+ previous-x step))
		    (incf previous-x step)
		    (move edge (mapcar #'(lambda (x) (* step x)) normal-vector) t)
		    (yy::draw-prompt (format nil "Distance ~a" previous-x))
		    ;; not erase
		    #+ignore
		    (yy::draw-string-xy window (format nil "Distance ~a" previous-x) 15 15)
		    )))))))))

(defmethod collapse-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore mouse-state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (accept-type (view superior)) window
	(yy::draw-prompt "Collapse     Please Select face")
	(let ((selection (yy::accept 'view-face window)))
	  (when selection
	    (with-slots (object) selection
	      (yy::draw-prompt (format nil "Collapse ~a" object))
	      (collapse object)
	      (with-slots (polyhedron) object
		(with-slots (view-objects) polyhedron
		  (dolist (view-object view-objects)
		    (redraw-view-solid view-object))))
	      )))))))

(defmethod extrude-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state)))
      bt
      (with-slots ((window yy::object-parent)) switch
	(with-slots (accept-type selection) window
	  (let ((view-object (yy::accept 'view-face window)))
	    (when view-object
	      (with-slots (object) view-object
		(yy::draw-prompt (format nil "Extrude face ~a" object))
		(with-slots (normal-vector) object
		  (Extrude  object normal-vector)
		  (yy::set-window-method window 'extrude-moving-internal
					 :event-mask (logior yy::*control*
							     yy::*shift*
							     yy::*meta*
							     yy::*mouse-move*))
		  (yy::set-window-method window 'moving-finish
					 :event-mask yy::*mouse-left-1*)
		  (setf selection view-object)
		  (yy::wait-process 'moving-terminate window)
		  (yy::disnable-event window (logior yy::*control*
						     yy::*meta*
						     yy::*shift*
						     yy::*mouse-move*
						     yy::*mouse-left-1*))
		  (yy::draw-prompt "Extrude Finished")
		  (with-slots (polyhedron) object
		    (with-slots (view-objects) polyhedron
		      (dolist (view-object view-objects)
			(redraw-view-solid view-object)))
		    ))))))))))

(defmethod extrude-moving-internal ((window viewer-window) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (previous-x previous-y selection (view superior)) window
    (when selection
      (unless previous-x (setf previous-x 1))
      (unless previous-y (setf previous-y (yy::mouse-state-y-position state)))
      (if (not (zerop (logand (yy::mouse-state-button-state state)
			      yy::*shift*)))
	  (setf previous-y (yy::mouse-state-y-position state))
	  (unless (= previous-y (yy::mouse-state-y-position state))
	    (with-slots (object) selection
	      (with-slots (normal-vector) object
		(let ((step (- (yy::mouse-state-y-position state)
			       previous-y)))
		  (if (not (zerop (logand (yy::mouse-state-button-state state)
					  yy::*control*)))
		      (setf step (* 10 step)))
		  (if (not (zerop (logand (yy::mouse-state-button-state state)
					  yy::*meta*)))
		      (setf step (* .1 step)))
		  (setf previous-y (yy::mouse-state-y-position state))
		  (when (plusp (+ previous-x step))
		    (incf previous-x step)
		    (move object (mapcar #'(lambda (x) (* step x)) normal-vector) t)
		    (yy::draw-prompt (format nil "Distance ~a" previous-x))
		    ;; not erase
		    #+ignore
		    (yy::draw-string-xy window (format nil "Distance ~a" previous-x) 15 15)
		    )))))))))

(defmethod cut-method-internal ((switch switch-with-title) mouse-state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-switch-default-look (switch)
    (let ((bt (yy::mouse-state-button-state mouse-state))
	  cut)
      (cond ((not (zerop (logand yy::*mouse-left-1* bt)))
	     (setf cut 2))
	    ((not (zerop (logand yy::*mouse-middle-1* bt)))
	     (setf cut 3))
	    ((not (zerop (logand yy::*mouse-right-1* bt)))
	     (setf cut 4)))
      (with-slots ((window yy::object-parent)) switch
	(with-slots (accept-type (view superior)) window
	  (yy::draw-prompt (format nil "CUT~d  Please Select edge" cut))
	  (let ((ans (yy::accept 'view-edge window)))
	    (when ans
	      (with-slots (object) ans
		(yy::draw-prompt (format nil "CUT~d ~a" cut object))
		(if (eq cut 3)
		    (cut3 object)
		    (cut2 object))))))))))

(defmethod move-method-internal ((switch switch-with-title) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore state))
  (with-switch-default-look (switch)
    (with-slots ((window yy::object-parent)) switch
      (with-slots (selection accept-type (view superior)) window
	(let ((ans))
	  (when (and accept-type
		     (progn (yy::draw-prompt "MOVE Please Select One")
			    (setf ans (yy::accept accept-type window))))
	    (when ans
	      (yy::draw-prompt (format nil "Moving ~a" ans))
	      (yy::set-window-method window 'moving-internal
				     :event-mask (logior yy::*shift*
							 yy::*control*
							 yy::*meta*
							 yy::*mouse-move*))
	      (yy::set-window-method window 'moving-finish
				     :event-mask yy::*mouse-left-1*)
	      (setf selection ans)
	      (yy::wait-process 'moving-terminate window)
	      (yy::disnable-event window (logior yy::*control*
						 yy::*meta*
						 yy::*shift*
						 yy::*mouse-move*
						 yy::*mouse-left-1*))
	      (yy::draw-prompt "Moving Finished")
	      (with-slots (object) ans
		(with-slots (polyhedron) object
		(with-slots (view-objects) polyhedron
		  (dolist (view-object view-objects)
		    (redraw-view-solid view-object))))
		))))))))

(defmethod moving-internal ((window viewer-window) state)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (previous-x previous-y selection (view superior)) window
    (when selection
      (if (not (zerop (logand (yy::mouse-state-button-state state)
			      yy::*shift*)))
	  (setf previous-x (yy::mouse-state-x-position state)
		previous-y (yy::mouse-state-y-position state))
	  (with-slots (object) selection
	    (unless previous-x
	      (setf previous-x (yy::mouse-state-x-position state)))
	    (unless previous-y
	      (setf previous-y (yy::mouse-state-y-position state)))
	    (unless (and (= previous-x (yy::mouse-state-x-position state))
			 (= previous-y (yy::mouse-state-y-position state)))
	      (let ((step-x (- (yy::mouse-state-x-position state) 
			       previous-x))
		    (step-y (- (yy::mouse-state-y-position state)
			       previous-y)))
		(when (not (zerop (logand (yy::mouse-state-button-state state)
					  yy::*meta*)))
		  (setf step-x (* .1 step-x)
			step-y (* .1 step-y)))
		(setf previous-x
		      (yy::mouse-state-x-position state)
		      previous-y
		      (yy::mouse-state-y-position state))
		(let ((vector (if (zerop (logand (yy::mouse-state-button-state state)
						 yy::*control*))
				  (list step-x 0 step-y)
				  (list step-x step-y 0))))
		  (yy::draw-prompt (format nil "Moving ~a " vector))
		  ;; not erase
		  #+ignore
		  (yy::draw-string-xy window (format nil "Moving ~a " vector) 15 15)
		  (move object vector t)))))))))

