;;; -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-
(in-package :user)

(pushnew :with-shape-presentation-alone-all *features*)

(yy-defsystem:defsystem
  YY-geo
  #+symbolics
  (cond ((eq (send net:*local-site* :name) :nsc)
	 (cons "f:>Shiota>yy-3D>"  "f:>Shiota>yy-3D>ibin>"))	;nsc
	((eq (send net:*local-site* :name) :PROCESS)
	 (cons "ss2:/home/kosaka/YY/version1.3.1/client/cg/"  
		   "IVORY:>Shiota>yy-3D>"))	;IPA
	((eq (send net:*local-site* :name) :IPA-LUV)
	 (cons (format nil "~a~a" "ss2:" *CG-FILES*)
		   "ivory:>Shiota>yy-3D>ibin>")))
  #-symbolics
  (cons *CG-FILES* *CG-BIN*)

  ;;
  ;; file         load           compile      files which       port
  ;;              environment    environment  force the of
  ;;                                          recompilation
  ;;                                          of this file
  ;;                                          
  (
   (package		t		t	)
   (model		t		t	(package))
   (misc		t		t	(package))
   (matrix		t		t	(package))
   (object		t		t	(package))
   (view-object		t		t	(package))

   (cube		t		t	(package))

   (move		t		t	(package))
   (modify		t		t	(package))

   (switch		t		t	(package))
   (gui			t		t	(package))

   (viewer-switches	t		t	(package))
   (viewer		t		t	(package))

   (geo-switches	t		t	(package))
   (geo			t		t	(package))
   ))

(defun compile-yy-geo (&optional m)
  (let (#+Lucid (lcl:*redefinition-action* nil)
	#+excl  (excl::*redefinition-warnings* nil)
	)
    (unless (member :yy *features*)
      (load-yy))
    (cond ((null m)        (yy-defsystem:operate-on-system 'yy-geo :compile))
	  ((eq m :print)   (yy-defsystem:operate-on-system 'yy-geo :compile () t))
	  ((eq m :query)   (yy-defsystem:operate-on-system 'yy-geo :query-compile))
	  ((eq m :confirm) (yy-defsystem:operate-on-system 'yy-geo :confirm-compile))
	  ((eq m 't)       (yy-defsystem:operate-on-system 'yy-geo :recompile)) 
	  ((listp m)       (yy-defsystem:operate-on-system 'yy-geo :compile-from m))
	  ((symbolp m)     (yy-defsystem:operate-on-system 'yy-geo :recompile-some 
							   `(,m))))))

(defun load-yy-geo (&optional m)
  (let (#+Lucid (lcl:*redefinition-action* nil)
	#+excl  (excl::*redefinition-warnings* nil)
	)
    (unless (member :yy *features*)
      (load-yy))
    (cond ((null m)      (yy-defsystem:operate-on-system 'yy-geo :load))
	  ((eq m :query) (yy-defsystem:operate-on-system 'yy-geo :query-load)))
    (pushnew :YY-GEO *features*)))

(user::compile-yy)
(user::load-yy)
(user::compile-yy-geo)
(user::load-yy-geo)

#+symbolics
(defun restart-yy-event-loop (&optional (reset-process t))
  (setf yy::*packet-sending* nil
	yy::*send-total-list* nil
	yy::*total-send* nil
	yy::*total-put-byte*  0)
  (when reset-process
    (when yy::*event-loop-process*
      (yy::KILLED-PROCESS yy::*event-loop-process*))
    (yy::start-event-loop)))

#+symbolics
(defun stop-geo (&optional (stop-yy-too t))
  (when yy-geo::*geo*
    (clos:with-slots (YY-GEO::WINDOW yy-geo::views) yy-geo::*geo*
      (setf (YY::WINDOW-VISIBLE YY-GEO::WINDOW) nil)
      (dolist (view yy-geo::views)
	(clos:with-slots (YY-GEO::WINDOW) view
	  (setf (YY::WINDOW-VISIBLE YY-GEO::WINDOW) nil))))
    (setf yy-geo::*geo* nil))
  (when stop-yy-too
    (yy::reset-yy-internal)
    (setf yy::*ROOT-WINDOW* nil)))

(defun start-geo (&key
		  (x-server-name "133.2.99.2:0.0")
		  (yy-server-name "ss2"))
  (unless yy::*ROOT-WINDOW*
    (yy::initialize-yy :x-server-name x-server-name :server-name yy-server-name))
  (setq yy-geo::*geo*
	(#-Lucid make-instance ;; symbolics and Allegro
	 #+Lucid make-instance
	 'yy-geo::geometry)))

(start-geo)
