;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-
(in-package :yy-geo)

;;;define bottun flavor.
(defclass switch-with-title (YY::EVENT-DRAWABLE-PIECE)
    ((title-string :initarg :title :initform nil
		   :accessor title-string)
     (selected :initarg :select :initform nil
	       :accessor switch-selected)
     (select-color :initarg :select-color)
     ))

(defclass with-switch-window (yy::viewport-window-stream)
    ((superior :initarg :superior)
     (view-hight :initform 200)
     (menu-hight :initform 60)
     (switch-hight :initform 20)
     (switch-width :initform 80)
     (switch-area-hight :initform 0)
     (switch-area-width :initform 0)
     (switches :initform nil :initarg :switches )))

(defmethod initialize-instance :after ((self with-switch-window) &rest initargs)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore initargs))
  (with-slots (superior YY::WINDOW-REGION
			(switch-list switches)
			switch-hight switch-width
			switch-area-hight switch-area-width
			view-hight menu-hight) self
    (with-slots (window) superior
      (setf window self))
    (setf switch-area-width (+ switch-width 10)
	  switch-area-hight (+ switch-hight 10))
    ;; set up Switches
    (set-switchs self switch-list)
    (redisplay-switches self)))

(defmethod set-switchs ((self with-switch-window) switch-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (switches) self
    (let ((temp nil))
      (dolist (switch switch-list)
	(when (listp switch)
	  (push (apply 'make-switch self switch) temp)))
      (when temp
	(setf switches temp)))))

(defmethod redisplay-switches ((window with-switch-window))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (switches) window
    (dolist (switch switches)
      (draw-switch switch))))


;;;
;;;Geometry Switches manipulation functions.
;;;
(defmethod draw-switch ((switch switch-with-title) &optional mode)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (yy::object-parent switch)))
	(with-slots (switch-width switch-hight) parent
	  (with-slots (selected select-color) switch
      (when mode
	(setf selected (if (eql mode :active) t nil)))
      ;;clear inside a region of Switch
      (yy::draw-piece-color switch yy::*white-color*)
      ;;If switch is selected, switch is in reverse.
      (cond (selected				; :active or :deactive ?
	     (yy::draw-piece-filled-rectangle
	       switch 2 2 (- switch-width 2) (- switch-hight 2)
	       :color select-color)
	     (yy::draw-piece-rectangle
	       switch 0 0 switch-width switch-hight
	       :line-width 1 :color select-color))
	    (t
	     (yy::draw-piece-rectangle
	       switch 0 0 switch-width switch-hight
	       :line-width 1 :color select-color)
	     (yy::draw-piece-rectangle
	       switch 0 0 (- switch-width 2) (- switch-hight 2)
	       :line-width 1 :color select-color)))
      (let ((label (title-string switch)))
	(yy::draw-piece-string
	  switch
	  ;;position in switch(yy::piece-region)
	  ;;Label string is centered in a switch rectangle.
	  (truncate
	    (/ (- switch-width
		  (yy::font-string-length yy::*default-font* label))
	       2))
	  (+ 3 (yy::font-kanji-base-line yy::*default-font*))
	  label
	  :color (if selected			; :active or :deactive ?
		     yy::*white-color*
		     select-color)))))))





;;;It's dummy code, effective when variable *debug* is t.
(defun define-dummy-methods (switch)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (declare (ignore switch))
  (yy::draw-prompt "DUMMY")
  nil)

(defun make-switch (window column low label-string method-func
		    &optional (select-color yy::*black-color*))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (switch-width switch-hight
			    switch-area-width switch-area-hight) window
    (let ((x-pos (+ (* column switch-area-width) 15))
	  (y-pos (+ (* low    switch-area-hight) 15))
	  (mask (logior yy::*shift* yy::*control* yy::*meta*))
	  switch)
      (when (symbolp select-color)
	(setf select-color (symbol-value select-color)))
      (when (eq yy::*white-color* select-color)	;for Black and white display
	(setf select-color yy::*black-color*))
      (setf switch
	    (make-instance 'switch-with-title
			   :title label-string
			   :draw-piece-visible t
			   :object-parent window
			   :left x-pos
			   :bottom y-pos
			   :width switch-area-width
			   :height switch-area-hight
			   :event-mask mask
			   :select-color select-color))
      (when (symbolp method-func)
	(setf (get method-func 'single-process) t
	      method-func (symbol-function method-func)))
      (apply method-func switch nil)
      switch
      )))

