;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-
(in-package :yy-geo)

;;; This list created by push function.
;;; New object sequence number must be unique number.
;;; This list is largest first style.
;;; First item's sequence number is largest one.
 
(defmethod move-vertex ((vertex vertex) (vector list))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (values vertex))
  (let ((dx (get-vector-x vector))
	(dy (get-vector-y vector))
	(dz (get-vector-z vector)))
    (with-slots (x y z) vertex
		(setf x (+ x dx)
		      y (+ y dy)
		      z (+ z dz))))
  vertex)

(defmethod move-vertex ((vertex vertex) (matrix array))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (values vertex))
  (multiple-value-bind (new-x new-y new-z)
      (calculate-matrix matrix vertex)
    (with-slots (x y z) vertex
      (setf x new-x
	    y new-y
	    z new-z)))
  vertex)

(defmethod move-vertex :after ((vertex vertex) mover)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore mover))
  (with-slots (view-objects) vertex
    (dolist (view-object view-objects)
      (compute-view-vertex view-object))))

;;; Modify Drawn Object
;;; by matrix or vector
;;;
(defmethod move ((object vertex) mover &optional (redraw-edge-only nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore redraw-edge-only))
  (move-vertex object mover))

(defmethod move ((object edge) mover &optional (redraw-edge-only nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore redraw-edge-only))
  (with-slots (head tail) object
    (move-vertex head mover)
    (move-vertex tail mover)))

(defmethod move ((object face) mover &optional (redraw-edge-only nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore redraw-edge-only))
  (with-slots (vertices) object
    (dolist (vertex vertices)
      (move-vertex vertex mover))))

(defmethod move ((object polyhedron) mover &optional (redraw-edge-only nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore redraw-edge-only))
  (with-slots (vertices) object
    (dolist (vertex vertices)
      (move-vertex vertex mover))))

(defmethod move ((object object) mover &optional (redraw-edge-only nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore redraw-edge-only))
  (with-slots (body) object
    (move body mover)))

(defmethod move :after ((object basic-object) mover &optional (redraw-edge-only nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore mover))
  (with-slots (view-objects) object
    (dolist (view-object view-objects)
      (reset-already-redraw view-object)
      (redraw-with-depends view-object redraw-edge-only))))

