;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-
(in-package :yy-geo)

;;;define yy window.
(defclass viewer-window (with-switch-window)
    ((view-hight :initform 400)
     (menu-hight :initform 100)
     (switch-hight :initform 20)
     (switch-width :initform 80)
     (center-x :initform 0)
     (center-y :initform 0)
     (accept-type :initform nil)
     (selection :initform nil)
     (previous-x :initform nil)
     (previous-y :initform nil)
     (previous-accept-type-switch :initform nil)
     ))


(defmethod initialize-instance :after ((self viewer-window) &rest initargs)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore initargs))
  (with-slots (view-hight menu-hight center-x center-y yy::window-region) self
    (with-slots ((size yy::region-internal)) yy::window-region
      (let ((xmin (first size))
	    (xmax (third size)))
	(setf center-x (round (- xmax xmin) 2)
	      center-y (round view-hight 2))))
    (setf (yy::filled-type self) yy::*FillSolid*
	  (yy::line-width self) 1)))

;;;define yy window frame.
(defclass viewer-frame (yy::window-frame)
    ())

;;;set frame size. (use coordinate related root-window)
;;;
;;;             700
;;;  --------------------------Bottom
;;;  |                         
;;;  |    Menu Area            | menu-hight
;;;  |                         
;;;  |-------------------------
;;;  |    View Area            | view-hight [400]
;;;  |                         |
;;;   TOP                     
(defmethod yy::set-frame-region :before ((frame viewer-frame) region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (menu-hight) (yy::parent-window frame)
    (setf (yy::region-bottom region) menu-hight)))


;;;Redisplay a Label String and Rectangle for Butttun
;;;  In a Piece-region,
;;;    (1) String position          (2) Rectangle position
;;;    _______________________      ____________________
;;;    |  3                 |      |  0              |
;;;    |                   ?(*1)   |                0|
;;;    |   ****************|      |   *************|
;;;    |   * Switch Label *  |      |   * Rectangle *  |
;;;    | ****************  |      | *************  |
;;;    | ?(*1)            3 |      | 0             0 |
;;;    |____________________|      |_________________|
;;;
;;;   (*1) Label string is centered.
;;;
;;;
;;;Create a region!!
;;;
;;;  In a Logical Area,    
;;;   ---------------- 90 ---------------> 
;;;   ------------------------------------- 
;;;   |   5                              | |
;;;   |                                  | |
;;;   |       ######################      | |
;;;   | 5   # Region of a Switch #  5 | | 30
;;;   |       ######################      | |
;;;   |                                  | |
;;;   |   5                              | |
;;;   ------------------------------------- 
(defmethod yy::redisplay-window ((window viewer-window))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;;initial creation of menu switch(yy::eventable-draw-piece)
  (yy::default-redisplay-window window)
  (with-slots (view-hight menu-hight center-x center-y yy::window-region superior) window
;    (with-slots ((size yy::region-internal)) yy::window-region
;      (let ((xmin (first size))
;	    (ymin (second size))
;	    (xmax (third size))
;	    (ymax (fourth size)))
;    (with-slots (YY::REGION-INTERNAL) yy::frame
    (yy::with-region-slots (YY::width yy::height) yy::window-region
      (setf view-hight yy::height ;;(- ymax ymin)
	    center-x (round (- yy::width  50);;(- xmax xmin)
			    2)
	    center-y (round view-hight 2)
	    ))
    (when superior
      (redisplay superior t nil))
    ))

;;;  |   70 =>                 
;;;  |------------------------
;;;  |M1 |       Menu Area     |
;;;  |--|20 =>                | 100
;;;  |   |                     |
;;;                           
;;;                              
;;; TOP
