;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-

(in-package :yy-geo)

(defclass geometry
	  ()
  ((window :initform nil)
   (bodys :initform nil)
   (views :initform nil)))

(defclass geometry-window (with-switch-window)
    ((line-hight :initform (+ 5 (yy::font-kanji-base-line yy::*default-font*)))))

(defmethod initialize-instance :after ((geometry geometry) &rest initargs)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (ignore initargs))
  (with-slots (window) geometry
    (setf *r-color*    yy::*red-color* ;;(make-color 65535     0 0)
	  *g-color*     yy::*green-color* ;;(make-color     0 65535 0)
	  *b-color*    yy::*blue-color* ;; (make-color     0     0 65535)
	  *y-color*    yy::*yellow-color* ;;(make-color 65535 65535 32768)
	  
	  *m-color*    yy::*purple-color* ;;(make-color 65535     0 65535)
	  )
    (setf window (yy::make-window-instance 
		   'geometry-window
		   :horizontal-scroll-visible t
		   :vertical-scroll-visible t
		   :window-region
		   (yy::make-region :left 5 :width 400 :bottom 5 :height 300)
		   :translate-coordinate :left-top
		   :title-bar 'yy::switch-title-bar
		   :window-frame 'geometry-frame
;;;		   :transform-matrix (yy::make-transform-matrix)
		   :drawing-region (yy::make-region)
		   :title-bar-string "Geometry"
		   :switches *geo-switchs*
		   :superior geometry))))

(defmethod yy::redisplay-window ((window geometry-window))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy::default-redisplay-window window))

(defclass geometry-frame (yy::window-frame)
    ())

(defmethod display ((geometry geometry) (view viewer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (window views bodys) geometry
    (dolist (body bodys)
      (make-view-object view body))
    (with-slots (line-hight menu-hight) window
      (let* ((n (length views))
	     (xpos 275)
	     (ypos (+ (* line-hight n) menu-hight)))
	(yy::with-output-as-presentation
	  (view window)
	  (setf (yy::graphic-color window) *r-color*)
	  (yy::draw-string-xy window (format nil "~a" view) xpos ypos))))))

(defmethod erase ((geometry geometry) (view viewer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (window views bodys) geometry
    (with-slots (line-hight) window
      (yy::delete-presentation-object view window 'viewer)
      (dolist (v views)
	(yy::move-presented-object v window 'viewer 0 (- line-hight))
	(if (eq v view)
	    (return)))
      (setf views (delete view views)))))

(defmethod add-view ((geometry geometry))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (make-instance 'viewer :superior geometry))

(defmethod kill ((geometry geometry) (view viewer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (views window bodys) geometry
    (dolist (body bodys)
      (delete-view-object view body))
    (erase geometry view)
;;; cannot work  yy::flush-window now just invisible window
;  (with-slots (window) view
;    (yy::flush-window window))
    (with-slots ((view-window window)) view
      (setf (YY::WINDOW-VISIBLE view-window) nil))))

(defmethod display ((geometry geometry) (cube object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (window bodys) geometry
    (with-slots (line-hight menu-hight) window
      (with-slots (name visible-p) cube
	(let* ((n (length bodys))
	       (xpos 20)
	       (ypos (+ (* line-hight n) menu-hight)))
	  (yy::with-output-as-presentation
	    (cube window)
	    (if visible-p
		(setf (yy::filled-type window) yy::*FillSolid*
		      (yy::graphic-color window) *b-color*)
		(setf (yy::filled-type window) yy::*Fillednon*
		      (yy::graphic-color window) *r-color*))
	    (yy::draw-circle-xy window xpos (- ypos 5) 5)
	    (yy::draw-string-xy window name (+ xpos 10) ypos)))))))

(defmethod change-display ((geometry geometry) (cube object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (window bodys) geometry
    (with-slots (line-hight menu-hight) window
      (with-slots (name visible-p) cube
	(let* ((n (- (length bodys)
		     (let ((i 0))
		       (dolist (body bodys)
			 (if (eq body cube)
			     (return i))
			 (incf i)))))  
	       (xpos 20)
	       (ypos (+ (* line-hight n) menu-hight)))
	  (yy::with-shape-presentation-alone
	    (cube window 'object)
	    (if visible-p
		(setf (yy::filled-type window) yy::*FillSolid*
		      (yy::graphic-color window) *b-color*)
		(setf (yy::filled-type window) yy::*Fillednon*
		      (yy::graphic-color window) *r-color*))
	    (yy::draw-circle-xy window xpos (- ypos 5) 5)
	    (yy::draw-string-xy window name (+ xpos 10) ypos)))))))

(defmethod erase ((geometry geometry) (object object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (bodys window) geometry
    (yy::delete-presentation-object object window 'object)
    (with-slots (line-hight) window
      (dolist (body bodys)
	(yy::move-presented-object body window 'object 0 (- line-hight))
	(if (eq body object)
	    (return)))
      (setf bodys (delete object bodys)))))

;;; Create Model Object Function
;;;
(defmethod add-cube ((geometry geometry) width &optional height depth)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (unless (numberp height) (setq height width))
  (unless (numberp depth)  (setq depth width))
  (with-slots (bodys) geometry
    (let ((w     (* width  0.5))
	  (h     (* height 0.5))
	  (d     (* depth  0.5))
	  (ID (get-next-element bodys))
	  )
      (make-instance
	'object
	:body (make-cube (- w) (- h) (- d) w h d ID)
	:name (format nil "CUBE[~d]" ID)
	:ID# ID
	:superior geometry))))

(defmethod add-cylinder ((geometry geometry) width &optional height)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (unless (numberp height) (setq height width))
  (with-slots (bodys) geometry
    (let ((w     (* width  0.5))
	  (h     (* height 0.5))
	  (ID (get-next-element bodys)))
      (make-instance
	'object
	:body (make-pseudo-cylinder 0 0 w (- h) h id)
	:name (format nil "CYLINDER[~d]" ID)
	:ID# ID
	:superior geometry))))

(defmethod add-sphere ((geometry geometry) rr)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (bodys) geometry
    (let ((r (* rr .5))
	  (ID (get-next-element bodys)))
      (make-instance
	'object
	:body (make-pseudo-sphere 0 0 0 r id)
	:name (format nil "SPHERE[~d]" ID)
	:ID# ID
	:superior geometry))))

(defmethod kill ((geometry geometry) (object object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (views) geometry
    (dolist (view views)
      (delete-view-object view object))
    (erase geometry object)))


;;; Function Inteface for get object
(defmethod get-body ((stream GEOMETRY) (sequence-number integer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (bodys) stream
    (dolist (body bodys)
      (with-slots ((ID sequence-number)) body
	(if (= sequence-number ID)
	    (return body))))))

(defmethod get-polyhedron ((stream GEOMETRY) (sequence-number integer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (bodys) stream
    (dolist (b bodys)
      (with-slots (body) b
	(with-slots ((ID sequence-number)) body
	  (if (= sequence-number ID)
	      (return body)))))))

(defmethod get-object ((polyhedron polyhedron) type (sequence-number integer))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (vertices edges faces) polyhedron
    (cond ((eq type 'vertex)
	   (dolist (i vertices)
	     (with-slots ((ID sequence-number)) i
	       (if (= sequence-number ID)
		   (return i)))))
	  ((eq type 'edge)
	   (dolist (i edges)
	     (with-slots ((ID sequence-number)) i
	       (if (= sequence-number ID)
		   (return i)))))
	  ((eq type 'face)
	   (dolist (i faces)
	     (with-slots ((ID sequence-number)) i
	       (if (= sequence-number ID)
		   (return i))))))))


