;;; -*- Mode:lisp; Syntax:Common-Lisp; Package:xtk; Base:10 -*-

(in-package :xtk)

(setq *sccsid* "@(#)cursor.lisp	1.9 9/11/92")

(defun get-cursor-number (cursor)
  (or (get cursor :cursor-shape)
      (clm-cerror "Use :WATCH as cursor shape."
	      "Unknown cursor shape: ~a~%" cursor)
      (get :watch :cursor-shape)))

;; EXPORT (change-grab-cursor)
(defun change-grab-cursor (cursor-id &key (add-mask nil) (remove-mask nil))
  (execute-request 11 (list cursor-id (get-event-mask add-mask)
			    (get-event-mask remove-mask))))

;; EXPORT (create-pixmap-cursor)
(defun create-pixmap-cursor (source mask &key (foreground "black")
					      (background "white"))
  (check-type source string)
  (check-type mask string)
  (check-type foreground string)
  (check-type background string)
  (first (execute-request 77 (list 0 source mask foreground background)
			  :num-results 1)))

;; EXPORT (create-font-cursor)
(defun create-font-cursor (shape)
  (first (execute-request 77 (list 1 (get-cursor-number shape))
			  :num-results 1)))

;; EXPORT (define-cursor)
(defun define-cursor (cursor-number &rest widgets)
  (execute-request 12 (cons (if (equal cursor-number :restore)
                                -1 cursor-number)
                            widgets)))

(defun all-cursors ()
  '(:x-cursor :arrow :based-arrow-down :based-arrow-up :boat :bogosity
    :bottom-left-corner :bottom-right-corner :bottom-side :bottom-tee 
    :box-spiral :center-ptr :circle :clock :coffee-mug :cross
    :cross-reverse :crosshair  :diamond-cross :dot :dotbox :double-arrow
    :draft-large :draft-small :draped-box :exchange :fleur :gobbler :gumby
    :hand :hand1_mask :heart :icon :iron-cross :left-ptr :left-side :left-tee
    :leftbutton :ll-angle :lr-angle :man :middlebutton :mouse :pencil :pirate
    :plus :question-arrow :right-ptr :right-side :right-tee :rightbutton
    :rtl-logo :sailboat :sb-down-arrow :sb-h-double-arrow :sb-left-arrow
    :sb-right-arrow :sb-up-arrow :sb-v-double-arrow :shuttle :sizing :spider
    :spraycan :star :target :tcross :top-left-arrow :top-left-corner
    :top-right-corner :top-side :top-tee :trek :ul-angle :umbrella :ur-angle
    :watch :xterm))


(setf (get :x-cursor :cursor-shape) 0)
(setf (get :arrow :cursor-shape) 2)
(setf (get :based-arrow-down :cursor-shape) 4)
(setf (get :based-arrow-up :cursor-shape) 6)
(setf (get :boat :cursor-shape) 8)
(setf (get :bogosity :cursor-shape) 10)
(setf (get :bottom-left-corner :cursor-shape) 12)
(setf (get :bottom-right-corner :cursor-shape) 14)
(setf (get :bottom-side :cursor-shape) 16)
(setf (get :bottom-tee :cursor-shape) 18)
(setf (get :box-spiral :cursor-shape) 20)
(setf (get :center-ptr :cursor-shape) 22)
(setf (get :circle :cursor-shape) 24)
(setf (get :clock :cursor-shape) 26)
(setf (get :coffee-mug :cursor-shape) 28)
(setf (get :cross :cursor-shape) 30)
(setf (get :cross-reverse :cursor-shape) 32)
(setf (get :crosshair :cursor-shape) 34)
(setf (get :diamond-cross :cursor-shape) 36)
(setf (get :dot :cursor-shape) 38)
(setf (get :dotbox :cursor-shape) 40)
(setf (get :double-arrow :cursor-shape) 42)
(setf (get :draft-large :cursor-shape) 44)
(setf (get :draft-small :cursor-shape) 46)
(setf (get :draped-box :cursor-shape) 48)
(setf (get :exchange :cursor-shape) 50)
(setf (get :fleur :cursor-shape) 52)
(setf (get :gobbler :cursor-shape) 54)
(setf (get :gumby :cursor-shape) 56)
(setf (get :hand :cursor-shape) 58)
(setf (get :hand1_mask :cursor-shape) 60)
(setf (get :heart :cursor-shape) 62)
(setf (get :icon :cursor-shape) 64)
(setf (get :iron-cross :cursor-shape) 66)
(setf (get :left-ptr :cursor-shape) 68)
(setf (get :left-side :cursor-shape) 70)
(setf (get :left-tee :cursor-shape) 72)
(setf (get :leftbutton :cursor-shape) 74)
(setf (get :ll-angle :cursor-shape) 76)
(setf (get :lr-angle :cursor-shape) 78)
(setf (get :man :cursor-shape) 80)
(setf (get :middlebutton :cursor-shape) 82)
(setf (get :mouse :cursor-shape) 84)
(setf (get :pencil :cursor-shape) 86)
(setf (get :pirate :cursor-shape) 88)
(setf (get :plus :cursor-shape) 90)
(setf (get :question-arrow :cursor-shape) 92)
(setf (get :right-ptr :cursor-shape) 94)
(setf (get :right-side :cursor-shape) 96)
(setf (get :right-tee :cursor-shape) 98)
(setf (get :rightbutton :cursor-shape) 100)
(setf (get :rtl-logo :cursor-shape) 102)
(setf (get :sailboat :cursor-shape) 104)
(setf (get :sb-down-arrow :cursor-shape) 106)
(setf (get :sb-h-double-arrow :cursor-shape) 108)
(setf (get :sb-left-arrow :cursor-shape) 110)
(setf (get :sb-right-arrow :cursor-shape) 112)
(setf (get :sb-up-arrow :cursor-shape) 114)
(setf (get :sb-v-double-arrow :cursor-shape) 116)
(setf (get :shuttle :cursor-shape) 118)
(setf (get :sizing :cursor-shape) 120)
(setf (get :spider :cursor-shape) 122)
(setf (get :spraycan :cursor-shape) 124)
(setf (get :star :cursor-shape) 126)
(setf (get :target :cursor-shape) 128)
(setf (get :tcross :cursor-shape) 130)
(setf (get :top-left-arrow :cursor-shape) 132)
(setf (get :top-left-corner :cursor-shape) 134)
(setf (get :top-right-corner :cursor-shape) 136)
(setf (get :top-side :cursor-shape) 138)
(setf (get :top-tee :cursor-shape) 140)
(setf (get :trek :cursor-shape) 142)
(setf (get :ul-angle :cursor-shape) 144)
(setf (get :umbrella :cursor-shape) 146)
(setf (get :ur-angle :cursor-shape) 148)
(setf (get :watch :cursor-shape) 150)
(setf (get :xterm :cursor-shape) 152)
