;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Package: CLIM-USER; Base: 10; Lowercase: Yes -*-

(in-package :clim-user)

;; This inherits the PRESENT method from the SYMBOL type
(clim:define-presentation-type symbol-in-package (&optional package)
  :inherit-from 'symbol
  :history symbol)

(clim:define-presentation-method clim:accept
    ((type symbol-in-package) stream (view clim:textual-view) &key)
  ;; If no package was supplied, read from the keyword package
  (let ((package (if (or (null package) (eq package '*))
		     (find-package :keyword)
		     (find-package package)))
	(symbol-name (string-upcase (read-token stream))))
    ;; If the symbol is not in the package, signal a parse error.  The
    ;; input editor will print the error message and wait for the user
    ;; to edit the input.
    (if (find-symbol symbol-name package)
	(values (intern symbol-name package))
	(clim:simple-parse-error "There is no such symbol in the package ~A" package))))

(clim:define-presentation-method clim:describe-presentation-type 
    ((type symbol-in-package) stream plural-count)
  (clim:default-describe-presentation-type "symbol" stream plural-count)
  (unless (eq package '*)
    (format stream " in the package ~A" package)))

;; Only symbols in the specified package are of this type
(clim:define-presentation-method clim:presentation-typep
    (object (type symbol-in-package))
  (values
    (and (symbolp object)
	 (find-symbol (symbol-name object) (find-package package)))))

;; Returns true iff the package is used by the supertype's package
(clim:define-presentation-method clim:presentation-subtypep 
    ((type symbol-in-package) supertype)
  (let ((pkg1 (clim:with-presentation-type-parameters (symbol-in-package type) 
		package))
	(pkg2 (clim:with-presentation-type-parameters (symbol-in-package supertype)
		package)))
    (cond ((eq pkg2 '*)
	   (values t t))
	  ((eq pkg1 '*)
	   (values nil t))
	  (t
	   (values (not (null (member (find-package pkg1)
				      (package-use-list (find-package pkg2)))))
		   t)))))
