(in-package "CL-USER")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                            Use defsystem package
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(use-package "DS" (find-package "CL-USER"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                         Define directory structure
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; the binaries go into a subfolder named "binary":

(setq *relative-binary-namestring* "binary")

(defvar *ZEBU-directory*
  (pathname #+LUCID "~/hpnlrw/zebu/"
	    #+MCL "home;zebu:"))
(defvar *ZEBU-binary-directory*
  (pathname #+LUCID "~/hpnlrw/zebu/binary/"
	    #+MCL "home;zebu:binary:"))

(defsystem ZEBU-Kernel
    (:default-pathname #.*ZEBU-directory*
     :default-package  "ZEBU"
     )
  "zebu-package"
  ("zebu-aux"             :load-always "zebu-package")
  ("zebu-mg-domain"       :load-always "zebu-aux")
  )
  
(defsystem ZEBU
    (:default-pathname    #.*ZEBU-directory*
     :default-package     "ZEBU"
     :load-before-compile ZEBU-Kernel
     :needed-systems      ZEBU-Kernel
     :documentation       "Run time system for LALR(1) parser"
     )
  ("zebu-loader"          :load-always ("zebu-package" "zebu-aux"))
  ("zebu-driver"          :load-always ("zebu-loader" "zebu-package"))
  ("zebu-actions" :load-always ("zebu-loader"))
  )

(defsystem ZEBU-Compiler
    (:default-pathname    #.*ZEBU-directory*
     :needed-systems      ZEBU
     :load-before-compile ZEBU-Kernel
     :documentation       "Compile time system for LALR(1) parser: Converts a grammar to a parse table"
     )
  "zebu-oset"      
  ("zebu-g-symbol"  :load-always "zebu-oset")
  ("zebu-loadgram"  :load-always ("zebu-g-symbol" "zebu-oset"
				  (ZEBU "zebu-loader")))
  ("zebu-generator" :load-always "zebu-loadgram")
  ("zebu-lr0-sets"  :load-always ("zebu-g-symbol" "zebu-loadgram"))
  ("zebu-empty-st"  :load-always ("zebu-loadgram"))
  ("zebu-first"     :load-always ("zebu-loadgram" "zebu-oset")
		    :recompile-on "zebu-oset")
  ("zebu-follow"    :load-always ("zebu-loadgram" "zebu-first"))
  ("zebu-tables"    :load-always ((ZEBU "zebu-loader")
				  "zebu-g-symbol" "zebu-loadgram"
				  "zebu-lr0-sets"))
  ("zebu-printers"  :load-always ("zebu-loadgram" "zebu-lr0-sets" "zebu-tables"))
  ("zebu-slr"       :load-always (ZEBU "zebu-loader"))
  ("zebu-closure"   :load-always ("zebu-oset" "zebu-g-symbol" "zebu-first"))
  ("zebu-lalr1"     :load-always ((ZEBU "zebu-loader")
				  "zebu-oset" "zebu-lr0-sets" "zebu-follow"))
  ("zebu-dump"      :load-always ("zebu-loadgram" "zebu-slr" "zebu-lalr1"))
  ("zebu-compile"   :load-always ((ZEBU-Kernel t)))
  ("zebu-mg"        :load-always ("zebu-compile" "zebu-dump"
				  "zebu-empty-st" "zebu-closure"
				  "zebu-tables" (ZEBU-Kernel t))
		    :compiler    ZB:zebu-compile-file
		    :loader      ZB:zebu-load-file
		    :suffixes    ("zb" . "tab"))
  )

(show-system 'zebu)
;;; Run time system for LALR(1) parser
;;; Load-before-compile: ZEBU-KERNEL 
;;; Needed Systems:      ZEBU-KERNEL 
;;; Default Package:     "ZEBU"
;;; Suffixes:            ("l" . "6bin")
;;; Default Path:    #P"/d7/laubsch/hpnlrw/zebu/"
;;; Module: "zebu-loader"                       Loaded  Needs Compilation
;;;    Load-always: "zebu-package" "zebu-aux" 
;;; Module: "zebu-driver"                       Loaded  Needs Compilation
;;;    Load-always: "zebu-loader" "zebu-package" 
;;; Module: "zebu-actions"                      Loaded  Needs Compilation
;;;    Load-always: "zebu-loader" 
;;; ---------------------------------
> 

;; a circular system
(defsystem fum
    ()
  ("f1" :load-after "f2")
  ("f2" :load-after "f3")
  ("f3" :load-after "f1")
  )

(show-system 'fum)

;;; ---------------------------------
;;; System: FUM is not loaded.
;;; Default Package:     #<Package "USER" 604753>
;;; Suffixes:            ("l" . "6bin")
;;; Module: "f1"                                Not Loaded
;;;    Source not found in #P""
;;;    Load-after: "f2" 
;;; Module: "f2"                                Not Loaded
;;;    Source not found in #P""
;;;    Load-after: "f3" 
;;; Module: "f3"                                Not Loaded
;;;    Source not found in #P""
;;;    Load-after: "f1" 
;;; Warning: Circularity: ("f1" "f3" "f2" "f1")
;;; Warning: Circularity: ("f2" "f1" "f3" "f2")
;;; Warning: Circularity: ("f3" "f2" "f1" "f3")
;;; ---------------------------------
> 
