       
#|
********************************************************************************
********************************************************************************
*****                                                                      *****
*****                        dialogfunktion b=auswahl                      *****
*****                                                                      *****
*****    autor: ute gappa                          erstellt: 11.4.90       *****
*****           klaus goos                         geaendert:  9.7.91      *****
********************************************************************************
********************************************************************************
|#


(defclass *b-auswahl-fenster* (*b~fenster_such_mixin* *b-selbstantwort-mixin* *b-window*)
  ;; ccl::arrow-dialog) ;erlaubt das benutzen der pfeiltasten in der sequence  
  ;; vorher: (dialog), ute/gnter
  ;; wird durch das *b~fenster_such_mixin* miterledigt , stefan 17.2.1994
  ((seq :initform nil :accessor seq)
   (ok-but :initform nil :accessor ok-but)))

(defun fenster-existiert-p (fenster)
  (wptr fenster))

;; zwischenklasse eingefuehrt, damit das such-mixin dazukann
;; stefan 17.2.94
#+ :ccl-2
(defclass b-auswahl-sequenz (*b~sequence_such_mixin* sequence-dialog-item)
  ())

(defvar B_AUSWAHL-FENSTER)

(defun b=auswahl (text-wert-alist
                  &key (ueberschrift nil)
                  (werttyp :position)            ;faengt bei 1 an
                  (vorselektierte-auswahlpunkte nil)
                  (ok-text (b=s :ok))
                  (abbrechen-text (b=s :abbrechen))
                  (schrift b_chicagoschrift)
                  (auswahlfeld-schrift b_chicagoschrift) 
                  (selection-type :single)
                  (anzahl-sichtbarer-zeilen nil) ;so viel wie er braucht
                  (unbedingt-mit-scrollbar nil)
                  (unbedingt-etwas-auswaehlen nil)
                  (fensterbreite nil)            ;heisst: wird berechnet
                  (fensterposition b_dialogfenster-position-oben)
                  (throw-to-cancel t)
                  (f-werte-verbalisieren nil)
                  (sekunden nil))
  
  "bringt einen dialog, in dem der benutzer antworten auswaehlen kann
   (single/multiple-choice), aehnlich wie select-item-from-list.
   zurueckgegeben wird eine liste mit den angeklickten antworten."
  
  #|autor: ute, 12.04.90

eingabeparameter:
- text-wert-alist: assoziativliste aus anzeigetext-rueckgabewert-paaren
                   (nicht dotted).
                   der anzeigetext erschient jeweils in der auswahlsequenz,
                   der rueckgabewert wird bei selektiertem anzeigetext
                   und werttyp = :wert zurueckgegeben.
                   bei nicht angegebenen werttyp (werttyp = :position)
                   braucht der rueckgabewert nicht angegeben werden.
- werttyp:         = :position oder :wert
                   position bedeutet, dass die nummern der gewaehlten antworten
                   zurueckgegeben werden (beginn bei 1)
                   bei werttyp = :wert wird der zum
                   anzeigewert angegebene rueckgabewert zurueckgegeben.
- vorselektierte-auswahlpunkte: 
                   liste der vorselektierten auswahlpunkte, 
                   die zu anfang schon schwarz unterlegt sind.
                   bei :werttyp = :position -> liste von zahlen,
                   bei :werttyp = :wert -> liste der rueckgabewerte.
- ueberschrift:     string evtl mit newlines (momentan nur einzeilig)
- ok-text:         text des ok-buttons (default: "ok")
- abbrechen-text:  text des abbrechen-buttons (default: "abbrechen")
                   wenn abbrechen-text = nil -> ein abbrechen-button
                   erscheint nicht.
- throw-to-cancel  t (= default) bedeutet, dass bei abbrechen ein throw nach 
                   toplevel erfolgt (:cancel; genauso wie bei select-item-
                   from-list). bei throw-to-cancel = nil wird bei abbrechen
                   nil als ergebnis zurueckgeliefert.
- anzahl-sichtbarer-zeilen:
                   gibt an, wieviele zeilen das auswahlfeld haben soll.
                   falls nil (= default), werden so viele zeilen angezeigt,
                   wie benoetigt werden.
- unbedingt-mit-scrollbar: (speziell fuer klaus)
                   t, falls eine scrollbar auch dann reingesetzt werden soll,
                   wenn sie nicht benoetigt wird (defaul-: nil)
- unbedingt-etwas-auswaehlen:
                   t, falls entweder etwas selektiert werden oder abgebrochen werden muss
                   (default-:nil)
- selection-type:  = :single, :continous oder :disjoint 
                   (wie bei sequences)
- schrift:         schriftart der ueberschrift
                   (default = b_chicagoschrift)
- auswahlfeld-schrift:  font des auswahlfeldes
                   (default = b_chicagoschrift)
- fensterbreite:   die breite des fensters in pixel. darueber wird auch die 
                   breite des auswahlfeldes gesteuert. wenn die breite nicht
                   angegeben ist, wird sie berechnet.
                   (die fensterhoehe wird immer automatisch berechnet)
- fensterposition: (default = b_dialogfenster-position-oben)
 
ausgabe:          
  die angeklickten auswahlpunkte als liste (auch bei :selection-type = :single)
  bei werttyp = :position wird jeweils die position (bei 1 beginnend), bei 
  werttyp = :wert der ueber die assoziationsliste text-wert-alist zugehoerige
  rueckgabewert zurueckgegeben.

funktionsweise:
  alternativ zum ok kann man den dialog auch mit doppelklick auf ein auswahl-
  punkt beenden.                 

portierung auf allegro cl
       egbert he, april 94
|#

  (when f-werte-verbalisieren
    (setq text-wert-alist
          (mapcar #'(lambda(was)
                     (list (funcall f-werte-verbalisieren was) was))
                  text-wert-alist)))
  
  (if (and (boundp 'b_auswahl-fenster)
           b_auswahl-fenster
           (fenster-existiert-p b_auswahl-fenster))
    (progn 
      (when sekunden (sekunden-setzen b_auswahl-fenster nil) )
      (when (subviews b_auswahl-fenster)
        (apply #'remove-subviews b_auswahl-fenster (subviews b_auswahl-fenster))))

    (setq b_auswahl-fenster 
          (m->a=erzeuge-modal-fenster 
           '*b-auswahl-fenster*
           :window-type :double-edge-box
           :view-font schrift
           :window-show nil
           ;; allogro-spezifisch
           #+ :aclpc :window-title  #+ :aclpc ""
           #+ :aclpc :window-frame  #+ :aclpc :dialog-box
           #+ :aclpc :user-closable #+ :aclpc nil)))
    
  (when sekunden  (sekunden-setzen b_auswahl-fenster sekunden))
  (set-view-position b_auswahl-fenster fensterposition)
  
  (let* ((ueberschrift-position (if ueberschrift #@(10 10) #@(0 0)))
         (minimale-fensterbreite 277)
         (maximale-fensterbreite (if fensterbreite fensterbreite (- *screen-width* 10)))
         (maximale-fensterhoehe (- *screen-height* 10 (point-v (view-position b_auswahl-fenster))))
         (maximale-sequence-breite (- maximale-fensterbreite 20))
         
         (sequence-strings (mapcar #'first text-wert-alist))
         (sequence)
         (maximale-sequence-string-breite
          (+ 20 ;fuer scrollbar
             (b=min sequence-strings 
                    :vergleichsfunktion '> 
                    :testfunktion #'(lambda(string)(string-width string auswahlfeld-schrift)))))
         (sequence-breite (max minimale-fensterbreite 
                               (if fensterbreite 
                                 maximale-sequence-breite ;(max maximale-sequence-string-breite maximale-sequence-breite)
                                 (min maximale-sequence-string-breite maximale-sequence-breite))))
         (die_fenster_breite (if fensterbreite fensterbreite (+ 20 15 sequence-breite))))
    (multiple-value-bind
      (ueberschrift-static-text ueberschrift-hoehe)
      (if ueberschrift
        (b=static-text ueberschrift
                       sequence-breite
                       (point-v ueberschrift-position)
                       (point-h ueberschrift-position)
                       :font schrift)
        (values nil 0))
      (let* ((sequence-start-y (+ (point-v ueberschrift-position) ueberschrift-hoehe
                                  (if ueberschrift 10 10)))
             (sequence-position (make-point 10 sequence-start-y)))
        (unless anzahl-sichtbarer-zeilen
          (setq anzahl-sichtbarer-zeilen
                (min
                 (floor (- maximale-fensterhoehe
                           sequence-start-y
                           50);fuer buttons
                        (b=schrifthoehe auswahlfeld-schrift))
                 (length sequence-strings))))
        ;eventuell gibt es keinen scrollbar, dann kann die sequence breiter werden
        (when (not (or ;unbedingt-mit-scrollbar
                       (> (length sequence-strings) anzahl-sichtbarer-zeilen) fensterbreite))
          ; += -> incf
          (incf sequence-breite 15))
        #+ :ccl-2
        (setq sequence (make-instance 'b-auswahl-sequenz
                         :table-sequence sequence-strings
                         :selection-type selection-type
                         ;:visible-dimensions (make-point 1 anzahl-sichtbarer-zeilen)
                         :cell-size (make-point sequence-breite (b=schrifthoehe auswahlfeld-schrift))
                         :table-hscrollp nil
                         :table-vscrollp (if unbedingt-mit-scrollbar t
                                             (> (length sequence-strings) anzahl-sichtbarer-zeilen))
                         :view-font auswahlfeld-schrift
                         :view-size (make-point sequence-breite
                                                (* anzahl-sichtbarer-zeilen (b=schrifthoehe auswahlfeld-schrift)))
                         :view-position sequence-position
                         :dialog-item-action 
                         #'(lambda (self)
                             (when unbedingt-etwas-auswaehlen
                               (if (selected-cells sequence)
                                 (dialog-item-enable (ok-but (view-window self)))
                                 (dialog-item-disable (ok-but (view-window self)))))
                             (when (double-click-p)
                               (dialog-item-action (ok-but (view-window self)))))))
        ;; da allegro zwischen single-item-list und /multi-item-list unterscheidet, muss hier 
        ;; unterschieden werden
        ;; single-item-list
        #+ :aclpc
        (setq sequence (m->a=erzeuge-dialog-item  
                        (if (eq selection-type :single)
                          'eg-single
                          'eg-multi)
                        ;;          :range statt :table-sequence
                        :range sequence-strings
                        ;:visible-dimensions (make-point 1 anzahl-sichtbarer-zeilen)
                        :cell-size (make-point sequence-breite 
                                               (b=schrifthoehe auswahlfeld-schrift))
                        ;; geht nicht::       :table-hscrollp nil
                        ;;                    :table-vscrollp (if unbedingt-mit-scrollbar t
                        ;;                                       (> (length sequence-strings)
                        ;;                                           anzahl-sichtbarer-zeilen))
                        :font auswahlfeld-schrift
                        :view-size (make-point sequence-breite
                                               (* anzahl-sichtbarer-zeilen
                                                  (b=schrifthoehe auswahlfeld-schrift)))
                        :view-position sequence-position
                        :set-value-fn 
                        #'(lambda (self neuer-wert alter-wert)
                               (cond ((ok-but b_auswahl-fenster)
                                         (when unbedingt-etwas-auswaehlen
                                              (if neuer-wert
                                                 (dialog-item-enable (ok-but b_auswahl-fenster))
                                                 (dialog-item-disable (ok-but b_auswahl-fenster))))
                                         (when (double-click-p)
                                              (dialog-item-action (ok-but b_auswahl-fenster)))
                                         (values t nil))
                                        (t 
                                         (values t nil))))
                                  ))
                                  
           (add-subviews b_auswahl-fenster (setf (seq b_auswahl-fenster) sequence))
        
        (let* ((sequence-size (view-size (seq b_auswahl-fenster)))
               (sequence-ende (+ sequence-start-y (point-v sequence-size)))
               (window-size (make-point die_fenster_breite
                                        (+ sequence-ende 50)))  ;=20+20+10
               (ok-button-position (make-point (- die_fenster_breite 100)
                                               (+ sequence-ende 20))))  ;abstand von der sequence
          
          (set-view-size b_auswahl-fenster window-size)
          
          (if vorselektierte-auswahlpunkte
            (dolist (vorselektierter-auswahlpunkt vorselektierte-auswahlpunkte)
              (cell-select sequence
                           (make-point 0
                                       (if (eql werttyp :position)
                                         (1- vorselektierter-auswahlpunkt)
                                         (position vorselektierter-auswahlpunkt text-wert-alist :key #'second :test #'equal))))))
          
          
          (when ueberschrift (add-subviews b_auswahl-fenster ueberschrift-static-text))
          
          (add-subviews b_auswahl-fenster
                        (setf (ok-but b_auswahl-fenster) 
                              (m->a=erzeuge-dialog-item '*b-ok-button*
                                :dialog-item-text ok-text
                                    :view-width  90
                                :view-position ok-button-position
                                :dialog-item-enabled-p 
                                (if unbedingt-etwas-auswaehlen (selected-cells sequence) t)
                                :dialog-item-action 
                                #'(lambda (self) 
                                    (declare (ignore self))
                                    (let ((selected-cells (selected-cells sequence)))
                                      (return-from-modal-dialog
                                       (mapcar #'(lambda (selected-cell)
                                                   (if (eql werttyp :position)
                                                     (1+ (point-v selected-cell))
                                                     (second (nth (point-v selected-cell) text-wert-alist))))
                                               selected-cells)))))))
          (b=set-default-button b_auswahl-fenster (ok-but b_auswahl-fenster))
          
          (when abbrechen-text
            (add-subviews b_auswahl-fenster
                          (m->a=erzeuge-dialog-item 
                           '*b-abbrechen-button*
                           :dialog-item-text abbrechen-text
                           :view-width 90
                           :view-position (make-point (- (point-h ok-button-position) 100)
                                                      (point-v ok-button-position))
                           :dialog-item-action #'(lambda (self)
                                                   (declare (ignore self))
                                                   (if throw-to-cancel
                                                     (return-from-modal-dialog :cancel)
                                                     (return-from-modal-dialog nil)))))))
        (set-view-position b_auswahl-fenster fensterposition))))
  
  (with-cursor *arrow-cursor*
    (modal-dialog b_auswahl-fenster nil)))

#|
********************************************************************************
********************************************************************************
beispiele:

(b=auswahl `(("a" 15) ("b" 33))
           :abbrechen-text nil
           :vorselektierte-auswahlpunkte `(33)
           :anzahl-sichtbarer-zeilen 4  
           :unbedingt-mit-scrollbar t  
           :selection-type :disjoint
           :auswahlfeld-schrift b_normalschrift
           :werttyp :wert)

(b=auswahl `(("dialog") ("wissenserwerb")) 
           :werttyp :position
           ;:schrift b_normalschrift
           :ueberschrift "bitte waehlen...")

(b=auswahl `(("1") ("2") ("3") ("4") ("5") ("6") ("7") ("8") ("9") ("10") ("11") ("12"))
           :selection-type :disjoint)
(b=auswahl `(("1") ("2") ("3") ("4") ("5") ("6") ("7") ("8") ("9") ("10") ("11") ("12"))
           :unbedingt-mit-scrollbar t
           :abbrechen-text nil
           :fensterbreite 700)

(b=auswahl `(("1") ("2") ("3") ("4") ("5") ("6") ("7") ("8") ("9") ("10") ("11") ("12"))
           :ueberschrift "lange mehrzeilige ueberschrift, die von klaus zerhakt wird und die vor
newline einen festen zeilenumbruch hat")

(b=auswahl `(("ute"))
           :ueberschrift "lange ueberschrift mit \"unterstrings\", die als sonderzeichen markiert sind und eingebautes
newline")

(b=auswahl `(("mit ganz langen auswahlpunkten") 
             ("dkfj kjds fklslks(license-to-object (edit-definition '9jnd flk dfs dsfsdfsdf")))
;wenn fensterbreite nicht gesetzt wird -> sequence wird vom objektsystem abgeschnitten


(b=auswahl `(("1") ("2") ("3") ("4") ("5") ("6") ("7") ("8") ("9") ("10") ("11") ("12")
             ("11") ("12") ("13") ("14") ("15") ("16") ("17") ("18") ("19") ("110") ("111") ("112")
             )
           :ueberschrift "lange mehrzeilige ueberschrift, die von klaus zerhakt wird und die vor
newline einen festen zeilenumbruch hat")

(b=auswahl `(("1") ("2") ("3") ("4") ("5") ("6") ("7") ("8") ("9") ("10") ("11") ("12")
             ("11") ("12") ("13") ("14") ("15") ("16") ("17") ("18") ("19") ("110") ("111") ("112")
             )
           :fensterposition (make-point 20 500)
 :unbedingt-etwas-auswaehlen t
           :ueberschrift "lange mehrzeilige ueberschrift, die von klaus zerhakt wird und die vor

newline einen festen zeilenumbruch hat")

(b=auswahl  '(:dialog :classika)
            :werttyp :wert
            :selection-type :single
            :f-werte-verbalisieren #'(lambda(was)(case was (:dialog "dialog die erste")(t "der wissenserwerb"))))

;beispiel mit countdown:
(b=auswahl `(("a" 15) ("b" 33))
           :abbrechen-text nil
        ;   :vorselektierte-auswahlpunkte `(33)
           :anzahl-sichtbarer-zeilen 4  
           :unbedingt-etwas-auswaehlen t  
           :selection-type :disjoint
           :auswahlfeld-schrift b_normalschrift
           :werttyp :wert :sekunden 5)
********************************************************************************
********************************************************************************
|#
