;; new common dialog for fonts

;; Allegro Common Lisp
;; patch for pcbug

;;                              -[Wed Jun 23 21:30:59 1993 by cheetham]-
;; 
;; copyright (c) 1985, 1986 Franz Inc, Alameda, CA  All rights reserved.
;; copyright (c) 1986-1992 Franz Inc, Berkeley, CA  All rights reserved.
;;
;; The software, data and information contained herein are proprietary
;; to, and comprise valuable trade secrets of, Franz, Inc.  They are
;; given in confidence by Franz, Inc. pursuant to a written license
;; agreement, and may be stored and used only in accordance with the terms
;; of such license.
;;
;; Restricted Rights Legend
;; ------------------------
;; Use, duplication, and disclosure of the software, data and information
;; contained herein by any agency, department or entity of the U.S.
;; Government are subject to restrictions of Restricted Rights for
;; Commercial Software developed at private expense as specified in FAR
;; 52.227-19 or DOD FAR Supplement 252.227-7013 (c) (1) (ii), as
;; applicable.
;;

(setq sys::*last-patch-description*

    ;; Enter patch description in the quotes.  This can be a multi-line
    ;; explanation of the problem being fixed and what the patch
    ;; achieves.  This string will go into the header file that
    ;; becomes the text part of the patch entry on the bbs.

    "The new user function cg:ask-user-for-font will pop up the
Windows 3.1 Common Dialog for font selection.  This function will
also be used internally by aclpc for font selection.

(defun cg:ask-user-for-font (&key initial-font fixed-width-only-p
                              minimum-size maximum-size) ...)

Arguments:
initial-font --- if passed, should be a font object to
   be displayed initially in the dialog; if not passed, then no
   initial font is displayed.
fixed-width-only-p --- if non-NIL, then the choices displayed in
   the dialog will be only those fonts where every character is the
   same width, such as :courier\ new.
minimum-size --- if passed, should be a positive integer denoting
   the minimum acceptable point size of the font; all sizes are
   still listed in the dialog, but a pop-up error dialog will prevent
   the user from returning an unacceptable size
maximum-size --- if passed, should be a positive integer denoting
   the maximum acceptable point size of the font

One potential source of confusion is that while aclpc specifies font
sizes in pixels, the Windows 3.1 Common Dialog specifies them in points.
So the size that you select from the dialog will not be the same as
the size value in the returned font object.  Aclpc will continue to use
pixel-size programmatically in order to use the same units that are used
for window dimensions and other drawing, etc., where font sizes must
be made to fit.  The point sizes that appear in the Common Dialog will be
similar to those that are familiar from choosing fonts interactively
in other applications.
")

;; Enter one-line patch description here.
(defvar sys::*patches* nil)
(push (cons :NNN "Use the Common Dialog for font selection, and provide a user function")
      sys::*patches*)

(in-package :win)

;; new 
(cl:export 'win::choosefont :win)
(cl:eval-when (cl:compile cl:load cl:eval)
 (defcstruct choosefont
  ((cfstructsize long)
   (cfowner short)
   (cfhdc short)
   (cflogfont long)
   (cfpointsize short)
   (cfflags long)
   (cfcolors long) ; colorref
   (cfcustomdata long)
   (cfcallback long)
   (cftemplatename long)
   (cfhinstance short)
   (cfstyle long) ; a string
   (cftype short)
   (cfsizemin short)
   (cfsizemax short)))
 )

;; new 
(cl:export 'win::bold_fonttype :win)
(cl:export 'win::italic_fonttype :win)
(cl:export 'win::regular_fonttype :win)
(cl:export 'win::screen_fonttype :win)
(cl:export 'win::printer_fonttype :win)
(cl:export 'win::simulated_fonttype :win)

;; new 
(cl:export 'win::cf_screenfonts :win)
(cl:export 'win::cf_printerfonts :win)
(cl:export 'win::cf_both :win)
(cl:export 'win::cf_showhelp :win)
(cl:export 'win::cf_enablehook :win)
(cl:export 'win::cf_enabletemplate :win)
(cl:export 'win::cf_enabletemplatehandle :win)
(cl:export 'win::cf_inittologfontstruct :win)
(cl:export 'win::cf_usestyle :win)
(cl:export 'win::cf_effects :win)
(cl:export 'win::cf_apply :win)
(cl:export 'win::cf_ansionly :win)
(cl:export 'win::cf_novectorfonts :win)
(cl:export 'win::cf_nooemfonts :win)
(cl:export 'win::cf_nosimulations :win)
(cl:export 'win::cf_limitsize :win)
(cl:export 'win::cf_fixedpitchonly :win)
(cl:export 'win::cf_wysiwyg :win)
(cl:export 'win::cf_forcefontexist :win)
(cl:export 'win::cf_scalableonly :win)
(cl:export 'win::cf_ttonly :win)
(cl:export 'win::cf_nofacesel :win)
(cl:export 'win::cf_nostylesel :win)
(cl:export 'win::cf_nosizesel :win)

;; new 
(cl:defconstant bold_fonttype #x100)
(cl:defconstant italic_fonttype #x200)
(cl:defconstant regular_fonttype #x400)
(cl:defconstant screen_fonttype #x2000)
(cl:defconstant printer_fonttype #x4000)
(cl:defconstant simulated_fonttype #x8000)

(cl:defconstant cf_screenfonts #x1)
(cl:defconstant cf_printerfonts #x2)
(cl:defconstant cf_both (cl:logior cf_screenfonts cf_printerfonts))
(cl:defconstant cf_showhelp #x4)
(cl:defconstant cf_enablehook #x8)
(cl:defconstant cf_enabletemplate #x10)
(cl:defconstant cf_enabletemplatehandle #x20)
(cl:defconstant cf_inittologfontstruct #x40)
(cl:defconstant cf_usestyle #x80)
(cl:defconstant cf_effects #x100)
(cl:defconstant cf_apply #x200)
(cl:defconstant cf_ansionly #x400)
(cl:defconstant cf_novectorfonts #x800)
(cl:defconstant cf_nooemfonts #x800)
(cl:defconstant cf_nosimulations #x1000)
(cl:defconstant cf_limitsize #x2000)
(cl:defconstant cf_fixedpitchonly #x4000)
(cl:defconstant cf_wysiwyg #x8000)
(cl:defconstant cf_forcefontexist #x10000)
(cl:defconstant cf_scalableonly #x20000)
(cl:defconstant cf_ttonly #x40000)
(cl:defconstant cf_nofacesel #x80000)
(cl:defconstant cf_nostylesel #x100000)
(cl:defconstant cf_nosizesel #x200000)

;; new 
(defun-dll win::ChooseFont
 ((choosefont (choosefont *)))
 :return-type bool
 :library-name "commdlg.dll"
 :entry-name "ChooseFont")



(in-package :pc)

;; new
(export 'cg::ask-user-for-font :cg)
(defun cg::ask-user-for-font (&key initial-font fixed-width-only-p
                              minimum-size maximum-size)
 (pop-up-font-dialog initial-font fixed-width-only-p
  minimum-size maximum-size))

;; unchanged
(progn
  (defconstant bold-bit 1)
  (defconstant italic-bit 2)
  (defconstant underline-bit 4)
  (defconstant outline-bit 8)
  (defconstant strike-out-bit 128))

;;from windows\dlgfont.lsp
(fmakunbound 'set-toploop-font)
(defun set-toploop-font (dialog foo1 foo2) 
  (declare (ignore dialog foo1 foo2))
  (let ((new-font (pop-up-font-dialog (font *terminal-io*))))
    (when new-font 
          (setq top::*top-font* new-font); cac pcbug155
          (set-font *terminal-io* new-font)))) 

;;from windows\dlgfont.lsp
(fmakunbound 'set-editor-font)
(defun set-editor-font (dialog foo1 foo2) 
  (declare (ignore dialog foo1 foo2))
  (let ((new-font (pop-up-font-dialog text-edit:*editor-font*)))
    (when new-font 
          (setf text-edit:*editor-font* new-font)
          (dolist (window  te::*lisp-editor-windows*)
                (unless (closed-stream-p window) (set-font window new-font))))))

#-:RUNTIME-SYSTEM
;;from windows\dlgfont.lsp
(fmakunbound 'set-inspector-font)
#-:RUNTIME-SYSTEM
(defun set-inspector-font (dialog foo1 foo2) 
  (declare (ignore dialog foo1 foo2))
  (let ((new-font (pop-up-font-dialog inspector::*inspector-font*)))
    (when new-font 
          (setf  inspector::*inspector-font* new-font)
          (dolist (window inspector::*inspector-windows*)
                (set-font window new-font)))))

;;from windows\dlgfont.lsp
(fmakunbound 'pop-up-font-dialog)
(defun pc::pop-up-font-dialog (current-font &optional fixed-width-only-p
                               minimum-size maximum-size)
 (declare (ignore reopen-dialog))
 (let* ((logfont (ccallocate logfont))
        (choosefont (ccallocate choosefont))
        (style-word (if current-font
                     (font-style-word current-font)
                     0))
        (face-string (if current-font
                        ;; Add the null character to the face string
                        (format nil "~a~a" (font-face current-font)
                           (int-char 0))
                        ""))
        return-value returned-face-name returned-family)
  (csets logfont logfont
     lfheight (if current-font
                 ;; Though the doc says this should be a negative number
                 ;; to exclude internal leading, we seem to have to pass
                 ;; it as positive here to sync with using negative
                 ;; numbers elsewhere to exclude leading.  Note that
                 ;; the common dialog always returns a negative number
                 ;; in this slot, apparently excluding internal leading.
                 (font-size current-font)
                 0)
     lfwidth 0
     lfescapement 0
     lforientation 0
     lfweight (cond
                   ((ilogtest style-word bold-bit) FW_BOLD)
                   #+no ;; we don't support this one
                   ((ilogtest style-word outline-bit) FW_LIGHT)
                   (t FW_NORMAL))
     lfitalic (if (ilogtest style-word italic-bit) 1 0)
     lfunderline (if (ilogtest style-word underline-bit) 1 0)
     lfstrikeout (if (ilogtest style-word strike-out-bit) 1 0)
     lfcharset ANSI_CHARSET
     lfoutprecision OUT_DEFAULT_PRECIS
     lfclipprecision CLIP_DEFAULT_PRECIS
     lfquality DEFAULT_QUALITY
     lfpitchandfamily 
     (if current-font
      (case (font-family current-font)
       (:decorative 
        #.(logior FF_DECORATIVE DEFAULT_PITCH))
       (:modern 
        #.(logior FF_MODERN FIXED_PITCH))
       (:roman 
        #.(logior FF_ROMAN VARIABLE_PITCH))
       (:script 
        #.(logior FF_SCRIPT DEFAULT_PITCH))
       (:swiss 
        #.(logior FF_SWISS VARIABLE_PITCH))
       ((nil) 
        #.(logior FF_DONTCARE DEFAULT_PITCH)))
      0)
     (lffacename (string (length face-string)))
     face-string
     )
  (csets choosefont choosefont
     cfstructsize (sizeof choosefont)
     cfowner 0
     cfhdc 0 ; only used to select printer fonts
     cflogfont (AllocAlias16 logfont)
     cfpointsize 0 ; set on output
     cfflags (logior
                 CF_BOTH ; show both screen and printer fonts
                 CF_FORCEFONTEXIST ; error if select non-existant font
                 (if current-font
                  CF_INITTOLOGFONTSTRUCT ; default to passed-in font
                  0)
                 CF_LIMITSIZE
                 (if fixed-width-only-p
                  CF_FIXEDPITCHONLY 0)
                 )
     cfcolors 0
     cfcustomdata 0
     cfcallback 0
     cftemplatename 0
     cfhinstance (handle-value shandle *hinst*)
     cfstyle 0
     cftype (logior
                (if (ilogtest style-word bold-bit) BOLD_FONTTYPE 0)
                (if (ilogtest style-word italic-bit) ITALIC_FONTTYPE 0)
                (if (or (ilogtest style-word bold-bit)
                     (ilogtest style-word italic-bit))
                 REGULAR_FONTTYPE 0))
     cfsizemin (or minimum-size 4)
     cfsizemax (or maximum-size 999)
     )
  (setq return-value (ChooseFont choosefont))
  (cond (return-value ;; t means it worked
         (setq returned-face-name
          (cref logfont logfont lffacename nil
             (string #.LF_FACESIZE)))
         (setq returned-family (logand #b11110000
                                (cref logfont logfont lfpitchandfamily)))
         (make-font
            ;; family
            (case returned-family
             (#.FF_DECORATIVE :decorative)
             (#.FF_MODERN :modern)
             (#.FF_ROMAN :roman)
             (#.FF_SCRIPT :script)
             (#.FF_SWISS :swiss)
             (t nil))
            ;; face
            (intern (string-upcase
                     (acl::substring returned-face-name 0
                      (ct:strlen returned-face-name)))
             :keyword)
            ;; size
            (abs (cref logfont logfont lfheight))
            ;; style
            (logior
             (if (eq (cref logfont logfont lfweight) FW_BOLD)
              bold-bit 0)
             (if (plusp (cref logfont logfont lfitalic))
              italic-bit 0)
             (if (plusp (cref logfont logfont lfunderline))
              underline-bit 0)
             (if (plusp (cref logfont logfont lfstrikeout))
              strike-out-bit 0)
            )))
   (t
      (let ((error-code (win::CommDlgExtendedError)))
       (and (plusp error-code) ;; zero means cancelled, so return NIL
        (error (format nil 
                "Common (font) dialog error ~a."
                error-code))))))))
