#|
********************************************************************************
********************************************************************************
*****                                                                      *****
*****                        Dialogfunktion b=nachrichen-fenster           *****
*****                                                                      *****
*****    Autor: Klaus Goos                         Erstellt: 17.4.90       *****
*****           Klaus Goos                         Geaendert:  10.02.94    *****
*****                                                                      *****
********************************************************************************
********************************************************************************
|#

(defclass *b-Nachricht-Fenster* (#+:ccl *b-Selbstantwort-mixin* 
                                 *b-window*)
  ())

(defclass *b-Nachricht-ohne-Button-Fenster* 
  (#+:ccl *b-Selbstantwort-mixin*
   *b-bei-klick-schliessen-dialog*)
  ())

#+:ccl
(defmethod countdown-ende ((fenster *b-Nachricht-ohne-Button-Fenster*))
  (view-click-event-handler fenster 0))

(defvar b_nachricht-Fenster)

(unless (boundp 'b_Nachricht-Icon)
   (defparameter b_Nachricht-Icon WARNING-ICON))

(defun b=nachricht (nachricht &key (icon b_Nachricht-Icon)
                              (ok-text (b=s :ok))
                              (fensterposition b_Dialogfenster-Position-oben)
                              (fensterbreite 350)
                              (schrift b_Chicagoschrift)
                              (sekunden nil))
  #|Autor: Klaus, 17.04.90

Eingabeparameter:
- Nachricht:       Nachricht fuer den Benutzer
- Icon:            Beliebiges Icon; default ist b-Nachrichten-Icon
- OK-text:         Text des OK-buttons (default: "OK"). Falls Ok-text = NIL
                   so erscheint kein Button und der Dialog kann durch einen
                   Click ins Fenster geschlossen werden.
- Fensterposition: Position des Fensters 
                   (default = b_Dialogfenster-Position-oben)
- Fensterbreite:   die Breite des Fensters in Pixel.
                   (Die fensterhoehe wird immer automatisch berechnet)
- Schrift:         (default = b_Chicagoschrift)

- Sekunden:        Sekundenanzahl, nach der das Fenster in jedem Fall wieder zugehen soll,
                   falls der Benutzer nicht den OkKnopf gedrckt hat

Bemerkung:
- Icon-pos:        Position des Icons im Dialog (default = #@(10 10))

|#
  (unless (stringp nachricht)
    (setq nachricht (b=erzeuge-string nachricht)))
   #+:aclpc
   (unless (stringp ok-text)
      (setq ok-text "Ok"))
  (let* ((icon-groesse 32)
         (button-size #@(90 20))
         (button-hoehe (point-v button-size))
         (button-breite (point-h button-size))
         (icon-pos #@(10 10))
         (text-breite (- fensterbreite (+ icon-groesse (* 3 (point-h icon-pos)))))
         (text-info (multiple-value-list (b=static-text nachricht text-breite 
                                                        (+ icon-groesse (* 2 (point-h icon-pos))) 
                                                        (point-v icon-pos) :font schrift)))
         
         (text-item (first text-info))
         (text-hoehe (second text-info))
         (fensterhoehe (if ok-text 
                        (+ text-hoehe button-hoehe (* 4 (point-v icon-pos)))
                        (if (> text-hoehe icon-groesse)
                          (+ text-hoehe (* 2 (point-v icon-pos)))
                          (+ icon-groesse (* 2 (point-v icon-pos))))))
         (fensterhoehe1 (if (and sekunden (null ok-text)) (+ fensterhoehe 20) fensterhoehe))
         (fensterklasse (if ok-text
                          '*b-Nachricht-Fenster*
                          '*b-Nachricht-ohne-Button-Fenster*
                           ))
         )
    (when (and (boundp 'b_nachricht-Fenster)
               (wptr b_nachricht-Fenster)
               (not (typep b_nachricht-Fenster fensterklasse)))
      (window-close b_nachricht-Fenster))
    (if (and (boundp 'b_nachricht-Fenster)
             (wptr b_nachricht-Fenster)
             (typep b_nachricht-Fenster fensterklasse)
             )
      (progn
        #+:ccl-2 (sekunden-setzen b_nachricht-Fenster nil)
        (apply #'remove-subviews b_nachricht-Fenster (subviews b_nachricht-Fenster))
        #+:ccl-2 (sekunden-setzen b_nachricht-Fenster sekunden)
        (set-view-size b_nachricht-Fenster (make-point fensterbreite fensterhoehe1)))
      (progn
        (setq b_nachricht-Fenster (m->a=erzeuge-modal-fenster fensterklasse
                                   :window-title "Nachricht"
                                     :view-position fensterposition
                                     :window-show nil
                                     :view-size (make-point fensterbreite fensterhoehe1)
                                     :window-type :double-edge-box
                                     #+:ccl :sekunden #+:ccl sekunden
                                     ))
        ;(modal-dialog b_nachricht-Fenster)
        ))
    (set-view-position b_nachricht-fenster fensterposition)
    ;Vielleicht passt das ganze nicht mehr auf dem Bildschirm ==> ueberpruefen
    (let* ((y-position (point-v (view-position b_nachricht-Fenster)))
           (maximale-fensterhoehe (- *screen-height* 10 y-position)))
      (when (> fensterhoehe maximale-fensterhoehe)
        ;Fenster passt nicht mehr auf dem Bildschirm !
        (let ((zu_gross (- fensterhoehe maximale-fensterhoehe)))
          (-= fensterhoehe zu_gross)
          (-= text-hoehe zu_gross)
          (set-view-size b_nachricht-fenster (make-point fensterbreite fensterhoehe))
          (set-view-size text-item (make-point (point-h (view-size text-item)) text-hoehe))
          (set-dialog-item-text text-item (b-drei-punkte-einfuegen (dialog-item-text text-item) text-hoehe (b=schrifthoehe schrift)))
          )))
    (add-subviews  b_nachricht-fenster
                   (m->a=erzeuge-dialog-item '*b-icon-dialog-item*
                    :icon icon
                    :view-position icon-pos))
    (when ok-text   
       (add-subviews b_nachricht-fenster
          (m->a=erzeuge-dialog-item '*b-button*
             :view-size button-size
             :dialog-item-text ok-text
             :view-position (make-point (- fensterbreite (+ (point-h icon-pos) button-breite))
                               (- fensterhoehe (+ (point-v icon-pos) button-hoehe)))
                                                    :dialog-item-action #'(lambda (self)
                                                                             (declare (ignore self))
                                                                             (return-from-modal-dialog NIL))
             :default-button T)))
     (add-subviews b_nachricht-fenster text-item)
     (with-cursor *arrow-cursor*
        (modal-dialog b_nachricht-fenster NIL)
        )))

#| 
********************************************************************************
********************************************************************************
Beispiel:

(b=nachricht "Soeben wurde die Wissensbasis zerstoert!!!")
(b=nachricht 'wqeruziqwer :sekunden 5)
(b=nachricht "Soeben wurde die Wissensbasis zerstoert!!!" :ok-text NIL :sekunden 3)
(with-cursor *watch-cursor*
  (b=nachricht "Soeben wurde die Wissensbasis zerstoert!!!" :ok-text NIL))
(b=nachricht "Soeben 
wurde 
die
 Wissensbasis
 zerstoert!!!
1
2
3
4
"  :fensterposition (make-point 50 600) )

********************************************************************************
********************************************************************************
|#

