#|
Erweiterung auf Buttons, Texte und Numerisch
Keine Symbolkonstruktion mehr:
|#

#|

********************************************************************************
********************************************************************************
*****                                                                      *****
*****                        *b-konfigurierungsdialog*                     *****
*****                                                                      *****
*****    Autor: Karsten Poeck                      Erstellt: 28.10.90      *****
*****                                              Verbessert 7.2.94       *****
********************************************************************************
********************************************************************************

Dieser Dialog ist dafuer geeignet Variablen einzustellen, ueblicherweise Konfigurierungsvariablen.
Diese werden dann mit Hilfe eines Modal-Dialogs gesetzt, der fuer jede Alternative
einen Radioknopf, Check-Boxen oder entsprechendes bietet.

Layout:

-------------------Ueberschrift-------------------
"Unterueberschrift"
"Bezeichner1" O Wert_1 O Wert_2    .. O Wert_N
...
"BezeichnerN" O Wert_1 O Wert_2    .. O Wert_N
'Sichern' 'Laden' 'Standard' 'Abbrechen' 'Ok'

Schnittstellen:

1)
Falls das gleich Fensterobjekt mehrmals wiederverwendet werden soll und in einer
Globalen Variablen gespeichert wird
(b=konfigurierungsdialog-aufrufen 
 (variablenname
  variablenliste 
  f-werte-name
  &key
  f-inaktive-bezeichner
  f-sichern
  f-laden
  (defaultliste nil)
  (Ueberschrift "Ueberschrift")
  (lesefunktion 'symbol-value)
  (schreibfunktion 'set)
  (fensterbreite 620)
  (zeilenabstand 17)
  (alternativenabstand 150)
  (alternativenanfang 150)
  ))
2)
Sonst 
(modal-dialog
 (b=konfigurationsdialog-erzeugen  ....)
 ohne den Parameter variablenname

Parameter:
Variablenname:         Symbol, unter dessen Wertbindung der Dialog abgespeichert wird 
Variablenliste:        ( (variablensymbol1 "Variablenstring1" [:abstand zahl] REST)
                         ...
                         (variablensymbolN "VariablenstringN" [:abstand zahl] REST)
                       )
REST ::= [:single] Alternative11 .. Alternative1n
         :multiple Alternative11 .. Alternative1n
         :numerisch [Stellenzahl]
         :text [Stellenzahl]
         :button [Funktion [Pixelbreite]]
         Falls ein anderer Dialog aufgerufen werden soll z.B. Schriftauswahl
         
                       zwischendurch kann auch ein String stehen, der dann nur als lokale Ueberschrift ausgegeben wird
                       Mit :abstand Zahl , kann fuer eine Variable der Standardabstand zwischen den Alternativen geaendert werden

f-werte-name           Funktion zur Verbalisierung der Alternativen
                       Parameter (Alternativen) ==> String

Optionale Parameter

f-inaktive-bezeichner: Funktion, die Liste von Variablen liefert, die 'disabled' werden sollen
                       Diese werden nur dargestellt, koennen aber nicht veraendert werden.
                       Parameter ()
f-sichern:             Funktion, die zum sichern der Einstellungen (auf Datei) aufgerufen wird, nachdem die aktuellen
                       Belegungen durch Aufruf der schreibfunktion gesichert wurden. 
                       Falls angegeben erscheint button 'sichern'
                       Parameter ()
f-laden:               Funktion zum Laden von Einstellungen (von Datei)
                       Parameter ()
                       Falls angegeben erscheint button 'laden'
defaultliste:          ( (Variablenbezeichner Standardwert) .. (Variablenbezeichner Standardwert) bzw.
                         (Variablenbezeichner (Standardwert1 .. Standardwert1))), falls :multiple
                       Falls angegeben erscheint Knopf 'Standard'
Ueberschrift:           String, der die Ueberschrift des Dialoges angibt
lesefunktion:          Funktion, die zum Lesen aus der Variable benutzt wird (Default symbol-value fuer globale Variablen)
                       Parameter (Variablenbezeichner_als_Symbol)
schreibfunktion:       Funktion, die zum Schreiben der Werte in die Variablen benutzt wird (Default set fuer globale Variablen)
                       Parameter (Variablenbezeichner_als_Symbol Wert-oder-Werte)
fensterbreite:         Breite des Dialoges in pixel
zeilenabstand:         abstand der Zeilen in Pixel
alternativenabstand:   Abstand der Antwortalternativen untereinander in pixel
alternativenanfang:    Abstand der Alternativen von der linken Seite des Dialogs in Pixeln

|#

(defun b-fenster-lebendig-p (fenster)
     #+:ccl-2 (wptr fenster)
     #+:aclpc (typep fenster 'window))

(defun b=konfigurierungsdialog-aufrufen (variablenname
                                              variablenliste 
                                              f-werte-name
                                              &key
                                              f-inaktive-bezeichner
                                              f-sichern
                                              f-laden
                                              (defaultliste nil)
                                              (Ueberschrift "berschrift")
                                              (lesefunktion 'symbol-value)
                                              (schreibfunktion 'set)
                                              (fensterbreite 620)
                                              (zeilenabstand 17)
                                              (alternativenabstand 150)
                                              (alternativenanfang 150))
  (if (and (boundp variablenname)
           (symbol-value variablenname)
           (b-fenster-lebendig-p  (symbol-value variablenname)))
    (with-cursor
      *watch-cursor*
      (bk=dialog-aktualisieren (symbol-value variablenname)))
    (set variablenname
         (b=konfigurationsdialog-erzeugen
          variablenliste 
          f-werte-name
          :f-inaktive-bezeichner f-inaktive-bezeichner
          :f-sichern f-sichern
          :f-laden f-laden
          :defaultliste defaultliste
          :Ueberschrift Ueberschrift
          :lesefunktion lesefunktion
          :schreibfunktion schreibfunktion
          :fensterbreite fensterbreite
          :zeilenabstand zeilenabstand
          :alternativenabstand alternativenabstand
          :alternativenanfang alternativenanfang)))
  (modal-dialog (symbol-value variablenname) nil)
  )
      
 
(defclass *b-konfigurierungsdialog* (*b-button-window*)
  (
   (die_liste :initarg :die_liste :initform nil)
   (defaultliste :initarg :defaultliste :initform nil)
   (lesefunktion :initarg :lesefunktion :initform nil)
   (schreibfunktion :initarg :schreibfunktion :initform nil)
   (f-inaktive-bezeichner :initarg :f-inaktive-bezeichner :initform nil)
   ;(f-sichern :initarg :f-sichern :initform nil)
   ;(f-laden :initarg :f-laden :initform nil)
   ;private slots
   (multiple :initform nil)
   (numerisch :initform nil)
   (text :initform nil)
   (buttonsliste :initform nil)
   (variable_wbliste :initform nil)
   (variablenname_objektaliste :initform nil)
   )
  )

(defmethod initialize-instance ((wer *b-konfigurierungsdialog*) &rest liste)
  (apply #'call-next-method wer liste))

(defmethod merke-objekt-zu-variable&wert ((wer *b-konfigurierungsdialog*) objekt variable &optional (wert t))
  (setf (getf (getf (slot-value wer 'variablenname_objektaliste) variable) wert)
        objekt)
  objekt
  )

(defmethod lese-objekt-zu-variable&wert ((wer *b-konfigurierungsdialog*) variable &optional (wert t))
  (b-lese-objekt (getf (slot-value wer 'variablenname_objektaliste) variable) wert))
      
(defun b-lese-objekt (liste wert)
  (second (member wert liste :test #'equal)))

(defclass *bk-button* (*b-button*)
  ((wert :initform nil)
   (f-werte-name :initarg :f-werte-name :Accessor bk-f-werte-name)
   )
  )

(defmethod initialize-instance ((ich *bk-button*)
                                &rest init-list
                                &key wert bk-aufruffunktion)
  (apply #'call-next-method ich
         :dialog-item-action
         #'(lambda(was)
             (declare (ignore was))
             (dialog-item-wert-setzen
              ich
              (funcall bk-aufruffunktion (slot-value ich 'wert))))
               init-list)
   
  (dialog-item-wert-setzen ich wert))

(defmethod dialog-item-wert ((ich *bk-button*))
  (slot-value ich 'wert))


(defmethod dialog-item-wert-setzen ((ich *bk-button*) wert)
  (setf (slot-value ich 'wert) wert)
  (set-dialog-item-text ich
                        (or (funcall (bk-f-werte-name ich) wert) "Setzen")))
                                       
(defun b=konfigurationsdialog-erzeugen (variablenliste f-werte-name
                                                             &key
                                                             f-inaktive-bezeichner
                                                             f-sichern
                                                             f-laden
                                                             (defaultliste nil)
                                                             (Ueberschrift "berschrift")
                                                             (lesefunktion 'symbol-value)
                                                             (schreibfunktion 'set)
                                                             (fensterbreite 620)
                                                             (zeilenabstand 17)
                                                             (alternativenabstand 150)
                                                             (alternativenanfang 150)
                                                             )
  
  (with-cursor *watch-cursor*
    (let*  (
            (temporaeres_formular 
             (m->a=erzeuge-modal-fenster
              '*b-konfigurierungsdialog*
              :window-title ""
              :die_liste variablenliste
              :defaultliste defaultliste
              :lesefunktion lesefunktion
              :schreibfunktion schreibfunktion
              :f-inaktive-bezeichner f-inaktive-bezeichner
              :view-size (make-point fensterbreite 400)
              :view-font b_Normalschrift
              :window-type :double-edge-box
              :window-show nil
              :buttons
              (remove nil
                      (list 
                       (if f-sichern
                         (m->a=erzeuge-dialog-item '*b-button*
                                        :dialog-item-text (b=s :sichern)
                                        :dialog-item-action
                                        #'(lambda(wer)
                                           (bk-konf-OK-ACTION (view-container wer))
                                           (funcall f-sichern)))
                         nil)
                       (if f-laden
                         (m->a=erzeuge-dialog-item '*b-button*
                                        :dialog-item-text (b=s :Laden)
                                        :dialog-item-action
                                        #'(lambda(wer)
                                           (funcall f-laden)
                                           (bk=dialog-aktualisieren (view-container wer))))
                         nil)
                       (if defaultliste
                         (m->a=erzeuge-dialog-item '*b-button*
                                        :dialog-item-text (b=s :Standard)
                                        :dialog-item-action
                                        #'(lambda(wer)
                                           (bk-konf-standard-action (view-container wer))))
                         nil)
                       (m->a=erzeuge-dialog-item '*b-Abbrechen-button*
                                      :dialog-item-action  #'(lambda(wer)
                                                              (declare (ignore wer))
                                                              (return-from-modal-dialog :cancel)))
                       (m->a=erzeuge-dialog-item '*b-ok-button*
                                      :default-button t
                                      :dialog-item-action #'(lambda(wer)
                                                             (bk-konf-OK-ACTION (view-container wer))
                                                             (return-from-modal-dialog t)))
                       ))))
            (ueberschriftengroesse (string-width Ueberschrift b_Chicagoschrift))
            (ueberschriftenanfang (- (ceiling fensterbreite 2)
                                     (ceiling ueberschriftengroesse 2)))
            (strichgroesse (string-width "_" :bold))
            (anzahl_striche (ceiling (- fensterbreite 10) strichgroesse))
            )
      
      ;Baue Ueberschrift ein
      (add-subviews temporaeres_formular
                    (m->a=erzeuge-dialog-item '*b-static-text-dialog-item*
                                   :dialog-item-text (make-sequence 'string anzahl_striche :initial-element #\_)
                                   :view-position #@(5 20)
                                   :view-font :bold)
                    (m->a=erzeuge-dialog-item '*b-static-text-dialog-item*
                                   :dialog-item-text Ueberschrift
                                   :view-position (make-point ueberschriftenanfang 7)
                                   :view-font b_Chicagoschrift))
      
      
      (let ((position #@(10 45)) ;vorher 5 anstatt 10
            (zeilenabstand (make-point 0 zeilenabstand)))
        (dolist (zeile variablenliste)
          (cond 
           ((stringp zeile)  ;Ueberschrift
            (add-subviews temporaeres_formular
                          (m->a=erzeuge-dialog-item '*b-static-text-dialog-item*
                                         :view-position position
                                         :dialog-item-text zeile
                                         :view-font b_Dickschrift)))
           
           (T   ;Zeile mit Bezeichner und Auswahlfelder
            (apply #'add-subviews
                   temporaeres_formular
                   (cons
                    (m->a=erzeuge-dialog-item '*b-static-text-dialog-item*
                                   :view-position position 
                                   :dialog-item-text (second zeile)
                                   :view-font b_Normalschrift)
                    (let* ((ab alternativenanfang)
                           (abstand (if (eql (third zeile) :abstand)
                                      (fourth zeile) alternativenabstand))
                           (akt_x ab)
                           (variable (first zeile))
                           objekte
                           )
                      (when (eql (third zeile) :abstand)
                        (setq zeile (cddr zeile)))
                      (cond ((eql :numerisch (third zeile))
                              (push variable (slot-value temporaeres_formular 'numerisch))
                             (setf (getf (slot-value temporaeres_formular 'variable_wbliste) variable) (cdddr zeile))
                             (push 
                              (merke-objekt-zu-variable&wert
                               temporaeres_formular
                               (m->a=erzeuge-dialog-item '*b-zahl*
                                 :view-position (add-points position (make-point akt_x 0))
                                 :view-font b_Normalschrift
                                 :wert (funcall lesefunktion variable)
                                 :stellenzahl (or (fourth zeile) 20)
                                 )
                               variable)
                              objekte)
                             (incf akt_x abstand)
                             objekte
                             )
                            ((eql :text (third zeile))
                              (push variable (slot-value temporaeres_formular 'text))
                             (setf (getf (slot-value temporaeres_formular 'variable_wbliste) variable) (cdddr zeile))
                             (push 
                              (merke-objekt-zu-variable&wert
                               temporaeres_formular
                               (let ((zeilenzahl (or (fifth zeile) 1)))
                                 (prog1
                                   (m->a=erzeuge-dialog-item (if (>= zeilenzahl 3)
                                                                                  '*B-MULTI-TEXT*
                                                                                   '*b-text*)
                                                             :stellenzahl (or (fourth zeile) 20)
                                                             :zeilenzahl zeilenzahl
                                                             :v-scrollp (>= (or (fifth zeile) 1) 3)
                                                             :view-position (add-points position (make-point akt_x 0))
                                                             :view-font b_Normalschrift
                                                             :wert (funcall lesefunktion variable)
                                                             )
                                   (if (> zeilenzahl 1)
                                     (setq position (add-points position
                                                                (make-point 0 
                                                                            (* (1- zeilenzahl) (point-v zeilenabstand)))))
                                      (setq position (add-points position
                                                                zeilenabstand))
                                      )))
                               variable)
                              objekte)
                             (+= akt_x abstand)
                             objekte
                             )
                            ((eql :button (third zeile))
                              (push variable (slot-value temporaeres_formular 'buttonsliste))
                             (setf (getf (slot-value temporaeres_formular 'variable_wbliste) variable) (cdddr zeile))
                             (push 
                              (merke-objekt-zu-variable&wert
                               temporaeres_formular
                               (m->a=erzeuge-dialog-item 
                                '*Bk-Button*
                                :f-werte-name f-werte-name                         
                                 :bk-aufruffunktion (fourth zeile)
                                 :dialog-item-text "Setzen"
                                 :view-position (add-points position (make-point akt_x 0))
                                 :breite (or (fifth zeile) 200)
                                 :wert (funcall lesefunktion variable)
                                 )
                               variable)
                              objekte)
                             (setq position (add-points position (make-point 0 5)))
                             (incf akt_x abstand)
                             objekte
                             )
                            ((eql :multiple (third zeile))
                             (push variable (slot-value temporaeres_formular 'multiple))
                             (setf (getf (slot-value temporaeres_formular 'variable_wbliste) variable) (cdddr zeile))
                             (dolist (wert (cdddr zeile) objekte)
                               (when (> (+ akt_x (+ 20 ;platz fueer kreis von knopf
                                                    (string-width (funcall f-werte-name wert) b_Normalschrift)))
                                        (- fensterbreite 10))
                                 (setq position (add-points position zeilenabstand))
                                 (setq akt_x ab))
                               (push 
                                (merke-objekt-zu-variable&wert
                                 temporaeres_formular
                                 (m->a=erzeuge-dialog-item '*b-check-box-dialog-item*
                                   :view-position (add-points position (make-point akt_x 0))
                                   :view-font b_Normalschrift
                                   :dialog-item-text (funcall f-werte-name wert)
                                   :check-box-checked-p (member wert (funcall lesefunktion variable)
                                                                :test #'equal
                                                                ))
                                 variable wert)
                                objekte)
                               (incf akt_x abstand)))
                        (t
                          (setf (getf (slot-value temporaeres_formular 'variable_wbliste) variable) (cddr zeile))
                          (dolist (wert (if (eq :single (third zeile))
                                          (cdddr zeile) 
                                          (cddr zeile))
                                        objekte)
                            (when (> (+ akt_x (+ 20 ;platz fueer kreis von knopf
                                                 (string-width (funcall f-werte-name wert) b_Normalschrift)))
                                     (- fensterbreite 10))
                              (setq position (add-points position zeilenabstand))
                              (setq akt_x ab))
                            (push 
                             (merke-objekt-zu-variable&wert temporaeres_formular 
                             (m->a=erzeuge-dialog-item '*b-radio-button-dialog-item*
                                            :view-position (add-points position (make-point akt_x 0))
                                            :view-font b_Normalschrift
                                            :dialog-item-text (funcall f-werte-name wert)
                                            :radio-button-cluster variable
                                            :radio-button-pushed-p (eql wert (funcall lesefunktion variable)))
                              variable wert)
                             objekte)
                            (incf akt_x abstand))))
                      )
                    )))) ;cond
          (setq position (add-points position zeilenabstand))
          );dolist zeile
        
        (setq position (make-point 0 (point-v position)))
        (set-view-size temporaeres_formular (make-point fensterbreite (+ (point-v position) 50)))  
        ;(bk-aktivierung-ueberpruefen temporaeres_formular)
        (set-view-position temporaeres_formular :centered)
        );let position
      (bk=dialog-aktualisieren temporaeres_formular)
      temporaeres_formular
      )
    )
  
  )

#|
(defun b-variablenname (variable wert)
  "Abbildung variable wert auf Radioobjektname"
  (b=lese-von-String
   (b=in-sequence-ersetzen
    (b=konkateniere-nach-string 
     variable "=" (B=erzeuge-string wert))
    '(#\( #\_)
      '(#\) #\_)
      '(#\space #\_)
      '(#\: #\_))))
|#

(defmethod bk-aktueller_wert ((wer *b-konfigurierungsdialog*) variable werte)
  "Welcher der Alternativen in werte zu Variable ist gueltig"
  (cond ((member variable (slot-value wer 'multiple))
         (remove-if-not
          #'(lambda (wert)
              (check-box-checked-p (lese-objekt-zu-variable&wert wer  variable wert)))
          werte))
        ((or (member variable (slot-value wer 'numerisch))
             (member variable (slot-value wer 'text))
             (member variable (slot-value wer 'buttonsliste))
             )
         (dialog-item-wert (lese-objekt-zu-variable&wert wer variable))
         )
        (t (find-if #'(lambda(wert)
                        (radio-button-pushed-p (lese-objekt-zu-variable&wert wer  variable wert)))
                    werte)))
  )

(defmethod bk=dialog-aktualisieren ((wer *b-konfigurierungsdialog*) )
  "Aktualisieren des Formulars auf die Werte der globalen Variablen"
  (set-view-font wer b_normalschrift)
  (dolist (zeile (slot-value wer 'die_liste))
    (when (listp zeile)   ;ansonsten handelt sich um eine Zwischenueberschrift
      (let* ((variable (first zeile))
             (wert-oder-werte (funcall (slot-value wer 'lesefunktion) variable)))
        (cond ((member variable (slot-value wer 'multiple))
               (dolist (wert (getf (slot-value wer 'variable_wbliste) variable))
                 (if (member wert wert-oder-werte :test #'equal)
                   (check-box-check (lese-objekt-zu-variable&wert wer variable wert))
                   (check-box-uncheck (lese-objekt-zu-variable&wert wer variable wert)))))
              ((or (member variable (slot-value wer 'numerisch))
                   (member variable (slot-value wer 'text))
                   (member variable (slot-value wer 'buttonsliste))
                   )
               (dialog-item-wert-setzen (lese-objekt-zu-variable&wert wer variable) wert-oder-werte)
               )
              (T (let ((objekt  (lese-objekt-zu-variable&wert wer  variable wert-oder-werte)))
                      (when objekt
                           (radio-button-push objekt )))))
        )
      )
    )
  (bk-aktivierung-ueberpruefen wer)
  )

(defmethod bk-aktivierung-ueberpruefen ((wer *b-konfigurierungsdialog*))
  ;eventuell Objekte ausschalten ...
  (when (and (slot-value wer 'f-inaktive-bezeichner) (funcall (slot-value wer 'f-inaktive-bezeichner)))
    (let ((inaktive (funcall (slot-value wer 'f-inaktive-bezeichner))))
      (dolist (zeile (slot-value wer 'DIE_LISTE))
        (when (listp zeile)
          (let ((variable (first zeile))
                (werte (cddr zeile)))
            (when (eql :abstand (first werte))
              (setq werte (cddr werte)))
            (cond
             ((member (first werte) (list :text :numerisch :button))
              (funcall (if (member variable inaktive)
                         #'dialog-item-disable
                         #'dialog-item-enable) (lese-objekt-zu-variable&wert wer variable t))
              )
             (t
              (when (or (eql :multiple (first werte))
                        (eql :single (first werte)))
                (setq werte (rest werte)))
              (dolist (objekt (mapcar #'(lambda(wert)
                                          (lese-objekt-zu-variable&wert wer variable wert))
                                      werte))
                (funcall (if (member variable inaktive)
                           #'dialog-item-disable
                           #'dialog-item-enable) objekt)))))))))
  )

(defmethod bk-konf-ok-action ((wer *b-konfigurierungsdialog*) )
  "Aktualisieren der Parameter nach ok"
  (mapcar 
   #'(lambda (zeile)
       (when (listp zeile)
         (let ((variable (first zeile))
               (werte (cddr zeile)))
           (when (eql :abstand (first werte))
             (setq werte (cddr werte)))
           (when (member (first werte) (list :single :multiple))
             (setq werte (rest werte)))
           ;(print `(,variable ,werte))
           (funcall (slot-value wer 'schreibfunktion) variable (bk-aktueller_wert wer variable werte))
           )))
   (slot-value wer 'die_liste))
  )

(defmethod bk-konf-standard-action ((wer *b-konfigurierungsdialog*))
  (set-view-font wer b_normalschrift)
  (dolist (paar (slot-value wer 'defaultliste))
    (let ((variable (first paar))
          (wert-oder-werte (second paar)))
      (cond ((member variable (slot-value wer 'multiple))
             (dolist (wert (getf  (slot-value wer 'variable_wbliste) variable))
               (if (member wert wert-oder-werte)
                 (check-box-check (lese-objekt-zu-variable&wert wer variable wert))
                 (check-box-uncheck (lese-objekt-zu-variable&wert wer variable wert)))))
            ((or (member variable (slot-value wer 'numerisch))
                 (member variable (slot-value wer 'text))
                 (member variable (slot-value wer 'buttonsliste))
                 )
             (dialog-item-wert-setzen (lese-objekt-zu-variable&wert wer  variable ) wert-oder-werte)
             )
            (T 
             (if (lese-objekt-zu-variable&wert wer  variable wert-oder-werte)
               (radio-button-push (lese-objekt-zu-variable&wert wer  variable wert-oder-werte))
               (print 
                (b=konkateniere-nach-string "Die Variable " variable " ist nicht im Dialog definert"))))))
    )
  )
