

(defun b=dokumentsymbol-zeichnen (view position &key (groesse #@(10 14))
                                       (eselsohrgroesse
                                        (make-point (ceiling (point-h groesse) 3)
                                                    (ceiling (point-h groesse) 3)))
                                       (invertiert-p nil))
  (let ((breite (point-h groesse))
        (hoehe (point-v groesse))
        (eselsohrbreite (point-h eselsohrgroesse))
        (eselsohrhoehe (point-v eselsohrgroesse)))
    (progn
      (erase-rect view position (add-points position groesse))
      (cond (invertiert-p
             (let ((region-alles nil)) (move-to view position) (open-region view)
                  (line view 0 hoehe) (line view breite 0)
                  (line view 0 (- (- hoehe eselsohrhoehe)))
                  (line view (- eselsohrbreite) (- eselsohrhoehe))
                  (line view (- (- breite eselsohrbreite)) 0)
                  (setq region-alles (close-region view))
                  (fill-region view *black-pattern* region-alles) (dispose-region region-alles)))
            (t
             (let (region-ecke) (move-to view position) (line view 0 hoehe)
                  (line view breite 0) (line view 0 (- (- hoehe eselsohrhoehe)))
                  (line view (- eselsohrbreite) (- eselsohrhoehe))
                  (line view (- (- breite eselsohrbreite)) 0)
                  (move-to view (add-points position (make-point (- breite eselsohrbreite) 0)))
                  (open-region view) (line view 0 eselsohrhoehe) (line view eselsohrbreite 0)
                  (line view (- eselsohrbreite) (- eselsohrhoehe))
                  (setq region-ecke (close-region view))
                  (fill-region view *black-pattern* region-ecke) (dispose-region region-ecke)))))))

#|Beispiel:
(setq wer (make-instance 'dialog))

(b=dokumentsymbol-zeichnen wer #@(50 50) :groesse #@(50 70) :eselsohrgroesse #@(20 30))
(b=dokumentsymbol-zeichnen wer #@(50 50) :groesse #@(50 70))
(b=dokumentsymbol-zeichnen wer #@(50 50))
(b=dokumentsymbol-zeichnen wer #@(80 50) :invertiert-p t)

(frame-rect wer (make-point 80 50) #@(90 65))

|#


(defun b=dokumentsymbol-loeschen (view position &key (groesse #@(10 14)))
  (erase-rect view position (add-points position (add-points groesse #@(1 1)))))


#|Beispiel:
(setq wer (make-instance 'dialog))

(b=dokumentsymbol-zeichnen wer #@(50 50))
(b=dokumentsymbol-loeschen wer #@(50 50))
|#

;********************
; LISP-Umgebung
;***********

(defun b=Inhalt-der-Zwischenablage ()
  "liefert den Inhalt der Zwischenablage als String, die vom LISP-System 
   fuer cut und paste benutzt wird"
  ;Autor: Ute, Datum: April 90, August 92
  (b=erzeuge-string (get-scrap :text))  ;am Anfang lieferte die Funktion `nil, daher b=erzeuge-String
  )

;*********************************************
; Ausgabeformatierung mit Fonts
;*********************************


(defun b=durchschnittliche-Buchstabenbreite (&optional schrift)
  ;Autor: Bertil?
  (round (string-width
      "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890"
      (if schrift schrift b_normalschrift))
     68))


(defun b=schrifthoehe (font)
  "Liefert die Schrifthoehe vom Font font in Pixeln."
  
#|Autor: Klaus, 17.04.1990|#
#|
Verbessert Karsten 4.1.93, value-list -> value-bind
|#
  (multiple-value-bind
    (a b c d)
    (font-info font)
    (declare (ignore c))
  (+ a b d)))

#| Beispiel:
(b=schrifthoehe `("geneva" 9  :bold))
|#

(defun  b=static-text (string textbreite-in-pixeln x y &key (font b_Chicagoschrift))
"Zerhackt den Text mit Hilfe der Funktion b=breche-string-um entsprechend der textbreite-
in-pixeln und legt einen *static-text-dialog-item* an. Der Text wird dabei an der
Position (x,y) positioniert. Zurueckgeliefert wird das Dialog-item und die Gesamthoehe des 
entstehenden Textes als multiple-value."

#|Autor: Klaus, 17.04.1990|#

  (let* ((string-liste (b=string-umbrechen string textbreite-in-pixeln font))
        (schrifthoehe (b=schrifthoehe font))
        (gesamt-texthoehe (* schrifthoehe (length string-liste)))
        (item NIL)
        (zeilen (length string-liste))
        (texthoehe-in-pixeln (* schrifthoehe zeilen)))
    (setq item (make-instance 'static-text-dialog-item
                      :dialog-item-text string
                      :view-size 
                      (make-point textbreite-in-pixeln texthoehe-in-pixeln)
                      :view-position 
                      (make-point x y)
                      :view-font font))
      (values item gesamt-texthoehe)))

#| Beispiel:
(b=static-text "hallo world hallo world hallo world" 60 40 50)
(b=static-text "Soeben wurde die Wissensbasis zerstoert!!!" 60 40 50)
|#

(defun  b=static-text-die-zweite (string textbreite-in-pixeln x y &key (font b_Chicagoschrift))
"Zerhackt den Text mit Hilfe der Funktion b=breche-string-um entsprechend der textbreite-
in-pixeln und legt einen *static-text-dialog-item* an. Der Text wird dabei an der
Position (x,y) positioniert. Zurueckgeliefert wird das Dialog-item und die Gesamthoehe des 
entstehenden Textes als multiple-value."
  (let* ((string-liste (b=string-umbrechen string textbreite-in-pixeln font))
         (die-echte-breite (b=min string-liste :vergleichsfunktion #'>
                                  :testfunktion #'(lambda(string)
                                                    (string-width string font))))
        (schrifthoehe (b=schrifthoehe font))
        (gesamt-texthoehe (* schrifthoehe (length string-liste)))
        (item NIL)
        (zeilen (length string-liste))
        (texthoehe-in-pixeln (* schrifthoehe zeilen)))
    (setq item (make-instance 'static-text-dialog-item
                      :dialog-item-text string
                      :view-size 
                      (make-point (+ 5 die-echte-breite) texthoehe-in-pixeln)
                      :view-position 
                      (make-point x y)
                      :view-font font))
      (values item gesamt-texthoehe)))


;********************
; Ausgabe
;***********

;********************
; Fenster und Bildschirm
;***********

(defun b=Fenster-hat-growbox-p (Fenster)
  (memq (window-type Fenster) 
        `(:document-with-grow :document-with-zoom)))

#|
(b=Fenster-hat-growbox-p (make-instance `*b-window*))
-> nil
(b=Fenster-hat-growbox-p (make-instance `*b-window* :window-type :document-with-zoom))
-> t
(b=Fenster-hat-growbox-p (make-instance `*b-window* :grow-icon-p t))
-> t
|#

(defun b=fenster-vollstaendig-sichtbar-p (fenster)
  "Ist das Fenster vollstndig auf dem Bildschirm sichtbar"
  (and (b=punkt-im-rechteck-p (view-position fenster) 
                              (make-point 0 0)
                              (make-point *screen-width* *screen-height*))
       (b=punkt-im-rechteck-p (add-points  (view-position fenster)
                                           (view-size fenster))
                              (make-point 0 0)
                              (make-point *screen-width* *screen-height*))))
(defun b=fenster-ok-p (fenster)
  (and (null fenster))
  (typep fenster 'window)
  (wptr fenster))

(defun b=bezeichnetes-fenster-ok-p (bezeichner)
  (and (boundp bezeichner)
       (b=fenster-ok-p (eval bezeichner))))


(defun b=grosser-Bildschirm-p ()
  (> *screen-width* 700))

(defun b=Standard-Fensterposition ()
  (if (b=grosser-Bildschirm-p)
    (make-point 4 46)
    (make-point 2 40)))

(defun b=menubar-bottom ()   ;*menubar-bottom* funktioniert nicht fuer den grossen Bildschirm
                            ;                 mit breiterer Menuezeile
  (if (b=grosser-Bildschirm-p)
    *menubar-bottom*
    44))

(defun b=freie-bildschirmhoehe ()    ;Die Hoehe des Bildschirms ohne die Menuezeile
  (- *screen-height* (b=menubar-bottom)))


(defun b=Fenster-growbox-p (window)
  (memq (window-type window)
        `(:document-with-zoom  ;(= default, wenn `window-type nicht angegeben)
          :document-with-grow))
          ;keine growbox haben: :document, :tool, :double-edge-box, :single-edge-box, :shadow-edge-box
  )

(unless (boundp 'b_Fenster-versetzen-Offset)
     (setq b_Fenster-versetzen-Offset (make-point 15 15)))

(defun b=Position-fuer-neues-Fenster (&key default-window-position
                                         (window-position-difference b_Fenster-versetzen-Offset)
                                         (window-position-max-difference 150)
                                         (window-type 'window)
                                         (fenster-test-funktion #'(lambda(fenster)
                                                                    (typep fenster window-type)))
                                         (default-Position-wenn-kein-grosser-Bildschirm-p t)  
                                         (versetzen-wenn-kein-grosser-Bildschirm-p nil))
  "gibt die erste freie Fensterposition zurueck,
   die zu bisherigen Fenstern des gleichen Fenstertyps
   um window-position-difference versetzt ist"
  #|
  falls alle moeglichen Positionen der angegebenen Spanne besetzt sind, erscheint das window
  an der ersten Position, die noch am wenigsten oft besetzt ist.

  window-type                         = die Objektklasse des Fensters
  fenster-test-funktion               = Funktion, die entscheidet, ob der Fenstertyp gleich ist
                                        ist nur noetig, falls der window.type nicht ausreichend ist
  default-window-position             = Position des ersten Windows
                                        wenn nicht angegeben -> Position oben rechts
  window-position-difference          = Verschiebung bzgl. dem letzten gleichartigen Fenster
  window-position-max-difference      = max. Verschiebung von oben (faengt wieder bei default-window-position an)
  default-Position-wenn-kein-grosser-Bildschirm-p 
                                      = wenn kein grosser Bildschirm vorhanden ist, wird die uebergebene
                                        default-window-position als Fensterposition genommen
                                        Wenn nil -> Das Fenster kommt oben links in die Ecke
  versetzen-wenn-kein-grosser-Bildschirm-p
                                      = wenn kein grosser Bildschirm da ist, wird trotzdem versetzt
  Autor: Ute, Datum: Maerz 90
  |#
  (unless default-window-position (setq default-window-position (b=Standard-Fensterposition)))
  (when (not (b=grosser-Bildschirm-p))
    (when (not default-Position-wenn-kein-grosser-Bildschirm-p) ;d.h. Fenster kommt oben links hin
      (setq default-window-position (b=Standard-Fensterposition))))
     
  (if (and (not (b=grosser-Bildschirm-p))
           (not versetzen-wenn-kein-grosser-Bildschirm-p))
    default-window-position
    (let* ((bestehende-Fensterpositionen (remove nil (mapcar #'(lambda (window)
                                                                 (if (funcall fenster-test-funktion window)
                                                                   (view-position window)))
                                                             (windows)))))
      (do ((Probierposition default-window-position (add-points Probierposition window-position-difference))
           (Fensteranzahl-auf-Position 0)  ;brauche ich nur lokal, nicht merken
           (bisher-geringste-Fensteranzahl-und-Position `(100000 (make-point 0 0))))  ;Liste aus Fensteranzahl und Position
          ((> (- (point-v Probierposition) (point-v default-window-position))
              window-position-max-difference) 
           (second bisher-geringste-Fensteranzahl-und-Position))
        (setq Fensteranzahl-auf-Position (count Probierposition bestehende-Fensterpositionen))
        (if (eql Fensteranzahl-auf-Position 0)
          (return Probierposition)
          (when (< Fensteranzahl-auf-Position (first bisher-geringste-Fensteranzahl-und-Position))
            (setq bisher-geringste-Fensteranzahl-und-Position
                  (list Fensteranzahl-auf-Position Probierposition))))))
    ))

#|
Beispiel:
(dotimes (x 12)
  (make-instance 'dialog :view-position (b=Position-fuer-neues-Fenster)))
(make-instance 'dialog :view-position (b=Position-fuer-neues-Fenster))
|#

(defun b=Oberflaeche-wechseln (Fenster-gehoert-zur-neuen-Oberflaeche-Praedikat
                                 &key (Oberflaechenwechsel-mit-Fensterklick-p nil))
  "die Funktion holt alle Fenster einer bestimmten Anwendung
   an die Oberflaeche"
  #|
  ob ein Fenster zur neuen Oberflaeche gehoert, wird mit der Funktion
  Fenster-gehoert-zur-neuen-Oberflaeche-Praedikat getestet.
  Achtung: die Funktion ist noch nicht richtig getestet und sollte deshalb
           vorlaeufig noch nicht verwendet werden
           (ich hatte das in ACL 1.2.2 mit window-show gemacht; das geht
            aber jetzt nicht mehr)
  ;Autor: Ute (war vorher Annettes Funktion); Datum: Maerz 90
  |#
  (let ((layer 0))
    (dolist (window (windows))
      (when (funcall Fenster-gehoert-zur-neuen-Oberflaeche-Praedikat window)
        (without-interrupts
         (set-window-layer window layer))
        (setq layer (1+ layer)))))
  (unless Oberflaechenwechsel-mit-Fensterklick-p
    (when (funcall Fenster-gehoert-zur-neuen-Oberflaeche-Praedikat (front-window))   ;damit nicht ein anderes Fenster aktiviert wird
      (window-select (front-window)))))


(defun b=Fenster-zu-globaler-Position (globale-position)
"Das Fenster zurckgeben, das sich unter einer
globalen Mausposition befindet"
; Gnter, 1.3.93
  (rlet ((wptr :pointer))
    (#_FindWindow globale-position wptr)
    (%setf-macptr wptr (%get-ptr wptr))
    (window-object wptr)))

(defun b=View-zu-globaler-Position (position)
"Den innersten View zur angegebenen Position"
; Gnter, 1.3.93  
(let ((view (b=Fenster-zu-globaler-Position position)))
    (when view
      (flet ((subview (view)
               (find-clicked-subview view (global-to-local view position))))
        (do ((subview (subview view) (subview view)))
            ((or (null subview) (eq subview view)) view)
          (setq view subview))))))

#|;Beispiel:
(let ((win (front-window)))
  (do (view new-view)
      ((mouse-down-p))
    (setq new-view 
          (b=View-zu-globaler-Position (local-to-global win (view-mouse-position win))))
    (unless (eq view new-view) (print new-view))
    (setq view new-view)))

zeigt an, ber welchem View jeweils die Maus steht, bis man das nchte Mal klickt
|#


(defun b=fensterausmass-maximal (maximales-fensterausmass fensteranfang)
  ;ist nur fuer eine dimension
  
  (- maximales-fensterausmass fensteranfang 3))


;********************
; Heap
;***********

(defun b=freier-Mac-Heap ()
  (#_freemem))

#|
vor Karstens nderung (Juli 93):

(defun b=freier-Mac-Heap ()
  (let* ((string
          (with-output-to-string 
            (*standard-output*)
            (room)))
         (position-erste-schliessende-klammer
          (position #\) string)))
    (if position-erste-schliessende-klammer
      (values (parse-integer  string :start (1+ position-erste-schliessende-klammer)
                              :junk-allowed t))
      0)))
|#