;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: COMMON-LISP-INTERNALS; Lowercase: Yes -*-

(fs:record-source-file-name 'get-macro-character 'defun t)

;;; From sys:clcp;read-print.lisp:

(defun get-macro-character (char &optional (a-readtable *readtable*))
  (when (null a-readtable)
    (setq a-readtable si:*initial-common-lisp-readtable*))
  (multiple-value-bind (value non-terminating-p)
      (get-macro-character-internal (strip-characters-style char) a-readtable)
    (cond ((null value) value)
	  ((and (lexical-closure-p value)
		(equal (arglist value) '(list-so-far stream))
		(zl:boundp-in-closure value 'function)
		
		;; I rewrote the code because the predicate of cond does
		;; not return multiple values (according to CLtL1&2).
		;; Being this the case one never get the value of
		;; non-terminating-p.
		
		;; (values
		(symbol-value-in-closure value 'function)
		;; non-terminating-p)
		)
	   (values (symbol-value-in-closure value 'function)
		   non-terminating-p))
	  (t (values
	       #'(lambda (stream char)
		   (ignore char)
		   (multiple-value-bind (thing ignore splicep)
		       (funcall value nil stream)
		     (if splicep
			 (if (atom thing)
			     (values)
			     (values (car thing)))
			 (values thing))))
	       non-terminating-p)))))



#|

Try this:
(cond ((values 1 2 )))

|#

