;;;; -*- Mode:Common-Lisp; Package:CLIP; Fonts:(MEDFNT); Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/mac-files/clip/demos/zacks-test-code.lisp *-*
;;;; *-* Last-edit: Monday, March 29, 1993  18:37:04; Edited-By: Westy *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                           CLIPS Example                                *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: David L. Westbrook
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  01-19-93 File Created.  (WESTY)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package #+CLTL2 clip #-CLTL2 'clip)

;;; ---------------------------------------------------------------------------
;;; 
;;; ---------------------------------------------------------------------------

(defclip delays ()
  (:components (total-delay-time number-of-delays))
  (loop with number-of-delays = 0
        and total-delay-time = 0
        and local-delay-time = 0
    for order in (find-units 'order (make-paths '(scheduler * order)) :ALL) do
    (setf local-delay-time (- (task-network$finish-time (order$network order)) (order$due-date-time order)))
    (unless (zerop local-delay-time)
      (incf number-of-delays)
      (incf total-delay-time local-delay-time))
    finally (values total-delay-time number-of-delays)))

(defclip total-delay-time (value))

(defclip number-of-delays (value))
  
;;; ***************************************************************************
;;; The Experiment Definition

(define-experiment zacks-test-experiment (resource-type resource-count start-perc end-perc increment)
  "This is the test experiment documentation-string."
  :start-system #+MCL (ccl::beep) #+allegro (clim::beep) 
                 #+Explorer w::beep
                ;#+Explorer arm:run-arm
  ;; references to these get expanded into property-list references ala `with-slots'
  ;:locals (zacks-var)
  ;; these are like locals that are stepped using the cross-product code
  :ivs ((control-strategy '(control-strategy-1 control-strategy-2 control-strategy-3))
        ;(control-strategy '(control-strategy-1 control-strategy-2 control-strategy-3))
	(perc from start-perc downto end-perc by increment)
        ;(perc '(90 80 70 60 50 40 30 20 10))
	)
  ;; actually we could do the below using loop with a collection of the var
;  :range ((control-strategy in control-strategies)
;          (perc from start-perc to end-perc downto increment))
  ;; all the ivs can also be referenced here as if the were defined using defclip
  :instrumentation (trial-number control-strategy perc delay-cost)
  ;; before experiment gets called with the args 
  :before-experiment (clips::spy resource-type resource-count start-perc end-perc increment)
  ;; before trial is called with args, ivs
  :before-trial (clips::spy control-strategy perc)
                  #+LATER
                  (setf (get (resource-on-demand-entry resource-type) :max-creation-limit)
                        (round (* perc resource-count) 100))
    ;; after trial is called with args, ivs
  :after-trial
    ;; Other options here include building CLASP datasets,
    ;; exporting to some database, massaging the data or some
    ;; combination fo these.
  (progn ;(zacks-function)
         (write-current-experiment-data))
  ;; after experiment is called with args
  :after-experiment (clips::spy resource-type resource-count start-perc end-perc increment)

  )

;;; ***************************************************************************
;;; Example

#|

; Executing this:

;;; need to make number of trials optional 
;; 
(run-experiment 'zacks-test-experiment)
                
|#

;;; ***************************************************************************
;;; EOF






