;;;; -*- Mode:Common-Lisp; Package:TRANSSIM; Fonts:(MEDFNT); Base:10 -*-
;;;; *-* File: Titanic: /usr/users/eksl/mac-files/clip/demos/transsim-experiment.lisp *-*
;;;; *-* Last-edit: Wednesday, July 28, 1993  20:26:01; Edited-By: Westy *-* 
;;;; *-* Machine: Count (Explorer II, Microcode 489) *-*
;;;; *-* Software: TI Common Lisp System 6.49 *-*
;;;; *-* Lisp: TI Common Lisp System 6.49  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *                                                                        *
;;;; *                          Experiment Definition                         *
;;;; *                                                                        *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: David L. Westbrook
;;;             Experimental Knowledge Systems Laboratory
;;;             Paul R. Cohen, Principal Investigator
;;;             David L. Westbrook, Systems Manager
;;;             David M. Hart, Laboratory Manager
;;;             Department of Computer Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  07-22-93 File Created.  (Westy)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; --*--

(in-package :TRANSSIM)

;;; --*--
;;; ***************************************************************************


;;; ---------------------------------------------------------------------------
;;; Clips
;;; ---------------------------------------------------------------------------

(clip:defclip the-date ()
  "the-date"
  ()
  (current-date))

(clip:defclip queue-backlog ()
  (:period "1 day")
  (float (length (contents (docking-queue (port 'port-2))))))

;;; ---------------------------------------------------------------------------
;;; Experiment
;;; ---------------------------------------------------------------------------

(clip:define-experiment ship-activity ()
  "Test sensitivity of ship activity prediction to scenario parameters."

  :start-system (transsim::simulate nil)
  :reset-system (transsim::initialize-simulation)
  :schedule-function schedule-function-for-clip
  :deactivate-scheduled-function reset
  :seconds-per-time-unit (transsim::internal-time->seconds 1)
  :ivs               ((number-of-ships '(100 50))                     ; Declare independent variables
                      (number-of-cargo '(60 180 300)))
  :locals            ()
  :instrumentation   (clip::trial-number                          ; Declare clips to be used
		       number-of-ships 
		       number-of-cargo
		       queue-backlog
		       the-date)
;  :script ((test 10 24 (ticl::beep))) ; 10 hours in transsim
  :before-trial      (let ((scenario-name (el::form-symbol "SCE-" (princ-to-string number-of-ships)
							   "-" (princ-to-string number-of-cargo))))
		       (name-scenario scenario-name)
		       (add-to-scenario scenario-name 'PORT
					 :name 'port-1 
					 :connected-ports '(port-2 port-3) 
					 :dock-specs 1
					 :geoloc-x 4000 :geoloc-y 4000)
		       (add-to-scenario scenario-name 'PORT
					 :name 'port-2 
					 :connected-ports '(port-1 port-3) 
					 :dock-specs 1
					 :geoloc-x 4000 :geoloc-y 8000)
		       (add-to-scenario scenario-name 'PORT
					 :name 'port-3 
					 :connected-ports '(port-1 port-2) 
					 :dock-specs 1
					 :geoloc-x 8000 :geoloc-y 4000)
		       (add-to-scenario scenario-name 'SHIPS
					:number (truncate number-of-ships 3)
					:initial-location 'port-1)
		       (add-to-scenario scenario-name 'SHIPS
					:number (truncate number-of-ships 3)
					:initial-location 'port-2)
		       (add-to-scenario scenario-name 'SHIPS
					:number (truncate number-of-ships 3)
					:initial-location 'port-3)
		       (add-to-scenario scenario-name 'SMR-MULTI
					:ports '(port-1 port-2 port-3)
					:load-date 0
					:amount number-of-cargo)
		       (build-scenario scenario-name))

  :after-trial       (progn
		       #+DEBUG
		       (write (slot-value (clip:find-instrumentation 'queue-length) 'clip::value)
			      :stream *standard-output*)
                       (clip:write-current-experiment-data)))	   ; Produce the data file
                       
;;; ---------------------------------------------------------------------------
;;; Example Invocation
;;; ---------------------------------------------------------------------------

#+TEST
(clips:run-experiment 'ship-activity 
		      :number-of-trials 2
		      :output-file "ed-buffer:out")

;;;----------------------------------------------------------------------------
;;; Helpers

(defun schedule-function-for-clip (function time period name)
  (if period
      (schedule-recurring-event (event-actuator :external)
                                          :function function
                                          :time time
                                          :period period
                                          :type (or name :instrumentation))
      (schedule-event (event-actuator :external)
                                :function function
                                :time time
                                :type (or name :instrumentation))))

;;;----------------------------------------------------------------------------
;;; EOF