;; -*- Mode: LISP; Package:(BOXER GLOBAL 1000); Base: 8.; Fonts:CPTFONT -*-

;; (C) Copyright 1985 Massachusetts Institute of Technology
;;
;; Permission to use, copy, modify, distribute, and sell this software
;; and its documentation for any purpose is hereby granted without fee,
;; provided that the above copyright notice appear in all copies and that
;; both that copyright notice and this permission notice appear in
;; supporting documentation, and that the name of M.I.T. not be used in
;; advertising or publicity pertaining to distribution of the software
;; without specific, written prior permission.  M.I.T. makes no
;; representations about the suitability of this software for any
;; purpose.  It is provided "as is" without express or implied warranty.
;;

;;;this file contains all the macro and defsubsts
;;;for the display code

;;;NOTE:it must be loaded before any of the other display files

(DEFSUBST MAKE-SCREEN-CHA (ACTUAL-CHA)
  ACTUAL-CHA)

(DEfSUBST SCREEN-CHA? (SC) (FIXNUMP SC))

(DEFUN CHA-WIDTH (CHA)
  (CHA-WID (FONT-NO CHA) (CHA-CODE CHA)))

(DEFVAR FREE-SCREEN-ROWS NIL
  "A list of free screen-rows.")

(DEFVAR FREE-SCREEN-BOXS NIL
  "A list of free screen-boxs.")

(DEFVAR FREE-GRAPHICS-SCREEN-BOXS NIL
  "A list of free graphics-screen-boxs.")

(DEFVAR INITIAL-NO-OF-FREE-SCREEN-ROWS 150.)

(DEFVAR INITIAL-NO-OF-FREE-SCREEN-BOXS 600.)

(DEFVAR INITIAL-NO-OF-FREE-GRAPHICS-SCREEN-BOXS 50.)

(DEFSUBST ALLOCATE-GRAPHICS-SCREEN-BOX-INTERNAL (GRAPHICS-BOX)
  (LET ((GRAPHICS-SCREEN-BOX (OR (POP FREE-GRAPHICS-SCREEN-BOXS)
				 (MAKE-INSTANCE 'GRAPHICS-SCREEN-BOX))))
    (TELL GRAPHICS-SCREEN-BOX :RE-INIT GRAPHICS-BOX)
    GRAPHICS-SCREEN-BOX))

(DEFUN ACTUAL-OBJ-OF-SCREEN-OBJ (SCREEN-OBJ)
  (IF (SCREEN-CHA? SCREEN-OBJ)
      SCREEN-OBJ
      (SCREEN-OBJ-ACTUAL-OBJ SCREEN-OBJ)))

(DEFSUBST ALLOCATE-SCREEN-ROW-INTERNAL (ACTUAL-ROW)
  (LET ((SCREEN-ROW (OR (POP FREE-SCREEN-ROWS) (MAKE-INSTANCE 'SCREEN-ROW))))
    (TELL SCREEN-ROW :RE-INIT ACTUAL-ROW)
    SCREEN-ROW))

(DEFSUBST ALLOCATE-SCREEN-BOX-INTERNAL (ACTUAL-BOX)
  (LET ((SCREEN-BOX (OR (POP FREE-SCREEN-BOXS) (MAKE-INSTANCE 'SCREEN-BOX))))
    (TELL SCREEN-BOX :RE-INIT ACTUAL-BOX)
    SCREEN-BOX))

(DEFSUBST ALLOCATE-GRAPHICS-SCREEN-SHEET-INTERNAL (GRAPHICS-SHEET)
  (MAKE-GRAPHICS-SCREEN-SHEET GRAPHICS-SHEET))


(DEFSUBST ALLOCATE-SCREEN-OBJ-INTERNAL (ACTUAL-OBJ)
  (COND ((GRAPHICS-BOX? ACTUAL-OBJ) (ALLOCATE-GRAPHICS-SCREEN-BOX-INTERNAL ACTUAL-OBJ))
	((and (port-box? actual-obj) (graphics-box? (tell actual-obj :ports)))
	 (ALLOCATE-GRAPHICS-SCREEN-BOX-INTERNAL ACTUAL-OBJ))
	((BOX? ACTUAL-OBJ) (ALLOCATE-SCREEN-BOX-INTERNAL ACTUAL-OBJ))
	((ROW? ACTUAL-OBJ) (ALLOCATE-SCREEN-ROW-INTERNAL ACTUAL-OBJ))
	((GRAPHICS-SHEET? ACTUAL-OBJ) (ALLOCATE-GRAPHICS-SCREEN-SHEET-INTERNAL ACTUAL-OBJ))
	(T (BARF 'BOXER-REDISPLAY-ERROR :FORMAT-CTL "Can't allocate a screen-obj for ~S"
		 :FORMAT-ARG ACTUAL-OBJ))))

(DEFSUBST DEALLOCATE-SCREEN-ROW-INTERNAL (SCREEN-ROW)
  (PUSH SCREEN-ROW FREE-SCREEN-ROWS))

(DEFSUBST DEALLOCATE-SCREEN-BOX-INTERNAL (SCREEN-BOX)
  (PUSH SCREEN-BOX FREE-SCREEN-BOXS))

(DEFSUBST DEALLOCATE-GRAPHICS-SCREEN-BOX-INTERNAL (GRAPHICS-SCREEN-BOX)
  (PUSH GRAPHICS-SCREEN-BOX FREE-GRAPHICS-SCREEN-BOXS))

(DEFSUBST DEALLOCATE-SCREEN-OBJ-INTERNAL (SCREEN-OBJ)
  (COND ((GRAPHICS-SCREEN-BOX? SCREEN-OBJ)
	 (DEALLOCATE-GRAPHICS-SCREEN-BOX-INTERNAL SCREEN-OBJ))
	((SCREEN-BOX? SCREEN-OBJ) (DEALLOCATE-SCREEN-BOX-INTERNAL SCREEN-OBJ))
	((SCREEN-ROW? SCREEN-OBJ) (DEALLOCATE-SCREEN-ROW-INTERNAL SCREEN-OBJ))
	(T (BARF 'BOXER-REDSIPLAY-ERROR :FORMAT-CTL "Can't deallocate ~S"
		 :FORMAT-ARG SCREEN-OBJ))))

(DEFSUBST BOX-BORDERS-FN-TYPE-LABEL-STRING (BOX-TYPE)
  (GET BOX-TYPE ':BOX-BORDERS-FN-TYPE-LABEL-STRING))
(DEFSUBST BOX-BORDERS-FN-TYPE-LABEL-FONT-NO (BOX-TYPE)
  (GET BOX-TYPE ':BOXER-BORDERS-TYPE-LABEL-FONT-NO))
(DEFSUBST BOX-BORDERS-FN-TYPE-LABEL-INDENTATION (BOX-TYPE)
  (GET BOX-TYPE ':BOX-BORDERS-FN-TYPE-LABEL-INDENTATION))
(DEFSUBST BOX-BORDERS-FN-BORDER-WID (BOX-TYPE)
  (GET BOX-TYPE ':BOX-BORDERS-FN-BORDER-WIDTH))
(DEFSUBST BOX-BORDERS-FN-BORDER-SPA (BOX-TYPE)
  (GET BOX-TYPE ':BOX-BORDERS-FN-BORDER-SPA))
(DEFSUBST BOX-BORDERS-FN-NAME-BORDER-SPA (BOX-TYPE)
  (GET BOX-TYPE ':BOX-BORDERS-FN-NAME-BORDER-SPA))
(DEFSUBST BOX-BORDERS-FN-NAME-BORDER-WID (BOX-TYPE)
  (GET BOX-TYPE ':BOX-BORDERS-FN-NAME-BORDER-WID))
(DEFSUBST BOX-BORDERS-FN-NAME-HIGHLIGHT (BOX-TYPE)
  (GET BOX-TYPE ':BOX-BORDERS-FN-NAME-HIGHLIGHT))

(DEFSUBST BOX-BORDERS-FN-SET-TYPE-LABEL-STRING (BOX-TYPE NEW-VALUE)
  (SETF (GET BOX-TYPE ':BOX-BORDERS-FN-TYPE-LABEL-STRING) NEW-VALUE))
(DEFSUBST BOX-BORDERS-FN-SET-TYPE-LABEL-FONT-NO (BOX-TYPE NEW-VALUE)
  (SETF (GET BOX-TYPE ':BOXER-BORDERS-TYPE-LABEL-FONT-NO) NEW-VALUE))
(DEFSUBST BOX-BORDERS-FN-SET-TYPE-LABEL-INDENTATION (BOX-TYPE NEW-VALUE)
  (SETF (GET BOX-TYPE ':BOX-BORDERS-FN-TYPE-LABEL-INDENTATION) NEW-VALUE))
(DEFSUBST BOX-BORDERS-FN-SET-BORDER-WID (BOX-TYPE NEW-VALUE)
  (SETF (GET BOX-TYPE ':BOX-BORDERS-FN-BORDER-WIDTH) NEW-VALUE))
(DEFSUBST BOX-BORDERS-FN-SET-BORDER-SPA (BOX-TYPE NEW-VALUE)
  (SETF (GET BOX-TYPE ':BOX-BORDERS-FN-BORDER-SPA) NEW-VALUE))
(DEFSUBST BOX-BORDERS-FN-SET-NAME-BORDER-SPA (BOX-TYPE NEW-VALUE)
  (SETF (GET BOX-TYPE ':BOX-BORDERS-FN-NAME-BORDER-SPA) NEW-VALUE))
(DEFSUBST BOX-BORDERS-FN-SET-NAME-BORDER-WID (BOX-TYPE NEW-VALUE)
  (SETF (GET BOX-TYPE ':BOX-BORDERS-FN-NAME-BORDER-WID) NEW-VALUE))
(DEFSUBST BOX-BORDERS-FN-SET-NAME-HIGHLIGHT (BOX-TYPE NEW-VALUE)
  (SETF (GET BOX-TYPE ':BOX-BORDERS-FN-NAME-HIGHLIGHT) NEW-VALUE))

(DEFSUBST REGION-WID (REGION)
  (SYMEVAL-IN-INSTANCE REGION 'TV:WIDTH))

(DEFSUBST REGION-HEI (REGION)
  (SYMEVAL-IN-INSTANCE REGION 'TV:HEIGHT))

(DEFSUBST REGION-X (REGION)
  (TV:BLINKER-X-POS REGION))

(DEFSUBST REGION-Y (REGION)
  (TV:BLINKER-Y-POS REGION))

(DEFSUBST REGION-VISIBILITY (REGION)
  (TV:BLINKER-VISIBILITY REGION))

(DEFMACRO USING-BOX-BORDERS-BLINKER ((VAR) &BODY BODY)
  `(USING-RESOURCE (,VAR BOX-BORDERS-BLINKER)
     (UNWIND-PROTECT
       (PROGN . ,BODY)
       (TELL ,VAR :SET-VISIBILITY NIL))))

(DEFRESOURCE BOX-BORDERS-BLINKER ()
  :CONSTRUCTOR (TV:MAKE-BLINKER *BOXER-PANE* 'BOX-BORDERS-BLINKER)
  :MATCHER (PROGN OBJECT T))

(DEFSUBST DISPLAY-NAME-TAB? (SCREEN-BOX)
  (NEQ SCREEN-BOX *OUTERMOST-SCREEN-BOX*))

(DEFMACRO BOX-BORDERS-FN-BIND-CONSTANT-VALUES (&BODY BODY)
  `(LET*
     ((TYPE-LABEL-STRING  (BOX-BORDERS-FN-TYPE-LABEL-STRING BOX-TYPE))
      (TYPE-LABEL-FONT-NO (BOX-BORDERS-FN-TYPE-LABEL-FONT-NO BOX-TYPE))
      (TYPE-LABEL-INDENTATION (BOX-BORDERS-FN-TYPE-LABEL-INDENTATION BOX-TYPE))
      (BORDER-WID (BOX-BORDERS-FN-BORDER-WID BOX-TYPE))
      (BORDER-SPA (BOX-BORDERS-FN-BORDER-SPA BOX-TYPE))
      (NAME-BORDER-SPA (BOX-BORDERS-FN-NAME-BORDER-SPA BOX-TYPE))
      (NAME-BORDER-WID (BOX-BORDERS-FN-NAME-BORDER-WID BOX-TYPE))
      (NAME-HIGHLIGHT (BOX-BORDERS-FN-NAME-HIGHLIGHT BOX-TYPE))
      ;; Now we start computing various parameters.
      (TYPE-LABEL-WID (STRING-WID TYPE-LABEL-FONT-NO TYPE-LABEL-STRING))
      (TYPE-LABEL-HEI (STRING-HEI TYPE-LABEL-FONT-NO)))
     ;; Prevent bound but never use errors
     NAME-BORDER-SPA NAME-BORDER-WID NAME-HIGHLIGHT
      . ,BODY))

(DEFMACRO BOX-BORDERS-FN-BIND-INTERESTING-VALUES (&BODY BODY)
  `(BOX-BORDERS-FN-BIND-CONSTANT-VALUES
     (LET* (;; Look for a naming row and its screen representation
	    (NAME-ROW (TELL (TELL-CHECK-NIL SCREEN-BOX :ACTUAL-OBJ) :NAME-ROW))
	    (SHOW-NAME-ROW (AND NAME-ROW (DISPLAY-NAME-TAB? SCREEN-BOX))))
       . ,BODY)))

(DEFMACRO BOX-BORDERS-FN-BIND-NAMED-BOX-PARAMETERS ((OLD-NAME-P) &BODY BODY)
  `(LET*
     ((NAME-ROW-WID (STRING-WID (OR (FONT-NO (CAR (TELL NAME-ROW :CHAS)))
					     *FONT-NUMBER-FOR-NAMING*)
				(IF ,OLD-NAME-P (TELL SCREEN-BOX :NAME)
				    (TELL NAME-ROW :TEXT-STRING))))
      (NAME-ROW-HEI (STRING-HEI (OR (FONT-NO (CAR (TELL NAME-ROW :CHAS)))
					     *FONT-NUMBER-FOR-NAMING*)))
      (NAME-TAB-WID (+ NAME-ROW-WID (* 2 NAME-BORDER-WID) (* 2 NAME-BORDER-SPA)))
      (NAME-TAB-HEI (+ NAME-ROW-HEI (* 2 NAME-BORDER-WID) (* 2 NAME-BORDER-SPA)))
      (BOX-WID (- OUTER-WID (* 2 BORDER-SPA)))
      (BOX-HEI (- OUTER-HEI (* 2 BORDER-SPA) (// (MAX 0 (- TYPE-LABEL-HEI BORDER-WID)) 2)))
      (BOX-INNER-WID (- BOX-WID (* 2 BORDER-WID) NAME-TAB-WID))
      (TAB-INNER-WID (- NAME-TAB-WID (* 2 NAME-BORDER-WID)))
      ;; Now calculate the positions of things like the BOX itself...
      (BOX-LEF (+ X BORDER-SPA NAME-TAB-WID))
      (BOX-RIG (- (+ X OUTER-WID) BORDER-SPA))
      (BOX-TOP (+ Y BORDER-SPA (// (MAX 0 (- TYPE-LABEL-HEI BORDER-WID)) 2)))
      (BOX-BOT (- (+ Y OUTER-HEI) BORDER-SPA))
      ;; ...the name tag and...
      (TAB-LEF (+ X BORDER-SPA))
      (TAB-RIG (+ X BORDER-SPA NAME-TAB-WID))
      (TAB-TOP (+ Y BORDER-SPA (// (MAX 0 (- TYPE-LABEL-HEI BORDER-WID)) 2)))
      (TAB-BOT (+ TAB-TOP NAME-TAB-HEI))
      ;; ...the box's type label
      (TYPE-LABEL-LEF (+ BOX-LEF BORDER-WID TYPE-LABEL-INDENTATION))
      (TYPE-LABEL-RIG (+ TYPE-LABEL-LEF TYPE-LABEL-WID))
      (TYPE-LABEL-TOP (+ Y BORDER-SPA (// (MAX 0 (- BORDER-WID TYPE-LABEL-HEI)) 2))))
     ;; Prevent bound but never used errors
     BOX-HEI BOX-INNER-WID BOX-RIG BOX-TOP BOX-BOT
     TAB-BOT TAB-RIG TAB-LEF TAB-INNER-WID
     TYPE-LABEL-RIG TYPE-LABEL-TOP
     . ,BODY))

(DEFMACRO BOX-BORDERS-FN-BIND-UNNAMED-BOX-PARAMETERS (&BODY BODY)
  `(LET*
     ((BOX-WID (- OUTER-WID (* 2 BORDER-SPA)))
      (BOX-HEI (- OUTER-HEI (* 2 BORDER-SPA) (// (MAX 0 (- TYPE-LABEL-HEI BORDER-WID)) 2)))
      (BOX-INNER-WID (- BOX-WID (* 2 BORDER-WID)))
      (BOX-LEF (+ X BORDER-SPA))
      (BOX-RIG (- (+ X OUTER-WID) BORDER-SPA))
      (BOX-TOP (+ Y BORDER-SPA (// (MAX 0 (- TYPE-LABEL-HEI BORDER-WID)) 2)))
      (BOX-BOT (- (+ Y OUTER-HEI) BORDER-SPA))
      (TYPE-LABEL-LEF (+ BOX-LEF BORDER-WID TYPE-LABEL-INDENTATION))
      (TYPE-LABEL-RIG (+ TYPE-LABEL-LEF TYPE-LABEL-WID))
      (TYPE-LABEL-TOP (+ Y BORDER-SPA (// (MAX 0 (- BORDER-WID TYPE-LABEL-HEI)) 2))))
     ;; Prevent bound but never used errors
     BOX-HEI BOX-INNER-WID BOX-RIG BOX-TOP BOX-BOT TYPE-LABEL-RIG TYPE-LABEL-TOP
     . ,BODY))

;;; Border drawing Macros

(DEFVAR *PORT-BOX-BORDER-GAP* 3
  "The amount of whitespace in between the inner and outer box border of a port. ")

(DEFMACRO DRAW-BOX-BORDERS ()
  `(PROGN
     ;; Left, right, and bottom of the box.	
     (DRAW-RECTANGLE TV:ALU-XOR
		     BORDER-WID                            BOX-HEI
		     BOX-LEF                               BOX-TOP)
     (DRAW-RECTANGLE TV:ALU-XOR
		     BORDER-WID                            BOX-HEI
		     (- BOX-RIG BORDER-WID)                BOX-TOP)
     (DRAW-RECTANGLE TV:ALU-XOR
		     BOX-INNER-WID                         BORDER-WID
		     (+ BOX-LEF BORDER-WID)                (- BOX-BOT BORDER-WID))
     ;; Left and right part of the top line.
     (DRAW-RECTANGLE TV:ALU-XOR
		     (- TYPE-LABEL-LEF BORDER-WID BOX-LEF) BORDER-WID
		     (+ BOX-LEF BORDER-WID)                BOX-TOP)
     (DRAW-RECTANGLE TV:ALU-XOR
		     (- BOX-RIG BORDER-WID TYPE-LABEL-RIG) BORDER-WID
		     TYPE-LABEL-RIG                        BOX-TOP)
     ;; Type label string.
     (DRAW-STRING
       TV:ALU-XOR TYPE-LABEL-FONT-NO TYPE-LABEL-STRING
       TYPE-LABEL-LEF TYPE-LABEL-TOP)
     (WHEN (EQ BOX-TYPE ':PORT-BOX)
       ;; bind some useful values
       (LET ((INNER-BOX-LENGTH-DIFFERENCE (+ (* 2 *PORT-BOX-BORDER-GAP*) (* 2 BORDER-WID)))
	     (INNER-BOX-OFFSET-DIFFERENCE (+ *PORT-BOX-BORDER-GAP* BORDER-WID))
	     (TYPE-LABEL-HEI-OFFSET (// (MAX 0 (- TYPE-LABEL-HEI BORDER-WID)) 2)))
	 ;; first, we draw the inner box (left, top, right, bottom)
	 (DRAW-RECTANGLE TV:ALU-XOR
			 BORDER-WID
			 (- BOX-HEI INNER-BOX-OFFSET-DIFFERENCE BORDER-SPA
			    TYPE-LABEL-HEI-OFFSET)
			 (+ BOX-LEF INNER-BOX-OFFSET-DIFFERENCE)
			 (+ BOX-TOP TYPE-LABEL-HEI-OFFSET BORDER-SPA))
	 (DRAW-RECTANGLE TV:ALU-XOR
			 (- BOX-INNER-WID INNER-BOX-LENGTH-DIFFERENCE) BORDER-WID
			 (+ BOX-LEF INNER-BOX-OFFSET-DIFFERENCE BORDER-WID)
			 (+ BOX-TOP TYPE-LABEL-HEI-OFFSET BORDER-SPA))
	 (DRAW-RECTANGLE TV:ALU-XOR
			 BORDER-WID
			 (- BOX-HEI INNER-BOX-OFFSET-DIFFERENCE BORDER-SPA
			    TYPE-LABEL-HEI-OFFSET)
			 (- BOX-RIG BORDER-WID INNER-BOX-OFFSET-DIFFERENCE)
			 (+ BOX-TOP TYPE-LABEL-HEI-OFFSET BORDER-SPA))
	 (DRAW-RECTANGLE TV:ALU-XOR
			 (- BOX-INNER-WID INNER-BOX-LENGTH-DIFFERENCE) BORDER-WID
			 (+ BOX-LEF INNER-BOX-OFFSET-DIFFERENCE BORDER-WID)
			 (- BOX-BOT BORDER-WID INNER-BOX-OFFSET-DIFFERENCE))
	 ;; Now we draw the connecting struts (top-left, top-right, bot-left, bot-right)
	 (DRAW-LINE (+ BOX-LEF BORDER-WID) (+ BOX-TOP BORDER-WID)
		    (+ BOX-LEF INNER-BOX-OFFSET-DIFFERENCE)
		    (+ BOX-TOP TYPE-LABEL-HEI-OFFSET BORDER-SPA)
		    TV:ALU-XOR NIL)
	 (DRAW-LINE (- BOX-RIG BORDER-WID 1) (+ BOX-TOP BORDER-WID)
		    (- BOX-RIG INNER-BOX-OFFSET-DIFFERENCE)
		    (+ BOX-TOP TYPE-LABEL-HEI-OFFSET BORDER-SPA)
		    TV:ALU-XOR T)
	 (DRAW-LINE (+ BOX-LEF BORDER-WID) (- BOX-BOT BORDER-WID 1)
		    (+ BOX-LEF INNER-BOX-OFFSET-DIFFERENCE)
		    (- BOX-BOT INNER-BOX-OFFSET-DIFFERENCE 1)
		    TV:ALU-XOR NIL)
	 (DRAW-LINE (- BOX-RIG BORDER-WID 1) (- BOX-BOT BORDER-WID 1)
		    (- BOX-RIG INNER-BOX-OFFSET-DIFFERENCE)
		    (- BOX-BOT INNER-BOX-OFFSET-DIFFERENCE 1)
		    TV:ALU-XOR T)))))

(DEFMACRO DRAW-SCREEN-ROW-FOR-NAMING ()
  ;; We can't just use :REDISPLAY-PASS-2 for screen-rows here because this function has to
  ;; have the property that it will erase itself if drawn twice
  `(LET* ((STRING-TO-DRAW (IF OLD-P
				(TELL SCREEN-BOX :NAME)
				(TELL NAME-ROW :TEXT-STRING)))
	    (EMPTY-P (TELL NAME-ROW :CHAS))
	    (STRING-FONT (IF (NULL EMPTY-P) *FONT-NUMBER-FOR-NAMING*
			     (FONT-NO (CAR (TELL NAME-ROW :CHAS))))))
       (IF OLD-P
	   (DRAW-STRING TV:ALU-XOR STRING-FONT STRING-TO-DRAW
			(+ TAB-LEF NAME-BORDER-WID NAME-BORDER-SPA)
			(+ TAB-TOP NAME-BORDER-WID NAME-BORDER-SPA))
	   (WHEN EMPTY-P
	     (DRAW-STRING TV:ALU-XOR STRING-FONT STRING-TO-DRAW
			  (+ TAB-LEF NAME-BORDER-WID NAME-BORDER-SPA)
			  (+ TAB-TOP NAME-BORDER-WID NAME-BORDER-SPA))))))

(DEFMACRO DRAW-NAME-BORDERS ()
  `(PROGN
     ;; The name row's borders (left, top, right, and bottom)
     (DRAW-RECTANGLE TV:ALU-XOR
		     NAME-BORDER-WID             NAME-TAB-HEI
		     TAB-LEF                     TAB-TOP)
     (DRAW-RECTANGLE TV:ALU-XOR
		     TAB-INNER-WID               NAME-BORDER-WID
		     (+ TAB-LEF NAME-BORDER-WID) TAB-TOP)
     (DRAW-RECTANGLE TV:ALU-XOR
		     NAME-BORDER-WID             NAME-TAB-HEI
		     (- TAB-RIG NAME-BORDER-WID) TAB-TOP)
     (DRAW-RECTANGLE TV:ALU-XOR
		     TAB-INNER-WID               NAME-BORDER-WID
		     (+ TAB-LEF NAME-BORDER-WID) (- TAB-BOT NAME-BORDER-WID))
     ;; now xor the entire name string for white on black
     (when name-highlight
       (draw-rectangle tv:alu-xor name-row-wid name-row-hei
		       (+ TAB-LEF NAME-BORDER-WID NAME-BORDER-SPA)
		       (+ TAB-TOP NAME-BORDER-WID NAME-BORDER-SPA)))))

;;;; Stuff for circular structures in the redisplay
(DEFVAR PORT-REDISPLAY-HISTORY NIL)

(DEFVAR *PORT-REDISPLAY-DEPTH* 3)

(DEFVAR *BOX-ELLIPSIS-WID* 40.)
(DEFVAR *BOX-ELLIPSIS-HEI* 40.)
;;; Maybe these should be related to BOX-BORDER-PARAMETERS or something...
(DEFVAR *BOX-ELLIPSIS-THICKNESS* 1.)
(DEFVAR *BOX-ELLIPSIS-SPACING*   2.)

;;; The various types of Ellipsi (Ellipses (?)) are stored as symbols in the screen-row
;;; slots of the screen-box.  The drawing function is the DRAW-SELF property of the symbol
(DEFVAR *DEFINED-BOX-ELLIPSIS-STYLES* NIL)

(DEFUN BOX-ELLIPSIS-STYLE? (THING)
  (AND (SYMBOLP THING) (MEMQ THING *DEFINED-BOX-ELLIPSIS-STYLES*)))

(DEFMACRO DEFINE-BOX-ELLIPSIS-STYLE (NAME)
  `(PROGN 'COMPILE
	  (PUSH ',NAME *DEFINED-BOX-ELLIPSIS-STYLES*)
	  ;; default erase adn size properties
	  ;; we can overide this with some other definition later
	  (DEFUN (:PROPERTY ,NAME ERASE-SELF) (X-COORD Y-COORD)
	    (DRAW-RECTANGLE TV:ALU-ANDCA *BOX-ELLIPSIS-WID* *BOX-ELLIPSIS-HEI*
			    X-COORD Y-COORD))
	  (DEFUN (:PROPERTY ,NAME SIZE) ()
	    (VALUES *BOX-ELLIPSIS-WID* *BOX-ELLIPSIS-HEI*))))

(DEFVAR *BOX-ELLIPSIS-CURRENT-STYLE* 'BOX-ELLIPSIS-SOLID-LINES)

(DEFMACRO ALTERING-REGION ((REGION) &BODY BODY)
  `(WITHOUT-INTERRUPTS
     (TV:OPEN-BLINKER ,REGION)
     (PROGN . ,BODY)))

;;;****************************************************************;;;
;;;                      REDISPLAY MACROS                          ;;;
;;;****************************************************************;;;

(DEFMACRO QUEUEING-SCREEN-OBJS-DEALLOCATION (&BODY BODY)
  `(LET ((SCREEN-OBJS-DEALLOCATION-QUEUE NIL))
     (DECLARE (SPECIAL SCREEN-OBJS-DEALLOCATION-QUEUE))
     (UNWIND-PROTECT
	 (PROGN . ,BODY)
       (DOLIST (QUEUED-SCREEN-OBJ SCREEN-OBJS-DEALLOCATION-QUEUE)
	 (TELL QUEUED-SCREEN-OBJ :DEALLOCATE-SELF)))))

(DEFMACRO PORT-REDISPLAYING-HISTORY ((ACTUAL-BOX) &BODY BODY)
  `(LET-IF (PORT-BOX? ,ACTUAL-BOX)
	   ((PORT-REDISPLAY-HISTORY (UPDATE-PORT-REDISPLAY-HISTORY ,ACTUAL-BOX)))
     . ,BODY))

(DEFMACRO REDISPLAYING-WINDOW ((WINDOW) &BODY BODY)
  `(LET* ((*REDISPLAY-WINDOW* ,WINDOW)
	  (*OUTERMOST-SCREEN-BOX* (TELL ,WINDOW :OUTERMOST-SCREEN-BOX))
	  (.OUTERMOST-SCREEN-BOX. *OUTERMOST-SCREEN-BOX*))
     (QUEUEING-SCREEN-OBJS-DEALLOCATION 
       (DRAWING-ON-WINDOW (,WINDOW)
	 (UNWIND-PROTECT
	   (PROGN . ,BODY)
	   ;; Check to see if *outermost-screen-box* got changed during
	   ;; the redisplay. If it did, then tell the window about it.
	   (WHEN (NEQ *OUTERMOST-SCREEN-BOX* .OUTERMOST-SCREEN-BOX.)
		 (TELL ,WINDOW :SET-OUTERMOST-SCREEN-BOX *OUTERMOST-SCREEN-BOX*)))))))

(DEFMACRO REDISPLAYING-BOX (SCREEN-BOX &BODY BODY)
  ;;this macro sets up the scaling for the redisplay of a particular box without having to
  ;;redisplay the entire screen.  This means that the box to be redisplayed has to be a fixed
  ;;sized box to avoid worrying about propagating changes in size to the superiors of the box.
  `(QUEUEING-SCREEN-OBJS-DEALLOCATION
     (DRAWING-ON-WINDOW (*BOXER-PANE*)
       (MULTIPLE-VALUE-BIND (SUPERIOR-ORIGIN-X-OFFSET SUPERIOR-ORIGIN-Y-OFFSET)
	   (TELL (TELL ,SCREEN-BOX :SUPERIOR) :POSITION)
	 (LET ((%ORIGIN-X-OFFSET (SCALE-X SUPERIOR-ORIGIN-X-OFFSET))
	       (%ORIGIN-Y-OFFSET (SCALE-Y SUPERIOR-ORIGIN-Y-OFFSET)))
	   (PROGN . ,BODY))))))

;;; Graphics defs and macros

(DEFVAR *DEFAULT-GRAPHICS-SHEET-WIDTH* 320.)

(DEFVAR *DEFAULT-GRAPHICS-SHEET-HEIGHT* 200.)

(DEFVAR *MAKE-TURTLE-WITH-NEW-GRAPHICS-BOX* NIL
  "Determines if graphics boxes are created with a turtle already in it. ")

(DEFSTRUCT (GRAPHICS-SCREEN-SHEET (:TYPE :NAMED-ARRAY)
				  :CONC-NAME
				  (:CONSTRUCTOR %MAKE-G-SCREEN-SHEET
				   (ACTUAL-OBJ X-OFFSET Y-OFFSET))
				  (:PRINT "#<GRAPH-SCR-ST X-~D. Y-~D.>"
				   (GRAPHICS-SCREEN-SHEET-X-OFFSET GRAPHICS-SCREEN-SHEET)
				   (GRAPHICS-SCREEN-SHEET-Y-OFFSET GRAPHICS-SCREEN-SHEET)))
  (X-OFFSET 0.)
  (Y-OFFSET 0.)
  (SCREEN-BOX NIL)
  (ACTUAL-OBJ NIL)
  )

(DEFTYPE-CHECKING-MACROS GRAPHICS-SCREEN-SHEET "A screen object for a Graphics Sheet")


(DEFMACRO DRAWING-ON-TURTLE-SLATE (SCREEN-BOX &BODY BODY)
  ;; this macro sets up the scaling for turtle graphics in absolute SCREEN coordinates
  `(DRAWING-ON-WINDOW (*BOXER-PANE*)
     (MULTIPLE-VALUE-BIND (BOX-X-OFFSET BOX-Y-OFFSET)
	 (TELL ,SCREEN-BOX :POSITION)
       (MULTIPLE-VALUE-BIND (INNER-WID INNER-HEI)
	   (TELL (TELL ,SCREEN-BOX :ACTUAL-OBJ) :GRAPHICS-SHEET-SIZE)
	 (MULTIPLE-VALUE-BIND (SHEET-X SHEET-Y)
	     (GRAPHICS-SCREEN-SHEET-OFFSETS (TELL ,SCREEN-BOX :SCREEN-SHEET))
	   (LET ((%ORIGIN-X-OFFSET (SCALE-X (+ BOX-X-OFFSET SHEET-X)))
		 ;; the x-coord of the upper-left corner of the turtle-array
		 (%ORIGIN-Y-OFFSET (SCALE-Y (+ BOX-Y-OFFSET SHEET-Y))))
	     ;; the y-coord of the upper-left corner of the turtle-array
	     (WITH-CLIPPING-INSIDE (0 0 (MIN INNER-WID (SCREEN-OBJ-WID ,SCREEN-BOX))
				      (MIN INNER-HEI (SCREEN-OBJ-HEI ,SCREEN-BOX)))
	       (PROGN . ,BODY))))))))
